// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
if(cljs.core.truth_((function (){var and__6198__auto__ = cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1);
if(cljs.core.truth_(and__6198__auto__)){
return stateful_method_QMARK_;
} else {
return and__6198__auto__;
}
})())){
return http_options__$1;
} else {
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var options_PLUS_xhr = cljs.core.assoc_in(http_options__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$xhr], null),true);
if(cljs.core.truth_((function (){var and__6198__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__6198__auto__)){
return cljs.core.not(stateful_method_QMARK_);
} else {
return and__6198__auto__;
}
})())){
return cljs.core.assoc_in(options_PLUS_xhr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__20892 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__20892) : cljs_hash.md5.md5.call(null,G__20892));
})());
} else {
return options_PLUS_xhr;
}
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__7287__auto__ = [];
var len__7280__auto___20897 = arguments.length;
var i__7281__auto___20898 = (0);
while(true){
if((i__7281__auto___20898 < len__7280__auto___20897)){
args__7287__auto__.push((arguments[i__7281__auto___20898]));

var G__20899 = (i__7281__auto___20898 + (1));
i__7281__auto___20898 = G__20899;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__20894){
var map__20895 = p__20894;
var map__20895__$1 = ((((!((map__20895 == null)))?((((map__20895.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20895.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20895):map__20895);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20895__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20895__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20895__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20895__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("Token "),cljs.core.str(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__6198__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__6198__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__6198__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4657__auto__ = (function (){var and__6198__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__6198__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__6198__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var crsf_token = temp__4657__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__6210__auto__ = accept_header;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq20893){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq20893));
});
/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__7287__auto__ = [];
var len__7280__auto___20907 = arguments.length;
var i__7281__auto___20908 = (0);
while(true){
if((i__7281__auto___20908 < len__7280__auto___20907)){
args__7287__auto__.push((arguments[i__7281__auto___20908]));

var G__20909 = (i__7281__auto___20908 + (1));
i__7281__auto___20908 = G__20909;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__20902){
var vec__20903 = p__20902;
var map__20904 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20903,(0),null);
var map__20904__$1 = ((((!((map__20904 == null)))?((((map__20904.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20904.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20904):map__20904);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20904__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e20906){if((e20906 instanceof Error)){
var _ = e20906;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e20906;

}
}} else {
return io_obj.getResponseText();
}
});

milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1);

milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq20900){
var G__20901 = cljs.core.first(seq20900);
var seq20900__$1 = cljs.core.next(seq20900);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(G__20901,seq20900__$1);
});
milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
var G__20916_20922 = io_obj;
var G__20917_20923 = goog.net.EventType.SUCCESS;
var G__20918_20924 = ((function (G__20916_20922,G__20917_20923,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__20916_20922,G__20917_20923,io_obj))
;
goog.events.listen(G__20916_20922,G__20917_20923,G__20918_20924);

var G__20919_20925 = io_obj;
var G__20920_20926 = goog.net.EventType.ERROR;
var G__20921_20927 = ((function (G__20919_20925,G__20920_20926,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__20919_20925,G__20920_20926,io_obj))
;
goog.events.listen(G__20919_20925,G__20920_20926,G__20921_20927);

return io_obj.sendFromForm(form,[cljs.core.str(form_api),cljs.core.str("?legacy=true")].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://goo.gl/B0fm2a
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__7287__auto__ = [];
var len__7280__auto___20944 = arguments.length;
var i__7281__auto___20945 = (0);
while(true){
if((i__7281__auto___20945 < len__7280__auto___20944)){
args__7287__auto__.push((arguments[i__7281__auto___20945]));

var G__20946 = (i__7281__auto___20945 + (1));
i__7281__auto___20945 = G__20946;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((2) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7288__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__20932){
var map__20933 = p__20932;
var map__20933__$1 = ((((!((map__20933 == null)))?((((map__20933.cljs$lang$protocol_mask$partition0$ & (64))) || (map__20933.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20933):map__20933);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20933__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20933__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20933__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

var G__20935_20947 = io_obj;
var G__20936_20948 = goog.net.EventType.SUCCESS;
var G__20937_20949 = ((function (G__20935_20947,G__20936_20948,io_obj,data,url,map__20933,map__20933__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,true], 0)));
});})(G__20935_20947,G__20936_20948,io_obj,data,url,map__20933,map__20933__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__20935_20947,G__20936_20948,G__20937_20949);

var G__20938_20950 = io_obj;
var G__20939_20951 = goog.net.EventType.ERROR;
var G__20940_20952 = ((function (G__20938_20950,G__20939_20951,io_obj,data,url,map__20933,map__20933__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,false], 0)));
});})(G__20938_20950,G__20939_20951,io_obj,data,url,map__20933,map__20933__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__20938_20950,G__20939_20951,G__20940_20952);

var G__20941_20953 = io_obj;
var G__20942_20954 = goog.net.EventType.PROGRESS;
var G__20943_20955 = ((function (G__20941_20953,G__20942_20954,io_obj,data,url,map__20933,map__20933__$1,headers,id,require_json_QMARK_){
return (function (p1__20928_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__20928_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__20928_SHARP_.loaded,cljs.core.cst$kw$total,p1__20928_SHARP_.total], null)));
});})(G__20941_20953,G__20942_20954,io_obj,data,url,map__20933,map__20933__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__20941_20953,G__20942_20954,G__20943_20955);

io_obj.send(url,"POST",form,headers);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq20929){
var G__20930 = cljs.core.first(seq20929);
var seq20929__$1 = cljs.core.next(seq20929);
var G__20931 = cljs.core.first(seq20929__$1);
var seq20929__$2 = cljs.core.next(seq20929__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__20930,G__20931,seq20929__$2);
});
/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21018 = arguments.length;
var i__7281__auto___21019 = (0);
while(true){
if((i__7281__auto___21019 < len__7280__auto___21018)){
args__7287__auto__.push((arguments[i__7281__auto___21019]));

var G__21020 = (i__7281__auto___21019 + (1));
i__7281__auto___21019 = G__21020;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__17645__auto___21021 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17645__auto___21021,response_channel){
return (function (){
var f__17646__auto__ = (function (){var switch__17531__auto__ = ((function (c__17645__auto___21021,response_channel){
return (function (state_20991){
var state_val_20992 = (state_20991[(1)]);
if((state_val_20992 === (7))){
var state_20991__$1 = state_20991;
var statearr_20993_21022 = state_20991__$1;
(statearr_20993_21022[(2)] = false);

(statearr_20993_21022[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20992 === (1))){
var inst_20959 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_20991__$1 = state_20991;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20991__$1,(2),inst_20959);
} else {
if((state_val_20992 === (4))){
var state_20991__$1 = state_20991;
var statearr_20994_21023 = state_20991__$1;
(statearr_20994_21023[(2)] = false);

(statearr_20994_21023[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20992 === (13))){
var inst_20981 = (state_20991[(7)]);
var inst_20987 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_20981);
var state_20991__$1 = state_20991;
var statearr_20995_21024 = state_20991__$1;
(statearr_20995_21024[(2)] = inst_20987);

(statearr_20995_21024[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20992 === (6))){
var state_20991__$1 = state_20991;
var statearr_20996_21025 = state_20991__$1;
(statearr_20996_21025[(2)] = true);

(statearr_20996_21025[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20992 === (3))){
var inst_20961 = (state_20991[(8)]);
var inst_20966 = inst_20961.cljs$lang$protocol_mask$partition0$;
var inst_20967 = (inst_20966 & (64));
var inst_20968 = inst_20961.cljs$core$ISeq$;
var inst_20969 = (inst_20967) || (inst_20968);
var state_20991__$1 = state_20991;
if(cljs.core.truth_(inst_20969)){
var statearr_20997_21026 = state_20991__$1;
(statearr_20997_21026[(1)] = (6));

} else {
var statearr_20998_21027 = state_20991__$1;
(statearr_20998_21027[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20992 === (12))){
var inst_20985 = window.location = window.location;
var state_20991__$1 = state_20991;
var statearr_20999_21028 = state_20991__$1;
(statearr_20999_21028[(2)] = inst_20985);

(statearr_20999_21028[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20992 === (2))){
var inst_20961 = (state_20991[(8)]);
var inst_20961__$1 = (state_20991[(2)]);
var inst_20963 = (inst_20961__$1 == null);
var inst_20964 = cljs.core.not(inst_20963);
var state_20991__$1 = (function (){var statearr_21000 = state_20991;
(statearr_21000[(8)] = inst_20961__$1);

return statearr_21000;
})();
if(inst_20964){
var statearr_21001_21029 = state_20991__$1;
(statearr_21001_21029[(1)] = (3));

} else {
var statearr_21002_21030 = state_20991__$1;
(statearr_21002_21030[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20992 === (11))){
var inst_20981 = (state_20991[(7)]);
var inst_20981__$1 = (state_20991[(2)]);
var inst_20982 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20981__$1,cljs.core.cst$kw$status);
var inst_20983 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_20982,(401));
var state_20991__$1 = (function (){var statearr_21003 = state_20991;
(statearr_21003[(7)] = inst_20981__$1);

return statearr_21003;
})();
if(inst_20983){
var statearr_21004_21031 = state_20991__$1;
(statearr_21004_21031[(1)] = (12));

} else {
var statearr_21005_21032 = state_20991__$1;
(statearr_21005_21032[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20992 === (9))){
var inst_20961 = (state_20991[(8)]);
var inst_20978 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20961);
var state_20991__$1 = state_20991;
var statearr_21006_21033 = state_20991__$1;
(statearr_21006_21033[(2)] = inst_20978);

(statearr_21006_21033[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20992 === (5))){
var inst_20976 = (state_20991[(2)]);
var state_20991__$1 = state_20991;
if(cljs.core.truth_(inst_20976)){
var statearr_21007_21034 = state_20991__$1;
(statearr_21007_21034[(1)] = (9));

} else {
var statearr_21008_21035 = state_20991__$1;
(statearr_21008_21035[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20992 === (14))){
var inst_20989 = (state_20991[(2)]);
var state_20991__$1 = state_20991;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20991__$1,inst_20989);
} else {
if((state_val_20992 === (10))){
var inst_20961 = (state_20991[(8)]);
var state_20991__$1 = state_20991;
var statearr_21009_21036 = state_20991__$1;
(statearr_21009_21036[(2)] = inst_20961);

(statearr_21009_21036[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20992 === (8))){
var inst_20973 = (state_20991[(2)]);
var state_20991__$1 = state_20991;
var statearr_21010_21037 = state_20991__$1;
(statearr_21010_21037[(2)] = inst_20973);

(statearr_21010_21037[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17645__auto___21021,response_channel))
;
return ((function (switch__17531__auto__,c__17645__auto___21021,response_channel){
return (function() {
var milia$api$io$state_machine__17532__auto__ = null;
var milia$api$io$state_machine__17532__auto____0 = (function (){
var statearr_21014 = [null,null,null,null,null,null,null,null,null];
(statearr_21014[(0)] = milia$api$io$state_machine__17532__auto__);

(statearr_21014[(1)] = (1));

return statearr_21014;
});
var milia$api$io$state_machine__17532__auto____1 = (function (state_20991){
while(true){
var ret_value__17533__auto__ = (function (){try{while(true){
var result__17534__auto__ = switch__17531__auto__(state_20991);
if(cljs.core.keyword_identical_QMARK_(result__17534__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17534__auto__;
}
break;
}
}catch (e21015){if((e21015 instanceof Object)){
var ex__17535__auto__ = e21015;
var statearr_21016_21038 = state_20991;
(statearr_21016_21038[(5)] = ex__17535__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20991);

return cljs.core.cst$kw$recur;
} else {
throw e21015;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17533__auto__,cljs.core.cst$kw$recur)){
var G__21039 = state_20991;
state_20991 = G__21039;
continue;
} else {
return ret_value__17533__auto__;
}
break;
}
});
milia$api$io$state_machine__17532__auto__ = function(state_20991){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__17532__auto____0.call(this);
case 1:
return milia$api$io$state_machine__17532__auto____1.call(this,state_20991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__17532__auto____0;
milia$api$io$state_machine__17532__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__17532__auto____1;
return milia$api$io$state_machine__17532__auto__;
})()
;})(switch__17531__auto__,c__17645__auto___21021,response_channel))
})();
var state__17647__auto__ = (function (){var statearr_21017 = (f__17646__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17646__auto__.cljs$core$IFn$_invoke$arity$0() : f__17646__auto__.call(null));
(statearr_21017[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__17645__auto___21021);

return statearr_21017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17647__auto__);
});})(c__17645__auto___21021,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq20956){
var G__20957 = cljs.core.first(seq20956);
var seq20956__$1 = cljs.core.next(seq20956);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__20957,seq20956__$1);
});
