// Compiled by ClojureScript 0.0-3196 {:optimize-constants true, :static-fns true}
goog.provide('dommy.template');
goog.require('cljs.core');
goog.require('dommy.attrs');
goog.require('clojure.string');
dommy.template._PLUS_svg_ns_PLUS_ = "http://www.w3.org/2000/svg";
dommy.template._PLUS_svg_tags_PLUS_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["svg",null,"line",null], null), null);

dommy.template.PElement = (function (){var obj43328 = {};
return obj43328;
})();

/**
 * return the element representation of this
 */
dommy.template._elem = (function dommy$template$_elem(this$){
if((function (){var and__4264__auto__ = this$;
if(and__4264__auto__){
return this$.dommy$template$PElement$_elem$arity$1;
} else {
return and__4264__auto__;
}
})()){
return this$.dommy$template$PElement$_elem$arity$1(this$);
} else {
var x__4912__auto__ = (((this$ == null))?null:this$);
return (function (){var or__4276__auto__ = (dommy.template._elem[(function (){var G__43332 = x__4912__auto__;
return goog.typeOf(G__43332);
})()]);
if(or__4276__auto__){
return or__4276__auto__;
} else {
var or__4276__auto____$1 = (dommy.template._elem["_"]);
if(or__4276__auto____$1){
return or__4276__auto____$1;
} else {
throw cljs.core.missing_protocol("PElement.-elem",this$);
}
}
})().call(null,this$);
}
});

/**
 * index of css character (#,.) in base-element. bottleneck
 */
dommy.template.next_css_index = (function dommy$template$next_css_index(s,start_idx){
var id_idx = s.indexOf("#",start_idx);
var class_idx = s.indexOf(".",start_idx);
var idx = Math.min(id_idx,class_idx);
if((idx < (0))){
return Math.max(id_idx,class_idx);
} else {
return idx;
}
});
/**
 * dom element from css-style keyword like :a.class1 or :span#my-span.class
 */
dommy.template.base_element = (function dommy$template$base_element(node_key){
var node_str = cljs.core.name(node_key);
var base_idx = dommy.template.next_css_index(node_str,(0));
var tag = (((base_idx > (0)))?node_str.substring((0),base_idx):(((base_idx === (0)))?"div":node_str
));
var node = (cljs.core.truth_((function (){var G__43335 = tag;
return (dommy.template._PLUS_svg_tags_PLUS_.cljs$core$IFn$_invoke$arity$1 ? dommy.template._PLUS_svg_tags_PLUS_.cljs$core$IFn$_invoke$arity$1(G__43335) : dommy.template._PLUS_svg_tags_PLUS_.call(null,G__43335));
})())?document.createElementNS(dommy.template._PLUS_svg_ns_PLUS_,tag):document.createElement(tag));
if((base_idx >= (0))){
var str_43337 = node_str.substring(base_idx);
while(true){
var next_idx_43338 = dommy.template.next_css_index(str_43337,(1));
var frag_43339 = (((next_idx_43338 >= (0)))?str_43337.substring((0),next_idx_43338):str_43337);
var G__43336_43340 = frag_43339.charAt((0));
switch (G__43336_43340) {
case ".":
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(node,frag_43339.substring((1)));

break;
case "#":
node.setAttribute("id",frag_43339.substring((1)));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(frag_43339.charAt((0)))].join('')));

}

if((next_idx_43338 >= (0))){
var G__43342 = str_43337.substring(next_idx_43338);
str_43337 = G__43342;
continue;
} else {
}
break;
}
} else {
}

return node;
});
dommy.template.throw_unable_to_make_node = (function dommy$template$throw_unable_to_make_node(node_data){
throw [cljs.core.str("Don't know how to make node from: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([node_data], 0)))].join('');
});
/**
 * take data and return a document fragment
 */
dommy.template.__GT_document_fragment = (function dommy$template$__GT_document_fragment(){
var G__43344 = arguments.length;
switch (G__43344) {
case 1:
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(arguments.length)].join('')));

}
});

dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$1 = (function (data){
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2(document.createDocumentFragment(),data);
});

dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2 = (function (result_frag,data){
if((function (){var G__43345 = data;
if(G__43345){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__43345.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__43345.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__43345);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__43345);
}
})()){
result_frag.appendChild(dommy.template._elem(data));

return result_frag;
} else {
if(cljs.core.seq_QMARK_(data)){
var seq__43346_43351 = cljs.core.seq(data);
var chunk__43347_43352 = null;
var count__43348_43353 = (0);
var i__43349_43354 = (0);
while(true){
if((i__43349_43354 < count__43348_43353)){
var child_43355 = chunk__43347_43352.cljs$core$IIndexed$_nth$arity$2(null,i__43349_43354);
dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2(result_frag,child_43355);

var G__43356 = seq__43346_43351;
var G__43357 = chunk__43347_43352;
var G__43358 = count__43348_43353;
var G__43359 = (i__43349_43354 + (1));
seq__43346_43351 = G__43356;
chunk__43347_43352 = G__43357;
count__43348_43353 = G__43358;
i__43349_43354 = G__43359;
continue;
} else {
var temp__4126__auto___43360 = cljs.core.seq(seq__43346_43351);
if(temp__4126__auto___43360){
var seq__43346_43361__$1 = temp__4126__auto___43360;
if(cljs.core.chunked_seq_QMARK_(seq__43346_43361__$1)){
var c__5061__auto___43362 = cljs.core.chunk_first(seq__43346_43361__$1);
var G__43363 = cljs.core.chunk_rest(seq__43346_43361__$1);
var G__43364 = c__5061__auto___43362;
var G__43365 = cljs.core.count(c__5061__auto___43362);
var G__43366 = (0);
seq__43346_43351 = G__43363;
chunk__43347_43352 = G__43364;
count__43348_43353 = G__43365;
i__43349_43354 = G__43366;
continue;
} else {
var child_43367 = cljs.core.first(seq__43346_43361__$1);
dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$2(result_frag,child_43367);

var G__43368 = cljs.core.next(seq__43346_43361__$1);
var G__43369 = null;
var G__43370 = (0);
var G__43371 = (0);
seq__43346_43351 = G__43368;
chunk__43347_43352 = G__43369;
count__43348_43353 = G__43370;
i__43349_43354 = G__43371;
continue;
}
} else {
}
}
break;
}

return result_frag;
} else {
if((data == null)){
return result_frag;
} else {
return dommy.template.throw_unable_to_make_node(data);

}
}
}
});

dommy.template.__GT_document_fragment.cljs$lang$maxFixedArity = 2;
/**
 * take data and return DOM node if it satisfies PElement and tries to
 * make a document fragment otherwise
 */
dommy.template.__GT_node_like = (function dommy$template$__GT_node_like(data){
if((function (){var G__43373 = data;
if(G__43373){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__43373.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__43373.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__43373);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__43373);
}
})()){
return dommy.template._elem(data);
} else {
return dommy.template.__GT_document_fragment.cljs$core$IFn$_invoke$arity$1(data);
}
});
/**
 * element with either attrs or nested children [:div [:span "Hello"]]
 */
dommy.template.compound_element = (function dommy$template$compound_element(p__43374){
var vec__43394 = p__43374;
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43394,(0),null);
var maybe_attrs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43394,(1),null);
var children = cljs.core.nthnext(vec__43394,(2));
var n = dommy.template.base_element(tag_name);
var attrs = (((cljs.core.map_QMARK_(maybe_attrs)) && (!((function (){var G__43396 = maybe_attrs;
if(G__43396){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__43396.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__43396.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__43396);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__43396);
}
})())))?maybe_attrs:null);
var children__$1 = (cljs.core.truth_(attrs)?children:cljs.core.cons(maybe_attrs,children));
var seq__43397_43413 = cljs.core.seq(attrs);
var chunk__43398_43414 = null;
var count__43399_43415 = (0);
var i__43400_43416 = (0);
while(true){
if((i__43400_43416 < count__43399_43415)){
var vec__43401_43417 = chunk__43398_43414.cljs$core$IIndexed$_nth$arity$2(null,i__43400_43416);
var k_43418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43401_43417,(0),null);
var v_43419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43401_43417,(1),null);
var G__43402_43420 = (((k_43418 instanceof cljs.core.Keyword))?k_43418.fqn:null);
switch (G__43402_43420) {
case "classes":
var seq__43403_43422 = cljs.core.seq(v_43419);
var chunk__43404_43423 = null;
var count__43405_43424 = (0);
var i__43406_43425 = (0);
while(true){
if((i__43406_43425 < count__43405_43424)){
var c_43426 = chunk__43404_43423.cljs$core$IIndexed$_nth$arity$2(null,i__43406_43425);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_43426);

var G__43427 = seq__43403_43422;
var G__43428 = chunk__43404_43423;
var G__43429 = count__43405_43424;
var G__43430 = (i__43406_43425 + (1));
seq__43403_43422 = G__43427;
chunk__43404_43423 = G__43428;
count__43405_43424 = G__43429;
i__43406_43425 = G__43430;
continue;
} else {
var temp__4126__auto___43431 = cljs.core.seq(seq__43403_43422);
if(temp__4126__auto___43431){
var seq__43403_43432__$1 = temp__4126__auto___43431;
if(cljs.core.chunked_seq_QMARK_(seq__43403_43432__$1)){
var c__5061__auto___43433 = cljs.core.chunk_first(seq__43403_43432__$1);
var G__43434 = cljs.core.chunk_rest(seq__43403_43432__$1);
var G__43435 = c__5061__auto___43433;
var G__43436 = cljs.core.count(c__5061__auto___43433);
var G__43437 = (0);
seq__43403_43422 = G__43434;
chunk__43404_43423 = G__43435;
count__43405_43424 = G__43436;
i__43406_43425 = G__43437;
continue;
} else {
var c_43438 = cljs.core.first(seq__43403_43432__$1);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_43438);

var G__43439 = cljs.core.next(seq__43403_43432__$1);
var G__43440 = null;
var G__43441 = (0);
var G__43442 = (0);
seq__43403_43422 = G__43439;
chunk__43404_43423 = G__43440;
count__43405_43424 = G__43441;
i__43406_43425 = G__43442;
continue;
}
} else {
}
}
break;
}

break;
case "class":
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,v_43419);

break;
default:
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(n,k_43418,v_43419);

}

var G__43443 = seq__43397_43413;
var G__43444 = chunk__43398_43414;
var G__43445 = count__43399_43415;
var G__43446 = (i__43400_43416 + (1));
seq__43397_43413 = G__43443;
chunk__43398_43414 = G__43444;
count__43399_43415 = G__43445;
i__43400_43416 = G__43446;
continue;
} else {
var temp__4126__auto___43447 = cljs.core.seq(seq__43397_43413);
if(temp__4126__auto___43447){
var seq__43397_43448__$1 = temp__4126__auto___43447;
if(cljs.core.chunked_seq_QMARK_(seq__43397_43448__$1)){
var c__5061__auto___43449 = cljs.core.chunk_first(seq__43397_43448__$1);
var G__43450 = cljs.core.chunk_rest(seq__43397_43448__$1);
var G__43451 = c__5061__auto___43449;
var G__43452 = cljs.core.count(c__5061__auto___43449);
var G__43453 = (0);
seq__43397_43413 = G__43450;
chunk__43398_43414 = G__43451;
count__43399_43415 = G__43452;
i__43400_43416 = G__43453;
continue;
} else {
var vec__43407_43454 = cljs.core.first(seq__43397_43448__$1);
var k_43455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43407_43454,(0),null);
var v_43456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43407_43454,(1),null);
var G__43408_43457 = (((k_43455 instanceof cljs.core.Keyword))?k_43455.fqn:null);
switch (G__43408_43457) {
case "classes":
var seq__43409_43459 = cljs.core.seq(v_43456);
var chunk__43410_43460 = null;
var count__43411_43461 = (0);
var i__43412_43462 = (0);
while(true){
if((i__43412_43462 < count__43411_43461)){
var c_43463 = chunk__43410_43460.cljs$core$IIndexed$_nth$arity$2(null,i__43412_43462);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_43463);

var G__43464 = seq__43409_43459;
var G__43465 = chunk__43410_43460;
var G__43466 = count__43411_43461;
var G__43467 = (i__43412_43462 + (1));
seq__43409_43459 = G__43464;
chunk__43410_43460 = G__43465;
count__43411_43461 = G__43466;
i__43412_43462 = G__43467;
continue;
} else {
var temp__4126__auto___43468__$1 = cljs.core.seq(seq__43409_43459);
if(temp__4126__auto___43468__$1){
var seq__43409_43469__$1 = temp__4126__auto___43468__$1;
if(cljs.core.chunked_seq_QMARK_(seq__43409_43469__$1)){
var c__5061__auto___43470 = cljs.core.chunk_first(seq__43409_43469__$1);
var G__43471 = cljs.core.chunk_rest(seq__43409_43469__$1);
var G__43472 = c__5061__auto___43470;
var G__43473 = cljs.core.count(c__5061__auto___43470);
var G__43474 = (0);
seq__43409_43459 = G__43471;
chunk__43410_43460 = G__43472;
count__43411_43461 = G__43473;
i__43412_43462 = G__43474;
continue;
} else {
var c_43475 = cljs.core.first(seq__43409_43469__$1);
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,c_43475);

var G__43476 = cljs.core.next(seq__43409_43469__$1);
var G__43477 = null;
var G__43478 = (0);
var G__43479 = (0);
seq__43409_43459 = G__43476;
chunk__43410_43460 = G__43477;
count__43411_43461 = G__43478;
i__43412_43462 = G__43479;
continue;
}
} else {
}
}
break;
}

break;
case "class":
dommy.attrs.add_class_BANG_.cljs$core$IFn$_invoke$arity$2(n,v_43456);

break;
default:
dommy.attrs.set_attr_BANG_.cljs$core$IFn$_invoke$arity$3(n,k_43455,v_43456);

}

var G__43480 = cljs.core.next(seq__43397_43448__$1);
var G__43481 = null;
var G__43482 = (0);
var G__43483 = (0);
seq__43397_43413 = G__43480;
chunk__43398_43414 = G__43481;
count__43399_43415 = G__43482;
i__43400_43416 = G__43483;
continue;
}
} else {
}
}
break;
}

n.appendChild(dommy.template.__GT_node_like(children__$1));

return n;
});
(dommy.template.PElement["string"] = true);

(dommy.template._elem["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return dommy.template.base_element(this$);
} else {
return document.createTextNode([cljs.core.str(this$)].join(''));
}
}));

(dommy.template.PElement["number"] = true);

(dommy.template._elem["number"] = (function (this$){
return document.createTextNode([cljs.core.str(this$)].join(''));
}));

cljs.core.PersistentVector.prototype.dommy$template$PElement$ = true;

cljs.core.PersistentVector.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return dommy.template.compound_element(this$__$1);
});

SVGElement.prototype.dommy$template$PElement$ = true;

SVGElement.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

Document.prototype.dommy$template$PElement$ = true;

Document.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

Text.prototype.dommy$template$PElement$ = true;

Text.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

DocumentFragment.prototype.dommy$template$PElement$ = true;

DocumentFragment.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});

HTMLElement.prototype.dommy$template$PElement$ = true;

HTMLElement.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
try{Window.prototype.dommy$template$PElement$ = true;

Window.prototype.dommy$template$PElement$_elem$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
});
}catch (e43484){if((e43484 instanceof ReferenceError)){
var __43485 = e43484;
console.log("PElement: js/Window not defined by browser, skipping it... (running on phantomjs?)");
} else {
throw e43484;

}
}dommy.template.node = (function dommy$template$node(data){
if((function (){var G__43487 = data;
if(G__43487){
var bit__4950__auto__ = null;
if(cljs.core.truth_((function (){var or__4276__auto__ = bit__4950__auto__;
if(cljs.core.truth_(or__4276__auto__)){
return or__4276__auto__;
} else {
return G__43487.dommy$template$PElement$;
}
})())){
return true;
} else {
if((!G__43487.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__43487);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(dommy.template.PElement,G__43487);
}
})()){
return dommy.template._elem(data);
} else {
return dommy.template.throw_unable_to_make_node(data);
}
});
dommy.template.html__GT_nodes = (function dommy$template$html__GT_nodes(html){
var parent = document.createElement("div");
parent.insertAdjacentHTML("beforeend",html);

return cljs.core.seq(Array.prototype.slice.call(parent.childNodes));
});
