// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.organization');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
milia.api.organization.internal_members_team_name = "members";
milia.api.organization.owners_team_name = "Owners";
milia.api.organization.editor_role = "editor";
/**
 * List all the organizations belonging to the account making the request.
 * When a username is provided, return only those organizations shared by both
 * the account making the request and the user associated with the username.
 */
milia.api.organization.all = (function milia$api$organization$all(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21241 = arguments.length;
var i__7281__auto___21242 = (0);
while(true){
if((i__7281__auto___21242 < len__7280__auto___21241)){
args__7287__auto__.push((arguments[i__7281__auto___21242]));

var G__21243 = (i__7281__auto___21242 + (1));
i__7281__auto___21242 = G__21243;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((0) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((0)),(0),null)):null);
return milia.api.organization.all.cljs$core$IFn$_invoke$arity$variadic(argseq__7288__auto__);
});

milia.api.organization.all.cljs$core$IFn$_invoke$arity$variadic = (function (p__21239){
var vec__21240 = p__21239;
var username = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21240,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(username)?[cljs.core.str("orgs?shared_with="),cljs.core.str(username)].join(''):"orgs")], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.organization.all.cljs$lang$maxFixedArity = (0);

milia.api.organization.all.cljs$lang$applyTo = (function (seq21238){
return milia.api.organization.all.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq21238));
});
milia.api.organization.create = (function milia$api$organization$create(data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
milia.api.organization.profile = (function milia$api$organization$profile(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21249 = arguments.length;
var i__7281__auto___21250 = (0);
while(true){
if((i__7281__auto___21250 < len__7280__auto___21249)){
args__7287__auto__.push((arguments[i__7281__auto___21250]));

var G__21251 = (i__7281__auto___21250 + (1));
i__7281__auto___21250 = G__21251;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic = (function (org_name,p__21246){
var map__21247 = p__21246;
var map__21247__$1 = ((((!((map__21247 == null)))?((((map__21247.cljs$lang$protocol_mask$partition0$ & (64))) || (map__21247.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__21247):map__21247);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21247__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.organization.profile.cljs$lang$maxFixedArity = (1);

milia.api.organization.profile.cljs$lang$applyTo = (function (seq21244){
var G__21245 = cljs.core.first(seq21244);
var seq21244__$1 = cljs.core.next(seq21244);
return milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic(G__21245,seq21244__$1);
});
/**
 * Return whether a user can create projects within an organization
 */
milia.api.organization.can_user_create_project_under_organization_QMARK_ = (function milia$api$organization$can_user_create_project_under_organization_QMARK_(username_to_check,organization){
var role = cljs.core.cst$kw$role.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__21252_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$user.cljs$core$IFn$_invoke$arity$1(p1__21252_SHARP_),username_to_check);
}),cljs.core.cst$kw$users.cljs$core$IFn$_invoke$arity$1(organization))));
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(role,"manager")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(role,"owner"));
});
milia.api.organization.get_organizations_where_user_can_create_projects = (function milia$api$organization$get_organizations_where_user_can_create_projects(username_to_check){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__21253_SHARP_){
return milia.api.organization.can_user_create_project_under_organization_QMARK_(username_to_check,p1__21253_SHARP_);
}),milia.api.organization.all());
});
/**
 * Return all the teams for an organization.
 */
milia.api.organization.teams_all = (function milia$api$organization$teams_all(var_args){
var args21254 = [];
var len__7280__auto___21257 = arguments.length;
var i__7281__auto___21258 = (0);
while(true){
if((i__7281__auto___21258 < len__7280__auto___21257)){
args21254.push((arguments[i__7281__auto___21258]));

var G__21259 = (i__7281__auto___21258 + (1));
i__7281__auto___21258 = G__21259;
continue;
} else {
}
break;
}

var G__21256 = args21254.length;
switch (G__21256) {
case 0:
return milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21254.length)].join('')));

}
});

milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$1(null);
});

milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$1 = (function (organization_name){
var base_url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams"], 0));
var url = (cljs.core.truth_(organization_name)?[cljs.core.str(base_url),cljs.core.str("?org="),cljs.core.str(organization_name)].join(''):base_url);
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.organization.teams_all.cljs$lang$maxFixedArity = 1;
/**
 * Return the teams for an organization, removing 'members' team that is used
 * internall by the API to store non-team based org members.
 */
milia.api.organization.teams = (function milia$api$organization$teams(org_name){
var teams__$1 = milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$0();
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (teams__$1){
return (function (p1__21261_SHARP_){
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(milia.api.organization.internal_members_team_name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(p1__21261_SHARP_))) || (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(org_name,cljs.core.cst$kw$organization.cljs$core$IFn$_invoke$arity$1(p1__21261_SHARP_)));
});})(teams__$1))
,teams__$1);
});
milia.api.organization.team_info = (function milia$api$organization$team_info(org_name,team_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",org_name,team_id], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.organization.team_members = (function milia$api$organization$team_members(team_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",team_id,"members"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add a team to an organization
 */
milia.api.organization.create_team = (function milia$api$organization$create_team(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Add a user to a team
 */
milia.api.organization.add_team_member = (function milia$api$organization$add_team_member(org_name,team_id,user){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",org_name,team_id,"members"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,user], null)], 0));
});
milia.api.organization.members = (function milia$api$organization$members(org_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add a user to an organization
 */
milia.api.organization.add_member = (function milia$api$organization$add_member(var_args){
var args21262 = [];
var len__7280__auto___21265 = arguments.length;
var i__7281__auto___21266 = (0);
while(true){
if((i__7281__auto___21266 < len__7280__auto___21265)){
args21262.push((arguments[i__7281__auto___21266]));

var G__21267 = (i__7281__auto___21266 + (1));
i__7281__auto___21266 = G__21267;
continue;
} else {
}
break;
}

var G__21264 = args21262.length;
switch (G__21264) {
case 2:
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21262.length)].join('')));

}
});

milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$2 = (function (org_name,member){
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3(org_name,member,null);
});

milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3 = (function (org_name,member,role){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members"], 0));
var assigned_role = (function (){var or__6210__auto__ = role;
if(cljs.core.truth_(or__6210__auto__)){
return or__6210__auto__;
} else {
return milia.api.organization.editor_role;
}
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,member,cljs.core.cst$kw$role,assigned_role], null)], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});

milia.api.organization.add_member.cljs$lang$maxFixedArity = 3;
/**
 * Remove a user from an organization or organization team
 */
milia.api.organization.remove_member = (function milia$api$organization$remove_member(var_args){
var args21269 = [];
var len__7280__auto___21272 = arguments.length;
var i__7281__auto___21273 = (0);
while(true){
if((i__7281__auto___21273 < len__7280__auto___21272)){
args21269.push((arguments[i__7281__auto___21273]));

var G__21274 = (i__7281__auto___21273 + (1));
i__7281__auto___21273 = G__21274;
continue;
} else {
}
break;
}

var G__21271 = args21269.length;
switch (G__21271) {
case 2:
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args21269.length)].join('')));

}
});

milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$2 = (function (org_name,member){
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3(org_name,member,null);
});

milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3 = (function (org_name,member,team_id){
var url = (cljs.core.truth_(team_id)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",org_name,team_id,"members"], 0)):milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members"], 0)));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$delete,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$username,member], null)], null)], 0));
});

milia.api.organization.remove_member.cljs$lang$maxFixedArity = 3;
/**
 * Is the user the only member of the Owners team.
 */
milia.api.organization.single_owner_QMARK_ = (function milia$api$organization$single_owner_QMARK_(team,members){
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(milia.api.organization.owners_team_name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(team))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(members)));
});
/**
 * Is user only members in org with owner role?
 */
milia.api.organization.single_owner_member_QMARK_ = (function milia$api$organization$single_owner_member_QMARK_(org_name){
var org = milia.api.organization.profile(org_name);
var users = cljs.core.cst$kw$users.cljs$core$IFn$_invoke$arity$1(org);
var owner_roles = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (org,users){
return (function (p1__21276_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("owner",p1__21276_SHARP_);
});})(org,users))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$role,users));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(owner_roles),(1));
});
/**
 * update organization profile
 */
milia.api.organization.update = (function milia$api$organization$update(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",cljs.core.cst$kw$org.cljs$core$IFn$_invoke$arity$1(params)], 0));
var params__$1 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(params,cljs.core.cst$kw$org);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,params__$1], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
/**
 * Returns an Organizaion team given the team name.
 */
milia.api.organization.get_team = (function milia$api$organization$get_team(org_name,team_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("teams?org="),cljs.core.str(org_name)].join('')], 0));
var teams = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
return cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (url,teams){
return (function (p1__21277_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(team_name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(p1__21277_SHARP_));
});})(url,teams))
,teams));
});
milia.api.organization.share_team = (function milia$api$organization$share_team(team_id,data){

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",team_id,"share"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null)], 0));
});
