// Compiled by ClojureScript 1.8.51 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.apps');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
milia.api.apps.rapidpro_hosts = new cljs.core.PersistentArrayMap(null, 2, ["rapidpro-ona","rapidpro.ona.io","textit","textit.in"], null);
milia.api.apps.get_host_url = (function milia$api$apps$get_host_url(server){
return [cljs.core.str((function (){var temp__4655__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(milia.api.apps.rapidpro_hosts,server);
if(cljs.core.truth_(temp__4655__auto__)){
var host_url = temp__4655__auto__;
return [cljs.core.str("https://"),cljs.core.str(host_url)].join('');
} else {
return server;
}
})()),cljs.core.str("/api/v1")].join('');
});
/**
 * Build a texit server API url.
 */
milia.api.apps.make_textit_url = (function milia$api$apps$make_textit_url(var_args){
var args__7287__auto__ = [];
var len__7280__auto___21102 = arguments.length;
var i__7281__auto___21103 = (0);
while(true){
if((i__7281__auto___21103 < len__7280__auto___21102)){
args__7287__auto__.push((arguments[i__7281__auto___21103]));

var G__21104 = (i__7281__auto___21103 + (1));
i__7281__auto___21103 = G__21104;
continue;
} else {
}
break;
}

var argseq__7288__auto__ = ((((1) < args__7287__auto__.length))?(new cljs.core.IndexedSeq(args__7287__auto__.slice((1)),(0),null)):null);
return milia.api.apps.make_textit_url.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7288__auto__);
});

milia.api.apps.make_textit_url.cljs$core$IFn$_invoke$arity$variadic = (function (server,postfix){
return milia.utils.remote.url_join(milia.api.apps.get_host_url(server),postfix);
});

milia.api.apps.make_textit_url.cljs$lang$maxFixedArity = (1);

milia.api.apps.make_textit_url.cljs$lang$applyTo = (function (seq21100){
var G__21101 = cljs.core.first(seq21100);
var seq21100__$1 = cljs.core.next(seq21100);
return milia.api.apps.make_textit_url.cljs$core$IFn$_invoke$arity$variadic(G__21101,seq21100__$1);
});
/**
 * Get data from textit server given server URL, endpoint & API Key.
 */
milia.api.apps.get_textit_data = (function milia$api$apps$get_textit_data(api_token,endpoint,server){
var url = milia.api.apps.make_textit_url.cljs$core$IFn$_invoke$arity$variadic(server,cljs.core.array_seq([[cljs.core.str(endpoint),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$auth_DASH_token,api_token,cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$raw_DASH_response_QMARK_,true,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
