// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.initial_polling_interval = (5000);
/**
 * Handles API server's response and acts according to given callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__35311,p__35312){
var map__35321 = p__35311;
var map__35321__$1 = ((((!((map__35321 == null)))?((((map__35321.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35321.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35321):map__35321);
var response = map__35321__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35321__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35321__$1,cljs.core.cst$kw$body);
var map__35322 = p__35312;
var map__35322__$1 = ((((!((map__35322 == null)))?((((map__35322.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35322.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35322):map__35322);
var callbacks = map__35322__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35322__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35322__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35322__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35322__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__35325 = body;
var map__35325__$1 = ((((!((map__35325 == null)))?((((map__35325.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35325.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35325):map__35325);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35325__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35325__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35325__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = ((function (map__35325,map__35325__$1,export_url,job_status,job_id,map__35321,map__35321__$1,response,status,body,map__35322,map__35322__$1,callbacks,on_error,on_export_url,on_job_id,on_stop){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});})(map__35325,map__35325__$1,export_url,job_status,job_id,map__35321,map__35321__$1,response,status,body,map__35322,map__35322__$1,callbacks,on_error,on_export_url,on_job_id,on_stop))
;
var error_detail = (function (){var or__6543__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = cljs.core.cst$kw$details.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
if(cljs.core.truth_(is_failed_status_QMARK_())){
return job_status;
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}

} else {
}

if(cljs.core.truth_((function (){var or__6543__auto__ = (status >= (400));
if(or__6543__auto__){
return or__6543__auto__;
} else {
return is_failed_status_QMARK_();
}
})())){
if(cljs.core.fn_QMARK_(on_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(403))){
var G__35327_35329 = error_detail;
var G__35328_35330 = cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(body);
(on_error.cljs$core$IFn$_invoke$arity$2 ? on_error.cljs$core$IFn$_invoke$arity$2(G__35327_35329,G__35328_35330) : on_error.call(null,G__35327_35329,G__35328_35330));
} else {
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
}
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 * When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35389 = arguments.length;
var i__7652__auto___35390 = (0);
while(true){
if((i__7652__auto___35390 < len__7651__auto___35389)){
args__7658__auto__.push((arguments[i__7652__auto___35390]));

var G__35391 = (i__7652__auto___35390 + (1));
i__7652__auto___35390 = G__35391;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__35334){
var map__35335 = p__35334;
var map__35335__$1 = ((((!((map__35335 == null)))?((((map__35335.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35335.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35335):map__35335);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35335__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35335__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35335__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var c__19089__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto__,map__35335,map__35335__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto__,map__35335,map__35335__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function (state_35366){
var state_val_35367 = (state_35366[(1)]);
if((state_val_35367 === (7))){
var inst_35344 = (state_35366[(7)]);
var inst_35337 = (state_35366[(8)]);
var inst_35339 = (state_35366[(9)]);
var inst_35347 = (state_35366[(2)]);
var inst_35348 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_35349 = (function (){var polling_interval = inst_35337;
var job_suffix = inst_35339;
var job_url = inst_35344;
var response = inst_35347;
return ((function (polling_interval,job_suffix,job_url,response,inst_35344,inst_35337,inst_35339,inst_35347,inst_35348,state_val_35367,c__19089__auto__,map__35335,map__35335__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function (){
return cljs.core.constantly(cljs.core.cst$kw$stop);
});
;})(polling_interval,job_suffix,job_url,response,inst_35344,inst_35337,inst_35339,inst_35347,inst_35348,state_val_35367,c__19089__auto__,map__35335,map__35335__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
})();
var inst_35350 = [inst_35349,on_error,on_export_url];
var inst_35351 = cljs.core.PersistentHashMap.fromArrays(inst_35348,inst_35350);
var inst_35352 = milia.api.async_export.handle_response(inst_35347,inst_35351);
var inst_35353 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_35352,cljs.core.cst$kw$stop);
var state_35366__$1 = state_35366;
if(inst_35353){
var statearr_35368_35392 = state_35366__$1;
(statearr_35368_35392[(1)] = (8));

} else {
var statearr_35369_35393 = state_35366__$1;
(statearr_35369_35393[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35367 === (1))){
var inst_35337 = milia.api.async_export.initial_polling_interval;
var state_35366__$1 = (function (){var statearr_35370 = state_35366;
(statearr_35370[(8)] = inst_35337);

return statearr_35370;
})();
var statearr_35371_35394 = state_35366__$1;
(statearr_35371_35394[(2)] = null);

(statearr_35371_35394[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35367 === (4))){
var state_35366__$1 = state_35366;
var statearr_35372_35395 = state_35366__$1;
(statearr_35372_35395[(2)] = "dataviews");

(statearr_35372_35395[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35367 === (6))){
var inst_35344 = (state_35366[(7)]);
var inst_35339 = (state_35366[(9)]);
var inst_35343 = (state_35366[(2)]);
var inst_35344__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_35343,dataset_id,inst_35339], 0));
var inst_35345 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_35344__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_35366__$1 = (function (){var statearr_35373 = state_35366;
(statearr_35373[(7)] = inst_35344__$1);

return statearr_35373;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35366__$1,(7),inst_35345);
} else {
if((state_val_35367 === (3))){
var inst_35364 = (state_35366[(2)]);
var state_35366__$1 = state_35366;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35366__$1,inst_35364);
} else {
if((state_val_35367 === (2))){
var inst_35339 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var state_35366__$1 = (function (){var statearr_35374 = state_35366;
(statearr_35374[(9)] = inst_35339);

return statearr_35374;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_35375_35396 = state_35366__$1;
(statearr_35375_35396[(1)] = (4));

} else {
var statearr_35376_35397 = state_35366__$1;
(statearr_35376_35397[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35367 === (11))){
var inst_35337 = (state_35366[(8)]);
var inst_35357 = (state_35366[(2)]);
var inst_35358 = (inst_35337 * (2));
var inst_35337__$1 = inst_35358;
var state_35366__$1 = (function (){var statearr_35377 = state_35366;
(statearr_35377[(8)] = inst_35337__$1);

(statearr_35377[(10)] = inst_35357);

return statearr_35377;
})();
var statearr_35378_35398 = state_35366__$1;
(statearr_35378_35398[(2)] = null);

(statearr_35378_35398[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35367 === (9))){
var state_35366__$1 = state_35366;
var statearr_35379_35399 = state_35366__$1;
(statearr_35379_35399[(2)] = null);

(statearr_35379_35399[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35367 === (5))){
var state_35366__$1 = state_35366;
var statearr_35380_35400 = state_35366__$1;
(statearr_35380_35400[(2)] = "forms");

(statearr_35380_35400[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35367 === (10))){
var inst_35362 = (state_35366[(2)]);
var state_35366__$1 = state_35366;
var statearr_35381_35401 = state_35366__$1;
(statearr_35381_35401[(2)] = inst_35362);

(statearr_35381_35401[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35367 === (8))){
var inst_35337 = (state_35366[(8)]);
var inst_35355 = cljs.core.async.timeout(inst_35337);
var state_35366__$1 = state_35366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35366__$1,(11),inst_35355);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto__,map__35335,map__35335__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
;
return ((function (switch__18977__auto__,c__19089__auto__,map__35335,map__35335__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function() {
var milia$api$async_export$state_machine__18978__auto__ = null;
var milia$api$async_export$state_machine__18978__auto____0 = (function (){
var statearr_35385 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35385[(0)] = milia$api$async_export$state_machine__18978__auto__);

(statearr_35385[(1)] = (1));

return statearr_35385;
});
var milia$api$async_export$state_machine__18978__auto____1 = (function (state_35366){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_35366);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e35386){if((e35386 instanceof Object)){
var ex__18981__auto__ = e35386;
var statearr_35387_35402 = state_35366;
(statearr_35387_35402[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35366);

return cljs.core.cst$kw$recur;
} else {
throw e35386;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__35403 = state_35366;
state_35366 = G__35403;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
milia$api$async_export$state_machine__18978__auto__ = function(state_35366){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__18978__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__18978__auto____1.call(this,state_35366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__18978__auto____0;
milia$api$async_export$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__18978__auto____1;
return milia$api$async_export$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto__,map__35335,map__35335__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
})();
var state__19091__auto__ = (function (){var statearr_35388 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_35388[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto__);

return statearr_35388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto__,map__35335,map__35335__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
);

return c__19089__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq35331){
var G__35332 = cljs.core.first(seq35331);
var seq35331__$1 = cljs.core.next(seq35331);
var G__35333 = cljs.core.first(seq35331__$1);
var seq35331__$2 = cljs.core.next(seq35331__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35332,G__35333,seq35331__$2);
});

milia.api.async_export.version_key = "_version";
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_hxl","include_images","remove_group_name",milia.api.async_export.version_key,"query","export_id","include_labels","include_labels_only","win_excel_utf8","redirect_uri"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_hxl_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id,cljs.core.cst$kw$include_DASH_labels_QMARK_,cljs.core.cst$kw$labels_DASH_only_QMARK_,cljs.core.cst$kw$windows_DASH_compatible_DASH_csv_QMARK_,cljs.core.cst$kw$redirect_DASH_uri], null);
milia.api.async_export.get_param = (function milia$api$async_export$get_param(key,value){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,milia.api.async_export.version_key)){
return goog.string.format("&query={\"%s\":\"%s\"}",key,value);
} else {
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
}
});
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_((function (){var or__6543__auto__ = value;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
return milia.api.async_export.get_param(key,value);
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35411 = arguments.length;
var i__7652__auto___35412 = (0);
while(true){
if((i__7652__auto___35412 < len__7651__auto___35411)){
args__7658__auto__.push((arguments[i__7652__auto___35412]));

var G__35413 = (i__7652__auto___35412 + (1));
i__7652__auto___35412 = G__35413;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__35407){
var vec__35408 = p__35407;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35408,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq35404){
var G__35405 = cljs.core.first(seq35404);
var seq35404__$1 = cljs.core.next(seq35404);
var G__35406 = cljs.core.first(seq35404__$1);
var seq35404__$2 = cljs.core.next(seq35404__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__35405,G__35406,seq35404__$2);
});

/**
 * Triggers async export and watches it via polling.
 * Fires on-job-id callback on receving :job_uuid from server, then monitors
 * job via polling. On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35452 = arguments.length;
var i__7652__auto___35453 = (0);
while(true){
if((i__7652__auto___35453 < len__7651__auto___35452)){
args__7658__auto__.push((arguments[i__7652__auto___35453]));

var G__35454 = (i__7652__auto___35453 + (1));
i__7652__auto___35453 = G__35454;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__35416){
var vec__35417 = p__35416;
var map__35420 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35417,(0),null);
var map__35420__$1 = ((((!((map__35420 == null)))?((((map__35420.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35420.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35420):map__35420);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35420__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35420__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35420__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35420__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35420__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35420__$1,cljs.core.cst$kw$on_DASH_error);
var c__19089__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto__,vec__35417,map__35420,map__35420__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto__,vec__35417,map__35420,map__35420__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (state_35437){
var state_val_35438 = (state_35437[(1)]);
if((state_val_35438 === (1))){
var inst_35422 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var state_35437__$1 = (function (){var statearr_35439 = state_35437;
(statearr_35439[(7)] = inst_35422);

return statearr_35439;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_35440_35455 = state_35437__$1;
(statearr_35440_35455[(1)] = (2));

} else {
var statearr_35441_35456 = state_35437__$1;
(statearr_35441_35456[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35438 === (2))){
var state_35437__$1 = state_35437;
var statearr_35442_35457 = state_35437__$1;
(statearr_35442_35457[(2)] = "dataviews");

(statearr_35442_35457[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35438 === (3))){
var state_35437__$1 = state_35437;
var statearr_35443_35458 = state_35437__$1;
(statearr_35443_35458[(2)] = "forms");

(statearr_35443_35458[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35438 === (4))){
var inst_35422 = (state_35437[(7)]);
var inst_35426 = (state_35437[(8)]);
var inst_35427 = (state_35437[(9)]);
var inst_35426__$1 = (state_35437[(2)]);
var inst_35427__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_35426__$1,dataset_id,inst_35422], 0));
var inst_35428 = milia.utils.retry.retry_parse_http(cljs.core.cst$kw$get,inst_35427__$1);
var state_35437__$1 = (function (){var statearr_35444 = state_35437;
(statearr_35444[(8)] = inst_35426__$1);

(statearr_35444[(9)] = inst_35427__$1);

return statearr_35444;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35437__$1,(5),inst_35428);
} else {
if((state_val_35438 === (5))){
var inst_35422 = (state_35437[(7)]);
var inst_35426 = (state_35437[(8)]);
var inst_35427 = (state_35437[(9)]);
var inst_35430 = (state_35437[(2)]);
var inst_35431 = (function (){var export_suffix = inst_35422;
var export_endpoint = inst_35426;
var export_url = inst_35427;
var response = inst_35430;
return ((function (export_suffix,export_endpoint,export_url,response,inst_35422,inst_35426,inst_35427,inst_35430,state_val_35438,c__19089__auto__,vec__35417,map__35420,map__35420__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([cljs.core.cst$kw$on_DASH_export_DASH_url,on_export_url,cljs.core.cst$kw$on_DASH_error,on_error,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_,is_filtered_dataview_QMARK_], 0));
});
;})(export_suffix,export_endpoint,export_url,response,inst_35422,inst_35426,inst_35427,inst_35430,state_val_35438,c__19089__auto__,vec__35417,map__35420,map__35420__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var inst_35432 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_35433 = [on_error,inst_35431,on_export_url];
var inst_35434 = cljs.core.PersistentHashMap.fromArrays(inst_35432,inst_35433);
var inst_35435 = milia.api.async_export.handle_response(inst_35430,inst_35434);
var state_35437__$1 = state_35437;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35437__$1,inst_35435);
} else {
return null;
}
}
}
}
}
});})(c__19089__auto__,vec__35417,map__35420,map__35420__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
;
return ((function (switch__18977__auto__,c__19089__auto__,vec__35417,map__35420,map__35420__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function() {
var milia$api$async_export$state_machine__18978__auto__ = null;
var milia$api$async_export$state_machine__18978__auto____0 = (function (){
var statearr_35448 = [null,null,null,null,null,null,null,null,null,null];
(statearr_35448[(0)] = milia$api$async_export$state_machine__18978__auto__);

(statearr_35448[(1)] = (1));

return statearr_35448;
});
var milia$api$async_export$state_machine__18978__auto____1 = (function (state_35437){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_35437);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e35449){if((e35449 instanceof Object)){
var ex__18981__auto__ = e35449;
var statearr_35450_35459 = state_35437;
(statearr_35450_35459[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35437);

return cljs.core.cst$kw$recur;
} else {
throw e35449;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__35460 = state_35437;
state_35437 = G__35460;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
milia$api$async_export$state_machine__18978__auto__ = function(state_35437){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__18978__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__18978__auto____1.call(this,state_35437);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__18978__auto____0;
milia$api$async_export$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__18978__auto____1;
return milia$api$async_export$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto__,vec__35417,map__35420,map__35420__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var state__19091__auto__ = (function (){var statearr_35451 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_35451[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto__);

return statearr_35451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto__,vec__35417,map__35420,map__35420__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
);

return c__19089__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq35414){
var G__35415 = cljs.core.first(seq35414);
var seq35414__$1 = cljs.core.next(seq35414);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35415,seq35414__$1);
});

/**
 * Returns a channel, which will have the async export url when ready.
 */
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,((function (ch){
return (function (p1__35461_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__35461_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
/**
 * Returns a channel, which will have the async _data_
 * downloaded using http-method when ready.
 */
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35486 = arguments.length;
var i__7652__auto___35487 = (0);
while(true){
if((i__7652__auto___35487 < len__7651__auto___35486)){
args__7658__auto__.push((arguments[i__7652__auto___35487]));

var G__35488 = (i__7652__auto___35487 + (1));
i__7652__auto___35487 = G__35488;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){
var c__19089__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto__){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto__){
return (function (state_35477){
var state_val_35478 = (state_35477[(1)]);
if((state_val_35478 === (1))){
var inst_35466 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_35477__$1 = state_35477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35477__$1,(2),inst_35466);
} else {
if((state_val_35478 === (2))){
var inst_35468 = (state_35477[(2)]);
var inst_35469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35470 = [http_method,inst_35468];
var inst_35471 = (new cljs.core.PersistentVector(null,2,(5),inst_35469,inst_35470,null));
var inst_35472 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_35471,args);
var inst_35473 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_35472);
var state_35477__$1 = state_35477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35477__$1,(3),inst_35473);
} else {
if((state_val_35478 === (3))){
var inst_35475 = (state_35477[(2)]);
var state_35477__$1 = state_35477;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35477__$1,inst_35475);
} else {
return null;
}
}
}
});})(c__19089__auto__))
;
return ((function (switch__18977__auto__,c__19089__auto__){
return (function() {
var milia$api$async_export$state_machine__18978__auto__ = null;
var milia$api$async_export$state_machine__18978__auto____0 = (function (){
var statearr_35482 = [null,null,null,null,null,null,null];
(statearr_35482[(0)] = milia$api$async_export$state_machine__18978__auto__);

(statearr_35482[(1)] = (1));

return statearr_35482;
});
var milia$api$async_export$state_machine__18978__auto____1 = (function (state_35477){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_35477);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e35483){if((e35483 instanceof Object)){
var ex__18981__auto__ = e35483;
var statearr_35484_35489 = state_35477;
(statearr_35484_35489[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35477);

return cljs.core.cst$kw$recur;
} else {
throw e35483;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__35490 = state_35477;
state_35477 = G__35490;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
milia$api$async_export$state_machine__18978__auto__ = function(state_35477){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__18978__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__18978__auto____1.call(this,state_35477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__18978__auto____0;
milia$api$async_export$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__18978__auto____1;
return milia$api$async_export$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto__))
})();
var state__19091__auto__ = (function (){var statearr_35485 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_35485[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto__);

return statearr_35485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto__))
);

return c__19089__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq35462){
var G__35463 = cljs.core.first(seq35462);
var seq35462__$1 = cljs.core.next(seq35462);
var G__35464 = cljs.core.first(seq35462__$1);
var seq35462__$2 = cljs.core.next(seq35462__$1);
var G__35465 = cljs.core.first(seq35462__$2);
var seq35462__$3 = cljs.core.next(seq35462__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__35463,G__35464,G__35465,seq35462__$3);
});

