// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.notes');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Returns all notes. Returns notes for a specific submission if
 *   optional instance ID is proviced
 */
milia.api.notes.list = (function milia$api$notes$list(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35158 = arguments.length;
var i__7652__auto___35159 = (0);
while(true){
if((i__7652__auto___35159 < len__7651__auto___35158)){
args__7658__auto__.push((arguments[i__7652__auto___35159]));

var G__35160 = (i__7652__auto___35159 + (1));
i__7652__auto___35159 = G__35160;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.notes.list.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.notes.list.cljs$core$IFn$_invoke$arity$variadic = (function (p__35155){
var map__35156 = p__35155;
var map__35156__$1 = ((((!((map__35156 == null)))?((((map__35156.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35156.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35156):map__35156);
var instance_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35156__$1,cljs.core.cst$kw$instance_DASH_id);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35156__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("notes"),cljs.core.str((cljs.core.truth_(instance_id)?[cljs.core.str("?instance="),cljs.core.str(instance_id)].join(''):null))].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.notes.list.cljs$lang$maxFixedArity = (0);

milia.api.notes.list.cljs$lang$applyTo = (function (seq35154){
return milia.api.notes.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35154));
});

/**
 * Creates a note for a submission instance given the note and instance-id.
 * Takes an options instance-field argument if note added for specific field.
 */
milia.api.notes.create = (function milia$api$notes$create(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35168 = arguments.length;
var i__7652__auto___35169 = (0);
while(true){
if((i__7652__auto___35169 < len__7651__auto___35168)){
args__7658__auto__.push((arguments[i__7652__auto___35169]));

var G__35170 = (i__7652__auto___35169 + (1));
i__7652__auto___35169 = G__35170;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.notes.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.notes.create.cljs$core$IFn$_invoke$arity$variadic = (function (note,instance_id,p__35164){
var vec__35165 = p__35164;
var instance_field = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35165,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["notes"], 0));
var params = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$note,note,cljs.core.cst$kw$instance,instance_id], null);
var form_params = (cljs.core.truth_(instance_field)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(params,cljs.core.cst$kw$instance_field,instance_field):params);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
});

milia.api.notes.create.cljs$lang$maxFixedArity = (2);

milia.api.notes.create.cljs$lang$applyTo = (function (seq35161){
var G__35162 = cljs.core.first(seq35161);
var seq35161__$1 = cljs.core.next(seq35161);
var G__35163 = cljs.core.first(seq35161__$1);
var seq35161__$2 = cljs.core.next(seq35161__$1);
return milia.api.notes.create.cljs$core$IFn$_invoke$arity$variadic(G__35162,G__35163,seq35161__$2);
});

/**
 * Returns a note object given a note ID.
 */
milia.api.notes.get = (function milia$api$notes$get(note_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["notes",note_id], 0)));
});
/**
 * Deletes a note given a note ID.
 */
milia.api.notes.delete$ = (function milia$api$notes$delete(note_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["notes",note_id], 0)));
});
