// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.widgets');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * The Ona API expects clients to submit a URL as the value of the object bound
 * to a widget. This is basically asking clients to be aware of internal API
 * implementation details since this is a Django REST framework peculiarity.
 * This function provides an abstraction that allows Clojure based clients to
 * be ignorant of the quirk.
 * `content-type` can be either :form or :dataview
 * `content-id` is an integer identifying the object
 */
milia.api.widgets.generate_content_object_url = (function milia$api$widgets$generate_content_object_url(content_type,content_id){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(function (){var G__34934 = (((content_type instanceof cljs.core.Keyword))?content_type.fqn:null);
switch (G__34934) {
case "form":
return "forms";

break;
case "dataview":
return "dataviews";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(content_type)].join('')));

}
})(),content_id], 0));
});
/**
 * Create a new widget.
 * `widget-definition` is a map containing the following keys:
 *  `:title` is a string
 *  `:content_type` is one of either :form of :dataview
 *  `:content_id` is an intger identifying the content object
 *  `:description` is a string.
 *  `:widget_type` is a string, determined by the client e.g. chart
 *  `:view_type` is a string, determined by the client e.g. bar-chart
 *  `:column` is the  data column to be stored based on the form field.
 *  `:order` this is the position of the widget in relation to others
 *           within the set associated with a form or dataview. Optional.
 *  `:group_by` the data column for the data to be grouped by. Optional
 *  `:aggregation` is the aggregation used while grouping data. Optional.
 *  `:metadata` is a map containing arbitrary key-value pairs.
 */
milia.api.widgets.create = (function milia$api$widgets$create(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34944 = arguments.length;
var i__7652__auto___34945 = (0);
while(true){
if((i__7652__auto___34945 < len__7651__auto___34944)){
args__7658__auto__.push((arguments[i__7652__auto___34945]));

var G__34946 = (i__7652__auto___34945 + (1));
i__7652__auto___34945 = G__34946;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.widgets.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.widgets.create.cljs$core$IFn$_invoke$arity$variadic = (function (p__34938,p__34939){
var map__34940 = p__34938;
var map__34940__$1 = ((((!((map__34940 == null)))?((((map__34940.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34940.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34940):map__34940);
var widget_definition = map__34940__$1;
var content_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34940__$1,cljs.core.cst$kw$content_type);
var content_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34940__$1,cljs.core.cst$kw$content_id);
var map__34941 = p__34939;
var map__34941__$1 = ((((!((map__34941 == null)))?((((map__34941.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34941.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34941):map__34941);
var with_data_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34941__$1,cljs.core.cst$kw$with_DASH_data_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("widgets"),cljs.core.str((cljs.core.truth_(with_data_QMARK_)?"?data=true":null))].join('')], 0));
var processed_widget_definition = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(widget_definition,cljs.core.cst$kw$content_object,milia.api.widgets.generate_content_object_url(content_type,content_id));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,processed_widget_definition], null)], 0));
});

milia.api.widgets.create.cljs$lang$maxFixedArity = (1);

milia.api.widgets.create.cljs$lang$applyTo = (function (seq34936){
var G__34937 = cljs.core.first(seq34936);
var seq34936__$1 = cljs.core.next(seq34936);
return milia.api.widgets.create.cljs$core$IFn$_invoke$arity$variadic(G__34937,seq34936__$1);
});

/**
 * Updates a widget, given the widget ID, and a map of properties to replace
 * existing values for the associated keys
 */
milia.api.widgets.update = (function milia$api$widgets$update(widget_id,patch_map){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["widgets",widget_id], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,patch_map], null)], 0));
});
/**
 * List widgets belonging to a particular user
 * Can optionally be filtered by supplying either a dataview ID or an XForm ID
 * Note that the filters are mutually exclusive
 */
milia.api.widgets.list = (function milia$api$widgets$list(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34951 = arguments.length;
var i__7652__auto___34952 = (0);
while(true){
if((i__7652__auto___34952 < len__7651__auto___34951)){
args__7658__auto__.push((arguments[i__7652__auto___34952]));

var G__34953 = (i__7652__auto___34952 + (1));
i__7652__auto___34952 = G__34953;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.widgets.list.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.widgets.list.cljs$core$IFn$_invoke$arity$variadic = (function (p__34948){
var map__34949 = p__34948;
var map__34949__$1 = ((((!((map__34949 == null)))?((((map__34949.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34949.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34949):map__34949);
var dataview_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34949__$1,cljs.core.cst$kw$dataview_DASH_id);
var xform_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34949__$1,cljs.core.cst$kw$xform_DASH_id);
var with_data_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34949__$1,cljs.core.cst$kw$with_DASH_data_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(dataview_id)?[cljs.core.str("widgets?dataview="),cljs.core.str(dataview_id),cljs.core.str((cljs.core.truth_(with_data_QMARK_)?"&data=true":null))].join(''):(cljs.core.truth_(xform_id)?[cljs.core.str("widgets?xform="),cljs.core.str(xform_id),cljs.core.str((cljs.core.truth_(with_data_QMARK_)?"&data=true":null))].join(''):[cljs.core.str("widgets"),cljs.core.str((cljs.core.truth_(with_data_QMARK_)?"?data=true":null))].join('')
))], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});

milia.api.widgets.list.cljs$lang$maxFixedArity = (0);

milia.api.widgets.list.cljs$lang$applyTo = (function (seq34947){
return milia.api.widgets.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34947));
});

/**
 * Deletes a widget, given a widget id.
 */
milia.api.widgets.delete$ = (function milia$api$widgets$delete(widget_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["widgets",widget_id], 0)));
});
/**
 * Returns specific widget, given the ID
 */
milia.api.widgets.get = (function milia$api$widgets$get(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34959 = arguments.length;
var i__7652__auto___34960 = (0);
while(true){
if((i__7652__auto___34960 < len__7651__auto___34959)){
args__7658__auto__.push((arguments[i__7652__auto___34960]));

var G__34961 = (i__7652__auto___34960 + (1));
i__7652__auto___34960 = G__34961;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.widgets.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.widgets.get.cljs$core$IFn$_invoke$arity$variadic = (function (widget_id,p__34956){
var map__34957 = p__34956;
var map__34957__$1 = ((((!((map__34957 == null)))?((((map__34957.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34957.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34957):map__34957);
var with_data_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34957__$1,cljs.core.cst$kw$with_DASH_data_QMARK_);
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["widgets",[cljs.core.str(widget_id),cljs.core.str((cljs.core.truth_(with_data_QMARK_)?"?data=true":null))].join('')], 0)));
});

milia.api.widgets.get.cljs$lang$maxFixedArity = (1);

milia.api.widgets.get.cljs$lang$applyTo = (function (seq34954){
var G__34955 = cljs.core.first(seq34954);
var seq34954__$1 = cljs.core.next(seq34954);
return milia.api.widgets.get.cljs$core$IFn$_invoke$arity$variadic(G__34955,seq34954__$1);
});

