// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
var G__34732 = http_options__$1;
if(cljs.core.truth_((function (){var and__6531__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return (cljs.core.not(cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1))) && (cljs.core.not(stateful_method_QMARK_));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.assoc_in(G__34732,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__34733 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__34733) : cljs_hash.md5.md5.call(null,G__34733));
})());
} else {
return G__34732;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34738 = arguments.length;
var i__7652__auto___34739 = (0);
while(true){
if((i__7652__auto___34739 < len__7651__auto___34738)){
args__7658__auto__.push((arguments[i__7652__auto___34739]));

var G__34740 = (i__7652__auto___34739 + (1));
i__7652__auto___34739 = G__34740;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__34735){
var map__34736 = p__34735;
var map__34736__$1 = ((((!((map__34736 == null)))?((((map__34736.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34736.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34736):map__34736);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34736__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34736__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34736__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34736__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("Token "),cljs.core.str(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__6531__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__6531__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4657__auto__ = (function (){var and__6531__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var crsf_token = temp__4657__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__6543__auto__ = accept_header;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq34734){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34734));
});

/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34750 = arguments.length;
var i__7652__auto___34751 = (0);
while(true){
if((i__7652__auto___34751 < len__7651__auto___34750)){
args__7658__auto__.push((arguments[i__7652__auto___34751]));

var G__34752 = (i__7652__auto___34751 + (1));
i__7652__auto___34751 = G__34752;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__34743){
var vec__34744 = p__34743;
var map__34747 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34744,(0),null);
var map__34747__$1 = ((((!((map__34747 == null)))?((((map__34747.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34747.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34747):map__34747);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34747__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e34749){if((e34749 instanceof Error)){
var _ = e34749;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e34749;

}
}} else {
return io_obj.getResponseText();
}
});

milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1);

milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq34741){
var G__34742 = cljs.core.first(seq34741);
var seq34741__$1 = cljs.core.next(seq34741);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(G__34742,seq34741__$1);
});

milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
var G__34759_34765 = io_obj;
var G__34760_34766 = goog.net.EventType.SUCCESS;
var G__34761_34767 = ((function (G__34759_34765,G__34760_34766,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__34759_34765,G__34760_34766,io_obj))
;
goog.events.listen(G__34759_34765,G__34760_34766,G__34761_34767);

var G__34762_34768 = io_obj;
var G__34763_34769 = goog.net.EventType.ERROR;
var G__34764_34770 = ((function (G__34762_34768,G__34763_34769,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__34762_34768,G__34763_34769,io_obj))
;
goog.events.listen(G__34762_34768,G__34763_34769,G__34764_34770);

return io_obj.sendFromForm(form,[cljs.core.str(form_api),cljs.core.str("?legacy=true")].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://goo.gl/B0fm2a
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34787 = arguments.length;
var i__7652__auto___34788 = (0);
while(true){
if((i__7652__auto___34788 < len__7651__auto___34787)){
args__7658__auto__.push((arguments[i__7652__auto___34788]));

var G__34789 = (i__7652__auto___34788 + (1));
i__7652__auto___34788 = G__34789;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__34775){
var map__34776 = p__34775;
var map__34776__$1 = ((((!((map__34776 == null)))?((((map__34776.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34776.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34776):map__34776);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34776__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34776__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34776__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

var G__34778_34790 = io_obj;
var G__34779_34791 = goog.net.EventType.SUCCESS;
var G__34780_34792 = ((function (G__34778_34790,G__34779_34791,io_obj,data,url,map__34776,map__34776__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,true], 0)));
});})(G__34778_34790,G__34779_34791,io_obj,data,url,map__34776,map__34776__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__34778_34790,G__34779_34791,G__34780_34792);

var G__34781_34793 = io_obj;
var G__34782_34794 = goog.net.EventType.ERROR;
var G__34783_34795 = ((function (G__34781_34793,G__34782_34794,io_obj,data,url,map__34776,map__34776__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,false], 0)));
});})(G__34781_34793,G__34782_34794,io_obj,data,url,map__34776,map__34776__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__34781_34793,G__34782_34794,G__34783_34795);

var G__34784_34796 = io_obj;
var G__34785_34797 = goog.net.EventType.PROGRESS;
var G__34786_34798 = ((function (G__34784_34796,G__34785_34797,io_obj,data,url,map__34776,map__34776__$1,headers,id,require_json_QMARK_){
return (function (p1__34771_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__34771_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__34771_SHARP_.loaded,cljs.core.cst$kw$total,p1__34771_SHARP_.total], null)));
});})(G__34784_34796,G__34785_34797,io_obj,data,url,map__34776,map__34776__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__34784_34796,G__34785_34797,G__34786_34798);

io_obj.send(url,"POST",form,headers);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq34772){
var G__34773 = cljs.core.first(seq34772);
var seq34772__$1 = cljs.core.next(seq34772);
var G__34774 = cljs.core.first(seq34772__$1);
var seq34772__$2 = cljs.core.next(seq34772__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__34773,G__34774,seq34772__$2);
});

/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34863 = arguments.length;
var i__7652__auto___34864 = (0);
while(true){
if((i__7652__auto___34864 < len__7651__auto___34863)){
args__7658__auto__.push((arguments[i__7652__auto___34864]));

var G__34865 = (i__7652__auto___34864 + (1));
i__7652__auto___34864 = G__34865;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__19089__auto___34866 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___34866,response_channel){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___34866,response_channel){
return (function (state_34836){
var state_val_34837 = (state_34836[(1)]);
if((state_val_34837 === (7))){
var state_34836__$1 = state_34836;
var statearr_34838_34867 = state_34836__$1;
(statearr_34838_34867[(2)] = false);

(statearr_34838_34867[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34837 === (1))){
var inst_34802 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_34836__$1 = state_34836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34836__$1,(2),inst_34802);
} else {
if((state_val_34837 === (4))){
var state_34836__$1 = state_34836;
var statearr_34839_34868 = state_34836__$1;
(statearr_34839_34868[(2)] = false);

(statearr_34839_34868[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34837 === (13))){
var inst_34825 = (state_34836[(7)]);
var inst_34832 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_34825);
var state_34836__$1 = state_34836;
var statearr_34840_34869 = state_34836__$1;
(statearr_34840_34869[(2)] = inst_34832);

(statearr_34840_34869[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34837 === (6))){
var state_34836__$1 = state_34836;
var statearr_34841_34870 = state_34836__$1;
(statearr_34841_34870[(2)] = true);

(statearr_34841_34870[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34837 === (3))){
var inst_34804 = (state_34836[(8)]);
var inst_34809 = inst_34804.cljs$lang$protocol_mask$partition0$;
var inst_34810 = (inst_34809 & (64));
var inst_34811 = inst_34804.cljs$core$ISeq$;
var inst_34812 = (cljs.core.PROTOCOL_SENTINEL === inst_34811);
var inst_34813 = (inst_34810) || (inst_34812);
var state_34836__$1 = state_34836;
if(cljs.core.truth_(inst_34813)){
var statearr_34842_34871 = state_34836__$1;
(statearr_34842_34871[(1)] = (6));

} else {
var statearr_34843_34872 = state_34836__$1;
(statearr_34843_34872[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34837 === (12))){
var inst_34829 = window.location.href();
var inst_34830 = window.location = inst_34829;
var state_34836__$1 = state_34836;
var statearr_34844_34873 = state_34836__$1;
(statearr_34844_34873[(2)] = inst_34830);

(statearr_34844_34873[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34837 === (2))){
var inst_34804 = (state_34836[(8)]);
var inst_34804__$1 = (state_34836[(2)]);
var inst_34806 = (inst_34804__$1 == null);
var inst_34807 = cljs.core.not(inst_34806);
var state_34836__$1 = (function (){var statearr_34845 = state_34836;
(statearr_34845[(8)] = inst_34804__$1);

return statearr_34845;
})();
if(inst_34807){
var statearr_34846_34874 = state_34836__$1;
(statearr_34846_34874[(1)] = (3));

} else {
var statearr_34847_34875 = state_34836__$1;
(statearr_34847_34875[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34837 === (11))){
var inst_34825 = (state_34836[(7)]);
var inst_34825__$1 = (state_34836[(2)]);
var inst_34826 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34825__$1,cljs.core.cst$kw$status);
var inst_34827 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34826,(401));
var state_34836__$1 = (function (){var statearr_34848 = state_34836;
(statearr_34848[(7)] = inst_34825__$1);

return statearr_34848;
})();
if(inst_34827){
var statearr_34849_34876 = state_34836__$1;
(statearr_34849_34876[(1)] = (12));

} else {
var statearr_34850_34877 = state_34836__$1;
(statearr_34850_34877[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34837 === (9))){
var inst_34804 = (state_34836[(8)]);
var inst_34822 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_34804);
var state_34836__$1 = state_34836;
var statearr_34851_34878 = state_34836__$1;
(statearr_34851_34878[(2)] = inst_34822);

(statearr_34851_34878[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34837 === (5))){
var inst_34820 = (state_34836[(2)]);
var state_34836__$1 = state_34836;
if(cljs.core.truth_(inst_34820)){
var statearr_34852_34879 = state_34836__$1;
(statearr_34852_34879[(1)] = (9));

} else {
var statearr_34853_34880 = state_34836__$1;
(statearr_34853_34880[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34837 === (14))){
var inst_34834 = (state_34836[(2)]);
var state_34836__$1 = state_34836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34836__$1,inst_34834);
} else {
if((state_val_34837 === (10))){
var inst_34804 = (state_34836[(8)]);
var state_34836__$1 = state_34836;
var statearr_34854_34881 = state_34836__$1;
(statearr_34854_34881[(2)] = inst_34804);

(statearr_34854_34881[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34837 === (8))){
var inst_34817 = (state_34836[(2)]);
var state_34836__$1 = state_34836;
var statearr_34855_34882 = state_34836__$1;
(statearr_34855_34882[(2)] = inst_34817);

(statearr_34855_34882[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___34866,response_channel))
;
return ((function (switch__18977__auto__,c__19089__auto___34866,response_channel){
return (function() {
var milia$api$io$state_machine__18978__auto__ = null;
var milia$api$io$state_machine__18978__auto____0 = (function (){
var statearr_34859 = [null,null,null,null,null,null,null,null,null];
(statearr_34859[(0)] = milia$api$io$state_machine__18978__auto__);

(statearr_34859[(1)] = (1));

return statearr_34859;
});
var milia$api$io$state_machine__18978__auto____1 = (function (state_34836){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_34836);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e34860){if((e34860 instanceof Object)){
var ex__18981__auto__ = e34860;
var statearr_34861_34883 = state_34836;
(statearr_34861_34883[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34836);

return cljs.core.cst$kw$recur;
} else {
throw e34860;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__34884 = state_34836;
state_34836 = G__34884;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
milia$api$io$state_machine__18978__auto__ = function(state_34836){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__18978__auto____0.call(this);
case 1:
return milia$api$io$state_machine__18978__auto____1.call(this,state_34836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__18978__auto____0;
milia$api$io$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__18978__auto____1;
return milia$api$io$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___34866,response_channel))
})();
var state__19091__auto__ = (function (){var statearr_34862 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_34862[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___34866);

return statearr_34862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___34866,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq34799){
var G__34800 = cljs.core.first(seq34799);
var seq34799__$1 = cljs.core.next(seq34799);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__34800,seq34799__$1);
});

