// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.charts');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
milia.api.charts.format = goog.string.format;
milia.api.charts.suffix = (function milia$api$charts$suffix(var_args){
var args35287 = [];
var len__7651__auto___35290 = arguments.length;
var i__7652__auto___35291 = (0);
while(true){
if((i__7652__auto___35291 < len__7651__auto___35290)){
args35287.push((arguments[i__7652__auto___35291]));

var G__35292 = (i__7652__auto___35291 + (1));
i__7652__auto___35291 = G__35292;
continue;
} else {
}
break;
}

var G__35289 = args35287.length;
switch (G__35289) {
case 1:
return milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35287.length)].join('')));

}
});

milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
return [cljs.core.str(dataset_id),cljs.core.str(".json")].join('');
});

milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,field_name){
var field_s = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(field_name,"all"))?"fields":"field_name");
return [cljs.core.str(dataset_id),cljs.core.str(".json?"),cljs.core.str(field_s),cljs.core.str("="),cljs.core.str(field_name)].join('');
});

milia.api.charts.suffix.cljs$lang$maxFixedArity = 2;

/**
 * Get list of chart fields for a specific dataset
 */
milia.api.charts.fields = (function milia$api$charts$fields(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["charts",milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1(dataset_id)], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Get chart for a specific field in a dataset
 */
milia.api.charts.chart = (function milia$api$charts$chart(var_args){
var args35294 = [];
var len__7651__auto___35297 = arguments.length;
var i__7652__auto___35298 = (0);
while(true){
if((i__7652__auto___35298 < len__7651__auto___35297)){
args35294.push((arguments[i__7652__auto___35298]));

var G__35299 = (i__7652__auto___35298 + (1));
i__7652__auto___35298 = G__35299;
continue;
} else {
}
break;
}

var G__35296 = args35294.length;
switch (G__35296) {
case 1:
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35294.length)].join('')));

}
});

milia.api.charts.chart.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2(dataset_id,"all");
});

milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,field_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["charts",milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2(dataset_id,field_name)], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.charts.chart.cljs$lang$maxFixedArity = 2;

/**
 * Given a field name, return chart data associated with a dataset or dataview
 */
milia.api.charts.get = (function milia$api$charts$get(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35306 = arguments.length;
var i__7652__auto___35307 = (0);
while(true){
if((i__7652__auto___35307 < len__7651__auto___35306)){
args__7658__auto__.push((arguments[i__7652__auto___35307]));

var G__35308 = (i__7652__auto___35307 + (1));
i__7652__auto___35307 = G__35308;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.charts.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.charts.get.cljs$core$IFn$_invoke$arity$variadic = (function (field_name,p__35303){
var map__35304 = p__35303;
var map__35304__$1 = ((((!((map__35304 == null)))?((((map__35304.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35304.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35304):map__35304);
var dataview_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35304__$1,cljs.core.cst$kw$dataview_DASH_id);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35304__$1,cljs.core.cst$kw$dataset_DASH_id);
var group_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35304__$1,cljs.core.cst$kw$group_DASH_by);
var id = (function (){var or__6543__auto__ = dataview_id;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return dataset_id;
}
})();
var base_url_template = (cljs.core.truth_(dataview_id)?"dataviews/%s/charts.json?field_name=%s":"charts/%s.json?field_name=%s");
var url_template = [cljs.core.str(base_url_template),cljs.core.str((cljs.core.truth_(group_by)?"&group_by=%s":null))].join('');
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(milia.api.charts.format.cljs$core$IFn$_invoke$arity$4 ? milia.api.charts.format.cljs$core$IFn$_invoke$arity$4(url_template,id,field_name,group_by) : milia.api.charts.format.call(null,url_template,id,field_name,group_by))], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.charts.get.cljs$lang$maxFixedArity = (1);

milia.api.charts.get.cljs$lang$applyTo = (function (seq35301){
var G__35302 = cljs.core.first(seq35301);
var seq35301__$1 = cljs.core.next(seq35301);
return milia.api.charts.get.cljs$core$IFn$_invoke$arity$variadic(G__35302,seq35301__$1);
});

