// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.project');
goog.require('cljs.core');
goog.require('chimera.urls');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.metadata');
goog.require('milia.utils.remote');
/**
 * Parse and add the projects ID.
 */
milia.api.project.add_id = (function milia$api$project$add_id(project_data){
if(typeof project_data === 'string'){
return null;
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([project_data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,chimera.urls.last_url_param(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(project_data))], null)], 0));
}
});
/**
 * Get the forms for this account and owner of the user.
 */
milia.api.project.get_forms = (function milia$api$project$get_forms(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"forms"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.project.get_project = (function milia$api$project$get_project(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35190 = arguments.length;
var i__7652__auto___35191 = (0);
while(true){
if((i__7652__auto___35191 < len__7651__auto___35190)){
args__7658__auto__.push((arguments[i__7652__auto___35191]));

var G__35192 = (i__7652__auto___35191 + (1));
i__7652__auto___35191 = G__35192;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__35187){
var map__35188 = p__35187;
var map__35188__$1 = ((((!((map__35188 == null)))?((((map__35188.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35188.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35188):map__35188);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35188__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
var data = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
return data;
});

milia.api.project.get_project.cljs$lang$maxFixedArity = (1);

milia.api.project.get_project.cljs$lang$applyTo = (function (seq35185){
var G__35186 = cljs.core.first(seq35185);
var seq35185__$1 = cljs.core.next(seq35185);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic(G__35186,seq35185__$1);
});

/**
 * Return all project for this account and owner or the user.
 */
milia.api.project.all = (function milia$api$project$all(var_args){
var args35195 = [];
var len__7651__auto___35203 = arguments.length;
var i__7652__auto___35204 = (0);
while(true){
if((i__7652__auto___35204 < len__7651__auto___35203)){
args35195.push((arguments[i__7652__auto___35204]));

var G__35205 = (i__7652__auto___35204 + (1));
i__7652__auto___35204 = G__35205;
continue;
} else {
}
break;
}

var G__35199 = args35195.length;
switch (G__35199) {
case 0:
return milia.api.project.all.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args35195.slice((1)),(0),null));
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7670__auto__);

}
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.project.all(null);
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic = (function (owner,p__35200){
var map__35201 = p__35200;
var map__35201__$1 = ((((!((map__35201 == null)))?((((map__35201.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35201.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35201):map__35201);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35201__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var logged_in_username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35201__$1,cljs.core.cst$kw$logged_DASH_in_DASH_username);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
var options = ((function (url,map__35201,map__35201__$1,no_cache_QMARK_,logged_in_username){
return (function (p1__35194_SHARP_){
if(cljs.core.truth_(logged_in_username)){
return cljs.core.assoc_in(p1__35194_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$u], null),logged_in_username);
} else {
return p1__35194_SHARP_;
}
});})(url,map__35201,map__35201__$1,no_cache_QMARK_,logged_in_username))
.call(null,((function (url,map__35201,map__35201__$1,no_cache_QMARK_,logged_in_username){
return (function (p1__35193_SHARP_){
if(cljs.core.truth_(owner)){
return cljs.core.assoc_in(p1__35193_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$owner], null),owner);
} else {
return p1__35193_SHARP_;
}
});})(url,map__35201,map__35201__$1,no_cache_QMARK_,logged_in_username))
.call(null,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,null], null)));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.project.all.cljs$lang$applyTo = (function (seq35196){
var G__35197 = cljs.core.first(seq35196);
var seq35196__$1 = cljs.core.next(seq35196);
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic(G__35197,seq35196__$1);
});

milia.api.project.all.cljs$lang$maxFixedArity = (1);

/**
 * Create a project for this account and owner or the user.
 */
milia.api.project.create = (function milia$api$project$create(data,owner){
var owner_url = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",owner], 0))], null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
var form_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([owner_url,data], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,form_params], null)], 0));
});
/**
 * Update project metadata
 */
milia.api.project.update = (function milia$api$project$update(project_id,data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,data], null)], 0));
});
/**
 * Share project with specific user or remove specific user from project
 */
milia.api.project.share = (function milia$api$project$share(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35215 = arguments.length;
var i__7652__auto___35216 = (0);
while(true){
if((i__7652__auto___35216 < len__7651__auto___35215)){
args__7658__auto__.push((arguments[i__7652__auto___35216]));

var G__35217 = (i__7652__auto___35216 + (1));
i__7652__auto___35216 = G__35217;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,username,role,p__35211){
var vec__35212 = p__35211;
var remove_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35212,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id,"share"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$role,role], null);
var form_params = (cljs.core.truth_(remove_QMARK_)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$remove,"True"], null)], 0)):data);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
});

milia.api.project.share.cljs$lang$maxFixedArity = (3);

milia.api.project.share.cljs$lang$applyTo = (function (seq35207){
var G__35208 = cljs.core.first(seq35207);
var seq35207__$1 = cljs.core.next(seq35207);
var G__35209 = cljs.core.first(seq35207__$1);
var seq35207__$2 = cljs.core.next(seq35207__$1);
var G__35210 = cljs.core.first(seq35207__$2);
var seq35207__$3 = cljs.core.next(seq35207__$2);
return milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic(G__35208,G__35209,G__35210,seq35207__$3);
});

/**
 * Add tags to a project.
 */
milia.api.project.add_tags = (function milia$api$project$add_tags(id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"labels"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null),cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Get projects with given tags.
 */
milia.api.project.with_tag = (function milia$api$project$with_tag(tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null)], null)], 0));
});
/**
 * Add star to project for this user.
 */
milia.api.project.add_star = (function milia$api$project$add_star(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35223 = arguments.length;
var i__7652__auto___35224 = (0);
while(true){
if((i__7652__auto___35224 < len__7651__auto___35223)){
args__7658__auto__.push((arguments[i__7652__auto___35224]));

var G__35225 = (i__7652__auto___35224 + (1));
i__7652__auto___35224 = G__35225;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__35220){
var map__35221 = p__35220;
var map__35221__$1 = ((((!((map__35221 == null)))?((((map__35221.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35221.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35221):map__35221);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35221__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$callback,callback], 0));
});

milia.api.project.add_star.cljs$lang$maxFixedArity = (1);

milia.api.project.add_star.cljs$lang$applyTo = (function (seq35218){
var G__35219 = cljs.core.first(seq35218);
var seq35218__$1 = cljs.core.next(seq35218);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic(G__35219,seq35218__$1);
});

/**
 * Remove star from project for this user.
 */
milia.api.project.remove_star = (function milia$api$project$remove_star(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35231 = arguments.length;
var i__7652__auto___35232 = (0);
while(true){
if((i__7652__auto___35232 < len__7651__auto___35231)){
args__7658__auto__.push((arguments[i__7652__auto___35232]));

var G__35233 = (i__7652__auto___35232 + (1));
i__7652__auto___35232 = G__35233;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__35228){
var map__35229 = p__35228;
var map__35229__$1 = ((((!((map__35229 == null)))?((((map__35229.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35229.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35229):map__35229);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35229__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$delete,url,cljs.core.array_seq([cljs.core.cst$kw$callback,callback], 0));
});

milia.api.project.remove_star.cljs$lang$maxFixedArity = (1);

milia.api.project.remove_star.cljs$lang$applyTo = (function (seq35226){
var G__35227 = cljs.core.first(seq35226);
var seq35226__$1 = cljs.core.next(seq35226);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic(G__35227,seq35226__$1);
});

/**
 * Toggle between starred and unstarred for a user's project
 */
milia.api.project.toggle_star = (function milia$api$project$toggle_star(id,star_QMARK_,callback){
return (cljs.core.truth_(star_QMARK_)?milia.api.project.add_star:milia.api.project.remove_star).call(null,id,cljs.core.cst$kw$callback,callback);
});
/**
 * Get projects this user has starred.
 */
milia.api.project.get_starred = (function milia$api$project$get_starred(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user",username,"starred"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Get user that starred this project.
 */
milia.api.project.starred_by = (function milia$api$project$starred_by(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Delete a project
 */
milia.api.project.delete$ = (function milia$api$project$delete(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Set new project owner
 */
milia.api.project.transfer_owner = (function milia$api$project$transfer_owner(id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",new_owner], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,new_owner__$1], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,form_params,cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Update the project public setting.
 */
milia.api.project.update_public = (function milia$api$project$update_public(projectid,public$){
return milia.api.project.update(projectid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$public,public$], null));
});
milia.api.project.files = (function milia$api$project$files(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35239 = arguments.length;
var i__7652__auto___35240 = (0);
while(true){
if((i__7652__auto___35240 < len__7651__auto___35239)){
args__7658__auto__.push((arguments[i__7652__auto___35240]));

var G__35241 = (i__7652__auto___35240 + (1));
i__7652__auto___35240 = G__35241;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,p__35236){
var map__35237 = p__35236;
var map__35237__$1 = ((((!((map__35237 == null)))?((((map__35237.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35237.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35237):map__35237);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35237__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.utils.metadata.metadata_files(cljs.core.cst$kw$project,project_id,no_cache_QMARK_);
});

milia.api.project.files.cljs$lang$maxFixedArity = (1);

milia.api.project.files.cljs$lang$applyTo = (function (seq35234){
var G__35235 = cljs.core.first(seq35234);
var seq35234__$1 = cljs.core.next(seq35234);
return milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic(G__35235,seq35234__$1);
});

