// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args31321 = [];
var len__7651__auto___31327 = arguments.length;
var i__7652__auto___31328 = (0);
while(true){
if((i__7652__auto___31328 < len__7651__auto___31327)){
args31321.push((arguments[i__7652__auto___31328]));

var G__31329 = (i__7652__auto___31328 + (1));
i__7652__auto___31328 = G__31329;
continue;
} else {
}
break;
}

var G__31323 = args31321.length;
switch (G__31323) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31321.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async31324 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31324 = (function (f,blockable,meta31325){
this.f = f;
this.blockable = blockable;
this.meta31325 = meta31325;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31324.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31326,meta31325__$1){
var self__ = this;
var _31326__$1 = this;
return (new cljs.core.async.t_cljs$core$async31324(self__.f,self__.blockable,meta31325__$1));
});

cljs.core.async.t_cljs$core$async31324.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31326){
var self__ = this;
var _31326__$1 = this;
return self__.meta31325;
});

cljs.core.async.t_cljs$core$async31324.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31324.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31324.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async31324.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async31324.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta31325], null);
});

cljs.core.async.t_cljs$core$async31324.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31324.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31324";

cljs.core.async.t_cljs$core$async31324.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async31324");
});

cljs.core.async.__GT_t_cljs$core$async31324 = (function cljs$core$async$__GT_t_cljs$core$async31324(f__$1,blockable__$1,meta31325){
return (new cljs.core.async.t_cljs$core$async31324(f__$1,blockable__$1,meta31325));
});

}

return (new cljs.core.async.t_cljs$core$async31324(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args31333 = [];
var len__7651__auto___31336 = arguments.length;
var i__7652__auto___31337 = (0);
while(true){
if((i__7652__auto___31337 < len__7651__auto___31336)){
args31333.push((arguments[i__7652__auto___31337]));

var G__31338 = (i__7652__auto___31337 + (1));
i__7652__auto___31337 = G__31338;
continue;
} else {
}
break;
}

var G__31335 = args31333.length;
switch (G__31335) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31333.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args31340 = [];
var len__7651__auto___31343 = arguments.length;
var i__7652__auto___31344 = (0);
while(true){
if((i__7652__auto___31344 < len__7651__auto___31343)){
args31340.push((arguments[i__7652__auto___31344]));

var G__31345 = (i__7652__auto___31344 + (1));
i__7652__auto___31344 = G__31345;
continue;
} else {
}
break;
}

var G__31342 = args31340.length;
switch (G__31342) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31340.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args31347 = [];
var len__7651__auto___31350 = arguments.length;
var i__7652__auto___31351 = (0);
while(true){
if((i__7652__auto___31351 < len__7651__auto___31350)){
args31347.push((arguments[i__7652__auto___31351]));

var G__31352 = (i__7652__auto___31351 + (1));
i__7652__auto___31351 = G__31352;
continue;
} else {
}
break;
}

var G__31349 = args31347.length;
switch (G__31349) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31347.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_31354 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31354) : fn1.call(null,val_31354));
} else {
cljs.core.async.impl.dispatch.run(((function (val_31354,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31354) : fn1.call(null,val_31354));
});})(val_31354,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args31355 = [];
var len__7651__auto___31358 = arguments.length;
var i__7652__auto___31359 = (0);
while(true){
if((i__7652__auto___31359 < len__7651__auto___31358)){
args31355.push((arguments[i__7652__auto___31359]));

var G__31360 = (i__7652__auto___31359 + (1));
i__7652__auto___31359 = G__31360;
continue;
} else {
}
break;
}

var G__31357 = args31355.length;
switch (G__31357) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31355.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7461__auto___31362 = n;
var x_31363 = (0);
while(true){
if((x_31363 < n__7461__auto___31362)){
(a[x_31363] = (0));

var G__31364 = (x_31363 + (1));
x_31363 = G__31364;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__31365 = (i + (1));
i = G__31365;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async31369 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31369 = (function (flag,meta31370){
this.flag = flag;
this.meta31370 = meta31370;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31369.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31371,meta31370__$1){
var self__ = this;
var _31371__$1 = this;
return (new cljs.core.async.t_cljs$core$async31369(self__.flag,meta31370__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31369.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31371){
var self__ = this;
var _31371__$1 = this;
return self__.meta31370;
});})(flag))
;

cljs.core.async.t_cljs$core$async31369.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31369.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async31369.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31369.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31369.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta31370], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31369.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31369.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31369";

cljs.core.async.t_cljs$core$async31369.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async31369");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31369 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31369(flag__$1,meta31370){
return (new cljs.core.async.t_cljs$core$async31369(flag__$1,meta31370));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31369(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31375 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31375 = (function (flag,cb,meta31376){
this.flag = flag;
this.cb = cb;
this.meta31376 = meta31376;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31375.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31377,meta31376__$1){
var self__ = this;
var _31377__$1 = this;
return (new cljs.core.async.t_cljs$core$async31375(self__.flag,self__.cb,meta31376__$1));
});

cljs.core.async.t_cljs$core$async31375.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31377){
var self__ = this;
var _31377__$1 = this;
return self__.meta31376;
});

cljs.core.async.t_cljs$core$async31375.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31375.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async31375.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31375.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31375.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta31376], null);
});

cljs.core.async.t_cljs$core$async31375.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31375.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31375";

cljs.core.async.t_cljs$core$async31375.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async31375");
});

cljs.core.async.__GT_t_cljs$core$async31375 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31375(flag__$1,cb__$1,meta31376){
return (new cljs.core.async.t_cljs$core$async31375(flag__$1,cb__$1,meta31376));
});

}

return (new cljs.core.async.t_cljs$core$async31375(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31378_SHARP_){
var G__31382 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31378_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31382) : fret.call(null,G__31382));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31379_SHARP_){
var G__31383 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31379_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31383) : fret.call(null,G__31383));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6543__auto__ = wport;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31384 = (i + (1));
i = G__31384;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6543__auto__ = ret;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6531__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31390 = arguments.length;
var i__7652__auto___31391 = (0);
while(true){
if((i__7652__auto___31391 < len__7651__auto___31390)){
args__7658__auto__.push((arguments[i__7652__auto___31391]));

var G__31392 = (i__7652__auto___31391 + (1));
i__7652__auto___31391 = G__31392;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31387){
var map__31388 = p__31387;
var map__31388__$1 = ((((!((map__31388 == null)))?((((map__31388.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31388.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31388):map__31388);
var opts = map__31388__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31385){
var G__31386 = cljs.core.first(seq31385);
var seq31385__$1 = cljs.core.next(seq31385);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31386,seq31385__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args31393 = [];
var len__7651__auto___31443 = arguments.length;
var i__7652__auto___31444 = (0);
while(true){
if((i__7652__auto___31444 < len__7651__auto___31443)){
args31393.push((arguments[i__7652__auto___31444]));

var G__31445 = (i__7652__auto___31444 + (1));
i__7652__auto___31444 = G__31445;
continue;
} else {
}
break;
}

var G__31395 = args31393.length;
switch (G__31395) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31393.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__19089__auto___31447 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___31447){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___31447){
return (function (state_31419){
var state_val_31420 = (state_31419[(1)]);
if((state_val_31420 === (7))){
var inst_31415 = (state_31419[(2)]);
var state_31419__$1 = state_31419;
var statearr_31421_31448 = state_31419__$1;
(statearr_31421_31448[(2)] = inst_31415);

(statearr_31421_31448[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31420 === (1))){
var state_31419__$1 = state_31419;
var statearr_31422_31449 = state_31419__$1;
(statearr_31422_31449[(2)] = null);

(statearr_31422_31449[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31420 === (4))){
var inst_31398 = (state_31419[(7)]);
var inst_31398__$1 = (state_31419[(2)]);
var inst_31399 = (inst_31398__$1 == null);
var state_31419__$1 = (function (){var statearr_31423 = state_31419;
(statearr_31423[(7)] = inst_31398__$1);

return statearr_31423;
})();
if(cljs.core.truth_(inst_31399)){
var statearr_31424_31450 = state_31419__$1;
(statearr_31424_31450[(1)] = (5));

} else {
var statearr_31425_31451 = state_31419__$1;
(statearr_31425_31451[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31420 === (13))){
var state_31419__$1 = state_31419;
var statearr_31426_31452 = state_31419__$1;
(statearr_31426_31452[(2)] = null);

(statearr_31426_31452[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31420 === (6))){
var inst_31398 = (state_31419[(7)]);
var state_31419__$1 = state_31419;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31419__$1,(11),to,inst_31398);
} else {
if((state_val_31420 === (3))){
var inst_31417 = (state_31419[(2)]);
var state_31419__$1 = state_31419;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31419__$1,inst_31417);
} else {
if((state_val_31420 === (12))){
var state_31419__$1 = state_31419;
var statearr_31427_31453 = state_31419__$1;
(statearr_31427_31453[(2)] = null);

(statearr_31427_31453[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31420 === (2))){
var state_31419__$1 = state_31419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31419__$1,(4),from);
} else {
if((state_val_31420 === (11))){
var inst_31408 = (state_31419[(2)]);
var state_31419__$1 = state_31419;
if(cljs.core.truth_(inst_31408)){
var statearr_31428_31454 = state_31419__$1;
(statearr_31428_31454[(1)] = (12));

} else {
var statearr_31429_31455 = state_31419__$1;
(statearr_31429_31455[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31420 === (9))){
var state_31419__$1 = state_31419;
var statearr_31430_31456 = state_31419__$1;
(statearr_31430_31456[(2)] = null);

(statearr_31430_31456[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31420 === (5))){
var state_31419__$1 = state_31419;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31431_31457 = state_31419__$1;
(statearr_31431_31457[(1)] = (8));

} else {
var statearr_31432_31458 = state_31419__$1;
(statearr_31432_31458[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31420 === (14))){
var inst_31413 = (state_31419[(2)]);
var state_31419__$1 = state_31419;
var statearr_31433_31459 = state_31419__$1;
(statearr_31433_31459[(2)] = inst_31413);

(statearr_31433_31459[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31420 === (10))){
var inst_31405 = (state_31419[(2)]);
var state_31419__$1 = state_31419;
var statearr_31434_31460 = state_31419__$1;
(statearr_31434_31460[(2)] = inst_31405);

(statearr_31434_31460[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31420 === (8))){
var inst_31402 = cljs.core.async.close_BANG_(to);
var state_31419__$1 = state_31419;
var statearr_31435_31461 = state_31419__$1;
(statearr_31435_31461[(2)] = inst_31402);

(statearr_31435_31461[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___31447))
;
return ((function (switch__18977__auto__,c__19089__auto___31447){
return (function() {
var cljs$core$async$state_machine__18978__auto__ = null;
var cljs$core$async$state_machine__18978__auto____0 = (function (){
var statearr_31439 = [null,null,null,null,null,null,null,null];
(statearr_31439[(0)] = cljs$core$async$state_machine__18978__auto__);

(statearr_31439[(1)] = (1));

return statearr_31439;
});
var cljs$core$async$state_machine__18978__auto____1 = (function (state_31419){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_31419);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e31440){if((e31440 instanceof Object)){
var ex__18981__auto__ = e31440;
var statearr_31441_31462 = state_31419;
(statearr_31441_31462[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31419);

return cljs.core.cst$kw$recur;
} else {
throw e31440;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__31463 = state_31419;
state_31419 = G__31463;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$state_machine__18978__auto__ = function(state_31419){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18978__auto____1.call(this,state_31419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18978__auto____0;
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18978__auto____1;
return cljs$core$async$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___31447))
})();
var state__19091__auto__ = (function (){var statearr_31442 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_31442[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___31447);

return statearr_31442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___31447))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__31651){
var vec__31652 = p__31651;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31652,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31652,(1),null);
var job = vec__31652;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__19089__auto___31838 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___31838,res,vec__31652,v,p,job,jobs,results){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___31838,res,vec__31652,v,p,job,jobs,results){
return (function (state_31659){
var state_val_31660 = (state_31659[(1)]);
if((state_val_31660 === (1))){
var state_31659__$1 = state_31659;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31659__$1,(2),res,v);
} else {
if((state_val_31660 === (2))){
var inst_31656 = (state_31659[(2)]);
var inst_31657 = cljs.core.async.close_BANG_(res);
var state_31659__$1 = (function (){var statearr_31661 = state_31659;
(statearr_31661[(7)] = inst_31656);

return statearr_31661;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_31659__$1,inst_31657);
} else {
return null;
}
}
});})(c__19089__auto___31838,res,vec__31652,v,p,job,jobs,results))
;
return ((function (switch__18977__auto__,c__19089__auto___31838,res,vec__31652,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0 = (function (){
var statearr_31665 = [null,null,null,null,null,null,null,null];
(statearr_31665[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__);

(statearr_31665[(1)] = (1));

return statearr_31665;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1 = (function (state_31659){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_31659);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e31666){if((e31666 instanceof Object)){
var ex__18981__auto__ = e31666;
var statearr_31667_31839 = state_31659;
(statearr_31667_31839[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31659);

return cljs.core.cst$kw$recur;
} else {
throw e31666;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__31840 = state_31659;
state_31659 = G__31840;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__ = function(state_31659){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1.call(this,state_31659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___31838,res,vec__31652,v,p,job,jobs,results))
})();
var state__19091__auto__ = (function (){var statearr_31668 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_31668[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___31838);

return statearr_31668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___31838,res,vec__31652,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31669){
var vec__31670 = p__31669;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31670,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31670,(1),null);
var job = vec__31670;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7461__auto___31841 = n;
var __31842 = (0);
while(true){
if((__31842 < n__7461__auto___31841)){
var G__31673_31843 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__31673_31843) {
case "compute":
var c__19089__auto___31845 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31842,c__19089__auto___31845,G__31673_31843,n__7461__auto___31841,jobs,results,process,async){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (__31842,c__19089__auto___31845,G__31673_31843,n__7461__auto___31841,jobs,results,process,async){
return (function (state_31686){
var state_val_31687 = (state_31686[(1)]);
if((state_val_31687 === (1))){
var state_31686__$1 = state_31686;
var statearr_31688_31846 = state_31686__$1;
(statearr_31688_31846[(2)] = null);

(statearr_31688_31846[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31687 === (2))){
var state_31686__$1 = state_31686;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31686__$1,(4),jobs);
} else {
if((state_val_31687 === (3))){
var inst_31684 = (state_31686[(2)]);
var state_31686__$1 = state_31686;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31686__$1,inst_31684);
} else {
if((state_val_31687 === (4))){
var inst_31676 = (state_31686[(2)]);
var inst_31677 = process(inst_31676);
var state_31686__$1 = state_31686;
if(cljs.core.truth_(inst_31677)){
var statearr_31689_31847 = state_31686__$1;
(statearr_31689_31847[(1)] = (5));

} else {
var statearr_31690_31848 = state_31686__$1;
(statearr_31690_31848[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31687 === (5))){
var state_31686__$1 = state_31686;
var statearr_31691_31849 = state_31686__$1;
(statearr_31691_31849[(2)] = null);

(statearr_31691_31849[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31687 === (6))){
var state_31686__$1 = state_31686;
var statearr_31692_31850 = state_31686__$1;
(statearr_31692_31850[(2)] = null);

(statearr_31692_31850[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31687 === (7))){
var inst_31682 = (state_31686[(2)]);
var state_31686__$1 = state_31686;
var statearr_31693_31851 = state_31686__$1;
(statearr_31693_31851[(2)] = inst_31682);

(statearr_31693_31851[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31842,c__19089__auto___31845,G__31673_31843,n__7461__auto___31841,jobs,results,process,async))
;
return ((function (__31842,switch__18977__auto__,c__19089__auto___31845,G__31673_31843,n__7461__auto___31841,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0 = (function (){
var statearr_31697 = [null,null,null,null,null,null,null];
(statearr_31697[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__);

(statearr_31697[(1)] = (1));

return statearr_31697;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1 = (function (state_31686){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_31686);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e31698){if((e31698 instanceof Object)){
var ex__18981__auto__ = e31698;
var statearr_31699_31852 = state_31686;
(statearr_31699_31852[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31686);

return cljs.core.cst$kw$recur;
} else {
throw e31698;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__31853 = state_31686;
state_31686 = G__31853;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__ = function(state_31686){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1.call(this,state_31686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__;
})()
;})(__31842,switch__18977__auto__,c__19089__auto___31845,G__31673_31843,n__7461__auto___31841,jobs,results,process,async))
})();
var state__19091__auto__ = (function (){var statearr_31700 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_31700[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___31845);

return statearr_31700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(__31842,c__19089__auto___31845,G__31673_31843,n__7461__auto___31841,jobs,results,process,async))
);


break;
case "async":
var c__19089__auto___31854 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31842,c__19089__auto___31854,G__31673_31843,n__7461__auto___31841,jobs,results,process,async){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (__31842,c__19089__auto___31854,G__31673_31843,n__7461__auto___31841,jobs,results,process,async){
return (function (state_31713){
var state_val_31714 = (state_31713[(1)]);
if((state_val_31714 === (1))){
var state_31713__$1 = state_31713;
var statearr_31715_31855 = state_31713__$1;
(statearr_31715_31855[(2)] = null);

(statearr_31715_31855[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31714 === (2))){
var state_31713__$1 = state_31713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31713__$1,(4),jobs);
} else {
if((state_val_31714 === (3))){
var inst_31711 = (state_31713[(2)]);
var state_31713__$1 = state_31713;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31713__$1,inst_31711);
} else {
if((state_val_31714 === (4))){
var inst_31703 = (state_31713[(2)]);
var inst_31704 = async(inst_31703);
var state_31713__$1 = state_31713;
if(cljs.core.truth_(inst_31704)){
var statearr_31716_31856 = state_31713__$1;
(statearr_31716_31856[(1)] = (5));

} else {
var statearr_31717_31857 = state_31713__$1;
(statearr_31717_31857[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31714 === (5))){
var state_31713__$1 = state_31713;
var statearr_31718_31858 = state_31713__$1;
(statearr_31718_31858[(2)] = null);

(statearr_31718_31858[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31714 === (6))){
var state_31713__$1 = state_31713;
var statearr_31719_31859 = state_31713__$1;
(statearr_31719_31859[(2)] = null);

(statearr_31719_31859[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31714 === (7))){
var inst_31709 = (state_31713[(2)]);
var state_31713__$1 = state_31713;
var statearr_31720_31860 = state_31713__$1;
(statearr_31720_31860[(2)] = inst_31709);

(statearr_31720_31860[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__31842,c__19089__auto___31854,G__31673_31843,n__7461__auto___31841,jobs,results,process,async))
;
return ((function (__31842,switch__18977__auto__,c__19089__auto___31854,G__31673_31843,n__7461__auto___31841,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0 = (function (){
var statearr_31724 = [null,null,null,null,null,null,null];
(statearr_31724[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__);

(statearr_31724[(1)] = (1));

return statearr_31724;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1 = (function (state_31713){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_31713);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e31725){if((e31725 instanceof Object)){
var ex__18981__auto__ = e31725;
var statearr_31726_31861 = state_31713;
(statearr_31726_31861[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31713);

return cljs.core.cst$kw$recur;
} else {
throw e31725;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__31862 = state_31713;
state_31713 = G__31862;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__ = function(state_31713){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1.call(this,state_31713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__;
})()
;})(__31842,switch__18977__auto__,c__19089__auto___31854,G__31673_31843,n__7461__auto___31841,jobs,results,process,async))
})();
var state__19091__auto__ = (function (){var statearr_31727 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_31727[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___31854);

return statearr_31727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(__31842,c__19089__auto___31854,G__31673_31843,n__7461__auto___31841,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__31863 = (__31842 + (1));
__31842 = G__31863;
continue;
} else {
}
break;
}

var c__19089__auto___31864 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___31864,jobs,results,process,async){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___31864,jobs,results,process,async){
return (function (state_31749){
var state_val_31750 = (state_31749[(1)]);
if((state_val_31750 === (1))){
var state_31749__$1 = state_31749;
var statearr_31751_31865 = state_31749__$1;
(statearr_31751_31865[(2)] = null);

(statearr_31751_31865[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31750 === (2))){
var state_31749__$1 = state_31749;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31749__$1,(4),from);
} else {
if((state_val_31750 === (3))){
var inst_31747 = (state_31749[(2)]);
var state_31749__$1 = state_31749;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31749__$1,inst_31747);
} else {
if((state_val_31750 === (4))){
var inst_31730 = (state_31749[(7)]);
var inst_31730__$1 = (state_31749[(2)]);
var inst_31731 = (inst_31730__$1 == null);
var state_31749__$1 = (function (){var statearr_31752 = state_31749;
(statearr_31752[(7)] = inst_31730__$1);

return statearr_31752;
})();
if(cljs.core.truth_(inst_31731)){
var statearr_31753_31866 = state_31749__$1;
(statearr_31753_31866[(1)] = (5));

} else {
var statearr_31754_31867 = state_31749__$1;
(statearr_31754_31867[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31750 === (5))){
var inst_31733 = cljs.core.async.close_BANG_(jobs);
var state_31749__$1 = state_31749;
var statearr_31755_31868 = state_31749__$1;
(statearr_31755_31868[(2)] = inst_31733);

(statearr_31755_31868[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31750 === (6))){
var inst_31735 = (state_31749[(8)]);
var inst_31730 = (state_31749[(7)]);
var inst_31735__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_31736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31737 = [inst_31730,inst_31735__$1];
var inst_31738 = (new cljs.core.PersistentVector(null,2,(5),inst_31736,inst_31737,null));
var state_31749__$1 = (function (){var statearr_31756 = state_31749;
(statearr_31756[(8)] = inst_31735__$1);

return statearr_31756;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31749__$1,(8),jobs,inst_31738);
} else {
if((state_val_31750 === (7))){
var inst_31745 = (state_31749[(2)]);
var state_31749__$1 = state_31749;
var statearr_31757_31869 = state_31749__$1;
(statearr_31757_31869[(2)] = inst_31745);

(statearr_31757_31869[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31750 === (8))){
var inst_31735 = (state_31749[(8)]);
var inst_31740 = (state_31749[(2)]);
var state_31749__$1 = (function (){var statearr_31758 = state_31749;
(statearr_31758[(9)] = inst_31740);

return statearr_31758;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31749__$1,(9),results,inst_31735);
} else {
if((state_val_31750 === (9))){
var inst_31742 = (state_31749[(2)]);
var state_31749__$1 = (function (){var statearr_31759 = state_31749;
(statearr_31759[(10)] = inst_31742);

return statearr_31759;
})();
var statearr_31760_31870 = state_31749__$1;
(statearr_31760_31870[(2)] = null);

(statearr_31760_31870[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___31864,jobs,results,process,async))
;
return ((function (switch__18977__auto__,c__19089__auto___31864,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0 = (function (){
var statearr_31764 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31764[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__);

(statearr_31764[(1)] = (1));

return statearr_31764;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1 = (function (state_31749){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_31749);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e31765){if((e31765 instanceof Object)){
var ex__18981__auto__ = e31765;
var statearr_31766_31871 = state_31749;
(statearr_31766_31871[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31749);

return cljs.core.cst$kw$recur;
} else {
throw e31765;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__31872 = state_31749;
state_31749 = G__31872;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__ = function(state_31749){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1.call(this,state_31749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___31864,jobs,results,process,async))
})();
var state__19091__auto__ = (function (){var statearr_31767 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_31767[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___31864);

return statearr_31767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___31864,jobs,results,process,async))
);


var c__19089__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto__,jobs,results,process,async){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto__,jobs,results,process,async){
return (function (state_31805){
var state_val_31806 = (state_31805[(1)]);
if((state_val_31806 === (7))){
var inst_31801 = (state_31805[(2)]);
var state_31805__$1 = state_31805;
var statearr_31807_31873 = state_31805__$1;
(statearr_31807_31873[(2)] = inst_31801);

(statearr_31807_31873[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (20))){
var state_31805__$1 = state_31805;
var statearr_31808_31874 = state_31805__$1;
(statearr_31808_31874[(2)] = null);

(statearr_31808_31874[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (1))){
var state_31805__$1 = state_31805;
var statearr_31809_31875 = state_31805__$1;
(statearr_31809_31875[(2)] = null);

(statearr_31809_31875[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (4))){
var inst_31770 = (state_31805[(7)]);
var inst_31770__$1 = (state_31805[(2)]);
var inst_31771 = (inst_31770__$1 == null);
var state_31805__$1 = (function (){var statearr_31810 = state_31805;
(statearr_31810[(7)] = inst_31770__$1);

return statearr_31810;
})();
if(cljs.core.truth_(inst_31771)){
var statearr_31811_31876 = state_31805__$1;
(statearr_31811_31876[(1)] = (5));

} else {
var statearr_31812_31877 = state_31805__$1;
(statearr_31812_31877[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (15))){
var inst_31783 = (state_31805[(8)]);
var state_31805__$1 = state_31805;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31805__$1,(18),to,inst_31783);
} else {
if((state_val_31806 === (21))){
var inst_31796 = (state_31805[(2)]);
var state_31805__$1 = state_31805;
var statearr_31813_31878 = state_31805__$1;
(statearr_31813_31878[(2)] = inst_31796);

(statearr_31813_31878[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (13))){
var inst_31798 = (state_31805[(2)]);
var state_31805__$1 = (function (){var statearr_31814 = state_31805;
(statearr_31814[(9)] = inst_31798);

return statearr_31814;
})();
var statearr_31815_31879 = state_31805__$1;
(statearr_31815_31879[(2)] = null);

(statearr_31815_31879[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (6))){
var inst_31770 = (state_31805[(7)]);
var state_31805__$1 = state_31805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31805__$1,(11),inst_31770);
} else {
if((state_val_31806 === (17))){
var inst_31791 = (state_31805[(2)]);
var state_31805__$1 = state_31805;
if(cljs.core.truth_(inst_31791)){
var statearr_31816_31880 = state_31805__$1;
(statearr_31816_31880[(1)] = (19));

} else {
var statearr_31817_31881 = state_31805__$1;
(statearr_31817_31881[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (3))){
var inst_31803 = (state_31805[(2)]);
var state_31805__$1 = state_31805;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31805__$1,inst_31803);
} else {
if((state_val_31806 === (12))){
var inst_31780 = (state_31805[(10)]);
var state_31805__$1 = state_31805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31805__$1,(14),inst_31780);
} else {
if((state_val_31806 === (2))){
var state_31805__$1 = state_31805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31805__$1,(4),results);
} else {
if((state_val_31806 === (19))){
var state_31805__$1 = state_31805;
var statearr_31818_31882 = state_31805__$1;
(statearr_31818_31882[(2)] = null);

(statearr_31818_31882[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (11))){
var inst_31780 = (state_31805[(2)]);
var state_31805__$1 = (function (){var statearr_31819 = state_31805;
(statearr_31819[(10)] = inst_31780);

return statearr_31819;
})();
var statearr_31820_31883 = state_31805__$1;
(statearr_31820_31883[(2)] = null);

(statearr_31820_31883[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (9))){
var state_31805__$1 = state_31805;
var statearr_31821_31884 = state_31805__$1;
(statearr_31821_31884[(2)] = null);

(statearr_31821_31884[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (5))){
var state_31805__$1 = state_31805;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31822_31885 = state_31805__$1;
(statearr_31822_31885[(1)] = (8));

} else {
var statearr_31823_31886 = state_31805__$1;
(statearr_31823_31886[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (14))){
var inst_31785 = (state_31805[(11)]);
var inst_31783 = (state_31805[(8)]);
var inst_31783__$1 = (state_31805[(2)]);
var inst_31784 = (inst_31783__$1 == null);
var inst_31785__$1 = cljs.core.not(inst_31784);
var state_31805__$1 = (function (){var statearr_31824 = state_31805;
(statearr_31824[(11)] = inst_31785__$1);

(statearr_31824[(8)] = inst_31783__$1);

return statearr_31824;
})();
if(inst_31785__$1){
var statearr_31825_31887 = state_31805__$1;
(statearr_31825_31887[(1)] = (15));

} else {
var statearr_31826_31888 = state_31805__$1;
(statearr_31826_31888[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (16))){
var inst_31785 = (state_31805[(11)]);
var state_31805__$1 = state_31805;
var statearr_31827_31889 = state_31805__$1;
(statearr_31827_31889[(2)] = inst_31785);

(statearr_31827_31889[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (10))){
var inst_31777 = (state_31805[(2)]);
var state_31805__$1 = state_31805;
var statearr_31828_31890 = state_31805__$1;
(statearr_31828_31890[(2)] = inst_31777);

(statearr_31828_31890[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (18))){
var inst_31788 = (state_31805[(2)]);
var state_31805__$1 = state_31805;
var statearr_31829_31891 = state_31805__$1;
(statearr_31829_31891[(2)] = inst_31788);

(statearr_31829_31891[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31806 === (8))){
var inst_31774 = cljs.core.async.close_BANG_(to);
var state_31805__$1 = state_31805;
var statearr_31830_31892 = state_31805__$1;
(statearr_31830_31892[(2)] = inst_31774);

(statearr_31830_31892[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto__,jobs,results,process,async))
;
return ((function (switch__18977__auto__,c__19089__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0 = (function (){
var statearr_31834 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31834[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__);

(statearr_31834[(1)] = (1));

return statearr_31834;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1 = (function (state_31805){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_31805);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e31835){if((e31835 instanceof Object)){
var ex__18981__auto__ = e31835;
var statearr_31836_31893 = state_31805;
(statearr_31836_31893[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31805);

return cljs.core.cst$kw$recur;
} else {
throw e31835;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__31894 = state_31805;
state_31805 = G__31894;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__ = function(state_31805){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1.call(this,state_31805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18978__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto__,jobs,results,process,async))
})();
var state__19091__auto__ = (function (){var statearr_31837 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_31837[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto__);

return statearr_31837;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto__,jobs,results,process,async))
);

return c__19089__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args31895 = [];
var len__7651__auto___31898 = arguments.length;
var i__7652__auto___31899 = (0);
while(true){
if((i__7652__auto___31899 < len__7651__auto___31898)){
args31895.push((arguments[i__7652__auto___31899]));

var G__31900 = (i__7652__auto___31899 + (1));
i__7652__auto___31899 = G__31900;
continue;
} else {
}
break;
}

var G__31897 = args31895.length;
switch (G__31897) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31895.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args31902 = [];
var len__7651__auto___31905 = arguments.length;
var i__7652__auto___31906 = (0);
while(true){
if((i__7652__auto___31906 < len__7651__auto___31905)){
args31902.push((arguments[i__7652__auto___31906]));

var G__31907 = (i__7652__auto___31906 + (1));
i__7652__auto___31906 = G__31907;
continue;
} else {
}
break;
}

var G__31904 = args31902.length;
switch (G__31904) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31902.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args31909 = [];
var len__7651__auto___31962 = arguments.length;
var i__7652__auto___31963 = (0);
while(true){
if((i__7652__auto___31963 < len__7651__auto___31962)){
args31909.push((arguments[i__7652__auto___31963]));

var G__31964 = (i__7652__auto___31963 + (1));
i__7652__auto___31963 = G__31964;
continue;
} else {
}
break;
}

var G__31911 = args31909.length;
switch (G__31911) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31909.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__19089__auto___31966 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___31966,tc,fc){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___31966,tc,fc){
return (function (state_31937){
var state_val_31938 = (state_31937[(1)]);
if((state_val_31938 === (7))){
var inst_31933 = (state_31937[(2)]);
var state_31937__$1 = state_31937;
var statearr_31939_31967 = state_31937__$1;
(statearr_31939_31967[(2)] = inst_31933);

(statearr_31939_31967[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31938 === (1))){
var state_31937__$1 = state_31937;
var statearr_31940_31968 = state_31937__$1;
(statearr_31940_31968[(2)] = null);

(statearr_31940_31968[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31938 === (4))){
var inst_31914 = (state_31937[(7)]);
var inst_31914__$1 = (state_31937[(2)]);
var inst_31915 = (inst_31914__$1 == null);
var state_31937__$1 = (function (){var statearr_31941 = state_31937;
(statearr_31941[(7)] = inst_31914__$1);

return statearr_31941;
})();
if(cljs.core.truth_(inst_31915)){
var statearr_31942_31969 = state_31937__$1;
(statearr_31942_31969[(1)] = (5));

} else {
var statearr_31943_31970 = state_31937__$1;
(statearr_31943_31970[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31938 === (13))){
var state_31937__$1 = state_31937;
var statearr_31944_31971 = state_31937__$1;
(statearr_31944_31971[(2)] = null);

(statearr_31944_31971[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31938 === (6))){
var inst_31914 = (state_31937[(7)]);
var inst_31920 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_31914) : p.call(null,inst_31914));
var state_31937__$1 = state_31937;
if(cljs.core.truth_(inst_31920)){
var statearr_31945_31972 = state_31937__$1;
(statearr_31945_31972[(1)] = (9));

} else {
var statearr_31946_31973 = state_31937__$1;
(statearr_31946_31973[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31938 === (3))){
var inst_31935 = (state_31937[(2)]);
var state_31937__$1 = state_31937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31937__$1,inst_31935);
} else {
if((state_val_31938 === (12))){
var state_31937__$1 = state_31937;
var statearr_31947_31974 = state_31937__$1;
(statearr_31947_31974[(2)] = null);

(statearr_31947_31974[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31938 === (2))){
var state_31937__$1 = state_31937;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31937__$1,(4),ch);
} else {
if((state_val_31938 === (11))){
var inst_31914 = (state_31937[(7)]);
var inst_31924 = (state_31937[(2)]);
var state_31937__$1 = state_31937;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31937__$1,(8),inst_31924,inst_31914);
} else {
if((state_val_31938 === (9))){
var state_31937__$1 = state_31937;
var statearr_31948_31975 = state_31937__$1;
(statearr_31948_31975[(2)] = tc);

(statearr_31948_31975[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31938 === (5))){
var inst_31917 = cljs.core.async.close_BANG_(tc);
var inst_31918 = cljs.core.async.close_BANG_(fc);
var state_31937__$1 = (function (){var statearr_31949 = state_31937;
(statearr_31949[(8)] = inst_31917);

return statearr_31949;
})();
var statearr_31950_31976 = state_31937__$1;
(statearr_31950_31976[(2)] = inst_31918);

(statearr_31950_31976[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31938 === (14))){
var inst_31931 = (state_31937[(2)]);
var state_31937__$1 = state_31937;
var statearr_31951_31977 = state_31937__$1;
(statearr_31951_31977[(2)] = inst_31931);

(statearr_31951_31977[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31938 === (10))){
var state_31937__$1 = state_31937;
var statearr_31952_31978 = state_31937__$1;
(statearr_31952_31978[(2)] = fc);

(statearr_31952_31978[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31938 === (8))){
var inst_31926 = (state_31937[(2)]);
var state_31937__$1 = state_31937;
if(cljs.core.truth_(inst_31926)){
var statearr_31953_31979 = state_31937__$1;
(statearr_31953_31979[(1)] = (12));

} else {
var statearr_31954_31980 = state_31937__$1;
(statearr_31954_31980[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___31966,tc,fc))
;
return ((function (switch__18977__auto__,c__19089__auto___31966,tc,fc){
return (function() {
var cljs$core$async$state_machine__18978__auto__ = null;
var cljs$core$async$state_machine__18978__auto____0 = (function (){
var statearr_31958 = [null,null,null,null,null,null,null,null,null];
(statearr_31958[(0)] = cljs$core$async$state_machine__18978__auto__);

(statearr_31958[(1)] = (1));

return statearr_31958;
});
var cljs$core$async$state_machine__18978__auto____1 = (function (state_31937){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_31937);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e31959){if((e31959 instanceof Object)){
var ex__18981__auto__ = e31959;
var statearr_31960_31981 = state_31937;
(statearr_31960_31981[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31937);

return cljs.core.cst$kw$recur;
} else {
throw e31959;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__31982 = state_31937;
state_31937 = G__31982;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$state_machine__18978__auto__ = function(state_31937){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18978__auto____1.call(this,state_31937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18978__auto____0;
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18978__auto____1;
return cljs$core$async$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___31966,tc,fc))
})();
var state__19091__auto__ = (function (){var statearr_31961 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_31961[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___31966);

return statearr_31961;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___31966,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__19089__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto__){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto__){
return (function (state_32046){
var state_val_32047 = (state_32046[(1)]);
if((state_val_32047 === (7))){
var inst_32042 = (state_32046[(2)]);
var state_32046__$1 = state_32046;
var statearr_32048_32069 = state_32046__$1;
(statearr_32048_32069[(2)] = inst_32042);

(statearr_32048_32069[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32047 === (1))){
var inst_32026 = init;
var state_32046__$1 = (function (){var statearr_32049 = state_32046;
(statearr_32049[(7)] = inst_32026);

return statearr_32049;
})();
var statearr_32050_32070 = state_32046__$1;
(statearr_32050_32070[(2)] = null);

(statearr_32050_32070[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32047 === (4))){
var inst_32029 = (state_32046[(8)]);
var inst_32029__$1 = (state_32046[(2)]);
var inst_32030 = (inst_32029__$1 == null);
var state_32046__$1 = (function (){var statearr_32051 = state_32046;
(statearr_32051[(8)] = inst_32029__$1);

return statearr_32051;
})();
if(cljs.core.truth_(inst_32030)){
var statearr_32052_32071 = state_32046__$1;
(statearr_32052_32071[(1)] = (5));

} else {
var statearr_32053_32072 = state_32046__$1;
(statearr_32053_32072[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32047 === (6))){
var inst_32033 = (state_32046[(9)]);
var inst_32026 = (state_32046[(7)]);
var inst_32029 = (state_32046[(8)]);
var inst_32033__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_32026,inst_32029) : f.call(null,inst_32026,inst_32029));
var inst_32034 = cljs.core.reduced_QMARK_(inst_32033__$1);
var state_32046__$1 = (function (){var statearr_32054 = state_32046;
(statearr_32054[(9)] = inst_32033__$1);

return statearr_32054;
})();
if(inst_32034){
var statearr_32055_32073 = state_32046__$1;
(statearr_32055_32073[(1)] = (8));

} else {
var statearr_32056_32074 = state_32046__$1;
(statearr_32056_32074[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32047 === (3))){
var inst_32044 = (state_32046[(2)]);
var state_32046__$1 = state_32046;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32046__$1,inst_32044);
} else {
if((state_val_32047 === (2))){
var state_32046__$1 = state_32046;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32046__$1,(4),ch);
} else {
if((state_val_32047 === (9))){
var inst_32033 = (state_32046[(9)]);
var inst_32026 = inst_32033;
var state_32046__$1 = (function (){var statearr_32057 = state_32046;
(statearr_32057[(7)] = inst_32026);

return statearr_32057;
})();
var statearr_32058_32075 = state_32046__$1;
(statearr_32058_32075[(2)] = null);

(statearr_32058_32075[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32047 === (5))){
var inst_32026 = (state_32046[(7)]);
var state_32046__$1 = state_32046;
var statearr_32059_32076 = state_32046__$1;
(statearr_32059_32076[(2)] = inst_32026);

(statearr_32059_32076[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32047 === (10))){
var inst_32040 = (state_32046[(2)]);
var state_32046__$1 = state_32046;
var statearr_32060_32077 = state_32046__$1;
(statearr_32060_32077[(2)] = inst_32040);

(statearr_32060_32077[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32047 === (8))){
var inst_32033 = (state_32046[(9)]);
var inst_32036 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_32033) : cljs.core.deref.call(null,inst_32033));
var state_32046__$1 = state_32046;
var statearr_32061_32078 = state_32046__$1;
(statearr_32061_32078[(2)] = inst_32036);

(statearr_32061_32078[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto__))
;
return ((function (switch__18977__auto__,c__19089__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__18978__auto__ = null;
var cljs$core$async$reduce_$_state_machine__18978__auto____0 = (function (){
var statearr_32065 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32065[(0)] = cljs$core$async$reduce_$_state_machine__18978__auto__);

(statearr_32065[(1)] = (1));

return statearr_32065;
});
var cljs$core$async$reduce_$_state_machine__18978__auto____1 = (function (state_32046){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_32046);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e32066){if((e32066 instanceof Object)){
var ex__18981__auto__ = e32066;
var statearr_32067_32079 = state_32046;
(statearr_32067_32079[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32046);

return cljs.core.cst$kw$recur;
} else {
throw e32066;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__32080 = state_32046;
state_32046 = G__32080;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__18978__auto__ = function(state_32046){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__18978__auto____1.call(this,state_32046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__18978__auto____0;
cljs$core$async$reduce_$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__18978__auto____1;
return cljs$core$async$reduce_$_state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto__))
})();
var state__19091__auto__ = (function (){var statearr_32068 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_32068[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto__);

return statearr_32068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto__))
);

return c__19089__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__19089__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto__,f__$1){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto__,f__$1){
return (function (state_32100){
var state_val_32101 = (state_32100[(1)]);
if((state_val_32101 === (1))){
var inst_32095 = cljs.core.async.reduce(f__$1,init,ch);
var state_32100__$1 = state_32100;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32100__$1,(2),inst_32095);
} else {
if((state_val_32101 === (2))){
var inst_32097 = (state_32100[(2)]);
var inst_32098 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_32097) : f__$1.call(null,inst_32097));
var state_32100__$1 = state_32100;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32100__$1,inst_32098);
} else {
return null;
}
}
});})(c__19089__auto__,f__$1))
;
return ((function (switch__18977__auto__,c__19089__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__18978__auto__ = null;
var cljs$core$async$transduce_$_state_machine__18978__auto____0 = (function (){
var statearr_32105 = [null,null,null,null,null,null,null];
(statearr_32105[(0)] = cljs$core$async$transduce_$_state_machine__18978__auto__);

(statearr_32105[(1)] = (1));

return statearr_32105;
});
var cljs$core$async$transduce_$_state_machine__18978__auto____1 = (function (state_32100){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_32100);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e32106){if((e32106 instanceof Object)){
var ex__18981__auto__ = e32106;
var statearr_32107_32109 = state_32100;
(statearr_32107_32109[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32100);

return cljs.core.cst$kw$recur;
} else {
throw e32106;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__32110 = state_32100;
state_32100 = G__32110;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__18978__auto__ = function(state_32100){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__18978__auto____1.call(this,state_32100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__18978__auto____0;
cljs$core$async$transduce_$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__18978__auto____1;
return cljs$core$async$transduce_$_state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto__,f__$1))
})();
var state__19091__auto__ = (function (){var statearr_32108 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_32108[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto__);

return statearr_32108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto__,f__$1))
);

return c__19089__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args32111 = [];
var len__7651__auto___32163 = arguments.length;
var i__7652__auto___32164 = (0);
while(true){
if((i__7652__auto___32164 < len__7651__auto___32163)){
args32111.push((arguments[i__7652__auto___32164]));

var G__32165 = (i__7652__auto___32164 + (1));
i__7652__auto___32164 = G__32165;
continue;
} else {
}
break;
}

var G__32113 = args32111.length;
switch (G__32113) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32111.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__19089__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto__){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto__){
return (function (state_32138){
var state_val_32139 = (state_32138[(1)]);
if((state_val_32139 === (7))){
var inst_32120 = (state_32138[(2)]);
var state_32138__$1 = state_32138;
var statearr_32140_32167 = state_32138__$1;
(statearr_32140_32167[(2)] = inst_32120);

(statearr_32140_32167[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32139 === (1))){
var inst_32114 = cljs.core.seq(coll);
var inst_32115 = inst_32114;
var state_32138__$1 = (function (){var statearr_32141 = state_32138;
(statearr_32141[(7)] = inst_32115);

return statearr_32141;
})();
var statearr_32142_32168 = state_32138__$1;
(statearr_32142_32168[(2)] = null);

(statearr_32142_32168[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32139 === (4))){
var inst_32115 = (state_32138[(7)]);
var inst_32118 = cljs.core.first(inst_32115);
var state_32138__$1 = state_32138;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32138__$1,(7),ch,inst_32118);
} else {
if((state_val_32139 === (13))){
var inst_32132 = (state_32138[(2)]);
var state_32138__$1 = state_32138;
var statearr_32143_32169 = state_32138__$1;
(statearr_32143_32169[(2)] = inst_32132);

(statearr_32143_32169[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32139 === (6))){
var inst_32123 = (state_32138[(2)]);
var state_32138__$1 = state_32138;
if(cljs.core.truth_(inst_32123)){
var statearr_32144_32170 = state_32138__$1;
(statearr_32144_32170[(1)] = (8));

} else {
var statearr_32145_32171 = state_32138__$1;
(statearr_32145_32171[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32139 === (3))){
var inst_32136 = (state_32138[(2)]);
var state_32138__$1 = state_32138;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32138__$1,inst_32136);
} else {
if((state_val_32139 === (12))){
var state_32138__$1 = state_32138;
var statearr_32146_32172 = state_32138__$1;
(statearr_32146_32172[(2)] = null);

(statearr_32146_32172[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32139 === (2))){
var inst_32115 = (state_32138[(7)]);
var state_32138__$1 = state_32138;
if(cljs.core.truth_(inst_32115)){
var statearr_32147_32173 = state_32138__$1;
(statearr_32147_32173[(1)] = (4));

} else {
var statearr_32148_32174 = state_32138__$1;
(statearr_32148_32174[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32139 === (11))){
var inst_32129 = cljs.core.async.close_BANG_(ch);
var state_32138__$1 = state_32138;
var statearr_32149_32175 = state_32138__$1;
(statearr_32149_32175[(2)] = inst_32129);

(statearr_32149_32175[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32139 === (9))){
var state_32138__$1 = state_32138;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32150_32176 = state_32138__$1;
(statearr_32150_32176[(1)] = (11));

} else {
var statearr_32151_32177 = state_32138__$1;
(statearr_32151_32177[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32139 === (5))){
var inst_32115 = (state_32138[(7)]);
var state_32138__$1 = state_32138;
var statearr_32152_32178 = state_32138__$1;
(statearr_32152_32178[(2)] = inst_32115);

(statearr_32152_32178[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32139 === (10))){
var inst_32134 = (state_32138[(2)]);
var state_32138__$1 = state_32138;
var statearr_32153_32179 = state_32138__$1;
(statearr_32153_32179[(2)] = inst_32134);

(statearr_32153_32179[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32139 === (8))){
var inst_32115 = (state_32138[(7)]);
var inst_32125 = cljs.core.next(inst_32115);
var inst_32115__$1 = inst_32125;
var state_32138__$1 = (function (){var statearr_32154 = state_32138;
(statearr_32154[(7)] = inst_32115__$1);

return statearr_32154;
})();
var statearr_32155_32180 = state_32138__$1;
(statearr_32155_32180[(2)] = null);

(statearr_32155_32180[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto__))
;
return ((function (switch__18977__auto__,c__19089__auto__){
return (function() {
var cljs$core$async$state_machine__18978__auto__ = null;
var cljs$core$async$state_machine__18978__auto____0 = (function (){
var statearr_32159 = [null,null,null,null,null,null,null,null];
(statearr_32159[(0)] = cljs$core$async$state_machine__18978__auto__);

(statearr_32159[(1)] = (1));

return statearr_32159;
});
var cljs$core$async$state_machine__18978__auto____1 = (function (state_32138){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_32138);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e32160){if((e32160 instanceof Object)){
var ex__18981__auto__ = e32160;
var statearr_32161_32181 = state_32138;
(statearr_32161_32181[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32138);

return cljs.core.cst$kw$recur;
} else {
throw e32160;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__32182 = state_32138;
state_32138 = G__32182;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$state_machine__18978__auto__ = function(state_32138){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18978__auto____1.call(this,state_32138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18978__auto____0;
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18978__auto____1;
return cljs$core$async$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto__))
})();
var state__19091__auto__ = (function (){var statearr_32162 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_32162[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto__);

return statearr_32162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto__))
);

return c__19089__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7206__auto__ = (((_ == null))?null:_);
var m__7207__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7207__auto__.call(null,_));
} else {
var m__7207__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7207__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7207__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7207__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto__.call(null,m));
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__32411 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32411) : cljs.core.atom.call(null,G__32411));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32412 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32412 = (function (ch,cs,meta32413){
this.ch = ch;
this.cs = cs;
this.meta32413 = meta32413;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32414,meta32413__$1){
var self__ = this;
var _32414__$1 = this;
return (new cljs.core.async.t_cljs$core$async32412(self__.ch,self__.cs,meta32413__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32414){
var self__ = this;
var _32414__$1 = this;
return self__.meta32413;
});})(cs))
;

cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32412.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32415_32639 = self__.cs;
var G__32416_32640 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32415_32639,G__32416_32640) : cljs.core.reset_BANG_.call(null,G__32415_32639,G__32416_32640));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32412.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta32413], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async32412.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32412.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32412";

cljs.core.async.t_cljs$core$async32412.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async32412");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async32412 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async32412(ch__$1,cs__$1,meta32413){
return (new cljs.core.async.t_cljs$core$async32412(ch__$1,cs__$1,meta32413));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async32412(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__19089__auto___32641 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___32641,cs,m,dchan,dctr,done){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___32641,cs,m,dchan,dctr,done){
return (function (state_32551){
var state_val_32552 = (state_32551[(1)]);
if((state_val_32552 === (7))){
var inst_32547 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32553_32642 = state_32551__$1;
(statearr_32553_32642[(2)] = inst_32547);

(statearr_32553_32642[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (20))){
var inst_32450 = (state_32551[(7)]);
var inst_32462 = cljs.core.first(inst_32450);
var inst_32463 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32462,(0),null);
var inst_32464 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32462,(1),null);
var state_32551__$1 = (function (){var statearr_32554 = state_32551;
(statearr_32554[(8)] = inst_32463);

return statearr_32554;
})();
if(cljs.core.truth_(inst_32464)){
var statearr_32555_32643 = state_32551__$1;
(statearr_32555_32643[(1)] = (22));

} else {
var statearr_32556_32644 = state_32551__$1;
(statearr_32556_32644[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (27))){
var inst_32494 = (state_32551[(9)]);
var inst_32492 = (state_32551[(10)]);
var inst_32499 = (state_32551[(11)]);
var inst_32419 = (state_32551[(12)]);
var inst_32499__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32492,inst_32494);
var inst_32500 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32499__$1,inst_32419,done);
var state_32551__$1 = (function (){var statearr_32557 = state_32551;
(statearr_32557[(11)] = inst_32499__$1);

return statearr_32557;
})();
if(cljs.core.truth_(inst_32500)){
var statearr_32558_32645 = state_32551__$1;
(statearr_32558_32645[(1)] = (30));

} else {
var statearr_32559_32646 = state_32551__$1;
(statearr_32559_32646[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (1))){
var state_32551__$1 = state_32551;
var statearr_32560_32647 = state_32551__$1;
(statearr_32560_32647[(2)] = null);

(statearr_32560_32647[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (24))){
var inst_32450 = (state_32551[(7)]);
var inst_32469 = (state_32551[(2)]);
var inst_32470 = cljs.core.next(inst_32450);
var inst_32428 = inst_32470;
var inst_32429 = null;
var inst_32430 = (0);
var inst_32431 = (0);
var state_32551__$1 = (function (){var statearr_32561 = state_32551;
(statearr_32561[(13)] = inst_32428);

(statearr_32561[(14)] = inst_32430);

(statearr_32561[(15)] = inst_32431);

(statearr_32561[(16)] = inst_32429);

(statearr_32561[(17)] = inst_32469);

return statearr_32561;
})();
var statearr_32562_32648 = state_32551__$1;
(statearr_32562_32648[(2)] = null);

(statearr_32562_32648[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (39))){
var state_32551__$1 = state_32551;
var statearr_32566_32649 = state_32551__$1;
(statearr_32566_32649[(2)] = null);

(statearr_32566_32649[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (4))){
var inst_32419 = (state_32551[(12)]);
var inst_32419__$1 = (state_32551[(2)]);
var inst_32420 = (inst_32419__$1 == null);
var state_32551__$1 = (function (){var statearr_32567 = state_32551;
(statearr_32567[(12)] = inst_32419__$1);

return statearr_32567;
})();
if(cljs.core.truth_(inst_32420)){
var statearr_32568_32650 = state_32551__$1;
(statearr_32568_32650[(1)] = (5));

} else {
var statearr_32569_32651 = state_32551__$1;
(statearr_32569_32651[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (15))){
var inst_32428 = (state_32551[(13)]);
var inst_32430 = (state_32551[(14)]);
var inst_32431 = (state_32551[(15)]);
var inst_32429 = (state_32551[(16)]);
var inst_32446 = (state_32551[(2)]);
var inst_32447 = (inst_32431 + (1));
var tmp32563 = inst_32428;
var tmp32564 = inst_32430;
var tmp32565 = inst_32429;
var inst_32428__$1 = tmp32563;
var inst_32429__$1 = tmp32565;
var inst_32430__$1 = tmp32564;
var inst_32431__$1 = inst_32447;
var state_32551__$1 = (function (){var statearr_32570 = state_32551;
(statearr_32570[(13)] = inst_32428__$1);

(statearr_32570[(18)] = inst_32446);

(statearr_32570[(14)] = inst_32430__$1);

(statearr_32570[(15)] = inst_32431__$1);

(statearr_32570[(16)] = inst_32429__$1);

return statearr_32570;
})();
var statearr_32571_32652 = state_32551__$1;
(statearr_32571_32652[(2)] = null);

(statearr_32571_32652[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (21))){
var inst_32473 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32575_32653 = state_32551__$1;
(statearr_32575_32653[(2)] = inst_32473);

(statearr_32575_32653[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (31))){
var inst_32499 = (state_32551[(11)]);
var inst_32503 = done(null);
var inst_32504 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32499);
var state_32551__$1 = (function (){var statearr_32576 = state_32551;
(statearr_32576[(19)] = inst_32503);

return statearr_32576;
})();
var statearr_32577_32654 = state_32551__$1;
(statearr_32577_32654[(2)] = inst_32504);

(statearr_32577_32654[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (32))){
var inst_32494 = (state_32551[(9)]);
var inst_32492 = (state_32551[(10)]);
var inst_32493 = (state_32551[(20)]);
var inst_32491 = (state_32551[(21)]);
var inst_32506 = (state_32551[(2)]);
var inst_32507 = (inst_32494 + (1));
var tmp32572 = inst_32492;
var tmp32573 = inst_32493;
var tmp32574 = inst_32491;
var inst_32491__$1 = tmp32574;
var inst_32492__$1 = tmp32572;
var inst_32493__$1 = tmp32573;
var inst_32494__$1 = inst_32507;
var state_32551__$1 = (function (){var statearr_32578 = state_32551;
(statearr_32578[(9)] = inst_32494__$1);

(statearr_32578[(10)] = inst_32492__$1);

(statearr_32578[(22)] = inst_32506);

(statearr_32578[(20)] = inst_32493__$1);

(statearr_32578[(21)] = inst_32491__$1);

return statearr_32578;
})();
var statearr_32579_32655 = state_32551__$1;
(statearr_32579_32655[(2)] = null);

(statearr_32579_32655[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (40))){
var inst_32519 = (state_32551[(23)]);
var inst_32523 = done(null);
var inst_32524 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32519);
var state_32551__$1 = (function (){var statearr_32580 = state_32551;
(statearr_32580[(24)] = inst_32523);

return statearr_32580;
})();
var statearr_32581_32656 = state_32551__$1;
(statearr_32581_32656[(2)] = inst_32524);

(statearr_32581_32656[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (33))){
var inst_32510 = (state_32551[(25)]);
var inst_32512 = cljs.core.chunked_seq_QMARK_(inst_32510);
var state_32551__$1 = state_32551;
if(inst_32512){
var statearr_32582_32657 = state_32551__$1;
(statearr_32582_32657[(1)] = (36));

} else {
var statearr_32583_32658 = state_32551__$1;
(statearr_32583_32658[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (13))){
var inst_32440 = (state_32551[(26)]);
var inst_32443 = cljs.core.async.close_BANG_(inst_32440);
var state_32551__$1 = state_32551;
var statearr_32584_32659 = state_32551__$1;
(statearr_32584_32659[(2)] = inst_32443);

(statearr_32584_32659[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (22))){
var inst_32463 = (state_32551[(8)]);
var inst_32466 = cljs.core.async.close_BANG_(inst_32463);
var state_32551__$1 = state_32551;
var statearr_32585_32660 = state_32551__$1;
(statearr_32585_32660[(2)] = inst_32466);

(statearr_32585_32660[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (36))){
var inst_32510 = (state_32551[(25)]);
var inst_32514 = cljs.core.chunk_first(inst_32510);
var inst_32515 = cljs.core.chunk_rest(inst_32510);
var inst_32516 = cljs.core.count(inst_32514);
var inst_32491 = inst_32515;
var inst_32492 = inst_32514;
var inst_32493 = inst_32516;
var inst_32494 = (0);
var state_32551__$1 = (function (){var statearr_32586 = state_32551;
(statearr_32586[(9)] = inst_32494);

(statearr_32586[(10)] = inst_32492);

(statearr_32586[(20)] = inst_32493);

(statearr_32586[(21)] = inst_32491);

return statearr_32586;
})();
var statearr_32587_32661 = state_32551__$1;
(statearr_32587_32661[(2)] = null);

(statearr_32587_32661[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (41))){
var inst_32510 = (state_32551[(25)]);
var inst_32526 = (state_32551[(2)]);
var inst_32527 = cljs.core.next(inst_32510);
var inst_32491 = inst_32527;
var inst_32492 = null;
var inst_32493 = (0);
var inst_32494 = (0);
var state_32551__$1 = (function (){var statearr_32588 = state_32551;
(statearr_32588[(27)] = inst_32526);

(statearr_32588[(9)] = inst_32494);

(statearr_32588[(10)] = inst_32492);

(statearr_32588[(20)] = inst_32493);

(statearr_32588[(21)] = inst_32491);

return statearr_32588;
})();
var statearr_32589_32662 = state_32551__$1;
(statearr_32589_32662[(2)] = null);

(statearr_32589_32662[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (43))){
var state_32551__$1 = state_32551;
var statearr_32590_32663 = state_32551__$1;
(statearr_32590_32663[(2)] = null);

(statearr_32590_32663[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (29))){
var inst_32535 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32591_32664 = state_32551__$1;
(statearr_32591_32664[(2)] = inst_32535);

(statearr_32591_32664[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (44))){
var inst_32544 = (state_32551[(2)]);
var state_32551__$1 = (function (){var statearr_32592 = state_32551;
(statearr_32592[(28)] = inst_32544);

return statearr_32592;
})();
var statearr_32593_32665 = state_32551__$1;
(statearr_32593_32665[(2)] = null);

(statearr_32593_32665[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (6))){
var inst_32483 = (state_32551[(29)]);
var inst_32482 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32483__$1 = cljs.core.keys(inst_32482);
var inst_32484 = cljs.core.count(inst_32483__$1);
var inst_32485 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_32484) : cljs.core.reset_BANG_.call(null,dctr,inst_32484));
var inst_32490 = cljs.core.seq(inst_32483__$1);
var inst_32491 = inst_32490;
var inst_32492 = null;
var inst_32493 = (0);
var inst_32494 = (0);
var state_32551__$1 = (function (){var statearr_32594 = state_32551;
(statearr_32594[(30)] = inst_32485);

(statearr_32594[(29)] = inst_32483__$1);

(statearr_32594[(9)] = inst_32494);

(statearr_32594[(10)] = inst_32492);

(statearr_32594[(20)] = inst_32493);

(statearr_32594[(21)] = inst_32491);

return statearr_32594;
})();
var statearr_32595_32666 = state_32551__$1;
(statearr_32595_32666[(2)] = null);

(statearr_32595_32666[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (28))){
var inst_32510 = (state_32551[(25)]);
var inst_32491 = (state_32551[(21)]);
var inst_32510__$1 = cljs.core.seq(inst_32491);
var state_32551__$1 = (function (){var statearr_32596 = state_32551;
(statearr_32596[(25)] = inst_32510__$1);

return statearr_32596;
})();
if(inst_32510__$1){
var statearr_32597_32667 = state_32551__$1;
(statearr_32597_32667[(1)] = (33));

} else {
var statearr_32598_32668 = state_32551__$1;
(statearr_32598_32668[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (25))){
var inst_32494 = (state_32551[(9)]);
var inst_32493 = (state_32551[(20)]);
var inst_32496 = (inst_32494 < inst_32493);
var inst_32497 = inst_32496;
var state_32551__$1 = state_32551;
if(cljs.core.truth_(inst_32497)){
var statearr_32599_32669 = state_32551__$1;
(statearr_32599_32669[(1)] = (27));

} else {
var statearr_32600_32670 = state_32551__$1;
(statearr_32600_32670[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (34))){
var state_32551__$1 = state_32551;
var statearr_32601_32671 = state_32551__$1;
(statearr_32601_32671[(2)] = null);

(statearr_32601_32671[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (17))){
var state_32551__$1 = state_32551;
var statearr_32602_32672 = state_32551__$1;
(statearr_32602_32672[(2)] = null);

(statearr_32602_32672[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (3))){
var inst_32549 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32551__$1,inst_32549);
} else {
if((state_val_32552 === (12))){
var inst_32478 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32603_32673 = state_32551__$1;
(statearr_32603_32673[(2)] = inst_32478);

(statearr_32603_32673[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (2))){
var state_32551__$1 = state_32551;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32551__$1,(4),ch);
} else {
if((state_val_32552 === (23))){
var state_32551__$1 = state_32551;
var statearr_32604_32674 = state_32551__$1;
(statearr_32604_32674[(2)] = null);

(statearr_32604_32674[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (35))){
var inst_32533 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32605_32675 = state_32551__$1;
(statearr_32605_32675[(2)] = inst_32533);

(statearr_32605_32675[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (19))){
var inst_32450 = (state_32551[(7)]);
var inst_32454 = cljs.core.chunk_first(inst_32450);
var inst_32455 = cljs.core.chunk_rest(inst_32450);
var inst_32456 = cljs.core.count(inst_32454);
var inst_32428 = inst_32455;
var inst_32429 = inst_32454;
var inst_32430 = inst_32456;
var inst_32431 = (0);
var state_32551__$1 = (function (){var statearr_32606 = state_32551;
(statearr_32606[(13)] = inst_32428);

(statearr_32606[(14)] = inst_32430);

(statearr_32606[(15)] = inst_32431);

(statearr_32606[(16)] = inst_32429);

return statearr_32606;
})();
var statearr_32607_32676 = state_32551__$1;
(statearr_32607_32676[(2)] = null);

(statearr_32607_32676[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (11))){
var inst_32428 = (state_32551[(13)]);
var inst_32450 = (state_32551[(7)]);
var inst_32450__$1 = cljs.core.seq(inst_32428);
var state_32551__$1 = (function (){var statearr_32608 = state_32551;
(statearr_32608[(7)] = inst_32450__$1);

return statearr_32608;
})();
if(inst_32450__$1){
var statearr_32609_32677 = state_32551__$1;
(statearr_32609_32677[(1)] = (16));

} else {
var statearr_32610_32678 = state_32551__$1;
(statearr_32610_32678[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (9))){
var inst_32480 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32611_32679 = state_32551__$1;
(statearr_32611_32679[(2)] = inst_32480);

(statearr_32611_32679[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (5))){
var inst_32426 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32427 = cljs.core.seq(inst_32426);
var inst_32428 = inst_32427;
var inst_32429 = null;
var inst_32430 = (0);
var inst_32431 = (0);
var state_32551__$1 = (function (){var statearr_32612 = state_32551;
(statearr_32612[(13)] = inst_32428);

(statearr_32612[(14)] = inst_32430);

(statearr_32612[(15)] = inst_32431);

(statearr_32612[(16)] = inst_32429);

return statearr_32612;
})();
var statearr_32613_32680 = state_32551__$1;
(statearr_32613_32680[(2)] = null);

(statearr_32613_32680[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (14))){
var state_32551__$1 = state_32551;
var statearr_32614_32681 = state_32551__$1;
(statearr_32614_32681[(2)] = null);

(statearr_32614_32681[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (45))){
var inst_32541 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32615_32682 = state_32551__$1;
(statearr_32615_32682[(2)] = inst_32541);

(statearr_32615_32682[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (26))){
var inst_32483 = (state_32551[(29)]);
var inst_32537 = (state_32551[(2)]);
var inst_32538 = cljs.core.seq(inst_32483);
var state_32551__$1 = (function (){var statearr_32616 = state_32551;
(statearr_32616[(31)] = inst_32537);

return statearr_32616;
})();
if(inst_32538){
var statearr_32617_32683 = state_32551__$1;
(statearr_32617_32683[(1)] = (42));

} else {
var statearr_32618_32684 = state_32551__$1;
(statearr_32618_32684[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (16))){
var inst_32450 = (state_32551[(7)]);
var inst_32452 = cljs.core.chunked_seq_QMARK_(inst_32450);
var state_32551__$1 = state_32551;
if(inst_32452){
var statearr_32619_32685 = state_32551__$1;
(statearr_32619_32685[(1)] = (19));

} else {
var statearr_32620_32686 = state_32551__$1;
(statearr_32620_32686[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (38))){
var inst_32530 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32621_32687 = state_32551__$1;
(statearr_32621_32687[(2)] = inst_32530);

(statearr_32621_32687[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (30))){
var state_32551__$1 = state_32551;
var statearr_32622_32688 = state_32551__$1;
(statearr_32622_32688[(2)] = null);

(statearr_32622_32688[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (10))){
var inst_32431 = (state_32551[(15)]);
var inst_32429 = (state_32551[(16)]);
var inst_32439 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32429,inst_32431);
var inst_32440 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32439,(0),null);
var inst_32441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32439,(1),null);
var state_32551__$1 = (function (){var statearr_32623 = state_32551;
(statearr_32623[(26)] = inst_32440);

return statearr_32623;
})();
if(cljs.core.truth_(inst_32441)){
var statearr_32624_32689 = state_32551__$1;
(statearr_32624_32689[(1)] = (13));

} else {
var statearr_32625_32690 = state_32551__$1;
(statearr_32625_32690[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (18))){
var inst_32476 = (state_32551[(2)]);
var state_32551__$1 = state_32551;
var statearr_32626_32691 = state_32551__$1;
(statearr_32626_32691[(2)] = inst_32476);

(statearr_32626_32691[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (42))){
var state_32551__$1 = state_32551;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32551__$1,(45),dchan);
} else {
if((state_val_32552 === (37))){
var inst_32519 = (state_32551[(23)]);
var inst_32419 = (state_32551[(12)]);
var inst_32510 = (state_32551[(25)]);
var inst_32519__$1 = cljs.core.first(inst_32510);
var inst_32520 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32519__$1,inst_32419,done);
var state_32551__$1 = (function (){var statearr_32627 = state_32551;
(statearr_32627[(23)] = inst_32519__$1);

return statearr_32627;
})();
if(cljs.core.truth_(inst_32520)){
var statearr_32628_32692 = state_32551__$1;
(statearr_32628_32692[(1)] = (39));

} else {
var statearr_32629_32693 = state_32551__$1;
(statearr_32629_32693[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32552 === (8))){
var inst_32430 = (state_32551[(14)]);
var inst_32431 = (state_32551[(15)]);
var inst_32433 = (inst_32431 < inst_32430);
var inst_32434 = inst_32433;
var state_32551__$1 = state_32551;
if(cljs.core.truth_(inst_32434)){
var statearr_32630_32694 = state_32551__$1;
(statearr_32630_32694[(1)] = (10));

} else {
var statearr_32631_32695 = state_32551__$1;
(statearr_32631_32695[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___32641,cs,m,dchan,dctr,done))
;
return ((function (switch__18977__auto__,c__19089__auto___32641,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__18978__auto__ = null;
var cljs$core$async$mult_$_state_machine__18978__auto____0 = (function (){
var statearr_32635 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32635[(0)] = cljs$core$async$mult_$_state_machine__18978__auto__);

(statearr_32635[(1)] = (1));

return statearr_32635;
});
var cljs$core$async$mult_$_state_machine__18978__auto____1 = (function (state_32551){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_32551);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e32636){if((e32636 instanceof Object)){
var ex__18981__auto__ = e32636;
var statearr_32637_32696 = state_32551;
(statearr_32637_32696[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32551);

return cljs.core.cst$kw$recur;
} else {
throw e32636;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__32697 = state_32551;
state_32551 = G__32697;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__18978__auto__ = function(state_32551){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__18978__auto____1.call(this,state_32551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__18978__auto____0;
cljs$core$async$mult_$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__18978__auto____1;
return cljs$core$async$mult_$_state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___32641,cs,m,dchan,dctr,done))
})();
var state__19091__auto__ = (function (){var statearr_32638 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_32638[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___32641);

return statearr_32638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___32641,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args32698 = [];
var len__7651__auto___32701 = arguments.length;
var i__7652__auto___32702 = (0);
while(true){
if((i__7652__auto___32702 < len__7651__auto___32701)){
args32698.push((arguments[i__7652__auto___32702]));

var G__32703 = (i__7652__auto___32702 + (1));
i__7652__auto___32702 = G__32703;
continue;
} else {
}
break;
}

var G__32700 = args32698.length;
switch (G__32700) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32698.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto__.call(null,m));
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7207__auto__.call(null,m,state_map));
} else {
var m__7207__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7207__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7207__auto__.call(null,m,mode));
} else {
var m__7207__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7207__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32715 = arguments.length;
var i__7652__auto___32716 = (0);
while(true){
if((i__7652__auto___32716 < len__7651__auto___32715)){
args__7658__auto__.push((arguments[i__7652__auto___32716]));

var G__32717 = (i__7652__auto___32716 + (1));
i__7652__auto___32716 = G__32717;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32709){
var map__32710 = p__32709;
var map__32710__$1 = ((((!((map__32710 == null)))?((((map__32710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32710.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32710):map__32710);
var opts = map__32710__$1;
var statearr_32712_32718 = state;
(statearr_32712_32718[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__32710,map__32710__$1,opts){
return (function (val){
var statearr_32713_32719 = state;
(statearr_32713_32719[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__32710,map__32710__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_32714_32720 = state;
(statearr_32714_32720[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32705){
var G__32706 = cljs.core.first(seq32705);
var seq32705__$1 = cljs.core.next(seq32705);
var G__32707 = cljs.core.first(seq32705__$1);
var seq32705__$2 = cljs.core.next(seq32705__$1);
var G__32708 = cljs.core.first(seq32705__$2);
var seq32705__$3 = cljs.core.next(seq32705__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32706,G__32707,G__32708,seq32705__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__32892 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32892) : cljs.core.atom.call(null,G__32892));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__32893 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32893) : cljs.core.atom.call(null,G__32893));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32894 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32894 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta32895){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta32895 = meta32895;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32894.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32896,meta32895__$1){
var self__ = this;
var _32896__$1 = this;
return (new cljs.core.async.t_cljs$core$async32894(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta32895__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32894.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32896){
var self__ = this;
var _32896__$1 = this;
return self__.meta32895;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32894.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32894.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32894.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32894.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32894.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32894.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32897_33063 = self__.cs;
var G__32898_33064 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32897_33063,G__32898_33064) : cljs.core.reset_BANG_.call(null,G__32897_33063,G__32898_33064));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32894.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32894.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32894.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta32895], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32894.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32894.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32894";

cljs.core.async.t_cljs$core$async32894.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async32894");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async32894 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async32894(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta32895){
return (new cljs.core.async.t_cljs$core$async32894(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta32895));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async32894(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19089__auto___33065 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___33065,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___33065,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_33000){
var state_val_33001 = (state_33000[(1)]);
if((state_val_33001 === (7))){
var inst_32915 = (state_33000[(2)]);
var state_33000__$1 = state_33000;
var statearr_33002_33066 = state_33000__$1;
(statearr_33002_33066[(2)] = inst_32915);

(statearr_33002_33066[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (20))){
var inst_32927 = (state_33000[(7)]);
var state_33000__$1 = state_33000;
var statearr_33003_33067 = state_33000__$1;
(statearr_33003_33067[(2)] = inst_32927);

(statearr_33003_33067[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (27))){
var state_33000__$1 = state_33000;
var statearr_33004_33068 = state_33000__$1;
(statearr_33004_33068[(2)] = null);

(statearr_33004_33068[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (1))){
var inst_32902 = (state_33000[(8)]);
var inst_32902__$1 = calc_state();
var inst_32904 = (inst_32902__$1 == null);
var inst_32905 = cljs.core.not(inst_32904);
var state_33000__$1 = (function (){var statearr_33005 = state_33000;
(statearr_33005[(8)] = inst_32902__$1);

return statearr_33005;
})();
if(inst_32905){
var statearr_33006_33069 = state_33000__$1;
(statearr_33006_33069[(1)] = (2));

} else {
var statearr_33007_33070 = state_33000__$1;
(statearr_33007_33070[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (24))){
var inst_32951 = (state_33000[(9)]);
var inst_32960 = (state_33000[(10)]);
var inst_32974 = (state_33000[(11)]);
var inst_32974__$1 = (inst_32951.cljs$core$IFn$_invoke$arity$1 ? inst_32951.cljs$core$IFn$_invoke$arity$1(inst_32960) : inst_32951.call(null,inst_32960));
var state_33000__$1 = (function (){var statearr_33008 = state_33000;
(statearr_33008[(11)] = inst_32974__$1);

return statearr_33008;
})();
if(cljs.core.truth_(inst_32974__$1)){
var statearr_33009_33071 = state_33000__$1;
(statearr_33009_33071[(1)] = (29));

} else {
var statearr_33010_33072 = state_33000__$1;
(statearr_33010_33072[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (4))){
var inst_32918 = (state_33000[(2)]);
var state_33000__$1 = state_33000;
if(cljs.core.truth_(inst_32918)){
var statearr_33011_33073 = state_33000__$1;
(statearr_33011_33073[(1)] = (8));

} else {
var statearr_33012_33074 = state_33000__$1;
(statearr_33012_33074[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (15))){
var inst_32945 = (state_33000[(2)]);
var state_33000__$1 = state_33000;
if(cljs.core.truth_(inst_32945)){
var statearr_33013_33075 = state_33000__$1;
(statearr_33013_33075[(1)] = (19));

} else {
var statearr_33014_33076 = state_33000__$1;
(statearr_33014_33076[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (21))){
var inst_32950 = (state_33000[(12)]);
var inst_32950__$1 = (state_33000[(2)]);
var inst_32951 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32950__$1,cljs.core.cst$kw$solos);
var inst_32952 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32950__$1,cljs.core.cst$kw$mutes);
var inst_32953 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32950__$1,cljs.core.cst$kw$reads);
var state_33000__$1 = (function (){var statearr_33015 = state_33000;
(statearr_33015[(9)] = inst_32951);

(statearr_33015[(13)] = inst_32952);

(statearr_33015[(12)] = inst_32950__$1);

return statearr_33015;
})();
return cljs.core.async.ioc_alts_BANG_(state_33000__$1,(22),inst_32953);
} else {
if((state_val_33001 === (31))){
var inst_32982 = (state_33000[(2)]);
var state_33000__$1 = state_33000;
if(cljs.core.truth_(inst_32982)){
var statearr_33016_33077 = state_33000__$1;
(statearr_33016_33077[(1)] = (32));

} else {
var statearr_33017_33078 = state_33000__$1;
(statearr_33017_33078[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (32))){
var inst_32959 = (state_33000[(14)]);
var state_33000__$1 = state_33000;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33000__$1,(35),out,inst_32959);
} else {
if((state_val_33001 === (33))){
var inst_32950 = (state_33000[(12)]);
var inst_32927 = inst_32950;
var state_33000__$1 = (function (){var statearr_33018 = state_33000;
(statearr_33018[(7)] = inst_32927);

return statearr_33018;
})();
var statearr_33019_33079 = state_33000__$1;
(statearr_33019_33079[(2)] = null);

(statearr_33019_33079[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (13))){
var inst_32927 = (state_33000[(7)]);
var inst_32934 = inst_32927.cljs$lang$protocol_mask$partition0$;
var inst_32935 = (inst_32934 & (64));
var inst_32936 = inst_32927.cljs$core$ISeq$;
var inst_32937 = (cljs.core.PROTOCOL_SENTINEL === inst_32936);
var inst_32938 = (inst_32935) || (inst_32937);
var state_33000__$1 = state_33000;
if(cljs.core.truth_(inst_32938)){
var statearr_33020_33080 = state_33000__$1;
(statearr_33020_33080[(1)] = (16));

} else {
var statearr_33021_33081 = state_33000__$1;
(statearr_33021_33081[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (22))){
var inst_32959 = (state_33000[(14)]);
var inst_32960 = (state_33000[(10)]);
var inst_32958 = (state_33000[(2)]);
var inst_32959__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32958,(0),null);
var inst_32960__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32958,(1),null);
var inst_32961 = (inst_32959__$1 == null);
var inst_32962 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32960__$1,change);
var inst_32963 = (inst_32961) || (inst_32962);
var state_33000__$1 = (function (){var statearr_33022 = state_33000;
(statearr_33022[(14)] = inst_32959__$1);

(statearr_33022[(10)] = inst_32960__$1);

return statearr_33022;
})();
if(cljs.core.truth_(inst_32963)){
var statearr_33023_33082 = state_33000__$1;
(statearr_33023_33082[(1)] = (23));

} else {
var statearr_33024_33083 = state_33000__$1;
(statearr_33024_33083[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (36))){
var inst_32950 = (state_33000[(12)]);
var inst_32927 = inst_32950;
var state_33000__$1 = (function (){var statearr_33025 = state_33000;
(statearr_33025[(7)] = inst_32927);

return statearr_33025;
})();
var statearr_33026_33084 = state_33000__$1;
(statearr_33026_33084[(2)] = null);

(statearr_33026_33084[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (29))){
var inst_32974 = (state_33000[(11)]);
var state_33000__$1 = state_33000;
var statearr_33027_33085 = state_33000__$1;
(statearr_33027_33085[(2)] = inst_32974);

(statearr_33027_33085[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (6))){
var state_33000__$1 = state_33000;
var statearr_33028_33086 = state_33000__$1;
(statearr_33028_33086[(2)] = false);

(statearr_33028_33086[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (28))){
var inst_32970 = (state_33000[(2)]);
var inst_32971 = calc_state();
var inst_32927 = inst_32971;
var state_33000__$1 = (function (){var statearr_33029 = state_33000;
(statearr_33029[(15)] = inst_32970);

(statearr_33029[(7)] = inst_32927);

return statearr_33029;
})();
var statearr_33030_33087 = state_33000__$1;
(statearr_33030_33087[(2)] = null);

(statearr_33030_33087[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (25))){
var inst_32996 = (state_33000[(2)]);
var state_33000__$1 = state_33000;
var statearr_33031_33088 = state_33000__$1;
(statearr_33031_33088[(2)] = inst_32996);

(statearr_33031_33088[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (34))){
var inst_32994 = (state_33000[(2)]);
var state_33000__$1 = state_33000;
var statearr_33032_33089 = state_33000__$1;
(statearr_33032_33089[(2)] = inst_32994);

(statearr_33032_33089[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (17))){
var state_33000__$1 = state_33000;
var statearr_33033_33090 = state_33000__$1;
(statearr_33033_33090[(2)] = false);

(statearr_33033_33090[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (3))){
var state_33000__$1 = state_33000;
var statearr_33034_33091 = state_33000__$1;
(statearr_33034_33091[(2)] = false);

(statearr_33034_33091[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (12))){
var inst_32998 = (state_33000[(2)]);
var state_33000__$1 = state_33000;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33000__$1,inst_32998);
} else {
if((state_val_33001 === (2))){
var inst_32902 = (state_33000[(8)]);
var inst_32907 = inst_32902.cljs$lang$protocol_mask$partition0$;
var inst_32908 = (inst_32907 & (64));
var inst_32909 = inst_32902.cljs$core$ISeq$;
var inst_32910 = (cljs.core.PROTOCOL_SENTINEL === inst_32909);
var inst_32911 = (inst_32908) || (inst_32910);
var state_33000__$1 = state_33000;
if(cljs.core.truth_(inst_32911)){
var statearr_33035_33092 = state_33000__$1;
(statearr_33035_33092[(1)] = (5));

} else {
var statearr_33036_33093 = state_33000__$1;
(statearr_33036_33093[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (23))){
var inst_32959 = (state_33000[(14)]);
var inst_32965 = (inst_32959 == null);
var state_33000__$1 = state_33000;
if(cljs.core.truth_(inst_32965)){
var statearr_33037_33094 = state_33000__$1;
(statearr_33037_33094[(1)] = (26));

} else {
var statearr_33038_33095 = state_33000__$1;
(statearr_33038_33095[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (35))){
var inst_32985 = (state_33000[(2)]);
var state_33000__$1 = state_33000;
if(cljs.core.truth_(inst_32985)){
var statearr_33039_33096 = state_33000__$1;
(statearr_33039_33096[(1)] = (36));

} else {
var statearr_33040_33097 = state_33000__$1;
(statearr_33040_33097[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (19))){
var inst_32927 = (state_33000[(7)]);
var inst_32947 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32927);
var state_33000__$1 = state_33000;
var statearr_33041_33098 = state_33000__$1;
(statearr_33041_33098[(2)] = inst_32947);

(statearr_33041_33098[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (11))){
var inst_32927 = (state_33000[(7)]);
var inst_32931 = (inst_32927 == null);
var inst_32932 = cljs.core.not(inst_32931);
var state_33000__$1 = state_33000;
if(inst_32932){
var statearr_33042_33099 = state_33000__$1;
(statearr_33042_33099[(1)] = (13));

} else {
var statearr_33043_33100 = state_33000__$1;
(statearr_33043_33100[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (9))){
var inst_32902 = (state_33000[(8)]);
var state_33000__$1 = state_33000;
var statearr_33044_33101 = state_33000__$1;
(statearr_33044_33101[(2)] = inst_32902);

(statearr_33044_33101[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (5))){
var state_33000__$1 = state_33000;
var statearr_33045_33102 = state_33000__$1;
(statearr_33045_33102[(2)] = true);

(statearr_33045_33102[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (14))){
var state_33000__$1 = state_33000;
var statearr_33046_33103 = state_33000__$1;
(statearr_33046_33103[(2)] = false);

(statearr_33046_33103[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (26))){
var inst_32960 = (state_33000[(10)]);
var inst_32967 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_32960);
var state_33000__$1 = state_33000;
var statearr_33047_33104 = state_33000__$1;
(statearr_33047_33104[(2)] = inst_32967);

(statearr_33047_33104[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (16))){
var state_33000__$1 = state_33000;
var statearr_33048_33105 = state_33000__$1;
(statearr_33048_33105[(2)] = true);

(statearr_33048_33105[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (38))){
var inst_32990 = (state_33000[(2)]);
var state_33000__$1 = state_33000;
var statearr_33049_33106 = state_33000__$1;
(statearr_33049_33106[(2)] = inst_32990);

(statearr_33049_33106[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (30))){
var inst_32951 = (state_33000[(9)]);
var inst_32960 = (state_33000[(10)]);
var inst_32952 = (state_33000[(13)]);
var inst_32977 = cljs.core.empty_QMARK_(inst_32951);
var inst_32978 = (inst_32952.cljs$core$IFn$_invoke$arity$1 ? inst_32952.cljs$core$IFn$_invoke$arity$1(inst_32960) : inst_32952.call(null,inst_32960));
var inst_32979 = cljs.core.not(inst_32978);
var inst_32980 = (inst_32977) && (inst_32979);
var state_33000__$1 = state_33000;
var statearr_33050_33107 = state_33000__$1;
(statearr_33050_33107[(2)] = inst_32980);

(statearr_33050_33107[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (10))){
var inst_32902 = (state_33000[(8)]);
var inst_32923 = (state_33000[(2)]);
var inst_32924 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32923,cljs.core.cst$kw$solos);
var inst_32925 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32923,cljs.core.cst$kw$mutes);
var inst_32926 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32923,cljs.core.cst$kw$reads);
var inst_32927 = inst_32902;
var state_33000__$1 = (function (){var statearr_33051 = state_33000;
(statearr_33051[(16)] = inst_32924);

(statearr_33051[(17)] = inst_32925);

(statearr_33051[(18)] = inst_32926);

(statearr_33051[(7)] = inst_32927);

return statearr_33051;
})();
var statearr_33052_33108 = state_33000__$1;
(statearr_33052_33108[(2)] = null);

(statearr_33052_33108[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (18))){
var inst_32942 = (state_33000[(2)]);
var state_33000__$1 = state_33000;
var statearr_33053_33109 = state_33000__$1;
(statearr_33053_33109[(2)] = inst_32942);

(statearr_33053_33109[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (37))){
var state_33000__$1 = state_33000;
var statearr_33054_33110 = state_33000__$1;
(statearr_33054_33110[(2)] = null);

(statearr_33054_33110[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (8))){
var inst_32902 = (state_33000[(8)]);
var inst_32920 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32902);
var state_33000__$1 = state_33000;
var statearr_33055_33111 = state_33000__$1;
(statearr_33055_33111[(2)] = inst_32920);

(statearr_33055_33111[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___33065,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__18977__auto__,c__19089__auto___33065,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__18978__auto__ = null;
var cljs$core$async$mix_$_state_machine__18978__auto____0 = (function (){
var statearr_33059 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33059[(0)] = cljs$core$async$mix_$_state_machine__18978__auto__);

(statearr_33059[(1)] = (1));

return statearr_33059;
});
var cljs$core$async$mix_$_state_machine__18978__auto____1 = (function (state_33000){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_33000);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e33060){if((e33060 instanceof Object)){
var ex__18981__auto__ = e33060;
var statearr_33061_33112 = state_33000;
(statearr_33061_33112[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33000);

return cljs.core.cst$kw$recur;
} else {
throw e33060;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__33113 = state_33000;
state_33000 = G__33113;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__18978__auto__ = function(state_33000){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__18978__auto____1.call(this,state_33000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__18978__auto____0;
cljs$core$async$mix_$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__18978__auto____1;
return cljs$core$async$mix_$_state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___33065,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__19091__auto__ = (function (){var statearr_33062 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_33062[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___33065);

return statearr_33062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___33065,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7207__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7207__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7207__auto__.call(null,p,v,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7207__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args33114 = [];
var len__7651__auto___33117 = arguments.length;
var i__7652__auto___33118 = (0);
while(true){
if((i__7652__auto___33118 < len__7651__auto___33117)){
args33114.push((arguments[i__7652__auto___33118]));

var G__33119 = (i__7652__auto___33118 + (1));
i__7652__auto___33118 = G__33119;
continue;
} else {
}
break;
}

var G__33116 = args33114.length;
switch (G__33116) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33114.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7207__auto__.call(null,p));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7207__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7207__auto__.call(null,p,v));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7207__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args33122 = [];
var len__7651__auto___33250 = arguments.length;
var i__7652__auto___33251 = (0);
while(true){
if((i__7652__auto___33251 < len__7651__auto___33250)){
args33122.push((arguments[i__7652__auto___33251]));

var G__33252 = (i__7652__auto___33251 + (1));
i__7652__auto___33251 = G__33252;
continue;
} else {
}
break;
}

var G__33124 = args33122.length;
switch (G__33124) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33122.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__33125 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33125) : cljs.core.atom.call(null,G__33125));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6543__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6543__auto__,mults){
return (function (p1__33121_SHARP_){
if(cljs.core.truth_((p1__33121_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33121_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__33121_SHARP_.call(null,topic)))){
return p1__33121_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__33121_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6543__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async33126 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33126 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta33127){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta33127 = meta33127;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33126.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_33128,meta33127__$1){
var self__ = this;
var _33128__$1 = this;
return (new cljs.core.async.t_cljs$core$async33126(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta33127__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33126.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_33128){
var self__ = this;
var _33128__$1 = this;
return self__.meta33127;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33126.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33126.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33126.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33126.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33126.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33126.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__33129 = self__.mults;
var G__33130 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__33129,G__33130) : cljs.core.reset_BANG_.call(null,G__33129,G__33130));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33126.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33126.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta33127], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33126.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33126.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33126";

cljs.core.async.t_cljs$core$async33126.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33126");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async33126 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async33126(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33127){
return (new cljs.core.async.t_cljs$core$async33126(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33127));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async33126(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19089__auto___33254 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___33254,mults,ensure_mult,p){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___33254,mults,ensure_mult,p){
return (function (state_33202){
var state_val_33203 = (state_33202[(1)]);
if((state_val_33203 === (7))){
var inst_33198 = (state_33202[(2)]);
var state_33202__$1 = state_33202;
var statearr_33204_33255 = state_33202__$1;
(statearr_33204_33255[(2)] = inst_33198);

(statearr_33204_33255[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (20))){
var state_33202__$1 = state_33202;
var statearr_33205_33256 = state_33202__$1;
(statearr_33205_33256[(2)] = null);

(statearr_33205_33256[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (1))){
var state_33202__$1 = state_33202;
var statearr_33206_33257 = state_33202__$1;
(statearr_33206_33257[(2)] = null);

(statearr_33206_33257[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (24))){
var inst_33181 = (state_33202[(7)]);
var inst_33190 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_33181);
var state_33202__$1 = state_33202;
var statearr_33207_33258 = state_33202__$1;
(statearr_33207_33258[(2)] = inst_33190);

(statearr_33207_33258[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (4))){
var inst_33133 = (state_33202[(8)]);
var inst_33133__$1 = (state_33202[(2)]);
var inst_33134 = (inst_33133__$1 == null);
var state_33202__$1 = (function (){var statearr_33208 = state_33202;
(statearr_33208[(8)] = inst_33133__$1);

return statearr_33208;
})();
if(cljs.core.truth_(inst_33134)){
var statearr_33209_33259 = state_33202__$1;
(statearr_33209_33259[(1)] = (5));

} else {
var statearr_33210_33260 = state_33202__$1;
(statearr_33210_33260[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (15))){
var inst_33175 = (state_33202[(2)]);
var state_33202__$1 = state_33202;
var statearr_33211_33261 = state_33202__$1;
(statearr_33211_33261[(2)] = inst_33175);

(statearr_33211_33261[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (21))){
var inst_33195 = (state_33202[(2)]);
var state_33202__$1 = (function (){var statearr_33212 = state_33202;
(statearr_33212[(9)] = inst_33195);

return statearr_33212;
})();
var statearr_33213_33262 = state_33202__$1;
(statearr_33213_33262[(2)] = null);

(statearr_33213_33262[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (13))){
var inst_33157 = (state_33202[(10)]);
var inst_33159 = cljs.core.chunked_seq_QMARK_(inst_33157);
var state_33202__$1 = state_33202;
if(inst_33159){
var statearr_33214_33263 = state_33202__$1;
(statearr_33214_33263[(1)] = (16));

} else {
var statearr_33215_33264 = state_33202__$1;
(statearr_33215_33264[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (22))){
var inst_33187 = (state_33202[(2)]);
var state_33202__$1 = state_33202;
if(cljs.core.truth_(inst_33187)){
var statearr_33216_33265 = state_33202__$1;
(statearr_33216_33265[(1)] = (23));

} else {
var statearr_33217_33266 = state_33202__$1;
(statearr_33217_33266[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (6))){
var inst_33183 = (state_33202[(11)]);
var inst_33133 = (state_33202[(8)]);
var inst_33181 = (state_33202[(7)]);
var inst_33181__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_33133) : topic_fn.call(null,inst_33133));
var inst_33182 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33183__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33182,inst_33181__$1);
var state_33202__$1 = (function (){var statearr_33218 = state_33202;
(statearr_33218[(11)] = inst_33183__$1);

(statearr_33218[(7)] = inst_33181__$1);

return statearr_33218;
})();
if(cljs.core.truth_(inst_33183__$1)){
var statearr_33219_33267 = state_33202__$1;
(statearr_33219_33267[(1)] = (19));

} else {
var statearr_33220_33268 = state_33202__$1;
(statearr_33220_33268[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (25))){
var inst_33192 = (state_33202[(2)]);
var state_33202__$1 = state_33202;
var statearr_33221_33269 = state_33202__$1;
(statearr_33221_33269[(2)] = inst_33192);

(statearr_33221_33269[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (17))){
var inst_33157 = (state_33202[(10)]);
var inst_33166 = cljs.core.first(inst_33157);
var inst_33167 = cljs.core.async.muxch_STAR_(inst_33166);
var inst_33168 = cljs.core.async.close_BANG_(inst_33167);
var inst_33169 = cljs.core.next(inst_33157);
var inst_33143 = inst_33169;
var inst_33144 = null;
var inst_33145 = (0);
var inst_33146 = (0);
var state_33202__$1 = (function (){var statearr_33222 = state_33202;
(statearr_33222[(12)] = inst_33144);

(statearr_33222[(13)] = inst_33146);

(statearr_33222[(14)] = inst_33145);

(statearr_33222[(15)] = inst_33168);

(statearr_33222[(16)] = inst_33143);

return statearr_33222;
})();
var statearr_33223_33270 = state_33202__$1;
(statearr_33223_33270[(2)] = null);

(statearr_33223_33270[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (3))){
var inst_33200 = (state_33202[(2)]);
var state_33202__$1 = state_33202;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33202__$1,inst_33200);
} else {
if((state_val_33203 === (12))){
var inst_33177 = (state_33202[(2)]);
var state_33202__$1 = state_33202;
var statearr_33224_33271 = state_33202__$1;
(statearr_33224_33271[(2)] = inst_33177);

(statearr_33224_33271[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (2))){
var state_33202__$1 = state_33202;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33202__$1,(4),ch);
} else {
if((state_val_33203 === (23))){
var state_33202__$1 = state_33202;
var statearr_33225_33272 = state_33202__$1;
(statearr_33225_33272[(2)] = null);

(statearr_33225_33272[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (19))){
var inst_33183 = (state_33202[(11)]);
var inst_33133 = (state_33202[(8)]);
var inst_33185 = cljs.core.async.muxch_STAR_(inst_33183);
var state_33202__$1 = state_33202;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33202__$1,(22),inst_33185,inst_33133);
} else {
if((state_val_33203 === (11))){
var inst_33157 = (state_33202[(10)]);
var inst_33143 = (state_33202[(16)]);
var inst_33157__$1 = cljs.core.seq(inst_33143);
var state_33202__$1 = (function (){var statearr_33226 = state_33202;
(statearr_33226[(10)] = inst_33157__$1);

return statearr_33226;
})();
if(inst_33157__$1){
var statearr_33227_33273 = state_33202__$1;
(statearr_33227_33273[(1)] = (13));

} else {
var statearr_33228_33274 = state_33202__$1;
(statearr_33228_33274[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (9))){
var inst_33179 = (state_33202[(2)]);
var state_33202__$1 = state_33202;
var statearr_33229_33275 = state_33202__$1;
(statearr_33229_33275[(2)] = inst_33179);

(statearr_33229_33275[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (5))){
var inst_33140 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33141 = cljs.core.vals(inst_33140);
var inst_33142 = cljs.core.seq(inst_33141);
var inst_33143 = inst_33142;
var inst_33144 = null;
var inst_33145 = (0);
var inst_33146 = (0);
var state_33202__$1 = (function (){var statearr_33230 = state_33202;
(statearr_33230[(12)] = inst_33144);

(statearr_33230[(13)] = inst_33146);

(statearr_33230[(14)] = inst_33145);

(statearr_33230[(16)] = inst_33143);

return statearr_33230;
})();
var statearr_33231_33276 = state_33202__$1;
(statearr_33231_33276[(2)] = null);

(statearr_33231_33276[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (14))){
var state_33202__$1 = state_33202;
var statearr_33235_33277 = state_33202__$1;
(statearr_33235_33277[(2)] = null);

(statearr_33235_33277[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (16))){
var inst_33157 = (state_33202[(10)]);
var inst_33161 = cljs.core.chunk_first(inst_33157);
var inst_33162 = cljs.core.chunk_rest(inst_33157);
var inst_33163 = cljs.core.count(inst_33161);
var inst_33143 = inst_33162;
var inst_33144 = inst_33161;
var inst_33145 = inst_33163;
var inst_33146 = (0);
var state_33202__$1 = (function (){var statearr_33236 = state_33202;
(statearr_33236[(12)] = inst_33144);

(statearr_33236[(13)] = inst_33146);

(statearr_33236[(14)] = inst_33145);

(statearr_33236[(16)] = inst_33143);

return statearr_33236;
})();
var statearr_33237_33278 = state_33202__$1;
(statearr_33237_33278[(2)] = null);

(statearr_33237_33278[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (10))){
var inst_33144 = (state_33202[(12)]);
var inst_33146 = (state_33202[(13)]);
var inst_33145 = (state_33202[(14)]);
var inst_33143 = (state_33202[(16)]);
var inst_33151 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33144,inst_33146);
var inst_33152 = cljs.core.async.muxch_STAR_(inst_33151);
var inst_33153 = cljs.core.async.close_BANG_(inst_33152);
var inst_33154 = (inst_33146 + (1));
var tmp33232 = inst_33144;
var tmp33233 = inst_33145;
var tmp33234 = inst_33143;
var inst_33143__$1 = tmp33234;
var inst_33144__$1 = tmp33232;
var inst_33145__$1 = tmp33233;
var inst_33146__$1 = inst_33154;
var state_33202__$1 = (function (){var statearr_33238 = state_33202;
(statearr_33238[(12)] = inst_33144__$1);

(statearr_33238[(17)] = inst_33153);

(statearr_33238[(13)] = inst_33146__$1);

(statearr_33238[(14)] = inst_33145__$1);

(statearr_33238[(16)] = inst_33143__$1);

return statearr_33238;
})();
var statearr_33239_33279 = state_33202__$1;
(statearr_33239_33279[(2)] = null);

(statearr_33239_33279[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (18))){
var inst_33172 = (state_33202[(2)]);
var state_33202__$1 = state_33202;
var statearr_33240_33280 = state_33202__$1;
(statearr_33240_33280[(2)] = inst_33172);

(statearr_33240_33280[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33203 === (8))){
var inst_33146 = (state_33202[(13)]);
var inst_33145 = (state_33202[(14)]);
var inst_33148 = (inst_33146 < inst_33145);
var inst_33149 = inst_33148;
var state_33202__$1 = state_33202;
if(cljs.core.truth_(inst_33149)){
var statearr_33241_33281 = state_33202__$1;
(statearr_33241_33281[(1)] = (10));

} else {
var statearr_33242_33282 = state_33202__$1;
(statearr_33242_33282[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___33254,mults,ensure_mult,p))
;
return ((function (switch__18977__auto__,c__19089__auto___33254,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__18978__auto__ = null;
var cljs$core$async$state_machine__18978__auto____0 = (function (){
var statearr_33246 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33246[(0)] = cljs$core$async$state_machine__18978__auto__);

(statearr_33246[(1)] = (1));

return statearr_33246;
});
var cljs$core$async$state_machine__18978__auto____1 = (function (state_33202){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_33202);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e33247){if((e33247 instanceof Object)){
var ex__18981__auto__ = e33247;
var statearr_33248_33283 = state_33202;
(statearr_33248_33283[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33202);

return cljs.core.cst$kw$recur;
} else {
throw e33247;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__33284 = state_33202;
state_33202 = G__33284;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$state_machine__18978__auto__ = function(state_33202){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18978__auto____1.call(this,state_33202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18978__auto____0;
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18978__auto____1;
return cljs$core$async$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___33254,mults,ensure_mult,p))
})();
var state__19091__auto__ = (function (){var statearr_33249 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_33249[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___33254);

return statearr_33249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___33254,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args33285 = [];
var len__7651__auto___33288 = arguments.length;
var i__7652__auto___33289 = (0);
while(true){
if((i__7652__auto___33289 < len__7651__auto___33288)){
args33285.push((arguments[i__7652__auto___33289]));

var G__33290 = (i__7652__auto___33289 + (1));
i__7652__auto___33289 = G__33290;
continue;
} else {
}
break;
}

var G__33287 = args33285.length;
switch (G__33287) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33285.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args33292 = [];
var len__7651__auto___33295 = arguments.length;
var i__7652__auto___33296 = (0);
while(true){
if((i__7652__auto___33296 < len__7651__auto___33295)){
args33292.push((arguments[i__7652__auto___33296]));

var G__33297 = (i__7652__auto___33296 + (1));
i__7652__auto___33296 = G__33297;
continue;
} else {
}
break;
}

var G__33294 = args33292.length;
switch (G__33294) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33292.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args33299 = [];
var len__7651__auto___33370 = arguments.length;
var i__7652__auto___33371 = (0);
while(true){
if((i__7652__auto___33371 < len__7651__auto___33370)){
args33299.push((arguments[i__7652__auto___33371]));

var G__33372 = (i__7652__auto___33371 + (1));
i__7652__auto___33371 = G__33372;
continue;
} else {
}
break;
}

var G__33301 = args33299.length;
switch (G__33301) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33299.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__19089__auto___33374 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___33374,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___33374,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33340){
var state_val_33341 = (state_33340[(1)]);
if((state_val_33341 === (7))){
var state_33340__$1 = state_33340;
var statearr_33342_33375 = state_33340__$1;
(statearr_33342_33375[(2)] = null);

(statearr_33342_33375[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33341 === (1))){
var state_33340__$1 = state_33340;
var statearr_33343_33376 = state_33340__$1;
(statearr_33343_33376[(2)] = null);

(statearr_33343_33376[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33341 === (4))){
var inst_33304 = (state_33340[(7)]);
var inst_33306 = (inst_33304 < cnt);
var state_33340__$1 = state_33340;
if(cljs.core.truth_(inst_33306)){
var statearr_33344_33377 = state_33340__$1;
(statearr_33344_33377[(1)] = (6));

} else {
var statearr_33345_33378 = state_33340__$1;
(statearr_33345_33378[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33341 === (15))){
var inst_33336 = (state_33340[(2)]);
var state_33340__$1 = state_33340;
var statearr_33346_33379 = state_33340__$1;
(statearr_33346_33379[(2)] = inst_33336);

(statearr_33346_33379[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33341 === (13))){
var inst_33329 = cljs.core.async.close_BANG_(out);
var state_33340__$1 = state_33340;
var statearr_33347_33380 = state_33340__$1;
(statearr_33347_33380[(2)] = inst_33329);

(statearr_33347_33380[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33341 === (6))){
var state_33340__$1 = state_33340;
var statearr_33348_33381 = state_33340__$1;
(statearr_33348_33381[(2)] = null);

(statearr_33348_33381[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33341 === (3))){
var inst_33338 = (state_33340[(2)]);
var state_33340__$1 = state_33340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33340__$1,inst_33338);
} else {
if((state_val_33341 === (12))){
var inst_33326 = (state_33340[(8)]);
var inst_33326__$1 = (state_33340[(2)]);
var inst_33327 = cljs.core.some(cljs.core.nil_QMARK_,inst_33326__$1);
var state_33340__$1 = (function (){var statearr_33349 = state_33340;
(statearr_33349[(8)] = inst_33326__$1);

return statearr_33349;
})();
if(cljs.core.truth_(inst_33327)){
var statearr_33350_33382 = state_33340__$1;
(statearr_33350_33382[(1)] = (13));

} else {
var statearr_33351_33383 = state_33340__$1;
(statearr_33351_33383[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33341 === (2))){
var inst_33303 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_33304 = (0);
var state_33340__$1 = (function (){var statearr_33352 = state_33340;
(statearr_33352[(9)] = inst_33303);

(statearr_33352[(7)] = inst_33304);

return statearr_33352;
})();
var statearr_33353_33384 = state_33340__$1;
(statearr_33353_33384[(2)] = null);

(statearr_33353_33384[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33341 === (11))){
var inst_33304 = (state_33340[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_33340,(10),Object,null,(9));
var inst_33313 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_33304) : chs__$1.call(null,inst_33304));
var inst_33314 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_33304) : done.call(null,inst_33304));
var inst_33315 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33313,inst_33314);
var state_33340__$1 = state_33340;
var statearr_33354_33385 = state_33340__$1;
(statearr_33354_33385[(2)] = inst_33315);


cljs.core.async.impl.ioc_helpers.process_exception(state_33340__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33341 === (9))){
var inst_33304 = (state_33340[(7)]);
var inst_33317 = (state_33340[(2)]);
var inst_33318 = (inst_33304 + (1));
var inst_33304__$1 = inst_33318;
var state_33340__$1 = (function (){var statearr_33355 = state_33340;
(statearr_33355[(10)] = inst_33317);

(statearr_33355[(7)] = inst_33304__$1);

return statearr_33355;
})();
var statearr_33356_33386 = state_33340__$1;
(statearr_33356_33386[(2)] = null);

(statearr_33356_33386[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33341 === (5))){
var inst_33324 = (state_33340[(2)]);
var state_33340__$1 = (function (){var statearr_33357 = state_33340;
(statearr_33357[(11)] = inst_33324);

return statearr_33357;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33340__$1,(12),dchan);
} else {
if((state_val_33341 === (14))){
var inst_33326 = (state_33340[(8)]);
var inst_33331 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_33326);
var state_33340__$1 = state_33340;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33340__$1,(16),out,inst_33331);
} else {
if((state_val_33341 === (16))){
var inst_33333 = (state_33340[(2)]);
var state_33340__$1 = (function (){var statearr_33358 = state_33340;
(statearr_33358[(12)] = inst_33333);

return statearr_33358;
})();
var statearr_33359_33387 = state_33340__$1;
(statearr_33359_33387[(2)] = null);

(statearr_33359_33387[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33341 === (10))){
var inst_33308 = (state_33340[(2)]);
var inst_33309 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_33340__$1 = (function (){var statearr_33360 = state_33340;
(statearr_33360[(13)] = inst_33308);

return statearr_33360;
})();
var statearr_33361_33388 = state_33340__$1;
(statearr_33361_33388[(2)] = inst_33309);


cljs.core.async.impl.ioc_helpers.process_exception(state_33340__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33341 === (8))){
var inst_33322 = (state_33340[(2)]);
var state_33340__$1 = state_33340;
var statearr_33362_33389 = state_33340__$1;
(statearr_33362_33389[(2)] = inst_33322);

(statearr_33362_33389[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___33374,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__18977__auto__,c__19089__auto___33374,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__18978__auto__ = null;
var cljs$core$async$state_machine__18978__auto____0 = (function (){
var statearr_33366 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33366[(0)] = cljs$core$async$state_machine__18978__auto__);

(statearr_33366[(1)] = (1));

return statearr_33366;
});
var cljs$core$async$state_machine__18978__auto____1 = (function (state_33340){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_33340);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e33367){if((e33367 instanceof Object)){
var ex__18981__auto__ = e33367;
var statearr_33368_33390 = state_33340;
(statearr_33368_33390[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33340);

return cljs.core.cst$kw$recur;
} else {
throw e33367;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__33391 = state_33340;
state_33340 = G__33391;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$state_machine__18978__auto__ = function(state_33340){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18978__auto____1.call(this,state_33340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18978__auto____0;
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18978__auto____1;
return cljs$core$async$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___33374,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__19091__auto__ = (function (){var statearr_33369 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_33369[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___33374);

return statearr_33369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___33374,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args33393 = [];
var len__7651__auto___33451 = arguments.length;
var i__7652__auto___33452 = (0);
while(true){
if((i__7652__auto___33452 < len__7651__auto___33451)){
args33393.push((arguments[i__7652__auto___33452]));

var G__33453 = (i__7652__auto___33452 + (1));
i__7652__auto___33452 = G__33453;
continue;
} else {
}
break;
}

var G__33395 = args33393.length;
switch (G__33395) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33393.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19089__auto___33455 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___33455,out){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___33455,out){
return (function (state_33427){
var state_val_33428 = (state_33427[(1)]);
if((state_val_33428 === (7))){
var inst_33406 = (state_33427[(7)]);
var inst_33407 = (state_33427[(8)]);
var inst_33406__$1 = (state_33427[(2)]);
var inst_33407__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33406__$1,(0),null);
var inst_33408 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33406__$1,(1),null);
var inst_33409 = (inst_33407__$1 == null);
var state_33427__$1 = (function (){var statearr_33429 = state_33427;
(statearr_33429[(7)] = inst_33406__$1);

(statearr_33429[(8)] = inst_33407__$1);

(statearr_33429[(9)] = inst_33408);

return statearr_33429;
})();
if(cljs.core.truth_(inst_33409)){
var statearr_33430_33456 = state_33427__$1;
(statearr_33430_33456[(1)] = (8));

} else {
var statearr_33431_33457 = state_33427__$1;
(statearr_33431_33457[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (1))){
var inst_33396 = cljs.core.vec(chs);
var inst_33397 = inst_33396;
var state_33427__$1 = (function (){var statearr_33432 = state_33427;
(statearr_33432[(10)] = inst_33397);

return statearr_33432;
})();
var statearr_33433_33458 = state_33427__$1;
(statearr_33433_33458[(2)] = null);

(statearr_33433_33458[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (4))){
var inst_33397 = (state_33427[(10)]);
var state_33427__$1 = state_33427;
return cljs.core.async.ioc_alts_BANG_(state_33427__$1,(7),inst_33397);
} else {
if((state_val_33428 === (6))){
var inst_33423 = (state_33427[(2)]);
var state_33427__$1 = state_33427;
var statearr_33434_33459 = state_33427__$1;
(statearr_33434_33459[(2)] = inst_33423);

(statearr_33434_33459[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (3))){
var inst_33425 = (state_33427[(2)]);
var state_33427__$1 = state_33427;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33427__$1,inst_33425);
} else {
if((state_val_33428 === (2))){
var inst_33397 = (state_33427[(10)]);
var inst_33399 = cljs.core.count(inst_33397);
var inst_33400 = (inst_33399 > (0));
var state_33427__$1 = state_33427;
if(cljs.core.truth_(inst_33400)){
var statearr_33436_33460 = state_33427__$1;
(statearr_33436_33460[(1)] = (4));

} else {
var statearr_33437_33461 = state_33427__$1;
(statearr_33437_33461[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (11))){
var inst_33397 = (state_33427[(10)]);
var inst_33416 = (state_33427[(2)]);
var tmp33435 = inst_33397;
var inst_33397__$1 = tmp33435;
var state_33427__$1 = (function (){var statearr_33438 = state_33427;
(statearr_33438[(10)] = inst_33397__$1);

(statearr_33438[(11)] = inst_33416);

return statearr_33438;
})();
var statearr_33439_33462 = state_33427__$1;
(statearr_33439_33462[(2)] = null);

(statearr_33439_33462[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (9))){
var inst_33407 = (state_33427[(8)]);
var state_33427__$1 = state_33427;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33427__$1,(11),out,inst_33407);
} else {
if((state_val_33428 === (5))){
var inst_33421 = cljs.core.async.close_BANG_(out);
var state_33427__$1 = state_33427;
var statearr_33440_33463 = state_33427__$1;
(statearr_33440_33463[(2)] = inst_33421);

(statearr_33440_33463[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (10))){
var inst_33419 = (state_33427[(2)]);
var state_33427__$1 = state_33427;
var statearr_33441_33464 = state_33427__$1;
(statearr_33441_33464[(2)] = inst_33419);

(statearr_33441_33464[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (8))){
var inst_33406 = (state_33427[(7)]);
var inst_33407 = (state_33427[(8)]);
var inst_33408 = (state_33427[(9)]);
var inst_33397 = (state_33427[(10)]);
var inst_33411 = (function (){var cs = inst_33397;
var vec__33402 = inst_33406;
var v = inst_33407;
var c = inst_33408;
return ((function (cs,vec__33402,v,c,inst_33406,inst_33407,inst_33408,inst_33397,state_val_33428,c__19089__auto___33455,out){
return (function (p1__33392_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33392_SHARP_);
});
;})(cs,vec__33402,v,c,inst_33406,inst_33407,inst_33408,inst_33397,state_val_33428,c__19089__auto___33455,out))
})();
var inst_33412 = cljs.core.filterv(inst_33411,inst_33397);
var inst_33397__$1 = inst_33412;
var state_33427__$1 = (function (){var statearr_33442 = state_33427;
(statearr_33442[(10)] = inst_33397__$1);

return statearr_33442;
})();
var statearr_33443_33465 = state_33427__$1;
(statearr_33443_33465[(2)] = null);

(statearr_33443_33465[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___33455,out))
;
return ((function (switch__18977__auto__,c__19089__auto___33455,out){
return (function() {
var cljs$core$async$state_machine__18978__auto__ = null;
var cljs$core$async$state_machine__18978__auto____0 = (function (){
var statearr_33447 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33447[(0)] = cljs$core$async$state_machine__18978__auto__);

(statearr_33447[(1)] = (1));

return statearr_33447;
});
var cljs$core$async$state_machine__18978__auto____1 = (function (state_33427){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_33427);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e33448){if((e33448 instanceof Object)){
var ex__18981__auto__ = e33448;
var statearr_33449_33466 = state_33427;
(statearr_33449_33466[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33427);

return cljs.core.cst$kw$recur;
} else {
throw e33448;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__33467 = state_33427;
state_33427 = G__33467;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$state_machine__18978__auto__ = function(state_33427){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18978__auto____1.call(this,state_33427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18978__auto____0;
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18978__auto____1;
return cljs$core$async$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___33455,out))
})();
var state__19091__auto__ = (function (){var statearr_33450 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_33450[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___33455);

return statearr_33450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___33455,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args33468 = [];
var len__7651__auto___33517 = arguments.length;
var i__7652__auto___33518 = (0);
while(true){
if((i__7652__auto___33518 < len__7651__auto___33517)){
args33468.push((arguments[i__7652__auto___33518]));

var G__33519 = (i__7652__auto___33518 + (1));
i__7652__auto___33518 = G__33519;
continue;
} else {
}
break;
}

var G__33470 = args33468.length;
switch (G__33470) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33468.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19089__auto___33521 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___33521,out){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___33521,out){
return (function (state_33494){
var state_val_33495 = (state_33494[(1)]);
if((state_val_33495 === (7))){
var inst_33476 = (state_33494[(7)]);
var inst_33476__$1 = (state_33494[(2)]);
var inst_33477 = (inst_33476__$1 == null);
var inst_33478 = cljs.core.not(inst_33477);
var state_33494__$1 = (function (){var statearr_33496 = state_33494;
(statearr_33496[(7)] = inst_33476__$1);

return statearr_33496;
})();
if(inst_33478){
var statearr_33497_33522 = state_33494__$1;
(statearr_33497_33522[(1)] = (8));

} else {
var statearr_33498_33523 = state_33494__$1;
(statearr_33498_33523[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33495 === (1))){
var inst_33471 = (0);
var state_33494__$1 = (function (){var statearr_33499 = state_33494;
(statearr_33499[(8)] = inst_33471);

return statearr_33499;
})();
var statearr_33500_33524 = state_33494__$1;
(statearr_33500_33524[(2)] = null);

(statearr_33500_33524[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33495 === (4))){
var state_33494__$1 = state_33494;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33494__$1,(7),ch);
} else {
if((state_val_33495 === (6))){
var inst_33489 = (state_33494[(2)]);
var state_33494__$1 = state_33494;
var statearr_33501_33525 = state_33494__$1;
(statearr_33501_33525[(2)] = inst_33489);

(statearr_33501_33525[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33495 === (3))){
var inst_33491 = (state_33494[(2)]);
var inst_33492 = cljs.core.async.close_BANG_(out);
var state_33494__$1 = (function (){var statearr_33502 = state_33494;
(statearr_33502[(9)] = inst_33491);

return statearr_33502;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33494__$1,inst_33492);
} else {
if((state_val_33495 === (2))){
var inst_33471 = (state_33494[(8)]);
var inst_33473 = (inst_33471 < n);
var state_33494__$1 = state_33494;
if(cljs.core.truth_(inst_33473)){
var statearr_33503_33526 = state_33494__$1;
(statearr_33503_33526[(1)] = (4));

} else {
var statearr_33504_33527 = state_33494__$1;
(statearr_33504_33527[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33495 === (11))){
var inst_33471 = (state_33494[(8)]);
var inst_33481 = (state_33494[(2)]);
var inst_33482 = (inst_33471 + (1));
var inst_33471__$1 = inst_33482;
var state_33494__$1 = (function (){var statearr_33505 = state_33494;
(statearr_33505[(8)] = inst_33471__$1);

(statearr_33505[(10)] = inst_33481);

return statearr_33505;
})();
var statearr_33506_33528 = state_33494__$1;
(statearr_33506_33528[(2)] = null);

(statearr_33506_33528[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33495 === (9))){
var state_33494__$1 = state_33494;
var statearr_33507_33529 = state_33494__$1;
(statearr_33507_33529[(2)] = null);

(statearr_33507_33529[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33495 === (5))){
var state_33494__$1 = state_33494;
var statearr_33508_33530 = state_33494__$1;
(statearr_33508_33530[(2)] = null);

(statearr_33508_33530[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33495 === (10))){
var inst_33486 = (state_33494[(2)]);
var state_33494__$1 = state_33494;
var statearr_33509_33531 = state_33494__$1;
(statearr_33509_33531[(2)] = inst_33486);

(statearr_33509_33531[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33495 === (8))){
var inst_33476 = (state_33494[(7)]);
var state_33494__$1 = state_33494;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33494__$1,(11),out,inst_33476);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___33521,out))
;
return ((function (switch__18977__auto__,c__19089__auto___33521,out){
return (function() {
var cljs$core$async$state_machine__18978__auto__ = null;
var cljs$core$async$state_machine__18978__auto____0 = (function (){
var statearr_33513 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33513[(0)] = cljs$core$async$state_machine__18978__auto__);

(statearr_33513[(1)] = (1));

return statearr_33513;
});
var cljs$core$async$state_machine__18978__auto____1 = (function (state_33494){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_33494);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e33514){if((e33514 instanceof Object)){
var ex__18981__auto__ = e33514;
var statearr_33515_33532 = state_33494;
(statearr_33515_33532[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33494);

return cljs.core.cst$kw$recur;
} else {
throw e33514;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__33533 = state_33494;
state_33494 = G__33533;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$state_machine__18978__auto__ = function(state_33494){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18978__auto____1.call(this,state_33494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18978__auto____0;
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18978__auto____1;
return cljs$core$async$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___33521,out))
})();
var state__19091__auto__ = (function (){var statearr_33516 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_33516[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___33521);

return statearr_33516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___33521,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33543 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33543 = (function (f,ch,meta33544){
this.f = f;
this.ch = ch;
this.meta33544 = meta33544;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33543.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33545,meta33544__$1){
var self__ = this;
var _33545__$1 = this;
return (new cljs.core.async.t_cljs$core$async33543(self__.f,self__.ch,meta33544__$1));
});

cljs.core.async.t_cljs$core$async33543.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33545){
var self__ = this;
var _33545__$1 = this;
return self__.meta33544;
});

cljs.core.async.t_cljs$core$async33543.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33543.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33543.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33543.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33543.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async33546 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33546 = (function (f,ch,meta33544,_,fn1,meta33547){
this.f = f;
this.ch = ch;
this.meta33544 = meta33544;
this._ = _;
this.fn1 = fn1;
this.meta33547 = meta33547;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33546.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_33548,meta33547__$1){
var self__ = this;
var _33548__$1 = this;
return (new cljs.core.async.t_cljs$core$async33546(self__.f,self__.ch,self__.meta33544,self__._,self__.fn1,meta33547__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async33546.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_33548){
var self__ = this;
var _33548__$1 = this;
return self__.meta33547;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33546.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33546.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33546.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33546.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__33534_SHARP_){
var G__33549 = (((p1__33534_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33534_SHARP_) : self__.f.call(null,p1__33534_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33549) : f1.call(null,G__33549));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async33546.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33544,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async33543], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta33547], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33546.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33546.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33546";

cljs.core.async.t_cljs$core$async33546.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33546");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async33546 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33546(f__$1,ch__$1,meta33544__$1,___$2,fn1__$1,meta33547){
return (new cljs.core.async.t_cljs$core$async33546(f__$1,ch__$1,meta33544__$1,___$2,fn1__$1,meta33547));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async33546(self__.f,self__.ch,self__.meta33544,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6531__auto__ = ret;
if(cljs.core.truth_(and__6531__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33550 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33550) : self__.f.call(null,G__33550));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async33543.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33543.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async33543.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33544], null);
});

cljs.core.async.t_cljs$core$async33543.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33543.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33543";

cljs.core.async.t_cljs$core$async33543.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33543");
});

cljs.core.async.__GT_t_cljs$core$async33543 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33543(f__$1,ch__$1,meta33544){
return (new cljs.core.async.t_cljs$core$async33543(f__$1,ch__$1,meta33544));
});

}

return (new cljs.core.async.t_cljs$core$async33543(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33554 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33554 = (function (f,ch,meta33555){
this.f = f;
this.ch = ch;
this.meta33555 = meta33555;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33554.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33556,meta33555__$1){
var self__ = this;
var _33556__$1 = this;
return (new cljs.core.async.t_cljs$core$async33554(self__.f,self__.ch,meta33555__$1));
});

cljs.core.async.t_cljs$core$async33554.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33556){
var self__ = this;
var _33556__$1 = this;
return self__.meta33555;
});

cljs.core.async.t_cljs$core$async33554.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33554.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33554.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33554.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33554.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33554.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async33554.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33555], null);
});

cljs.core.async.t_cljs$core$async33554.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33554.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33554";

cljs.core.async.t_cljs$core$async33554.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33554");
});

cljs.core.async.__GT_t_cljs$core$async33554 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33554(f__$1,ch__$1,meta33555){
return (new cljs.core.async.t_cljs$core$async33554(f__$1,ch__$1,meta33555));
});

}

return (new cljs.core.async.t_cljs$core$async33554(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async33560 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33560 = (function (p,ch,meta33561){
this.p = p;
this.ch = ch;
this.meta33561 = meta33561;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33560.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33562,meta33561__$1){
var self__ = this;
var _33562__$1 = this;
return (new cljs.core.async.t_cljs$core$async33560(self__.p,self__.ch,meta33561__$1));
});

cljs.core.async.t_cljs$core$async33560.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33562){
var self__ = this;
var _33562__$1 = this;
return self__.meta33561;
});

cljs.core.async.t_cljs$core$async33560.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33560.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33560.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33560.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33560.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33560.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33560.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async33560.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33561], null);
});

cljs.core.async.t_cljs$core$async33560.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33560.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33560";

cljs.core.async.t_cljs$core$async33560.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33560");
});

cljs.core.async.__GT_t_cljs$core$async33560 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33560(p__$1,ch__$1,meta33561){
return (new cljs.core.async.t_cljs$core$async33560(p__$1,ch__$1,meta33561));
});

}

return (new cljs.core.async.t_cljs$core$async33560(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args33563 = [];
var len__7651__auto___33607 = arguments.length;
var i__7652__auto___33608 = (0);
while(true){
if((i__7652__auto___33608 < len__7651__auto___33607)){
args33563.push((arguments[i__7652__auto___33608]));

var G__33609 = (i__7652__auto___33608 + (1));
i__7652__auto___33608 = G__33609;
continue;
} else {
}
break;
}

var G__33565 = args33563.length;
switch (G__33565) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33563.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19089__auto___33611 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___33611,out){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___33611,out){
return (function (state_33586){
var state_val_33587 = (state_33586[(1)]);
if((state_val_33587 === (7))){
var inst_33582 = (state_33586[(2)]);
var state_33586__$1 = state_33586;
var statearr_33588_33612 = state_33586__$1;
(statearr_33588_33612[(2)] = inst_33582);

(statearr_33588_33612[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33587 === (1))){
var state_33586__$1 = state_33586;
var statearr_33589_33613 = state_33586__$1;
(statearr_33589_33613[(2)] = null);

(statearr_33589_33613[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33587 === (4))){
var inst_33568 = (state_33586[(7)]);
var inst_33568__$1 = (state_33586[(2)]);
var inst_33569 = (inst_33568__$1 == null);
var state_33586__$1 = (function (){var statearr_33590 = state_33586;
(statearr_33590[(7)] = inst_33568__$1);

return statearr_33590;
})();
if(cljs.core.truth_(inst_33569)){
var statearr_33591_33614 = state_33586__$1;
(statearr_33591_33614[(1)] = (5));

} else {
var statearr_33592_33615 = state_33586__$1;
(statearr_33592_33615[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33587 === (6))){
var inst_33568 = (state_33586[(7)]);
var inst_33573 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33568) : p.call(null,inst_33568));
var state_33586__$1 = state_33586;
if(cljs.core.truth_(inst_33573)){
var statearr_33593_33616 = state_33586__$1;
(statearr_33593_33616[(1)] = (8));

} else {
var statearr_33594_33617 = state_33586__$1;
(statearr_33594_33617[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33587 === (3))){
var inst_33584 = (state_33586[(2)]);
var state_33586__$1 = state_33586;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33586__$1,inst_33584);
} else {
if((state_val_33587 === (2))){
var state_33586__$1 = state_33586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33586__$1,(4),ch);
} else {
if((state_val_33587 === (11))){
var inst_33576 = (state_33586[(2)]);
var state_33586__$1 = state_33586;
var statearr_33595_33618 = state_33586__$1;
(statearr_33595_33618[(2)] = inst_33576);

(statearr_33595_33618[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33587 === (9))){
var state_33586__$1 = state_33586;
var statearr_33596_33619 = state_33586__$1;
(statearr_33596_33619[(2)] = null);

(statearr_33596_33619[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33587 === (5))){
var inst_33571 = cljs.core.async.close_BANG_(out);
var state_33586__$1 = state_33586;
var statearr_33597_33620 = state_33586__$1;
(statearr_33597_33620[(2)] = inst_33571);

(statearr_33597_33620[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33587 === (10))){
var inst_33579 = (state_33586[(2)]);
var state_33586__$1 = (function (){var statearr_33598 = state_33586;
(statearr_33598[(8)] = inst_33579);

return statearr_33598;
})();
var statearr_33599_33621 = state_33586__$1;
(statearr_33599_33621[(2)] = null);

(statearr_33599_33621[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33587 === (8))){
var inst_33568 = (state_33586[(7)]);
var state_33586__$1 = state_33586;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33586__$1,(11),out,inst_33568);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___33611,out))
;
return ((function (switch__18977__auto__,c__19089__auto___33611,out){
return (function() {
var cljs$core$async$state_machine__18978__auto__ = null;
var cljs$core$async$state_machine__18978__auto____0 = (function (){
var statearr_33603 = [null,null,null,null,null,null,null,null,null];
(statearr_33603[(0)] = cljs$core$async$state_machine__18978__auto__);

(statearr_33603[(1)] = (1));

return statearr_33603;
});
var cljs$core$async$state_machine__18978__auto____1 = (function (state_33586){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_33586);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e33604){if((e33604 instanceof Object)){
var ex__18981__auto__ = e33604;
var statearr_33605_33622 = state_33586;
(statearr_33605_33622[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33586);

return cljs.core.cst$kw$recur;
} else {
throw e33604;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__33623 = state_33586;
state_33586 = G__33623;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$state_machine__18978__auto__ = function(state_33586){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18978__auto____1.call(this,state_33586);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18978__auto____0;
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18978__auto____1;
return cljs$core$async$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___33611,out))
})();
var state__19091__auto__ = (function (){var statearr_33606 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_33606[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___33611);

return statearr_33606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___33611,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args33624 = [];
var len__7651__auto___33627 = arguments.length;
var i__7652__auto___33628 = (0);
while(true){
if((i__7652__auto___33628 < len__7651__auto___33627)){
args33624.push((arguments[i__7652__auto___33628]));

var G__33629 = (i__7652__auto___33628 + (1));
i__7652__auto___33628 = G__33629;
continue;
} else {
}
break;
}

var G__33626 = args33624.length;
switch (G__33626) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33624.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__19089__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto__){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto__){
return (function (state_33796){
var state_val_33797 = (state_33796[(1)]);
if((state_val_33797 === (7))){
var inst_33792 = (state_33796[(2)]);
var state_33796__$1 = state_33796;
var statearr_33798_33839 = state_33796__$1;
(statearr_33798_33839[(2)] = inst_33792);

(statearr_33798_33839[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (20))){
var inst_33762 = (state_33796[(7)]);
var inst_33773 = (state_33796[(2)]);
var inst_33774 = cljs.core.next(inst_33762);
var inst_33748 = inst_33774;
var inst_33749 = null;
var inst_33750 = (0);
var inst_33751 = (0);
var state_33796__$1 = (function (){var statearr_33799 = state_33796;
(statearr_33799[(8)] = inst_33773);

(statearr_33799[(9)] = inst_33751);

(statearr_33799[(10)] = inst_33748);

(statearr_33799[(11)] = inst_33749);

(statearr_33799[(12)] = inst_33750);

return statearr_33799;
})();
var statearr_33800_33840 = state_33796__$1;
(statearr_33800_33840[(2)] = null);

(statearr_33800_33840[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (1))){
var state_33796__$1 = state_33796;
var statearr_33801_33841 = state_33796__$1;
(statearr_33801_33841[(2)] = null);

(statearr_33801_33841[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (4))){
var inst_33737 = (state_33796[(13)]);
var inst_33737__$1 = (state_33796[(2)]);
var inst_33738 = (inst_33737__$1 == null);
var state_33796__$1 = (function (){var statearr_33802 = state_33796;
(statearr_33802[(13)] = inst_33737__$1);

return statearr_33802;
})();
if(cljs.core.truth_(inst_33738)){
var statearr_33803_33842 = state_33796__$1;
(statearr_33803_33842[(1)] = (5));

} else {
var statearr_33804_33843 = state_33796__$1;
(statearr_33804_33843[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (15))){
var state_33796__$1 = state_33796;
var statearr_33808_33844 = state_33796__$1;
(statearr_33808_33844[(2)] = null);

(statearr_33808_33844[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (21))){
var state_33796__$1 = state_33796;
var statearr_33809_33845 = state_33796__$1;
(statearr_33809_33845[(2)] = null);

(statearr_33809_33845[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (13))){
var inst_33751 = (state_33796[(9)]);
var inst_33748 = (state_33796[(10)]);
var inst_33749 = (state_33796[(11)]);
var inst_33750 = (state_33796[(12)]);
var inst_33758 = (state_33796[(2)]);
var inst_33759 = (inst_33751 + (1));
var tmp33805 = inst_33748;
var tmp33806 = inst_33749;
var tmp33807 = inst_33750;
var inst_33748__$1 = tmp33805;
var inst_33749__$1 = tmp33806;
var inst_33750__$1 = tmp33807;
var inst_33751__$1 = inst_33759;
var state_33796__$1 = (function (){var statearr_33810 = state_33796;
(statearr_33810[(9)] = inst_33751__$1);

(statearr_33810[(10)] = inst_33748__$1);

(statearr_33810[(11)] = inst_33749__$1);

(statearr_33810[(12)] = inst_33750__$1);

(statearr_33810[(14)] = inst_33758);

return statearr_33810;
})();
var statearr_33811_33846 = state_33796__$1;
(statearr_33811_33846[(2)] = null);

(statearr_33811_33846[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (22))){
var state_33796__$1 = state_33796;
var statearr_33812_33847 = state_33796__$1;
(statearr_33812_33847[(2)] = null);

(statearr_33812_33847[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (6))){
var inst_33737 = (state_33796[(13)]);
var inst_33746 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_33737) : f.call(null,inst_33737));
var inst_33747 = cljs.core.seq(inst_33746);
var inst_33748 = inst_33747;
var inst_33749 = null;
var inst_33750 = (0);
var inst_33751 = (0);
var state_33796__$1 = (function (){var statearr_33813 = state_33796;
(statearr_33813[(9)] = inst_33751);

(statearr_33813[(10)] = inst_33748);

(statearr_33813[(11)] = inst_33749);

(statearr_33813[(12)] = inst_33750);

return statearr_33813;
})();
var statearr_33814_33848 = state_33796__$1;
(statearr_33814_33848[(2)] = null);

(statearr_33814_33848[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (17))){
var inst_33762 = (state_33796[(7)]);
var inst_33766 = cljs.core.chunk_first(inst_33762);
var inst_33767 = cljs.core.chunk_rest(inst_33762);
var inst_33768 = cljs.core.count(inst_33766);
var inst_33748 = inst_33767;
var inst_33749 = inst_33766;
var inst_33750 = inst_33768;
var inst_33751 = (0);
var state_33796__$1 = (function (){var statearr_33815 = state_33796;
(statearr_33815[(9)] = inst_33751);

(statearr_33815[(10)] = inst_33748);

(statearr_33815[(11)] = inst_33749);

(statearr_33815[(12)] = inst_33750);

return statearr_33815;
})();
var statearr_33816_33849 = state_33796__$1;
(statearr_33816_33849[(2)] = null);

(statearr_33816_33849[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (3))){
var inst_33794 = (state_33796[(2)]);
var state_33796__$1 = state_33796;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33796__$1,inst_33794);
} else {
if((state_val_33797 === (12))){
var inst_33782 = (state_33796[(2)]);
var state_33796__$1 = state_33796;
var statearr_33817_33850 = state_33796__$1;
(statearr_33817_33850[(2)] = inst_33782);

(statearr_33817_33850[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (2))){
var state_33796__$1 = state_33796;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33796__$1,(4),in$);
} else {
if((state_val_33797 === (23))){
var inst_33790 = (state_33796[(2)]);
var state_33796__$1 = state_33796;
var statearr_33818_33851 = state_33796__$1;
(statearr_33818_33851[(2)] = inst_33790);

(statearr_33818_33851[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (19))){
var inst_33777 = (state_33796[(2)]);
var state_33796__$1 = state_33796;
var statearr_33819_33852 = state_33796__$1;
(statearr_33819_33852[(2)] = inst_33777);

(statearr_33819_33852[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (11))){
var inst_33762 = (state_33796[(7)]);
var inst_33748 = (state_33796[(10)]);
var inst_33762__$1 = cljs.core.seq(inst_33748);
var state_33796__$1 = (function (){var statearr_33820 = state_33796;
(statearr_33820[(7)] = inst_33762__$1);

return statearr_33820;
})();
if(inst_33762__$1){
var statearr_33821_33853 = state_33796__$1;
(statearr_33821_33853[(1)] = (14));

} else {
var statearr_33822_33854 = state_33796__$1;
(statearr_33822_33854[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (9))){
var inst_33784 = (state_33796[(2)]);
var inst_33785 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_33796__$1 = (function (){var statearr_33823 = state_33796;
(statearr_33823[(15)] = inst_33784);

return statearr_33823;
})();
if(cljs.core.truth_(inst_33785)){
var statearr_33824_33855 = state_33796__$1;
(statearr_33824_33855[(1)] = (21));

} else {
var statearr_33825_33856 = state_33796__$1;
(statearr_33825_33856[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (5))){
var inst_33740 = cljs.core.async.close_BANG_(out);
var state_33796__$1 = state_33796;
var statearr_33826_33857 = state_33796__$1;
(statearr_33826_33857[(2)] = inst_33740);

(statearr_33826_33857[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (14))){
var inst_33762 = (state_33796[(7)]);
var inst_33764 = cljs.core.chunked_seq_QMARK_(inst_33762);
var state_33796__$1 = state_33796;
if(inst_33764){
var statearr_33827_33858 = state_33796__$1;
(statearr_33827_33858[(1)] = (17));

} else {
var statearr_33828_33859 = state_33796__$1;
(statearr_33828_33859[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (16))){
var inst_33780 = (state_33796[(2)]);
var state_33796__$1 = state_33796;
var statearr_33829_33860 = state_33796__$1;
(statearr_33829_33860[(2)] = inst_33780);

(statearr_33829_33860[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33797 === (10))){
var inst_33751 = (state_33796[(9)]);
var inst_33749 = (state_33796[(11)]);
var inst_33756 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33749,inst_33751);
var state_33796__$1 = state_33796;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33796__$1,(13),out,inst_33756);
} else {
if((state_val_33797 === (18))){
var inst_33762 = (state_33796[(7)]);
var inst_33771 = cljs.core.first(inst_33762);
var state_33796__$1 = state_33796;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33796__$1,(20),out,inst_33771);
} else {
if((state_val_33797 === (8))){
var inst_33751 = (state_33796[(9)]);
var inst_33750 = (state_33796[(12)]);
var inst_33753 = (inst_33751 < inst_33750);
var inst_33754 = inst_33753;
var state_33796__$1 = state_33796;
if(cljs.core.truth_(inst_33754)){
var statearr_33830_33861 = state_33796__$1;
(statearr_33830_33861[(1)] = (10));

} else {
var statearr_33831_33862 = state_33796__$1;
(statearr_33831_33862[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto__))
;
return ((function (switch__18977__auto__,c__19089__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__18978__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__18978__auto____0 = (function (){
var statearr_33835 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33835[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__18978__auto__);

(statearr_33835[(1)] = (1));

return statearr_33835;
});
var cljs$core$async$mapcat_STAR__$_state_machine__18978__auto____1 = (function (state_33796){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_33796);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e33836){if((e33836 instanceof Object)){
var ex__18981__auto__ = e33836;
var statearr_33837_33863 = state_33796;
(statearr_33837_33863[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33796);

return cljs.core.cst$kw$recur;
} else {
throw e33836;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__33864 = state_33796;
state_33796 = G__33864;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__18978__auto__ = function(state_33796){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__18978__auto____1.call(this,state_33796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__18978__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__18978__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto__))
})();
var state__19091__auto__ = (function (){var statearr_33838 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_33838[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto__);

return statearr_33838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto__))
);

return c__19089__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args33865 = [];
var len__7651__auto___33868 = arguments.length;
var i__7652__auto___33869 = (0);
while(true){
if((i__7652__auto___33869 < len__7651__auto___33868)){
args33865.push((arguments[i__7652__auto___33869]));

var G__33870 = (i__7652__auto___33869 + (1));
i__7652__auto___33869 = G__33870;
continue;
} else {
}
break;
}

var G__33867 = args33865.length;
switch (G__33867) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33865.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args33872 = [];
var len__7651__auto___33875 = arguments.length;
var i__7652__auto___33876 = (0);
while(true){
if((i__7652__auto___33876 < len__7651__auto___33875)){
args33872.push((arguments[i__7652__auto___33876]));

var G__33877 = (i__7652__auto___33876 + (1));
i__7652__auto___33876 = G__33877;
continue;
} else {
}
break;
}

var G__33874 = args33872.length;
switch (G__33874) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33872.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args33879 = [];
var len__7651__auto___33930 = arguments.length;
var i__7652__auto___33931 = (0);
while(true){
if((i__7652__auto___33931 < len__7651__auto___33930)){
args33879.push((arguments[i__7652__auto___33931]));

var G__33932 = (i__7652__auto___33931 + (1));
i__7652__auto___33931 = G__33932;
continue;
} else {
}
break;
}

var G__33881 = args33879.length;
switch (G__33881) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33879.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19089__auto___33934 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___33934,out){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___33934,out){
return (function (state_33905){
var state_val_33906 = (state_33905[(1)]);
if((state_val_33906 === (7))){
var inst_33900 = (state_33905[(2)]);
var state_33905__$1 = state_33905;
var statearr_33907_33935 = state_33905__$1;
(statearr_33907_33935[(2)] = inst_33900);

(statearr_33907_33935[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33906 === (1))){
var inst_33882 = null;
var state_33905__$1 = (function (){var statearr_33908 = state_33905;
(statearr_33908[(7)] = inst_33882);

return statearr_33908;
})();
var statearr_33909_33936 = state_33905__$1;
(statearr_33909_33936[(2)] = null);

(statearr_33909_33936[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33906 === (4))){
var inst_33885 = (state_33905[(8)]);
var inst_33885__$1 = (state_33905[(2)]);
var inst_33886 = (inst_33885__$1 == null);
var inst_33887 = cljs.core.not(inst_33886);
var state_33905__$1 = (function (){var statearr_33910 = state_33905;
(statearr_33910[(8)] = inst_33885__$1);

return statearr_33910;
})();
if(inst_33887){
var statearr_33911_33937 = state_33905__$1;
(statearr_33911_33937[(1)] = (5));

} else {
var statearr_33912_33938 = state_33905__$1;
(statearr_33912_33938[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33906 === (6))){
var state_33905__$1 = state_33905;
var statearr_33913_33939 = state_33905__$1;
(statearr_33913_33939[(2)] = null);

(statearr_33913_33939[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33906 === (3))){
var inst_33902 = (state_33905[(2)]);
var inst_33903 = cljs.core.async.close_BANG_(out);
var state_33905__$1 = (function (){var statearr_33914 = state_33905;
(statearr_33914[(9)] = inst_33902);

return statearr_33914;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33905__$1,inst_33903);
} else {
if((state_val_33906 === (2))){
var state_33905__$1 = state_33905;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33905__$1,(4),ch);
} else {
if((state_val_33906 === (11))){
var inst_33885 = (state_33905[(8)]);
var inst_33894 = (state_33905[(2)]);
var inst_33882 = inst_33885;
var state_33905__$1 = (function (){var statearr_33915 = state_33905;
(statearr_33915[(7)] = inst_33882);

(statearr_33915[(10)] = inst_33894);

return statearr_33915;
})();
var statearr_33916_33940 = state_33905__$1;
(statearr_33916_33940[(2)] = null);

(statearr_33916_33940[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33906 === (9))){
var inst_33885 = (state_33905[(8)]);
var state_33905__$1 = state_33905;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33905__$1,(11),out,inst_33885);
} else {
if((state_val_33906 === (5))){
var inst_33882 = (state_33905[(7)]);
var inst_33885 = (state_33905[(8)]);
var inst_33889 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33885,inst_33882);
var state_33905__$1 = state_33905;
if(inst_33889){
var statearr_33918_33941 = state_33905__$1;
(statearr_33918_33941[(1)] = (8));

} else {
var statearr_33919_33942 = state_33905__$1;
(statearr_33919_33942[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33906 === (10))){
var inst_33897 = (state_33905[(2)]);
var state_33905__$1 = state_33905;
var statearr_33920_33943 = state_33905__$1;
(statearr_33920_33943[(2)] = inst_33897);

(statearr_33920_33943[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33906 === (8))){
var inst_33882 = (state_33905[(7)]);
var tmp33917 = inst_33882;
var inst_33882__$1 = tmp33917;
var state_33905__$1 = (function (){var statearr_33921 = state_33905;
(statearr_33921[(7)] = inst_33882__$1);

return statearr_33921;
})();
var statearr_33922_33944 = state_33905__$1;
(statearr_33922_33944[(2)] = null);

(statearr_33922_33944[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___33934,out))
;
return ((function (switch__18977__auto__,c__19089__auto___33934,out){
return (function() {
var cljs$core$async$state_machine__18978__auto__ = null;
var cljs$core$async$state_machine__18978__auto____0 = (function (){
var statearr_33926 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33926[(0)] = cljs$core$async$state_machine__18978__auto__);

(statearr_33926[(1)] = (1));

return statearr_33926;
});
var cljs$core$async$state_machine__18978__auto____1 = (function (state_33905){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_33905);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e33927){if((e33927 instanceof Object)){
var ex__18981__auto__ = e33927;
var statearr_33928_33945 = state_33905;
(statearr_33928_33945[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33905);

return cljs.core.cst$kw$recur;
} else {
throw e33927;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__33946 = state_33905;
state_33905 = G__33946;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$state_machine__18978__auto__ = function(state_33905){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18978__auto____1.call(this,state_33905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18978__auto____0;
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18978__auto____1;
return cljs$core$async$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___33934,out))
})();
var state__19091__auto__ = (function (){var statearr_33929 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_33929[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___33934);

return statearr_33929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___33934,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args33947 = [];
var len__7651__auto___34017 = arguments.length;
var i__7652__auto___34018 = (0);
while(true){
if((i__7652__auto___34018 < len__7651__auto___34017)){
args33947.push((arguments[i__7652__auto___34018]));

var G__34019 = (i__7652__auto___34018 + (1));
i__7652__auto___34018 = G__34019;
continue;
} else {
}
break;
}

var G__33949 = args33947.length;
switch (G__33949) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33947.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19089__auto___34021 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___34021,out){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___34021,out){
return (function (state_33987){
var state_val_33988 = (state_33987[(1)]);
if((state_val_33988 === (7))){
var inst_33983 = (state_33987[(2)]);
var state_33987__$1 = state_33987;
var statearr_33989_34022 = state_33987__$1;
(statearr_33989_34022[(2)] = inst_33983);

(statearr_33989_34022[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33988 === (1))){
var inst_33950 = (new Array(n));
var inst_33951 = inst_33950;
var inst_33952 = (0);
var state_33987__$1 = (function (){var statearr_33990 = state_33987;
(statearr_33990[(7)] = inst_33952);

(statearr_33990[(8)] = inst_33951);

return statearr_33990;
})();
var statearr_33991_34023 = state_33987__$1;
(statearr_33991_34023[(2)] = null);

(statearr_33991_34023[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33988 === (4))){
var inst_33955 = (state_33987[(9)]);
var inst_33955__$1 = (state_33987[(2)]);
var inst_33956 = (inst_33955__$1 == null);
var inst_33957 = cljs.core.not(inst_33956);
var state_33987__$1 = (function (){var statearr_33992 = state_33987;
(statearr_33992[(9)] = inst_33955__$1);

return statearr_33992;
})();
if(inst_33957){
var statearr_33993_34024 = state_33987__$1;
(statearr_33993_34024[(1)] = (5));

} else {
var statearr_33994_34025 = state_33987__$1;
(statearr_33994_34025[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33988 === (15))){
var inst_33977 = (state_33987[(2)]);
var state_33987__$1 = state_33987;
var statearr_33995_34026 = state_33987__$1;
(statearr_33995_34026[(2)] = inst_33977);

(statearr_33995_34026[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33988 === (13))){
var state_33987__$1 = state_33987;
var statearr_33996_34027 = state_33987__$1;
(statearr_33996_34027[(2)] = null);

(statearr_33996_34027[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33988 === (6))){
var inst_33952 = (state_33987[(7)]);
var inst_33973 = (inst_33952 > (0));
var state_33987__$1 = state_33987;
if(cljs.core.truth_(inst_33973)){
var statearr_33997_34028 = state_33987__$1;
(statearr_33997_34028[(1)] = (12));

} else {
var statearr_33998_34029 = state_33987__$1;
(statearr_33998_34029[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33988 === (3))){
var inst_33985 = (state_33987[(2)]);
var state_33987__$1 = state_33987;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33987__$1,inst_33985);
} else {
if((state_val_33988 === (12))){
var inst_33951 = (state_33987[(8)]);
var inst_33975 = cljs.core.vec(inst_33951);
var state_33987__$1 = state_33987;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33987__$1,(15),out,inst_33975);
} else {
if((state_val_33988 === (2))){
var state_33987__$1 = state_33987;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33987__$1,(4),ch);
} else {
if((state_val_33988 === (11))){
var inst_33967 = (state_33987[(2)]);
var inst_33968 = (new Array(n));
var inst_33951 = inst_33968;
var inst_33952 = (0);
var state_33987__$1 = (function (){var statearr_33999 = state_33987;
(statearr_33999[(7)] = inst_33952);

(statearr_33999[(8)] = inst_33951);

(statearr_33999[(10)] = inst_33967);

return statearr_33999;
})();
var statearr_34000_34030 = state_33987__$1;
(statearr_34000_34030[(2)] = null);

(statearr_34000_34030[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33988 === (9))){
var inst_33951 = (state_33987[(8)]);
var inst_33965 = cljs.core.vec(inst_33951);
var state_33987__$1 = state_33987;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33987__$1,(11),out,inst_33965);
} else {
if((state_val_33988 === (5))){
var inst_33960 = (state_33987[(11)]);
var inst_33955 = (state_33987[(9)]);
var inst_33952 = (state_33987[(7)]);
var inst_33951 = (state_33987[(8)]);
var inst_33959 = (inst_33951[inst_33952] = inst_33955);
var inst_33960__$1 = (inst_33952 + (1));
var inst_33961 = (inst_33960__$1 < n);
var state_33987__$1 = (function (){var statearr_34001 = state_33987;
(statearr_34001[(11)] = inst_33960__$1);

(statearr_34001[(12)] = inst_33959);

return statearr_34001;
})();
if(cljs.core.truth_(inst_33961)){
var statearr_34002_34031 = state_33987__$1;
(statearr_34002_34031[(1)] = (8));

} else {
var statearr_34003_34032 = state_33987__$1;
(statearr_34003_34032[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33988 === (14))){
var inst_33980 = (state_33987[(2)]);
var inst_33981 = cljs.core.async.close_BANG_(out);
var state_33987__$1 = (function (){var statearr_34005 = state_33987;
(statearr_34005[(13)] = inst_33980);

return statearr_34005;
})();
var statearr_34006_34033 = state_33987__$1;
(statearr_34006_34033[(2)] = inst_33981);

(statearr_34006_34033[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33988 === (10))){
var inst_33971 = (state_33987[(2)]);
var state_33987__$1 = state_33987;
var statearr_34007_34034 = state_33987__$1;
(statearr_34007_34034[(2)] = inst_33971);

(statearr_34007_34034[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33988 === (8))){
var inst_33960 = (state_33987[(11)]);
var inst_33951 = (state_33987[(8)]);
var tmp34004 = inst_33951;
var inst_33951__$1 = tmp34004;
var inst_33952 = inst_33960;
var state_33987__$1 = (function (){var statearr_34008 = state_33987;
(statearr_34008[(7)] = inst_33952);

(statearr_34008[(8)] = inst_33951__$1);

return statearr_34008;
})();
var statearr_34009_34035 = state_33987__$1;
(statearr_34009_34035[(2)] = null);

(statearr_34009_34035[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___34021,out))
;
return ((function (switch__18977__auto__,c__19089__auto___34021,out){
return (function() {
var cljs$core$async$state_machine__18978__auto__ = null;
var cljs$core$async$state_machine__18978__auto____0 = (function (){
var statearr_34013 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34013[(0)] = cljs$core$async$state_machine__18978__auto__);

(statearr_34013[(1)] = (1));

return statearr_34013;
});
var cljs$core$async$state_machine__18978__auto____1 = (function (state_33987){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_33987);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e34014){if((e34014 instanceof Object)){
var ex__18981__auto__ = e34014;
var statearr_34015_34036 = state_33987;
(statearr_34015_34036[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33987);

return cljs.core.cst$kw$recur;
} else {
throw e34014;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__34037 = state_33987;
state_33987 = G__34037;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$state_machine__18978__auto__ = function(state_33987){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18978__auto____1.call(this,state_33987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18978__auto____0;
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18978__auto____1;
return cljs$core$async$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___34021,out))
})();
var state__19091__auto__ = (function (){var statearr_34016 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_34016[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___34021);

return statearr_34016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___34021,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args34038 = [];
var len__7651__auto___34112 = arguments.length;
var i__7652__auto___34113 = (0);
while(true){
if((i__7652__auto___34113 < len__7651__auto___34112)){
args34038.push((arguments[i__7652__auto___34113]));

var G__34114 = (i__7652__auto___34113 + (1));
i__7652__auto___34113 = G__34114;
continue;
} else {
}
break;
}

var G__34040 = args34038.length;
switch (G__34040) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34038.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19089__auto___34116 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___34116,out){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___34116,out){
return (function (state_34082){
var state_val_34083 = (state_34082[(1)]);
if((state_val_34083 === (7))){
var inst_34078 = (state_34082[(2)]);
var state_34082__$1 = state_34082;
var statearr_34084_34117 = state_34082__$1;
(statearr_34084_34117[(2)] = inst_34078);

(statearr_34084_34117[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34083 === (1))){
var inst_34041 = [];
var inst_34042 = inst_34041;
var inst_34043 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_34082__$1 = (function (){var statearr_34085 = state_34082;
(statearr_34085[(7)] = inst_34043);

(statearr_34085[(8)] = inst_34042);

return statearr_34085;
})();
var statearr_34086_34118 = state_34082__$1;
(statearr_34086_34118[(2)] = null);

(statearr_34086_34118[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34083 === (4))){
var inst_34046 = (state_34082[(9)]);
var inst_34046__$1 = (state_34082[(2)]);
var inst_34047 = (inst_34046__$1 == null);
var inst_34048 = cljs.core.not(inst_34047);
var state_34082__$1 = (function (){var statearr_34087 = state_34082;
(statearr_34087[(9)] = inst_34046__$1);

return statearr_34087;
})();
if(inst_34048){
var statearr_34088_34119 = state_34082__$1;
(statearr_34088_34119[(1)] = (5));

} else {
var statearr_34089_34120 = state_34082__$1;
(statearr_34089_34120[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34083 === (15))){
var inst_34072 = (state_34082[(2)]);
var state_34082__$1 = state_34082;
var statearr_34090_34121 = state_34082__$1;
(statearr_34090_34121[(2)] = inst_34072);

(statearr_34090_34121[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34083 === (13))){
var state_34082__$1 = state_34082;
var statearr_34091_34122 = state_34082__$1;
(statearr_34091_34122[(2)] = null);

(statearr_34091_34122[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34083 === (6))){
var inst_34042 = (state_34082[(8)]);
var inst_34067 = inst_34042.length;
var inst_34068 = (inst_34067 > (0));
var state_34082__$1 = state_34082;
if(cljs.core.truth_(inst_34068)){
var statearr_34092_34123 = state_34082__$1;
(statearr_34092_34123[(1)] = (12));

} else {
var statearr_34093_34124 = state_34082__$1;
(statearr_34093_34124[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34083 === (3))){
var inst_34080 = (state_34082[(2)]);
var state_34082__$1 = state_34082;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34082__$1,inst_34080);
} else {
if((state_val_34083 === (12))){
var inst_34042 = (state_34082[(8)]);
var inst_34070 = cljs.core.vec(inst_34042);
var state_34082__$1 = state_34082;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34082__$1,(15),out,inst_34070);
} else {
if((state_val_34083 === (2))){
var state_34082__$1 = state_34082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34082__$1,(4),ch);
} else {
if((state_val_34083 === (11))){
var inst_34046 = (state_34082[(9)]);
var inst_34050 = (state_34082[(10)]);
var inst_34060 = (state_34082[(2)]);
var inst_34061 = [];
var inst_34062 = inst_34061.push(inst_34046);
var inst_34042 = inst_34061;
var inst_34043 = inst_34050;
var state_34082__$1 = (function (){var statearr_34094 = state_34082;
(statearr_34094[(7)] = inst_34043);

(statearr_34094[(11)] = inst_34060);

(statearr_34094[(12)] = inst_34062);

(statearr_34094[(8)] = inst_34042);

return statearr_34094;
})();
var statearr_34095_34125 = state_34082__$1;
(statearr_34095_34125[(2)] = null);

(statearr_34095_34125[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34083 === (9))){
var inst_34042 = (state_34082[(8)]);
var inst_34058 = cljs.core.vec(inst_34042);
var state_34082__$1 = state_34082;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34082__$1,(11),out,inst_34058);
} else {
if((state_val_34083 === (5))){
var inst_34043 = (state_34082[(7)]);
var inst_34046 = (state_34082[(9)]);
var inst_34050 = (state_34082[(10)]);
var inst_34050__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34046) : f.call(null,inst_34046));
var inst_34051 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34050__$1,inst_34043);
var inst_34052 = cljs.core.keyword_identical_QMARK_(inst_34043,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_34053 = (inst_34051) || (inst_34052);
var state_34082__$1 = (function (){var statearr_34096 = state_34082;
(statearr_34096[(10)] = inst_34050__$1);

return statearr_34096;
})();
if(cljs.core.truth_(inst_34053)){
var statearr_34097_34126 = state_34082__$1;
(statearr_34097_34126[(1)] = (8));

} else {
var statearr_34098_34127 = state_34082__$1;
(statearr_34098_34127[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34083 === (14))){
var inst_34075 = (state_34082[(2)]);
var inst_34076 = cljs.core.async.close_BANG_(out);
var state_34082__$1 = (function (){var statearr_34100 = state_34082;
(statearr_34100[(13)] = inst_34075);

return statearr_34100;
})();
var statearr_34101_34128 = state_34082__$1;
(statearr_34101_34128[(2)] = inst_34076);

(statearr_34101_34128[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34083 === (10))){
var inst_34065 = (state_34082[(2)]);
var state_34082__$1 = state_34082;
var statearr_34102_34129 = state_34082__$1;
(statearr_34102_34129[(2)] = inst_34065);

(statearr_34102_34129[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34083 === (8))){
var inst_34042 = (state_34082[(8)]);
var inst_34046 = (state_34082[(9)]);
var inst_34050 = (state_34082[(10)]);
var inst_34055 = inst_34042.push(inst_34046);
var tmp34099 = inst_34042;
var inst_34042__$1 = tmp34099;
var inst_34043 = inst_34050;
var state_34082__$1 = (function (){var statearr_34103 = state_34082;
(statearr_34103[(7)] = inst_34043);

(statearr_34103[(14)] = inst_34055);

(statearr_34103[(8)] = inst_34042__$1);

return statearr_34103;
})();
var statearr_34104_34130 = state_34082__$1;
(statearr_34104_34130[(2)] = null);

(statearr_34104_34130[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19089__auto___34116,out))
;
return ((function (switch__18977__auto__,c__19089__auto___34116,out){
return (function() {
var cljs$core$async$state_machine__18978__auto__ = null;
var cljs$core$async$state_machine__18978__auto____0 = (function (){
var statearr_34108 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34108[(0)] = cljs$core$async$state_machine__18978__auto__);

(statearr_34108[(1)] = (1));

return statearr_34108;
});
var cljs$core$async$state_machine__18978__auto____1 = (function (state_34082){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_34082);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e34109){if((e34109 instanceof Object)){
var ex__18981__auto__ = e34109;
var statearr_34110_34131 = state_34082;
(statearr_34110_34131[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34082);

return cljs.core.cst$kw$recur;
} else {
throw e34109;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__34132 = state_34082;
state_34082 = G__34132;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs$core$async$state_machine__18978__auto__ = function(state_34082){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18978__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18978__auto____1.call(this,state_34082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18978__auto____0;
cljs$core$async$state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18978__auto____1;
return cljs$core$async$state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___34116,out))
})();
var state__19091__auto__ = (function (){var statearr_34111 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_34111[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___34116);

return statearr_34111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___34116,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

