// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.initial_polling_interval = (5000);
/**
 * Handles API server's response and acts according to given callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__26907,p__26908){
var map__26917 = p__26907;
var map__26917__$1 = ((((!((map__26917 == null)))?((((map__26917.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26917.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26917):map__26917);
var response = map__26917__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26917__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26917__$1,cljs.core.cst$kw$body);
var map__26918 = p__26908;
var map__26918__$1 = ((((!((map__26918 == null)))?((((map__26918.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26918.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26918):map__26918);
var callbacks = map__26918__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26918__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26918__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26918__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26918__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__26921 = body;
var map__26921__$1 = ((((!((map__26921 == null)))?((((map__26921.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26921.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26921):map__26921);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26921__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26921__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26921__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = ((function (map__26921,map__26921__$1,export_url,job_status,job_id,map__26917,map__26917__$1,response,status,body,map__26918,map__26918__$1,callbacks,on_error,on_export_url,on_job_id,on_stop){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});})(map__26921,map__26921__$1,export_url,job_status,job_id,map__26917,map__26917__$1,response,status,body,map__26918,map__26918__$1,callbacks,on_error,on_export_url,on_job_id,on_stop))
;
var error_detail = (function (){var or__6543__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = cljs.core.cst$kw$details.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
if(cljs.core.truth_(is_failed_status_QMARK_())){
return job_status;
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}

} else {
}

if(cljs.core.truth_((function (){var or__6543__auto__ = (status >= (400));
if(or__6543__auto__){
return or__6543__auto__;
} else {
return is_failed_status_QMARK_();
}
})())){
if(cljs.core.fn_QMARK_(on_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(403))){
var G__26923_26925 = error_detail;
var G__26924_26926 = cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(body);
(on_error.cljs$core$IFn$_invoke$arity$2 ? on_error.cljs$core$IFn$_invoke$arity$2(G__26923_26925,G__26924_26926) : on_error.call(null,G__26923_26925,G__26924_26926));
} else {
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
}
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 * When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___26985 = arguments.length;
var i__7652__auto___26986 = (0);
while(true){
if((i__7652__auto___26986 < len__7651__auto___26985)){
args__7658__auto__.push((arguments[i__7652__auto___26986]));

var G__26987 = (i__7652__auto___26986 + (1));
i__7652__auto___26986 = G__26987;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__26930){
var map__26931 = p__26930;
var map__26931__$1 = ((((!((map__26931 == null)))?((((map__26931.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26931.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26931):map__26931);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26931__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26931__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26931__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var c__15677__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15677__auto__,map__26931,map__26931__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function (){
var f__15678__auto__ = (function (){var switch__15612__auto__ = ((function (c__15677__auto__,map__26931,map__26931__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function (state_26962){
var state_val_26963 = (state_26962[(1)]);
if((state_val_26963 === (7))){
var inst_26940 = (state_26962[(7)]);
var inst_26933 = (state_26962[(8)]);
var inst_26935 = (state_26962[(9)]);
var inst_26943 = (state_26962[(2)]);
var inst_26944 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_26945 = (function (){var polling_interval = inst_26933;
var job_suffix = inst_26935;
var job_url = inst_26940;
var response = inst_26943;
return ((function (polling_interval,job_suffix,job_url,response,inst_26940,inst_26933,inst_26935,inst_26943,inst_26944,state_val_26963,c__15677__auto__,map__26931,map__26931__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function (){
return cljs.core.constantly(cljs.core.cst$kw$stop);
});
;})(polling_interval,job_suffix,job_url,response,inst_26940,inst_26933,inst_26935,inst_26943,inst_26944,state_val_26963,c__15677__auto__,map__26931,map__26931__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
})();
var inst_26946 = [inst_26945,on_error,on_export_url];
var inst_26947 = cljs.core.PersistentHashMap.fromArrays(inst_26944,inst_26946);
var inst_26948 = milia.api.async_export.handle_response(inst_26943,inst_26947);
var inst_26949 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_26948,cljs.core.cst$kw$stop);
var state_26962__$1 = state_26962;
if(inst_26949){
var statearr_26964_26988 = state_26962__$1;
(statearr_26964_26988[(1)] = (8));

} else {
var statearr_26965_26989 = state_26962__$1;
(statearr_26965_26989[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26963 === (1))){
var inst_26933 = milia.api.async_export.initial_polling_interval;
var state_26962__$1 = (function (){var statearr_26966 = state_26962;
(statearr_26966[(8)] = inst_26933);

return statearr_26966;
})();
var statearr_26967_26990 = state_26962__$1;
(statearr_26967_26990[(2)] = null);

(statearr_26967_26990[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26963 === (4))){
var state_26962__$1 = state_26962;
var statearr_26968_26991 = state_26962__$1;
(statearr_26968_26991[(2)] = "dataviews");

(statearr_26968_26991[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26963 === (6))){
var inst_26940 = (state_26962[(7)]);
var inst_26935 = (state_26962[(9)]);
var inst_26939 = (state_26962[(2)]);
var inst_26940__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_26939,dataset_id,inst_26935], 0));
var inst_26941 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_26940__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_26962__$1 = (function (){var statearr_26969 = state_26962;
(statearr_26969[(7)] = inst_26940__$1);

return statearr_26969;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26962__$1,(7),inst_26941);
} else {
if((state_val_26963 === (3))){
var inst_26960 = (state_26962[(2)]);
var state_26962__$1 = state_26962;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26962__$1,inst_26960);
} else {
if((state_val_26963 === (2))){
var inst_26935 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var state_26962__$1 = (function (){var statearr_26970 = state_26962;
(statearr_26970[(9)] = inst_26935);

return statearr_26970;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_26971_26992 = state_26962__$1;
(statearr_26971_26992[(1)] = (4));

} else {
var statearr_26972_26993 = state_26962__$1;
(statearr_26972_26993[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26963 === (11))){
var inst_26933 = (state_26962[(8)]);
var inst_26953 = (state_26962[(2)]);
var inst_26954 = (inst_26933 * (2));
var inst_26933__$1 = inst_26954;
var state_26962__$1 = (function (){var statearr_26973 = state_26962;
(statearr_26973[(8)] = inst_26933__$1);

(statearr_26973[(10)] = inst_26953);

return statearr_26973;
})();
var statearr_26974_26994 = state_26962__$1;
(statearr_26974_26994[(2)] = null);

(statearr_26974_26994[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26963 === (9))){
var state_26962__$1 = state_26962;
var statearr_26975_26995 = state_26962__$1;
(statearr_26975_26995[(2)] = null);

(statearr_26975_26995[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26963 === (5))){
var state_26962__$1 = state_26962;
var statearr_26976_26996 = state_26962__$1;
(statearr_26976_26996[(2)] = "forms");

(statearr_26976_26996[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26963 === (10))){
var inst_26958 = (state_26962[(2)]);
var state_26962__$1 = state_26962;
var statearr_26977_26997 = state_26962__$1;
(statearr_26977_26997[(2)] = inst_26958);

(statearr_26977_26997[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26963 === (8))){
var inst_26933 = (state_26962[(8)]);
var inst_26951 = cljs.core.async.timeout(inst_26933);
var state_26962__$1 = state_26962;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26962__$1,(11),inst_26951);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__15677__auto__,map__26931,map__26931__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
;
return ((function (switch__15612__auto__,c__15677__auto__,map__26931,map__26931__$1,on_error,on_export_url,is_filtered_dataview_QMARK_){
return (function() {
var milia$api$async_export$state_machine__15613__auto__ = null;
var milia$api$async_export$state_machine__15613__auto____0 = (function (){
var statearr_26981 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26981[(0)] = milia$api$async_export$state_machine__15613__auto__);

(statearr_26981[(1)] = (1));

return statearr_26981;
});
var milia$api$async_export$state_machine__15613__auto____1 = (function (state_26962){
while(true){
var ret_value__15614__auto__ = (function (){try{while(true){
var result__15615__auto__ = switch__15612__auto__(state_26962);
if(cljs.core.keyword_identical_QMARK_(result__15615__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15615__auto__;
}
break;
}
}catch (e26982){if((e26982 instanceof Object)){
var ex__15616__auto__ = e26982;
var statearr_26983_26998 = state_26962;
(statearr_26983_26998[(5)] = ex__15616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_26962);

return cljs.core.cst$kw$recur;
} else {
throw e26982;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15614__auto__,cljs.core.cst$kw$recur)){
var G__26999 = state_26962;
state_26962 = G__26999;
continue;
} else {
return ret_value__15614__auto__;
}
break;
}
});
milia$api$async_export$state_machine__15613__auto__ = function(state_26962){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__15613__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__15613__auto____1.call(this,state_26962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__15613__auto____0;
milia$api$async_export$state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__15613__auto____1;
return milia$api$async_export$state_machine__15613__auto__;
})()
;})(switch__15612__auto__,c__15677__auto__,map__26931,map__26931__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
})();
var state__15679__auto__ = (function (){var statearr_26984 = (f__15678__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15678__auto__.cljs$core$IFn$_invoke$arity$0() : f__15678__auto__.call(null));
(statearr_26984[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15677__auto__);

return statearr_26984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15679__auto__);
});})(c__15677__auto__,map__26931,map__26931__$1,on_error,on_export_url,is_filtered_dataview_QMARK_))
);

return c__15677__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq26927){
var G__26928 = cljs.core.first(seq26927);
var seq26927__$1 = cljs.core.next(seq26927);
var G__26929 = cljs.core.first(seq26927__$1);
var seq26927__$2 = cljs.core.next(seq26927__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26928,G__26929,seq26927__$2);
});

/**
 * Repeatedly polls the export endpoint given a form_id while any of the export
 *   status is pending.
 */
milia.api.async_export.monitor_async_exports_per_form_BANG_ = (function milia$api$async_export$monitor_async_exports_per_form_BANG_(dataset_id,callback){
var c__15677__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15677__auto__){
return (function (){
var f__15678__auto__ = (function (){var switch__15612__auto__ = ((function (c__15677__auto__){
return (function (state_27125){
var state_val_27126 = (state_27125[(1)]);
if((state_val_27126 === (7))){
var inst_27103 = (state_27125[(2)]);
var state_27125__$1 = state_27125;
if(cljs.core.truth_(inst_27103)){
var statearr_27127_27157 = state_27125__$1;
(statearr_27127_27157[(1)] = (11));

} else {
var statearr_27128_27158 = state_27125__$1;
(statearr_27128_27158[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27126 === (1))){
var inst_27079 = milia.api.async_export.initial_polling_interval;
var state_27125__$1 = (function (){var statearr_27129 = state_27125;
(statearr_27129[(7)] = inst_27079);

return statearr_27129;
})();
var statearr_27130_27159 = state_27125__$1;
(statearr_27130_27159[(2)] = null);

(statearr_27130_27159[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27126 === (4))){
var inst_27087 = (state_27125[(8)]);
var inst_27087__$1 = (state_27125[(2)]);
var inst_27089 = (inst_27087__$1 == null);
var inst_27090 = cljs.core.not(inst_27089);
var state_27125__$1 = (function (){var statearr_27131 = state_27125;
(statearr_27131[(8)] = inst_27087__$1);

return statearr_27131;
})();
if(inst_27090){
var statearr_27132_27160 = state_27125__$1;
(statearr_27132_27160[(1)] = (5));

} else {
var statearr_27133_27161 = state_27125__$1;
(statearr_27133_27161[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27126 === (15))){
var inst_27079 = (state_27125[(7)]);
var inst_27118 = (inst_27079 * (2));
var inst_27079__$1 = inst_27118;
var state_27125__$1 = (function (){var statearr_27134 = state_27125;
(statearr_27134[(7)] = inst_27079__$1);

return statearr_27134;
})();
var statearr_27135_27162 = state_27125__$1;
(statearr_27135_27162[(2)] = null);

(statearr_27135_27162[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27126 === (13))){
var inst_27082 = (state_27125[(9)]);
var inst_27084 = (state_27125[(10)]);
var inst_27079 = (state_27125[(7)]);
var inst_27110 = (state_27125[(11)]);
var inst_27108 = (state_27125[(2)]);
var inst_27109 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27108,cljs.core.cst$kw$status);
var inst_27110__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27108,cljs.core.cst$kw$body);
var inst_27111 = (function (){var polling_interval = inst_27079;
var temp_token = inst_27082;
var export_url = inst_27084;
var map__27081 = inst_27108;
var status = inst_27109;
var body = inst_27110__$1;
return ((function (polling_interval,temp_token,export_url,map__27081,status,body,inst_27082,inst_27084,inst_27079,inst_27110,inst_27108,inst_27109,inst_27110__$1,state_val_27126,c__15677__auto__){
return (function (p1__27000_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$job_status.cljs$core$IFn$_invoke$arity$1(p1__27000_SHARP_),"PENDING");
});
;})(polling_interval,temp_token,export_url,map__27081,status,body,inst_27082,inst_27084,inst_27079,inst_27110,inst_27108,inst_27109,inst_27110__$1,state_val_27126,c__15677__auto__))
})();
var inst_27112 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_27111,inst_27110__$1);
var inst_27113 = cljs.core.vec(inst_27112);
var inst_27114 = cljs.core.empty_QMARK_(inst_27113);
var state_27125__$1 = (function (){var statearr_27136 = state_27125;
(statearr_27136[(11)] = inst_27110__$1);

return statearr_27136;
})();
if(inst_27114){
var statearr_27137_27163 = state_27125__$1;
(statearr_27137_27163[(1)] = (14));

} else {
var statearr_27138_27164 = state_27125__$1;
(statearr_27138_27164[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27126 === (6))){
var state_27125__$1 = state_27125;
var statearr_27139_27165 = state_27125__$1;
(statearr_27139_27165[(2)] = false);

(statearr_27139_27165[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27126 === (3))){
var inst_27123 = (state_27125[(2)]);
var state_27125__$1 = state_27125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27125__$1,inst_27123);
} else {
if((state_val_27126 === (12))){
var inst_27087 = (state_27125[(8)]);
var state_27125__$1 = state_27125;
var statearr_27140_27166 = state_27125__$1;
(statearr_27140_27166[(2)] = inst_27087);

(statearr_27140_27166[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27126 === (2))){
var inst_27082 = (state_27125[(9)]);
var inst_27084 = (state_27125[(10)]);
var inst_27082__$1 = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
var inst_27083 = [cljs.core.str("export?xform="),cljs.core.str(dataset_id),cljs.core.str("&temp_token="),cljs.core.str(inst_27082__$1)].join('');
var inst_27084__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_27083], 0));
var inst_27085 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_27084__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_27125__$1 = (function (){var statearr_27141 = state_27125;
(statearr_27141[(9)] = inst_27082__$1);

(statearr_27141[(10)] = inst_27084__$1);

return statearr_27141;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27125__$1,(4),inst_27085);
} else {
if((state_val_27126 === (11))){
var inst_27087 = (state_27125[(8)]);
var inst_27105 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_27087);
var state_27125__$1 = state_27125;
var statearr_27142_27167 = state_27125__$1;
(statearr_27142_27167[(2)] = inst_27105);

(statearr_27142_27167[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27126 === (9))){
var state_27125__$1 = state_27125;
var statearr_27143_27168 = state_27125__$1;
(statearr_27143_27168[(2)] = false);

(statearr_27143_27168[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27126 === (5))){
var inst_27087 = (state_27125[(8)]);
var inst_27092 = inst_27087.cljs$lang$protocol_mask$partition0$;
var inst_27093 = (inst_27092 & (64));
var inst_27094 = inst_27087.cljs$core$ISeq$;
var inst_27095 = (cljs.core.PROTOCOL_SENTINEL === inst_27094);
var inst_27096 = (inst_27093) || (inst_27095);
var state_27125__$1 = state_27125;
if(cljs.core.truth_(inst_27096)){
var statearr_27144_27169 = state_27125__$1;
(statearr_27144_27169[(1)] = (8));

} else {
var statearr_27145_27170 = state_27125__$1;
(statearr_27145_27170[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27126 === (14))){
var inst_27110 = (state_27125[(11)]);
var inst_27116 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_27110) : callback.call(null,inst_27110));
var state_27125__$1 = state_27125;
var statearr_27146_27171 = state_27125__$1;
(statearr_27146_27171[(2)] = inst_27116);

(statearr_27146_27171[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27126 === (16))){
var inst_27121 = (state_27125[(2)]);
var state_27125__$1 = state_27125;
var statearr_27147_27172 = state_27125__$1;
(statearr_27147_27172[(2)] = inst_27121);

(statearr_27147_27172[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27126 === (10))){
var inst_27100 = (state_27125[(2)]);
var state_27125__$1 = state_27125;
var statearr_27148_27173 = state_27125__$1;
(statearr_27148_27173[(2)] = inst_27100);

(statearr_27148_27173[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27126 === (8))){
var state_27125__$1 = state_27125;
var statearr_27149_27174 = state_27125__$1;
(statearr_27149_27174[(2)] = true);

(statearr_27149_27174[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15677__auto__))
;
return ((function (switch__15612__auto__,c__15677__auto__){
return (function() {
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__15613__auto__ = null;
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__15613__auto____0 = (function (){
var statearr_27153 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27153[(0)] = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__15613__auto__);

(statearr_27153[(1)] = (1));

return statearr_27153;
});
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__15613__auto____1 = (function (state_27125){
while(true){
var ret_value__15614__auto__ = (function (){try{while(true){
var result__15615__auto__ = switch__15612__auto__(state_27125);
if(cljs.core.keyword_identical_QMARK_(result__15615__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15615__auto__;
}
break;
}
}catch (e27154){if((e27154 instanceof Object)){
var ex__15616__auto__ = e27154;
var statearr_27155_27175 = state_27125;
(statearr_27155_27175[(5)] = ex__15616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27125);

return cljs.core.cst$kw$recur;
} else {
throw e27154;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15614__auto__,cljs.core.cst$kw$recur)){
var G__27176 = state_27125;
state_27125 = G__27176;
continue;
} else {
return ret_value__15614__auto__;
}
break;
}
});
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__15613__auto__ = function(state_27125){
switch(arguments.length){
case 0:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__15613__auto____0.call(this);
case 1:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__15613__auto____1.call(this,state_27125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__15613__auto____0;
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__15613__auto____1;
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__15613__auto__;
})()
;})(switch__15612__auto__,c__15677__auto__))
})();
var state__15679__auto__ = (function (){var statearr_27156 = (f__15678__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15678__auto__.cljs$core$IFn$_invoke$arity$0() : f__15678__auto__.call(null));
(statearr_27156[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15677__auto__);

return statearr_27156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15679__auto__);
});})(c__15677__auto__))
);

return c__15677__auto__;
});
milia.api.async_export.version_key = "_version";
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_hxl","include_images","remove_group_name",milia.api.async_export.version_key,"query","export_id","include_labels","include_labels_only","win_excel_utf8","redirect_uri"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_hxl_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id,cljs.core.cst$kw$include_DASH_labels_QMARK_,cljs.core.cst$kw$labels_DASH_only_QMARK_,cljs.core.cst$kw$windows_DASH_compatible_DASH_csv_QMARK_,cljs.core.cst$kw$redirect_DASH_uri], null);
milia.api.async_export.get_param = (function milia$api$async_export$get_param(key,value){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,milia.api.async_export.version_key)){
return goog.string.format("&query={\"%s\":\"%s\"}",key,value);
} else {
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
}
});
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_((function (){var or__6543__auto__ = value;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
return milia.api.async_export.get_param(key,value);
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___27184 = arguments.length;
var i__7652__auto___27185 = (0);
while(true){
if((i__7652__auto___27185 < len__7651__auto___27184)){
args__7658__auto__.push((arguments[i__7652__auto___27185]));

var G__27186 = (i__7652__auto___27185 + (1));
i__7652__auto___27185 = G__27186;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__27180){
var vec__27181 = p__27180;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27181,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq27177){
var G__27178 = cljs.core.first(seq27177);
var seq27177__$1 = cljs.core.next(seq27177);
var G__27179 = cljs.core.first(seq27177__$1);
var seq27177__$2 = cljs.core.next(seq27177__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__27178,G__27179,seq27177__$2);
});

/**
 * Triggers async export and watches it via polling.
 * Fires on-job-id callback on receving :job_uuid from server, then monitors
 * job via polling. On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___27223 = arguments.length;
var i__7652__auto___27224 = (0);
while(true){
if((i__7652__auto___27224 < len__7651__auto___27223)){
args__7658__auto__.push((arguments[i__7652__auto___27224]));

var G__27225 = (i__7652__auto___27224 + (1));
i__7652__auto___27224 = G__27225;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__27189){
var vec__27190 = p__27189;
var map__27193 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27190,(0),null);
var map__27193__$1 = ((((!((map__27193 == null)))?((((map__27193.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27193.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27193):map__27193);
var is_filtered_dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27193__$1,cljs.core.cst$kw$is_DASH_filtered_DASH_dataview_QMARK_);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27193__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27193__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27193__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27193__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27193__$1,cljs.core.cst$kw$on_DASH_error);
var c__15677__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15677__auto__,vec__27190,map__27193,map__27193__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (){
var f__15678__auto__ = (function (){var switch__15612__auto__ = ((function (c__15677__auto__,vec__27190,map__27193,map__27193__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function (state_27209){
var state_val_27210 = (state_27209[(1)]);
if((state_val_27210 === (1))){
var inst_27195 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var state_27209__$1 = (function (){var statearr_27211 = state_27209;
(statearr_27211[(7)] = inst_27195);

return statearr_27211;
})();
if(cljs.core.truth_(is_filtered_dataview_QMARK_)){
var statearr_27212_27226 = state_27209__$1;
(statearr_27212_27226[(1)] = (2));

} else {
var statearr_27213_27227 = state_27209__$1;
(statearr_27213_27227[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27210 === (2))){
var state_27209__$1 = state_27209;
var statearr_27214_27228 = state_27209__$1;
(statearr_27214_27228[(2)] = "dataviews");

(statearr_27214_27228[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27210 === (3))){
var state_27209__$1 = state_27209;
var statearr_27215_27229 = state_27209__$1;
(statearr_27215_27229[(2)] = "forms");

(statearr_27215_27229[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27210 === (4))){
var inst_27195 = (state_27209[(7)]);
var inst_27199 = (state_27209[(2)]);
var inst_27200 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_27199,dataset_id,inst_27195], 0));
var inst_27201 = milia.utils.retry.retry_parse_http(cljs.core.cst$kw$get,inst_27200);
var state_27209__$1 = state_27209;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27209__$1,(5),inst_27201);
} else {
if((state_val_27210 === (5))){
var inst_27203 = (state_27209[(2)]);
var inst_27204 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_27205 = [on_error,on_job_id,on_export_url];
var inst_27206 = cljs.core.PersistentHashMap.fromArrays(inst_27204,inst_27205);
var inst_27207 = milia.api.async_export.handle_response(inst_27203,inst_27206);
var state_27209__$1 = state_27209;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27209__$1,inst_27207);
} else {
return null;
}
}
}
}
}
});})(c__15677__auto__,vec__27190,map__27193,map__27193__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
;
return ((function (switch__15612__auto__,c__15677__auto__,vec__27190,map__27193,map__27193__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error){
return (function() {
var milia$api$async_export$state_machine__15613__auto__ = null;
var milia$api$async_export$state_machine__15613__auto____0 = (function (){
var statearr_27219 = [null,null,null,null,null,null,null,null];
(statearr_27219[(0)] = milia$api$async_export$state_machine__15613__auto__);

(statearr_27219[(1)] = (1));

return statearr_27219;
});
var milia$api$async_export$state_machine__15613__auto____1 = (function (state_27209){
while(true){
var ret_value__15614__auto__ = (function (){try{while(true){
var result__15615__auto__ = switch__15612__auto__(state_27209);
if(cljs.core.keyword_identical_QMARK_(result__15615__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15615__auto__;
}
break;
}
}catch (e27220){if((e27220 instanceof Object)){
var ex__15616__auto__ = e27220;
var statearr_27221_27230 = state_27209;
(statearr_27221_27230[(5)] = ex__15616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27209);

return cljs.core.cst$kw$recur;
} else {
throw e27220;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15614__auto__,cljs.core.cst$kw$recur)){
var G__27231 = state_27209;
state_27209 = G__27231;
continue;
} else {
return ret_value__15614__auto__;
}
break;
}
});
milia$api$async_export$state_machine__15613__auto__ = function(state_27209){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__15613__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__15613__auto____1.call(this,state_27209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__15613__auto____0;
milia$api$async_export$state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__15613__auto____1;
return milia$api$async_export$state_machine__15613__auto__;
})()
;})(switch__15612__auto__,c__15677__auto__,vec__27190,map__27193,map__27193__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
})();
var state__15679__auto__ = (function (){var statearr_27222 = (f__15678__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15678__auto__.cljs$core$IFn$_invoke$arity$0() : f__15678__auto__.call(null));
(statearr_27222[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15677__auto__);

return statearr_27222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15679__auto__);
});})(c__15677__auto__,vec__27190,map__27193,map__27193__$1,is_filtered_dataview_QMARK_,data_format,export_options,on_job_id,on_export_url,on_error))
);

return c__15677__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq27187){
var G__27188 = cljs.core.first(seq27187);
var seq27187__$1 = cljs.core.next(seq27187);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__27188,seq27187__$1);
});

/**
 * Returns a channel, which will have the async export url when ready.
 */
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,((function (ch){
return (function (p1__27232_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__27232_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
/**
 * Returns a channel, which will have the async _data_
 * downloaded using http-method when ready.
 */
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___27257 = arguments.length;
var i__7652__auto___27258 = (0);
while(true){
if((i__7652__auto___27258 < len__7651__auto___27257)){
args__7658__auto__.push((arguments[i__7652__auto___27258]));

var G__27259 = (i__7652__auto___27258 + (1));
i__7652__auto___27258 = G__27259;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){
var c__15677__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15677__auto__){
return (function (){
var f__15678__auto__ = (function (){var switch__15612__auto__ = ((function (c__15677__auto__){
return (function (state_27248){
var state_val_27249 = (state_27248[(1)]);
if((state_val_27249 === (1))){
var inst_27237 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_27248__$1 = state_27248;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27248__$1,(2),inst_27237);
} else {
if((state_val_27249 === (2))){
var inst_27239 = (state_27248[(2)]);
var inst_27240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27241 = [http_method,inst_27239];
var inst_27242 = (new cljs.core.PersistentVector(null,2,(5),inst_27240,inst_27241,null));
var inst_27243 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_27242,args);
var inst_27244 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_27243);
var state_27248__$1 = state_27248;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27248__$1,(3),inst_27244);
} else {
if((state_val_27249 === (3))){
var inst_27246 = (state_27248[(2)]);
var state_27248__$1 = state_27248;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27248__$1,inst_27246);
} else {
return null;
}
}
}
});})(c__15677__auto__))
;
return ((function (switch__15612__auto__,c__15677__auto__){
return (function() {
var milia$api$async_export$state_machine__15613__auto__ = null;
var milia$api$async_export$state_machine__15613__auto____0 = (function (){
var statearr_27253 = [null,null,null,null,null,null,null];
(statearr_27253[(0)] = milia$api$async_export$state_machine__15613__auto__);

(statearr_27253[(1)] = (1));

return statearr_27253;
});
var milia$api$async_export$state_machine__15613__auto____1 = (function (state_27248){
while(true){
var ret_value__15614__auto__ = (function (){try{while(true){
var result__15615__auto__ = switch__15612__auto__(state_27248);
if(cljs.core.keyword_identical_QMARK_(result__15615__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15615__auto__;
}
break;
}
}catch (e27254){if((e27254 instanceof Object)){
var ex__15616__auto__ = e27254;
var statearr_27255_27260 = state_27248;
(statearr_27255_27260[(5)] = ex__15616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_27248);

return cljs.core.cst$kw$recur;
} else {
throw e27254;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15614__auto__,cljs.core.cst$kw$recur)){
var G__27261 = state_27248;
state_27248 = G__27261;
continue;
} else {
return ret_value__15614__auto__;
}
break;
}
});
milia$api$async_export$state_machine__15613__auto__ = function(state_27248){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__15613__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__15613__auto____1.call(this,state_27248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__15613__auto____0;
milia$api$async_export$state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__15613__auto____1;
return milia$api$async_export$state_machine__15613__auto__;
})()
;})(switch__15612__auto__,c__15677__auto__))
})();
var state__15679__auto__ = (function (){var statearr_27256 = (f__15678__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15678__auto__.cljs$core$IFn$_invoke$arity$0() : f__15678__auto__.call(null));
(statearr_27256[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15677__auto__);

return statearr_27256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15679__auto__);
});})(c__15677__auto__))
);

return c__15677__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq27233){
var G__27234 = cljs.core.first(seq27233);
var seq27233__$1 = cljs.core.next(seq27233);
var G__27235 = cljs.core.first(seq27233__$1);
var seq27233__$2 = cljs.core.next(seq27233__$1);
var G__27236 = cljs.core.first(seq27233__$2);
var seq27233__$3 = cljs.core.next(seq27233__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__27234,G__27235,G__27236,seq27233__$3);
});

/**
 * Get exports based on a form id.
 */
milia.api.async_export.get_exports_per_form = (function milia$api$async_export$get_exports_per_form(dataset_id,temp_token){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("export?xform="),cljs.core.str(dataset_id),cljs.core.str("&temp_token="),cljs.core.str(temp_token)].join('')], 0)));
});
/**
 * Delete an export based on an export id
 */
milia.api.async_export.delete_export = (function milia$api$async_export$delete_export(export_id,temp_token){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export",[cljs.core.str(export_id),cljs.core.str("?temp_token="),cljs.core.str(temp_token)].join('')], 0)));
});
