// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.http');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('milia.api.io');
goog.require('cljs_hash.md5');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
/**
 * Send and parse an HTTP response as JSON.
 * Additional arguments modify beavior of parse-http:
 * In both: `raw-response?`, `filename`, `http-options`.
 * In CLJ: `suppress-4xx-exceptions?`, `as-map?`.
 * In CLJS: `accept-header` `callback`, `no-cache?`.
 * When a request fails for one of the following reasons, an exception is thrown
 * with a map containing a `:reason` key, and an optional `:detail` key
 *  1. No response: {:reason :no-http-response}
 *  2. 4xx response: {:reason :http-client-error
 *                    :detail {:status-code <status-code>
 *                             :response <parsed-json-from-server>}
 *  3. 5xx response: {:reason :http-server-error
 *                    :detail {:response <raw-response>
 *                             :status-code <status-code>}
 */
milia.api.http.parse_http = (function milia$api$http$parse_http(var_args){
var args__7658__auto__ = [];
var len__7651__auto___26511 = arguments.length;
var i__7652__auto___26512 = (0);
while(true){
if((i__7652__auto___26512 < len__7651__auto___26511)){
args__7658__auto__.push((arguments[i__7652__auto___26512]));

var G__26513 = (i__7652__auto___26512 + (1));
i__7652__auto___26512 = G__26513;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__26495){
var map__26496 = p__26495;
var map__26496__$1 = ((((!((map__26496 == null)))?((((map__26496.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26496.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26496):map__26496);
var http_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26496__$1,cljs.core.cst$kw$http_DASH_options);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26496__$1,cljs.core.cst$kw$accept_DASH_header);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26496__$1,cljs.core.cst$kw$callback);
var as_map_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26496__$1,cljs.core.cst$kw$as_DASH_map_QMARK_);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26496__$1,cljs.core.cst$kw$auth_DASH_token);
var suppress_4xx_exceptions_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26496__$1,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26496__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26496__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var filename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26496__$1,cljs.core.cst$kw$filename);
var raw_response_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26496__$1,cljs.core.cst$kw$raw_DASH_response_QMARK_);
if(cljs.core.truth_(filename)){
throw (new Error("File downloads auth not supported via JS"));
} else {
var request_fn = (cljs.core.truth_(raw_response_QMARK_)?milia.api.io.raw_request:cljs_http.client.request);
var headers = milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$kw$get_DASH_crsftoken_QMARK_,cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(method,cljs.core.cst$kw$get),cljs.core.cst$kw$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$auth_DASH_token,auth_token], 0));
var ch = milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(request_fn,cljs.core.array_seq([cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.io.build_http_options(http_options,method,no_cache_QMARK_),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$method,method,cljs.core.cst$kw$url,url], null)], 0))], 0));
if(cljs.core.truth_(callback)){
var c__15677__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15677__auto__,request_fn,headers,ch,map__26496,map__26496__$1,http_options,accept_header,callback,as_map_QMARK_,auth_token,suppress_4xx_exceptions_QMARK_,must_revalidate_QMARK_,no_cache_QMARK_,filename,raw_response_QMARK_){
return (function (){
var f__15678__auto__ = (function (){var switch__15612__auto__ = ((function (c__15677__auto__,request_fn,headers,ch,map__26496,map__26496__$1,http_options,accept_header,callback,as_map_QMARK_,auth_token,suppress_4xx_exceptions_QMARK_,must_revalidate_QMARK_,no_cache_QMARK_,filename,raw_response_QMARK_){
return (function (state_26502){
var state_val_26503 = (state_26502[(1)]);
if((state_val_26503 === (1))){
var state_26502__$1 = state_26502;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26502__$1,(2),ch);
} else {
if((state_val_26503 === (2))){
var inst_26499 = (state_26502[(2)]);
var inst_26500 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_26499) : callback.call(null,inst_26499));
var state_26502__$1 = state_26502;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26502__$1,inst_26500);
} else {
return null;
}
}
});})(c__15677__auto__,request_fn,headers,ch,map__26496,map__26496__$1,http_options,accept_header,callback,as_map_QMARK_,auth_token,suppress_4xx_exceptions_QMARK_,must_revalidate_QMARK_,no_cache_QMARK_,filename,raw_response_QMARK_))
;
return ((function (switch__15612__auto__,c__15677__auto__,request_fn,headers,ch,map__26496,map__26496__$1,http_options,accept_header,callback,as_map_QMARK_,auth_token,suppress_4xx_exceptions_QMARK_,must_revalidate_QMARK_,no_cache_QMARK_,filename,raw_response_QMARK_){
return (function() {
var milia$api$http$state_machine__15613__auto__ = null;
var milia$api$http$state_machine__15613__auto____0 = (function (){
var statearr_26507 = [null,null,null,null,null,null,null];
(statearr_26507[(0)] = milia$api$http$state_machine__15613__auto__);

(statearr_26507[(1)] = (1));

return statearr_26507;
});
var milia$api$http$state_machine__15613__auto____1 = (function (state_26502){
while(true){
var ret_value__15614__auto__ = (function (){try{while(true){
var result__15615__auto__ = switch__15612__auto__(state_26502);
if(cljs.core.keyword_identical_QMARK_(result__15615__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__15615__auto__;
}
break;
}
}catch (e26508){if((e26508 instanceof Object)){
var ex__15616__auto__ = e26508;
var statearr_26509_26514 = state_26502;
(statearr_26509_26514[(5)] = ex__15616__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_26502);

return cljs.core.cst$kw$recur;
} else {
throw e26508;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__15614__auto__,cljs.core.cst$kw$recur)){
var G__26515 = state_26502;
state_26502 = G__26515;
continue;
} else {
return ret_value__15614__auto__;
}
break;
}
});
milia$api$http$state_machine__15613__auto__ = function(state_26502){
switch(arguments.length){
case 0:
return milia$api$http$state_machine__15613__auto____0.call(this);
case 1:
return milia$api$http$state_machine__15613__auto____1.call(this,state_26502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$http$state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$http$state_machine__15613__auto____0;
milia$api$http$state_machine__15613__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$http$state_machine__15613__auto____1;
return milia$api$http$state_machine__15613__auto__;
})()
;})(switch__15612__auto__,c__15677__auto__,request_fn,headers,ch,map__26496,map__26496__$1,http_options,accept_header,callback,as_map_QMARK_,auth_token,suppress_4xx_exceptions_QMARK_,must_revalidate_QMARK_,no_cache_QMARK_,filename,raw_response_QMARK_))
})();
var state__15679__auto__ = (function (){var statearr_26510 = (f__15678__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15678__auto__.cljs$core$IFn$_invoke$arity$0() : f__15678__auto__.call(null));
(statearr_26510[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15677__auto__);

return statearr_26510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15679__auto__);
});})(c__15677__auto__,request_fn,headers,ch,map__26496,map__26496__$1,http_options,accept_header,callback,as_map_QMARK_,auth_token,suppress_4xx_exceptions_QMARK_,must_revalidate_QMARK_,no_cache_QMARK_,filename,raw_response_QMARK_))
);

return c__15677__auto__;
} else {
return ch;
}
}
});

milia.api.http.parse_http.cljs$lang$maxFixedArity = (2);

milia.api.http.parse_http.cljs$lang$applyTo = (function (seq26492){
var G__26493 = cljs.core.first(seq26492);
var seq26492__$1 = cljs.core.next(seq26492);
var G__26494 = cljs.core.first(seq26492__$1);
var seq26492__$2 = cljs.core.next(seq26492__$1);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(G__26493,G__26494,seq26492__$2);
});

