// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__34135 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__34135) : cljs.core.atom.call(null,G__34135));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4657__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cljs_http.core.pending_requests) : cljs.core.deref.call(null,cljs_http.core.pending_requests)).call(null,channel);
if(cljs.core.truth_(temp__4657__auto__)){
var req = temp__4657__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__34140){
var vec__34141 = p__34140;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34141,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34141,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__34145 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__34145)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__34145)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__34145)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__34145)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__34145)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__34145)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__34146){
var map__34150 = p__34146;
var map__34150__$1 = ((((!((map__34150 == null)))?((((map__34150.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34150.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34150):map__34150);
var request = map__34150__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34150__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34150__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34150__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__6543__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__34152 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__34152,default_headers);

cljs_http.core.apply_response_type_BANG_(G__34152,response_type);

G__34152.setTimeoutInterval(timeout);

G__34152.setWithCredentials(send_credentials);

return G__34152;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__34153){
var map__34182 = p__34153;
var map__34182__$1 = ((((!((map__34182 == null)))?((((map__34182.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34182.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34182):map__34182);
var request = map__34182__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34182__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34182__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34182__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34182__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34182__$1,cljs.core.cst$kw$cancel);
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34182__$1,cljs.core.cst$kw$progress);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__6543__auto__ = request_method;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr,map__34182,map__34182__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__34184 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__34184) : cljs_http.core.error_kw.call(null,G__34184));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr,map__34182,map__34182__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

if(cljs.core.truth_(progress)){
var listener_34210 = ((function (channel,request_url,method,headers__$1,xhr,map__34182,map__34182__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$direction,direction,cljs.core.cst$kw$loaded,evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,evt.total], null):null)], 0)));
});})(channel,request_url,method,headers__$1,xhr,map__34182,map__34182__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
var G__34185_34211 = xhr;
G__34185_34211.setProgressEventsEnabled(true);

G__34185_34211.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_34210,cljs.core.cst$kw$upload));

G__34185_34211.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_34210,cljs.core.cst$kw$download));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__19089__auto___34212 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___34212,channel,request_url,method,headers__$1,xhr,map__34182,map__34182__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___34212,channel,request_url,method,headers__$1,xhr,map__34182,map__34182__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (state_34196){
var state_val_34197 = (state_34196[(1)]);
if((state_val_34197 === (1))){
var state_34196__$1 = state_34196;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34196__$1,(2),cancel);
} else {
if((state_val_34197 === (2))){
var inst_34187 = (state_34196[(2)]);
var inst_34188 = xhr.isComplete();
var inst_34189 = cljs.core.not(inst_34188);
var state_34196__$1 = (function (){var statearr_34198 = state_34196;
(statearr_34198[(7)] = inst_34187);

return statearr_34198;
})();
if(inst_34189){
var statearr_34199_34213 = state_34196__$1;
(statearr_34199_34213[(1)] = (3));

} else {
var statearr_34200_34214 = state_34196__$1;
(statearr_34200_34214[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34197 === (3))){
var inst_34191 = xhr.abort();
var state_34196__$1 = state_34196;
var statearr_34201_34215 = state_34196__$1;
(statearr_34201_34215[(2)] = inst_34191);

(statearr_34201_34215[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34197 === (4))){
var state_34196__$1 = state_34196;
var statearr_34202_34216 = state_34196__$1;
(statearr_34202_34216[(2)] = null);

(statearr_34202_34216[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34197 === (5))){
var inst_34194 = (state_34196[(2)]);
var state_34196__$1 = state_34196;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34196__$1,inst_34194);
} else {
return null;
}
}
}
}
}
});})(c__19089__auto___34212,channel,request_url,method,headers__$1,xhr,map__34182,map__34182__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
return ((function (switch__18977__auto__,c__19089__auto___34212,channel,request_url,method,headers__$1,xhr,map__34182,map__34182__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function() {
var cljs_http$core$xhr_$_state_machine__18978__auto__ = null;
var cljs_http$core$xhr_$_state_machine__18978__auto____0 = (function (){
var statearr_34206 = [null,null,null,null,null,null,null,null];
(statearr_34206[(0)] = cljs_http$core$xhr_$_state_machine__18978__auto__);

(statearr_34206[(1)] = (1));

return statearr_34206;
});
var cljs_http$core$xhr_$_state_machine__18978__auto____1 = (function (state_34196){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_34196);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e34207){if((e34207 instanceof Object)){
var ex__18981__auto__ = e34207;
var statearr_34208_34217 = state_34196;
(statearr_34208_34217[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34196);

return cljs.core.cst$kw$recur;
} else {
throw e34207;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__34218 = state_34196;
state_34196 = G__34218;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__18978__auto__ = function(state_34196){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__18978__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__18978__auto____1.call(this,state_34196);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__18978__auto____0;
cljs_http$core$xhr_$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__18978__auto____1;
return cljs_http$core$xhr_$_state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___34212,channel,request_url,method,headers__$1,xhr,map__34182,map__34182__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
})();
var state__19091__auto__ = (function (){var statearr_34209 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_34209[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___34212);

return statearr_34209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___34212,channel,request_url,method,headers__$1,xhr,map__34182,map__34182__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__34219){
var map__34236 = p__34219;
var map__34236__$1 = ((((!((map__34236 == null)))?((((map__34236.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34236.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34236):map__34236);
var request = map__34236__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34236__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34236__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34236__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34236__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_34252 = jsonp.send(null,((function (channel,jsonp,map__34236,map__34236__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__34236,map__34236__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp,map__34236,map__34236__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__34236,map__34236__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_34252], null));

if(cljs.core.truth_(cancel)){
var c__19089__auto___34253 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19089__auto___34253,req_34252,channel,jsonp,map__34236,map__34236__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__19090__auto__ = (function (){var switch__18977__auto__ = ((function (c__19089__auto___34253,req_34252,channel,jsonp,map__34236,map__34236__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_34242){
var state_val_34243 = (state_34242[(1)]);
if((state_val_34243 === (1))){
var state_34242__$1 = state_34242;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34242__$1,(2),cancel);
} else {
if((state_val_34243 === (2))){
var inst_34239 = (state_34242[(2)]);
var inst_34240 = jsonp.cancel(req_34252);
var state_34242__$1 = (function (){var statearr_34244 = state_34242;
(statearr_34244[(7)] = inst_34239);

return statearr_34244;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34242__$1,inst_34240);
} else {
return null;
}
}
});})(c__19089__auto___34253,req_34252,channel,jsonp,map__34236,map__34236__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__18977__auto__,c__19089__auto___34253,req_34252,channel,jsonp,map__34236,map__34236__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__18978__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__18978__auto____0 = (function (){
var statearr_34248 = [null,null,null,null,null,null,null,null];
(statearr_34248[(0)] = cljs_http$core$jsonp_$_state_machine__18978__auto__);

(statearr_34248[(1)] = (1));

return statearr_34248;
});
var cljs_http$core$jsonp_$_state_machine__18978__auto____1 = (function (state_34242){
while(true){
var ret_value__18979__auto__ = (function (){try{while(true){
var result__18980__auto__ = switch__18977__auto__(state_34242);
if(cljs.core.keyword_identical_QMARK_(result__18980__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18980__auto__;
}
break;
}
}catch (e34249){if((e34249 instanceof Object)){
var ex__18981__auto__ = e34249;
var statearr_34250_34254 = state_34242;
(statearr_34250_34254[(5)] = ex__18981__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34242);

return cljs.core.cst$kw$recur;
} else {
throw e34249;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18979__auto__,cljs.core.cst$kw$recur)){
var G__34255 = state_34242;
state_34242 = G__34255;
continue;
} else {
return ret_value__18979__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__18978__auto__ = function(state_34242){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__18978__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__18978__auto____1.call(this,state_34242);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__18978__auto____0;
cljs_http$core$jsonp_$_state_machine__18978__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__18978__auto____1;
return cljs_http$core$jsonp_$_state_machine__18978__auto__;
})()
;})(switch__18977__auto__,c__19089__auto___34253,req_34252,channel,jsonp,map__34236,map__34236__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__19091__auto__ = (function (){var statearr_34251 = (f__19090__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19090__auto__.cljs$core$IFn$_invoke$arity$0() : f__19090__auto__.call(null));
(statearr_34251[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19089__auto___34253);

return statearr_34251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19091__auto__);
});})(c__19089__auto___34253,req_34252,channel,jsonp,map__34236,map__34236__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__34256){
var map__34259 = p__34256;
var map__34259__$1 = ((((!((map__34259 == null)))?((((map__34259.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34259.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34259):map__34259);
var request = map__34259__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34259__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
