// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.rest_services');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create a rest service.
 * `xform-id` is the numeric id of the x-form to associate the service with
 * `name` is one of 1. `generic_json`
 *                  2. `generic_xml`
 *                  3. `textit`
 *                  4. `f2dhis2`
 *                  5. `bamboo`
 * `service-url` is the URL of the webhook receiving endpoint
 * `options` is a map for additional configuration, containing the following
 *    keys in the case of textit:
 *  1. `:service` - Service being configured
 *  2. `:auth_token` - Authentication token
 *  3. `:flow_uuid` - UUID of the flow in textit
 *  4. `:contacts` - The contact in the flow
 */
milia.api.rest_services.create = (function milia$api$rest_services$create(var_args){
var args__7658__auto__ = [];
var len__7651__auto___26848 = arguments.length;
var i__7652__auto___26849 = (0);
while(true){
if((i__7652__auto___26849 < len__7651__auto___26848)){
args__7658__auto__.push((arguments[i__7652__auto___26849]));

var G__26850 = (i__7652__auto___26849 + (1));
i__7652__auto___26849 = G__26850;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic = (function (xform_id,name,service_url,p__26844){
var vec__26845 = p__26844;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26845,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
});

milia.api.rest_services.create.cljs$lang$maxFixedArity = (3);

milia.api.rest_services.create.cljs$lang$applyTo = (function (seq26840){
var G__26841 = cljs.core.first(seq26840);
var seq26840__$1 = cljs.core.next(seq26840);
var G__26842 = cljs.core.first(seq26840__$1);
var seq26840__$2 = cljs.core.next(seq26840__$1);
var G__26843 = cljs.core.first(seq26840__$2);
var seq26840__$3 = cljs.core.next(seq26840__$2);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic(G__26841,G__26842,G__26843,seq26840__$3);
});

/**
 * Updates a rest service.
 */
milia.api.rest_services.update_restservice = (function milia$api$rest_services$update_restservice(var_args){
var args__7658__auto__ = [];
var len__7651__auto___26860 = arguments.length;
var i__7652__auto___26861 = (0);
while(true){
if((i__7652__auto___26861 < len__7651__auto___26860)){
args__7658__auto__.push((arguments[i__7652__auto___26861]));

var G__26862 = (i__7652__auto___26861 + (1));
i__7652__auto___26861 = G__26862;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((4) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((4)),(0),null)):null);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7659__auto__);
});

milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic = (function (id,xform_id,name,service_url,p__26856){
var vec__26857 = p__26856;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26857,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
});

milia.api.rest_services.update_restservice.cljs$lang$maxFixedArity = (4);

milia.api.rest_services.update_restservice.cljs$lang$applyTo = (function (seq26851){
var G__26852 = cljs.core.first(seq26851);
var seq26851__$1 = cljs.core.next(seq26851);
var G__26853 = cljs.core.first(seq26851__$1);
var seq26851__$2 = cljs.core.next(seq26851__$1);
var G__26854 = cljs.core.first(seq26851__$2);
var seq26851__$3 = cljs.core.next(seq26851__$2);
var G__26855 = cljs.core.first(seq26851__$3);
var seq26851__$4 = cljs.core.next(seq26851__$3);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic(G__26852,G__26853,G__26854,G__26855,seq26851__$4);
});

/**
 * Delete a rest service
 */
milia.api.rest_services.delete$ = (function milia$api$rest_services$delete(id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)));
});
/**
 * Get all rest services the requesting user has access to
 */
milia.api.rest_services.get_all = (function milia$api$rest_services$get_all(){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)));
});
/**
 * Get information for a specific rest service
 */
milia.api.rest_services.get_by_id = (function milia$api$rest_services$get_by_id(var_args){
var args__7658__auto__ = [];
var len__7651__auto___26868 = arguments.length;
var i__7652__auto___26869 = (0);
while(true){
if((i__7652__auto___26869 < len__7651__auto___26868)){
args__7658__auto__.push((arguments[i__7652__auto___26869]));

var G__26870 = (i__7652__auto___26869 + (1));
i__7652__auto___26869 = G__26870;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__26865){
var map__26866 = p__26865;
var map__26866__$1 = ((((!((map__26866 == null)))?((((map__26866.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26866.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26866):map__26866);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26866__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.rest_services.get_by_id.cljs$lang$maxFixedArity = (1);

milia.api.rest_services.get_by_id.cljs$lang$applyTo = (function (seq26863){
var G__26864 = cljs.core.first(seq26863);
var seq26863__$1 = cljs.core.next(seq26863);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic(G__26864,seq26863__$1);
});

/**
 * Get rest services for a form
 */
milia.api.rest_services.get_by_form_id = (function milia$api$rest_services$get_by_form_id(var_args){
var args__7658__auto__ = [];
var len__7651__auto___26876 = arguments.length;
var i__7652__auto___26877 = (0);
while(true){
if((i__7652__auto___26877 < len__7651__auto___26876)){
args__7658__auto__.push((arguments[i__7652__auto___26877]));

var G__26878 = (i__7652__auto___26877 + (1));
i__7652__auto___26877 = G__26878;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic = (function (formid,p__26873){
var map__26874 = p__26873;
var map__26874__$1 = ((((!((map__26874 == null)))?((((map__26874.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26874.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26874):map__26874);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26874__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("restservices?xform="),cljs.core.str(formid)].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.rest_services.get_by_form_id.cljs$lang$maxFixedArity = (1);

milia.api.rest_services.get_by_form_id.cljs$lang$applyTo = (function (seq26871){
var G__26872 = cljs.core.first(seq26871);
var seq26871__$1 = cljs.core.next(seq26871);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic(G__26872,seq26871__$1);
});

