// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('chimera.js_interop');
goog.require('cljs.core');
goog.require('cognitect.transit');
goog.require('goog.string');
/**
 * Convert json string to cljs object using transit.
 * Fast, but doesn't preserve keywords.
 */
chimera.js_interop.json__GT_cljs = (function chimera$js_interop$json__GT_cljs(s){
return cognitect.transit.read(cognitect.transit.reader.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$json),s);
});
/**
 * Convert json to js using JSON.parse.
 * If error occurs, return the string unmodified.
 */
chimera.js_interop.str__GT_json = (function chimera$js_interop$str__GT_json(string){
try{return JSON.parse(string);
}catch (e34917){if((e34917 instanceof Error)){
var _ = e34917;
return string;
} else {
throw e34917;

}
}});
/**
 * Convert json string to cljs via js.
 * Slow method, but preserves keywords, and appropriate for small json.
 */
chimera.js_interop.json__GT_js__GT_cljs = (function chimera$js_interop$json__GT_js__GT_cljs(s){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(chimera.js_interop.str__GT_json(s),cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
/**
 * Formats a string using goog.string.format, so we can use format in cljx.
 */
chimera.js_interop.format = (function chimera$js_interop$format(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34920 = arguments.length;
var i__7652__auto___34921 = (0);
while(true){
if((i__7652__auto___34921 < len__7651__auto___34920)){
args__7658__auto__.push((arguments[i__7652__auto___34921]));

var G__34922 = (i__7652__auto___34921 + (1));
i__7652__auto___34921 = G__34922;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
});

chimera.js_interop.format.cljs$lang$maxFixedArity = (1);

chimera.js_interop.format.cljs$lang$applyTo = (function (seq34918){
var G__34919 = cljs.core.first(seq34918);
var seq34918__$1 = cljs.core.next(seq34918);
return chimera.js_interop.format.cljs$core$IFn$_invoke$arity$variadic(G__34919,seq34918__$1);
});

/**
 * Create a safe (escaped) js regex out of a string.
 * By default, creates regex with ignore case option.
 */
chimera.js_interop.safe_regex = (function chimera$js_interop$safe_regex(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34928 = arguments.length;
var i__7652__auto___34929 = (0);
while(true){
if((i__7652__auto___34929 < len__7651__auto___34928)){
args__7658__auto__.push((arguments[i__7652__auto___34929]));

var G__34930 = (i__7652__auto___34929 + (1));
i__7652__auto___34929 = G__34930;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic = (function (query_string,p__34925){
var map__34926 = p__34925;
var map__34926__$1 = ((((!((map__34926 == null)))?((((map__34926.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34926.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34926):map__34926);
var ignore_case_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__34926__$1,cljs.core.cst$kw$ignore_DASH_case_QMARK_,true);
return cljs.core.re_pattern([cljs.core.str((cljs.core.truth_(ignore_case_QMARK_)?"(?i)":null)),cljs.core.str(goog.string.regExpEscape(query_string))].join(''));
});

chimera.js_interop.safe_regex.cljs$lang$maxFixedArity = (1);

chimera.js_interop.safe_regex.cljs$lang$applyTo = (function (seq34923){
var G__34924 = cljs.core.first(seq34923);
var seq34923__$1 = cljs.core.next(seq34923);
return chimera.js_interop.safe_regex.cljs$core$IFn$_invoke$arity$variadic(G__34924,seq34923__$1);
});

