// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('chimera.seq');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('chimera.string');
goog.require('clojure.set');
/**
 * Concat then turn into vector
 */
chimera.seq.concatv = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,cljs.core.concat);
chimera.seq.filter_first = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.filter);
chimera.seq.not_empty_QMARK_ = cljs.core.complement(cljs.core.empty_QMARK_);
chimera.seq.select_values = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.vals,cljs.core.select_keys);
chimera.seq.select_value = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.first,chimera.seq.select_values);
/**
 * Return a list of all items that appear more than once in a sequence.
 */
chimera.seq.duplicates = (function chimera$seq$duplicates(l){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__34606_SHARP_){
if((cljs.core.last(p1__34606_SHARP_) > (1))){
return cljs.core.first(p1__34606_SHARP_);
} else {
return null;
}
}),cljs.core.frequencies(l));
});
/**
 * True is map has all these keys.
 */
chimera.seq.has_keys_QMARK_ = (function chimera$seq$has_keys_QMARK_(m,keys){
return cljs.core.every_QMARK_(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.contains_QMARK_,m),keys);
});
/**
 * True if elem is in list, false otherwise.
 */
chimera.seq.in_QMARK_ = (function chimera$seq$in_QMARK_(list,elem){
return cljs.core.boolean$(cljs.core.some((function (p1__34607_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(elem,p1__34607_SHARP_);
}),list));
});
chimera.seq.mapply = (function chimera$seq$mapply(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34610 = arguments.length;
var i__7652__auto___34611 = (0);
while(true){
if((i__7652__auto___34611 < len__7651__auto___34610)){
args__7658__auto__.push((arguments[i__7652__auto___34611]));

var G__34612 = (i__7652__auto___34611 + (1));
i__7652__auto___34611 = G__34612;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.concat,cljs.core.butlast(args),cljs.core.last(args)));
});

chimera.seq.mapply.cljs$lang$maxFixedArity = (1);

chimera.seq.mapply.cljs$lang$applyTo = (function (seq34608){
var G__34609 = cljs.core.first(seq34608);
var seq34608__$1 = cljs.core.next(seq34608);
return chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(G__34609,seq34608__$1);
});

chimera.seq.sort_by_category = (function chimera$seq$sort_by_category(sort_by_key,collection){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (item){
var G__34614 = cljs.core.cst$kw$metadata.cljs$core$IFn$_invoke$arity$1(item);
return (sort_by_key.cljs$core$IFn$_invoke$arity$1 ? sort_by_key.cljs$core$IFn$_invoke$arity$1(G__34614) : sort_by_key.call(null,G__34614));
}),collection);
});
/**
 * Apply a function to each value of a map. From http://goo.gl/JdwzZf
 */
chimera.seq.update_values = (function chimera$seq$update_values(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34622 = arguments.length;
var i__7652__auto___34623 = (0);
while(true){
if((i__7652__auto___34623 < len__7651__auto___34622)){
args__7658__auto__.push((arguments[i__7652__auto___34623]));

var G__34624 = (i__7652__auto___34623 + (1));
i__7652__auto___34623 = G__34624;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return chimera.seq.update_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

chimera.seq.update_values.cljs$core$IFn$_invoke$arity$variadic = (function (m,f,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (r,p__34618){
var vec__34619 = p__34618;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34619,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34619,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(r,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,v,args));
}),cljs.core.PersistentArrayMap.EMPTY,m);
});

chimera.seq.update_values.cljs$lang$maxFixedArity = (2);

chimera.seq.update_values.cljs$lang$applyTo = (function (seq34615){
var G__34616 = cljs.core.first(seq34615);
var seq34615__$1 = cljs.core.next(seq34615);
var G__34617 = cljs.core.first(seq34615__$1);
var seq34615__$2 = cljs.core.next(seq34615__$1);
return chimera.seq.update_values.cljs$core$IFn$_invoke$arity$variadic(G__34616,G__34617,seq34615__$2);
});

chimera.seq.sort_by_name = (function chimera$seq$sort_by_name(sort_by_key,collection){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__34625_SHARP_){
return clojure.string.lower_case((sort_by_key.cljs$core$IFn$_invoke$arity$1 ? sort_by_key.cljs$core$IFn$_invoke$arity$1(p1__34625_SHARP_) : sort_by_key.call(null,p1__34625_SHARP_)));
}),collection);
});
/**
 * Removes elem from a vector by its position.
 */
chimera.seq.dissoc_vec = (function chimera$seq$dissoc_vec(coll,pos){
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(coll,(0),pos),cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(coll,(pos + (1)))));
});
/**
 * Like core/assoc-in but accepting multiple key vectors and values
 * (assoc-in* coll & args)
 */
chimera.seq.assoc_in_multi = (function chimera$seq$assoc_in_multi(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34636 = arguments.length;
var i__7652__auto___34637 = (0);
while(true){
if((i__7652__auto___34637 < len__7651__auto___34636)){
args__7658__auto__.push((arguments[i__7652__auto___34637]));

var G__34638 = (i__7652__auto___34637 + (1));
i__7652__auto___34637 = G__34638;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return chimera.seq.assoc_in_multi.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

chimera.seq.assoc_in_multi.cljs$core$IFn$_invoke$arity$variadic = (function (coll,args){
if(cljs.core.even_QMARK_){
} else {
throw (new Error("Assert failed: even?"));
}

if(cljs.core.truth_(cljs.core.count(args))){
} else {
throw (new Error("Assert failed: (count args)"));
}

var pairs = cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),args);
var reducer = ((function (pairs){
return (function (skeleton_map,p__34632){
var vec__34633 = p__34632;
var keys = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34633,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34633,(1),null);
return cljs.core.assoc_in(skeleton_map,keys,value);
});})(pairs))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(reducer,coll,pairs);
});

chimera.seq.assoc_in_multi.cljs$lang$maxFixedArity = (1);

chimera.seq.assoc_in_multi.cljs$lang$applyTo = (function (seq34630){
var G__34631 = cljs.core.first(seq34630);
var seq34630__$1 = cljs.core.next(seq34630);
return chimera.seq.assoc_in_multi.cljs$core$IFn$_invoke$arity$variadic(G__34631,seq34630__$1);
});

/**
 * Deep merge any number of maps.
 */
chimera.seq.deep_merge = (function chimera$seq$deep_merge(var_args){
var args__7658__auto__ = [];
var len__7651__auto___34640 = arguments.length;
var i__7652__auto___34641 = (0);
while(true){
if((i__7652__auto___34641 < len__7651__auto___34640)){
args__7658__auto__.push((arguments[i__7652__auto___34641]));

var G__34642 = (i__7652__auto___34641 + (1));
i__7652__auto___34641 = G__34642;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return chimera.seq.deep_merge.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

chimera.seq.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,(function (x,y){
if(cljs.core.map_QMARK_(y)){
return chimera.seq.deep_merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([x,y], 0));
} else {
if(cljs.core.vector_QMARK_(y)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y);
} else {
return y;

}
}
}),maps);
});

chimera.seq.deep_merge.cljs$lang$maxFixedArity = (0);

chimera.seq.deep_merge.cljs$lang$applyTo = (function (seq34639){
return chimera.seq.deep_merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34639));
});

/**
 * Apply func to pred matching k value to v.
 */
chimera.seq.fn_collection = (function chimera$seq$fn_collection(func,k,v,collection){
if(cljs.core.truth_(v)){
var G__34646 = (function (p1__34643_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,(k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(p1__34643_SHARP_) : k.call(null,p1__34643_SHARP_)));
});
var G__34647 = collection;
return (func.cljs$core$IFn$_invoke$arity$2 ? func.cljs$core$IFn$_invoke$arity$2(G__34646,G__34647) : func.call(null,G__34646,G__34647));
} else {
return collection;
}
});
/**
 * Keeps values in list maps where k value matchs v
 */
chimera.seq.filter_collection = (function chimera$seq$filter_collection(k,v,collection){
return chimera.seq.fn_collection(cljs.core.filter,k,v,collection);
});
/**
 * Removes values in list maps where k value matchs cond
 */
chimera.seq.filter_out_collection = (function chimera$seq$filter_out_collection(k,v,collection){
return chimera.seq.fn_collection(cljs.core.remove,k,v,collection);
});
/**
 * Remove map entries where the value is falsey.
 */
chimera.seq.remove_falsey_values = (function chimera$seq$remove_falsey_values(a_map){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(clojure.string.blank_QMARK_,cljs.core.second),a_map));
});
/**
 * Return collections with a key matching the query.
 */
chimera.seq.search_collection = (function chimera$seq$search_collection(var_args){
var args34648 = [];
var len__7651__auto___34657 = arguments.length;
var i__7652__auto___34658 = (0);
while(true){
if((i__7652__auto___34658 < len__7651__auto___34657)){
args34648.push((arguments[i__7652__auto___34658]));

var G__34659 = (i__7652__auto___34658 + (1));
i__7652__auto___34658 = G__34659;
continue;
} else {
}
break;
}

var G__34650 = args34648.length;
switch (G__34650) {
case 3:
return chimera.seq.search_collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return chimera.seq.search_collection.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34648.length)].join('')));

}
});

chimera.seq.search_collection.cljs$core$IFn$_invoke$arity$3 = (function (query,collection,k){
return chimera.seq.search_collection.cljs$core$IFn$_invoke$arity$4(query,collection,k,true);
});

chimera.seq.search_collection.cljs$core$IFn$_invoke$arity$4 = (function (query,collection,k,case_insensitive_QMARK_){
var query_cased = (cljs.core.truth_(case_insensitive_QMARK_)?clojure.string.lower_case(query):query);
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,(function (){var iter__7326__auto__ = ((function (query_cased){
return (function chimera$seq$iter__34651(s__34652){
return (new cljs.core.LazySeq(null,((function (query_cased){
return (function (){
var s__34652__$1 = s__34652;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__34652__$1);
if(temp__4657__auto__){
var s__34652__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34652__$2)){
var c__7324__auto__ = cljs.core.chunk_first(s__34652__$2);
var size__7325__auto__ = cljs.core.count(c__7324__auto__);
var b__34654 = cljs.core.chunk_buffer(size__7325__auto__);
if((function (){var i__34653 = (0);
while(true){
if((i__34653 < size__7325__auto__)){
var member = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7324__auto__,i__34653);
var v = (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(member) : k.call(null,member));
var v_cased = (cljs.core.truth_(case_insensitive_QMARK_)?clojure.string.lower_case(v):v);
if(cljs.core.truth_(chimera.string.substring_QMARK_(query_cased,v_cased))){
cljs.core.chunk_append(b__34654,member);

var G__34661 = (i__34653 + (1));
i__34653 = G__34661;
continue;
} else {
var G__34662 = (i__34653 + (1));
i__34653 = G__34662;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34654),chimera$seq$iter__34651(cljs.core.chunk_rest(s__34652__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34654),null);
}
} else {
var member = cljs.core.first(s__34652__$2);
var v = (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(member) : k.call(null,member));
var v_cased = (cljs.core.truth_(case_insensitive_QMARK_)?clojure.string.lower_case(v):v);
if(cljs.core.truth_(chimera.string.substring_QMARK_(query_cased,v_cased))){
return cljs.core.cons(member,chimera$seq$iter__34651(cljs.core.rest(s__34652__$2)));
} else {
var G__34663 = cljs.core.rest(s__34652__$2);
s__34652__$1 = G__34663;
continue;
}
}
} else {
return null;
}
break;
}
});})(query_cased))
,null,null));
});})(query_cased))
;
return iter__7326__auto__(collection);
})());
});

chimera.seq.search_collection.cljs$lang$maxFixedArity = 4;

/**
 * Returns the position of at which pred is true for items in coll.
 */
chimera.seq.positions = (function chimera$seq$positions(pred,coll){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,x){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(x) : pred.call(null,x)))){
return idx;
} else {
return null;
}
}),coll);
});
/**
 * Returns index of an item within a collection.
 */
chimera.seq.index_of = (function chimera$seq$index_of(coll,item){
return cljs.core.first(chimera.seq.positions(cljs.core.PersistentHashSet.fromArray([item], true),coll));
});
/**
 * Update map value in list based on key match
 */
chimera.seq.update_map_in_list = (function chimera$seq$update_map_in_list(list,map_to_update,key_to_match){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__34664_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((key_to_match.cljs$core$IFn$_invoke$arity$1 ? key_to_match.cljs$core$IFn$_invoke$arity$1(p1__34664_SHARP_) : key_to_match.call(null,p1__34664_SHARP_)),(key_to_match.cljs$core$IFn$_invoke$arity$1 ? key_to_match.cljs$core$IFn$_invoke$arity$1(map_to_update) : key_to_match.call(null,map_to_update)))){
return map_to_update;
} else {
return p1__34664_SHARP_;
}
}),list);
});
/**
 * Basically lifted from http://stackoverflow.com/a/17902228/420386
 */
chimera.seq.flatten_map = (function chimera$seq$flatten_map(var_args){
var args34665 = [];
var len__7651__auto___34672 = arguments.length;
var i__7652__auto___34673 = (0);
while(true){
if((i__7652__auto___34673 < len__7651__auto___34672)){
args34665.push((arguments[i__7652__auto___34673]));

var G__34674 = (i__7652__auto___34673 + (1));
i__7652__auto___34673 = G__34674;
continue;
} else {
}
break;
}

var G__34667 = args34665.length;
switch (G__34667) {
case 1:
return chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34665.length)].join('')));

}
});

chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$1 = (function (form){
return chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$2(form,"/");
});

chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$2 = (function (form,separator){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$3(form,separator,null));
});

chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$3 = (function (form,separator,prefix){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__34668){
var vec__34669 = p__34668;
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34669,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34669,(1),null);
var full_prefix = (cljs.core.truth_(prefix)?[cljs.core.str(prefix),cljs.core.str(separator),cljs.core.str(cljs.core.name(key))].join(''):cljs.core.name(key));
if(cljs.core.map_QMARK_(value)){
return chimera.seq.flatten_map.cljs$core$IFn$_invoke$arity$3(value,separator,full_prefix);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [full_prefix,value], null)], null);
}
}),cljs.core.array_seq([form], 0));
});

chimera.seq.flatten_map.cljs$lang$maxFixedArity = 3;

/**
 * Return difference between 2 sequences.
 */
chimera.seq.diff = (function chimera$seq$diff(a,b){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set(a),cljs.core.set(b));
});
/**
 * Return difference between 2 sequences. Preserves ordering in first seq.
 */
chimera.seq.ordered_diff = (function chimera$seq$ordered_diff(a,b){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__34676_SHARP_){
return !(cljs.core.contains_QMARK_(cljs.core.set(b),p1__34676_SHARP_));
}),a);
});
/**
 * Merges two sequeneces
 */
chimera.seq.union = (function chimera$seq$union(a,b){
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.set(a),cljs.core.set(b));
});
/**
 * Remove nil values from a sequence.
 */
chimera.seq.remove_nil = (function chimera$seq$remove_nil(l){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,l);
});
/**
 * Removes x from coll if present, and adds if absent.
 */
chimera.seq.toggle = (function chimera$seq$toggle(coll,x){
if(cljs.core.contains_QMARK_(cljs.core.set(coll),x)){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__34677_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,p1__34677_SHARP_);
}),coll);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * Given a seq, produces a two-el seq. [a b c] => [[0 a] [1 b] [2 c]].
 */
chimera.seq.indexed = (function chimera$seq$indexed(coll){
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,coll);
});
chimera.seq.transpose = (function chimera$seq$transpose(m){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.mapv,cljs.core.vector,m);
});
/**
 * Get the first map from a list of maps with the given value for key.
 */
chimera.seq.map_list__GT_map = (function chimera$seq$map_list__GT_map(map_list,k,v){
var G__34681 = (function (p1__34678_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(p1__34678_SHARP_) : k.call(null,p1__34678_SHARP_)),v);
});
var G__34682 = map_list;
return (chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2 ? chimera.seq.filter_first.cljs$core$IFn$_invoke$arity$2(G__34681,G__34682) : chimera.seq.filter_first.call(null,G__34681,G__34682));
});
