// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args31748 = [];
var len__7651__auto___31754 = arguments.length;
var i__7652__auto___31755 = (0);
while(true){
if((i__7652__auto___31755 < len__7651__auto___31754)){
args31748.push((arguments[i__7652__auto___31755]));

var G__31756 = (i__7652__auto___31755 + (1));
i__7652__auto___31755 = G__31756;
continue;
} else {
}
break;
}

var G__31750 = args31748.length;
switch (G__31750) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31748.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async31751 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31751 = (function (f,blockable,meta31752){
this.f = f;
this.blockable = blockable;
this.meta31752 = meta31752;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31751.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31753,meta31752__$1){
var self__ = this;
var _31753__$1 = this;
return (new cljs.core.async.t_cljs$core$async31751(self__.f,self__.blockable,meta31752__$1));
});

cljs.core.async.t_cljs$core$async31751.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31753){
var self__ = this;
var _31753__$1 = this;
return self__.meta31752;
});

cljs.core.async.t_cljs$core$async31751.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31751.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31751.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async31751.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async31751.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta31752], null);
});

cljs.core.async.t_cljs$core$async31751.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31751.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31751";

cljs.core.async.t_cljs$core$async31751.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async31751");
});

cljs.core.async.__GT_t_cljs$core$async31751 = (function cljs$core$async$__GT_t_cljs$core$async31751(f__$1,blockable__$1,meta31752){
return (new cljs.core.async.t_cljs$core$async31751(f__$1,blockable__$1,meta31752));
});

}

return (new cljs.core.async.t_cljs$core$async31751(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args31760 = [];
var len__7651__auto___31763 = arguments.length;
var i__7652__auto___31764 = (0);
while(true){
if((i__7652__auto___31764 < len__7651__auto___31763)){
args31760.push((arguments[i__7652__auto___31764]));

var G__31765 = (i__7652__auto___31764 + (1));
i__7652__auto___31764 = G__31765;
continue;
} else {
}
break;
}

var G__31762 = args31760.length;
switch (G__31762) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31760.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args31767 = [];
var len__7651__auto___31770 = arguments.length;
var i__7652__auto___31771 = (0);
while(true){
if((i__7652__auto___31771 < len__7651__auto___31770)){
args31767.push((arguments[i__7652__auto___31771]));

var G__31772 = (i__7652__auto___31771 + (1));
i__7652__auto___31771 = G__31772;
continue;
} else {
}
break;
}

var G__31769 = args31767.length;
switch (G__31769) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31767.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args31774 = [];
var len__7651__auto___31777 = arguments.length;
var i__7652__auto___31778 = (0);
while(true){
if((i__7652__auto___31778 < len__7651__auto___31777)){
args31774.push((arguments[i__7652__auto___31778]));

var G__31779 = (i__7652__auto___31778 + (1));
i__7652__auto___31778 = G__31779;
continue;
} else {
}
break;
}

var G__31776 = args31774.length;
switch (G__31776) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31774.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_31781 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31781) : fn1.call(null,val_31781));
} else {
cljs.core.async.impl.dispatch.run(((function (val_31781,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31781) : fn1.call(null,val_31781));
});})(val_31781,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args31782 = [];
var len__7651__auto___31785 = arguments.length;
var i__7652__auto___31786 = (0);
while(true){
if((i__7652__auto___31786 < len__7651__auto___31785)){
args31782.push((arguments[i__7652__auto___31786]));

var G__31787 = (i__7652__auto___31786 + (1));
i__7652__auto___31786 = G__31787;
continue;
} else {
}
break;
}

var G__31784 = args31782.length;
switch (G__31784) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31782.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7461__auto___31789 = n;
var x_31790 = (0);
while(true){
if((x_31790 < n__7461__auto___31789)){
(a[x_31790] = (0));

var G__31791 = (x_31790 + (1));
x_31790 = G__31791;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__31792 = (i + (1));
i = G__31792;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async31796 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31796 = (function (flag,meta31797){
this.flag = flag;
this.meta31797 = meta31797;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31796.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31798,meta31797__$1){
var self__ = this;
var _31798__$1 = this;
return (new cljs.core.async.t_cljs$core$async31796(self__.flag,meta31797__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31796.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31798){
var self__ = this;
var _31798__$1 = this;
return self__.meta31797;
});})(flag))
;

cljs.core.async.t_cljs$core$async31796.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31796.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async31796.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31796.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31796.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta31797], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31796.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31796.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31796";

cljs.core.async.t_cljs$core$async31796.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async31796");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31796 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31796(flag__$1,meta31797){
return (new cljs.core.async.t_cljs$core$async31796(flag__$1,meta31797));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31796(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31802 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31802 = (function (flag,cb,meta31803){
this.flag = flag;
this.cb = cb;
this.meta31803 = meta31803;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31802.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31804,meta31803__$1){
var self__ = this;
var _31804__$1 = this;
return (new cljs.core.async.t_cljs$core$async31802(self__.flag,self__.cb,meta31803__$1));
});

cljs.core.async.t_cljs$core$async31802.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31804){
var self__ = this;
var _31804__$1 = this;
return self__.meta31803;
});

cljs.core.async.t_cljs$core$async31802.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31802.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async31802.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31802.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31802.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta31803], null);
});

cljs.core.async.t_cljs$core$async31802.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31802.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31802";

cljs.core.async.t_cljs$core$async31802.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async31802");
});

cljs.core.async.__GT_t_cljs$core$async31802 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31802(flag__$1,cb__$1,meta31803){
return (new cljs.core.async.t_cljs$core$async31802(flag__$1,cb__$1,meta31803));
});

}

return (new cljs.core.async.t_cljs$core$async31802(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31805_SHARP_){
var G__31809 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31805_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31809) : fret.call(null,G__31809));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31806_SHARP_){
var G__31810 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31806_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31810) : fret.call(null,G__31810));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6543__auto__ = wport;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31811 = (i + (1));
i = G__31811;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6543__auto__ = ret;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6531__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31817 = arguments.length;
var i__7652__auto___31818 = (0);
while(true){
if((i__7652__auto___31818 < len__7651__auto___31817)){
args__7658__auto__.push((arguments[i__7652__auto___31818]));

var G__31819 = (i__7652__auto___31818 + (1));
i__7652__auto___31818 = G__31819;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31814){
var map__31815 = p__31814;
var map__31815__$1 = ((((!((map__31815 == null)))?((((map__31815.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31815.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31815):map__31815);
var opts = map__31815__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31812){
var G__31813 = cljs.core.first(seq31812);
var seq31812__$1 = cljs.core.next(seq31812);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31813,seq31812__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args31820 = [];
var len__7651__auto___31870 = arguments.length;
var i__7652__auto___31871 = (0);
while(true){
if((i__7652__auto___31871 < len__7651__auto___31870)){
args31820.push((arguments[i__7652__auto___31871]));

var G__31872 = (i__7652__auto___31871 + (1));
i__7652__auto___31871 = G__31872;
continue;
} else {
}
break;
}

var G__31822 = args31820.length;
switch (G__31822) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31820.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__18808__auto___31874 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___31874){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___31874){
return (function (state_31846){
var state_val_31847 = (state_31846[(1)]);
if((state_val_31847 === (7))){
var inst_31842 = (state_31846[(2)]);
var state_31846__$1 = state_31846;
var statearr_31848_31875 = state_31846__$1;
(statearr_31848_31875[(2)] = inst_31842);

(statearr_31848_31875[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31847 === (1))){
var state_31846__$1 = state_31846;
var statearr_31849_31876 = state_31846__$1;
(statearr_31849_31876[(2)] = null);

(statearr_31849_31876[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31847 === (4))){
var inst_31825 = (state_31846[(7)]);
var inst_31825__$1 = (state_31846[(2)]);
var inst_31826 = (inst_31825__$1 == null);
var state_31846__$1 = (function (){var statearr_31850 = state_31846;
(statearr_31850[(7)] = inst_31825__$1);

return statearr_31850;
})();
if(cljs.core.truth_(inst_31826)){
var statearr_31851_31877 = state_31846__$1;
(statearr_31851_31877[(1)] = (5));

} else {
var statearr_31852_31878 = state_31846__$1;
(statearr_31852_31878[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31847 === (13))){
var state_31846__$1 = state_31846;
var statearr_31853_31879 = state_31846__$1;
(statearr_31853_31879[(2)] = null);

(statearr_31853_31879[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31847 === (6))){
var inst_31825 = (state_31846[(7)]);
var state_31846__$1 = state_31846;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31846__$1,(11),to,inst_31825);
} else {
if((state_val_31847 === (3))){
var inst_31844 = (state_31846[(2)]);
var state_31846__$1 = state_31846;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31846__$1,inst_31844);
} else {
if((state_val_31847 === (12))){
var state_31846__$1 = state_31846;
var statearr_31854_31880 = state_31846__$1;
(statearr_31854_31880[(2)] = null);

(statearr_31854_31880[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31847 === (2))){
var state_31846__$1 = state_31846;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31846__$1,(4),from);
} else {
if((state_val_31847 === (11))){
var inst_31835 = (state_31846[(2)]);
var state_31846__$1 = state_31846;
if(cljs.core.truth_(inst_31835)){
var statearr_31855_31881 = state_31846__$1;
(statearr_31855_31881[(1)] = (12));

} else {
var statearr_31856_31882 = state_31846__$1;
(statearr_31856_31882[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31847 === (9))){
var state_31846__$1 = state_31846;
var statearr_31857_31883 = state_31846__$1;
(statearr_31857_31883[(2)] = null);

(statearr_31857_31883[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31847 === (5))){
var state_31846__$1 = state_31846;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31858_31884 = state_31846__$1;
(statearr_31858_31884[(1)] = (8));

} else {
var statearr_31859_31885 = state_31846__$1;
(statearr_31859_31885[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31847 === (14))){
var inst_31840 = (state_31846[(2)]);
var state_31846__$1 = state_31846;
var statearr_31860_31886 = state_31846__$1;
(statearr_31860_31886[(2)] = inst_31840);

(statearr_31860_31886[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31847 === (10))){
var inst_31832 = (state_31846[(2)]);
var state_31846__$1 = state_31846;
var statearr_31861_31887 = state_31846__$1;
(statearr_31861_31887[(2)] = inst_31832);

(statearr_31861_31887[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31847 === (8))){
var inst_31829 = cljs.core.async.close_BANG_(to);
var state_31846__$1 = state_31846;
var statearr_31862_31888 = state_31846__$1;
(statearr_31862_31888[(2)] = inst_31829);

(statearr_31862_31888[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto___31874))
;
return ((function (switch__18696__auto__,c__18808__auto___31874){
return (function() {
var cljs$core$async$state_machine__18697__auto__ = null;
var cljs$core$async$state_machine__18697__auto____0 = (function (){
var statearr_31866 = [null,null,null,null,null,null,null,null];
(statearr_31866[(0)] = cljs$core$async$state_machine__18697__auto__);

(statearr_31866[(1)] = (1));

return statearr_31866;
});
var cljs$core$async$state_machine__18697__auto____1 = (function (state_31846){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_31846);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e31867){if((e31867 instanceof Object)){
var ex__18700__auto__ = e31867;
var statearr_31868_31889 = state_31846;
(statearr_31868_31889[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31846);

return cljs.core.cst$kw$recur;
} else {
throw e31867;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__31890 = state_31846;
state_31846 = G__31890;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$state_machine__18697__auto__ = function(state_31846){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18697__auto____1.call(this,state_31846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18697__auto____0;
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18697__auto____1;
return cljs$core$async$state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___31874))
})();
var state__18810__auto__ = (function (){var statearr_31869 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_31869[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___31874);

return statearr_31869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___31874))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__32078){
var vec__32079 = p__32078;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32079,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32079,(1),null);
var job = vec__32079;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__18808__auto___32265 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___32265,res,vec__32079,v,p,job,jobs,results){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___32265,res,vec__32079,v,p,job,jobs,results){
return (function (state_32086){
var state_val_32087 = (state_32086[(1)]);
if((state_val_32087 === (1))){
var state_32086__$1 = state_32086;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32086__$1,(2),res,v);
} else {
if((state_val_32087 === (2))){
var inst_32083 = (state_32086[(2)]);
var inst_32084 = cljs.core.async.close_BANG_(res);
var state_32086__$1 = (function (){var statearr_32088 = state_32086;
(statearr_32088[(7)] = inst_32083);

return statearr_32088;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32086__$1,inst_32084);
} else {
return null;
}
}
});})(c__18808__auto___32265,res,vec__32079,v,p,job,jobs,results))
;
return ((function (switch__18696__auto__,c__18808__auto___32265,res,vec__32079,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0 = (function (){
var statearr_32092 = [null,null,null,null,null,null,null,null];
(statearr_32092[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__);

(statearr_32092[(1)] = (1));

return statearr_32092;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1 = (function (state_32086){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_32086);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e32093){if((e32093 instanceof Object)){
var ex__18700__auto__ = e32093;
var statearr_32094_32266 = state_32086;
(statearr_32094_32266[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32086);

return cljs.core.cst$kw$recur;
} else {
throw e32093;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__32267 = state_32086;
state_32086 = G__32267;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__ = function(state_32086){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1.call(this,state_32086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___32265,res,vec__32079,v,p,job,jobs,results))
})();
var state__18810__auto__ = (function (){var statearr_32095 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_32095[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___32265);

return statearr_32095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___32265,res,vec__32079,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__32096){
var vec__32097 = p__32096;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32097,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32097,(1),null);
var job = vec__32097;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7461__auto___32268 = n;
var __32269 = (0);
while(true){
if((__32269 < n__7461__auto___32268)){
var G__32100_32270 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__32100_32270) {
case "compute":
var c__18808__auto___32272 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32269,c__18808__auto___32272,G__32100_32270,n__7461__auto___32268,jobs,results,process,async){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (__32269,c__18808__auto___32272,G__32100_32270,n__7461__auto___32268,jobs,results,process,async){
return (function (state_32113){
var state_val_32114 = (state_32113[(1)]);
if((state_val_32114 === (1))){
var state_32113__$1 = state_32113;
var statearr_32115_32273 = state_32113__$1;
(statearr_32115_32273[(2)] = null);

(statearr_32115_32273[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32114 === (2))){
var state_32113__$1 = state_32113;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32113__$1,(4),jobs);
} else {
if((state_val_32114 === (3))){
var inst_32111 = (state_32113[(2)]);
var state_32113__$1 = state_32113;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32113__$1,inst_32111);
} else {
if((state_val_32114 === (4))){
var inst_32103 = (state_32113[(2)]);
var inst_32104 = process(inst_32103);
var state_32113__$1 = state_32113;
if(cljs.core.truth_(inst_32104)){
var statearr_32116_32274 = state_32113__$1;
(statearr_32116_32274[(1)] = (5));

} else {
var statearr_32117_32275 = state_32113__$1;
(statearr_32117_32275[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32114 === (5))){
var state_32113__$1 = state_32113;
var statearr_32118_32276 = state_32113__$1;
(statearr_32118_32276[(2)] = null);

(statearr_32118_32276[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32114 === (6))){
var state_32113__$1 = state_32113;
var statearr_32119_32277 = state_32113__$1;
(statearr_32119_32277[(2)] = null);

(statearr_32119_32277[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32114 === (7))){
var inst_32109 = (state_32113[(2)]);
var state_32113__$1 = state_32113;
var statearr_32120_32278 = state_32113__$1;
(statearr_32120_32278[(2)] = inst_32109);

(statearr_32120_32278[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__32269,c__18808__auto___32272,G__32100_32270,n__7461__auto___32268,jobs,results,process,async))
;
return ((function (__32269,switch__18696__auto__,c__18808__auto___32272,G__32100_32270,n__7461__auto___32268,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0 = (function (){
var statearr_32124 = [null,null,null,null,null,null,null];
(statearr_32124[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__);

(statearr_32124[(1)] = (1));

return statearr_32124;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1 = (function (state_32113){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_32113);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e32125){if((e32125 instanceof Object)){
var ex__18700__auto__ = e32125;
var statearr_32126_32279 = state_32113;
(statearr_32126_32279[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32113);

return cljs.core.cst$kw$recur;
} else {
throw e32125;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__32280 = state_32113;
state_32113 = G__32280;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__ = function(state_32113){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1.call(this,state_32113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__;
})()
;})(__32269,switch__18696__auto__,c__18808__auto___32272,G__32100_32270,n__7461__auto___32268,jobs,results,process,async))
})();
var state__18810__auto__ = (function (){var statearr_32127 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_32127[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___32272);

return statearr_32127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(__32269,c__18808__auto___32272,G__32100_32270,n__7461__auto___32268,jobs,results,process,async))
);


break;
case "async":
var c__18808__auto___32281 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32269,c__18808__auto___32281,G__32100_32270,n__7461__auto___32268,jobs,results,process,async){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (__32269,c__18808__auto___32281,G__32100_32270,n__7461__auto___32268,jobs,results,process,async){
return (function (state_32140){
var state_val_32141 = (state_32140[(1)]);
if((state_val_32141 === (1))){
var state_32140__$1 = state_32140;
var statearr_32142_32282 = state_32140__$1;
(statearr_32142_32282[(2)] = null);

(statearr_32142_32282[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32141 === (2))){
var state_32140__$1 = state_32140;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32140__$1,(4),jobs);
} else {
if((state_val_32141 === (3))){
var inst_32138 = (state_32140[(2)]);
var state_32140__$1 = state_32140;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32140__$1,inst_32138);
} else {
if((state_val_32141 === (4))){
var inst_32130 = (state_32140[(2)]);
var inst_32131 = async(inst_32130);
var state_32140__$1 = state_32140;
if(cljs.core.truth_(inst_32131)){
var statearr_32143_32283 = state_32140__$1;
(statearr_32143_32283[(1)] = (5));

} else {
var statearr_32144_32284 = state_32140__$1;
(statearr_32144_32284[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32141 === (5))){
var state_32140__$1 = state_32140;
var statearr_32145_32285 = state_32140__$1;
(statearr_32145_32285[(2)] = null);

(statearr_32145_32285[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32141 === (6))){
var state_32140__$1 = state_32140;
var statearr_32146_32286 = state_32140__$1;
(statearr_32146_32286[(2)] = null);

(statearr_32146_32286[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32141 === (7))){
var inst_32136 = (state_32140[(2)]);
var state_32140__$1 = state_32140;
var statearr_32147_32287 = state_32140__$1;
(statearr_32147_32287[(2)] = inst_32136);

(statearr_32147_32287[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__32269,c__18808__auto___32281,G__32100_32270,n__7461__auto___32268,jobs,results,process,async))
;
return ((function (__32269,switch__18696__auto__,c__18808__auto___32281,G__32100_32270,n__7461__auto___32268,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0 = (function (){
var statearr_32151 = [null,null,null,null,null,null,null];
(statearr_32151[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__);

(statearr_32151[(1)] = (1));

return statearr_32151;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1 = (function (state_32140){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_32140);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e32152){if((e32152 instanceof Object)){
var ex__18700__auto__ = e32152;
var statearr_32153_32288 = state_32140;
(statearr_32153_32288[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32140);

return cljs.core.cst$kw$recur;
} else {
throw e32152;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__32289 = state_32140;
state_32140 = G__32289;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__ = function(state_32140){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1.call(this,state_32140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__;
})()
;})(__32269,switch__18696__auto__,c__18808__auto___32281,G__32100_32270,n__7461__auto___32268,jobs,results,process,async))
})();
var state__18810__auto__ = (function (){var statearr_32154 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_32154[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___32281);

return statearr_32154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(__32269,c__18808__auto___32281,G__32100_32270,n__7461__auto___32268,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__32290 = (__32269 + (1));
__32269 = G__32290;
continue;
} else {
}
break;
}

var c__18808__auto___32291 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___32291,jobs,results,process,async){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___32291,jobs,results,process,async){
return (function (state_32176){
var state_val_32177 = (state_32176[(1)]);
if((state_val_32177 === (1))){
var state_32176__$1 = state_32176;
var statearr_32178_32292 = state_32176__$1;
(statearr_32178_32292[(2)] = null);

(statearr_32178_32292[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32177 === (2))){
var state_32176__$1 = state_32176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32176__$1,(4),from);
} else {
if((state_val_32177 === (3))){
var inst_32174 = (state_32176[(2)]);
var state_32176__$1 = state_32176;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32176__$1,inst_32174);
} else {
if((state_val_32177 === (4))){
var inst_32157 = (state_32176[(7)]);
var inst_32157__$1 = (state_32176[(2)]);
var inst_32158 = (inst_32157__$1 == null);
var state_32176__$1 = (function (){var statearr_32179 = state_32176;
(statearr_32179[(7)] = inst_32157__$1);

return statearr_32179;
})();
if(cljs.core.truth_(inst_32158)){
var statearr_32180_32293 = state_32176__$1;
(statearr_32180_32293[(1)] = (5));

} else {
var statearr_32181_32294 = state_32176__$1;
(statearr_32181_32294[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32177 === (5))){
var inst_32160 = cljs.core.async.close_BANG_(jobs);
var state_32176__$1 = state_32176;
var statearr_32182_32295 = state_32176__$1;
(statearr_32182_32295[(2)] = inst_32160);

(statearr_32182_32295[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32177 === (6))){
var inst_32157 = (state_32176[(7)]);
var inst_32162 = (state_32176[(8)]);
var inst_32162__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_32163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32164 = [inst_32157,inst_32162__$1];
var inst_32165 = (new cljs.core.PersistentVector(null,2,(5),inst_32163,inst_32164,null));
var state_32176__$1 = (function (){var statearr_32183 = state_32176;
(statearr_32183[(8)] = inst_32162__$1);

return statearr_32183;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32176__$1,(8),jobs,inst_32165);
} else {
if((state_val_32177 === (7))){
var inst_32172 = (state_32176[(2)]);
var state_32176__$1 = state_32176;
var statearr_32184_32296 = state_32176__$1;
(statearr_32184_32296[(2)] = inst_32172);

(statearr_32184_32296[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32177 === (8))){
var inst_32162 = (state_32176[(8)]);
var inst_32167 = (state_32176[(2)]);
var state_32176__$1 = (function (){var statearr_32185 = state_32176;
(statearr_32185[(9)] = inst_32167);

return statearr_32185;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32176__$1,(9),results,inst_32162);
} else {
if((state_val_32177 === (9))){
var inst_32169 = (state_32176[(2)]);
var state_32176__$1 = (function (){var statearr_32186 = state_32176;
(statearr_32186[(10)] = inst_32169);

return statearr_32186;
})();
var statearr_32187_32297 = state_32176__$1;
(statearr_32187_32297[(2)] = null);

(statearr_32187_32297[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__18808__auto___32291,jobs,results,process,async))
;
return ((function (switch__18696__auto__,c__18808__auto___32291,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0 = (function (){
var statearr_32191 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32191[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__);

(statearr_32191[(1)] = (1));

return statearr_32191;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1 = (function (state_32176){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_32176);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e32192){if((e32192 instanceof Object)){
var ex__18700__auto__ = e32192;
var statearr_32193_32298 = state_32176;
(statearr_32193_32298[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32176);

return cljs.core.cst$kw$recur;
} else {
throw e32192;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__32299 = state_32176;
state_32176 = G__32299;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__ = function(state_32176){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1.call(this,state_32176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___32291,jobs,results,process,async))
})();
var state__18810__auto__ = (function (){var statearr_32194 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_32194[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___32291);

return statearr_32194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___32291,jobs,results,process,async))
);


var c__18808__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto__,jobs,results,process,async){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto__,jobs,results,process,async){
return (function (state_32232){
var state_val_32233 = (state_32232[(1)]);
if((state_val_32233 === (7))){
var inst_32228 = (state_32232[(2)]);
var state_32232__$1 = state_32232;
var statearr_32234_32300 = state_32232__$1;
(statearr_32234_32300[(2)] = inst_32228);

(statearr_32234_32300[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (20))){
var state_32232__$1 = state_32232;
var statearr_32235_32301 = state_32232__$1;
(statearr_32235_32301[(2)] = null);

(statearr_32235_32301[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (1))){
var state_32232__$1 = state_32232;
var statearr_32236_32302 = state_32232__$1;
(statearr_32236_32302[(2)] = null);

(statearr_32236_32302[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (4))){
var inst_32197 = (state_32232[(7)]);
var inst_32197__$1 = (state_32232[(2)]);
var inst_32198 = (inst_32197__$1 == null);
var state_32232__$1 = (function (){var statearr_32237 = state_32232;
(statearr_32237[(7)] = inst_32197__$1);

return statearr_32237;
})();
if(cljs.core.truth_(inst_32198)){
var statearr_32238_32303 = state_32232__$1;
(statearr_32238_32303[(1)] = (5));

} else {
var statearr_32239_32304 = state_32232__$1;
(statearr_32239_32304[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (15))){
var inst_32210 = (state_32232[(8)]);
var state_32232__$1 = state_32232;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32232__$1,(18),to,inst_32210);
} else {
if((state_val_32233 === (21))){
var inst_32223 = (state_32232[(2)]);
var state_32232__$1 = state_32232;
var statearr_32240_32305 = state_32232__$1;
(statearr_32240_32305[(2)] = inst_32223);

(statearr_32240_32305[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (13))){
var inst_32225 = (state_32232[(2)]);
var state_32232__$1 = (function (){var statearr_32241 = state_32232;
(statearr_32241[(9)] = inst_32225);

return statearr_32241;
})();
var statearr_32242_32306 = state_32232__$1;
(statearr_32242_32306[(2)] = null);

(statearr_32242_32306[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (6))){
var inst_32197 = (state_32232[(7)]);
var state_32232__$1 = state_32232;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32232__$1,(11),inst_32197);
} else {
if((state_val_32233 === (17))){
var inst_32218 = (state_32232[(2)]);
var state_32232__$1 = state_32232;
if(cljs.core.truth_(inst_32218)){
var statearr_32243_32307 = state_32232__$1;
(statearr_32243_32307[(1)] = (19));

} else {
var statearr_32244_32308 = state_32232__$1;
(statearr_32244_32308[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (3))){
var inst_32230 = (state_32232[(2)]);
var state_32232__$1 = state_32232;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32232__$1,inst_32230);
} else {
if((state_val_32233 === (12))){
var inst_32207 = (state_32232[(10)]);
var state_32232__$1 = state_32232;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32232__$1,(14),inst_32207);
} else {
if((state_val_32233 === (2))){
var state_32232__$1 = state_32232;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32232__$1,(4),results);
} else {
if((state_val_32233 === (19))){
var state_32232__$1 = state_32232;
var statearr_32245_32309 = state_32232__$1;
(statearr_32245_32309[(2)] = null);

(statearr_32245_32309[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (11))){
var inst_32207 = (state_32232[(2)]);
var state_32232__$1 = (function (){var statearr_32246 = state_32232;
(statearr_32246[(10)] = inst_32207);

return statearr_32246;
})();
var statearr_32247_32310 = state_32232__$1;
(statearr_32247_32310[(2)] = null);

(statearr_32247_32310[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (9))){
var state_32232__$1 = state_32232;
var statearr_32248_32311 = state_32232__$1;
(statearr_32248_32311[(2)] = null);

(statearr_32248_32311[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (5))){
var state_32232__$1 = state_32232;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32249_32312 = state_32232__$1;
(statearr_32249_32312[(1)] = (8));

} else {
var statearr_32250_32313 = state_32232__$1;
(statearr_32250_32313[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (14))){
var inst_32212 = (state_32232[(11)]);
var inst_32210 = (state_32232[(8)]);
var inst_32210__$1 = (state_32232[(2)]);
var inst_32211 = (inst_32210__$1 == null);
var inst_32212__$1 = cljs.core.not(inst_32211);
var state_32232__$1 = (function (){var statearr_32251 = state_32232;
(statearr_32251[(11)] = inst_32212__$1);

(statearr_32251[(8)] = inst_32210__$1);

return statearr_32251;
})();
if(inst_32212__$1){
var statearr_32252_32314 = state_32232__$1;
(statearr_32252_32314[(1)] = (15));

} else {
var statearr_32253_32315 = state_32232__$1;
(statearr_32253_32315[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (16))){
var inst_32212 = (state_32232[(11)]);
var state_32232__$1 = state_32232;
var statearr_32254_32316 = state_32232__$1;
(statearr_32254_32316[(2)] = inst_32212);

(statearr_32254_32316[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (10))){
var inst_32204 = (state_32232[(2)]);
var state_32232__$1 = state_32232;
var statearr_32255_32317 = state_32232__$1;
(statearr_32255_32317[(2)] = inst_32204);

(statearr_32255_32317[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (18))){
var inst_32215 = (state_32232[(2)]);
var state_32232__$1 = state_32232;
var statearr_32256_32318 = state_32232__$1;
(statearr_32256_32318[(2)] = inst_32215);

(statearr_32256_32318[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32233 === (8))){
var inst_32201 = cljs.core.async.close_BANG_(to);
var state_32232__$1 = state_32232;
var statearr_32257_32319 = state_32232__$1;
(statearr_32257_32319[(2)] = inst_32201);

(statearr_32257_32319[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto__,jobs,results,process,async))
;
return ((function (switch__18696__auto__,c__18808__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0 = (function (){
var statearr_32261 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32261[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__);

(statearr_32261[(1)] = (1));

return statearr_32261;
});
var cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1 = (function (state_32232){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_32232);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e32262){if((e32262 instanceof Object)){
var ex__18700__auto__ = e32262;
var statearr_32263_32320 = state_32232;
(statearr_32263_32320[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32232);

return cljs.core.cst$kw$recur;
} else {
throw e32262;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__32321 = state_32232;
state_32232 = G__32321;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__ = function(state_32232){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1.call(this,state_32232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__18697__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto__,jobs,results,process,async))
})();
var state__18810__auto__ = (function (){var statearr_32264 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_32264[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto__);

return statearr_32264;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto__,jobs,results,process,async))
);

return c__18808__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args32322 = [];
var len__7651__auto___32325 = arguments.length;
var i__7652__auto___32326 = (0);
while(true){
if((i__7652__auto___32326 < len__7651__auto___32325)){
args32322.push((arguments[i__7652__auto___32326]));

var G__32327 = (i__7652__auto___32326 + (1));
i__7652__auto___32326 = G__32327;
continue;
} else {
}
break;
}

var G__32324 = args32322.length;
switch (G__32324) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32322.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args32329 = [];
var len__7651__auto___32332 = arguments.length;
var i__7652__auto___32333 = (0);
while(true){
if((i__7652__auto___32333 < len__7651__auto___32332)){
args32329.push((arguments[i__7652__auto___32333]));

var G__32334 = (i__7652__auto___32333 + (1));
i__7652__auto___32333 = G__32334;
continue;
} else {
}
break;
}

var G__32331 = args32329.length;
switch (G__32331) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32329.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args32336 = [];
var len__7651__auto___32389 = arguments.length;
var i__7652__auto___32390 = (0);
while(true){
if((i__7652__auto___32390 < len__7651__auto___32389)){
args32336.push((arguments[i__7652__auto___32390]));

var G__32391 = (i__7652__auto___32390 + (1));
i__7652__auto___32390 = G__32391;
continue;
} else {
}
break;
}

var G__32338 = args32336.length;
switch (G__32338) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32336.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__18808__auto___32393 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___32393,tc,fc){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___32393,tc,fc){
return (function (state_32364){
var state_val_32365 = (state_32364[(1)]);
if((state_val_32365 === (7))){
var inst_32360 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32366_32394 = state_32364__$1;
(statearr_32366_32394[(2)] = inst_32360);

(statearr_32366_32394[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (1))){
var state_32364__$1 = state_32364;
var statearr_32367_32395 = state_32364__$1;
(statearr_32367_32395[(2)] = null);

(statearr_32367_32395[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (4))){
var inst_32341 = (state_32364[(7)]);
var inst_32341__$1 = (state_32364[(2)]);
var inst_32342 = (inst_32341__$1 == null);
var state_32364__$1 = (function (){var statearr_32368 = state_32364;
(statearr_32368[(7)] = inst_32341__$1);

return statearr_32368;
})();
if(cljs.core.truth_(inst_32342)){
var statearr_32369_32396 = state_32364__$1;
(statearr_32369_32396[(1)] = (5));

} else {
var statearr_32370_32397 = state_32364__$1;
(statearr_32370_32397[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (13))){
var state_32364__$1 = state_32364;
var statearr_32371_32398 = state_32364__$1;
(statearr_32371_32398[(2)] = null);

(statearr_32371_32398[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (6))){
var inst_32341 = (state_32364[(7)]);
var inst_32347 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_32341) : p.call(null,inst_32341));
var state_32364__$1 = state_32364;
if(cljs.core.truth_(inst_32347)){
var statearr_32372_32399 = state_32364__$1;
(statearr_32372_32399[(1)] = (9));

} else {
var statearr_32373_32400 = state_32364__$1;
(statearr_32373_32400[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (3))){
var inst_32362 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32364__$1,inst_32362);
} else {
if((state_val_32365 === (12))){
var state_32364__$1 = state_32364;
var statearr_32374_32401 = state_32364__$1;
(statearr_32374_32401[(2)] = null);

(statearr_32374_32401[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (2))){
var state_32364__$1 = state_32364;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32364__$1,(4),ch);
} else {
if((state_val_32365 === (11))){
var inst_32341 = (state_32364[(7)]);
var inst_32351 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32364__$1,(8),inst_32351,inst_32341);
} else {
if((state_val_32365 === (9))){
var state_32364__$1 = state_32364;
var statearr_32375_32402 = state_32364__$1;
(statearr_32375_32402[(2)] = tc);

(statearr_32375_32402[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (5))){
var inst_32344 = cljs.core.async.close_BANG_(tc);
var inst_32345 = cljs.core.async.close_BANG_(fc);
var state_32364__$1 = (function (){var statearr_32376 = state_32364;
(statearr_32376[(8)] = inst_32344);

return statearr_32376;
})();
var statearr_32377_32403 = state_32364__$1;
(statearr_32377_32403[(2)] = inst_32345);

(statearr_32377_32403[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (14))){
var inst_32358 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
var statearr_32378_32404 = state_32364__$1;
(statearr_32378_32404[(2)] = inst_32358);

(statearr_32378_32404[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (10))){
var state_32364__$1 = state_32364;
var statearr_32379_32405 = state_32364__$1;
(statearr_32379_32405[(2)] = fc);

(statearr_32379_32405[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32365 === (8))){
var inst_32353 = (state_32364[(2)]);
var state_32364__$1 = state_32364;
if(cljs.core.truth_(inst_32353)){
var statearr_32380_32406 = state_32364__$1;
(statearr_32380_32406[(1)] = (12));

} else {
var statearr_32381_32407 = state_32364__$1;
(statearr_32381_32407[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto___32393,tc,fc))
;
return ((function (switch__18696__auto__,c__18808__auto___32393,tc,fc){
return (function() {
var cljs$core$async$state_machine__18697__auto__ = null;
var cljs$core$async$state_machine__18697__auto____0 = (function (){
var statearr_32385 = [null,null,null,null,null,null,null,null,null];
(statearr_32385[(0)] = cljs$core$async$state_machine__18697__auto__);

(statearr_32385[(1)] = (1));

return statearr_32385;
});
var cljs$core$async$state_machine__18697__auto____1 = (function (state_32364){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_32364);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e32386){if((e32386 instanceof Object)){
var ex__18700__auto__ = e32386;
var statearr_32387_32408 = state_32364;
(statearr_32387_32408[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32364);

return cljs.core.cst$kw$recur;
} else {
throw e32386;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__32409 = state_32364;
state_32364 = G__32409;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$state_machine__18697__auto__ = function(state_32364){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18697__auto____1.call(this,state_32364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18697__auto____0;
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18697__auto____1;
return cljs$core$async$state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___32393,tc,fc))
})();
var state__18810__auto__ = (function (){var statearr_32388 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_32388[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___32393);

return statearr_32388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___32393,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__18808__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto__){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto__){
return (function (state_32473){
var state_val_32474 = (state_32473[(1)]);
if((state_val_32474 === (7))){
var inst_32469 = (state_32473[(2)]);
var state_32473__$1 = state_32473;
var statearr_32475_32496 = state_32473__$1;
(statearr_32475_32496[(2)] = inst_32469);

(statearr_32475_32496[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32474 === (1))){
var inst_32453 = init;
var state_32473__$1 = (function (){var statearr_32476 = state_32473;
(statearr_32476[(7)] = inst_32453);

return statearr_32476;
})();
var statearr_32477_32497 = state_32473__$1;
(statearr_32477_32497[(2)] = null);

(statearr_32477_32497[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32474 === (4))){
var inst_32456 = (state_32473[(8)]);
var inst_32456__$1 = (state_32473[(2)]);
var inst_32457 = (inst_32456__$1 == null);
var state_32473__$1 = (function (){var statearr_32478 = state_32473;
(statearr_32478[(8)] = inst_32456__$1);

return statearr_32478;
})();
if(cljs.core.truth_(inst_32457)){
var statearr_32479_32498 = state_32473__$1;
(statearr_32479_32498[(1)] = (5));

} else {
var statearr_32480_32499 = state_32473__$1;
(statearr_32480_32499[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32474 === (6))){
var inst_32460 = (state_32473[(9)]);
var inst_32453 = (state_32473[(7)]);
var inst_32456 = (state_32473[(8)]);
var inst_32460__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_32453,inst_32456) : f.call(null,inst_32453,inst_32456));
var inst_32461 = cljs.core.reduced_QMARK_(inst_32460__$1);
var state_32473__$1 = (function (){var statearr_32481 = state_32473;
(statearr_32481[(9)] = inst_32460__$1);

return statearr_32481;
})();
if(inst_32461){
var statearr_32482_32500 = state_32473__$1;
(statearr_32482_32500[(1)] = (8));

} else {
var statearr_32483_32501 = state_32473__$1;
(statearr_32483_32501[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32474 === (3))){
var inst_32471 = (state_32473[(2)]);
var state_32473__$1 = state_32473;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32473__$1,inst_32471);
} else {
if((state_val_32474 === (2))){
var state_32473__$1 = state_32473;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32473__$1,(4),ch);
} else {
if((state_val_32474 === (9))){
var inst_32460 = (state_32473[(9)]);
var inst_32453 = inst_32460;
var state_32473__$1 = (function (){var statearr_32484 = state_32473;
(statearr_32484[(7)] = inst_32453);

return statearr_32484;
})();
var statearr_32485_32502 = state_32473__$1;
(statearr_32485_32502[(2)] = null);

(statearr_32485_32502[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32474 === (5))){
var inst_32453 = (state_32473[(7)]);
var state_32473__$1 = state_32473;
var statearr_32486_32503 = state_32473__$1;
(statearr_32486_32503[(2)] = inst_32453);

(statearr_32486_32503[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32474 === (10))){
var inst_32467 = (state_32473[(2)]);
var state_32473__$1 = state_32473;
var statearr_32487_32504 = state_32473__$1;
(statearr_32487_32504[(2)] = inst_32467);

(statearr_32487_32504[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32474 === (8))){
var inst_32460 = (state_32473[(9)]);
var inst_32463 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_32460) : cljs.core.deref.call(null,inst_32460));
var state_32473__$1 = state_32473;
var statearr_32488_32505 = state_32473__$1;
(statearr_32488_32505[(2)] = inst_32463);

(statearr_32488_32505[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto__))
;
return ((function (switch__18696__auto__,c__18808__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__18697__auto__ = null;
var cljs$core$async$reduce_$_state_machine__18697__auto____0 = (function (){
var statearr_32492 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32492[(0)] = cljs$core$async$reduce_$_state_machine__18697__auto__);

(statearr_32492[(1)] = (1));

return statearr_32492;
});
var cljs$core$async$reduce_$_state_machine__18697__auto____1 = (function (state_32473){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_32473);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e32493){if((e32493 instanceof Object)){
var ex__18700__auto__ = e32493;
var statearr_32494_32506 = state_32473;
(statearr_32494_32506[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32473);

return cljs.core.cst$kw$recur;
} else {
throw e32493;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__32507 = state_32473;
state_32473 = G__32507;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__18697__auto__ = function(state_32473){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__18697__auto____1.call(this,state_32473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__18697__auto____0;
cljs$core$async$reduce_$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__18697__auto____1;
return cljs$core$async$reduce_$_state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto__))
})();
var state__18810__auto__ = (function (){var statearr_32495 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_32495[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto__);

return statearr_32495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto__))
);

return c__18808__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__18808__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto__,f__$1){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto__,f__$1){
return (function (state_32527){
var state_val_32528 = (state_32527[(1)]);
if((state_val_32528 === (1))){
var inst_32522 = cljs.core.async.reduce(f__$1,init,ch);
var state_32527__$1 = state_32527;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32527__$1,(2),inst_32522);
} else {
if((state_val_32528 === (2))){
var inst_32524 = (state_32527[(2)]);
var inst_32525 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_32524) : f__$1.call(null,inst_32524));
var state_32527__$1 = state_32527;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32527__$1,inst_32525);
} else {
return null;
}
}
});})(c__18808__auto__,f__$1))
;
return ((function (switch__18696__auto__,c__18808__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__18697__auto__ = null;
var cljs$core$async$transduce_$_state_machine__18697__auto____0 = (function (){
var statearr_32532 = [null,null,null,null,null,null,null];
(statearr_32532[(0)] = cljs$core$async$transduce_$_state_machine__18697__auto__);

(statearr_32532[(1)] = (1));

return statearr_32532;
});
var cljs$core$async$transduce_$_state_machine__18697__auto____1 = (function (state_32527){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_32527);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e32533){if((e32533 instanceof Object)){
var ex__18700__auto__ = e32533;
var statearr_32534_32536 = state_32527;
(statearr_32534_32536[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32527);

return cljs.core.cst$kw$recur;
} else {
throw e32533;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__32537 = state_32527;
state_32527 = G__32537;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__18697__auto__ = function(state_32527){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__18697__auto____1.call(this,state_32527);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__18697__auto____0;
cljs$core$async$transduce_$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__18697__auto____1;
return cljs$core$async$transduce_$_state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto__,f__$1))
})();
var state__18810__auto__ = (function (){var statearr_32535 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_32535[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto__);

return statearr_32535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto__,f__$1))
);

return c__18808__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args32538 = [];
var len__7651__auto___32590 = arguments.length;
var i__7652__auto___32591 = (0);
while(true){
if((i__7652__auto___32591 < len__7651__auto___32590)){
args32538.push((arguments[i__7652__auto___32591]));

var G__32592 = (i__7652__auto___32591 + (1));
i__7652__auto___32591 = G__32592;
continue;
} else {
}
break;
}

var G__32540 = args32538.length;
switch (G__32540) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32538.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__18808__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto__){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto__){
return (function (state_32565){
var state_val_32566 = (state_32565[(1)]);
if((state_val_32566 === (7))){
var inst_32547 = (state_32565[(2)]);
var state_32565__$1 = state_32565;
var statearr_32567_32594 = state_32565__$1;
(statearr_32567_32594[(2)] = inst_32547);

(statearr_32567_32594[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32566 === (1))){
var inst_32541 = cljs.core.seq(coll);
var inst_32542 = inst_32541;
var state_32565__$1 = (function (){var statearr_32568 = state_32565;
(statearr_32568[(7)] = inst_32542);

return statearr_32568;
})();
var statearr_32569_32595 = state_32565__$1;
(statearr_32569_32595[(2)] = null);

(statearr_32569_32595[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32566 === (4))){
var inst_32542 = (state_32565[(7)]);
var inst_32545 = cljs.core.first(inst_32542);
var state_32565__$1 = state_32565;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32565__$1,(7),ch,inst_32545);
} else {
if((state_val_32566 === (13))){
var inst_32559 = (state_32565[(2)]);
var state_32565__$1 = state_32565;
var statearr_32570_32596 = state_32565__$1;
(statearr_32570_32596[(2)] = inst_32559);

(statearr_32570_32596[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32566 === (6))){
var inst_32550 = (state_32565[(2)]);
var state_32565__$1 = state_32565;
if(cljs.core.truth_(inst_32550)){
var statearr_32571_32597 = state_32565__$1;
(statearr_32571_32597[(1)] = (8));

} else {
var statearr_32572_32598 = state_32565__$1;
(statearr_32572_32598[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32566 === (3))){
var inst_32563 = (state_32565[(2)]);
var state_32565__$1 = state_32565;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32565__$1,inst_32563);
} else {
if((state_val_32566 === (12))){
var state_32565__$1 = state_32565;
var statearr_32573_32599 = state_32565__$1;
(statearr_32573_32599[(2)] = null);

(statearr_32573_32599[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32566 === (2))){
var inst_32542 = (state_32565[(7)]);
var state_32565__$1 = state_32565;
if(cljs.core.truth_(inst_32542)){
var statearr_32574_32600 = state_32565__$1;
(statearr_32574_32600[(1)] = (4));

} else {
var statearr_32575_32601 = state_32565__$1;
(statearr_32575_32601[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32566 === (11))){
var inst_32556 = cljs.core.async.close_BANG_(ch);
var state_32565__$1 = state_32565;
var statearr_32576_32602 = state_32565__$1;
(statearr_32576_32602[(2)] = inst_32556);

(statearr_32576_32602[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32566 === (9))){
var state_32565__$1 = state_32565;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32577_32603 = state_32565__$1;
(statearr_32577_32603[(1)] = (11));

} else {
var statearr_32578_32604 = state_32565__$1;
(statearr_32578_32604[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32566 === (5))){
var inst_32542 = (state_32565[(7)]);
var state_32565__$1 = state_32565;
var statearr_32579_32605 = state_32565__$1;
(statearr_32579_32605[(2)] = inst_32542);

(statearr_32579_32605[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32566 === (10))){
var inst_32561 = (state_32565[(2)]);
var state_32565__$1 = state_32565;
var statearr_32580_32606 = state_32565__$1;
(statearr_32580_32606[(2)] = inst_32561);

(statearr_32580_32606[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32566 === (8))){
var inst_32542 = (state_32565[(7)]);
var inst_32552 = cljs.core.next(inst_32542);
var inst_32542__$1 = inst_32552;
var state_32565__$1 = (function (){var statearr_32581 = state_32565;
(statearr_32581[(7)] = inst_32542__$1);

return statearr_32581;
})();
var statearr_32582_32607 = state_32565__$1;
(statearr_32582_32607[(2)] = null);

(statearr_32582_32607[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto__))
;
return ((function (switch__18696__auto__,c__18808__auto__){
return (function() {
var cljs$core$async$state_machine__18697__auto__ = null;
var cljs$core$async$state_machine__18697__auto____0 = (function (){
var statearr_32586 = [null,null,null,null,null,null,null,null];
(statearr_32586[(0)] = cljs$core$async$state_machine__18697__auto__);

(statearr_32586[(1)] = (1));

return statearr_32586;
});
var cljs$core$async$state_machine__18697__auto____1 = (function (state_32565){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_32565);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e32587){if((e32587 instanceof Object)){
var ex__18700__auto__ = e32587;
var statearr_32588_32608 = state_32565;
(statearr_32588_32608[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32565);

return cljs.core.cst$kw$recur;
} else {
throw e32587;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__32609 = state_32565;
state_32565 = G__32609;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$state_machine__18697__auto__ = function(state_32565){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18697__auto____1.call(this,state_32565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18697__auto____0;
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18697__auto____1;
return cljs$core$async$state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto__))
})();
var state__18810__auto__ = (function (){var statearr_32589 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_32589[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto__);

return statearr_32589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto__))
);

return c__18808__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7206__auto__ = (((_ == null))?null:_);
var m__7207__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7207__auto__.call(null,_));
} else {
var m__7207__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7207__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7207__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7207__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto__.call(null,m));
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__32838 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32838) : cljs.core.atom.call(null,G__32838));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32839 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32839 = (function (ch,cs,meta32840){
this.ch = ch;
this.cs = cs;
this.meta32840 = meta32840;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32839.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32841,meta32840__$1){
var self__ = this;
var _32841__$1 = this;
return (new cljs.core.async.t_cljs$core$async32839(self__.ch,self__.cs,meta32840__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async32839.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32841){
var self__ = this;
var _32841__$1 = this;
return self__.meta32840;
});})(cs))
;

cljs.core.async.t_cljs$core$async32839.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32839.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async32839.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32839.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32839.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32839.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32842_33066 = self__.cs;
var G__32843_33067 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32842_33066,G__32843_33067) : cljs.core.reset_BANG_.call(null,G__32842_33066,G__32843_33067));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32839.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta32840], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async32839.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32839.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32839";

cljs.core.async.t_cljs$core$async32839.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async32839");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async32839 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async32839(ch__$1,cs__$1,meta32840){
return (new cljs.core.async.t_cljs$core$async32839(ch__$1,cs__$1,meta32840));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async32839(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__18808__auto___33068 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___33068,cs,m,dchan,dctr,done){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___33068,cs,m,dchan,dctr,done){
return (function (state_32978){
var state_val_32979 = (state_32978[(1)]);
if((state_val_32979 === (7))){
var inst_32974 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
var statearr_32980_33069 = state_32978__$1;
(statearr_32980_33069[(2)] = inst_32974);

(statearr_32980_33069[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (20))){
var inst_32877 = (state_32978[(7)]);
var inst_32889 = cljs.core.first(inst_32877);
var inst_32890 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32889,(0),null);
var inst_32891 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32889,(1),null);
var state_32978__$1 = (function (){var statearr_32981 = state_32978;
(statearr_32981[(8)] = inst_32890);

return statearr_32981;
})();
if(cljs.core.truth_(inst_32891)){
var statearr_32982_33070 = state_32978__$1;
(statearr_32982_33070[(1)] = (22));

} else {
var statearr_32983_33071 = state_32978__$1;
(statearr_32983_33071[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (27))){
var inst_32921 = (state_32978[(9)]);
var inst_32846 = (state_32978[(10)]);
var inst_32919 = (state_32978[(11)]);
var inst_32926 = (state_32978[(12)]);
var inst_32926__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32919,inst_32921);
var inst_32927 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32926__$1,inst_32846,done);
var state_32978__$1 = (function (){var statearr_32984 = state_32978;
(statearr_32984[(12)] = inst_32926__$1);

return statearr_32984;
})();
if(cljs.core.truth_(inst_32927)){
var statearr_32985_33072 = state_32978__$1;
(statearr_32985_33072[(1)] = (30));

} else {
var statearr_32986_33073 = state_32978__$1;
(statearr_32986_33073[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (1))){
var state_32978__$1 = state_32978;
var statearr_32987_33074 = state_32978__$1;
(statearr_32987_33074[(2)] = null);

(statearr_32987_33074[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (24))){
var inst_32877 = (state_32978[(7)]);
var inst_32896 = (state_32978[(2)]);
var inst_32897 = cljs.core.next(inst_32877);
var inst_32855 = inst_32897;
var inst_32856 = null;
var inst_32857 = (0);
var inst_32858 = (0);
var state_32978__$1 = (function (){var statearr_32988 = state_32978;
(statearr_32988[(13)] = inst_32857);

(statearr_32988[(14)] = inst_32856);

(statearr_32988[(15)] = inst_32858);

(statearr_32988[(16)] = inst_32855);

(statearr_32988[(17)] = inst_32896);

return statearr_32988;
})();
var statearr_32989_33075 = state_32978__$1;
(statearr_32989_33075[(2)] = null);

(statearr_32989_33075[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (39))){
var state_32978__$1 = state_32978;
var statearr_32993_33076 = state_32978__$1;
(statearr_32993_33076[(2)] = null);

(statearr_32993_33076[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (4))){
var inst_32846 = (state_32978[(10)]);
var inst_32846__$1 = (state_32978[(2)]);
var inst_32847 = (inst_32846__$1 == null);
var state_32978__$1 = (function (){var statearr_32994 = state_32978;
(statearr_32994[(10)] = inst_32846__$1);

return statearr_32994;
})();
if(cljs.core.truth_(inst_32847)){
var statearr_32995_33077 = state_32978__$1;
(statearr_32995_33077[(1)] = (5));

} else {
var statearr_32996_33078 = state_32978__$1;
(statearr_32996_33078[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (15))){
var inst_32857 = (state_32978[(13)]);
var inst_32856 = (state_32978[(14)]);
var inst_32858 = (state_32978[(15)]);
var inst_32855 = (state_32978[(16)]);
var inst_32873 = (state_32978[(2)]);
var inst_32874 = (inst_32858 + (1));
var tmp32990 = inst_32857;
var tmp32991 = inst_32856;
var tmp32992 = inst_32855;
var inst_32855__$1 = tmp32992;
var inst_32856__$1 = tmp32991;
var inst_32857__$1 = tmp32990;
var inst_32858__$1 = inst_32874;
var state_32978__$1 = (function (){var statearr_32997 = state_32978;
(statearr_32997[(13)] = inst_32857__$1);

(statearr_32997[(14)] = inst_32856__$1);

(statearr_32997[(15)] = inst_32858__$1);

(statearr_32997[(18)] = inst_32873);

(statearr_32997[(16)] = inst_32855__$1);

return statearr_32997;
})();
var statearr_32998_33079 = state_32978__$1;
(statearr_32998_33079[(2)] = null);

(statearr_32998_33079[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (21))){
var inst_32900 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
var statearr_33002_33080 = state_32978__$1;
(statearr_33002_33080[(2)] = inst_32900);

(statearr_33002_33080[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (31))){
var inst_32926 = (state_32978[(12)]);
var inst_32930 = done(null);
var inst_32931 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32926);
var state_32978__$1 = (function (){var statearr_33003 = state_32978;
(statearr_33003[(19)] = inst_32930);

return statearr_33003;
})();
var statearr_33004_33081 = state_32978__$1;
(statearr_33004_33081[(2)] = inst_32931);

(statearr_33004_33081[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (32))){
var inst_32921 = (state_32978[(9)]);
var inst_32918 = (state_32978[(20)]);
var inst_32919 = (state_32978[(11)]);
var inst_32920 = (state_32978[(21)]);
var inst_32933 = (state_32978[(2)]);
var inst_32934 = (inst_32921 + (1));
var tmp32999 = inst_32918;
var tmp33000 = inst_32919;
var tmp33001 = inst_32920;
var inst_32918__$1 = tmp32999;
var inst_32919__$1 = tmp33000;
var inst_32920__$1 = tmp33001;
var inst_32921__$1 = inst_32934;
var state_32978__$1 = (function (){var statearr_33005 = state_32978;
(statearr_33005[(9)] = inst_32921__$1);

(statearr_33005[(20)] = inst_32918__$1);

(statearr_33005[(11)] = inst_32919__$1);

(statearr_33005[(21)] = inst_32920__$1);

(statearr_33005[(22)] = inst_32933);

return statearr_33005;
})();
var statearr_33006_33082 = state_32978__$1;
(statearr_33006_33082[(2)] = null);

(statearr_33006_33082[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (40))){
var inst_32946 = (state_32978[(23)]);
var inst_32950 = done(null);
var inst_32951 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32946);
var state_32978__$1 = (function (){var statearr_33007 = state_32978;
(statearr_33007[(24)] = inst_32950);

return statearr_33007;
})();
var statearr_33008_33083 = state_32978__$1;
(statearr_33008_33083[(2)] = inst_32951);

(statearr_33008_33083[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (33))){
var inst_32937 = (state_32978[(25)]);
var inst_32939 = cljs.core.chunked_seq_QMARK_(inst_32937);
var state_32978__$1 = state_32978;
if(inst_32939){
var statearr_33009_33084 = state_32978__$1;
(statearr_33009_33084[(1)] = (36));

} else {
var statearr_33010_33085 = state_32978__$1;
(statearr_33010_33085[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (13))){
var inst_32867 = (state_32978[(26)]);
var inst_32870 = cljs.core.async.close_BANG_(inst_32867);
var state_32978__$1 = state_32978;
var statearr_33011_33086 = state_32978__$1;
(statearr_33011_33086[(2)] = inst_32870);

(statearr_33011_33086[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (22))){
var inst_32890 = (state_32978[(8)]);
var inst_32893 = cljs.core.async.close_BANG_(inst_32890);
var state_32978__$1 = state_32978;
var statearr_33012_33087 = state_32978__$1;
(statearr_33012_33087[(2)] = inst_32893);

(statearr_33012_33087[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (36))){
var inst_32937 = (state_32978[(25)]);
var inst_32941 = cljs.core.chunk_first(inst_32937);
var inst_32942 = cljs.core.chunk_rest(inst_32937);
var inst_32943 = cljs.core.count(inst_32941);
var inst_32918 = inst_32942;
var inst_32919 = inst_32941;
var inst_32920 = inst_32943;
var inst_32921 = (0);
var state_32978__$1 = (function (){var statearr_33013 = state_32978;
(statearr_33013[(9)] = inst_32921);

(statearr_33013[(20)] = inst_32918);

(statearr_33013[(11)] = inst_32919);

(statearr_33013[(21)] = inst_32920);

return statearr_33013;
})();
var statearr_33014_33088 = state_32978__$1;
(statearr_33014_33088[(2)] = null);

(statearr_33014_33088[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (41))){
var inst_32937 = (state_32978[(25)]);
var inst_32953 = (state_32978[(2)]);
var inst_32954 = cljs.core.next(inst_32937);
var inst_32918 = inst_32954;
var inst_32919 = null;
var inst_32920 = (0);
var inst_32921 = (0);
var state_32978__$1 = (function (){var statearr_33015 = state_32978;
(statearr_33015[(9)] = inst_32921);

(statearr_33015[(20)] = inst_32918);

(statearr_33015[(11)] = inst_32919);

(statearr_33015[(27)] = inst_32953);

(statearr_33015[(21)] = inst_32920);

return statearr_33015;
})();
var statearr_33016_33089 = state_32978__$1;
(statearr_33016_33089[(2)] = null);

(statearr_33016_33089[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (43))){
var state_32978__$1 = state_32978;
var statearr_33017_33090 = state_32978__$1;
(statearr_33017_33090[(2)] = null);

(statearr_33017_33090[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (29))){
var inst_32962 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
var statearr_33018_33091 = state_32978__$1;
(statearr_33018_33091[(2)] = inst_32962);

(statearr_33018_33091[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (44))){
var inst_32971 = (state_32978[(2)]);
var state_32978__$1 = (function (){var statearr_33019 = state_32978;
(statearr_33019[(28)] = inst_32971);

return statearr_33019;
})();
var statearr_33020_33092 = state_32978__$1;
(statearr_33020_33092[(2)] = null);

(statearr_33020_33092[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (6))){
var inst_32910 = (state_32978[(29)]);
var inst_32909 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32910__$1 = cljs.core.keys(inst_32909);
var inst_32911 = cljs.core.count(inst_32910__$1);
var inst_32912 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_32911) : cljs.core.reset_BANG_.call(null,dctr,inst_32911));
var inst_32917 = cljs.core.seq(inst_32910__$1);
var inst_32918 = inst_32917;
var inst_32919 = null;
var inst_32920 = (0);
var inst_32921 = (0);
var state_32978__$1 = (function (){var statearr_33021 = state_32978;
(statearr_33021[(9)] = inst_32921);

(statearr_33021[(20)] = inst_32918);

(statearr_33021[(11)] = inst_32919);

(statearr_33021[(21)] = inst_32920);

(statearr_33021[(30)] = inst_32912);

(statearr_33021[(29)] = inst_32910__$1);

return statearr_33021;
})();
var statearr_33022_33093 = state_32978__$1;
(statearr_33022_33093[(2)] = null);

(statearr_33022_33093[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (28))){
var inst_32918 = (state_32978[(20)]);
var inst_32937 = (state_32978[(25)]);
var inst_32937__$1 = cljs.core.seq(inst_32918);
var state_32978__$1 = (function (){var statearr_33023 = state_32978;
(statearr_33023[(25)] = inst_32937__$1);

return statearr_33023;
})();
if(inst_32937__$1){
var statearr_33024_33094 = state_32978__$1;
(statearr_33024_33094[(1)] = (33));

} else {
var statearr_33025_33095 = state_32978__$1;
(statearr_33025_33095[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (25))){
var inst_32921 = (state_32978[(9)]);
var inst_32920 = (state_32978[(21)]);
var inst_32923 = (inst_32921 < inst_32920);
var inst_32924 = inst_32923;
var state_32978__$1 = state_32978;
if(cljs.core.truth_(inst_32924)){
var statearr_33026_33096 = state_32978__$1;
(statearr_33026_33096[(1)] = (27));

} else {
var statearr_33027_33097 = state_32978__$1;
(statearr_33027_33097[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (34))){
var state_32978__$1 = state_32978;
var statearr_33028_33098 = state_32978__$1;
(statearr_33028_33098[(2)] = null);

(statearr_33028_33098[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (17))){
var state_32978__$1 = state_32978;
var statearr_33029_33099 = state_32978__$1;
(statearr_33029_33099[(2)] = null);

(statearr_33029_33099[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (3))){
var inst_32976 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32978__$1,inst_32976);
} else {
if((state_val_32979 === (12))){
var inst_32905 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
var statearr_33030_33100 = state_32978__$1;
(statearr_33030_33100[(2)] = inst_32905);

(statearr_33030_33100[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (2))){
var state_32978__$1 = state_32978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32978__$1,(4),ch);
} else {
if((state_val_32979 === (23))){
var state_32978__$1 = state_32978;
var statearr_33031_33101 = state_32978__$1;
(statearr_33031_33101[(2)] = null);

(statearr_33031_33101[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (35))){
var inst_32960 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
var statearr_33032_33102 = state_32978__$1;
(statearr_33032_33102[(2)] = inst_32960);

(statearr_33032_33102[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (19))){
var inst_32877 = (state_32978[(7)]);
var inst_32881 = cljs.core.chunk_first(inst_32877);
var inst_32882 = cljs.core.chunk_rest(inst_32877);
var inst_32883 = cljs.core.count(inst_32881);
var inst_32855 = inst_32882;
var inst_32856 = inst_32881;
var inst_32857 = inst_32883;
var inst_32858 = (0);
var state_32978__$1 = (function (){var statearr_33033 = state_32978;
(statearr_33033[(13)] = inst_32857);

(statearr_33033[(14)] = inst_32856);

(statearr_33033[(15)] = inst_32858);

(statearr_33033[(16)] = inst_32855);

return statearr_33033;
})();
var statearr_33034_33103 = state_32978__$1;
(statearr_33034_33103[(2)] = null);

(statearr_33034_33103[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (11))){
var inst_32877 = (state_32978[(7)]);
var inst_32855 = (state_32978[(16)]);
var inst_32877__$1 = cljs.core.seq(inst_32855);
var state_32978__$1 = (function (){var statearr_33035 = state_32978;
(statearr_33035[(7)] = inst_32877__$1);

return statearr_33035;
})();
if(inst_32877__$1){
var statearr_33036_33104 = state_32978__$1;
(statearr_33036_33104[(1)] = (16));

} else {
var statearr_33037_33105 = state_32978__$1;
(statearr_33037_33105[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (9))){
var inst_32907 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
var statearr_33038_33106 = state_32978__$1;
(statearr_33038_33106[(2)] = inst_32907);

(statearr_33038_33106[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (5))){
var inst_32853 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32854 = cljs.core.seq(inst_32853);
var inst_32855 = inst_32854;
var inst_32856 = null;
var inst_32857 = (0);
var inst_32858 = (0);
var state_32978__$1 = (function (){var statearr_33039 = state_32978;
(statearr_33039[(13)] = inst_32857);

(statearr_33039[(14)] = inst_32856);

(statearr_33039[(15)] = inst_32858);

(statearr_33039[(16)] = inst_32855);

return statearr_33039;
})();
var statearr_33040_33107 = state_32978__$1;
(statearr_33040_33107[(2)] = null);

(statearr_33040_33107[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (14))){
var state_32978__$1 = state_32978;
var statearr_33041_33108 = state_32978__$1;
(statearr_33041_33108[(2)] = null);

(statearr_33041_33108[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (45))){
var inst_32968 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
var statearr_33042_33109 = state_32978__$1;
(statearr_33042_33109[(2)] = inst_32968);

(statearr_33042_33109[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (26))){
var inst_32910 = (state_32978[(29)]);
var inst_32964 = (state_32978[(2)]);
var inst_32965 = cljs.core.seq(inst_32910);
var state_32978__$1 = (function (){var statearr_33043 = state_32978;
(statearr_33043[(31)] = inst_32964);

return statearr_33043;
})();
if(inst_32965){
var statearr_33044_33110 = state_32978__$1;
(statearr_33044_33110[(1)] = (42));

} else {
var statearr_33045_33111 = state_32978__$1;
(statearr_33045_33111[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (16))){
var inst_32877 = (state_32978[(7)]);
var inst_32879 = cljs.core.chunked_seq_QMARK_(inst_32877);
var state_32978__$1 = state_32978;
if(inst_32879){
var statearr_33046_33112 = state_32978__$1;
(statearr_33046_33112[(1)] = (19));

} else {
var statearr_33047_33113 = state_32978__$1;
(statearr_33047_33113[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (38))){
var inst_32957 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
var statearr_33048_33114 = state_32978__$1;
(statearr_33048_33114[(2)] = inst_32957);

(statearr_33048_33114[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (30))){
var state_32978__$1 = state_32978;
var statearr_33049_33115 = state_32978__$1;
(statearr_33049_33115[(2)] = null);

(statearr_33049_33115[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (10))){
var inst_32856 = (state_32978[(14)]);
var inst_32858 = (state_32978[(15)]);
var inst_32866 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32856,inst_32858);
var inst_32867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32866,(0),null);
var inst_32868 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32866,(1),null);
var state_32978__$1 = (function (){var statearr_33050 = state_32978;
(statearr_33050[(26)] = inst_32867);

return statearr_33050;
})();
if(cljs.core.truth_(inst_32868)){
var statearr_33051_33116 = state_32978__$1;
(statearr_33051_33116[(1)] = (13));

} else {
var statearr_33052_33117 = state_32978__$1;
(statearr_33052_33117[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (18))){
var inst_32903 = (state_32978[(2)]);
var state_32978__$1 = state_32978;
var statearr_33053_33118 = state_32978__$1;
(statearr_33053_33118[(2)] = inst_32903);

(statearr_33053_33118[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (42))){
var state_32978__$1 = state_32978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32978__$1,(45),dchan);
} else {
if((state_val_32979 === (37))){
var inst_32846 = (state_32978[(10)]);
var inst_32937 = (state_32978[(25)]);
var inst_32946 = (state_32978[(23)]);
var inst_32946__$1 = cljs.core.first(inst_32937);
var inst_32947 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32946__$1,inst_32846,done);
var state_32978__$1 = (function (){var statearr_33054 = state_32978;
(statearr_33054[(23)] = inst_32946__$1);

return statearr_33054;
})();
if(cljs.core.truth_(inst_32947)){
var statearr_33055_33119 = state_32978__$1;
(statearr_33055_33119[(1)] = (39));

} else {
var statearr_33056_33120 = state_32978__$1;
(statearr_33056_33120[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32979 === (8))){
var inst_32857 = (state_32978[(13)]);
var inst_32858 = (state_32978[(15)]);
var inst_32860 = (inst_32858 < inst_32857);
var inst_32861 = inst_32860;
var state_32978__$1 = state_32978;
if(cljs.core.truth_(inst_32861)){
var statearr_33057_33121 = state_32978__$1;
(statearr_33057_33121[(1)] = (10));

} else {
var statearr_33058_33122 = state_32978__$1;
(statearr_33058_33122[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto___33068,cs,m,dchan,dctr,done))
;
return ((function (switch__18696__auto__,c__18808__auto___33068,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__18697__auto__ = null;
var cljs$core$async$mult_$_state_machine__18697__auto____0 = (function (){
var statearr_33062 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33062[(0)] = cljs$core$async$mult_$_state_machine__18697__auto__);

(statearr_33062[(1)] = (1));

return statearr_33062;
});
var cljs$core$async$mult_$_state_machine__18697__auto____1 = (function (state_32978){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_32978);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e33063){if((e33063 instanceof Object)){
var ex__18700__auto__ = e33063;
var statearr_33064_33123 = state_32978;
(statearr_33064_33123[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32978);

return cljs.core.cst$kw$recur;
} else {
throw e33063;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__33124 = state_32978;
state_32978 = G__33124;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__18697__auto__ = function(state_32978){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__18697__auto____1.call(this,state_32978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__18697__auto____0;
cljs$core$async$mult_$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__18697__auto____1;
return cljs$core$async$mult_$_state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___33068,cs,m,dchan,dctr,done))
})();
var state__18810__auto__ = (function (){var statearr_33065 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_33065[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___33068);

return statearr_33065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___33068,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args33125 = [];
var len__7651__auto___33128 = arguments.length;
var i__7652__auto___33129 = (0);
while(true){
if((i__7652__auto___33129 < len__7651__auto___33128)){
args33125.push((arguments[i__7652__auto___33129]));

var G__33130 = (i__7652__auto___33129 + (1));
i__7652__auto___33129 = G__33130;
continue;
} else {
}
break;
}

var G__33127 = args33125.length;
switch (G__33127) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33125.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto__.call(null,m));
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7207__auto__.call(null,m,state_map));
} else {
var m__7207__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7207__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7207__auto__.call(null,m,mode));
} else {
var m__7207__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7207__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___33142 = arguments.length;
var i__7652__auto___33143 = (0);
while(true){
if((i__7652__auto___33143 < len__7651__auto___33142)){
args__7658__auto__.push((arguments[i__7652__auto___33143]));

var G__33144 = (i__7652__auto___33143 + (1));
i__7652__auto___33143 = G__33144;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__33136){
var map__33137 = p__33136;
var map__33137__$1 = ((((!((map__33137 == null)))?((((map__33137.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33137.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33137):map__33137);
var opts = map__33137__$1;
var statearr_33139_33145 = state;
(statearr_33139_33145[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__33137,map__33137__$1,opts){
return (function (val){
var statearr_33140_33146 = state;
(statearr_33140_33146[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__33137,map__33137__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_33141_33147 = state;
(statearr_33141_33147[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq33132){
var G__33133 = cljs.core.first(seq33132);
var seq33132__$1 = cljs.core.next(seq33132);
var G__33134 = cljs.core.first(seq33132__$1);
var seq33132__$2 = cljs.core.next(seq33132__$1);
var G__33135 = cljs.core.first(seq33132__$2);
var seq33132__$3 = cljs.core.next(seq33132__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33133,G__33134,G__33135,seq33132__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__33319 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33319) : cljs.core.atom.call(null,G__33319));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__33320 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33320) : cljs.core.atom.call(null,G__33320));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async33321 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33321 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta33322){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta33322 = meta33322;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33321.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33323,meta33322__$1){
var self__ = this;
var _33323__$1 = this;
return (new cljs.core.async.t_cljs$core$async33321(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta33322__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33321.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33323){
var self__ = this;
var _33323__$1 = this;
return self__.meta33322;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33321.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33321.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33321.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33321.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33321.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33321.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__33324_33490 = self__.cs;
var G__33325_33491 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__33324_33490,G__33325_33491) : cljs.core.reset_BANG_.call(null,G__33324_33490,G__33325_33491));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33321.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33321.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33321.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta33322], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33321.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33321.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33321";

cljs.core.async.t_cljs$core$async33321.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33321");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async33321 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async33321(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33322){
return (new cljs.core.async.t_cljs$core$async33321(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33322));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async33321(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18808__auto___33492 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___33492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___33492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_33427){
var state_val_33428 = (state_33427[(1)]);
if((state_val_33428 === (7))){
var inst_33342 = (state_33427[(2)]);
var state_33427__$1 = state_33427;
var statearr_33429_33493 = state_33427__$1;
(statearr_33429_33493[(2)] = inst_33342);

(statearr_33429_33493[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (20))){
var inst_33354 = (state_33427[(7)]);
var state_33427__$1 = state_33427;
var statearr_33430_33494 = state_33427__$1;
(statearr_33430_33494[(2)] = inst_33354);

(statearr_33430_33494[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (27))){
var state_33427__$1 = state_33427;
var statearr_33431_33495 = state_33427__$1;
(statearr_33431_33495[(2)] = null);

(statearr_33431_33495[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (1))){
var inst_33329 = (state_33427[(8)]);
var inst_33329__$1 = calc_state();
var inst_33331 = (inst_33329__$1 == null);
var inst_33332 = cljs.core.not(inst_33331);
var state_33427__$1 = (function (){var statearr_33432 = state_33427;
(statearr_33432[(8)] = inst_33329__$1);

return statearr_33432;
})();
if(inst_33332){
var statearr_33433_33496 = state_33427__$1;
(statearr_33433_33496[(1)] = (2));

} else {
var statearr_33434_33497 = state_33427__$1;
(statearr_33434_33497[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (24))){
var inst_33401 = (state_33427[(9)]);
var inst_33387 = (state_33427[(10)]);
var inst_33378 = (state_33427[(11)]);
var inst_33401__$1 = (inst_33378.cljs$core$IFn$_invoke$arity$1 ? inst_33378.cljs$core$IFn$_invoke$arity$1(inst_33387) : inst_33378.call(null,inst_33387));
var state_33427__$1 = (function (){var statearr_33435 = state_33427;
(statearr_33435[(9)] = inst_33401__$1);

return statearr_33435;
})();
if(cljs.core.truth_(inst_33401__$1)){
var statearr_33436_33498 = state_33427__$1;
(statearr_33436_33498[(1)] = (29));

} else {
var statearr_33437_33499 = state_33427__$1;
(statearr_33437_33499[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (4))){
var inst_33345 = (state_33427[(2)]);
var state_33427__$1 = state_33427;
if(cljs.core.truth_(inst_33345)){
var statearr_33438_33500 = state_33427__$1;
(statearr_33438_33500[(1)] = (8));

} else {
var statearr_33439_33501 = state_33427__$1;
(statearr_33439_33501[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (15))){
var inst_33372 = (state_33427[(2)]);
var state_33427__$1 = state_33427;
if(cljs.core.truth_(inst_33372)){
var statearr_33440_33502 = state_33427__$1;
(statearr_33440_33502[(1)] = (19));

} else {
var statearr_33441_33503 = state_33427__$1;
(statearr_33441_33503[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (21))){
var inst_33377 = (state_33427[(12)]);
var inst_33377__$1 = (state_33427[(2)]);
var inst_33378 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33377__$1,cljs.core.cst$kw$solos);
var inst_33379 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33377__$1,cljs.core.cst$kw$mutes);
var inst_33380 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33377__$1,cljs.core.cst$kw$reads);
var state_33427__$1 = (function (){var statearr_33442 = state_33427;
(statearr_33442[(12)] = inst_33377__$1);

(statearr_33442[(13)] = inst_33379);

(statearr_33442[(11)] = inst_33378);

return statearr_33442;
})();
return cljs.core.async.ioc_alts_BANG_(state_33427__$1,(22),inst_33380);
} else {
if((state_val_33428 === (31))){
var inst_33409 = (state_33427[(2)]);
var state_33427__$1 = state_33427;
if(cljs.core.truth_(inst_33409)){
var statearr_33443_33504 = state_33427__$1;
(statearr_33443_33504[(1)] = (32));

} else {
var statearr_33444_33505 = state_33427__$1;
(statearr_33444_33505[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (32))){
var inst_33386 = (state_33427[(14)]);
var state_33427__$1 = state_33427;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33427__$1,(35),out,inst_33386);
} else {
if((state_val_33428 === (33))){
var inst_33377 = (state_33427[(12)]);
var inst_33354 = inst_33377;
var state_33427__$1 = (function (){var statearr_33445 = state_33427;
(statearr_33445[(7)] = inst_33354);

return statearr_33445;
})();
var statearr_33446_33506 = state_33427__$1;
(statearr_33446_33506[(2)] = null);

(statearr_33446_33506[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (13))){
var inst_33354 = (state_33427[(7)]);
var inst_33361 = inst_33354.cljs$lang$protocol_mask$partition0$;
var inst_33362 = (inst_33361 & (64));
var inst_33363 = inst_33354.cljs$core$ISeq$;
var inst_33364 = (cljs.core.PROTOCOL_SENTINEL === inst_33363);
var inst_33365 = (inst_33362) || (inst_33364);
var state_33427__$1 = state_33427;
if(cljs.core.truth_(inst_33365)){
var statearr_33447_33507 = state_33427__$1;
(statearr_33447_33507[(1)] = (16));

} else {
var statearr_33448_33508 = state_33427__$1;
(statearr_33448_33508[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (22))){
var inst_33386 = (state_33427[(14)]);
var inst_33387 = (state_33427[(10)]);
var inst_33385 = (state_33427[(2)]);
var inst_33386__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33385,(0),null);
var inst_33387__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33385,(1),null);
var inst_33388 = (inst_33386__$1 == null);
var inst_33389 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33387__$1,change);
var inst_33390 = (inst_33388) || (inst_33389);
var state_33427__$1 = (function (){var statearr_33449 = state_33427;
(statearr_33449[(14)] = inst_33386__$1);

(statearr_33449[(10)] = inst_33387__$1);

return statearr_33449;
})();
if(cljs.core.truth_(inst_33390)){
var statearr_33450_33509 = state_33427__$1;
(statearr_33450_33509[(1)] = (23));

} else {
var statearr_33451_33510 = state_33427__$1;
(statearr_33451_33510[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (36))){
var inst_33377 = (state_33427[(12)]);
var inst_33354 = inst_33377;
var state_33427__$1 = (function (){var statearr_33452 = state_33427;
(statearr_33452[(7)] = inst_33354);

return statearr_33452;
})();
var statearr_33453_33511 = state_33427__$1;
(statearr_33453_33511[(2)] = null);

(statearr_33453_33511[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (29))){
var inst_33401 = (state_33427[(9)]);
var state_33427__$1 = state_33427;
var statearr_33454_33512 = state_33427__$1;
(statearr_33454_33512[(2)] = inst_33401);

(statearr_33454_33512[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (6))){
var state_33427__$1 = state_33427;
var statearr_33455_33513 = state_33427__$1;
(statearr_33455_33513[(2)] = false);

(statearr_33455_33513[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (28))){
var inst_33397 = (state_33427[(2)]);
var inst_33398 = calc_state();
var inst_33354 = inst_33398;
var state_33427__$1 = (function (){var statearr_33456 = state_33427;
(statearr_33456[(7)] = inst_33354);

(statearr_33456[(15)] = inst_33397);

return statearr_33456;
})();
var statearr_33457_33514 = state_33427__$1;
(statearr_33457_33514[(2)] = null);

(statearr_33457_33514[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (25))){
var inst_33423 = (state_33427[(2)]);
var state_33427__$1 = state_33427;
var statearr_33458_33515 = state_33427__$1;
(statearr_33458_33515[(2)] = inst_33423);

(statearr_33458_33515[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (34))){
var inst_33421 = (state_33427[(2)]);
var state_33427__$1 = state_33427;
var statearr_33459_33516 = state_33427__$1;
(statearr_33459_33516[(2)] = inst_33421);

(statearr_33459_33516[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (17))){
var state_33427__$1 = state_33427;
var statearr_33460_33517 = state_33427__$1;
(statearr_33460_33517[(2)] = false);

(statearr_33460_33517[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (3))){
var state_33427__$1 = state_33427;
var statearr_33461_33518 = state_33427__$1;
(statearr_33461_33518[(2)] = false);

(statearr_33461_33518[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (12))){
var inst_33425 = (state_33427[(2)]);
var state_33427__$1 = state_33427;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33427__$1,inst_33425);
} else {
if((state_val_33428 === (2))){
var inst_33329 = (state_33427[(8)]);
var inst_33334 = inst_33329.cljs$lang$protocol_mask$partition0$;
var inst_33335 = (inst_33334 & (64));
var inst_33336 = inst_33329.cljs$core$ISeq$;
var inst_33337 = (cljs.core.PROTOCOL_SENTINEL === inst_33336);
var inst_33338 = (inst_33335) || (inst_33337);
var state_33427__$1 = state_33427;
if(cljs.core.truth_(inst_33338)){
var statearr_33462_33519 = state_33427__$1;
(statearr_33462_33519[(1)] = (5));

} else {
var statearr_33463_33520 = state_33427__$1;
(statearr_33463_33520[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (23))){
var inst_33386 = (state_33427[(14)]);
var inst_33392 = (inst_33386 == null);
var state_33427__$1 = state_33427;
if(cljs.core.truth_(inst_33392)){
var statearr_33464_33521 = state_33427__$1;
(statearr_33464_33521[(1)] = (26));

} else {
var statearr_33465_33522 = state_33427__$1;
(statearr_33465_33522[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (35))){
var inst_33412 = (state_33427[(2)]);
var state_33427__$1 = state_33427;
if(cljs.core.truth_(inst_33412)){
var statearr_33466_33523 = state_33427__$1;
(statearr_33466_33523[(1)] = (36));

} else {
var statearr_33467_33524 = state_33427__$1;
(statearr_33467_33524[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (19))){
var inst_33354 = (state_33427[(7)]);
var inst_33374 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33354);
var state_33427__$1 = state_33427;
var statearr_33468_33525 = state_33427__$1;
(statearr_33468_33525[(2)] = inst_33374);

(statearr_33468_33525[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (11))){
var inst_33354 = (state_33427[(7)]);
var inst_33358 = (inst_33354 == null);
var inst_33359 = cljs.core.not(inst_33358);
var state_33427__$1 = state_33427;
if(inst_33359){
var statearr_33469_33526 = state_33427__$1;
(statearr_33469_33526[(1)] = (13));

} else {
var statearr_33470_33527 = state_33427__$1;
(statearr_33470_33527[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (9))){
var inst_33329 = (state_33427[(8)]);
var state_33427__$1 = state_33427;
var statearr_33471_33528 = state_33427__$1;
(statearr_33471_33528[(2)] = inst_33329);

(statearr_33471_33528[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (5))){
var state_33427__$1 = state_33427;
var statearr_33472_33529 = state_33427__$1;
(statearr_33472_33529[(2)] = true);

(statearr_33472_33529[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (14))){
var state_33427__$1 = state_33427;
var statearr_33473_33530 = state_33427__$1;
(statearr_33473_33530[(2)] = false);

(statearr_33473_33530[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (26))){
var inst_33387 = (state_33427[(10)]);
var inst_33394 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_33387);
var state_33427__$1 = state_33427;
var statearr_33474_33531 = state_33427__$1;
(statearr_33474_33531[(2)] = inst_33394);

(statearr_33474_33531[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (16))){
var state_33427__$1 = state_33427;
var statearr_33475_33532 = state_33427__$1;
(statearr_33475_33532[(2)] = true);

(statearr_33475_33532[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (38))){
var inst_33417 = (state_33427[(2)]);
var state_33427__$1 = state_33427;
var statearr_33476_33533 = state_33427__$1;
(statearr_33476_33533[(2)] = inst_33417);

(statearr_33476_33533[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (30))){
var inst_33387 = (state_33427[(10)]);
var inst_33379 = (state_33427[(13)]);
var inst_33378 = (state_33427[(11)]);
var inst_33404 = cljs.core.empty_QMARK_(inst_33378);
var inst_33405 = (inst_33379.cljs$core$IFn$_invoke$arity$1 ? inst_33379.cljs$core$IFn$_invoke$arity$1(inst_33387) : inst_33379.call(null,inst_33387));
var inst_33406 = cljs.core.not(inst_33405);
var inst_33407 = (inst_33404) && (inst_33406);
var state_33427__$1 = state_33427;
var statearr_33477_33534 = state_33427__$1;
(statearr_33477_33534[(2)] = inst_33407);

(statearr_33477_33534[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (10))){
var inst_33329 = (state_33427[(8)]);
var inst_33350 = (state_33427[(2)]);
var inst_33351 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33350,cljs.core.cst$kw$solos);
var inst_33352 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33350,cljs.core.cst$kw$mutes);
var inst_33353 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33350,cljs.core.cst$kw$reads);
var inst_33354 = inst_33329;
var state_33427__$1 = (function (){var statearr_33478 = state_33427;
(statearr_33478[(16)] = inst_33353);

(statearr_33478[(7)] = inst_33354);

(statearr_33478[(17)] = inst_33351);

(statearr_33478[(18)] = inst_33352);

return statearr_33478;
})();
var statearr_33479_33535 = state_33427__$1;
(statearr_33479_33535[(2)] = null);

(statearr_33479_33535[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (18))){
var inst_33369 = (state_33427[(2)]);
var state_33427__$1 = state_33427;
var statearr_33480_33536 = state_33427__$1;
(statearr_33480_33536[(2)] = inst_33369);

(statearr_33480_33536[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (37))){
var state_33427__$1 = state_33427;
var statearr_33481_33537 = state_33427__$1;
(statearr_33481_33537[(2)] = null);

(statearr_33481_33537[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33428 === (8))){
var inst_33329 = (state_33427[(8)]);
var inst_33347 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33329);
var state_33427__$1 = state_33427;
var statearr_33482_33538 = state_33427__$1;
(statearr_33482_33538[(2)] = inst_33347);

(statearr_33482_33538[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto___33492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__18696__auto__,c__18808__auto___33492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__18697__auto__ = null;
var cljs$core$async$mix_$_state_machine__18697__auto____0 = (function (){
var statearr_33486 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33486[(0)] = cljs$core$async$mix_$_state_machine__18697__auto__);

(statearr_33486[(1)] = (1));

return statearr_33486;
});
var cljs$core$async$mix_$_state_machine__18697__auto____1 = (function (state_33427){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_33427);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e33487){if((e33487 instanceof Object)){
var ex__18700__auto__ = e33487;
var statearr_33488_33539 = state_33427;
(statearr_33488_33539[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33427);

return cljs.core.cst$kw$recur;
} else {
throw e33487;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__33540 = state_33427;
state_33427 = G__33540;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__18697__auto__ = function(state_33427){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__18697__auto____1.call(this,state_33427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__18697__auto____0;
cljs$core$async$mix_$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__18697__auto____1;
return cljs$core$async$mix_$_state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___33492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__18810__auto__ = (function (){var statearr_33489 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_33489[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___33492);

return statearr_33489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___33492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7207__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7207__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7207__auto__.call(null,p,v,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7207__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args33541 = [];
var len__7651__auto___33544 = arguments.length;
var i__7652__auto___33545 = (0);
while(true){
if((i__7652__auto___33545 < len__7651__auto___33544)){
args33541.push((arguments[i__7652__auto___33545]));

var G__33546 = (i__7652__auto___33545 + (1));
i__7652__auto___33545 = G__33546;
continue;
} else {
}
break;
}

var G__33543 = args33541.length;
switch (G__33543) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33541.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7207__auto__.call(null,p));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7207__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7207__auto__.call(null,p,v));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7207__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args33549 = [];
var len__7651__auto___33677 = arguments.length;
var i__7652__auto___33678 = (0);
while(true){
if((i__7652__auto___33678 < len__7651__auto___33677)){
args33549.push((arguments[i__7652__auto___33678]));

var G__33679 = (i__7652__auto___33678 + (1));
i__7652__auto___33678 = G__33679;
continue;
} else {
}
break;
}

var G__33551 = args33549.length;
switch (G__33551) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33549.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__33552 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33552) : cljs.core.atom.call(null,G__33552));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6543__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6543__auto__,mults){
return (function (p1__33548_SHARP_){
if(cljs.core.truth_((p1__33548_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33548_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__33548_SHARP_.call(null,topic)))){
return p1__33548_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__33548_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6543__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async33553 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33553 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta33554){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta33554 = meta33554;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33553.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_33555,meta33554__$1){
var self__ = this;
var _33555__$1 = this;
return (new cljs.core.async.t_cljs$core$async33553(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta33554__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33553.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_33555){
var self__ = this;
var _33555__$1 = this;
return self__.meta33554;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33553.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33553.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33553.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33553.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33553.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33553.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__33556 = self__.mults;
var G__33557 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__33556,G__33557) : cljs.core.reset_BANG_.call(null,G__33556,G__33557));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33553.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33553.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta33554], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33553.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33553.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33553";

cljs.core.async.t_cljs$core$async33553.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33553");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async33553 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async33553(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33554){
return (new cljs.core.async.t_cljs$core$async33553(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33554));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async33553(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__18808__auto___33681 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___33681,mults,ensure_mult,p){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___33681,mults,ensure_mult,p){
return (function (state_33629){
var state_val_33630 = (state_33629[(1)]);
if((state_val_33630 === (7))){
var inst_33625 = (state_33629[(2)]);
var state_33629__$1 = state_33629;
var statearr_33631_33682 = state_33629__$1;
(statearr_33631_33682[(2)] = inst_33625);

(statearr_33631_33682[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (20))){
var state_33629__$1 = state_33629;
var statearr_33632_33683 = state_33629__$1;
(statearr_33632_33683[(2)] = null);

(statearr_33632_33683[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (1))){
var state_33629__$1 = state_33629;
var statearr_33633_33684 = state_33629__$1;
(statearr_33633_33684[(2)] = null);

(statearr_33633_33684[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (24))){
var inst_33608 = (state_33629[(7)]);
var inst_33617 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_33608);
var state_33629__$1 = state_33629;
var statearr_33634_33685 = state_33629__$1;
(statearr_33634_33685[(2)] = inst_33617);

(statearr_33634_33685[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (4))){
var inst_33560 = (state_33629[(8)]);
var inst_33560__$1 = (state_33629[(2)]);
var inst_33561 = (inst_33560__$1 == null);
var state_33629__$1 = (function (){var statearr_33635 = state_33629;
(statearr_33635[(8)] = inst_33560__$1);

return statearr_33635;
})();
if(cljs.core.truth_(inst_33561)){
var statearr_33636_33686 = state_33629__$1;
(statearr_33636_33686[(1)] = (5));

} else {
var statearr_33637_33687 = state_33629__$1;
(statearr_33637_33687[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (15))){
var inst_33602 = (state_33629[(2)]);
var state_33629__$1 = state_33629;
var statearr_33638_33688 = state_33629__$1;
(statearr_33638_33688[(2)] = inst_33602);

(statearr_33638_33688[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (21))){
var inst_33622 = (state_33629[(2)]);
var state_33629__$1 = (function (){var statearr_33639 = state_33629;
(statearr_33639[(9)] = inst_33622);

return statearr_33639;
})();
var statearr_33640_33689 = state_33629__$1;
(statearr_33640_33689[(2)] = null);

(statearr_33640_33689[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (13))){
var inst_33584 = (state_33629[(10)]);
var inst_33586 = cljs.core.chunked_seq_QMARK_(inst_33584);
var state_33629__$1 = state_33629;
if(inst_33586){
var statearr_33641_33690 = state_33629__$1;
(statearr_33641_33690[(1)] = (16));

} else {
var statearr_33642_33691 = state_33629__$1;
(statearr_33642_33691[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (22))){
var inst_33614 = (state_33629[(2)]);
var state_33629__$1 = state_33629;
if(cljs.core.truth_(inst_33614)){
var statearr_33643_33692 = state_33629__$1;
(statearr_33643_33692[(1)] = (23));

} else {
var statearr_33644_33693 = state_33629__$1;
(statearr_33644_33693[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (6))){
var inst_33610 = (state_33629[(11)]);
var inst_33560 = (state_33629[(8)]);
var inst_33608 = (state_33629[(7)]);
var inst_33608__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_33560) : topic_fn.call(null,inst_33560));
var inst_33609 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33610__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33609,inst_33608__$1);
var state_33629__$1 = (function (){var statearr_33645 = state_33629;
(statearr_33645[(11)] = inst_33610__$1);

(statearr_33645[(7)] = inst_33608__$1);

return statearr_33645;
})();
if(cljs.core.truth_(inst_33610__$1)){
var statearr_33646_33694 = state_33629__$1;
(statearr_33646_33694[(1)] = (19));

} else {
var statearr_33647_33695 = state_33629__$1;
(statearr_33647_33695[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (25))){
var inst_33619 = (state_33629[(2)]);
var state_33629__$1 = state_33629;
var statearr_33648_33696 = state_33629__$1;
(statearr_33648_33696[(2)] = inst_33619);

(statearr_33648_33696[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (17))){
var inst_33584 = (state_33629[(10)]);
var inst_33593 = cljs.core.first(inst_33584);
var inst_33594 = cljs.core.async.muxch_STAR_(inst_33593);
var inst_33595 = cljs.core.async.close_BANG_(inst_33594);
var inst_33596 = cljs.core.next(inst_33584);
var inst_33570 = inst_33596;
var inst_33571 = null;
var inst_33572 = (0);
var inst_33573 = (0);
var state_33629__$1 = (function (){var statearr_33649 = state_33629;
(statearr_33649[(12)] = inst_33570);

(statearr_33649[(13)] = inst_33571);

(statearr_33649[(14)] = inst_33573);

(statearr_33649[(15)] = inst_33572);

(statearr_33649[(16)] = inst_33595);

return statearr_33649;
})();
var statearr_33650_33697 = state_33629__$1;
(statearr_33650_33697[(2)] = null);

(statearr_33650_33697[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (3))){
var inst_33627 = (state_33629[(2)]);
var state_33629__$1 = state_33629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33629__$1,inst_33627);
} else {
if((state_val_33630 === (12))){
var inst_33604 = (state_33629[(2)]);
var state_33629__$1 = state_33629;
var statearr_33651_33698 = state_33629__$1;
(statearr_33651_33698[(2)] = inst_33604);

(statearr_33651_33698[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (2))){
var state_33629__$1 = state_33629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33629__$1,(4),ch);
} else {
if((state_val_33630 === (23))){
var state_33629__$1 = state_33629;
var statearr_33652_33699 = state_33629__$1;
(statearr_33652_33699[(2)] = null);

(statearr_33652_33699[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (19))){
var inst_33610 = (state_33629[(11)]);
var inst_33560 = (state_33629[(8)]);
var inst_33612 = cljs.core.async.muxch_STAR_(inst_33610);
var state_33629__$1 = state_33629;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33629__$1,(22),inst_33612,inst_33560);
} else {
if((state_val_33630 === (11))){
var inst_33570 = (state_33629[(12)]);
var inst_33584 = (state_33629[(10)]);
var inst_33584__$1 = cljs.core.seq(inst_33570);
var state_33629__$1 = (function (){var statearr_33653 = state_33629;
(statearr_33653[(10)] = inst_33584__$1);

return statearr_33653;
})();
if(inst_33584__$1){
var statearr_33654_33700 = state_33629__$1;
(statearr_33654_33700[(1)] = (13));

} else {
var statearr_33655_33701 = state_33629__$1;
(statearr_33655_33701[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (9))){
var inst_33606 = (state_33629[(2)]);
var state_33629__$1 = state_33629;
var statearr_33656_33702 = state_33629__$1;
(statearr_33656_33702[(2)] = inst_33606);

(statearr_33656_33702[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (5))){
var inst_33567 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33568 = cljs.core.vals(inst_33567);
var inst_33569 = cljs.core.seq(inst_33568);
var inst_33570 = inst_33569;
var inst_33571 = null;
var inst_33572 = (0);
var inst_33573 = (0);
var state_33629__$1 = (function (){var statearr_33657 = state_33629;
(statearr_33657[(12)] = inst_33570);

(statearr_33657[(13)] = inst_33571);

(statearr_33657[(14)] = inst_33573);

(statearr_33657[(15)] = inst_33572);

return statearr_33657;
})();
var statearr_33658_33703 = state_33629__$1;
(statearr_33658_33703[(2)] = null);

(statearr_33658_33703[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (14))){
var state_33629__$1 = state_33629;
var statearr_33662_33704 = state_33629__$1;
(statearr_33662_33704[(2)] = null);

(statearr_33662_33704[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (16))){
var inst_33584 = (state_33629[(10)]);
var inst_33588 = cljs.core.chunk_first(inst_33584);
var inst_33589 = cljs.core.chunk_rest(inst_33584);
var inst_33590 = cljs.core.count(inst_33588);
var inst_33570 = inst_33589;
var inst_33571 = inst_33588;
var inst_33572 = inst_33590;
var inst_33573 = (0);
var state_33629__$1 = (function (){var statearr_33663 = state_33629;
(statearr_33663[(12)] = inst_33570);

(statearr_33663[(13)] = inst_33571);

(statearr_33663[(14)] = inst_33573);

(statearr_33663[(15)] = inst_33572);

return statearr_33663;
})();
var statearr_33664_33705 = state_33629__$1;
(statearr_33664_33705[(2)] = null);

(statearr_33664_33705[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (10))){
var inst_33570 = (state_33629[(12)]);
var inst_33571 = (state_33629[(13)]);
var inst_33573 = (state_33629[(14)]);
var inst_33572 = (state_33629[(15)]);
var inst_33578 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33571,inst_33573);
var inst_33579 = cljs.core.async.muxch_STAR_(inst_33578);
var inst_33580 = cljs.core.async.close_BANG_(inst_33579);
var inst_33581 = (inst_33573 + (1));
var tmp33659 = inst_33570;
var tmp33660 = inst_33571;
var tmp33661 = inst_33572;
var inst_33570__$1 = tmp33659;
var inst_33571__$1 = tmp33660;
var inst_33572__$1 = tmp33661;
var inst_33573__$1 = inst_33581;
var state_33629__$1 = (function (){var statearr_33665 = state_33629;
(statearr_33665[(12)] = inst_33570__$1);

(statearr_33665[(13)] = inst_33571__$1);

(statearr_33665[(14)] = inst_33573__$1);

(statearr_33665[(15)] = inst_33572__$1);

(statearr_33665[(17)] = inst_33580);

return statearr_33665;
})();
var statearr_33666_33706 = state_33629__$1;
(statearr_33666_33706[(2)] = null);

(statearr_33666_33706[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (18))){
var inst_33599 = (state_33629[(2)]);
var state_33629__$1 = state_33629;
var statearr_33667_33707 = state_33629__$1;
(statearr_33667_33707[(2)] = inst_33599);

(statearr_33667_33707[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33630 === (8))){
var inst_33573 = (state_33629[(14)]);
var inst_33572 = (state_33629[(15)]);
var inst_33575 = (inst_33573 < inst_33572);
var inst_33576 = inst_33575;
var state_33629__$1 = state_33629;
if(cljs.core.truth_(inst_33576)){
var statearr_33668_33708 = state_33629__$1;
(statearr_33668_33708[(1)] = (10));

} else {
var statearr_33669_33709 = state_33629__$1;
(statearr_33669_33709[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto___33681,mults,ensure_mult,p))
;
return ((function (switch__18696__auto__,c__18808__auto___33681,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__18697__auto__ = null;
var cljs$core$async$state_machine__18697__auto____0 = (function (){
var statearr_33673 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33673[(0)] = cljs$core$async$state_machine__18697__auto__);

(statearr_33673[(1)] = (1));

return statearr_33673;
});
var cljs$core$async$state_machine__18697__auto____1 = (function (state_33629){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_33629);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e33674){if((e33674 instanceof Object)){
var ex__18700__auto__ = e33674;
var statearr_33675_33710 = state_33629;
(statearr_33675_33710[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33629);

return cljs.core.cst$kw$recur;
} else {
throw e33674;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__33711 = state_33629;
state_33629 = G__33711;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$state_machine__18697__auto__ = function(state_33629){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18697__auto____1.call(this,state_33629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18697__auto____0;
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18697__auto____1;
return cljs$core$async$state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___33681,mults,ensure_mult,p))
})();
var state__18810__auto__ = (function (){var statearr_33676 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_33676[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___33681);

return statearr_33676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___33681,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args33712 = [];
var len__7651__auto___33715 = arguments.length;
var i__7652__auto___33716 = (0);
while(true){
if((i__7652__auto___33716 < len__7651__auto___33715)){
args33712.push((arguments[i__7652__auto___33716]));

var G__33717 = (i__7652__auto___33716 + (1));
i__7652__auto___33716 = G__33717;
continue;
} else {
}
break;
}

var G__33714 = args33712.length;
switch (G__33714) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33712.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args33719 = [];
var len__7651__auto___33722 = arguments.length;
var i__7652__auto___33723 = (0);
while(true){
if((i__7652__auto___33723 < len__7651__auto___33722)){
args33719.push((arguments[i__7652__auto___33723]));

var G__33724 = (i__7652__auto___33723 + (1));
i__7652__auto___33723 = G__33724;
continue;
} else {
}
break;
}

var G__33721 = args33719.length;
switch (G__33721) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33719.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args33726 = [];
var len__7651__auto___33797 = arguments.length;
var i__7652__auto___33798 = (0);
while(true){
if((i__7652__auto___33798 < len__7651__auto___33797)){
args33726.push((arguments[i__7652__auto___33798]));

var G__33799 = (i__7652__auto___33798 + (1));
i__7652__auto___33798 = G__33799;
continue;
} else {
}
break;
}

var G__33728 = args33726.length;
switch (G__33728) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33726.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__18808__auto___33801 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___33801,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___33801,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33767){
var state_val_33768 = (state_33767[(1)]);
if((state_val_33768 === (7))){
var state_33767__$1 = state_33767;
var statearr_33769_33802 = state_33767__$1;
(statearr_33769_33802[(2)] = null);

(statearr_33769_33802[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33768 === (1))){
var state_33767__$1 = state_33767;
var statearr_33770_33803 = state_33767__$1;
(statearr_33770_33803[(2)] = null);

(statearr_33770_33803[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33768 === (4))){
var inst_33731 = (state_33767[(7)]);
var inst_33733 = (inst_33731 < cnt);
var state_33767__$1 = state_33767;
if(cljs.core.truth_(inst_33733)){
var statearr_33771_33804 = state_33767__$1;
(statearr_33771_33804[(1)] = (6));

} else {
var statearr_33772_33805 = state_33767__$1;
(statearr_33772_33805[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33768 === (15))){
var inst_33763 = (state_33767[(2)]);
var state_33767__$1 = state_33767;
var statearr_33773_33806 = state_33767__$1;
(statearr_33773_33806[(2)] = inst_33763);

(statearr_33773_33806[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33768 === (13))){
var inst_33756 = cljs.core.async.close_BANG_(out);
var state_33767__$1 = state_33767;
var statearr_33774_33807 = state_33767__$1;
(statearr_33774_33807[(2)] = inst_33756);

(statearr_33774_33807[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33768 === (6))){
var state_33767__$1 = state_33767;
var statearr_33775_33808 = state_33767__$1;
(statearr_33775_33808[(2)] = null);

(statearr_33775_33808[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33768 === (3))){
var inst_33765 = (state_33767[(2)]);
var state_33767__$1 = state_33767;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33767__$1,inst_33765);
} else {
if((state_val_33768 === (12))){
var inst_33753 = (state_33767[(8)]);
var inst_33753__$1 = (state_33767[(2)]);
var inst_33754 = cljs.core.some(cljs.core.nil_QMARK_,inst_33753__$1);
var state_33767__$1 = (function (){var statearr_33776 = state_33767;
(statearr_33776[(8)] = inst_33753__$1);

return statearr_33776;
})();
if(cljs.core.truth_(inst_33754)){
var statearr_33777_33809 = state_33767__$1;
(statearr_33777_33809[(1)] = (13));

} else {
var statearr_33778_33810 = state_33767__$1;
(statearr_33778_33810[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33768 === (2))){
var inst_33730 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_33731 = (0);
var state_33767__$1 = (function (){var statearr_33779 = state_33767;
(statearr_33779[(9)] = inst_33730);

(statearr_33779[(7)] = inst_33731);

return statearr_33779;
})();
var statearr_33780_33811 = state_33767__$1;
(statearr_33780_33811[(2)] = null);

(statearr_33780_33811[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33768 === (11))){
var inst_33731 = (state_33767[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_33767,(10),Object,null,(9));
var inst_33740 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_33731) : chs__$1.call(null,inst_33731));
var inst_33741 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_33731) : done.call(null,inst_33731));
var inst_33742 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33740,inst_33741);
var state_33767__$1 = state_33767;
var statearr_33781_33812 = state_33767__$1;
(statearr_33781_33812[(2)] = inst_33742);


cljs.core.async.impl.ioc_helpers.process_exception(state_33767__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33768 === (9))){
var inst_33731 = (state_33767[(7)]);
var inst_33744 = (state_33767[(2)]);
var inst_33745 = (inst_33731 + (1));
var inst_33731__$1 = inst_33745;
var state_33767__$1 = (function (){var statearr_33782 = state_33767;
(statearr_33782[(7)] = inst_33731__$1);

(statearr_33782[(10)] = inst_33744);

return statearr_33782;
})();
var statearr_33783_33813 = state_33767__$1;
(statearr_33783_33813[(2)] = null);

(statearr_33783_33813[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33768 === (5))){
var inst_33751 = (state_33767[(2)]);
var state_33767__$1 = (function (){var statearr_33784 = state_33767;
(statearr_33784[(11)] = inst_33751);

return statearr_33784;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33767__$1,(12),dchan);
} else {
if((state_val_33768 === (14))){
var inst_33753 = (state_33767[(8)]);
var inst_33758 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_33753);
var state_33767__$1 = state_33767;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33767__$1,(16),out,inst_33758);
} else {
if((state_val_33768 === (16))){
var inst_33760 = (state_33767[(2)]);
var state_33767__$1 = (function (){var statearr_33785 = state_33767;
(statearr_33785[(12)] = inst_33760);

return statearr_33785;
})();
var statearr_33786_33814 = state_33767__$1;
(statearr_33786_33814[(2)] = null);

(statearr_33786_33814[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33768 === (10))){
var inst_33735 = (state_33767[(2)]);
var inst_33736 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_33767__$1 = (function (){var statearr_33787 = state_33767;
(statearr_33787[(13)] = inst_33735);

return statearr_33787;
})();
var statearr_33788_33815 = state_33767__$1;
(statearr_33788_33815[(2)] = inst_33736);


cljs.core.async.impl.ioc_helpers.process_exception(state_33767__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33768 === (8))){
var inst_33749 = (state_33767[(2)]);
var state_33767__$1 = state_33767;
var statearr_33789_33816 = state_33767__$1;
(statearr_33789_33816[(2)] = inst_33749);

(statearr_33789_33816[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto___33801,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__18696__auto__,c__18808__auto___33801,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__18697__auto__ = null;
var cljs$core$async$state_machine__18697__auto____0 = (function (){
var statearr_33793 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33793[(0)] = cljs$core$async$state_machine__18697__auto__);

(statearr_33793[(1)] = (1));

return statearr_33793;
});
var cljs$core$async$state_machine__18697__auto____1 = (function (state_33767){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_33767);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e33794){if((e33794 instanceof Object)){
var ex__18700__auto__ = e33794;
var statearr_33795_33817 = state_33767;
(statearr_33795_33817[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33767);

return cljs.core.cst$kw$recur;
} else {
throw e33794;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__33818 = state_33767;
state_33767 = G__33818;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$state_machine__18697__auto__ = function(state_33767){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18697__auto____1.call(this,state_33767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18697__auto____0;
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18697__auto____1;
return cljs$core$async$state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___33801,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__18810__auto__ = (function (){var statearr_33796 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_33796[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___33801);

return statearr_33796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___33801,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args33820 = [];
var len__7651__auto___33878 = arguments.length;
var i__7652__auto___33879 = (0);
while(true){
if((i__7652__auto___33879 < len__7651__auto___33878)){
args33820.push((arguments[i__7652__auto___33879]));

var G__33880 = (i__7652__auto___33879 + (1));
i__7652__auto___33879 = G__33880;
continue;
} else {
}
break;
}

var G__33822 = args33820.length;
switch (G__33822) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33820.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__18808__auto___33882 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___33882,out){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___33882,out){
return (function (state_33854){
var state_val_33855 = (state_33854[(1)]);
if((state_val_33855 === (7))){
var inst_33834 = (state_33854[(7)]);
var inst_33833 = (state_33854[(8)]);
var inst_33833__$1 = (state_33854[(2)]);
var inst_33834__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33833__$1,(0),null);
var inst_33835 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33833__$1,(1),null);
var inst_33836 = (inst_33834__$1 == null);
var state_33854__$1 = (function (){var statearr_33856 = state_33854;
(statearr_33856[(7)] = inst_33834__$1);

(statearr_33856[(9)] = inst_33835);

(statearr_33856[(8)] = inst_33833__$1);

return statearr_33856;
})();
if(cljs.core.truth_(inst_33836)){
var statearr_33857_33883 = state_33854__$1;
(statearr_33857_33883[(1)] = (8));

} else {
var statearr_33858_33884 = state_33854__$1;
(statearr_33858_33884[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33855 === (1))){
var inst_33823 = cljs.core.vec(chs);
var inst_33824 = inst_33823;
var state_33854__$1 = (function (){var statearr_33859 = state_33854;
(statearr_33859[(10)] = inst_33824);

return statearr_33859;
})();
var statearr_33860_33885 = state_33854__$1;
(statearr_33860_33885[(2)] = null);

(statearr_33860_33885[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33855 === (4))){
var inst_33824 = (state_33854[(10)]);
var state_33854__$1 = state_33854;
return cljs.core.async.ioc_alts_BANG_(state_33854__$1,(7),inst_33824);
} else {
if((state_val_33855 === (6))){
var inst_33850 = (state_33854[(2)]);
var state_33854__$1 = state_33854;
var statearr_33861_33886 = state_33854__$1;
(statearr_33861_33886[(2)] = inst_33850);

(statearr_33861_33886[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33855 === (3))){
var inst_33852 = (state_33854[(2)]);
var state_33854__$1 = state_33854;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33854__$1,inst_33852);
} else {
if((state_val_33855 === (2))){
var inst_33824 = (state_33854[(10)]);
var inst_33826 = cljs.core.count(inst_33824);
var inst_33827 = (inst_33826 > (0));
var state_33854__$1 = state_33854;
if(cljs.core.truth_(inst_33827)){
var statearr_33863_33887 = state_33854__$1;
(statearr_33863_33887[(1)] = (4));

} else {
var statearr_33864_33888 = state_33854__$1;
(statearr_33864_33888[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33855 === (11))){
var inst_33824 = (state_33854[(10)]);
var inst_33843 = (state_33854[(2)]);
var tmp33862 = inst_33824;
var inst_33824__$1 = tmp33862;
var state_33854__$1 = (function (){var statearr_33865 = state_33854;
(statearr_33865[(10)] = inst_33824__$1);

(statearr_33865[(11)] = inst_33843);

return statearr_33865;
})();
var statearr_33866_33889 = state_33854__$1;
(statearr_33866_33889[(2)] = null);

(statearr_33866_33889[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33855 === (9))){
var inst_33834 = (state_33854[(7)]);
var state_33854__$1 = state_33854;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33854__$1,(11),out,inst_33834);
} else {
if((state_val_33855 === (5))){
var inst_33848 = cljs.core.async.close_BANG_(out);
var state_33854__$1 = state_33854;
var statearr_33867_33890 = state_33854__$1;
(statearr_33867_33890[(2)] = inst_33848);

(statearr_33867_33890[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33855 === (10))){
var inst_33846 = (state_33854[(2)]);
var state_33854__$1 = state_33854;
var statearr_33868_33891 = state_33854__$1;
(statearr_33868_33891[(2)] = inst_33846);

(statearr_33868_33891[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33855 === (8))){
var inst_33824 = (state_33854[(10)]);
var inst_33834 = (state_33854[(7)]);
var inst_33835 = (state_33854[(9)]);
var inst_33833 = (state_33854[(8)]);
var inst_33838 = (function (){var cs = inst_33824;
var vec__33829 = inst_33833;
var v = inst_33834;
var c = inst_33835;
return ((function (cs,vec__33829,v,c,inst_33824,inst_33834,inst_33835,inst_33833,state_val_33855,c__18808__auto___33882,out){
return (function (p1__33819_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33819_SHARP_);
});
;})(cs,vec__33829,v,c,inst_33824,inst_33834,inst_33835,inst_33833,state_val_33855,c__18808__auto___33882,out))
})();
var inst_33839 = cljs.core.filterv(inst_33838,inst_33824);
var inst_33824__$1 = inst_33839;
var state_33854__$1 = (function (){var statearr_33869 = state_33854;
(statearr_33869[(10)] = inst_33824__$1);

return statearr_33869;
})();
var statearr_33870_33892 = state_33854__$1;
(statearr_33870_33892[(2)] = null);

(statearr_33870_33892[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto___33882,out))
;
return ((function (switch__18696__auto__,c__18808__auto___33882,out){
return (function() {
var cljs$core$async$state_machine__18697__auto__ = null;
var cljs$core$async$state_machine__18697__auto____0 = (function (){
var statearr_33874 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33874[(0)] = cljs$core$async$state_machine__18697__auto__);

(statearr_33874[(1)] = (1));

return statearr_33874;
});
var cljs$core$async$state_machine__18697__auto____1 = (function (state_33854){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_33854);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e33875){if((e33875 instanceof Object)){
var ex__18700__auto__ = e33875;
var statearr_33876_33893 = state_33854;
(statearr_33876_33893[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33854);

return cljs.core.cst$kw$recur;
} else {
throw e33875;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__33894 = state_33854;
state_33854 = G__33894;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$state_machine__18697__auto__ = function(state_33854){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18697__auto____1.call(this,state_33854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18697__auto____0;
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18697__auto____1;
return cljs$core$async$state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___33882,out))
})();
var state__18810__auto__ = (function (){var statearr_33877 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_33877[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___33882);

return statearr_33877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___33882,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args33895 = [];
var len__7651__auto___33944 = arguments.length;
var i__7652__auto___33945 = (0);
while(true){
if((i__7652__auto___33945 < len__7651__auto___33944)){
args33895.push((arguments[i__7652__auto___33945]));

var G__33946 = (i__7652__auto___33945 + (1));
i__7652__auto___33945 = G__33946;
continue;
} else {
}
break;
}

var G__33897 = args33895.length;
switch (G__33897) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33895.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__18808__auto___33948 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___33948,out){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___33948,out){
return (function (state_33921){
var state_val_33922 = (state_33921[(1)]);
if((state_val_33922 === (7))){
var inst_33903 = (state_33921[(7)]);
var inst_33903__$1 = (state_33921[(2)]);
var inst_33904 = (inst_33903__$1 == null);
var inst_33905 = cljs.core.not(inst_33904);
var state_33921__$1 = (function (){var statearr_33923 = state_33921;
(statearr_33923[(7)] = inst_33903__$1);

return statearr_33923;
})();
if(inst_33905){
var statearr_33924_33949 = state_33921__$1;
(statearr_33924_33949[(1)] = (8));

} else {
var statearr_33925_33950 = state_33921__$1;
(statearr_33925_33950[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33922 === (1))){
var inst_33898 = (0);
var state_33921__$1 = (function (){var statearr_33926 = state_33921;
(statearr_33926[(8)] = inst_33898);

return statearr_33926;
})();
var statearr_33927_33951 = state_33921__$1;
(statearr_33927_33951[(2)] = null);

(statearr_33927_33951[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33922 === (4))){
var state_33921__$1 = state_33921;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33921__$1,(7),ch);
} else {
if((state_val_33922 === (6))){
var inst_33916 = (state_33921[(2)]);
var state_33921__$1 = state_33921;
var statearr_33928_33952 = state_33921__$1;
(statearr_33928_33952[(2)] = inst_33916);

(statearr_33928_33952[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33922 === (3))){
var inst_33918 = (state_33921[(2)]);
var inst_33919 = cljs.core.async.close_BANG_(out);
var state_33921__$1 = (function (){var statearr_33929 = state_33921;
(statearr_33929[(9)] = inst_33918);

return statearr_33929;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33921__$1,inst_33919);
} else {
if((state_val_33922 === (2))){
var inst_33898 = (state_33921[(8)]);
var inst_33900 = (inst_33898 < n);
var state_33921__$1 = state_33921;
if(cljs.core.truth_(inst_33900)){
var statearr_33930_33953 = state_33921__$1;
(statearr_33930_33953[(1)] = (4));

} else {
var statearr_33931_33954 = state_33921__$1;
(statearr_33931_33954[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33922 === (11))){
var inst_33898 = (state_33921[(8)]);
var inst_33908 = (state_33921[(2)]);
var inst_33909 = (inst_33898 + (1));
var inst_33898__$1 = inst_33909;
var state_33921__$1 = (function (){var statearr_33932 = state_33921;
(statearr_33932[(8)] = inst_33898__$1);

(statearr_33932[(10)] = inst_33908);

return statearr_33932;
})();
var statearr_33933_33955 = state_33921__$1;
(statearr_33933_33955[(2)] = null);

(statearr_33933_33955[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33922 === (9))){
var state_33921__$1 = state_33921;
var statearr_33934_33956 = state_33921__$1;
(statearr_33934_33956[(2)] = null);

(statearr_33934_33956[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33922 === (5))){
var state_33921__$1 = state_33921;
var statearr_33935_33957 = state_33921__$1;
(statearr_33935_33957[(2)] = null);

(statearr_33935_33957[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33922 === (10))){
var inst_33913 = (state_33921[(2)]);
var state_33921__$1 = state_33921;
var statearr_33936_33958 = state_33921__$1;
(statearr_33936_33958[(2)] = inst_33913);

(statearr_33936_33958[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33922 === (8))){
var inst_33903 = (state_33921[(7)]);
var state_33921__$1 = state_33921;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33921__$1,(11),out,inst_33903);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto___33948,out))
;
return ((function (switch__18696__auto__,c__18808__auto___33948,out){
return (function() {
var cljs$core$async$state_machine__18697__auto__ = null;
var cljs$core$async$state_machine__18697__auto____0 = (function (){
var statearr_33940 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33940[(0)] = cljs$core$async$state_machine__18697__auto__);

(statearr_33940[(1)] = (1));

return statearr_33940;
});
var cljs$core$async$state_machine__18697__auto____1 = (function (state_33921){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_33921);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e33941){if((e33941 instanceof Object)){
var ex__18700__auto__ = e33941;
var statearr_33942_33959 = state_33921;
(statearr_33942_33959[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33921);

return cljs.core.cst$kw$recur;
} else {
throw e33941;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__33960 = state_33921;
state_33921 = G__33960;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$state_machine__18697__auto__ = function(state_33921){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18697__auto____1.call(this,state_33921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18697__auto____0;
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18697__auto____1;
return cljs$core$async$state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___33948,out))
})();
var state__18810__auto__ = (function (){var statearr_33943 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_33943[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___33948);

return statearr_33943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___33948,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33970 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33970 = (function (f,ch,meta33971){
this.f = f;
this.ch = ch;
this.meta33971 = meta33971;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33970.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33972,meta33971__$1){
var self__ = this;
var _33972__$1 = this;
return (new cljs.core.async.t_cljs$core$async33970(self__.f,self__.ch,meta33971__$1));
});

cljs.core.async.t_cljs$core$async33970.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33972){
var self__ = this;
var _33972__$1 = this;
return self__.meta33971;
});

cljs.core.async.t_cljs$core$async33970.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33970.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33970.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33970.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33970.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async33973 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33973 = (function (f,ch,meta33971,_,fn1,meta33974){
this.f = f;
this.ch = ch;
this.meta33971 = meta33971;
this._ = _;
this.fn1 = fn1;
this.meta33974 = meta33974;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33973.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_33975,meta33974__$1){
var self__ = this;
var _33975__$1 = this;
return (new cljs.core.async.t_cljs$core$async33973(self__.f,self__.ch,self__.meta33971,self__._,self__.fn1,meta33974__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async33973.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_33975){
var self__ = this;
var _33975__$1 = this;
return self__.meta33974;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33973.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33973.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33973.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33973.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__33961_SHARP_){
var G__33976 = (((p1__33961_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__33961_SHARP_) : self__.f.call(null,p1__33961_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__33976) : f1.call(null,G__33976));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async33973.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33971,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async33970], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta33974], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33973.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33973.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33973";

cljs.core.async.t_cljs$core$async33973.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33973");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async33973 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33973(f__$1,ch__$1,meta33971__$1,___$2,fn1__$1,meta33974){
return (new cljs.core.async.t_cljs$core$async33973(f__$1,ch__$1,meta33971__$1,___$2,fn1__$1,meta33974));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async33973(self__.f,self__.ch,self__.meta33971,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6531__auto__ = ret;
if(cljs.core.truth_(and__6531__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__33977 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__33977) : self__.f.call(null,G__33977));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async33970.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33970.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async33970.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33971], null);
});

cljs.core.async.t_cljs$core$async33970.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33970.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33970";

cljs.core.async.t_cljs$core$async33970.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33970");
});

cljs.core.async.__GT_t_cljs$core$async33970 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33970(f__$1,ch__$1,meta33971){
return (new cljs.core.async.t_cljs$core$async33970(f__$1,ch__$1,meta33971));
});

}

return (new cljs.core.async.t_cljs$core$async33970(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33981 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33981 = (function (f,ch,meta33982){
this.f = f;
this.ch = ch;
this.meta33982 = meta33982;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33981.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33983,meta33982__$1){
var self__ = this;
var _33983__$1 = this;
return (new cljs.core.async.t_cljs$core$async33981(self__.f,self__.ch,meta33982__$1));
});

cljs.core.async.t_cljs$core$async33981.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33983){
var self__ = this;
var _33983__$1 = this;
return self__.meta33982;
});

cljs.core.async.t_cljs$core$async33981.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33981.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33981.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33981.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33981.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33981.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async33981.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33982], null);
});

cljs.core.async.t_cljs$core$async33981.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33981.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33981";

cljs.core.async.t_cljs$core$async33981.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33981");
});

cljs.core.async.__GT_t_cljs$core$async33981 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33981(f__$1,ch__$1,meta33982){
return (new cljs.core.async.t_cljs$core$async33981(f__$1,ch__$1,meta33982));
});

}

return (new cljs.core.async.t_cljs$core$async33981(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async33987 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33987 = (function (p,ch,meta33988){
this.p = p;
this.ch = ch;
this.meta33988 = meta33988;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33987.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33989,meta33988__$1){
var self__ = this;
var _33989__$1 = this;
return (new cljs.core.async.t_cljs$core$async33987(self__.p,self__.ch,meta33988__$1));
});

cljs.core.async.t_cljs$core$async33987.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33989){
var self__ = this;
var _33989__$1 = this;
return self__.meta33988;
});

cljs.core.async.t_cljs$core$async33987.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33987.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async33987.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async33987.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33987.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33987.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33987.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async33987.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta33988], null);
});

cljs.core.async.t_cljs$core$async33987.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33987.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33987";

cljs.core.async.t_cljs$core$async33987.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33987");
});

cljs.core.async.__GT_t_cljs$core$async33987 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33987(p__$1,ch__$1,meta33988){
return (new cljs.core.async.t_cljs$core$async33987(p__$1,ch__$1,meta33988));
});

}

return (new cljs.core.async.t_cljs$core$async33987(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args33990 = [];
var len__7651__auto___34034 = arguments.length;
var i__7652__auto___34035 = (0);
while(true){
if((i__7652__auto___34035 < len__7651__auto___34034)){
args33990.push((arguments[i__7652__auto___34035]));

var G__34036 = (i__7652__auto___34035 + (1));
i__7652__auto___34035 = G__34036;
continue;
} else {
}
break;
}

var G__33992 = args33990.length;
switch (G__33992) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33990.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__18808__auto___34038 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___34038,out){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___34038,out){
return (function (state_34013){
var state_val_34014 = (state_34013[(1)]);
if((state_val_34014 === (7))){
var inst_34009 = (state_34013[(2)]);
var state_34013__$1 = state_34013;
var statearr_34015_34039 = state_34013__$1;
(statearr_34015_34039[(2)] = inst_34009);

(statearr_34015_34039[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34014 === (1))){
var state_34013__$1 = state_34013;
var statearr_34016_34040 = state_34013__$1;
(statearr_34016_34040[(2)] = null);

(statearr_34016_34040[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34014 === (4))){
var inst_33995 = (state_34013[(7)]);
var inst_33995__$1 = (state_34013[(2)]);
var inst_33996 = (inst_33995__$1 == null);
var state_34013__$1 = (function (){var statearr_34017 = state_34013;
(statearr_34017[(7)] = inst_33995__$1);

return statearr_34017;
})();
if(cljs.core.truth_(inst_33996)){
var statearr_34018_34041 = state_34013__$1;
(statearr_34018_34041[(1)] = (5));

} else {
var statearr_34019_34042 = state_34013__$1;
(statearr_34019_34042[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34014 === (6))){
var inst_33995 = (state_34013[(7)]);
var inst_34000 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_33995) : p.call(null,inst_33995));
var state_34013__$1 = state_34013;
if(cljs.core.truth_(inst_34000)){
var statearr_34020_34043 = state_34013__$1;
(statearr_34020_34043[(1)] = (8));

} else {
var statearr_34021_34044 = state_34013__$1;
(statearr_34021_34044[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34014 === (3))){
var inst_34011 = (state_34013[(2)]);
var state_34013__$1 = state_34013;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34013__$1,inst_34011);
} else {
if((state_val_34014 === (2))){
var state_34013__$1 = state_34013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34013__$1,(4),ch);
} else {
if((state_val_34014 === (11))){
var inst_34003 = (state_34013[(2)]);
var state_34013__$1 = state_34013;
var statearr_34022_34045 = state_34013__$1;
(statearr_34022_34045[(2)] = inst_34003);

(statearr_34022_34045[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34014 === (9))){
var state_34013__$1 = state_34013;
var statearr_34023_34046 = state_34013__$1;
(statearr_34023_34046[(2)] = null);

(statearr_34023_34046[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34014 === (5))){
var inst_33998 = cljs.core.async.close_BANG_(out);
var state_34013__$1 = state_34013;
var statearr_34024_34047 = state_34013__$1;
(statearr_34024_34047[(2)] = inst_33998);

(statearr_34024_34047[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34014 === (10))){
var inst_34006 = (state_34013[(2)]);
var state_34013__$1 = (function (){var statearr_34025 = state_34013;
(statearr_34025[(8)] = inst_34006);

return statearr_34025;
})();
var statearr_34026_34048 = state_34013__$1;
(statearr_34026_34048[(2)] = null);

(statearr_34026_34048[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34014 === (8))){
var inst_33995 = (state_34013[(7)]);
var state_34013__$1 = state_34013;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34013__$1,(11),out,inst_33995);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto___34038,out))
;
return ((function (switch__18696__auto__,c__18808__auto___34038,out){
return (function() {
var cljs$core$async$state_machine__18697__auto__ = null;
var cljs$core$async$state_machine__18697__auto____0 = (function (){
var statearr_34030 = [null,null,null,null,null,null,null,null,null];
(statearr_34030[(0)] = cljs$core$async$state_machine__18697__auto__);

(statearr_34030[(1)] = (1));

return statearr_34030;
});
var cljs$core$async$state_machine__18697__auto____1 = (function (state_34013){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_34013);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e34031){if((e34031 instanceof Object)){
var ex__18700__auto__ = e34031;
var statearr_34032_34049 = state_34013;
(statearr_34032_34049[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34013);

return cljs.core.cst$kw$recur;
} else {
throw e34031;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__34050 = state_34013;
state_34013 = G__34050;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$state_machine__18697__auto__ = function(state_34013){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18697__auto____1.call(this,state_34013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18697__auto____0;
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18697__auto____1;
return cljs$core$async$state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___34038,out))
})();
var state__18810__auto__ = (function (){var statearr_34033 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_34033[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___34038);

return statearr_34033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___34038,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args34051 = [];
var len__7651__auto___34054 = arguments.length;
var i__7652__auto___34055 = (0);
while(true){
if((i__7652__auto___34055 < len__7651__auto___34054)){
args34051.push((arguments[i__7652__auto___34055]));

var G__34056 = (i__7652__auto___34055 + (1));
i__7652__auto___34055 = G__34056;
continue;
} else {
}
break;
}

var G__34053 = args34051.length;
switch (G__34053) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34051.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__18808__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto__){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto__){
return (function (state_34223){
var state_val_34224 = (state_34223[(1)]);
if((state_val_34224 === (7))){
var inst_34219 = (state_34223[(2)]);
var state_34223__$1 = state_34223;
var statearr_34225_34266 = state_34223__$1;
(statearr_34225_34266[(2)] = inst_34219);

(statearr_34225_34266[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (20))){
var inst_34189 = (state_34223[(7)]);
var inst_34200 = (state_34223[(2)]);
var inst_34201 = cljs.core.next(inst_34189);
var inst_34175 = inst_34201;
var inst_34176 = null;
var inst_34177 = (0);
var inst_34178 = (0);
var state_34223__$1 = (function (){var statearr_34226 = state_34223;
(statearr_34226[(8)] = inst_34175);

(statearr_34226[(9)] = inst_34200);

(statearr_34226[(10)] = inst_34178);

(statearr_34226[(11)] = inst_34176);

(statearr_34226[(12)] = inst_34177);

return statearr_34226;
})();
var statearr_34227_34267 = state_34223__$1;
(statearr_34227_34267[(2)] = null);

(statearr_34227_34267[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (1))){
var state_34223__$1 = state_34223;
var statearr_34228_34268 = state_34223__$1;
(statearr_34228_34268[(2)] = null);

(statearr_34228_34268[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (4))){
var inst_34164 = (state_34223[(13)]);
var inst_34164__$1 = (state_34223[(2)]);
var inst_34165 = (inst_34164__$1 == null);
var state_34223__$1 = (function (){var statearr_34229 = state_34223;
(statearr_34229[(13)] = inst_34164__$1);

return statearr_34229;
})();
if(cljs.core.truth_(inst_34165)){
var statearr_34230_34269 = state_34223__$1;
(statearr_34230_34269[(1)] = (5));

} else {
var statearr_34231_34270 = state_34223__$1;
(statearr_34231_34270[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (15))){
var state_34223__$1 = state_34223;
var statearr_34235_34271 = state_34223__$1;
(statearr_34235_34271[(2)] = null);

(statearr_34235_34271[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (21))){
var state_34223__$1 = state_34223;
var statearr_34236_34272 = state_34223__$1;
(statearr_34236_34272[(2)] = null);

(statearr_34236_34272[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (13))){
var inst_34175 = (state_34223[(8)]);
var inst_34178 = (state_34223[(10)]);
var inst_34176 = (state_34223[(11)]);
var inst_34177 = (state_34223[(12)]);
var inst_34185 = (state_34223[(2)]);
var inst_34186 = (inst_34178 + (1));
var tmp34232 = inst_34175;
var tmp34233 = inst_34176;
var tmp34234 = inst_34177;
var inst_34175__$1 = tmp34232;
var inst_34176__$1 = tmp34233;
var inst_34177__$1 = tmp34234;
var inst_34178__$1 = inst_34186;
var state_34223__$1 = (function (){var statearr_34237 = state_34223;
(statearr_34237[(8)] = inst_34175__$1);

(statearr_34237[(10)] = inst_34178__$1);

(statearr_34237[(11)] = inst_34176__$1);

(statearr_34237[(12)] = inst_34177__$1);

(statearr_34237[(14)] = inst_34185);

return statearr_34237;
})();
var statearr_34238_34273 = state_34223__$1;
(statearr_34238_34273[(2)] = null);

(statearr_34238_34273[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (22))){
var state_34223__$1 = state_34223;
var statearr_34239_34274 = state_34223__$1;
(statearr_34239_34274[(2)] = null);

(statearr_34239_34274[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (6))){
var inst_34164 = (state_34223[(13)]);
var inst_34173 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34164) : f.call(null,inst_34164));
var inst_34174 = cljs.core.seq(inst_34173);
var inst_34175 = inst_34174;
var inst_34176 = null;
var inst_34177 = (0);
var inst_34178 = (0);
var state_34223__$1 = (function (){var statearr_34240 = state_34223;
(statearr_34240[(8)] = inst_34175);

(statearr_34240[(10)] = inst_34178);

(statearr_34240[(11)] = inst_34176);

(statearr_34240[(12)] = inst_34177);

return statearr_34240;
})();
var statearr_34241_34275 = state_34223__$1;
(statearr_34241_34275[(2)] = null);

(statearr_34241_34275[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (17))){
var inst_34189 = (state_34223[(7)]);
var inst_34193 = cljs.core.chunk_first(inst_34189);
var inst_34194 = cljs.core.chunk_rest(inst_34189);
var inst_34195 = cljs.core.count(inst_34193);
var inst_34175 = inst_34194;
var inst_34176 = inst_34193;
var inst_34177 = inst_34195;
var inst_34178 = (0);
var state_34223__$1 = (function (){var statearr_34242 = state_34223;
(statearr_34242[(8)] = inst_34175);

(statearr_34242[(10)] = inst_34178);

(statearr_34242[(11)] = inst_34176);

(statearr_34242[(12)] = inst_34177);

return statearr_34242;
})();
var statearr_34243_34276 = state_34223__$1;
(statearr_34243_34276[(2)] = null);

(statearr_34243_34276[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (3))){
var inst_34221 = (state_34223[(2)]);
var state_34223__$1 = state_34223;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34223__$1,inst_34221);
} else {
if((state_val_34224 === (12))){
var inst_34209 = (state_34223[(2)]);
var state_34223__$1 = state_34223;
var statearr_34244_34277 = state_34223__$1;
(statearr_34244_34277[(2)] = inst_34209);

(statearr_34244_34277[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (2))){
var state_34223__$1 = state_34223;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34223__$1,(4),in$);
} else {
if((state_val_34224 === (23))){
var inst_34217 = (state_34223[(2)]);
var state_34223__$1 = state_34223;
var statearr_34245_34278 = state_34223__$1;
(statearr_34245_34278[(2)] = inst_34217);

(statearr_34245_34278[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (19))){
var inst_34204 = (state_34223[(2)]);
var state_34223__$1 = state_34223;
var statearr_34246_34279 = state_34223__$1;
(statearr_34246_34279[(2)] = inst_34204);

(statearr_34246_34279[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (11))){
var inst_34175 = (state_34223[(8)]);
var inst_34189 = (state_34223[(7)]);
var inst_34189__$1 = cljs.core.seq(inst_34175);
var state_34223__$1 = (function (){var statearr_34247 = state_34223;
(statearr_34247[(7)] = inst_34189__$1);

return statearr_34247;
})();
if(inst_34189__$1){
var statearr_34248_34280 = state_34223__$1;
(statearr_34248_34280[(1)] = (14));

} else {
var statearr_34249_34281 = state_34223__$1;
(statearr_34249_34281[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (9))){
var inst_34211 = (state_34223[(2)]);
var inst_34212 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_34223__$1 = (function (){var statearr_34250 = state_34223;
(statearr_34250[(15)] = inst_34211);

return statearr_34250;
})();
if(cljs.core.truth_(inst_34212)){
var statearr_34251_34282 = state_34223__$1;
(statearr_34251_34282[(1)] = (21));

} else {
var statearr_34252_34283 = state_34223__$1;
(statearr_34252_34283[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (5))){
var inst_34167 = cljs.core.async.close_BANG_(out);
var state_34223__$1 = state_34223;
var statearr_34253_34284 = state_34223__$1;
(statearr_34253_34284[(2)] = inst_34167);

(statearr_34253_34284[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (14))){
var inst_34189 = (state_34223[(7)]);
var inst_34191 = cljs.core.chunked_seq_QMARK_(inst_34189);
var state_34223__$1 = state_34223;
if(inst_34191){
var statearr_34254_34285 = state_34223__$1;
(statearr_34254_34285[(1)] = (17));

} else {
var statearr_34255_34286 = state_34223__$1;
(statearr_34255_34286[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (16))){
var inst_34207 = (state_34223[(2)]);
var state_34223__$1 = state_34223;
var statearr_34256_34287 = state_34223__$1;
(statearr_34256_34287[(2)] = inst_34207);

(statearr_34256_34287[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34224 === (10))){
var inst_34178 = (state_34223[(10)]);
var inst_34176 = (state_34223[(11)]);
var inst_34183 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_34176,inst_34178);
var state_34223__$1 = state_34223;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34223__$1,(13),out,inst_34183);
} else {
if((state_val_34224 === (18))){
var inst_34189 = (state_34223[(7)]);
var inst_34198 = cljs.core.first(inst_34189);
var state_34223__$1 = state_34223;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34223__$1,(20),out,inst_34198);
} else {
if((state_val_34224 === (8))){
var inst_34178 = (state_34223[(10)]);
var inst_34177 = (state_34223[(12)]);
var inst_34180 = (inst_34178 < inst_34177);
var inst_34181 = inst_34180;
var state_34223__$1 = state_34223;
if(cljs.core.truth_(inst_34181)){
var statearr_34257_34288 = state_34223__$1;
(statearr_34257_34288[(1)] = (10));

} else {
var statearr_34258_34289 = state_34223__$1;
(statearr_34258_34289[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto__))
;
return ((function (switch__18696__auto__,c__18808__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__18697__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__18697__auto____0 = (function (){
var statearr_34262 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34262[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__18697__auto__);

(statearr_34262[(1)] = (1));

return statearr_34262;
});
var cljs$core$async$mapcat_STAR__$_state_machine__18697__auto____1 = (function (state_34223){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_34223);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e34263){if((e34263 instanceof Object)){
var ex__18700__auto__ = e34263;
var statearr_34264_34290 = state_34223;
(statearr_34264_34290[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34223);

return cljs.core.cst$kw$recur;
} else {
throw e34263;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__34291 = state_34223;
state_34223 = G__34291;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__18697__auto__ = function(state_34223){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__18697__auto____1.call(this,state_34223);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__18697__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__18697__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto__))
})();
var state__18810__auto__ = (function (){var statearr_34265 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_34265[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto__);

return statearr_34265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto__))
);

return c__18808__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args34292 = [];
var len__7651__auto___34295 = arguments.length;
var i__7652__auto___34296 = (0);
while(true){
if((i__7652__auto___34296 < len__7651__auto___34295)){
args34292.push((arguments[i__7652__auto___34296]));

var G__34297 = (i__7652__auto___34296 + (1));
i__7652__auto___34296 = G__34297;
continue;
} else {
}
break;
}

var G__34294 = args34292.length;
switch (G__34294) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34292.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args34299 = [];
var len__7651__auto___34302 = arguments.length;
var i__7652__auto___34303 = (0);
while(true){
if((i__7652__auto___34303 < len__7651__auto___34302)){
args34299.push((arguments[i__7652__auto___34303]));

var G__34304 = (i__7652__auto___34303 + (1));
i__7652__auto___34303 = G__34304;
continue;
} else {
}
break;
}

var G__34301 = args34299.length;
switch (G__34301) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34299.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args34306 = [];
var len__7651__auto___34357 = arguments.length;
var i__7652__auto___34358 = (0);
while(true){
if((i__7652__auto___34358 < len__7651__auto___34357)){
args34306.push((arguments[i__7652__auto___34358]));

var G__34359 = (i__7652__auto___34358 + (1));
i__7652__auto___34358 = G__34359;
continue;
} else {
}
break;
}

var G__34308 = args34306.length;
switch (G__34308) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34306.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__18808__auto___34361 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___34361,out){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___34361,out){
return (function (state_34332){
var state_val_34333 = (state_34332[(1)]);
if((state_val_34333 === (7))){
var inst_34327 = (state_34332[(2)]);
var state_34332__$1 = state_34332;
var statearr_34334_34362 = state_34332__$1;
(statearr_34334_34362[(2)] = inst_34327);

(statearr_34334_34362[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34333 === (1))){
var inst_34309 = null;
var state_34332__$1 = (function (){var statearr_34335 = state_34332;
(statearr_34335[(7)] = inst_34309);

return statearr_34335;
})();
var statearr_34336_34363 = state_34332__$1;
(statearr_34336_34363[(2)] = null);

(statearr_34336_34363[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34333 === (4))){
var inst_34312 = (state_34332[(8)]);
var inst_34312__$1 = (state_34332[(2)]);
var inst_34313 = (inst_34312__$1 == null);
var inst_34314 = cljs.core.not(inst_34313);
var state_34332__$1 = (function (){var statearr_34337 = state_34332;
(statearr_34337[(8)] = inst_34312__$1);

return statearr_34337;
})();
if(inst_34314){
var statearr_34338_34364 = state_34332__$1;
(statearr_34338_34364[(1)] = (5));

} else {
var statearr_34339_34365 = state_34332__$1;
(statearr_34339_34365[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34333 === (6))){
var state_34332__$1 = state_34332;
var statearr_34340_34366 = state_34332__$1;
(statearr_34340_34366[(2)] = null);

(statearr_34340_34366[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34333 === (3))){
var inst_34329 = (state_34332[(2)]);
var inst_34330 = cljs.core.async.close_BANG_(out);
var state_34332__$1 = (function (){var statearr_34341 = state_34332;
(statearr_34341[(9)] = inst_34329);

return statearr_34341;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34332__$1,inst_34330);
} else {
if((state_val_34333 === (2))){
var state_34332__$1 = state_34332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34332__$1,(4),ch);
} else {
if((state_val_34333 === (11))){
var inst_34312 = (state_34332[(8)]);
var inst_34321 = (state_34332[(2)]);
var inst_34309 = inst_34312;
var state_34332__$1 = (function (){var statearr_34342 = state_34332;
(statearr_34342[(10)] = inst_34321);

(statearr_34342[(7)] = inst_34309);

return statearr_34342;
})();
var statearr_34343_34367 = state_34332__$1;
(statearr_34343_34367[(2)] = null);

(statearr_34343_34367[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34333 === (9))){
var inst_34312 = (state_34332[(8)]);
var state_34332__$1 = state_34332;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34332__$1,(11),out,inst_34312);
} else {
if((state_val_34333 === (5))){
var inst_34312 = (state_34332[(8)]);
var inst_34309 = (state_34332[(7)]);
var inst_34316 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34312,inst_34309);
var state_34332__$1 = state_34332;
if(inst_34316){
var statearr_34345_34368 = state_34332__$1;
(statearr_34345_34368[(1)] = (8));

} else {
var statearr_34346_34369 = state_34332__$1;
(statearr_34346_34369[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34333 === (10))){
var inst_34324 = (state_34332[(2)]);
var state_34332__$1 = state_34332;
var statearr_34347_34370 = state_34332__$1;
(statearr_34347_34370[(2)] = inst_34324);

(statearr_34347_34370[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34333 === (8))){
var inst_34309 = (state_34332[(7)]);
var tmp34344 = inst_34309;
var inst_34309__$1 = tmp34344;
var state_34332__$1 = (function (){var statearr_34348 = state_34332;
(statearr_34348[(7)] = inst_34309__$1);

return statearr_34348;
})();
var statearr_34349_34371 = state_34332__$1;
(statearr_34349_34371[(2)] = null);

(statearr_34349_34371[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto___34361,out))
;
return ((function (switch__18696__auto__,c__18808__auto___34361,out){
return (function() {
var cljs$core$async$state_machine__18697__auto__ = null;
var cljs$core$async$state_machine__18697__auto____0 = (function (){
var statearr_34353 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34353[(0)] = cljs$core$async$state_machine__18697__auto__);

(statearr_34353[(1)] = (1));

return statearr_34353;
});
var cljs$core$async$state_machine__18697__auto____1 = (function (state_34332){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_34332);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e34354){if((e34354 instanceof Object)){
var ex__18700__auto__ = e34354;
var statearr_34355_34372 = state_34332;
(statearr_34355_34372[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34332);

return cljs.core.cst$kw$recur;
} else {
throw e34354;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__34373 = state_34332;
state_34332 = G__34373;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$state_machine__18697__auto__ = function(state_34332){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18697__auto____1.call(this,state_34332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18697__auto____0;
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18697__auto____1;
return cljs$core$async$state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___34361,out))
})();
var state__18810__auto__ = (function (){var statearr_34356 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_34356[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___34361);

return statearr_34356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___34361,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args34374 = [];
var len__7651__auto___34444 = arguments.length;
var i__7652__auto___34445 = (0);
while(true){
if((i__7652__auto___34445 < len__7651__auto___34444)){
args34374.push((arguments[i__7652__auto___34445]));

var G__34446 = (i__7652__auto___34445 + (1));
i__7652__auto___34445 = G__34446;
continue;
} else {
}
break;
}

var G__34376 = args34374.length;
switch (G__34376) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34374.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__18808__auto___34448 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___34448,out){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___34448,out){
return (function (state_34414){
var state_val_34415 = (state_34414[(1)]);
if((state_val_34415 === (7))){
var inst_34410 = (state_34414[(2)]);
var state_34414__$1 = state_34414;
var statearr_34416_34449 = state_34414__$1;
(statearr_34416_34449[(2)] = inst_34410);

(statearr_34416_34449[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34415 === (1))){
var inst_34377 = (new Array(n));
var inst_34378 = inst_34377;
var inst_34379 = (0);
var state_34414__$1 = (function (){var statearr_34417 = state_34414;
(statearr_34417[(7)] = inst_34379);

(statearr_34417[(8)] = inst_34378);

return statearr_34417;
})();
var statearr_34418_34450 = state_34414__$1;
(statearr_34418_34450[(2)] = null);

(statearr_34418_34450[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34415 === (4))){
var inst_34382 = (state_34414[(9)]);
var inst_34382__$1 = (state_34414[(2)]);
var inst_34383 = (inst_34382__$1 == null);
var inst_34384 = cljs.core.not(inst_34383);
var state_34414__$1 = (function (){var statearr_34419 = state_34414;
(statearr_34419[(9)] = inst_34382__$1);

return statearr_34419;
})();
if(inst_34384){
var statearr_34420_34451 = state_34414__$1;
(statearr_34420_34451[(1)] = (5));

} else {
var statearr_34421_34452 = state_34414__$1;
(statearr_34421_34452[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34415 === (15))){
var inst_34404 = (state_34414[(2)]);
var state_34414__$1 = state_34414;
var statearr_34422_34453 = state_34414__$1;
(statearr_34422_34453[(2)] = inst_34404);

(statearr_34422_34453[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34415 === (13))){
var state_34414__$1 = state_34414;
var statearr_34423_34454 = state_34414__$1;
(statearr_34423_34454[(2)] = null);

(statearr_34423_34454[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34415 === (6))){
var inst_34379 = (state_34414[(7)]);
var inst_34400 = (inst_34379 > (0));
var state_34414__$1 = state_34414;
if(cljs.core.truth_(inst_34400)){
var statearr_34424_34455 = state_34414__$1;
(statearr_34424_34455[(1)] = (12));

} else {
var statearr_34425_34456 = state_34414__$1;
(statearr_34425_34456[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34415 === (3))){
var inst_34412 = (state_34414[(2)]);
var state_34414__$1 = state_34414;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34414__$1,inst_34412);
} else {
if((state_val_34415 === (12))){
var inst_34378 = (state_34414[(8)]);
var inst_34402 = cljs.core.vec(inst_34378);
var state_34414__$1 = state_34414;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34414__$1,(15),out,inst_34402);
} else {
if((state_val_34415 === (2))){
var state_34414__$1 = state_34414;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34414__$1,(4),ch);
} else {
if((state_val_34415 === (11))){
var inst_34394 = (state_34414[(2)]);
var inst_34395 = (new Array(n));
var inst_34378 = inst_34395;
var inst_34379 = (0);
var state_34414__$1 = (function (){var statearr_34426 = state_34414;
(statearr_34426[(10)] = inst_34394);

(statearr_34426[(7)] = inst_34379);

(statearr_34426[(8)] = inst_34378);

return statearr_34426;
})();
var statearr_34427_34457 = state_34414__$1;
(statearr_34427_34457[(2)] = null);

(statearr_34427_34457[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34415 === (9))){
var inst_34378 = (state_34414[(8)]);
var inst_34392 = cljs.core.vec(inst_34378);
var state_34414__$1 = state_34414;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34414__$1,(11),out,inst_34392);
} else {
if((state_val_34415 === (5))){
var inst_34387 = (state_34414[(11)]);
var inst_34379 = (state_34414[(7)]);
var inst_34378 = (state_34414[(8)]);
var inst_34382 = (state_34414[(9)]);
var inst_34386 = (inst_34378[inst_34379] = inst_34382);
var inst_34387__$1 = (inst_34379 + (1));
var inst_34388 = (inst_34387__$1 < n);
var state_34414__$1 = (function (){var statearr_34428 = state_34414;
(statearr_34428[(11)] = inst_34387__$1);

(statearr_34428[(12)] = inst_34386);

return statearr_34428;
})();
if(cljs.core.truth_(inst_34388)){
var statearr_34429_34458 = state_34414__$1;
(statearr_34429_34458[(1)] = (8));

} else {
var statearr_34430_34459 = state_34414__$1;
(statearr_34430_34459[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34415 === (14))){
var inst_34407 = (state_34414[(2)]);
var inst_34408 = cljs.core.async.close_BANG_(out);
var state_34414__$1 = (function (){var statearr_34432 = state_34414;
(statearr_34432[(13)] = inst_34407);

return statearr_34432;
})();
var statearr_34433_34460 = state_34414__$1;
(statearr_34433_34460[(2)] = inst_34408);

(statearr_34433_34460[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34415 === (10))){
var inst_34398 = (state_34414[(2)]);
var state_34414__$1 = state_34414;
var statearr_34434_34461 = state_34414__$1;
(statearr_34434_34461[(2)] = inst_34398);

(statearr_34434_34461[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34415 === (8))){
var inst_34387 = (state_34414[(11)]);
var inst_34378 = (state_34414[(8)]);
var tmp34431 = inst_34378;
var inst_34378__$1 = tmp34431;
var inst_34379 = inst_34387;
var state_34414__$1 = (function (){var statearr_34435 = state_34414;
(statearr_34435[(7)] = inst_34379);

(statearr_34435[(8)] = inst_34378__$1);

return statearr_34435;
})();
var statearr_34436_34462 = state_34414__$1;
(statearr_34436_34462[(2)] = null);

(statearr_34436_34462[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto___34448,out))
;
return ((function (switch__18696__auto__,c__18808__auto___34448,out){
return (function() {
var cljs$core$async$state_machine__18697__auto__ = null;
var cljs$core$async$state_machine__18697__auto____0 = (function (){
var statearr_34440 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34440[(0)] = cljs$core$async$state_machine__18697__auto__);

(statearr_34440[(1)] = (1));

return statearr_34440;
});
var cljs$core$async$state_machine__18697__auto____1 = (function (state_34414){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_34414);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e34441){if((e34441 instanceof Object)){
var ex__18700__auto__ = e34441;
var statearr_34442_34463 = state_34414;
(statearr_34442_34463[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34414);

return cljs.core.cst$kw$recur;
} else {
throw e34441;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__34464 = state_34414;
state_34414 = G__34464;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$state_machine__18697__auto__ = function(state_34414){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18697__auto____1.call(this,state_34414);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18697__auto____0;
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18697__auto____1;
return cljs$core$async$state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___34448,out))
})();
var state__18810__auto__ = (function (){var statearr_34443 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_34443[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___34448);

return statearr_34443;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___34448,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args34465 = [];
var len__7651__auto___34539 = arguments.length;
var i__7652__auto___34540 = (0);
while(true){
if((i__7652__auto___34540 < len__7651__auto___34539)){
args34465.push((arguments[i__7652__auto___34540]));

var G__34541 = (i__7652__auto___34540 + (1));
i__7652__auto___34540 = G__34541;
continue;
} else {
}
break;
}

var G__34467 = args34465.length;
switch (G__34467) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34465.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__18808__auto___34543 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__18808__auto___34543,out){
return (function (){
var f__18809__auto__ = (function (){var switch__18696__auto__ = ((function (c__18808__auto___34543,out){
return (function (state_34509){
var state_val_34510 = (state_34509[(1)]);
if((state_val_34510 === (7))){
var inst_34505 = (state_34509[(2)]);
var state_34509__$1 = state_34509;
var statearr_34511_34544 = state_34509__$1;
(statearr_34511_34544[(2)] = inst_34505);

(statearr_34511_34544[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34510 === (1))){
var inst_34468 = [];
var inst_34469 = inst_34468;
var inst_34470 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_34509__$1 = (function (){var statearr_34512 = state_34509;
(statearr_34512[(7)] = inst_34470);

(statearr_34512[(8)] = inst_34469);

return statearr_34512;
})();
var statearr_34513_34545 = state_34509__$1;
(statearr_34513_34545[(2)] = null);

(statearr_34513_34545[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34510 === (4))){
var inst_34473 = (state_34509[(9)]);
var inst_34473__$1 = (state_34509[(2)]);
var inst_34474 = (inst_34473__$1 == null);
var inst_34475 = cljs.core.not(inst_34474);
var state_34509__$1 = (function (){var statearr_34514 = state_34509;
(statearr_34514[(9)] = inst_34473__$1);

return statearr_34514;
})();
if(inst_34475){
var statearr_34515_34546 = state_34509__$1;
(statearr_34515_34546[(1)] = (5));

} else {
var statearr_34516_34547 = state_34509__$1;
(statearr_34516_34547[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34510 === (15))){
var inst_34499 = (state_34509[(2)]);
var state_34509__$1 = state_34509;
var statearr_34517_34548 = state_34509__$1;
(statearr_34517_34548[(2)] = inst_34499);

(statearr_34517_34548[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34510 === (13))){
var state_34509__$1 = state_34509;
var statearr_34518_34549 = state_34509__$1;
(statearr_34518_34549[(2)] = null);

(statearr_34518_34549[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34510 === (6))){
var inst_34469 = (state_34509[(8)]);
var inst_34494 = inst_34469.length;
var inst_34495 = (inst_34494 > (0));
var state_34509__$1 = state_34509;
if(cljs.core.truth_(inst_34495)){
var statearr_34519_34550 = state_34509__$1;
(statearr_34519_34550[(1)] = (12));

} else {
var statearr_34520_34551 = state_34509__$1;
(statearr_34520_34551[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34510 === (3))){
var inst_34507 = (state_34509[(2)]);
var state_34509__$1 = state_34509;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34509__$1,inst_34507);
} else {
if((state_val_34510 === (12))){
var inst_34469 = (state_34509[(8)]);
var inst_34497 = cljs.core.vec(inst_34469);
var state_34509__$1 = state_34509;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34509__$1,(15),out,inst_34497);
} else {
if((state_val_34510 === (2))){
var state_34509__$1 = state_34509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34509__$1,(4),ch);
} else {
if((state_val_34510 === (11))){
var inst_34473 = (state_34509[(9)]);
var inst_34477 = (state_34509[(10)]);
var inst_34487 = (state_34509[(2)]);
var inst_34488 = [];
var inst_34489 = inst_34488.push(inst_34473);
var inst_34469 = inst_34488;
var inst_34470 = inst_34477;
var state_34509__$1 = (function (){var statearr_34521 = state_34509;
(statearr_34521[(7)] = inst_34470);

(statearr_34521[(11)] = inst_34489);

(statearr_34521[(12)] = inst_34487);

(statearr_34521[(8)] = inst_34469);

return statearr_34521;
})();
var statearr_34522_34552 = state_34509__$1;
(statearr_34522_34552[(2)] = null);

(statearr_34522_34552[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34510 === (9))){
var inst_34469 = (state_34509[(8)]);
var inst_34485 = cljs.core.vec(inst_34469);
var state_34509__$1 = state_34509;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34509__$1,(11),out,inst_34485);
} else {
if((state_val_34510 === (5))){
var inst_34470 = (state_34509[(7)]);
var inst_34473 = (state_34509[(9)]);
var inst_34477 = (state_34509[(10)]);
var inst_34477__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34473) : f.call(null,inst_34473));
var inst_34478 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34477__$1,inst_34470);
var inst_34479 = cljs.core.keyword_identical_QMARK_(inst_34470,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_34480 = (inst_34478) || (inst_34479);
var state_34509__$1 = (function (){var statearr_34523 = state_34509;
(statearr_34523[(10)] = inst_34477__$1);

return statearr_34523;
})();
if(cljs.core.truth_(inst_34480)){
var statearr_34524_34553 = state_34509__$1;
(statearr_34524_34553[(1)] = (8));

} else {
var statearr_34525_34554 = state_34509__$1;
(statearr_34525_34554[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34510 === (14))){
var inst_34502 = (state_34509[(2)]);
var inst_34503 = cljs.core.async.close_BANG_(out);
var state_34509__$1 = (function (){var statearr_34527 = state_34509;
(statearr_34527[(13)] = inst_34502);

return statearr_34527;
})();
var statearr_34528_34555 = state_34509__$1;
(statearr_34528_34555[(2)] = inst_34503);

(statearr_34528_34555[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34510 === (10))){
var inst_34492 = (state_34509[(2)]);
var state_34509__$1 = state_34509;
var statearr_34529_34556 = state_34509__$1;
(statearr_34529_34556[(2)] = inst_34492);

(statearr_34529_34556[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34510 === (8))){
var inst_34473 = (state_34509[(9)]);
var inst_34477 = (state_34509[(10)]);
var inst_34469 = (state_34509[(8)]);
var inst_34482 = inst_34469.push(inst_34473);
var tmp34526 = inst_34469;
var inst_34469__$1 = tmp34526;
var inst_34470 = inst_34477;
var state_34509__$1 = (function (){var statearr_34530 = state_34509;
(statearr_34530[(7)] = inst_34470);

(statearr_34530[(14)] = inst_34482);

(statearr_34530[(8)] = inst_34469__$1);

return statearr_34530;
})();
var statearr_34531_34557 = state_34509__$1;
(statearr_34531_34557[(2)] = null);

(statearr_34531_34557[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__18808__auto___34543,out))
;
return ((function (switch__18696__auto__,c__18808__auto___34543,out){
return (function() {
var cljs$core$async$state_machine__18697__auto__ = null;
var cljs$core$async$state_machine__18697__auto____0 = (function (){
var statearr_34535 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34535[(0)] = cljs$core$async$state_machine__18697__auto__);

(statearr_34535[(1)] = (1));

return statearr_34535;
});
var cljs$core$async$state_machine__18697__auto____1 = (function (state_34509){
while(true){
var ret_value__18698__auto__ = (function (){try{while(true){
var result__18699__auto__ = switch__18696__auto__(state_34509);
if(cljs.core.keyword_identical_QMARK_(result__18699__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__18699__auto__;
}
break;
}
}catch (e34536){if((e34536 instanceof Object)){
var ex__18700__auto__ = e34536;
var statearr_34537_34558 = state_34509;
(statearr_34537_34558[(5)] = ex__18700__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34509);

return cljs.core.cst$kw$recur;
} else {
throw e34536;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__18698__auto__,cljs.core.cst$kw$recur)){
var G__34559 = state_34509;
state_34509 = G__34559;
continue;
} else {
return ret_value__18698__auto__;
}
break;
}
});
cljs$core$async$state_machine__18697__auto__ = function(state_34509){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__18697__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__18697__auto____1.call(this,state_34509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__18697__auto____0;
cljs$core$async$state_machine__18697__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__18697__auto____1;
return cljs$core$async$state_machine__18697__auto__;
})()
;})(switch__18696__auto__,c__18808__auto___34543,out))
})();
var state__18810__auto__ = (function (){var statearr_34538 = (f__18809__auto__.cljs$core$IFn$_invoke$arity$0 ? f__18809__auto__.cljs$core$IFn$_invoke$arity$0() : f__18809__auto__.call(null));
(statearr_34538[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__18808__auto___34543);

return statearr_34538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__18810__auto__);
});})(c__18808__auto___34543,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

