// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.dataset');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.metadata');
goog.require('milia.utils.remote');
if(typeof milia.api.dataset.type__GT_endpoint !== 'undefined'){
} else {
milia.api.dataset.type__GT_endpoint = (function (){var method_table__7471__auto__ = (function (){var G__31731 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31731) : cljs.core.atom.call(null,G__31731));
})();
var prefer_table__7472__auto__ = (function (){var G__31732 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31732) : cljs.core.atom.call(null,G__31732));
})();
var method_cache__7473__auto__ = (function (){var G__31733 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31733) : cljs.core.atom.call(null,G__31733));
})();
var cached_hierarchy__7474__auto__ = (function (){var G__31734 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31734) : cljs.core.atom.call(null,G__31734));
})();
var hierarchy__7475__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("milia.api.dataset","type->endpoint"),((function (method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__){
return (function() { 
var G__31735__delegate = function (datatype,_){
return datatype;
};
var G__31735 = function (datatype,var_args){
var _ = null;
if (arguments.length > 1) {
var G__31736__i = 0, G__31736__a = new Array(arguments.length -  1);
while (G__31736__i < G__31736__a.length) {G__31736__a[G__31736__i] = arguments[G__31736__i + 1]; ++G__31736__i;}
  _ = new cljs.core.IndexedSeq(G__31736__a,0);
} 
return G__31735__delegate.call(this,datatype,_);};
G__31735.cljs$lang$maxFixedArity = 1;
G__31735.cljs$lang$applyTo = (function (arglist__31737){
var datatype = cljs.core.first(arglist__31737);
var _ = cljs.core.rest(arglist__31737);
return G__31735__delegate(datatype,_);
});
G__31735.cljs$core$IFn$_invoke$arity$variadic = G__31735__delegate;
return G__31735;
})()
;})(method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__))
,cljs.core.cst$kw$default,hierarchy__7475__auto__,method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__));
})();
}
milia.api.dataset.type__GT_endpoint.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function() { 
var G__31741__delegate = function (_,p__31738){
var map__31739 = p__31738;
var map__31739__$1 = ((((!((map__31739 == null)))?((((map__31739.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31739.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31739):map__31739);
var async = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31739__$1,cljs.core.cst$kw$async,true);
if(cljs.core.truth_(async)){
return "forms";
} else {
return "data";
}
};
var G__31741 = function (_,var_args){
var p__31738 = null;
if (arguments.length > 1) {
var G__31742__i = 0, G__31742__a = new Array(arguments.length -  1);
while (G__31742__i < G__31742__a.length) {G__31742__a[G__31742__i] = arguments[G__31742__i + 1]; ++G__31742__i;}
  p__31738 = new cljs.core.IndexedSeq(G__31742__a,0);
} 
return G__31741__delegate.call(this,_,p__31738);};
G__31741.cljs$lang$maxFixedArity = 1;
G__31741.cljs$lang$applyTo = (function (arglist__31743){
var _ = cljs.core.first(arglist__31743);
var p__31738 = cljs.core.rest(arglist__31743);
return G__31741__delegate(_,p__31738);
});
G__31741.cljs$core$IFn$_invoke$arity$variadic = G__31741__delegate;
return G__31741;
})()
);
milia.api.dataset.type__GT_endpoint.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$filtered_DASH_dataset,(function() { 
var G__31744__delegate = function (_,___$1){
return "dataviews";
};
var G__31744 = function (_,var_args){
var ___$1 = null;
if (arguments.length > 1) {
var G__31745__i = 0, G__31745__a = new Array(arguments.length -  1);
while (G__31745__i < G__31745__a.length) {G__31745__a[G__31745__i] = arguments[G__31745__i + 1]; ++G__31745__i;}
  ___$1 = new cljs.core.IndexedSeq(G__31745__a,0);
} 
return G__31744__delegate.call(this,_,___$1);};
G__31744.cljs$lang$maxFixedArity = 1;
G__31744.cljs$lang$applyTo = (function (arglist__31746){
var _ = cljs.core.first(arglist__31746);
var ___$1 = cljs.core.rest(arglist__31746);
return G__31744__delegate(_,___$1);
});
G__31744.cljs$core$IFn$_invoke$arity$variadic = G__31744__delegate;
return G__31744;
})()
);
/**
 * Return all the datasets for an account.
 */
milia.api.dataset.all = (function milia$api$dataset$all(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("forms?owner="),cljs.core.str(username)].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return all public datasets for a specific user.
 */
milia.api.dataset.public$ = (function milia$api$dataset$public(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",username], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Clone the dataset given by ID into the account with the given username.
 */
milia.api.dataset.clone = (function milia$api$dataset$clone(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31753 = arguments.length;
var i__7652__auto___31754 = (0);
while(true){
if((i__7652__auto___31754 < len__7651__auto___31753)){
args__7658__auto__.push((arguments[i__7652__auto___31754]));

var G__31755 = (i__7652__auto___31754 + (1));
i__7652__auto___31754 = G__31755;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,username,p__31750){
var map__31751 = p__31750;
var map__31751__$1 = ((((!((map__31751 == null)))?((((map__31751.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31751.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31751):map__31751);
var project_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31751__$1,cljs.core.cst$kw$project_DASH_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"clone"], 0));
var data_base = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$username,username], null)], null);
var data = (cljs.core.truth_(project_id)?cljs.core.assoc_in(data_base,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form_DASH_params,cljs.core.cst$kw$project_id], null),project_id):data_base);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,data,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});

milia.api.dataset.clone.cljs$lang$maxFixedArity = (2);

milia.api.dataset.clone.cljs$lang$applyTo = (function (seq31747){
var G__31748 = cljs.core.first(seq31747);
var seq31747__$1 = cljs.core.next(seq31747);
var G__31749 = cljs.core.first(seq31747__$1);
var seq31747__$2 = cljs.core.next(seq31747__$1);
return milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic(G__31748,G__31749,seq31747__$2);
});

/**
 * Set the metadata for a dataset using PUT. All parameters must be passed.
 */
milia.api.dataset.update = (function milia$api$dataset$update(dataset_id,params){
if(cljs.core.truth_(chimera.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$created_by,cljs.core.cst$kw$description,cljs.core.cst$kw$downloadable,cljs.core.cst$kw$owner,cljs.core.cst$kw$project,cljs.core.cst$kw$public,cljs.core.cst$kw$public_data,cljs.core.cst$kw$title,cljs.core.cst$kw$uuid], null)))){
} else {
throw (new Error("Assert failed: (has-keys? params [:created_by :description :downloadable :owner :project :public :public_data :title :uuid])"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Update the title of a form
 */
milia.api.dataset.update_form_name = (function milia$api$dataset$update_form_name(dataset_id,params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Return the data associated with a dataset.
 */
milia.api.dataset.data = (function milia$api$dataset$data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31761 = arguments.length;
var i__7652__auto___31762 = (0);
while(true){
if((i__7652__auto___31762 < len__7651__auto___31761)){
args__7658__auto__.push((arguments[i__7652__auto___31762]));

var G__31763 = (i__7652__auto___31762 + (1));
i__7652__auto___31762 = G__31763;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});
goog.exportSymbol('milia.api.dataset.data', milia.api.dataset.data);

milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__31758){
var map__31759 = p__31758;
var map__31759__$1 = ((((!((map__31759 == null)))?((((map__31759.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31759.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31759):map__31759);
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31759__$1,cljs.core.cst$kw$format);
var raw_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31759__$1,cljs.core.cst$kw$raw_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31759__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31759__$1,cljs.core.cst$kw$accept_DASH_header);
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31759__$1,cljs.core.cst$kw$query_DASH_params);
var data_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31759__$1,cljs.core.cst$kw$data_DASH_id);
var dataset_suffix = (cljs.core.truth_(format)?[cljs.core.str(dataset_id),cljs.core.str((cljs.core.truth_(data_id)?[cljs.core.str("/"),cljs.core.str(data_id)].join(''):null)),cljs.core.str("."),cljs.core.str(format)].join(''):dataset_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_suffix], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,query_params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$raw_DASH_response_QMARK_,raw_QMARK_,cljs.core.cst$kw$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.cst$kw$accept_DASH_header,accept_header], 0));
});

milia.api.dataset.data.cljs$lang$maxFixedArity = (1);

milia.api.dataset.data.cljs$lang$applyTo = (function (seq31756){
var G__31757 = cljs.core.first(seq31756);
var seq31756__$1 = cljs.core.next(seq31756);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic(G__31757,seq31756__$1);
});

/**
 * Retrieve a record from the dataset.
 */
milia.api.dataset.record = (function milia$api$dataset$record(dataset_id,record_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,record_id], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Returns tags for a dataset
 */
milia.api.dataset.tags = (function milia$api$dataset$tags(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"labels"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add tags to a dataset
 */
milia.api.dataset.add_tags = (function milia$api$dataset$add_tags(dataset_id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"labels"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,tags], null)], 0));
});
/**
 * Return filename taking format special cases into account.
 */
milia.api.dataset.filename_for_format = (function milia$api$dataset$filename_for_format(dataset_id,format){
return [cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(format,"csvzip"))?"zip":format))].join('');
});
/**
 * Return options needed to handle format.
 */
milia.api.dataset.options_for_format = (function milia$api$dataset$options_for_format(format){
if(cljs.core.truth_(chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["csvzip","sav","xls","xlsx","zip"], null),format))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
if(typeof milia.api.dataset.type__GT_download_path !== 'undefined'){
} else {
milia.api.dataset.type__GT_download_path = (function (){var method_table__7471__auto__ = (function (){var G__31764 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31764) : cljs.core.atom.call(null,G__31764));
})();
var prefer_table__7472__auto__ = (function (){var G__31765 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31765) : cljs.core.atom.call(null,G__31765));
})();
var method_cache__7473__auto__ = (function (){var G__31766 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31766) : cljs.core.atom.call(null,G__31766));
})();
var cached_hierarchy__7474__auto__ = (function (){var G__31767 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__31767) : cljs.core.atom.call(null,G__31767));
})();
var hierarchy__7475__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("milia.api.dataset","type->download-path"),((function (method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__){
return (function() { 
var G__31768__delegate = function (datatype,_){
return datatype;
};
var G__31768 = function (datatype,var_args){
var _ = null;
if (arguments.length > 1) {
var G__31769__i = 0, G__31769__a = new Array(arguments.length -  1);
while (G__31769__i < G__31769__a.length) {G__31769__a[G__31769__i] = arguments[G__31769__i + 1]; ++G__31769__i;}
  _ = new cljs.core.IndexedSeq(G__31769__a,0);
} 
return G__31768__delegate.call(this,datatype,_);};
G__31768.cljs$lang$maxFixedArity = 1;
G__31768.cljs$lang$applyTo = (function (arglist__31770){
var datatype = cljs.core.first(arglist__31770);
var _ = cljs.core.rest(arglist__31770);
return G__31768__delegate(datatype,_);
});
G__31768.cljs$core$IFn$_invoke$arity$variadic = G__31768__delegate;
return G__31768;
})()
;})(method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__))
,cljs.core.cst$kw$default,hierarchy__7475__auto__,method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__));
})();
}
milia.api.dataset.type__GT_download_path.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,dataset_id,format,export_options){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(format),cljs.core.str((cljs.core.truth_(export_options)?[cljs.core.str("?"),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",(function (){var iter__7326__auto__ = (function milia$api$dataset$iter__31771(s__31772){
return (new cljs.core.LazySeq(null,(function (){
var s__31772__$1 = s__31772;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__31772__$1);
if(temp__4657__auto__){
var s__31772__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__31772__$2)){
var c__7324__auto__ = cljs.core.chunk_first(s__31772__$2);
var size__7325__auto__ = cljs.core.count(c__7324__auto__);
var b__31774 = cljs.core.chunk_buffer(size__7325__auto__);
if((function (){var i__31773 = (0);
while(true){
if((i__31773 < size__7325__auto__)){
var vec__31783 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7324__auto__,i__31773);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31783,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31783,(1),null);
cljs.core.chunk_append(b__31774,[cljs.core.str(cljs.core.name(option)),cljs.core.str("="),cljs.core.str(val)].join(''));

var G__31789 = (i__31773 + (1));
i__31773 = G__31789;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__31774),milia$api$dataset$iter__31771(cljs.core.chunk_rest(s__31772__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__31774),null);
}
} else {
var vec__31786 = cljs.core.first(s__31772__$2);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31786,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31786,(1),null);
return cljs.core.cons([cljs.core.str(cljs.core.name(option)),cljs.core.str("="),cljs.core.str(val)].join(''),milia$api$dataset$iter__31771(cljs.core.rest(s__31772__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7326__auto__(export_options);
})()))].join(''):null))].join('')], null);
}));
milia.api.dataset.type__GT_download_path.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$filtered_DASH_dataset,(function (_,dataset_id,format,export_options){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dataset_id,[cljs.core.str("data."),cljs.core.str(format)].join('')], null);
}));
/**
 * Download form data in specified format. The synchronicity here refers to the
 * server side. This will still return a channel, not data, in CLJS.
 * The options map (last parameter) has the following keys:
 * :accept-header Defaults to application/json
 * :submission-id The id of the submission whose data the client requires. The
 *  function returns data for all submissions if this is not provided.
 * :dataview? Boolean flag indicating whether the data belongs to a filtered
 *  dataview
 */
milia.api.dataset.download_synchronously = (function milia$api$dataset$download_synchronously(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31796 = arguments.length;
var i__7652__auto___31797 = (0);
while(true){
if((i__7652__auto___31797 < len__7651__auto___31796)){
args__7658__auto__.push((arguments[i__7652__auto___31797]));

var G__31798 = (i__7652__auto___31797 + (1));
i__7652__auto___31797 = G__31798;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,format,p__31793){
var map__31794 = p__31793;
var map__31794__$1 = ((((!((map__31794 == null)))?((((map__31794.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31794.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31794):map__31794);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31794__$1,cljs.core.cst$kw$accept_DASH_header);
var submission_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31794__$1,cljs.core.cst$kw$submission_DASH_id);
var dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31794__$1,cljs.core.cst$kw$dataview_QMARK_);
var url = (cljs.core.truth_(dataview_QMARK_)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataset_id,[cljs.core.str("data."),cljs.core.str(format)].join('')], 0)):(cljs.core.truth_(submission_id)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,[cljs.core.str(submission_id),cljs.core.str("."),cljs.core.str(format)].join('')], 0)):milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",[cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(format)].join('')], 0))
));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$http_DASH_options,milia.api.dataset.options_for_format(format)], 0));
});

milia.api.dataset.download_synchronously.cljs$lang$maxFixedArity = (2);

milia.api.dataset.download_synchronously.cljs$lang$applyTo = (function (seq31790){
var G__31791 = cljs.core.first(seq31790);
var seq31790__$1 = cljs.core.next(seq31790);
var G__31792 = cljs.core.first(seq31790__$1);
var seq31790__$2 = cljs.core.next(seq31790__$1);
return milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic(G__31791,G__31792,seq31790__$2);
});

/**
 * Download form as JSON string or file in specified format if format passed.
 */
milia.api.dataset.form = (function milia$api$dataset$form(var_args){
var args31799 = [];
var len__7651__auto___31802 = arguments.length;
var i__7652__auto___31803 = (0);
while(true){
if((i__7652__auto___31803 < len__7651__auto___31802)){
args31799.push((arguments[i__7652__auto___31803]));

var G__31804 = (i__7652__auto___31803 + (1));
i__7652__auto___31803 = G__31804;
continue;
} else {
}
break;
}

var G__31801 = args31799.length;
switch (G__31801) {
case 1:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31799.length)].join('')));

}
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"form.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,format){
var suffix = [cljs.core.str("form."),cljs.core.str(format)].join('');
var options = milia.api.dataset.options_for_format(format);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,suffix], 0));
var filename = [cljs.core.str(dataset_id),cljs.core.str("_"),cljs.core.str(suffix)].join('');
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$filename,filename], 0));
});

milia.api.dataset.form.cljs$lang$maxFixedArity = 2;

/**
 * Show dataset metadata.
 */
milia.api.dataset.metadata = (function milia$api$dataset$metadata(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31811 = arguments.length;
var i__7652__auto___31812 = (0);
while(true){
if((i__7652__auto___31812 < len__7651__auto___31811)){
args__7658__auto__.push((arguments[i__7652__auto___31812]));

var G__31813 = (i__7652__auto___31812 + (1));
i__7652__auto___31812 = G__31813;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__31808){
var map__31809 = p__31808;
var map__31809__$1 = ((((!((map__31809 == null)))?((((map__31809.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31809.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31809):map__31809);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31809__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",[cljs.core.str(dataset_id),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.dataset.metadata.cljs$lang$maxFixedArity = (1);

milia.api.dataset.metadata.cljs$lang$applyTo = (function (seq31806){
var G__31807 = cljs.core.first(seq31806);
var seq31806__$1 = cljs.core.next(seq31806);
return milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic(G__31807,seq31806__$1);
});

/**
 * Return link to online data entry.
 */
milia.api.dataset.online_data_entry_link = (function milia$api$dataset$online_data_entry_link(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"enketo"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return link to online data entry.
 */
milia.api.dataset.edit_link = (function milia$api$dataset$edit_link(username,project_id,dataset_id,instance_id){
var return_url = milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([username,project_id,dataset_id,"submission-editing-complete"], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,instance_id,[cljs.core.str("enketo?return_url="),cljs.core.str(return_url)].join('')], 0));
return cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(milia.api.http.parse_http(cljs.core.cst$kw$get,url));
});
/**
 * Delete a dataset by ID.
 */
milia.api.dataset.delete$ = (function milia$api$dataset$delete(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"delete_async"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Move a dataset to a project use account if no owner passed.
 */
milia.api.dataset.move_to_project = (function milia$api$dataset$move_to_project(dataset_id,project_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id,"forms"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$formid,dataset_id], null)], null)], 0));
});
/**
 * Set a new form owner
 */
milia.api.dataset.new_form_owner = (function milia$api$dataset$new_form_owner(dataset_id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",new_owner], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,new_owner__$1], null)], null)], 0));
});
/**
 * Share dataset with specific user
 */
milia.api.dataset.update_sharing = (function milia$api$dataset$update_sharing(dataset_id,username,role){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"share"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$role,role], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null)], 0));
});
/**
 * Link xform or dataview as media
 */
milia.api.dataset.link_xform_or_dataview_as_media = (function milia$api$dataset$link_xform_or_dataview_as_media(object_type,object_id,media_filename,xform_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata"], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"media",cljs.core.cst$kw$data_value,[cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [object_type,object_id,media_filename], null)))].join(''),cljs.core.cst$kw$xform,xform_id], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Add xls report link to dataset
 */
milia.api.dataset.add_xls_report = (function milia$api$dataset$add_xls_report(dataset_id,uuid,filename){
var xls_url = milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["xls",uuid], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata"], 0));
var data = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_type,"external_export",cljs.core.cst$kw$data_value,[cljs.core.str(filename),cljs.core.str("|"),cljs.core.str(xls_url)].join('')], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null)], 0));
});
/**
 * Download xls report from the j2x service
 */
milia.api.dataset.download_xls_report = (function milia$api$dataset$download_xls_report(var_args){
var args31814 = [];
var len__7651__auto___31817 = arguments.length;
var i__7652__auto___31818 = (0);
while(true){
if((i__7652__auto___31818 < len__7651__auto___31817)){
args31814.push((arguments[i__7652__auto___31818]));

var G__31819 = (i__7652__auto___31818 + (1));
i__7652__auto___31818 = G__31819;
continue;
} else {
}
break;
}

var G__31816 = args31814.length;
switch (G__31816) {
case 3:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31814.length)].join('')));

}
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3 = (function (dataset_id,meta_id,filename){
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4(dataset_id,meta_id,filename,null);
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4 = (function (dataset_id,meta_id,filename,data_id){
var suffix = (cljs.core.truth_(data_id)?[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id),cljs.core.str("&data_id="),cljs.core.str(data_id)].join(''):[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id)].join(''));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",suffix], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$filename,filename], 0));
});

milia.api.dataset.download_xls_report.cljs$lang$maxFixedArity = 4;

/**
 * Returns a submission's edit history
 */
milia.api.dataset.edit_history = (function milia$api$dataset$edit_history(dataset_id,instance_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,instance_id,"history"], 0)));
});
milia.api.dataset.files = (function milia$api$dataset$files(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31827 = arguments.length;
var i__7652__auto___31828 = (0);
while(true){
if((i__7652__auto___31828 < len__7651__auto___31827)){
args__7658__auto__.push((arguments[i__7652__auto___31828]));

var G__31829 = (i__7652__auto___31828 + (1));
i__7652__auto___31828 = G__31829;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic = (function (instance_id,project_id,p__31824){
var map__31825 = p__31824;
var map__31825__$1 = ((((!((map__31825 == null)))?((((map__31825.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31825.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31825):map__31825);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31825__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31825__$1,cljs.core.cst$kw$dataset_DASH_id);
var extra_params = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$project,project_id], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$xform,dataset_id], null));
return milia.utils.metadata.metadata_files.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$instance,instance_id,no_cache_QMARK_,cljs.core.array_seq([cljs.core.cst$kw$extra_DASH_params,extra_params], 0));
});

milia.api.dataset.files.cljs$lang$maxFixedArity = (2);

milia.api.dataset.files.cljs$lang$applyTo = (function (seq31821){
var G__31822 = cljs.core.first(seq31821);
var seq31821__$1 = cljs.core.next(seq31821);
var G__31823 = cljs.core.first(seq31821__$1);
var seq31821__$2 = cljs.core.next(seq31821__$1);
return milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic(G__31822,G__31823,seq31821__$2);
});

/**
 * Integer Integer String String -> Channel HttpResponse
 */
milia.api.dataset.update_xform_meta_permissions = (function milia$api$dataset$update_xform_meta_permissions(dataset_id,metadata_id,editor_meta_role,dataentry_meta_role){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata",metadata_id], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"xform_meta_perms",cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_value,[cljs.core.str(editor_meta_role),cljs.core.str("|"),cljs.core.str(dataentry_meta_role)].join('')], null)], null)], 0));
});
/**
 * Integer String String -> Channel HttpResponse
 */
milia.api.dataset.create_xform_meta_permissions = (function milia$api$dataset$create_xform_meta_permissions(dataset_id,editor_meta_role,dataentry_meta_role){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"xform_meta_perms",cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_value,[cljs.core.str(editor_meta_role),cljs.core.str("|"),cljs.core.str(dataentry_meta_role)].join('')], null)], null)], 0));
});
