// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.widgets');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * The Ona API expects clients to submit a URL as the value of the object bound
 * to a widget. This is basically asking clients to be aware of internal API
 * implementation details since this is a Django REST framework peculiarity.
 * This function provides an abstraction that allows Clojure based clients to
 * be ignorant of the quirk.
 * `content-type` can be either :form or :dataview
 * `content-id` is an integer identifying the object
 */
milia.api.widgets.generate_content_object_url = (function milia$api$widgets$generate_content_object_url(content_type,content_id){
return milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(function (){var G__31354 = (((content_type instanceof cljs.core.Keyword))?content_type.fqn:null);
switch (G__31354) {
case "form":
return "forms";

break;
case "dataview":
return "dataviews";

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(content_type)].join('')));

}
})(),content_id], 0));
});
/**
 * Create a new widget.
 * `widget-definition` is a map containing the following keys:
 *  `:title` is a string
 *  `:content_type` is one of either :form of :dataview
 *  `:content_id` is an intger identifying the content object
 *  `:description` is a string.
 *  `:widget_type` is a string, determined by the client e.g. chart
 *  `:view_type` is a string, determined by the client e.g. bar-chart
 *  `:column` is the  data column to be stored based on the form field.
 *  `:order` this is the position of the widget in relation to others
 *           within the set associated with a form or dataview. Optional.
 *  `:group_by` the data column for the data to be grouped by. Optional
 *  `:aggregation` is the aggregation used while grouping data. Optional.
 *  `:metadata` is a map containing arbitrary key-value pairs.
 */
milia.api.widgets.create = (function milia$api$widgets$create(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31364 = arguments.length;
var i__7652__auto___31365 = (0);
while(true){
if((i__7652__auto___31365 < len__7651__auto___31364)){
args__7658__auto__.push((arguments[i__7652__auto___31365]));

var G__31366 = (i__7652__auto___31365 + (1));
i__7652__auto___31365 = G__31366;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.widgets.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.widgets.create.cljs$core$IFn$_invoke$arity$variadic = (function (p__31358,p__31359){
var map__31360 = p__31358;
var map__31360__$1 = ((((!((map__31360 == null)))?((((map__31360.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31360.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31360):map__31360);
var widget_definition = map__31360__$1;
var content_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31360__$1,cljs.core.cst$kw$content_type);
var content_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31360__$1,cljs.core.cst$kw$content_id);
var map__31361 = p__31359;
var map__31361__$1 = ((((!((map__31361 == null)))?((((map__31361.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31361.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31361):map__31361);
var with_data_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31361__$1,cljs.core.cst$kw$with_DASH_data_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("widgets"),cljs.core.str((cljs.core.truth_(with_data_QMARK_)?"?data=true":null))].join('')], 0));
var processed_widget_definition = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(widget_definition,cljs.core.cst$kw$content_object,milia.api.widgets.generate_content_object_url(content_type,content_id));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,processed_widget_definition], null)], 0));
});

milia.api.widgets.create.cljs$lang$maxFixedArity = (1);

milia.api.widgets.create.cljs$lang$applyTo = (function (seq31356){
var G__31357 = cljs.core.first(seq31356);
var seq31356__$1 = cljs.core.next(seq31356);
return milia.api.widgets.create.cljs$core$IFn$_invoke$arity$variadic(G__31357,seq31356__$1);
});

/**
 * Updates a widget, given the widget ID, and a map of properties to replace
 * existing values for the associated keys
 */
milia.api.widgets.update = (function milia$api$widgets$update(widget_id,patch_map){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["widgets",widget_id], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,patch_map], null)], 0));
});
/**
 * List widgets belonging to a particular user
 * Can optionally be filtered by supplying either a dataview ID or an XForm ID
 * Note that the filters are mutually exclusive
 */
milia.api.widgets.list = (function milia$api$widgets$list(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31371 = arguments.length;
var i__7652__auto___31372 = (0);
while(true){
if((i__7652__auto___31372 < len__7651__auto___31371)){
args__7658__auto__.push((arguments[i__7652__auto___31372]));

var G__31373 = (i__7652__auto___31372 + (1));
i__7652__auto___31372 = G__31373;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.widgets.list.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.widgets.list.cljs$core$IFn$_invoke$arity$variadic = (function (p__31368){
var map__31369 = p__31368;
var map__31369__$1 = ((((!((map__31369 == null)))?((((map__31369.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31369.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31369):map__31369);
var dataview_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31369__$1,cljs.core.cst$kw$dataview_DASH_id);
var xform_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31369__$1,cljs.core.cst$kw$xform_DASH_id);
var with_data_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31369__$1,cljs.core.cst$kw$with_DASH_data_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(dataview_id)?[cljs.core.str("widgets?dataview="),cljs.core.str(dataview_id),cljs.core.str((cljs.core.truth_(with_data_QMARK_)?"&data=true":null))].join(''):(cljs.core.truth_(xform_id)?[cljs.core.str("widgets?xform="),cljs.core.str(xform_id),cljs.core.str((cljs.core.truth_(with_data_QMARK_)?"&data=true":null))].join(''):[cljs.core.str("widgets"),cljs.core.str((cljs.core.truth_(with_data_QMARK_)?"?data=true":null))].join('')
))], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});

milia.api.widgets.list.cljs$lang$maxFixedArity = (0);

milia.api.widgets.list.cljs$lang$applyTo = (function (seq31367){
return milia.api.widgets.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31367));
});

/**
 * Deletes a widget, given a widget id.
 */
milia.api.widgets.delete$ = (function milia$api$widgets$delete(widget_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["widgets",widget_id], 0)));
});
/**
 * Returns specific widget, given the ID
 */
milia.api.widgets.get = (function milia$api$widgets$get(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31379 = arguments.length;
var i__7652__auto___31380 = (0);
while(true){
if((i__7652__auto___31380 < len__7651__auto___31379)){
args__7658__auto__.push((arguments[i__7652__auto___31380]));

var G__31381 = (i__7652__auto___31380 + (1));
i__7652__auto___31380 = G__31381;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.widgets.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.widgets.get.cljs$core$IFn$_invoke$arity$variadic = (function (widget_id,p__31376){
var map__31377 = p__31376;
var map__31377__$1 = ((((!((map__31377 == null)))?((((map__31377.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31377.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31377):map__31377);
var with_data_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31377__$1,cljs.core.cst$kw$with_DASH_data_QMARK_);
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["widgets",[cljs.core.str(widget_id),cljs.core.str((cljs.core.truth_(with_data_QMARK_)?"?data=true":null))].join('')], 0)));
});

milia.api.widgets.get.cljs$lang$maxFixedArity = (1);

milia.api.widgets.get.cljs$lang$applyTo = (function (seq31374){
var G__31375 = cljs.core.first(seq31374);
var seq31374__$1 = cljs.core.next(seq31374);
return milia.api.widgets.get.cljs$core$IFn$_invoke$arity$variadic(G__31375,seq31374__$1);
});

