// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.retry');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('cljs.core.async');
goog.require('milia.api.http');
milia.utils.retry.default_max_retries = (1);
milia.utils.retry.default_retry_for_statuses = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(502),(503),(504)], null);
milia.utils.retry.initial_polling_interval = (1000);
milia.utils.retry.retry_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$max_DASH_retries,cljs.core.cst$kw$retry_DASH_for_DASH_statuses], null);
/**
 * Retry if a status code in retry-for-statuses is returned. Pauses for an
 * exponentially backedoff initial-polling-interval in ClojureScript. Does not
 * pause between retries in Clojure.
 */
milia.utils.retry.retry_parse_http = (function milia$utils$retry$retry_parse_http(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31499 = arguments.length;
var i__7652__auto___31500 = (0);
while(true){
if((i__7652__auto___31500 < len__7651__auto___31499)){
args__7658__auto__.push((arguments[i__7652__auto___31500]));

var G__31501 = (i__7652__auto___31500 + (1));
i__7652__auto___31500 = G__31501;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__31412){
var map__31413 = p__31412;
var map__31413__$1 = ((((!((map__31413 == null)))?((((map__31413.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31413.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31413):map__31413);
var options = map__31413__$1;
var max_retries = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31413__$1,cljs.core.cst$kw$max_DASH_retries,milia.utils.retry.default_max_retries);
var retry_for_statuses = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31413__$1,cljs.core.cst$kw$retry_DASH_for_DASH_statuses,milia.utils.retry.default_retry_for_statuses);
var c__19294__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19294__auto__,map__31413,map__31413__$1,options,max_retries,retry_for_statuses){
return (function (){
var f__19295__auto__ = (function (){var switch__19182__auto__ = ((function (c__19294__auto__,map__31413,map__31413__$1,options,max_retries,retry_for_statuses){
return (function (state_31464){
var state_val_31465 = (state_31464[(1)]);
if((state_val_31465 === (7))){
var inst_31438 = (state_31464[(2)]);
var state_31464__$1 = state_31464;
if(cljs.core.truth_(inst_31438)){
var statearr_31466_31502 = state_31464__$1;
(statearr_31466_31502[(1)] = (11));

} else {
var statearr_31467_31503 = state_31464__$1;
(statearr_31467_31503[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (20))){
var inst_31416 = (state_31464[(7)]);
var inst_31415 = (state_31464[(8)]);
var inst_31454 = (state_31464[(2)]);
var inst_31455 = (inst_31415 * (2));
var inst_31456 = (inst_31416 + (1));
var inst_31415__$1 = inst_31455;
var inst_31416__$1 = inst_31456;
var state_31464__$1 = (function (){var statearr_31468 = state_31464;
(statearr_31468[(9)] = inst_31454);

(statearr_31468[(7)] = inst_31416__$1);

(statearr_31468[(8)] = inst_31415__$1);

return statearr_31468;
})();
var statearr_31469_31504 = state_31464__$1;
(statearr_31469_31504[(2)] = null);

(statearr_31469_31504[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (1))){
var inst_31415 = milia.utils.retry.initial_polling_interval;
var inst_31416 = (0);
var state_31464__$1 = (function (){var statearr_31470 = state_31464;
(statearr_31470[(7)] = inst_31416);

(statearr_31470[(8)] = inst_31415);

return statearr_31470;
})();
var statearr_31471_31505 = state_31464__$1;
(statearr_31471_31505[(2)] = null);

(statearr_31471_31505[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (4))){
var inst_31422 = (state_31464[(10)]);
var inst_31422__$1 = (state_31464[(2)]);
var inst_31424 = (inst_31422__$1 == null);
var inst_31425 = cljs.core.not(inst_31424);
var state_31464__$1 = (function (){var statearr_31472 = state_31464;
(statearr_31472[(10)] = inst_31422__$1);

return statearr_31472;
})();
if(inst_31425){
var statearr_31473_31506 = state_31464__$1;
(statearr_31473_31506[(1)] = (5));

} else {
var statearr_31474_31507 = state_31464__$1;
(statearr_31474_31507[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (15))){
var inst_31445 = (state_31464[(11)]);
var state_31464__$1 = state_31464;
var statearr_31475_31508 = state_31464__$1;
(statearr_31475_31508[(2)] = inst_31445);

(statearr_31475_31508[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (13))){
var inst_31445 = (state_31464[(11)]);
var inst_31443 = (state_31464[(12)]);
var inst_31443__$1 = (state_31464[(2)]);
var inst_31444 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31443__$1,cljs.core.cst$kw$status);
var inst_31445__$1 = chimera.seq.in_QMARK_(retry_for_statuses,inst_31444);
var state_31464__$1 = (function (){var statearr_31476 = state_31464;
(statearr_31476[(11)] = inst_31445__$1);

(statearr_31476[(12)] = inst_31443__$1);

return statearr_31476;
})();
if(cljs.core.truth_(inst_31445__$1)){
var statearr_31477_31509 = state_31464__$1;
(statearr_31477_31509[(1)] = (14));

} else {
var statearr_31478_31510 = state_31464__$1;
(statearr_31478_31510[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (6))){
var state_31464__$1 = state_31464;
var statearr_31479_31511 = state_31464__$1;
(statearr_31479_31511[(2)] = false);

(statearr_31479_31511[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (17))){
var inst_31415 = (state_31464[(8)]);
var inst_31452 = cljs.core.async.timeout(inst_31415);
var state_31464__$1 = state_31464;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31464__$1,(20),inst_31452);
} else {
if((state_val_31465 === (3))){
var inst_31462 = (state_31464[(2)]);
var state_31464__$1 = state_31464;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31464__$1,inst_31462);
} else {
if((state_val_31465 === (12))){
var inst_31422 = (state_31464[(10)]);
var state_31464__$1 = state_31464;
var statearr_31480_31512 = state_31464__$1;
(statearr_31480_31512[(2)] = inst_31422);

(statearr_31480_31512[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (2))){
var inst_31419 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,options,milia.utils.retry.retry_keys);
var inst_31420 = chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(milia.api.http.parse_http,cljs.core.array_seq([method,url,inst_31419], 0));
var state_31464__$1 = state_31464;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31464__$1,(4),inst_31420);
} else {
if((state_val_31465 === (19))){
var inst_31460 = (state_31464[(2)]);
var state_31464__$1 = state_31464;
var statearr_31481_31513 = state_31464__$1;
(statearr_31481_31513[(2)] = inst_31460);

(statearr_31481_31513[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (11))){
var inst_31422 = (state_31464[(10)]);
var inst_31440 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31422);
var state_31464__$1 = state_31464;
var statearr_31482_31514 = state_31464__$1;
(statearr_31482_31514[(2)] = inst_31440);

(statearr_31482_31514[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (9))){
var state_31464__$1 = state_31464;
var statearr_31483_31515 = state_31464__$1;
(statearr_31483_31515[(2)] = false);

(statearr_31483_31515[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (5))){
var inst_31422 = (state_31464[(10)]);
var inst_31427 = inst_31422.cljs$lang$protocol_mask$partition0$;
var inst_31428 = (inst_31427 & (64));
var inst_31429 = inst_31422.cljs$core$ISeq$;
var inst_31430 = (cljs.core.PROTOCOL_SENTINEL === inst_31429);
var inst_31431 = (inst_31428) || (inst_31430);
var state_31464__$1 = state_31464;
if(cljs.core.truth_(inst_31431)){
var statearr_31484_31516 = state_31464__$1;
(statearr_31484_31516[(1)] = (8));

} else {
var statearr_31485_31517 = state_31464__$1;
(statearr_31485_31517[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (14))){
var inst_31416 = (state_31464[(7)]);
var inst_31447 = (inst_31416 < max_retries);
var state_31464__$1 = state_31464;
var statearr_31486_31518 = state_31464__$1;
(statearr_31486_31518[(2)] = inst_31447);

(statearr_31486_31518[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (16))){
var inst_31450 = (state_31464[(2)]);
var state_31464__$1 = state_31464;
if(cljs.core.truth_(inst_31450)){
var statearr_31487_31519 = state_31464__$1;
(statearr_31487_31519[(1)] = (17));

} else {
var statearr_31488_31520 = state_31464__$1;
(statearr_31488_31520[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (10))){
var inst_31435 = (state_31464[(2)]);
var state_31464__$1 = state_31464;
var statearr_31489_31521 = state_31464__$1;
(statearr_31489_31521[(2)] = inst_31435);

(statearr_31489_31521[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (18))){
var inst_31443 = (state_31464[(12)]);
var state_31464__$1 = state_31464;
var statearr_31490_31522 = state_31464__$1;
(statearr_31490_31522[(2)] = inst_31443);

(statearr_31490_31522[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31465 === (8))){
var state_31464__$1 = state_31464;
var statearr_31491_31523 = state_31464__$1;
(statearr_31491_31523[(2)] = true);

(statearr_31491_31523[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19294__auto__,map__31413,map__31413__$1,options,max_retries,retry_for_statuses))
;
return ((function (switch__19182__auto__,c__19294__auto__,map__31413,map__31413__$1,options,max_retries,retry_for_statuses){
return (function() {
var milia$utils$retry$state_machine__19183__auto__ = null;
var milia$utils$retry$state_machine__19183__auto____0 = (function (){
var statearr_31495 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31495[(0)] = milia$utils$retry$state_machine__19183__auto__);

(statearr_31495[(1)] = (1));

return statearr_31495;
});
var milia$utils$retry$state_machine__19183__auto____1 = (function (state_31464){
while(true){
var ret_value__19184__auto__ = (function (){try{while(true){
var result__19185__auto__ = switch__19182__auto__(state_31464);
if(cljs.core.keyword_identical_QMARK_(result__19185__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19185__auto__;
}
break;
}
}catch (e31496){if((e31496 instanceof Object)){
var ex__19186__auto__ = e31496;
var statearr_31497_31524 = state_31464;
(statearr_31497_31524[(5)] = ex__19186__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31464);

return cljs.core.cst$kw$recur;
} else {
throw e31496;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19184__auto__,cljs.core.cst$kw$recur)){
var G__31525 = state_31464;
state_31464 = G__31525;
continue;
} else {
return ret_value__19184__auto__;
}
break;
}
});
milia$utils$retry$state_machine__19183__auto__ = function(state_31464){
switch(arguments.length){
case 0:
return milia$utils$retry$state_machine__19183__auto____0.call(this);
case 1:
return milia$utils$retry$state_machine__19183__auto____1.call(this,state_31464);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$utils$retry$state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$0 = milia$utils$retry$state_machine__19183__auto____0;
milia$utils$retry$state_machine__19183__auto__.cljs$core$IFn$_invoke$arity$1 = milia$utils$retry$state_machine__19183__auto____1;
return milia$utils$retry$state_machine__19183__auto__;
})()
;})(switch__19182__auto__,c__19294__auto__,map__31413,map__31413__$1,options,max_retries,retry_for_statuses))
})();
var state__19296__auto__ = (function (){var statearr_31498 = (f__19295__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19295__auto__.cljs$core$IFn$_invoke$arity$0() : f__19295__auto__.call(null));
(statearr_31498[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19294__auto__);

return statearr_31498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19296__auto__);
});})(c__19294__auto__,map__31413,map__31413__$1,options,max_retries,retry_for_statuses))
);

return c__19294__auto__;
});

milia.utils.retry.retry_parse_http.cljs$lang$maxFixedArity = (2);

milia.utils.retry.retry_parse_http.cljs$lang$applyTo = (function (seq31409){
var G__31410 = cljs.core.first(seq31409);
var seq31409__$1 = cljs.core.next(seq31409);
var G__31411 = cljs.core.first(seq31409__$1);
var seq31409__$2 = cljs.core.next(seq31409__$1);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(G__31410,G__31411,seq31409__$2);
});

