// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('chimera.string');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.dataset');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.export_pending_status_msg = "PENDING";
milia.api.async_export.initial_polling_interval = (5000);
/**
 * If a temp-token is set, add it as a query string parameter. The caller needs
 * to explicity pass a question-mark or ampersand depending on whether this is
 * the first or a subsequenty query parameter.
 */
milia.api.async_export.temp_token_suffix = (function milia$api$async_export$temp_token_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35935 = arguments.length;
var i__7652__auto___35936 = (0);
while(true){
if((i__7652__auto___35936 < len__7651__auto___35935)){
args__7658__auto__.push((arguments[i__7652__auto___35936]));

var G__35937 = (i__7652__auto___35936 + (1));
i__7652__auto___35936 = G__35937;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (s){
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return clojure.string.join.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_((chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token)))?cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.vec(s),"&temp_token=",cljs.core.array_seq([temp_token], 0)):s));
});

milia.api.async_export.temp_token_suffix.cljs$lang$maxFixedArity = (0);

milia.api.async_export.temp_token_suffix.cljs$lang$applyTo = (function (seq35934){
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35934));
});

/**
 * Handles API server's response and acts according to given callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__35938,p__35939){
var map__35948 = p__35938;
var map__35948__$1 = ((((!((map__35948 == null)))?((((map__35948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35948.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35948):map__35948);
var response = map__35948__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35948__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35948__$1,cljs.core.cst$kw$body);
var map__35949 = p__35939;
var map__35949__$1 = ((((!((map__35949 == null)))?((((map__35949.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35949.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35949):map__35949);
var callbacks = map__35949__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35949__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35949__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35949__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35949__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__35952 = body;
var map__35952__$1 = ((((!((map__35952 == null)))?((((map__35952.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35952.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35952):map__35952);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35952__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35952__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35952__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = ((function (map__35952,map__35952__$1,export_url,job_status,job_id,map__35948,map__35948__$1,response,status,body,map__35949,map__35949__$1,callbacks,on_error,on_export_url,on_job_id,on_stop){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});})(map__35952,map__35952__$1,export_url,job_status,job_id,map__35948,map__35948__$1,response,status,body,map__35949,map__35949__$1,callbacks,on_error,on_export_url,on_job_id,on_stop))
;
var error_detail = (function (){var or__6543__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = cljs.core.cst$kw$details.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
if(cljs.core.truth_(is_failed_status_QMARK_())){
return job_status;
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}

} else {
}

if(cljs.core.truth_((function (){var or__6543__auto__ = (status >= (400));
if(or__6543__auto__){
return or__6543__auto__;
} else {
return is_failed_status_QMARK_();
}
})())){
if(cljs.core.fn_QMARK_(on_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(403))){
var G__35954_35956 = error_detail;
var G__35955_35957 = cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(body);
(on_error.cljs$core$IFn$_invoke$arity$2 ? on_error.cljs$core$IFn$_invoke$arity$2(G__35954_35956,G__35955_35957) : on_error.call(null,G__35954_35956,G__35955_35957));
} else {
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
}
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 *  When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___36008 = arguments.length;
var i__7652__auto___36009 = (0);
while(true){
if((i__7652__auto___36009 < len__7651__auto___36008)){
args__7658__auto__.push((arguments[i__7652__auto___36009]));

var G__36010 = (i__7652__auto___36009 + (1));
i__7652__auto___36009 = G__36010;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__35961){
var map__35962 = p__35961;
var map__35962__$1 = ((((!((map__35962 == null)))?((((map__35962.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35962.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35962):map__35962);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35962__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35962__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35962__$1,cljs.core.cst$kw$data_DASH_type);
var c__19292__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto__,map__35962,map__35962__$1,on_error,on_export_url,data_type){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto__,map__35962,map__35962__$1,on_error,on_export_url,data_type){
return (function (state_35990){
var state_val_35991 = (state_35990[(1)]);
if((state_val_35991 === (1))){
var inst_35964 = milia.api.async_export.initial_polling_interval;
var state_35990__$1 = (function (){var statearr_35992 = state_35990;
(statearr_35992[(7)] = inst_35964);

return statearr_35992;
})();
var statearr_35993_36011 = state_35990__$1;
(statearr_35993_36011[(2)] = null);

(statearr_35993_36011[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35991 === (2))){
var inst_35966 = (state_35990[(8)]);
var inst_35968 = (state_35990[(9)]);
var inst_35966__$1 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var inst_35967 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_35968__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_35967,dataset_id,inst_35966__$1], 0));
var inst_35969 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_35968__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_35990__$1 = (function (){var statearr_35994 = state_35990;
(statearr_35994[(8)] = inst_35966__$1);

(statearr_35994[(9)] = inst_35968__$1);

return statearr_35994;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35990__$1,(4),inst_35969);
} else {
if((state_val_35991 === (3))){
var inst_35988 = (state_35990[(2)]);
var state_35990__$1 = state_35990;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35990__$1,inst_35988);
} else {
if((state_val_35991 === (4))){
var inst_35964 = (state_35990[(7)]);
var inst_35966 = (state_35990[(8)]);
var inst_35968 = (state_35990[(9)]);
var inst_35971 = (state_35990[(2)]);
var inst_35972 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_35973 = (function (){var polling_interval = inst_35964;
var job_suffix = inst_35966;
var job_url = inst_35968;
var response = inst_35971;
return ((function (polling_interval,job_suffix,job_url,response,inst_35964,inst_35966,inst_35968,inst_35971,inst_35972,state_val_35991,c__19292__auto__,map__35962,map__35962__$1,on_error,on_export_url,data_type){
return (function (){
return cljs.core.constantly(cljs.core.cst$kw$stop);
});
;})(polling_interval,job_suffix,job_url,response,inst_35964,inst_35966,inst_35968,inst_35971,inst_35972,state_val_35991,c__19292__auto__,map__35962,map__35962__$1,on_error,on_export_url,data_type))
})();
var inst_35974 = [inst_35973,on_error,on_export_url];
var inst_35975 = cljs.core.PersistentHashMap.fromArrays(inst_35972,inst_35974);
var inst_35976 = milia.api.async_export.handle_response(inst_35971,inst_35975);
var inst_35977 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_35976,cljs.core.cst$kw$stop);
var state_35990__$1 = state_35990;
if(inst_35977){
var statearr_35995_36012 = state_35990__$1;
(statearr_35995_36012[(1)] = (5));

} else {
var statearr_35996_36013 = state_35990__$1;
(statearr_35996_36013[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35991 === (5))){
var inst_35964 = (state_35990[(7)]);
var inst_35979 = cljs.core.async.timeout(inst_35964);
var state_35990__$1 = state_35990;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35990__$1,(8),inst_35979);
} else {
if((state_val_35991 === (6))){
var state_35990__$1 = state_35990;
var statearr_35997_36014 = state_35990__$1;
(statearr_35997_36014[(2)] = null);

(statearr_35997_36014[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35991 === (7))){
var inst_35986 = (state_35990[(2)]);
var state_35990__$1 = state_35990;
var statearr_35998_36015 = state_35990__$1;
(statearr_35998_36015[(2)] = inst_35986);

(statearr_35998_36015[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35991 === (8))){
var inst_35964 = (state_35990[(7)]);
var inst_35981 = (state_35990[(2)]);
var inst_35982 = (inst_35964 * (2));
var inst_35964__$1 = inst_35982;
var state_35990__$1 = (function (){var statearr_35999 = state_35990;
(statearr_35999[(7)] = inst_35964__$1);

(statearr_35999[(10)] = inst_35981);

return statearr_35999;
})();
var statearr_36000_36016 = state_35990__$1;
(statearr_36000_36016[(2)] = null);

(statearr_36000_36016[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19292__auto__,map__35962,map__35962__$1,on_error,on_export_url,data_type))
;
return ((function (switch__19180__auto__,c__19292__auto__,map__35962,map__35962__$1,on_error,on_export_url,data_type){
return (function() {
var milia$api$async_export$state_machine__19181__auto__ = null;
var milia$api$async_export$state_machine__19181__auto____0 = (function (){
var statearr_36004 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36004[(0)] = milia$api$async_export$state_machine__19181__auto__);

(statearr_36004[(1)] = (1));

return statearr_36004;
});
var milia$api$async_export$state_machine__19181__auto____1 = (function (state_35990){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_35990);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e36005){if((e36005 instanceof Object)){
var ex__19184__auto__ = e36005;
var statearr_36006_36017 = state_35990;
(statearr_36006_36017[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35990);

return cljs.core.cst$kw$recur;
} else {
throw e36005;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__36018 = state_35990;
state_35990 = G__36018;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19181__auto__ = function(state_35990){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19181__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19181__auto____1.call(this,state_35990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19181__auto____0;
milia$api$async_export$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19181__auto____1;
return milia$api$async_export$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto__,map__35962,map__35962__$1,on_error,on_export_url,data_type))
})();
var state__19294__auto__ = (function (){var statearr_36007 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_36007[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto__);

return statearr_36007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto__,map__35962,map__35962__$1,on_error,on_export_url,data_type))
);

return c__19292__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq35958){
var G__35959 = cljs.core.first(seq35958);
var seq35958__$1 = cljs.core.next(seq35958);
var G__35960 = cljs.core.first(seq35958__$1);
var seq35958__$2 = cljs.core.next(seq35958__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35959,G__35960,seq35958__$2);
});

/**
 * Repeatedly polls the export endpoint given a form_id while any of the
 *    export status is pending.
 */
milia.api.async_export.monitor_async_exports_per_form_BANG_ = (function milia$api$async_export$monitor_async_exports_per_form_BANG_(dataset_id,callback){
var c__19292__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto__){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto__){
return (function (state_36148){
var state_val_36149 = (state_36148[(1)]);
if((state_val_36149 === (7))){
var inst_36123 = (state_36148[(2)]);
var state_36148__$1 = state_36148;
if(cljs.core.truth_(inst_36123)){
var statearr_36150_36180 = state_36148__$1;
(statearr_36150_36180[(1)] = (11));

} else {
var statearr_36151_36181 = state_36148__$1;
(statearr_36151_36181[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (1))){
var inst_36100 = milia.api.async_export.initial_polling_interval;
var state_36148__$1 = (function (){var statearr_36152 = state_36148;
(statearr_36152[(7)] = inst_36100);

return statearr_36152;
})();
var statearr_36153_36182 = state_36148__$1;
(statearr_36153_36182[(2)] = null);

(statearr_36153_36182[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (4))){
var inst_36107 = (state_36148[(8)]);
var inst_36107__$1 = (state_36148[(2)]);
var inst_36109 = (inst_36107__$1 == null);
var inst_36110 = cljs.core.not(inst_36109);
var state_36148__$1 = (function (){var statearr_36154 = state_36148;
(statearr_36154[(8)] = inst_36107__$1);

return statearr_36154;
})();
if(inst_36110){
var statearr_36155_36183 = state_36148__$1;
(statearr_36155_36183[(1)] = (5));

} else {
var statearr_36156_36184 = state_36148__$1;
(statearr_36156_36184[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (15))){
var inst_36100 = (state_36148[(7)]);
var inst_36138 = cljs.core.async.timeout(inst_36100);
var state_36148__$1 = state_36148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36148__$1,(17),inst_36138);
} else {
if((state_val_36149 === (13))){
var inst_36100 = (state_36148[(7)]);
var inst_36130 = (state_36148[(9)]);
var inst_36104 = (state_36148[(10)]);
var inst_36128 = (state_36148[(2)]);
var inst_36129 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36128,cljs.core.cst$kw$status);
var inst_36130__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36128,cljs.core.cst$kw$body);
var inst_36131 = (function (){var polling_interval = inst_36100;
var export_url = inst_36104;
var map__36102 = inst_36128;
var status = inst_36129;
var body = inst_36130__$1;
return ((function (polling_interval,export_url,map__36102,status,body,inst_36100,inst_36130,inst_36104,inst_36128,inst_36129,inst_36130__$1,state_val_36149,c__19292__auto__){
return (function (p1__36019_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$job_status.cljs$core$IFn$_invoke$arity$1(p1__36019_SHARP_),milia.api.async_export.export_pending_status_msg);
});
;})(polling_interval,export_url,map__36102,status,body,inst_36100,inst_36130,inst_36104,inst_36128,inst_36129,inst_36130__$1,state_val_36149,c__19292__auto__))
})();
var inst_36132 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_36131,inst_36130__$1);
var inst_36133 = cljs.core.vec(inst_36132);
var inst_36134 = cljs.core.empty_QMARK_(inst_36133);
var state_36148__$1 = (function (){var statearr_36157 = state_36148;
(statearr_36157[(9)] = inst_36130__$1);

return statearr_36157;
})();
if(inst_36134){
var statearr_36158_36185 = state_36148__$1;
(statearr_36158_36185[(1)] = (14));

} else {
var statearr_36159_36186 = state_36148__$1;
(statearr_36159_36186[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (6))){
var state_36148__$1 = state_36148;
var statearr_36160_36187 = state_36148__$1;
(statearr_36160_36187[(2)] = false);

(statearr_36160_36187[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (17))){
var inst_36100 = (state_36148[(7)]);
var inst_36140 = (state_36148[(2)]);
var inst_36141 = (inst_36100 * (2));
var inst_36100__$1 = inst_36141;
var state_36148__$1 = (function (){var statearr_36161 = state_36148;
(statearr_36161[(11)] = inst_36140);

(statearr_36161[(7)] = inst_36100__$1);

return statearr_36161;
})();
var statearr_36162_36188 = state_36148__$1;
(statearr_36162_36188[(2)] = null);

(statearr_36162_36188[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (3))){
var inst_36146 = (state_36148[(2)]);
var state_36148__$1 = state_36148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36148__$1,inst_36146);
} else {
if((state_val_36149 === (12))){
var inst_36107 = (state_36148[(8)]);
var state_36148__$1 = state_36148;
var statearr_36163_36189 = state_36148__$1;
(statearr_36163_36189[(2)] = inst_36107);

(statearr_36163_36189[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (2))){
var inst_36104 = (state_36148[(10)]);
var inst_36103 = milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export?xform=",dataset_id,"&"], 0));
var inst_36104__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_36103], 0));
var inst_36105 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_36104__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_36148__$1 = (function (){var statearr_36164 = state_36148;
(statearr_36164[(10)] = inst_36104__$1);

return statearr_36164;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36148__$1,(4),inst_36105);
} else {
if((state_val_36149 === (11))){
var inst_36107 = (state_36148[(8)]);
var inst_36125 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_36107);
var state_36148__$1 = state_36148;
var statearr_36165_36190 = state_36148__$1;
(statearr_36165_36190[(2)] = inst_36125);

(statearr_36165_36190[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (9))){
var state_36148__$1 = state_36148;
var statearr_36166_36191 = state_36148__$1;
(statearr_36166_36191[(2)] = false);

(statearr_36166_36191[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (5))){
var inst_36107 = (state_36148[(8)]);
var inst_36112 = inst_36107.cljs$lang$protocol_mask$partition0$;
var inst_36113 = (inst_36112 & (64));
var inst_36114 = inst_36107.cljs$core$ISeq$;
var inst_36115 = (cljs.core.PROTOCOL_SENTINEL === inst_36114);
var inst_36116 = (inst_36113) || (inst_36115);
var state_36148__$1 = state_36148;
if(cljs.core.truth_(inst_36116)){
var statearr_36167_36192 = state_36148__$1;
(statearr_36167_36192[(1)] = (8));

} else {
var statearr_36168_36193 = state_36148__$1;
(statearr_36168_36193[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (14))){
var inst_36130 = (state_36148[(9)]);
var inst_36136 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_36130) : callback.call(null,inst_36130));
var state_36148__$1 = state_36148;
var statearr_36169_36194 = state_36148__$1;
(statearr_36169_36194[(2)] = inst_36136);

(statearr_36169_36194[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (16))){
var inst_36144 = (state_36148[(2)]);
var state_36148__$1 = state_36148;
var statearr_36170_36195 = state_36148__$1;
(statearr_36170_36195[(2)] = inst_36144);

(statearr_36170_36195[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (10))){
var inst_36120 = (state_36148[(2)]);
var state_36148__$1 = state_36148;
var statearr_36171_36196 = state_36148__$1;
(statearr_36171_36196[(2)] = inst_36120);

(statearr_36171_36196[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36149 === (8))){
var state_36148__$1 = state_36148;
var statearr_36172_36197 = state_36148__$1;
(statearr_36172_36197[(2)] = true);

(statearr_36172_36197[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto__))
;
return ((function (switch__19180__auto__,c__19292__auto__){
return (function() {
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19181__auto__ = null;
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19181__auto____0 = (function (){
var statearr_36176 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36176[(0)] = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19181__auto__);

(statearr_36176[(1)] = (1));

return statearr_36176;
});
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19181__auto____1 = (function (state_36148){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_36148);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e36177){if((e36177 instanceof Object)){
var ex__19184__auto__ = e36177;
var statearr_36178_36198 = state_36148;
(statearr_36178_36198[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36148);

return cljs.core.cst$kw$recur;
} else {
throw e36177;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__36199 = state_36148;
state_36148 = G__36199;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19181__auto__ = function(state_36148){
switch(arguments.length){
case 0:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19181__auto____0.call(this);
case 1:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19181__auto____1.call(this,state_36148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19181__auto____0;
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19181__auto____1;
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto__))
})();
var state__19294__auto__ = (function (){var statearr_36179 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_36179[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto__);

return statearr_36179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto__))
);

return c__19292__auto__;
});
milia.api.async_export.version_key = "_version";
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_hxl","include_images","remove_group_name",milia.api.async_export.version_key,"query","export_id","include_labels","include_labels_only","win_excel_utf8","redirect_uri"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_hxl_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id,cljs.core.cst$kw$include_DASH_labels_QMARK_,cljs.core.cst$kw$labels_DASH_only_QMARK_,cljs.core.cst$kw$windows_DASH_compatible_DASH_csv_QMARK_,cljs.core.cst$kw$redirect_DASH_uri], null);
milia.api.async_export.get_param = (function milia$api$async_export$get_param(key,value){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,milia.api.async_export.version_key)){
return goog.string.format("&query={\"%s\":\"%s\"}",key,value);
} else {
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
}
});
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_((function (){var or__6543__auto__ = value;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
return milia.api.async_export.get_param(key,value);
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___36207 = arguments.length;
var i__7652__auto___36208 = (0);
while(true){
if((i__7652__auto___36208 < len__7651__auto___36207)){
args__7658__auto__.push((arguments[i__7652__auto___36208]));

var G__36209 = (i__7652__auto___36208 + (1));
i__7652__auto___36208 = G__36209;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__36203){
var vec__36204 = p__36203;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36204,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq36200){
var G__36201 = cljs.core.first(seq36200);
var seq36200__$1 = cljs.core.next(seq36200);
var G__36202 = cljs.core.first(seq36200__$1);
var seq36200__$2 = cljs.core.next(seq36200__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__36201,G__36202,seq36200__$2);
});

/**
 * Triggers async export and watches it via polling.
 *    Fires on-job-id callback on receving :job_uuid from server, then monitors
 *    job via polling.
 *    On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___36259 = arguments.length;
var i__7652__auto___36260 = (0);
while(true){
if((i__7652__auto___36260 < len__7651__auto___36259)){
args__7658__auto__.push((arguments[i__7652__auto___36260]));

var G__36261 = (i__7652__auto___36260 + (1));
i__7652__auto___36260 = G__36261;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__36212){
var vec__36213 = p__36212;
var map__36216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36213,(0),null);
var map__36216__$1 = ((((!((map__36216 == null)))?((((map__36216.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36216.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36216):map__36216);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36216__$1,cljs.core.cst$kw$data_DASH_type);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36216__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36216__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36216__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36216__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36216__$1,cljs.core.cst$kw$on_DASH_error);
var on_done = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36216__$1,cljs.core.cst$kw$on_DASH_done);
var c__19292__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto__,vec__36213,map__36216,map__36216__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto__,vec__36213,map__36216,map__36216__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (state_36239){
var state_val_36240 = (state_36239[(1)]);
if((state_val_36240 === (1))){
var inst_36218 = (state_36239[(7)]);
var inst_36220 = (state_36239[(8)]);
var inst_36218__$1 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var inst_36219 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_36220__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_36219,dataset_id,inst_36218__$1], 0));
var inst_36221 = milia.utils.retry.retry_parse_http(cljs.core.cst$kw$get,inst_36220__$1);
var state_36239__$1 = (function (){var statearr_36241 = state_36239;
(statearr_36241[(7)] = inst_36218__$1);

(statearr_36241[(8)] = inst_36220__$1);

return statearr_36241;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36239__$1,(2),inst_36221);
} else {
if((state_val_36240 === (2))){
var inst_36218 = (state_36239[(7)]);
var inst_36223 = (state_36239[(9)]);
var inst_36220 = (state_36239[(8)]);
var inst_36223__$1 = (state_36239[(2)]);
var inst_36224 = (function (){var export_suffix = inst_36218;
var export_url = inst_36220;
var response = inst_36223__$1;
return ((function (export_suffix,export_url,response,inst_36218,inst_36223,inst_36220,inst_36223__$1,state_val_36240,c__19292__auto__,vec__36213,map__36216,map__36216__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([cljs.core.cst$kw$on_DASH_export_DASH_url,on_export_url,cljs.core.cst$kw$on_DASH_error,on_error,cljs.core.cst$kw$data_DASH_type,data_type], 0));
});
;})(export_suffix,export_url,response,inst_36218,inst_36223,inst_36220,inst_36223__$1,state_val_36240,c__19292__auto__,vec__36213,map__36216,map__36216__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state_36239__$1 = (function (){var statearr_36242 = state_36239;
(statearr_36242[(10)] = inst_36224);

(statearr_36242[(9)] = inst_36223__$1);

return statearr_36242;
})();
if(cljs.core.truth_(on_done)){
var statearr_36243_36262 = state_36239__$1;
(statearr_36243_36262[(1)] = (3));

} else {
var statearr_36244_36263 = state_36239__$1;
(statearr_36244_36263[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36240 === (3))){
var inst_36223 = (state_36239[(9)]);
var inst_36226 = (on_done.cljs$core$IFn$_invoke$arity$1 ? on_done.cljs$core$IFn$_invoke$arity$1(inst_36223) : on_done.call(null,inst_36223));
var state_36239__$1 = state_36239;
var statearr_36245_36264 = state_36239__$1;
(statearr_36245_36264[(2)] = inst_36226);

(statearr_36245_36264[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36240 === (4))){
var state_36239__$1 = state_36239;
var statearr_36246_36265 = state_36239__$1;
(statearr_36246_36265[(2)] = null);

(statearr_36246_36265[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36240 === (5))){
var inst_36229 = (state_36239[(2)]);
var inst_36230 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var state_36239__$1 = (function (){var statearr_36247 = state_36239;
(statearr_36247[(11)] = inst_36229);

(statearr_36247[(12)] = inst_36230);

return statearr_36247;
})();
if(cljs.core.truth_(on_done)){
var statearr_36248_36266 = state_36239__$1;
(statearr_36248_36266[(1)] = (6));

} else {
var statearr_36249_36267 = state_36239__$1;
(statearr_36249_36267[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36240 === (6))){
var state_36239__$1 = state_36239;
var statearr_36250_36268 = state_36239__$1;
(statearr_36250_36268[(2)] = on_job_id);

(statearr_36250_36268[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36240 === (7))){
var inst_36224 = (state_36239[(10)]);
var state_36239__$1 = state_36239;
var statearr_36251_36269 = state_36239__$1;
(statearr_36251_36269[(2)] = inst_36224);

(statearr_36251_36269[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36240 === (8))){
var inst_36223 = (state_36239[(9)]);
var inst_36230 = (state_36239[(12)]);
var inst_36234 = (state_36239[(2)]);
var inst_36235 = [on_error,inst_36234,on_export_url];
var inst_36236 = cljs.core.PersistentHashMap.fromArrays(inst_36230,inst_36235);
var inst_36237 = milia.api.async_export.handle_response(inst_36223,inst_36236);
var state_36239__$1 = state_36239;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36239__$1,inst_36237);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19292__auto__,vec__36213,map__36216,map__36216__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
;
return ((function (switch__19180__auto__,c__19292__auto__,vec__36213,map__36216,map__36216__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function() {
var milia$api$async_export$state_machine__19181__auto__ = null;
var milia$api$async_export$state_machine__19181__auto____0 = (function (){
var statearr_36255 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36255[(0)] = milia$api$async_export$state_machine__19181__auto__);

(statearr_36255[(1)] = (1));

return statearr_36255;
});
var milia$api$async_export$state_machine__19181__auto____1 = (function (state_36239){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_36239);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e36256){if((e36256 instanceof Object)){
var ex__19184__auto__ = e36256;
var statearr_36257_36270 = state_36239;
(statearr_36257_36270[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36239);

return cljs.core.cst$kw$recur;
} else {
throw e36256;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__36271 = state_36239;
state_36239 = G__36271;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19181__auto__ = function(state_36239){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19181__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19181__auto____1.call(this,state_36239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19181__auto____0;
milia$api$async_export$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19181__auto____1;
return milia$api$async_export$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto__,vec__36213,map__36216,map__36216__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state__19294__auto__ = (function (){var statearr_36258 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_36258[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto__);

return statearr_36258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto__,vec__36213,map__36216,map__36216__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
);

return c__19292__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq36210){
var G__36211 = cljs.core.first(seq36210);
var seq36210__$1 = cljs.core.next(seq36210);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__36211,seq36210__$1);
});

/**
 * Returns a channel, which will have the async export url when ready.
 */
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,((function (ch){
return (function (p1__36272_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__36272_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
/**
 * Returns a channel, which will have the async _data_
 *  downloaded using http-method when ready.
 */
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___36297 = arguments.length;
var i__7652__auto___36298 = (0);
while(true){
if((i__7652__auto___36298 < len__7651__auto___36297)){
args__7658__auto__.push((arguments[i__7652__auto___36298]));

var G__36299 = (i__7652__auto___36298 + (1));
i__7652__auto___36298 = G__36299;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){
var c__19292__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto__){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto__){
return (function (state_36288){
var state_val_36289 = (state_36288[(1)]);
if((state_val_36289 === (1))){
var inst_36277 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_36288__$1 = state_36288;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36288__$1,(2),inst_36277);
} else {
if((state_val_36289 === (2))){
var inst_36279 = (state_36288[(2)]);
var inst_36280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36281 = [http_method,inst_36279];
var inst_36282 = (new cljs.core.PersistentVector(null,2,(5),inst_36280,inst_36281,null));
var inst_36283 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_36282,args);
var inst_36284 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_36283);
var state_36288__$1 = state_36288;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36288__$1,(3),inst_36284);
} else {
if((state_val_36289 === (3))){
var inst_36286 = (state_36288[(2)]);
var state_36288__$1 = state_36288;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36288__$1,inst_36286);
} else {
return null;
}
}
}
});})(c__19292__auto__))
;
return ((function (switch__19180__auto__,c__19292__auto__){
return (function() {
var milia$api$async_export$state_machine__19181__auto__ = null;
var milia$api$async_export$state_machine__19181__auto____0 = (function (){
var statearr_36293 = [null,null,null,null,null,null,null];
(statearr_36293[(0)] = milia$api$async_export$state_machine__19181__auto__);

(statearr_36293[(1)] = (1));

return statearr_36293;
});
var milia$api$async_export$state_machine__19181__auto____1 = (function (state_36288){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_36288);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e36294){if((e36294 instanceof Object)){
var ex__19184__auto__ = e36294;
var statearr_36295_36300 = state_36288;
(statearr_36295_36300[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36288);

return cljs.core.cst$kw$recur;
} else {
throw e36294;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__36301 = state_36288;
state_36288 = G__36301;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19181__auto__ = function(state_36288){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19181__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19181__auto____1.call(this,state_36288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19181__auto____0;
milia$api$async_export$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19181__auto____1;
return milia$api$async_export$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto__))
})();
var state__19294__auto__ = (function (){var statearr_36296 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_36296[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto__);

return statearr_36296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto__))
);

return c__19292__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq36273){
var G__36274 = cljs.core.first(seq36273);
var seq36273__$1 = cljs.core.next(seq36273);
var G__36275 = cljs.core.first(seq36273__$1);
var seq36273__$2 = cljs.core.next(seq36273__$1);
var G__36276 = cljs.core.first(seq36273__$2);
var seq36273__$3 = cljs.core.next(seq36273__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__36274,G__36275,G__36276,seq36273__$3);
});

/**
 * Get exports based on a form id.
 */
milia.api.async_export.get_exports_per_form = (function milia$api$async_export$get_exports_per_form(dataset_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export?xform=",dataset_id], 0))], 0)));
});
/**
 * Delete an export based on an export id
 */
milia.api.async_export.delete_export = (function milia$api$async_export$delete_export(export_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export",milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([export_id,"?"], 0))], 0)));
});
