// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.charts');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
milia.api.charts.format = goog.string.format;
milia.api.charts.suffix = (function milia$api$charts$suffix(var_args){
var args35809 = [];
var len__7651__auto___35812 = arguments.length;
var i__7652__auto___35813 = (0);
while(true){
if((i__7652__auto___35813 < len__7651__auto___35812)){
args35809.push((arguments[i__7652__auto___35813]));

var G__35814 = (i__7652__auto___35813 + (1));
i__7652__auto___35813 = G__35814;
continue;
} else {
}
break;
}

var G__35811 = args35809.length;
switch (G__35811) {
case 1:
return milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35809.length)].join('')));

}
});

milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
return [cljs.core.str(dataset_id),cljs.core.str(".json")].join('');
});

milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,field_name){
var field_s = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(field_name,"all"))?"fields":"field_name");
return [cljs.core.str(dataset_id),cljs.core.str(".json?"),cljs.core.str(field_s),cljs.core.str("="),cljs.core.str(field_name)].join('');
});

milia.api.charts.suffix.cljs$lang$maxFixedArity = 2;

/**
 * Get list of chart fields for a specific dataset
 */
milia.api.charts.fields = (function milia$api$charts$fields(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["charts",milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$1(dataset_id)], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Get chart for a specific field in a dataset
 */
milia.api.charts.chart = (function milia$api$charts$chart(var_args){
var args35816 = [];
var len__7651__auto___35819 = arguments.length;
var i__7652__auto___35820 = (0);
while(true){
if((i__7652__auto___35820 < len__7651__auto___35819)){
args35816.push((arguments[i__7652__auto___35820]));

var G__35821 = (i__7652__auto___35820 + (1));
i__7652__auto___35820 = G__35821;
continue;
} else {
}
break;
}

var G__35818 = args35816.length;
switch (G__35818) {
case 1:
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35816.length)].join('')));

}
});

milia.api.charts.chart.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
return milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2(dataset_id,"all");
});

milia.api.charts.chart.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,field_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["charts",milia.api.charts.suffix.cljs$core$IFn$_invoke$arity$2(dataset_id,field_name)], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.charts.chart.cljs$lang$maxFixedArity = 2;

/**
 * Given a field name, return chart data associated with a dataset or dataview
 */
milia.api.charts.get = (function milia$api$charts$get(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35828 = arguments.length;
var i__7652__auto___35829 = (0);
while(true){
if((i__7652__auto___35829 < len__7651__auto___35828)){
args__7658__auto__.push((arguments[i__7652__auto___35829]));

var G__35830 = (i__7652__auto___35829 + (1));
i__7652__auto___35829 = G__35830;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.charts.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.charts.get.cljs$core$IFn$_invoke$arity$variadic = (function (field_name,p__35825){
var map__35826 = p__35825;
var map__35826__$1 = ((((!((map__35826 == null)))?((((map__35826.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35826.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35826):map__35826);
var dataview_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35826__$1,cljs.core.cst$kw$dataview_DASH_id);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35826__$1,cljs.core.cst$kw$dataset_DASH_id);
var group_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35826__$1,cljs.core.cst$kw$group_DASH_by);
var id = (function (){var or__6543__auto__ = dataview_id;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return dataset_id;
}
})();
var base_url_template = (cljs.core.truth_(dataview_id)?"dataviews/%s/charts.json?field_name=%s":"charts/%s.json?field_name=%s");
var url_template = [cljs.core.str(base_url_template),cljs.core.str((cljs.core.truth_(group_by)?"&group_by=%s":null))].join('');
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(milia.api.charts.format.cljs$core$IFn$_invoke$arity$4 ? milia.api.charts.format.cljs$core$IFn$_invoke$arity$4(url_template,id,field_name,group_by) : milia.api.charts.format.call(null,url_template,id,field_name,group_by))], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.charts.get.cljs$lang$maxFixedArity = (1);

milia.api.charts.get.cljs$lang$applyTo = (function (seq35823){
var G__35824 = cljs.core.first(seq35823);
var seq35823__$1 = cljs.core.next(seq35823);
return milia.api.charts.get.cljs$core$IFn$_invoke$arity$variadic(G__35824,seq35823__$1);
});

