// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
var G__35254 = http_options__$1;
if(cljs.core.truth_((function (){var and__6531__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return (cljs.core.not(cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1))) && (cljs.core.not(stateful_method_QMARK_));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.assoc_in(G__35254,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__35255 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__35255) : cljs_hash.md5.md5.call(null,G__35255));
})());
} else {
return G__35254;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35260 = arguments.length;
var i__7652__auto___35261 = (0);
while(true){
if((i__7652__auto___35261 < len__7651__auto___35260)){
args__7658__auto__.push((arguments[i__7652__auto___35261]));

var G__35262 = (i__7652__auto___35261 + (1));
i__7652__auto___35261 = G__35262;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__35257){
var map__35258 = p__35257;
var map__35258__$1 = ((((!((map__35258 == null)))?((((map__35258.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35258.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35258):map__35258);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35258__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35258__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35258__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35258__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("Token "),cljs.core.str(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__6531__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__6531__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4657__auto__ = (function (){var and__6531__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var crsf_token = temp__4657__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__6543__auto__ = accept_header;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq35256){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35256));
});

/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35272 = arguments.length;
var i__7652__auto___35273 = (0);
while(true){
if((i__7652__auto___35273 < len__7651__auto___35272)){
args__7658__auto__.push((arguments[i__7652__auto___35273]));

var G__35274 = (i__7652__auto___35273 + (1));
i__7652__auto___35273 = G__35274;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__35265){
var vec__35266 = p__35265;
var map__35269 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35266,(0),null);
var map__35269__$1 = ((((!((map__35269 == null)))?((((map__35269.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35269.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35269):map__35269);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35269__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e35271){if((e35271 instanceof Error)){
var _ = e35271;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e35271;

}
}} else {
return io_obj.getResponseText();
}
});

milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1);

milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq35263){
var G__35264 = cljs.core.first(seq35263);
var seq35263__$1 = cljs.core.next(seq35263);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(G__35264,seq35263__$1);
});

milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
var G__35281_35287 = io_obj;
var G__35282_35288 = goog.net.EventType.SUCCESS;
var G__35283_35289 = ((function (G__35281_35287,G__35282_35288,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__35281_35287,G__35282_35288,io_obj))
;
goog.events.listen(G__35281_35287,G__35282_35288,G__35283_35289);

var G__35284_35290 = io_obj;
var G__35285_35291 = goog.net.EventType.ERROR;
var G__35286_35292 = ((function (G__35284_35290,G__35285_35291,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__35284_35290,G__35285_35291,io_obj))
;
goog.events.listen(G__35284_35290,G__35285_35291,G__35286_35292);

return io_obj.sendFromForm(form,[cljs.core.str(form_api),cljs.core.str("?legacy=true")].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://goo.gl/B0fm2a
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35309 = arguments.length;
var i__7652__auto___35310 = (0);
while(true){
if((i__7652__auto___35310 < len__7651__auto___35309)){
args__7658__auto__.push((arguments[i__7652__auto___35310]));

var G__35311 = (i__7652__auto___35310 + (1));
i__7652__auto___35310 = G__35311;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__35297){
var map__35298 = p__35297;
var map__35298__$1 = ((((!((map__35298 == null)))?((((map__35298.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35298.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35298):map__35298);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35298__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35298__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35298__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

var G__35300_35312 = io_obj;
var G__35301_35313 = goog.net.EventType.SUCCESS;
var G__35302_35314 = ((function (G__35300_35312,G__35301_35313,io_obj,data,url,map__35298,map__35298__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,true], 0)));
});})(G__35300_35312,G__35301_35313,io_obj,data,url,map__35298,map__35298__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__35300_35312,G__35301_35313,G__35302_35314);

var G__35303_35315 = io_obj;
var G__35304_35316 = goog.net.EventType.ERROR;
var G__35305_35317 = ((function (G__35303_35315,G__35304_35316,io_obj,data,url,map__35298,map__35298__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,false], 0)));
});})(G__35303_35315,G__35304_35316,io_obj,data,url,map__35298,map__35298__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__35303_35315,G__35304_35316,G__35305_35317);

var G__35306_35318 = io_obj;
var G__35307_35319 = goog.net.EventType.PROGRESS;
var G__35308_35320 = ((function (G__35306_35318,G__35307_35319,io_obj,data,url,map__35298,map__35298__$1,headers,id,require_json_QMARK_){
return (function (p1__35293_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__35293_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__35293_SHARP_.loaded,cljs.core.cst$kw$total,p1__35293_SHARP_.total], null)));
});})(G__35306_35318,G__35307_35319,io_obj,data,url,map__35298,map__35298__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__35306_35318,G__35307_35319,G__35308_35320);

io_obj.send(url,"POST",form,headers);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq35294){
var G__35295 = cljs.core.first(seq35294);
var seq35294__$1 = cljs.core.next(seq35294);
var G__35296 = cljs.core.first(seq35294__$1);
var seq35294__$2 = cljs.core.next(seq35294__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__35295,G__35296,seq35294__$2);
});

/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35385 = arguments.length;
var i__7652__auto___35386 = (0);
while(true){
if((i__7652__auto___35386 < len__7651__auto___35385)){
args__7658__auto__.push((arguments[i__7652__auto___35386]));

var G__35387 = (i__7652__auto___35386 + (1));
i__7652__auto___35386 = G__35387;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__19292__auto___35388 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___35388,response_channel){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___35388,response_channel){
return (function (state_35358){
var state_val_35359 = (state_35358[(1)]);
if((state_val_35359 === (7))){
var state_35358__$1 = state_35358;
var statearr_35360_35389 = state_35358__$1;
(statearr_35360_35389[(2)] = false);

(statearr_35360_35389[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35359 === (1))){
var inst_35324 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_35358__$1 = state_35358;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35358__$1,(2),inst_35324);
} else {
if((state_val_35359 === (4))){
var state_35358__$1 = state_35358;
var statearr_35361_35390 = state_35358__$1;
(statearr_35361_35390[(2)] = false);

(statearr_35361_35390[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35359 === (13))){
var inst_35347 = (state_35358[(7)]);
var inst_35354 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_35347);
var state_35358__$1 = state_35358;
var statearr_35362_35391 = state_35358__$1;
(statearr_35362_35391[(2)] = inst_35354);

(statearr_35362_35391[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35359 === (6))){
var state_35358__$1 = state_35358;
var statearr_35363_35392 = state_35358__$1;
(statearr_35363_35392[(2)] = true);

(statearr_35363_35392[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35359 === (3))){
var inst_35326 = (state_35358[(8)]);
var inst_35331 = inst_35326.cljs$lang$protocol_mask$partition0$;
var inst_35332 = (inst_35331 & (64));
var inst_35333 = inst_35326.cljs$core$ISeq$;
var inst_35334 = (cljs.core.PROTOCOL_SENTINEL === inst_35333);
var inst_35335 = (inst_35332) || (inst_35334);
var state_35358__$1 = state_35358;
if(cljs.core.truth_(inst_35335)){
var statearr_35364_35393 = state_35358__$1;
(statearr_35364_35393[(1)] = (6));

} else {
var statearr_35365_35394 = state_35358__$1;
(statearr_35365_35394[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35359 === (12))){
var inst_35351 = window.location.href();
var inst_35352 = window.location = inst_35351;
var state_35358__$1 = state_35358;
var statearr_35366_35395 = state_35358__$1;
(statearr_35366_35395[(2)] = inst_35352);

(statearr_35366_35395[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35359 === (2))){
var inst_35326 = (state_35358[(8)]);
var inst_35326__$1 = (state_35358[(2)]);
var inst_35328 = (inst_35326__$1 == null);
var inst_35329 = cljs.core.not(inst_35328);
var state_35358__$1 = (function (){var statearr_35367 = state_35358;
(statearr_35367[(8)] = inst_35326__$1);

return statearr_35367;
})();
if(inst_35329){
var statearr_35368_35396 = state_35358__$1;
(statearr_35368_35396[(1)] = (3));

} else {
var statearr_35369_35397 = state_35358__$1;
(statearr_35369_35397[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35359 === (11))){
var inst_35347 = (state_35358[(7)]);
var inst_35347__$1 = (state_35358[(2)]);
var inst_35348 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35347__$1,cljs.core.cst$kw$status);
var inst_35349 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35348,(401));
var state_35358__$1 = (function (){var statearr_35370 = state_35358;
(statearr_35370[(7)] = inst_35347__$1);

return statearr_35370;
})();
if(inst_35349){
var statearr_35371_35398 = state_35358__$1;
(statearr_35371_35398[(1)] = (12));

} else {
var statearr_35372_35399 = state_35358__$1;
(statearr_35372_35399[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35359 === (9))){
var inst_35326 = (state_35358[(8)]);
var inst_35344 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35326);
var state_35358__$1 = state_35358;
var statearr_35373_35400 = state_35358__$1;
(statearr_35373_35400[(2)] = inst_35344);

(statearr_35373_35400[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35359 === (5))){
var inst_35342 = (state_35358[(2)]);
var state_35358__$1 = state_35358;
if(cljs.core.truth_(inst_35342)){
var statearr_35374_35401 = state_35358__$1;
(statearr_35374_35401[(1)] = (9));

} else {
var statearr_35375_35402 = state_35358__$1;
(statearr_35375_35402[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35359 === (14))){
var inst_35356 = (state_35358[(2)]);
var state_35358__$1 = state_35358;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35358__$1,inst_35356);
} else {
if((state_val_35359 === (10))){
var inst_35326 = (state_35358[(8)]);
var state_35358__$1 = state_35358;
var statearr_35376_35403 = state_35358__$1;
(statearr_35376_35403[(2)] = inst_35326);

(statearr_35376_35403[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35359 === (8))){
var inst_35339 = (state_35358[(2)]);
var state_35358__$1 = state_35358;
var statearr_35377_35404 = state_35358__$1;
(statearr_35377_35404[(2)] = inst_35339);

(statearr_35377_35404[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___35388,response_channel))
;
return ((function (switch__19180__auto__,c__19292__auto___35388,response_channel){
return (function() {
var milia$api$io$state_machine__19181__auto__ = null;
var milia$api$io$state_machine__19181__auto____0 = (function (){
var statearr_35381 = [null,null,null,null,null,null,null,null,null];
(statearr_35381[(0)] = milia$api$io$state_machine__19181__auto__);

(statearr_35381[(1)] = (1));

return statearr_35381;
});
var milia$api$io$state_machine__19181__auto____1 = (function (state_35358){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_35358);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e35382){if((e35382 instanceof Object)){
var ex__19184__auto__ = e35382;
var statearr_35383_35405 = state_35358;
(statearr_35383_35405[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35358);

return cljs.core.cst$kw$recur;
} else {
throw e35382;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__35406 = state_35358;
state_35358 = G__35406;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
milia$api$io$state_machine__19181__auto__ = function(state_35358){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__19181__auto____0.call(this);
case 1:
return milia$api$io$state_machine__19181__auto____1.call(this,state_35358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__19181__auto____0;
milia$api$io$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__19181__auto____1;
return milia$api$io$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___35388,response_channel))
})();
var state__19294__auto__ = (function (){var statearr_35384 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_35384[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___35388);

return statearr_35384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___35388,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq35321){
var G__35322 = cljs.core.first(seq35321);
var seq35321__$1 = cljs.core.next(seq35321);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__35322,seq35321__$1);
});

