// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.project');
goog.require('cljs.core');
goog.require('chimera.urls');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.metadata');
goog.require('milia.utils.remote');
/**
 * Parse and add the projects ID.
 */
milia.api.project.add_id = (function milia$api$project$add_id(project_data){
if(typeof project_data === 'string'){
return null;
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([project_data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,chimera.urls.last_url_param(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(project_data))], null)], 0));
}
});
/**
 * Get the forms for this account and owner of the user.
 */
milia.api.project.get_forms = (function milia$api$project$get_forms(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"forms"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.project.get_project = (function milia$api$project$get_project(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35712 = arguments.length;
var i__7652__auto___35713 = (0);
while(true){
if((i__7652__auto___35713 < len__7651__auto___35712)){
args__7658__auto__.push((arguments[i__7652__auto___35713]));

var G__35714 = (i__7652__auto___35713 + (1));
i__7652__auto___35713 = G__35714;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__35709){
var map__35710 = p__35709;
var map__35710__$1 = ((((!((map__35710 == null)))?((((map__35710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35710.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35710):map__35710);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35710__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
var data = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
return data;
});

milia.api.project.get_project.cljs$lang$maxFixedArity = (1);

milia.api.project.get_project.cljs$lang$applyTo = (function (seq35707){
var G__35708 = cljs.core.first(seq35707);
var seq35707__$1 = cljs.core.next(seq35707);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic(G__35708,seq35707__$1);
});

/**
 * Return all project for this account and owner or the user.
 */
milia.api.project.all = (function milia$api$project$all(var_args){
var args35717 = [];
var len__7651__auto___35725 = arguments.length;
var i__7652__auto___35726 = (0);
while(true){
if((i__7652__auto___35726 < len__7651__auto___35725)){
args35717.push((arguments[i__7652__auto___35726]));

var G__35727 = (i__7652__auto___35726 + (1));
i__7652__auto___35726 = G__35727;
continue;
} else {
}
break;
}

var G__35721 = args35717.length;
switch (G__35721) {
case 0:
return milia.api.project.all.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args35717.slice((1)),(0),null));
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7670__auto__);

}
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.project.all(null);
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic = (function (owner,p__35722){
var map__35723 = p__35722;
var map__35723__$1 = ((((!((map__35723 == null)))?((((map__35723.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35723.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35723):map__35723);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35723__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var logged_in_username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35723__$1,cljs.core.cst$kw$logged_DASH_in_DASH_username);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
var options = ((function (url,map__35723,map__35723__$1,no_cache_QMARK_,logged_in_username){
return (function (p1__35716_SHARP_){
if(cljs.core.truth_(logged_in_username)){
return cljs.core.assoc_in(p1__35716_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$u], null),logged_in_username);
} else {
return p1__35716_SHARP_;
}
});})(url,map__35723,map__35723__$1,no_cache_QMARK_,logged_in_username))
.call(null,((function (url,map__35723,map__35723__$1,no_cache_QMARK_,logged_in_username){
return (function (p1__35715_SHARP_){
if(cljs.core.truth_(owner)){
return cljs.core.assoc_in(p1__35715_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$owner], null),owner);
} else {
return p1__35715_SHARP_;
}
});})(url,map__35723,map__35723__$1,no_cache_QMARK_,logged_in_username))
.call(null,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,null], null)));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.project.all.cljs$lang$applyTo = (function (seq35718){
var G__35719 = cljs.core.first(seq35718);
var seq35718__$1 = cljs.core.next(seq35718);
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic(G__35719,seq35718__$1);
});

milia.api.project.all.cljs$lang$maxFixedArity = (1);

/**
 * Create a project for this account and owner or the user.
 */
milia.api.project.create = (function milia$api$project$create(data,owner){
var owner_url = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",owner], 0))], null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
var form_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([owner_url,data], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,form_params], null)], 0));
});
/**
 * Update project metadata
 */
milia.api.project.update = (function milia$api$project$update(project_id,data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,data], null)], 0));
});
/**
 * Share project with specific user or remove specific user from project
 */
milia.api.project.share = (function milia$api$project$share(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35737 = arguments.length;
var i__7652__auto___35738 = (0);
while(true){
if((i__7652__auto___35738 < len__7651__auto___35737)){
args__7658__auto__.push((arguments[i__7652__auto___35738]));

var G__35739 = (i__7652__auto___35738 + (1));
i__7652__auto___35738 = G__35739;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,username,role,p__35733){
var vec__35734 = p__35733;
var remove_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35734,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id,"share"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$role,role], null);
var form_params = (cljs.core.truth_(remove_QMARK_)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$remove,"True"], null)], 0)):data);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
});

milia.api.project.share.cljs$lang$maxFixedArity = (3);

milia.api.project.share.cljs$lang$applyTo = (function (seq35729){
var G__35730 = cljs.core.first(seq35729);
var seq35729__$1 = cljs.core.next(seq35729);
var G__35731 = cljs.core.first(seq35729__$1);
var seq35729__$2 = cljs.core.next(seq35729__$1);
var G__35732 = cljs.core.first(seq35729__$2);
var seq35729__$3 = cljs.core.next(seq35729__$2);
return milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic(G__35730,G__35731,G__35732,seq35729__$3);
});

/**
 * Add tags to a project.
 */
milia.api.project.add_tags = (function milia$api$project$add_tags(id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"labels"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null),cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Get projects with given tags.
 */
milia.api.project.with_tag = (function milia$api$project$with_tag(tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null)], null)], 0));
});
/**
 * Add star to project for this user.
 */
milia.api.project.add_star = (function milia$api$project$add_star(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35745 = arguments.length;
var i__7652__auto___35746 = (0);
while(true){
if((i__7652__auto___35746 < len__7651__auto___35745)){
args__7658__auto__.push((arguments[i__7652__auto___35746]));

var G__35747 = (i__7652__auto___35746 + (1));
i__7652__auto___35746 = G__35747;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__35742){
var map__35743 = p__35742;
var map__35743__$1 = ((((!((map__35743 == null)))?((((map__35743.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35743.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35743):map__35743);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35743__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$callback,callback], 0));
});

milia.api.project.add_star.cljs$lang$maxFixedArity = (1);

milia.api.project.add_star.cljs$lang$applyTo = (function (seq35740){
var G__35741 = cljs.core.first(seq35740);
var seq35740__$1 = cljs.core.next(seq35740);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic(G__35741,seq35740__$1);
});

/**
 * Remove star from project for this user.
 */
milia.api.project.remove_star = (function milia$api$project$remove_star(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35753 = arguments.length;
var i__7652__auto___35754 = (0);
while(true){
if((i__7652__auto___35754 < len__7651__auto___35753)){
args__7658__auto__.push((arguments[i__7652__auto___35754]));

var G__35755 = (i__7652__auto___35754 + (1));
i__7652__auto___35754 = G__35755;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__35750){
var map__35751 = p__35750;
var map__35751__$1 = ((((!((map__35751 == null)))?((((map__35751.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35751.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35751):map__35751);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35751__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$delete,url,cljs.core.array_seq([cljs.core.cst$kw$callback,callback], 0));
});

milia.api.project.remove_star.cljs$lang$maxFixedArity = (1);

milia.api.project.remove_star.cljs$lang$applyTo = (function (seq35748){
var G__35749 = cljs.core.first(seq35748);
var seq35748__$1 = cljs.core.next(seq35748);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic(G__35749,seq35748__$1);
});

/**
 * Toggle between starred and unstarred for a user's project
 */
milia.api.project.toggle_star = (function milia$api$project$toggle_star(id,star_QMARK_,callback){
return (cljs.core.truth_(star_QMARK_)?milia.api.project.add_star:milia.api.project.remove_star).call(null,id,cljs.core.cst$kw$callback,callback);
});
/**
 * Get projects this user has starred.
 */
milia.api.project.get_starred = (function milia$api$project$get_starred(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user",username,"starred"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Get user that starred this project.
 */
milia.api.project.starred_by = (function milia$api$project$starred_by(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Delete a project
 */
milia.api.project.delete$ = (function milia$api$project$delete(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Set new project owner
 */
milia.api.project.transfer_owner = (function milia$api$project$transfer_owner(id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",new_owner], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,new_owner__$1], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,form_params,cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Update the project public setting.
 */
milia.api.project.update_public = (function milia$api$project$update_public(projectid,public$){
return milia.api.project.update(projectid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$public,public$], null));
});
milia.api.project.files = (function milia$api$project$files(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35761 = arguments.length;
var i__7652__auto___35762 = (0);
while(true){
if((i__7652__auto___35762 < len__7651__auto___35761)){
args__7658__auto__.push((arguments[i__7652__auto___35762]));

var G__35763 = (i__7652__auto___35762 + (1));
i__7652__auto___35762 = G__35763;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,p__35758){
var map__35759 = p__35758;
var map__35759__$1 = ((((!((map__35759 == null)))?((((map__35759.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35759.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35759):map__35759);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35759__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.utils.metadata.metadata_files(cljs.core.cst$kw$project,project_id,no_cache_QMARK_);
});

milia.api.project.files.cljs$lang$maxFixedArity = (1);

milia.api.project.files.cljs$lang$applyTo = (function (seq35756){
var G__35757 = cljs.core.first(seq35756);
var seq35756__$1 = cljs.core.next(seq35756);
return milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic(G__35757,seq35756__$1);
});

