// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.retry');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('cljs.core.async');
goog.require('milia.api.http');
milia.utils.retry.default_max_retries = (1);
milia.utils.retry.default_retry_for_statuses = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(502),(503),(504)], null);
milia.utils.retry.initial_polling_interval = (1000);
milia.utils.retry.retry_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$max_DASH_retries,cljs.core.cst$kw$retry_DASH_for_DASH_statuses], null);
/**
 * Retry if a status code in retry-for-statuses is returned. Pauses for an
 * exponentially backedoff initial-polling-interval in ClojureScript. Does not
 * pause between retries in Clojure.
 */
milia.utils.retry.retry_parse_http = (function milia$utils$retry$retry_parse_http(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35601 = arguments.length;
var i__7652__auto___35602 = (0);
while(true){
if((i__7652__auto___35602 < len__7651__auto___35601)){
args__7658__auto__.push((arguments[i__7652__auto___35602]));

var G__35603 = (i__7652__auto___35602 + (1));
i__7652__auto___35602 = G__35603;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__35514){
var map__35515 = p__35514;
var map__35515__$1 = ((((!((map__35515 == null)))?((((map__35515.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35515.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35515):map__35515);
var options = map__35515__$1;
var max_retries = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35515__$1,cljs.core.cst$kw$max_DASH_retries,milia.utils.retry.default_max_retries);
var retry_for_statuses = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35515__$1,cljs.core.cst$kw$retry_DASH_for_DASH_statuses,milia.utils.retry.default_retry_for_statuses);
var c__19292__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto__,map__35515,map__35515__$1,options,max_retries,retry_for_statuses){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto__,map__35515,map__35515__$1,options,max_retries,retry_for_statuses){
return (function (state_35566){
var state_val_35567 = (state_35566[(1)]);
if((state_val_35567 === (7))){
var inst_35540 = (state_35566[(2)]);
var state_35566__$1 = state_35566;
if(cljs.core.truth_(inst_35540)){
var statearr_35568_35604 = state_35566__$1;
(statearr_35568_35604[(1)] = (11));

} else {
var statearr_35569_35605 = state_35566__$1;
(statearr_35569_35605[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (20))){
var inst_35517 = (state_35566[(7)]);
var inst_35518 = (state_35566[(8)]);
var inst_35556 = (state_35566[(2)]);
var inst_35557 = (inst_35517 * (2));
var inst_35558 = (inst_35518 + (1));
var inst_35517__$1 = inst_35557;
var inst_35518__$1 = inst_35558;
var state_35566__$1 = (function (){var statearr_35570 = state_35566;
(statearr_35570[(7)] = inst_35517__$1);

(statearr_35570[(8)] = inst_35518__$1);

(statearr_35570[(9)] = inst_35556);

return statearr_35570;
})();
var statearr_35571_35606 = state_35566__$1;
(statearr_35571_35606[(2)] = null);

(statearr_35571_35606[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (1))){
var inst_35517 = milia.utils.retry.initial_polling_interval;
var inst_35518 = (0);
var state_35566__$1 = (function (){var statearr_35572 = state_35566;
(statearr_35572[(7)] = inst_35517);

(statearr_35572[(8)] = inst_35518);

return statearr_35572;
})();
var statearr_35573_35607 = state_35566__$1;
(statearr_35573_35607[(2)] = null);

(statearr_35573_35607[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (4))){
var inst_35524 = (state_35566[(10)]);
var inst_35524__$1 = (state_35566[(2)]);
var inst_35526 = (inst_35524__$1 == null);
var inst_35527 = cljs.core.not(inst_35526);
var state_35566__$1 = (function (){var statearr_35574 = state_35566;
(statearr_35574[(10)] = inst_35524__$1);

return statearr_35574;
})();
if(inst_35527){
var statearr_35575_35608 = state_35566__$1;
(statearr_35575_35608[(1)] = (5));

} else {
var statearr_35576_35609 = state_35566__$1;
(statearr_35576_35609[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (15))){
var inst_35547 = (state_35566[(11)]);
var state_35566__$1 = state_35566;
var statearr_35577_35610 = state_35566__$1;
(statearr_35577_35610[(2)] = inst_35547);

(statearr_35577_35610[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (13))){
var inst_35545 = (state_35566[(12)]);
var inst_35547 = (state_35566[(11)]);
var inst_35545__$1 = (state_35566[(2)]);
var inst_35546 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35545__$1,cljs.core.cst$kw$status);
var inst_35547__$1 = chimera.seq.in_QMARK_(retry_for_statuses,inst_35546);
var state_35566__$1 = (function (){var statearr_35578 = state_35566;
(statearr_35578[(12)] = inst_35545__$1);

(statearr_35578[(11)] = inst_35547__$1);

return statearr_35578;
})();
if(cljs.core.truth_(inst_35547__$1)){
var statearr_35579_35611 = state_35566__$1;
(statearr_35579_35611[(1)] = (14));

} else {
var statearr_35580_35612 = state_35566__$1;
(statearr_35580_35612[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (6))){
var state_35566__$1 = state_35566;
var statearr_35581_35613 = state_35566__$1;
(statearr_35581_35613[(2)] = false);

(statearr_35581_35613[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (17))){
var inst_35517 = (state_35566[(7)]);
var inst_35554 = cljs.core.async.timeout(inst_35517);
var state_35566__$1 = state_35566;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35566__$1,(20),inst_35554);
} else {
if((state_val_35567 === (3))){
var inst_35564 = (state_35566[(2)]);
var state_35566__$1 = state_35566;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35566__$1,inst_35564);
} else {
if((state_val_35567 === (12))){
var inst_35524 = (state_35566[(10)]);
var state_35566__$1 = state_35566;
var statearr_35582_35614 = state_35566__$1;
(statearr_35582_35614[(2)] = inst_35524);

(statearr_35582_35614[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (2))){
var inst_35521 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,options,milia.utils.retry.retry_keys);
var inst_35522 = chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(milia.api.http.parse_http,cljs.core.array_seq([method,url,inst_35521], 0));
var state_35566__$1 = state_35566;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35566__$1,(4),inst_35522);
} else {
if((state_val_35567 === (19))){
var inst_35562 = (state_35566[(2)]);
var state_35566__$1 = state_35566;
var statearr_35583_35615 = state_35566__$1;
(statearr_35583_35615[(2)] = inst_35562);

(statearr_35583_35615[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (11))){
var inst_35524 = (state_35566[(10)]);
var inst_35542 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35524);
var state_35566__$1 = state_35566;
var statearr_35584_35616 = state_35566__$1;
(statearr_35584_35616[(2)] = inst_35542);

(statearr_35584_35616[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (9))){
var state_35566__$1 = state_35566;
var statearr_35585_35617 = state_35566__$1;
(statearr_35585_35617[(2)] = false);

(statearr_35585_35617[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (5))){
var inst_35524 = (state_35566[(10)]);
var inst_35529 = inst_35524.cljs$lang$protocol_mask$partition0$;
var inst_35530 = (inst_35529 & (64));
var inst_35531 = inst_35524.cljs$core$ISeq$;
var inst_35532 = (cljs.core.PROTOCOL_SENTINEL === inst_35531);
var inst_35533 = (inst_35530) || (inst_35532);
var state_35566__$1 = state_35566;
if(cljs.core.truth_(inst_35533)){
var statearr_35586_35618 = state_35566__$1;
(statearr_35586_35618[(1)] = (8));

} else {
var statearr_35587_35619 = state_35566__$1;
(statearr_35587_35619[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (14))){
var inst_35518 = (state_35566[(8)]);
var inst_35549 = (inst_35518 < max_retries);
var state_35566__$1 = state_35566;
var statearr_35588_35620 = state_35566__$1;
(statearr_35588_35620[(2)] = inst_35549);

(statearr_35588_35620[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (16))){
var inst_35552 = (state_35566[(2)]);
var state_35566__$1 = state_35566;
if(cljs.core.truth_(inst_35552)){
var statearr_35589_35621 = state_35566__$1;
(statearr_35589_35621[(1)] = (17));

} else {
var statearr_35590_35622 = state_35566__$1;
(statearr_35590_35622[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (10))){
var inst_35537 = (state_35566[(2)]);
var state_35566__$1 = state_35566;
var statearr_35591_35623 = state_35566__$1;
(statearr_35591_35623[(2)] = inst_35537);

(statearr_35591_35623[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (18))){
var inst_35545 = (state_35566[(12)]);
var state_35566__$1 = state_35566;
var statearr_35592_35624 = state_35566__$1;
(statearr_35592_35624[(2)] = inst_35545);

(statearr_35592_35624[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35567 === (8))){
var state_35566__$1 = state_35566;
var statearr_35593_35625 = state_35566__$1;
(statearr_35593_35625[(2)] = true);

(statearr_35593_35625[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto__,map__35515,map__35515__$1,options,max_retries,retry_for_statuses))
;
return ((function (switch__19180__auto__,c__19292__auto__,map__35515,map__35515__$1,options,max_retries,retry_for_statuses){
return (function() {
var milia$utils$retry$state_machine__19181__auto__ = null;
var milia$utils$retry$state_machine__19181__auto____0 = (function (){
var statearr_35597 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35597[(0)] = milia$utils$retry$state_machine__19181__auto__);

(statearr_35597[(1)] = (1));

return statearr_35597;
});
var milia$utils$retry$state_machine__19181__auto____1 = (function (state_35566){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_35566);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e35598){if((e35598 instanceof Object)){
var ex__19184__auto__ = e35598;
var statearr_35599_35626 = state_35566;
(statearr_35599_35626[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35566);

return cljs.core.cst$kw$recur;
} else {
throw e35598;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__35627 = state_35566;
state_35566 = G__35627;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
milia$utils$retry$state_machine__19181__auto__ = function(state_35566){
switch(arguments.length){
case 0:
return milia$utils$retry$state_machine__19181__auto____0.call(this);
case 1:
return milia$utils$retry$state_machine__19181__auto____1.call(this,state_35566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$utils$retry$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = milia$utils$retry$state_machine__19181__auto____0;
milia$utils$retry$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = milia$utils$retry$state_machine__19181__auto____1;
return milia$utils$retry$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto__,map__35515,map__35515__$1,options,max_retries,retry_for_statuses))
})();
var state__19294__auto__ = (function (){var statearr_35600 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_35600[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto__);

return statearr_35600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto__,map__35515,map__35515__$1,options,max_retries,retry_for_statuses))
);

return c__19292__auto__;
});

milia.utils.retry.retry_parse_http.cljs$lang$maxFixedArity = (2);

milia.utils.retry.retry_parse_http.cljs$lang$applyTo = (function (seq35511){
var G__35512 = cljs.core.first(seq35511);
var seq35511__$1 = cljs.core.next(seq35511);
var G__35513 = cljs.core.first(seq35511__$1);
var seq35511__$2 = cljs.core.next(seq35511__$1);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(G__35512,G__35513,seq35511__$2);
});

