// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args31809 = [];
var len__7651__auto___31815 = arguments.length;
var i__7652__auto___31816 = (0);
while(true){
if((i__7652__auto___31816 < len__7651__auto___31815)){
args31809.push((arguments[i__7652__auto___31816]));

var G__31817 = (i__7652__auto___31816 + (1));
i__7652__auto___31816 = G__31817;
continue;
} else {
}
break;
}

var G__31811 = args31809.length;
switch (G__31811) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31809.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async31812 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31812 = (function (f,blockable,meta31813){
this.f = f;
this.blockable = blockable;
this.meta31813 = meta31813;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31812.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31814,meta31813__$1){
var self__ = this;
var _31814__$1 = this;
return (new cljs.core.async.t_cljs$core$async31812(self__.f,self__.blockable,meta31813__$1));
});

cljs.core.async.t_cljs$core$async31812.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31814){
var self__ = this;
var _31814__$1 = this;
return self__.meta31813;
});

cljs.core.async.t_cljs$core$async31812.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31812.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31812.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async31812.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async31812.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta31813], null);
});

cljs.core.async.t_cljs$core$async31812.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31812.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31812";

cljs.core.async.t_cljs$core$async31812.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async31812");
});

cljs.core.async.__GT_t_cljs$core$async31812 = (function cljs$core$async$__GT_t_cljs$core$async31812(f__$1,blockable__$1,meta31813){
return (new cljs.core.async.t_cljs$core$async31812(f__$1,blockable__$1,meta31813));
});

}

return (new cljs.core.async.t_cljs$core$async31812(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args31821 = [];
var len__7651__auto___31824 = arguments.length;
var i__7652__auto___31825 = (0);
while(true){
if((i__7652__auto___31825 < len__7651__auto___31824)){
args31821.push((arguments[i__7652__auto___31825]));

var G__31826 = (i__7652__auto___31825 + (1));
i__7652__auto___31825 = G__31826;
continue;
} else {
}
break;
}

var G__31823 = args31821.length;
switch (G__31823) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31821.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args31828 = [];
var len__7651__auto___31831 = arguments.length;
var i__7652__auto___31832 = (0);
while(true){
if((i__7652__auto___31832 < len__7651__auto___31831)){
args31828.push((arguments[i__7652__auto___31832]));

var G__31833 = (i__7652__auto___31832 + (1));
i__7652__auto___31832 = G__31833;
continue;
} else {
}
break;
}

var G__31830 = args31828.length;
switch (G__31830) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31828.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args31835 = [];
var len__7651__auto___31838 = arguments.length;
var i__7652__auto___31839 = (0);
while(true){
if((i__7652__auto___31839 < len__7651__auto___31838)){
args31835.push((arguments[i__7652__auto___31839]));

var G__31840 = (i__7652__auto___31839 + (1));
i__7652__auto___31839 = G__31840;
continue;
} else {
}
break;
}

var G__31837 = args31835.length;
switch (G__31837) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31835.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_31842 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31842) : fn1.call(null,val_31842));
} else {
cljs.core.async.impl.dispatch.run(((function (val_31842,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31842) : fn1.call(null,val_31842));
});})(val_31842,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args31843 = [];
var len__7651__auto___31846 = arguments.length;
var i__7652__auto___31847 = (0);
while(true){
if((i__7652__auto___31847 < len__7651__auto___31846)){
args31843.push((arguments[i__7652__auto___31847]));

var G__31848 = (i__7652__auto___31847 + (1));
i__7652__auto___31847 = G__31848;
continue;
} else {
}
break;
}

var G__31845 = args31843.length;
switch (G__31845) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31843.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7461__auto___31850 = n;
var x_31851 = (0);
while(true){
if((x_31851 < n__7461__auto___31850)){
(a[x_31851] = (0));

var G__31852 = (x_31851 + (1));
x_31851 = G__31852;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__31853 = (i + (1));
i = G__31853;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async31857 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31857 = (function (flag,meta31858){
this.flag = flag;
this.meta31858 = meta31858;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31857.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31859,meta31858__$1){
var self__ = this;
var _31859__$1 = this;
return (new cljs.core.async.t_cljs$core$async31857(self__.flag,meta31858__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31857.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31859){
var self__ = this;
var _31859__$1 = this;
return self__.meta31858;
});})(flag))
;

cljs.core.async.t_cljs$core$async31857.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31857.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async31857.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31857.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31857.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta31858], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31857.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31857.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31857";

cljs.core.async.t_cljs$core$async31857.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async31857");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31857 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31857(flag__$1,meta31858){
return (new cljs.core.async.t_cljs$core$async31857(flag__$1,meta31858));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31857(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31863 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31863 = (function (flag,cb,meta31864){
this.flag = flag;
this.cb = cb;
this.meta31864 = meta31864;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31863.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31865,meta31864__$1){
var self__ = this;
var _31865__$1 = this;
return (new cljs.core.async.t_cljs$core$async31863(self__.flag,self__.cb,meta31864__$1));
});

cljs.core.async.t_cljs$core$async31863.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31865){
var self__ = this;
var _31865__$1 = this;
return self__.meta31864;
});

cljs.core.async.t_cljs$core$async31863.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31863.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async31863.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31863.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31863.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta31864], null);
});

cljs.core.async.t_cljs$core$async31863.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31863.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31863";

cljs.core.async.t_cljs$core$async31863.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async31863");
});

cljs.core.async.__GT_t_cljs$core$async31863 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31863(flag__$1,cb__$1,meta31864){
return (new cljs.core.async.t_cljs$core$async31863(flag__$1,cb__$1,meta31864));
});

}

return (new cljs.core.async.t_cljs$core$async31863(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31866_SHARP_){
var G__31870 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31866_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31870) : fret.call(null,G__31870));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31867_SHARP_){
var G__31871 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31867_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31871) : fret.call(null,G__31871));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6543__auto__ = wport;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31872 = (i + (1));
i = G__31872;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6543__auto__ = ret;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6531__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31878 = arguments.length;
var i__7652__auto___31879 = (0);
while(true){
if((i__7652__auto___31879 < len__7651__auto___31878)){
args__7658__auto__.push((arguments[i__7652__auto___31879]));

var G__31880 = (i__7652__auto___31879 + (1));
i__7652__auto___31879 = G__31880;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31875){
var map__31876 = p__31875;
var map__31876__$1 = ((((!((map__31876 == null)))?((((map__31876.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31876.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31876):map__31876);
var opts = map__31876__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31873){
var G__31874 = cljs.core.first(seq31873);
var seq31873__$1 = cljs.core.next(seq31873);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31874,seq31873__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args31881 = [];
var len__7651__auto___31931 = arguments.length;
var i__7652__auto___31932 = (0);
while(true){
if((i__7652__auto___31932 < len__7651__auto___31931)){
args31881.push((arguments[i__7652__auto___31932]));

var G__31933 = (i__7652__auto___31932 + (1));
i__7652__auto___31932 = G__31933;
continue;
} else {
}
break;
}

var G__31883 = args31881.length;
switch (G__31883) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31881.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__19175__auto___31935 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___31935){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___31935){
return (function (state_31907){
var state_val_31908 = (state_31907[(1)]);
if((state_val_31908 === (7))){
var inst_31903 = (state_31907[(2)]);
var state_31907__$1 = state_31907;
var statearr_31909_31936 = state_31907__$1;
(statearr_31909_31936[(2)] = inst_31903);

(statearr_31909_31936[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31908 === (1))){
var state_31907__$1 = state_31907;
var statearr_31910_31937 = state_31907__$1;
(statearr_31910_31937[(2)] = null);

(statearr_31910_31937[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31908 === (4))){
var inst_31886 = (state_31907[(7)]);
var inst_31886__$1 = (state_31907[(2)]);
var inst_31887 = (inst_31886__$1 == null);
var state_31907__$1 = (function (){var statearr_31911 = state_31907;
(statearr_31911[(7)] = inst_31886__$1);

return statearr_31911;
})();
if(cljs.core.truth_(inst_31887)){
var statearr_31912_31938 = state_31907__$1;
(statearr_31912_31938[(1)] = (5));

} else {
var statearr_31913_31939 = state_31907__$1;
(statearr_31913_31939[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31908 === (13))){
var state_31907__$1 = state_31907;
var statearr_31914_31940 = state_31907__$1;
(statearr_31914_31940[(2)] = null);

(statearr_31914_31940[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31908 === (6))){
var inst_31886 = (state_31907[(7)]);
var state_31907__$1 = state_31907;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31907__$1,(11),to,inst_31886);
} else {
if((state_val_31908 === (3))){
var inst_31905 = (state_31907[(2)]);
var state_31907__$1 = state_31907;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31907__$1,inst_31905);
} else {
if((state_val_31908 === (12))){
var state_31907__$1 = state_31907;
var statearr_31915_31941 = state_31907__$1;
(statearr_31915_31941[(2)] = null);

(statearr_31915_31941[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31908 === (2))){
var state_31907__$1 = state_31907;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31907__$1,(4),from);
} else {
if((state_val_31908 === (11))){
var inst_31896 = (state_31907[(2)]);
var state_31907__$1 = state_31907;
if(cljs.core.truth_(inst_31896)){
var statearr_31916_31942 = state_31907__$1;
(statearr_31916_31942[(1)] = (12));

} else {
var statearr_31917_31943 = state_31907__$1;
(statearr_31917_31943[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31908 === (9))){
var state_31907__$1 = state_31907;
var statearr_31918_31944 = state_31907__$1;
(statearr_31918_31944[(2)] = null);

(statearr_31918_31944[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31908 === (5))){
var state_31907__$1 = state_31907;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31919_31945 = state_31907__$1;
(statearr_31919_31945[(1)] = (8));

} else {
var statearr_31920_31946 = state_31907__$1;
(statearr_31920_31946[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31908 === (14))){
var inst_31901 = (state_31907[(2)]);
var state_31907__$1 = state_31907;
var statearr_31921_31947 = state_31907__$1;
(statearr_31921_31947[(2)] = inst_31901);

(statearr_31921_31947[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31908 === (10))){
var inst_31893 = (state_31907[(2)]);
var state_31907__$1 = state_31907;
var statearr_31922_31948 = state_31907__$1;
(statearr_31922_31948[(2)] = inst_31893);

(statearr_31922_31948[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31908 === (8))){
var inst_31890 = cljs.core.async.close_BANG_(to);
var state_31907__$1 = state_31907;
var statearr_31923_31949 = state_31907__$1;
(statearr_31923_31949[(2)] = inst_31890);

(statearr_31923_31949[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___31935))
;
return ((function (switch__19063__auto__,c__19175__auto___31935){
return (function() {
var cljs$core$async$state_machine__19064__auto__ = null;
var cljs$core$async$state_machine__19064__auto____0 = (function (){
var statearr_31927 = [null,null,null,null,null,null,null,null];
(statearr_31927[(0)] = cljs$core$async$state_machine__19064__auto__);

(statearr_31927[(1)] = (1));

return statearr_31927;
});
var cljs$core$async$state_machine__19064__auto____1 = (function (state_31907){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_31907);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e31928){if((e31928 instanceof Object)){
var ex__19067__auto__ = e31928;
var statearr_31929_31950 = state_31907;
(statearr_31929_31950[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31907);

return cljs.core.cst$kw$recur;
} else {
throw e31928;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__31951 = state_31907;
state_31907 = G__31951;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$state_machine__19064__auto__ = function(state_31907){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19064__auto____1.call(this,state_31907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19064__auto____0;
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19064__auto____1;
return cljs$core$async$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___31935))
})();
var state__19177__auto__ = (function (){var statearr_31930 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_31930[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___31935);

return statearr_31930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___31935))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__32139){
var vec__32140 = p__32139;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32140,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32140,(1),null);
var job = vec__32140;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__19175__auto___32326 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___32326,res,vec__32140,v,p,job,jobs,results){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___32326,res,vec__32140,v,p,job,jobs,results){
return (function (state_32147){
var state_val_32148 = (state_32147[(1)]);
if((state_val_32148 === (1))){
var state_32147__$1 = state_32147;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32147__$1,(2),res,v);
} else {
if((state_val_32148 === (2))){
var inst_32144 = (state_32147[(2)]);
var inst_32145 = cljs.core.async.close_BANG_(res);
var state_32147__$1 = (function (){var statearr_32149 = state_32147;
(statearr_32149[(7)] = inst_32144);

return statearr_32149;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32147__$1,inst_32145);
} else {
return null;
}
}
});})(c__19175__auto___32326,res,vec__32140,v,p,job,jobs,results))
;
return ((function (switch__19063__auto__,c__19175__auto___32326,res,vec__32140,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0 = (function (){
var statearr_32153 = [null,null,null,null,null,null,null,null];
(statearr_32153[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__);

(statearr_32153[(1)] = (1));

return statearr_32153;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1 = (function (state_32147){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_32147);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e32154){if((e32154 instanceof Object)){
var ex__19067__auto__ = e32154;
var statearr_32155_32327 = state_32147;
(statearr_32155_32327[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32147);

return cljs.core.cst$kw$recur;
} else {
throw e32154;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__32328 = state_32147;
state_32147 = G__32328;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__ = function(state_32147){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1.call(this,state_32147);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___32326,res,vec__32140,v,p,job,jobs,results))
})();
var state__19177__auto__ = (function (){var statearr_32156 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_32156[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___32326);

return statearr_32156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___32326,res,vec__32140,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__32157){
var vec__32158 = p__32157;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32158,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32158,(1),null);
var job = vec__32158;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7461__auto___32329 = n;
var __32330 = (0);
while(true){
if((__32330 < n__7461__auto___32329)){
var G__32161_32331 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__32161_32331) {
case "compute":
var c__19175__auto___32333 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32330,c__19175__auto___32333,G__32161_32331,n__7461__auto___32329,jobs,results,process,async){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (__32330,c__19175__auto___32333,G__32161_32331,n__7461__auto___32329,jobs,results,process,async){
return (function (state_32174){
var state_val_32175 = (state_32174[(1)]);
if((state_val_32175 === (1))){
var state_32174__$1 = state_32174;
var statearr_32176_32334 = state_32174__$1;
(statearr_32176_32334[(2)] = null);

(statearr_32176_32334[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32175 === (2))){
var state_32174__$1 = state_32174;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32174__$1,(4),jobs);
} else {
if((state_val_32175 === (3))){
var inst_32172 = (state_32174[(2)]);
var state_32174__$1 = state_32174;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32174__$1,inst_32172);
} else {
if((state_val_32175 === (4))){
var inst_32164 = (state_32174[(2)]);
var inst_32165 = process(inst_32164);
var state_32174__$1 = state_32174;
if(cljs.core.truth_(inst_32165)){
var statearr_32177_32335 = state_32174__$1;
(statearr_32177_32335[(1)] = (5));

} else {
var statearr_32178_32336 = state_32174__$1;
(statearr_32178_32336[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32175 === (5))){
var state_32174__$1 = state_32174;
var statearr_32179_32337 = state_32174__$1;
(statearr_32179_32337[(2)] = null);

(statearr_32179_32337[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32175 === (6))){
var state_32174__$1 = state_32174;
var statearr_32180_32338 = state_32174__$1;
(statearr_32180_32338[(2)] = null);

(statearr_32180_32338[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32175 === (7))){
var inst_32170 = (state_32174[(2)]);
var state_32174__$1 = state_32174;
var statearr_32181_32339 = state_32174__$1;
(statearr_32181_32339[(2)] = inst_32170);

(statearr_32181_32339[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__32330,c__19175__auto___32333,G__32161_32331,n__7461__auto___32329,jobs,results,process,async))
;
return ((function (__32330,switch__19063__auto__,c__19175__auto___32333,G__32161_32331,n__7461__auto___32329,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0 = (function (){
var statearr_32185 = [null,null,null,null,null,null,null];
(statearr_32185[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__);

(statearr_32185[(1)] = (1));

return statearr_32185;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1 = (function (state_32174){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_32174);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e32186){if((e32186 instanceof Object)){
var ex__19067__auto__ = e32186;
var statearr_32187_32340 = state_32174;
(statearr_32187_32340[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32174);

return cljs.core.cst$kw$recur;
} else {
throw e32186;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__32341 = state_32174;
state_32174 = G__32341;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__ = function(state_32174){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1.call(this,state_32174);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__;
})()
;})(__32330,switch__19063__auto__,c__19175__auto___32333,G__32161_32331,n__7461__auto___32329,jobs,results,process,async))
})();
var state__19177__auto__ = (function (){var statearr_32188 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_32188[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___32333);

return statearr_32188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(__32330,c__19175__auto___32333,G__32161_32331,n__7461__auto___32329,jobs,results,process,async))
);


break;
case "async":
var c__19175__auto___32342 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32330,c__19175__auto___32342,G__32161_32331,n__7461__auto___32329,jobs,results,process,async){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (__32330,c__19175__auto___32342,G__32161_32331,n__7461__auto___32329,jobs,results,process,async){
return (function (state_32201){
var state_val_32202 = (state_32201[(1)]);
if((state_val_32202 === (1))){
var state_32201__$1 = state_32201;
var statearr_32203_32343 = state_32201__$1;
(statearr_32203_32343[(2)] = null);

(statearr_32203_32343[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32202 === (2))){
var state_32201__$1 = state_32201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32201__$1,(4),jobs);
} else {
if((state_val_32202 === (3))){
var inst_32199 = (state_32201[(2)]);
var state_32201__$1 = state_32201;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32201__$1,inst_32199);
} else {
if((state_val_32202 === (4))){
var inst_32191 = (state_32201[(2)]);
var inst_32192 = async(inst_32191);
var state_32201__$1 = state_32201;
if(cljs.core.truth_(inst_32192)){
var statearr_32204_32344 = state_32201__$1;
(statearr_32204_32344[(1)] = (5));

} else {
var statearr_32205_32345 = state_32201__$1;
(statearr_32205_32345[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32202 === (5))){
var state_32201__$1 = state_32201;
var statearr_32206_32346 = state_32201__$1;
(statearr_32206_32346[(2)] = null);

(statearr_32206_32346[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32202 === (6))){
var state_32201__$1 = state_32201;
var statearr_32207_32347 = state_32201__$1;
(statearr_32207_32347[(2)] = null);

(statearr_32207_32347[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32202 === (7))){
var inst_32197 = (state_32201[(2)]);
var state_32201__$1 = state_32201;
var statearr_32208_32348 = state_32201__$1;
(statearr_32208_32348[(2)] = inst_32197);

(statearr_32208_32348[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__32330,c__19175__auto___32342,G__32161_32331,n__7461__auto___32329,jobs,results,process,async))
;
return ((function (__32330,switch__19063__auto__,c__19175__auto___32342,G__32161_32331,n__7461__auto___32329,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0 = (function (){
var statearr_32212 = [null,null,null,null,null,null,null];
(statearr_32212[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__);

(statearr_32212[(1)] = (1));

return statearr_32212;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1 = (function (state_32201){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_32201);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e32213){if((e32213 instanceof Object)){
var ex__19067__auto__ = e32213;
var statearr_32214_32349 = state_32201;
(statearr_32214_32349[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32201);

return cljs.core.cst$kw$recur;
} else {
throw e32213;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__32350 = state_32201;
state_32201 = G__32350;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__ = function(state_32201){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1.call(this,state_32201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__;
})()
;})(__32330,switch__19063__auto__,c__19175__auto___32342,G__32161_32331,n__7461__auto___32329,jobs,results,process,async))
})();
var state__19177__auto__ = (function (){var statearr_32215 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_32215[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___32342);

return statearr_32215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(__32330,c__19175__auto___32342,G__32161_32331,n__7461__auto___32329,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__32351 = (__32330 + (1));
__32330 = G__32351;
continue;
} else {
}
break;
}

var c__19175__auto___32352 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___32352,jobs,results,process,async){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___32352,jobs,results,process,async){
return (function (state_32237){
var state_val_32238 = (state_32237[(1)]);
if((state_val_32238 === (1))){
var state_32237__$1 = state_32237;
var statearr_32239_32353 = state_32237__$1;
(statearr_32239_32353[(2)] = null);

(statearr_32239_32353[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32238 === (2))){
var state_32237__$1 = state_32237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32237__$1,(4),from);
} else {
if((state_val_32238 === (3))){
var inst_32235 = (state_32237[(2)]);
var state_32237__$1 = state_32237;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32237__$1,inst_32235);
} else {
if((state_val_32238 === (4))){
var inst_32218 = (state_32237[(7)]);
var inst_32218__$1 = (state_32237[(2)]);
var inst_32219 = (inst_32218__$1 == null);
var state_32237__$1 = (function (){var statearr_32240 = state_32237;
(statearr_32240[(7)] = inst_32218__$1);

return statearr_32240;
})();
if(cljs.core.truth_(inst_32219)){
var statearr_32241_32354 = state_32237__$1;
(statearr_32241_32354[(1)] = (5));

} else {
var statearr_32242_32355 = state_32237__$1;
(statearr_32242_32355[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32238 === (5))){
var inst_32221 = cljs.core.async.close_BANG_(jobs);
var state_32237__$1 = state_32237;
var statearr_32243_32356 = state_32237__$1;
(statearr_32243_32356[(2)] = inst_32221);

(statearr_32243_32356[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32238 === (6))){
var inst_32218 = (state_32237[(7)]);
var inst_32223 = (state_32237[(8)]);
var inst_32223__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_32224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32225 = [inst_32218,inst_32223__$1];
var inst_32226 = (new cljs.core.PersistentVector(null,2,(5),inst_32224,inst_32225,null));
var state_32237__$1 = (function (){var statearr_32244 = state_32237;
(statearr_32244[(8)] = inst_32223__$1);

return statearr_32244;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32237__$1,(8),jobs,inst_32226);
} else {
if((state_val_32238 === (7))){
var inst_32233 = (state_32237[(2)]);
var state_32237__$1 = state_32237;
var statearr_32245_32357 = state_32237__$1;
(statearr_32245_32357[(2)] = inst_32233);

(statearr_32245_32357[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32238 === (8))){
var inst_32223 = (state_32237[(8)]);
var inst_32228 = (state_32237[(2)]);
var state_32237__$1 = (function (){var statearr_32246 = state_32237;
(statearr_32246[(9)] = inst_32228);

return statearr_32246;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32237__$1,(9),results,inst_32223);
} else {
if((state_val_32238 === (9))){
var inst_32230 = (state_32237[(2)]);
var state_32237__$1 = (function (){var statearr_32247 = state_32237;
(statearr_32247[(10)] = inst_32230);

return statearr_32247;
})();
var statearr_32248_32358 = state_32237__$1;
(statearr_32248_32358[(2)] = null);

(statearr_32248_32358[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___32352,jobs,results,process,async))
;
return ((function (switch__19063__auto__,c__19175__auto___32352,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0 = (function (){
var statearr_32252 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32252[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__);

(statearr_32252[(1)] = (1));

return statearr_32252;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1 = (function (state_32237){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_32237);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e32253){if((e32253 instanceof Object)){
var ex__19067__auto__ = e32253;
var statearr_32254_32359 = state_32237;
(statearr_32254_32359[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32237);

return cljs.core.cst$kw$recur;
} else {
throw e32253;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__32360 = state_32237;
state_32237 = G__32360;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__ = function(state_32237){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1.call(this,state_32237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___32352,jobs,results,process,async))
})();
var state__19177__auto__ = (function (){var statearr_32255 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_32255[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___32352);

return statearr_32255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___32352,jobs,results,process,async))
);


var c__19175__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto__,jobs,results,process,async){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto__,jobs,results,process,async){
return (function (state_32293){
var state_val_32294 = (state_32293[(1)]);
if((state_val_32294 === (7))){
var inst_32289 = (state_32293[(2)]);
var state_32293__$1 = state_32293;
var statearr_32295_32361 = state_32293__$1;
(statearr_32295_32361[(2)] = inst_32289);

(statearr_32295_32361[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (20))){
var state_32293__$1 = state_32293;
var statearr_32296_32362 = state_32293__$1;
(statearr_32296_32362[(2)] = null);

(statearr_32296_32362[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (1))){
var state_32293__$1 = state_32293;
var statearr_32297_32363 = state_32293__$1;
(statearr_32297_32363[(2)] = null);

(statearr_32297_32363[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (4))){
var inst_32258 = (state_32293[(7)]);
var inst_32258__$1 = (state_32293[(2)]);
var inst_32259 = (inst_32258__$1 == null);
var state_32293__$1 = (function (){var statearr_32298 = state_32293;
(statearr_32298[(7)] = inst_32258__$1);

return statearr_32298;
})();
if(cljs.core.truth_(inst_32259)){
var statearr_32299_32364 = state_32293__$1;
(statearr_32299_32364[(1)] = (5));

} else {
var statearr_32300_32365 = state_32293__$1;
(statearr_32300_32365[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (15))){
var inst_32271 = (state_32293[(8)]);
var state_32293__$1 = state_32293;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32293__$1,(18),to,inst_32271);
} else {
if((state_val_32294 === (21))){
var inst_32284 = (state_32293[(2)]);
var state_32293__$1 = state_32293;
var statearr_32301_32366 = state_32293__$1;
(statearr_32301_32366[(2)] = inst_32284);

(statearr_32301_32366[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (13))){
var inst_32286 = (state_32293[(2)]);
var state_32293__$1 = (function (){var statearr_32302 = state_32293;
(statearr_32302[(9)] = inst_32286);

return statearr_32302;
})();
var statearr_32303_32367 = state_32293__$1;
(statearr_32303_32367[(2)] = null);

(statearr_32303_32367[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (6))){
var inst_32258 = (state_32293[(7)]);
var state_32293__$1 = state_32293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32293__$1,(11),inst_32258);
} else {
if((state_val_32294 === (17))){
var inst_32279 = (state_32293[(2)]);
var state_32293__$1 = state_32293;
if(cljs.core.truth_(inst_32279)){
var statearr_32304_32368 = state_32293__$1;
(statearr_32304_32368[(1)] = (19));

} else {
var statearr_32305_32369 = state_32293__$1;
(statearr_32305_32369[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (3))){
var inst_32291 = (state_32293[(2)]);
var state_32293__$1 = state_32293;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32293__$1,inst_32291);
} else {
if((state_val_32294 === (12))){
var inst_32268 = (state_32293[(10)]);
var state_32293__$1 = state_32293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32293__$1,(14),inst_32268);
} else {
if((state_val_32294 === (2))){
var state_32293__$1 = state_32293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32293__$1,(4),results);
} else {
if((state_val_32294 === (19))){
var state_32293__$1 = state_32293;
var statearr_32306_32370 = state_32293__$1;
(statearr_32306_32370[(2)] = null);

(statearr_32306_32370[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (11))){
var inst_32268 = (state_32293[(2)]);
var state_32293__$1 = (function (){var statearr_32307 = state_32293;
(statearr_32307[(10)] = inst_32268);

return statearr_32307;
})();
var statearr_32308_32371 = state_32293__$1;
(statearr_32308_32371[(2)] = null);

(statearr_32308_32371[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (9))){
var state_32293__$1 = state_32293;
var statearr_32309_32372 = state_32293__$1;
(statearr_32309_32372[(2)] = null);

(statearr_32309_32372[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (5))){
var state_32293__$1 = state_32293;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32310_32373 = state_32293__$1;
(statearr_32310_32373[(1)] = (8));

} else {
var statearr_32311_32374 = state_32293__$1;
(statearr_32311_32374[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (14))){
var inst_32271 = (state_32293[(8)]);
var inst_32273 = (state_32293[(11)]);
var inst_32271__$1 = (state_32293[(2)]);
var inst_32272 = (inst_32271__$1 == null);
var inst_32273__$1 = cljs.core.not(inst_32272);
var state_32293__$1 = (function (){var statearr_32312 = state_32293;
(statearr_32312[(8)] = inst_32271__$1);

(statearr_32312[(11)] = inst_32273__$1);

return statearr_32312;
})();
if(inst_32273__$1){
var statearr_32313_32375 = state_32293__$1;
(statearr_32313_32375[(1)] = (15));

} else {
var statearr_32314_32376 = state_32293__$1;
(statearr_32314_32376[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (16))){
var inst_32273 = (state_32293[(11)]);
var state_32293__$1 = state_32293;
var statearr_32315_32377 = state_32293__$1;
(statearr_32315_32377[(2)] = inst_32273);

(statearr_32315_32377[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (10))){
var inst_32265 = (state_32293[(2)]);
var state_32293__$1 = state_32293;
var statearr_32316_32378 = state_32293__$1;
(statearr_32316_32378[(2)] = inst_32265);

(statearr_32316_32378[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (18))){
var inst_32276 = (state_32293[(2)]);
var state_32293__$1 = state_32293;
var statearr_32317_32379 = state_32293__$1;
(statearr_32317_32379[(2)] = inst_32276);

(statearr_32317_32379[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32294 === (8))){
var inst_32262 = cljs.core.async.close_BANG_(to);
var state_32293__$1 = state_32293;
var statearr_32318_32380 = state_32293__$1;
(statearr_32318_32380[(2)] = inst_32262);

(statearr_32318_32380[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto__,jobs,results,process,async))
;
return ((function (switch__19063__auto__,c__19175__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0 = (function (){
var statearr_32322 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32322[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__);

(statearr_32322[(1)] = (1));

return statearr_32322;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1 = (function (state_32293){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_32293);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e32323){if((e32323 instanceof Object)){
var ex__19067__auto__ = e32323;
var statearr_32324_32381 = state_32293;
(statearr_32324_32381[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32293);

return cljs.core.cst$kw$recur;
} else {
throw e32323;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__32382 = state_32293;
state_32293 = G__32382;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__ = function(state_32293){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1.call(this,state_32293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19064__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto__,jobs,results,process,async))
})();
var state__19177__auto__ = (function (){var statearr_32325 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_32325[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto__);

return statearr_32325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto__,jobs,results,process,async))
);

return c__19175__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args32383 = [];
var len__7651__auto___32386 = arguments.length;
var i__7652__auto___32387 = (0);
while(true){
if((i__7652__auto___32387 < len__7651__auto___32386)){
args32383.push((arguments[i__7652__auto___32387]));

var G__32388 = (i__7652__auto___32387 + (1));
i__7652__auto___32387 = G__32388;
continue;
} else {
}
break;
}

var G__32385 = args32383.length;
switch (G__32385) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32383.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args32390 = [];
var len__7651__auto___32393 = arguments.length;
var i__7652__auto___32394 = (0);
while(true){
if((i__7652__auto___32394 < len__7651__auto___32393)){
args32390.push((arguments[i__7652__auto___32394]));

var G__32395 = (i__7652__auto___32394 + (1));
i__7652__auto___32394 = G__32395;
continue;
} else {
}
break;
}

var G__32392 = args32390.length;
switch (G__32392) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32390.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args32397 = [];
var len__7651__auto___32450 = arguments.length;
var i__7652__auto___32451 = (0);
while(true){
if((i__7652__auto___32451 < len__7651__auto___32450)){
args32397.push((arguments[i__7652__auto___32451]));

var G__32452 = (i__7652__auto___32451 + (1));
i__7652__auto___32451 = G__32452;
continue;
} else {
}
break;
}

var G__32399 = args32397.length;
switch (G__32399) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32397.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__19175__auto___32454 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___32454,tc,fc){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___32454,tc,fc){
return (function (state_32425){
var state_val_32426 = (state_32425[(1)]);
if((state_val_32426 === (7))){
var inst_32421 = (state_32425[(2)]);
var state_32425__$1 = state_32425;
var statearr_32427_32455 = state_32425__$1;
(statearr_32427_32455[(2)] = inst_32421);

(statearr_32427_32455[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32426 === (1))){
var state_32425__$1 = state_32425;
var statearr_32428_32456 = state_32425__$1;
(statearr_32428_32456[(2)] = null);

(statearr_32428_32456[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32426 === (4))){
var inst_32402 = (state_32425[(7)]);
var inst_32402__$1 = (state_32425[(2)]);
var inst_32403 = (inst_32402__$1 == null);
var state_32425__$1 = (function (){var statearr_32429 = state_32425;
(statearr_32429[(7)] = inst_32402__$1);

return statearr_32429;
})();
if(cljs.core.truth_(inst_32403)){
var statearr_32430_32457 = state_32425__$1;
(statearr_32430_32457[(1)] = (5));

} else {
var statearr_32431_32458 = state_32425__$1;
(statearr_32431_32458[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32426 === (13))){
var state_32425__$1 = state_32425;
var statearr_32432_32459 = state_32425__$1;
(statearr_32432_32459[(2)] = null);

(statearr_32432_32459[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32426 === (6))){
var inst_32402 = (state_32425[(7)]);
var inst_32408 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_32402) : p.call(null,inst_32402));
var state_32425__$1 = state_32425;
if(cljs.core.truth_(inst_32408)){
var statearr_32433_32460 = state_32425__$1;
(statearr_32433_32460[(1)] = (9));

} else {
var statearr_32434_32461 = state_32425__$1;
(statearr_32434_32461[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32426 === (3))){
var inst_32423 = (state_32425[(2)]);
var state_32425__$1 = state_32425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32425__$1,inst_32423);
} else {
if((state_val_32426 === (12))){
var state_32425__$1 = state_32425;
var statearr_32435_32462 = state_32425__$1;
(statearr_32435_32462[(2)] = null);

(statearr_32435_32462[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32426 === (2))){
var state_32425__$1 = state_32425;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32425__$1,(4),ch);
} else {
if((state_val_32426 === (11))){
var inst_32402 = (state_32425[(7)]);
var inst_32412 = (state_32425[(2)]);
var state_32425__$1 = state_32425;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32425__$1,(8),inst_32412,inst_32402);
} else {
if((state_val_32426 === (9))){
var state_32425__$1 = state_32425;
var statearr_32436_32463 = state_32425__$1;
(statearr_32436_32463[(2)] = tc);

(statearr_32436_32463[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32426 === (5))){
var inst_32405 = cljs.core.async.close_BANG_(tc);
var inst_32406 = cljs.core.async.close_BANG_(fc);
var state_32425__$1 = (function (){var statearr_32437 = state_32425;
(statearr_32437[(8)] = inst_32405);

return statearr_32437;
})();
var statearr_32438_32464 = state_32425__$1;
(statearr_32438_32464[(2)] = inst_32406);

(statearr_32438_32464[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32426 === (14))){
var inst_32419 = (state_32425[(2)]);
var state_32425__$1 = state_32425;
var statearr_32439_32465 = state_32425__$1;
(statearr_32439_32465[(2)] = inst_32419);

(statearr_32439_32465[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32426 === (10))){
var state_32425__$1 = state_32425;
var statearr_32440_32466 = state_32425__$1;
(statearr_32440_32466[(2)] = fc);

(statearr_32440_32466[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32426 === (8))){
var inst_32414 = (state_32425[(2)]);
var state_32425__$1 = state_32425;
if(cljs.core.truth_(inst_32414)){
var statearr_32441_32467 = state_32425__$1;
(statearr_32441_32467[(1)] = (12));

} else {
var statearr_32442_32468 = state_32425__$1;
(statearr_32442_32468[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___32454,tc,fc))
;
return ((function (switch__19063__auto__,c__19175__auto___32454,tc,fc){
return (function() {
var cljs$core$async$state_machine__19064__auto__ = null;
var cljs$core$async$state_machine__19064__auto____0 = (function (){
var statearr_32446 = [null,null,null,null,null,null,null,null,null];
(statearr_32446[(0)] = cljs$core$async$state_machine__19064__auto__);

(statearr_32446[(1)] = (1));

return statearr_32446;
});
var cljs$core$async$state_machine__19064__auto____1 = (function (state_32425){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_32425);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e32447){if((e32447 instanceof Object)){
var ex__19067__auto__ = e32447;
var statearr_32448_32469 = state_32425;
(statearr_32448_32469[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32425);

return cljs.core.cst$kw$recur;
} else {
throw e32447;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__32470 = state_32425;
state_32425 = G__32470;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$state_machine__19064__auto__ = function(state_32425){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19064__auto____1.call(this,state_32425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19064__auto____0;
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19064__auto____1;
return cljs$core$async$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___32454,tc,fc))
})();
var state__19177__auto__ = (function (){var statearr_32449 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_32449[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___32454);

return statearr_32449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___32454,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__19175__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto__){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto__){
return (function (state_32534){
var state_val_32535 = (state_32534[(1)]);
if((state_val_32535 === (7))){
var inst_32530 = (state_32534[(2)]);
var state_32534__$1 = state_32534;
var statearr_32536_32557 = state_32534__$1;
(statearr_32536_32557[(2)] = inst_32530);

(statearr_32536_32557[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32535 === (1))){
var inst_32514 = init;
var state_32534__$1 = (function (){var statearr_32537 = state_32534;
(statearr_32537[(7)] = inst_32514);

return statearr_32537;
})();
var statearr_32538_32558 = state_32534__$1;
(statearr_32538_32558[(2)] = null);

(statearr_32538_32558[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32535 === (4))){
var inst_32517 = (state_32534[(8)]);
var inst_32517__$1 = (state_32534[(2)]);
var inst_32518 = (inst_32517__$1 == null);
var state_32534__$1 = (function (){var statearr_32539 = state_32534;
(statearr_32539[(8)] = inst_32517__$1);

return statearr_32539;
})();
if(cljs.core.truth_(inst_32518)){
var statearr_32540_32559 = state_32534__$1;
(statearr_32540_32559[(1)] = (5));

} else {
var statearr_32541_32560 = state_32534__$1;
(statearr_32541_32560[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32535 === (6))){
var inst_32517 = (state_32534[(8)]);
var inst_32521 = (state_32534[(9)]);
var inst_32514 = (state_32534[(7)]);
var inst_32521__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_32514,inst_32517) : f.call(null,inst_32514,inst_32517));
var inst_32522 = cljs.core.reduced_QMARK_(inst_32521__$1);
var state_32534__$1 = (function (){var statearr_32542 = state_32534;
(statearr_32542[(9)] = inst_32521__$1);

return statearr_32542;
})();
if(inst_32522){
var statearr_32543_32561 = state_32534__$1;
(statearr_32543_32561[(1)] = (8));

} else {
var statearr_32544_32562 = state_32534__$1;
(statearr_32544_32562[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32535 === (3))){
var inst_32532 = (state_32534[(2)]);
var state_32534__$1 = state_32534;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32534__$1,inst_32532);
} else {
if((state_val_32535 === (2))){
var state_32534__$1 = state_32534;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32534__$1,(4),ch);
} else {
if((state_val_32535 === (9))){
var inst_32521 = (state_32534[(9)]);
var inst_32514 = inst_32521;
var state_32534__$1 = (function (){var statearr_32545 = state_32534;
(statearr_32545[(7)] = inst_32514);

return statearr_32545;
})();
var statearr_32546_32563 = state_32534__$1;
(statearr_32546_32563[(2)] = null);

(statearr_32546_32563[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32535 === (5))){
var inst_32514 = (state_32534[(7)]);
var state_32534__$1 = state_32534;
var statearr_32547_32564 = state_32534__$1;
(statearr_32547_32564[(2)] = inst_32514);

(statearr_32547_32564[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32535 === (10))){
var inst_32528 = (state_32534[(2)]);
var state_32534__$1 = state_32534;
var statearr_32548_32565 = state_32534__$1;
(statearr_32548_32565[(2)] = inst_32528);

(statearr_32548_32565[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32535 === (8))){
var inst_32521 = (state_32534[(9)]);
var inst_32524 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_32521) : cljs.core.deref.call(null,inst_32521));
var state_32534__$1 = state_32534;
var statearr_32549_32566 = state_32534__$1;
(statearr_32549_32566[(2)] = inst_32524);

(statearr_32549_32566[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto__))
;
return ((function (switch__19063__auto__,c__19175__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__19064__auto__ = null;
var cljs$core$async$reduce_$_state_machine__19064__auto____0 = (function (){
var statearr_32553 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32553[(0)] = cljs$core$async$reduce_$_state_machine__19064__auto__);

(statearr_32553[(1)] = (1));

return statearr_32553;
});
var cljs$core$async$reduce_$_state_machine__19064__auto____1 = (function (state_32534){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_32534);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e32554){if((e32554 instanceof Object)){
var ex__19067__auto__ = e32554;
var statearr_32555_32567 = state_32534;
(statearr_32555_32567[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32534);

return cljs.core.cst$kw$recur;
} else {
throw e32554;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__32568 = state_32534;
state_32534 = G__32568;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__19064__auto__ = function(state_32534){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__19064__auto____1.call(this,state_32534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__19064__auto____0;
cljs$core$async$reduce_$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__19064__auto____1;
return cljs$core$async$reduce_$_state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto__))
})();
var state__19177__auto__ = (function (){var statearr_32556 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_32556[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto__);

return statearr_32556;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto__))
);

return c__19175__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__19175__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto__,f__$1){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto__,f__$1){
return (function (state_32588){
var state_val_32589 = (state_32588[(1)]);
if((state_val_32589 === (1))){
var inst_32583 = cljs.core.async.reduce(f__$1,init,ch);
var state_32588__$1 = state_32588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32588__$1,(2),inst_32583);
} else {
if((state_val_32589 === (2))){
var inst_32585 = (state_32588[(2)]);
var inst_32586 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_32585) : f__$1.call(null,inst_32585));
var state_32588__$1 = state_32588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32588__$1,inst_32586);
} else {
return null;
}
}
});})(c__19175__auto__,f__$1))
;
return ((function (switch__19063__auto__,c__19175__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__19064__auto__ = null;
var cljs$core$async$transduce_$_state_machine__19064__auto____0 = (function (){
var statearr_32593 = [null,null,null,null,null,null,null];
(statearr_32593[(0)] = cljs$core$async$transduce_$_state_machine__19064__auto__);

(statearr_32593[(1)] = (1));

return statearr_32593;
});
var cljs$core$async$transduce_$_state_machine__19064__auto____1 = (function (state_32588){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_32588);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e32594){if((e32594 instanceof Object)){
var ex__19067__auto__ = e32594;
var statearr_32595_32597 = state_32588;
(statearr_32595_32597[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32588);

return cljs.core.cst$kw$recur;
} else {
throw e32594;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__32598 = state_32588;
state_32588 = G__32598;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__19064__auto__ = function(state_32588){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__19064__auto____1.call(this,state_32588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__19064__auto____0;
cljs$core$async$transduce_$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__19064__auto____1;
return cljs$core$async$transduce_$_state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto__,f__$1))
})();
var state__19177__auto__ = (function (){var statearr_32596 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_32596[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto__);

return statearr_32596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto__,f__$1))
);

return c__19175__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args32599 = [];
var len__7651__auto___32651 = arguments.length;
var i__7652__auto___32652 = (0);
while(true){
if((i__7652__auto___32652 < len__7651__auto___32651)){
args32599.push((arguments[i__7652__auto___32652]));

var G__32653 = (i__7652__auto___32652 + (1));
i__7652__auto___32652 = G__32653;
continue;
} else {
}
break;
}

var G__32601 = args32599.length;
switch (G__32601) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32599.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__19175__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto__){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto__){
return (function (state_32626){
var state_val_32627 = (state_32626[(1)]);
if((state_val_32627 === (7))){
var inst_32608 = (state_32626[(2)]);
var state_32626__$1 = state_32626;
var statearr_32628_32655 = state_32626__$1;
(statearr_32628_32655[(2)] = inst_32608);

(statearr_32628_32655[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32627 === (1))){
var inst_32602 = cljs.core.seq(coll);
var inst_32603 = inst_32602;
var state_32626__$1 = (function (){var statearr_32629 = state_32626;
(statearr_32629[(7)] = inst_32603);

return statearr_32629;
})();
var statearr_32630_32656 = state_32626__$1;
(statearr_32630_32656[(2)] = null);

(statearr_32630_32656[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32627 === (4))){
var inst_32603 = (state_32626[(7)]);
var inst_32606 = cljs.core.first(inst_32603);
var state_32626__$1 = state_32626;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32626__$1,(7),ch,inst_32606);
} else {
if((state_val_32627 === (13))){
var inst_32620 = (state_32626[(2)]);
var state_32626__$1 = state_32626;
var statearr_32631_32657 = state_32626__$1;
(statearr_32631_32657[(2)] = inst_32620);

(statearr_32631_32657[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32627 === (6))){
var inst_32611 = (state_32626[(2)]);
var state_32626__$1 = state_32626;
if(cljs.core.truth_(inst_32611)){
var statearr_32632_32658 = state_32626__$1;
(statearr_32632_32658[(1)] = (8));

} else {
var statearr_32633_32659 = state_32626__$1;
(statearr_32633_32659[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32627 === (3))){
var inst_32624 = (state_32626[(2)]);
var state_32626__$1 = state_32626;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32626__$1,inst_32624);
} else {
if((state_val_32627 === (12))){
var state_32626__$1 = state_32626;
var statearr_32634_32660 = state_32626__$1;
(statearr_32634_32660[(2)] = null);

(statearr_32634_32660[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32627 === (2))){
var inst_32603 = (state_32626[(7)]);
var state_32626__$1 = state_32626;
if(cljs.core.truth_(inst_32603)){
var statearr_32635_32661 = state_32626__$1;
(statearr_32635_32661[(1)] = (4));

} else {
var statearr_32636_32662 = state_32626__$1;
(statearr_32636_32662[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32627 === (11))){
var inst_32617 = cljs.core.async.close_BANG_(ch);
var state_32626__$1 = state_32626;
var statearr_32637_32663 = state_32626__$1;
(statearr_32637_32663[(2)] = inst_32617);

(statearr_32637_32663[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32627 === (9))){
var state_32626__$1 = state_32626;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32638_32664 = state_32626__$1;
(statearr_32638_32664[(1)] = (11));

} else {
var statearr_32639_32665 = state_32626__$1;
(statearr_32639_32665[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32627 === (5))){
var inst_32603 = (state_32626[(7)]);
var state_32626__$1 = state_32626;
var statearr_32640_32666 = state_32626__$1;
(statearr_32640_32666[(2)] = inst_32603);

(statearr_32640_32666[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32627 === (10))){
var inst_32622 = (state_32626[(2)]);
var state_32626__$1 = state_32626;
var statearr_32641_32667 = state_32626__$1;
(statearr_32641_32667[(2)] = inst_32622);

(statearr_32641_32667[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32627 === (8))){
var inst_32603 = (state_32626[(7)]);
var inst_32613 = cljs.core.next(inst_32603);
var inst_32603__$1 = inst_32613;
var state_32626__$1 = (function (){var statearr_32642 = state_32626;
(statearr_32642[(7)] = inst_32603__$1);

return statearr_32642;
})();
var statearr_32643_32668 = state_32626__$1;
(statearr_32643_32668[(2)] = null);

(statearr_32643_32668[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto__))
;
return ((function (switch__19063__auto__,c__19175__auto__){
return (function() {
var cljs$core$async$state_machine__19064__auto__ = null;
var cljs$core$async$state_machine__19064__auto____0 = (function (){
var statearr_32647 = [null,null,null,null,null,null,null,null];
(statearr_32647[(0)] = cljs$core$async$state_machine__19064__auto__);

(statearr_32647[(1)] = (1));

return statearr_32647;
});
var cljs$core$async$state_machine__19064__auto____1 = (function (state_32626){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_32626);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e32648){if((e32648 instanceof Object)){
var ex__19067__auto__ = e32648;
var statearr_32649_32669 = state_32626;
(statearr_32649_32669[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32626);

return cljs.core.cst$kw$recur;
} else {
throw e32648;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__32670 = state_32626;
state_32626 = G__32670;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$state_machine__19064__auto__ = function(state_32626){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19064__auto____1.call(this,state_32626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19064__auto____0;
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19064__auto____1;
return cljs$core$async$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto__))
})();
var state__19177__auto__ = (function (){var statearr_32650 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_32650[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto__);

return statearr_32650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto__))
);

return c__19175__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7206__auto__ = (((_ == null))?null:_);
var m__7207__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7207__auto__.call(null,_));
} else {
var m__7207__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7207__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7207__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7207__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto__.call(null,m));
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__32899 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32899) : cljs.core.atom.call(null,G__32899));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32900 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32900 = (function (ch,cs,meta32901){
this.ch = ch;
this.cs = cs;
this.meta32901 = meta32901;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32900.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32902,meta32901__$1){
var self__ = this;
var _32902__$1 = this;
return (new cljs.core.async.t_cljs$core$async32900(self__.ch,self__.cs,meta32901__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async32900.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32902){
var self__ = this;
var _32902__$1 = this;
return self__.meta32901;
});})(cs))
;

cljs.core.async.t_cljs$core$async32900.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32900.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async32900.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32900.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32900.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32900.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32903_33127 = self__.cs;
var G__32904_33128 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32903_33127,G__32904_33128) : cljs.core.reset_BANG_.call(null,G__32903_33127,G__32904_33128));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32900.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta32901], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async32900.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32900.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32900";

cljs.core.async.t_cljs$core$async32900.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async32900");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async32900 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async32900(ch__$1,cs__$1,meta32901){
return (new cljs.core.async.t_cljs$core$async32900(ch__$1,cs__$1,meta32901));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async32900(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__19175__auto___33129 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___33129,cs,m,dchan,dctr,done){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___33129,cs,m,dchan,dctr,done){
return (function (state_33039){
var state_val_33040 = (state_33039[(1)]);
if((state_val_33040 === (7))){
var inst_33035 = (state_33039[(2)]);
var state_33039__$1 = state_33039;
var statearr_33041_33130 = state_33039__$1;
(statearr_33041_33130[(2)] = inst_33035);

(statearr_33041_33130[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (20))){
var inst_32938 = (state_33039[(7)]);
var inst_32950 = cljs.core.first(inst_32938);
var inst_32951 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32950,(0),null);
var inst_32952 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32950,(1),null);
var state_33039__$1 = (function (){var statearr_33042 = state_33039;
(statearr_33042[(8)] = inst_32951);

return statearr_33042;
})();
if(cljs.core.truth_(inst_32952)){
var statearr_33043_33131 = state_33039__$1;
(statearr_33043_33131[(1)] = (22));

} else {
var statearr_33044_33132 = state_33039__$1;
(statearr_33044_33132[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (27))){
var inst_32987 = (state_33039[(9)]);
var inst_32982 = (state_33039[(10)]);
var inst_32980 = (state_33039[(11)]);
var inst_32907 = (state_33039[(12)]);
var inst_32987__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32980,inst_32982);
var inst_32988 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_32987__$1,inst_32907,done);
var state_33039__$1 = (function (){var statearr_33045 = state_33039;
(statearr_33045[(9)] = inst_32987__$1);

return statearr_33045;
})();
if(cljs.core.truth_(inst_32988)){
var statearr_33046_33133 = state_33039__$1;
(statearr_33046_33133[(1)] = (30));

} else {
var statearr_33047_33134 = state_33039__$1;
(statearr_33047_33134[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (1))){
var state_33039__$1 = state_33039;
var statearr_33048_33135 = state_33039__$1;
(statearr_33048_33135[(2)] = null);

(statearr_33048_33135[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (24))){
var inst_32938 = (state_33039[(7)]);
var inst_32957 = (state_33039[(2)]);
var inst_32958 = cljs.core.next(inst_32938);
var inst_32916 = inst_32958;
var inst_32917 = null;
var inst_32918 = (0);
var inst_32919 = (0);
var state_33039__$1 = (function (){var statearr_33049 = state_33039;
(statearr_33049[(13)] = inst_32918);

(statearr_33049[(14)] = inst_32957);

(statearr_33049[(15)] = inst_32917);

(statearr_33049[(16)] = inst_32919);

(statearr_33049[(17)] = inst_32916);

return statearr_33049;
})();
var statearr_33050_33136 = state_33039__$1;
(statearr_33050_33136[(2)] = null);

(statearr_33050_33136[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (39))){
var state_33039__$1 = state_33039;
var statearr_33054_33137 = state_33039__$1;
(statearr_33054_33137[(2)] = null);

(statearr_33054_33137[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (4))){
var inst_32907 = (state_33039[(12)]);
var inst_32907__$1 = (state_33039[(2)]);
var inst_32908 = (inst_32907__$1 == null);
var state_33039__$1 = (function (){var statearr_33055 = state_33039;
(statearr_33055[(12)] = inst_32907__$1);

return statearr_33055;
})();
if(cljs.core.truth_(inst_32908)){
var statearr_33056_33138 = state_33039__$1;
(statearr_33056_33138[(1)] = (5));

} else {
var statearr_33057_33139 = state_33039__$1;
(statearr_33057_33139[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (15))){
var inst_32918 = (state_33039[(13)]);
var inst_32917 = (state_33039[(15)]);
var inst_32919 = (state_33039[(16)]);
var inst_32916 = (state_33039[(17)]);
var inst_32934 = (state_33039[(2)]);
var inst_32935 = (inst_32919 + (1));
var tmp33051 = inst_32918;
var tmp33052 = inst_32917;
var tmp33053 = inst_32916;
var inst_32916__$1 = tmp33053;
var inst_32917__$1 = tmp33052;
var inst_32918__$1 = tmp33051;
var inst_32919__$1 = inst_32935;
var state_33039__$1 = (function (){var statearr_33058 = state_33039;
(statearr_33058[(13)] = inst_32918__$1);

(statearr_33058[(15)] = inst_32917__$1);

(statearr_33058[(16)] = inst_32919__$1);

(statearr_33058[(17)] = inst_32916__$1);

(statearr_33058[(18)] = inst_32934);

return statearr_33058;
})();
var statearr_33059_33140 = state_33039__$1;
(statearr_33059_33140[(2)] = null);

(statearr_33059_33140[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (21))){
var inst_32961 = (state_33039[(2)]);
var state_33039__$1 = state_33039;
var statearr_33063_33141 = state_33039__$1;
(statearr_33063_33141[(2)] = inst_32961);

(statearr_33063_33141[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (31))){
var inst_32987 = (state_33039[(9)]);
var inst_32991 = done(null);
var inst_32992 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_32987);
var state_33039__$1 = (function (){var statearr_33064 = state_33039;
(statearr_33064[(19)] = inst_32991);

return statearr_33064;
})();
var statearr_33065_33142 = state_33039__$1;
(statearr_33065_33142[(2)] = inst_32992);

(statearr_33065_33142[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (32))){
var inst_32982 = (state_33039[(10)]);
var inst_32979 = (state_33039[(20)]);
var inst_32980 = (state_33039[(11)]);
var inst_32981 = (state_33039[(21)]);
var inst_32994 = (state_33039[(2)]);
var inst_32995 = (inst_32982 + (1));
var tmp33060 = inst_32979;
var tmp33061 = inst_32980;
var tmp33062 = inst_32981;
var inst_32979__$1 = tmp33060;
var inst_32980__$1 = tmp33061;
var inst_32981__$1 = tmp33062;
var inst_32982__$1 = inst_32995;
var state_33039__$1 = (function (){var statearr_33066 = state_33039;
(statearr_33066[(10)] = inst_32982__$1);

(statearr_33066[(20)] = inst_32979__$1);

(statearr_33066[(11)] = inst_32980__$1);

(statearr_33066[(21)] = inst_32981__$1);

(statearr_33066[(22)] = inst_32994);

return statearr_33066;
})();
var statearr_33067_33143 = state_33039__$1;
(statearr_33067_33143[(2)] = null);

(statearr_33067_33143[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (40))){
var inst_33007 = (state_33039[(23)]);
var inst_33011 = done(null);
var inst_33012 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_33007);
var state_33039__$1 = (function (){var statearr_33068 = state_33039;
(statearr_33068[(24)] = inst_33011);

return statearr_33068;
})();
var statearr_33069_33144 = state_33039__$1;
(statearr_33069_33144[(2)] = inst_33012);

(statearr_33069_33144[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (33))){
var inst_32998 = (state_33039[(25)]);
var inst_33000 = cljs.core.chunked_seq_QMARK_(inst_32998);
var state_33039__$1 = state_33039;
if(inst_33000){
var statearr_33070_33145 = state_33039__$1;
(statearr_33070_33145[(1)] = (36));

} else {
var statearr_33071_33146 = state_33039__$1;
(statearr_33071_33146[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (13))){
var inst_32928 = (state_33039[(26)]);
var inst_32931 = cljs.core.async.close_BANG_(inst_32928);
var state_33039__$1 = state_33039;
var statearr_33072_33147 = state_33039__$1;
(statearr_33072_33147[(2)] = inst_32931);

(statearr_33072_33147[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (22))){
var inst_32951 = (state_33039[(8)]);
var inst_32954 = cljs.core.async.close_BANG_(inst_32951);
var state_33039__$1 = state_33039;
var statearr_33073_33148 = state_33039__$1;
(statearr_33073_33148[(2)] = inst_32954);

(statearr_33073_33148[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (36))){
var inst_32998 = (state_33039[(25)]);
var inst_33002 = cljs.core.chunk_first(inst_32998);
var inst_33003 = cljs.core.chunk_rest(inst_32998);
var inst_33004 = cljs.core.count(inst_33002);
var inst_32979 = inst_33003;
var inst_32980 = inst_33002;
var inst_32981 = inst_33004;
var inst_32982 = (0);
var state_33039__$1 = (function (){var statearr_33074 = state_33039;
(statearr_33074[(10)] = inst_32982);

(statearr_33074[(20)] = inst_32979);

(statearr_33074[(11)] = inst_32980);

(statearr_33074[(21)] = inst_32981);

return statearr_33074;
})();
var statearr_33075_33149 = state_33039__$1;
(statearr_33075_33149[(2)] = null);

(statearr_33075_33149[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (41))){
var inst_32998 = (state_33039[(25)]);
var inst_33014 = (state_33039[(2)]);
var inst_33015 = cljs.core.next(inst_32998);
var inst_32979 = inst_33015;
var inst_32980 = null;
var inst_32981 = (0);
var inst_32982 = (0);
var state_33039__$1 = (function (){var statearr_33076 = state_33039;
(statearr_33076[(10)] = inst_32982);

(statearr_33076[(20)] = inst_32979);

(statearr_33076[(11)] = inst_32980);

(statearr_33076[(27)] = inst_33014);

(statearr_33076[(21)] = inst_32981);

return statearr_33076;
})();
var statearr_33077_33150 = state_33039__$1;
(statearr_33077_33150[(2)] = null);

(statearr_33077_33150[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (43))){
var state_33039__$1 = state_33039;
var statearr_33078_33151 = state_33039__$1;
(statearr_33078_33151[(2)] = null);

(statearr_33078_33151[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (29))){
var inst_33023 = (state_33039[(2)]);
var state_33039__$1 = state_33039;
var statearr_33079_33152 = state_33039__$1;
(statearr_33079_33152[(2)] = inst_33023);

(statearr_33079_33152[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (44))){
var inst_33032 = (state_33039[(2)]);
var state_33039__$1 = (function (){var statearr_33080 = state_33039;
(statearr_33080[(28)] = inst_33032);

return statearr_33080;
})();
var statearr_33081_33153 = state_33039__$1;
(statearr_33081_33153[(2)] = null);

(statearr_33081_33153[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (6))){
var inst_32971 = (state_33039[(29)]);
var inst_32970 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32971__$1 = cljs.core.keys(inst_32970);
var inst_32972 = cljs.core.count(inst_32971__$1);
var inst_32973 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_32972) : cljs.core.reset_BANG_.call(null,dctr,inst_32972));
var inst_32978 = cljs.core.seq(inst_32971__$1);
var inst_32979 = inst_32978;
var inst_32980 = null;
var inst_32981 = (0);
var inst_32982 = (0);
var state_33039__$1 = (function (){var statearr_33082 = state_33039;
(statearr_33082[(10)] = inst_32982);

(statearr_33082[(30)] = inst_32973);

(statearr_33082[(20)] = inst_32979);

(statearr_33082[(11)] = inst_32980);

(statearr_33082[(29)] = inst_32971__$1);

(statearr_33082[(21)] = inst_32981);

return statearr_33082;
})();
var statearr_33083_33154 = state_33039__$1;
(statearr_33083_33154[(2)] = null);

(statearr_33083_33154[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (28))){
var inst_32979 = (state_33039[(20)]);
var inst_32998 = (state_33039[(25)]);
var inst_32998__$1 = cljs.core.seq(inst_32979);
var state_33039__$1 = (function (){var statearr_33084 = state_33039;
(statearr_33084[(25)] = inst_32998__$1);

return statearr_33084;
})();
if(inst_32998__$1){
var statearr_33085_33155 = state_33039__$1;
(statearr_33085_33155[(1)] = (33));

} else {
var statearr_33086_33156 = state_33039__$1;
(statearr_33086_33156[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (25))){
var inst_32982 = (state_33039[(10)]);
var inst_32981 = (state_33039[(21)]);
var inst_32984 = (inst_32982 < inst_32981);
var inst_32985 = inst_32984;
var state_33039__$1 = state_33039;
if(cljs.core.truth_(inst_32985)){
var statearr_33087_33157 = state_33039__$1;
(statearr_33087_33157[(1)] = (27));

} else {
var statearr_33088_33158 = state_33039__$1;
(statearr_33088_33158[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (34))){
var state_33039__$1 = state_33039;
var statearr_33089_33159 = state_33039__$1;
(statearr_33089_33159[(2)] = null);

(statearr_33089_33159[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (17))){
var state_33039__$1 = state_33039;
var statearr_33090_33160 = state_33039__$1;
(statearr_33090_33160[(2)] = null);

(statearr_33090_33160[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (3))){
var inst_33037 = (state_33039[(2)]);
var state_33039__$1 = state_33039;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33039__$1,inst_33037);
} else {
if((state_val_33040 === (12))){
var inst_32966 = (state_33039[(2)]);
var state_33039__$1 = state_33039;
var statearr_33091_33161 = state_33039__$1;
(statearr_33091_33161[(2)] = inst_32966);

(statearr_33091_33161[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (2))){
var state_33039__$1 = state_33039;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33039__$1,(4),ch);
} else {
if((state_val_33040 === (23))){
var state_33039__$1 = state_33039;
var statearr_33092_33162 = state_33039__$1;
(statearr_33092_33162[(2)] = null);

(statearr_33092_33162[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (35))){
var inst_33021 = (state_33039[(2)]);
var state_33039__$1 = state_33039;
var statearr_33093_33163 = state_33039__$1;
(statearr_33093_33163[(2)] = inst_33021);

(statearr_33093_33163[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (19))){
var inst_32938 = (state_33039[(7)]);
var inst_32942 = cljs.core.chunk_first(inst_32938);
var inst_32943 = cljs.core.chunk_rest(inst_32938);
var inst_32944 = cljs.core.count(inst_32942);
var inst_32916 = inst_32943;
var inst_32917 = inst_32942;
var inst_32918 = inst_32944;
var inst_32919 = (0);
var state_33039__$1 = (function (){var statearr_33094 = state_33039;
(statearr_33094[(13)] = inst_32918);

(statearr_33094[(15)] = inst_32917);

(statearr_33094[(16)] = inst_32919);

(statearr_33094[(17)] = inst_32916);

return statearr_33094;
})();
var statearr_33095_33164 = state_33039__$1;
(statearr_33095_33164[(2)] = null);

(statearr_33095_33164[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (11))){
var inst_32938 = (state_33039[(7)]);
var inst_32916 = (state_33039[(17)]);
var inst_32938__$1 = cljs.core.seq(inst_32916);
var state_33039__$1 = (function (){var statearr_33096 = state_33039;
(statearr_33096[(7)] = inst_32938__$1);

return statearr_33096;
})();
if(inst_32938__$1){
var statearr_33097_33165 = state_33039__$1;
(statearr_33097_33165[(1)] = (16));

} else {
var statearr_33098_33166 = state_33039__$1;
(statearr_33098_33166[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (9))){
var inst_32968 = (state_33039[(2)]);
var state_33039__$1 = state_33039;
var statearr_33099_33167 = state_33039__$1;
(statearr_33099_33167[(2)] = inst_32968);

(statearr_33099_33167[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (5))){
var inst_32914 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32915 = cljs.core.seq(inst_32914);
var inst_32916 = inst_32915;
var inst_32917 = null;
var inst_32918 = (0);
var inst_32919 = (0);
var state_33039__$1 = (function (){var statearr_33100 = state_33039;
(statearr_33100[(13)] = inst_32918);

(statearr_33100[(15)] = inst_32917);

(statearr_33100[(16)] = inst_32919);

(statearr_33100[(17)] = inst_32916);

return statearr_33100;
})();
var statearr_33101_33168 = state_33039__$1;
(statearr_33101_33168[(2)] = null);

(statearr_33101_33168[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (14))){
var state_33039__$1 = state_33039;
var statearr_33102_33169 = state_33039__$1;
(statearr_33102_33169[(2)] = null);

(statearr_33102_33169[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (45))){
var inst_33029 = (state_33039[(2)]);
var state_33039__$1 = state_33039;
var statearr_33103_33170 = state_33039__$1;
(statearr_33103_33170[(2)] = inst_33029);

(statearr_33103_33170[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (26))){
var inst_32971 = (state_33039[(29)]);
var inst_33025 = (state_33039[(2)]);
var inst_33026 = cljs.core.seq(inst_32971);
var state_33039__$1 = (function (){var statearr_33104 = state_33039;
(statearr_33104[(31)] = inst_33025);

return statearr_33104;
})();
if(inst_33026){
var statearr_33105_33171 = state_33039__$1;
(statearr_33105_33171[(1)] = (42));

} else {
var statearr_33106_33172 = state_33039__$1;
(statearr_33106_33172[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (16))){
var inst_32938 = (state_33039[(7)]);
var inst_32940 = cljs.core.chunked_seq_QMARK_(inst_32938);
var state_33039__$1 = state_33039;
if(inst_32940){
var statearr_33107_33173 = state_33039__$1;
(statearr_33107_33173[(1)] = (19));

} else {
var statearr_33108_33174 = state_33039__$1;
(statearr_33108_33174[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (38))){
var inst_33018 = (state_33039[(2)]);
var state_33039__$1 = state_33039;
var statearr_33109_33175 = state_33039__$1;
(statearr_33109_33175[(2)] = inst_33018);

(statearr_33109_33175[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (30))){
var state_33039__$1 = state_33039;
var statearr_33110_33176 = state_33039__$1;
(statearr_33110_33176[(2)] = null);

(statearr_33110_33176[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (10))){
var inst_32917 = (state_33039[(15)]);
var inst_32919 = (state_33039[(16)]);
var inst_32927 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32917,inst_32919);
var inst_32928 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32927,(0),null);
var inst_32929 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32927,(1),null);
var state_33039__$1 = (function (){var statearr_33111 = state_33039;
(statearr_33111[(26)] = inst_32928);

return statearr_33111;
})();
if(cljs.core.truth_(inst_32929)){
var statearr_33112_33177 = state_33039__$1;
(statearr_33112_33177[(1)] = (13));

} else {
var statearr_33113_33178 = state_33039__$1;
(statearr_33113_33178[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (18))){
var inst_32964 = (state_33039[(2)]);
var state_33039__$1 = state_33039;
var statearr_33114_33179 = state_33039__$1;
(statearr_33114_33179[(2)] = inst_32964);

(statearr_33114_33179[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (42))){
var state_33039__$1 = state_33039;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33039__$1,(45),dchan);
} else {
if((state_val_33040 === (37))){
var inst_32998 = (state_33039[(25)]);
var inst_32907 = (state_33039[(12)]);
var inst_33007 = (state_33039[(23)]);
var inst_33007__$1 = cljs.core.first(inst_32998);
var inst_33008 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33007__$1,inst_32907,done);
var state_33039__$1 = (function (){var statearr_33115 = state_33039;
(statearr_33115[(23)] = inst_33007__$1);

return statearr_33115;
})();
if(cljs.core.truth_(inst_33008)){
var statearr_33116_33180 = state_33039__$1;
(statearr_33116_33180[(1)] = (39));

} else {
var statearr_33117_33181 = state_33039__$1;
(statearr_33117_33181[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33040 === (8))){
var inst_32918 = (state_33039[(13)]);
var inst_32919 = (state_33039[(16)]);
var inst_32921 = (inst_32919 < inst_32918);
var inst_32922 = inst_32921;
var state_33039__$1 = state_33039;
if(cljs.core.truth_(inst_32922)){
var statearr_33118_33182 = state_33039__$1;
(statearr_33118_33182[(1)] = (10));

} else {
var statearr_33119_33183 = state_33039__$1;
(statearr_33119_33183[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___33129,cs,m,dchan,dctr,done))
;
return ((function (switch__19063__auto__,c__19175__auto___33129,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__19064__auto__ = null;
var cljs$core$async$mult_$_state_machine__19064__auto____0 = (function (){
var statearr_33123 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33123[(0)] = cljs$core$async$mult_$_state_machine__19064__auto__);

(statearr_33123[(1)] = (1));

return statearr_33123;
});
var cljs$core$async$mult_$_state_machine__19064__auto____1 = (function (state_33039){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_33039);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e33124){if((e33124 instanceof Object)){
var ex__19067__auto__ = e33124;
var statearr_33125_33184 = state_33039;
(statearr_33125_33184[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33039);

return cljs.core.cst$kw$recur;
} else {
throw e33124;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__33185 = state_33039;
state_33039 = G__33185;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__19064__auto__ = function(state_33039){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__19064__auto____1.call(this,state_33039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__19064__auto____0;
cljs$core$async$mult_$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__19064__auto____1;
return cljs$core$async$mult_$_state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___33129,cs,m,dchan,dctr,done))
})();
var state__19177__auto__ = (function (){var statearr_33126 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_33126[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___33129);

return statearr_33126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___33129,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args33186 = [];
var len__7651__auto___33189 = arguments.length;
var i__7652__auto___33190 = (0);
while(true){
if((i__7652__auto___33190 < len__7651__auto___33189)){
args33186.push((arguments[i__7652__auto___33190]));

var G__33191 = (i__7652__auto___33190 + (1));
i__7652__auto___33190 = G__33191;
continue;
} else {
}
break;
}

var G__33188 = args33186.length;
switch (G__33188) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33186.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto__.call(null,m));
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7207__auto__.call(null,m,state_map));
} else {
var m__7207__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7207__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7207__auto__.call(null,m,mode));
} else {
var m__7207__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7207__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___33203 = arguments.length;
var i__7652__auto___33204 = (0);
while(true){
if((i__7652__auto___33204 < len__7651__auto___33203)){
args__7658__auto__.push((arguments[i__7652__auto___33204]));

var G__33205 = (i__7652__auto___33204 + (1));
i__7652__auto___33204 = G__33205;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__33197){
var map__33198 = p__33197;
var map__33198__$1 = ((((!((map__33198 == null)))?((((map__33198.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33198.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33198):map__33198);
var opts = map__33198__$1;
var statearr_33200_33206 = state;
(statearr_33200_33206[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__33198,map__33198__$1,opts){
return (function (val){
var statearr_33201_33207 = state;
(statearr_33201_33207[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__33198,map__33198__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_33202_33208 = state;
(statearr_33202_33208[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq33193){
var G__33194 = cljs.core.first(seq33193);
var seq33193__$1 = cljs.core.next(seq33193);
var G__33195 = cljs.core.first(seq33193__$1);
var seq33193__$2 = cljs.core.next(seq33193__$1);
var G__33196 = cljs.core.first(seq33193__$2);
var seq33193__$3 = cljs.core.next(seq33193__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33194,G__33195,G__33196,seq33193__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__33380 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33380) : cljs.core.atom.call(null,G__33380));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__33381 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33381) : cljs.core.atom.call(null,G__33381));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async33382 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33382 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta33383){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta33383 = meta33383;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33382.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33384,meta33383__$1){
var self__ = this;
var _33384__$1 = this;
return (new cljs.core.async.t_cljs$core$async33382(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta33383__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33382.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33384){
var self__ = this;
var _33384__$1 = this;
return self__.meta33383;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33382.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33382.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33382.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33382.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33382.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33382.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__33385_33551 = self__.cs;
var G__33386_33552 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__33385_33551,G__33386_33552) : cljs.core.reset_BANG_.call(null,G__33385_33551,G__33386_33552));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33382.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33382.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33382.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta33383], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33382.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33382.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33382";

cljs.core.async.t_cljs$core$async33382.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33382");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async33382 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async33382(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33383){
return (new cljs.core.async.t_cljs$core$async33382(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33383));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async33382(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19175__auto___33553 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___33553,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___33553,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_33488){
var state_val_33489 = (state_33488[(1)]);
if((state_val_33489 === (7))){
var inst_33403 = (state_33488[(2)]);
var state_33488__$1 = state_33488;
var statearr_33490_33554 = state_33488__$1;
(statearr_33490_33554[(2)] = inst_33403);

(statearr_33490_33554[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (20))){
var inst_33415 = (state_33488[(7)]);
var state_33488__$1 = state_33488;
var statearr_33491_33555 = state_33488__$1;
(statearr_33491_33555[(2)] = inst_33415);

(statearr_33491_33555[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (27))){
var state_33488__$1 = state_33488;
var statearr_33492_33556 = state_33488__$1;
(statearr_33492_33556[(2)] = null);

(statearr_33492_33556[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (1))){
var inst_33390 = (state_33488[(8)]);
var inst_33390__$1 = calc_state();
var inst_33392 = (inst_33390__$1 == null);
var inst_33393 = cljs.core.not(inst_33392);
var state_33488__$1 = (function (){var statearr_33493 = state_33488;
(statearr_33493[(8)] = inst_33390__$1);

return statearr_33493;
})();
if(inst_33393){
var statearr_33494_33557 = state_33488__$1;
(statearr_33494_33557[(1)] = (2));

} else {
var statearr_33495_33558 = state_33488__$1;
(statearr_33495_33558[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (24))){
var inst_33448 = (state_33488[(9)]);
var inst_33439 = (state_33488[(10)]);
var inst_33462 = (state_33488[(11)]);
var inst_33462__$1 = (inst_33439.cljs$core$IFn$_invoke$arity$1 ? inst_33439.cljs$core$IFn$_invoke$arity$1(inst_33448) : inst_33439.call(null,inst_33448));
var state_33488__$1 = (function (){var statearr_33496 = state_33488;
(statearr_33496[(11)] = inst_33462__$1);

return statearr_33496;
})();
if(cljs.core.truth_(inst_33462__$1)){
var statearr_33497_33559 = state_33488__$1;
(statearr_33497_33559[(1)] = (29));

} else {
var statearr_33498_33560 = state_33488__$1;
(statearr_33498_33560[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (4))){
var inst_33406 = (state_33488[(2)]);
var state_33488__$1 = state_33488;
if(cljs.core.truth_(inst_33406)){
var statearr_33499_33561 = state_33488__$1;
(statearr_33499_33561[(1)] = (8));

} else {
var statearr_33500_33562 = state_33488__$1;
(statearr_33500_33562[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (15))){
var inst_33433 = (state_33488[(2)]);
var state_33488__$1 = state_33488;
if(cljs.core.truth_(inst_33433)){
var statearr_33501_33563 = state_33488__$1;
(statearr_33501_33563[(1)] = (19));

} else {
var statearr_33502_33564 = state_33488__$1;
(statearr_33502_33564[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (21))){
var inst_33438 = (state_33488[(12)]);
var inst_33438__$1 = (state_33488[(2)]);
var inst_33439 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33438__$1,cljs.core.cst$kw$solos);
var inst_33440 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33438__$1,cljs.core.cst$kw$mutes);
var inst_33441 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33438__$1,cljs.core.cst$kw$reads);
var state_33488__$1 = (function (){var statearr_33503 = state_33488;
(statearr_33503[(10)] = inst_33439);

(statearr_33503[(12)] = inst_33438__$1);

(statearr_33503[(13)] = inst_33440);

return statearr_33503;
})();
return cljs.core.async.ioc_alts_BANG_(state_33488__$1,(22),inst_33441);
} else {
if((state_val_33489 === (31))){
var inst_33470 = (state_33488[(2)]);
var state_33488__$1 = state_33488;
if(cljs.core.truth_(inst_33470)){
var statearr_33504_33565 = state_33488__$1;
(statearr_33504_33565[(1)] = (32));

} else {
var statearr_33505_33566 = state_33488__$1;
(statearr_33505_33566[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (32))){
var inst_33447 = (state_33488[(14)]);
var state_33488__$1 = state_33488;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33488__$1,(35),out,inst_33447);
} else {
if((state_val_33489 === (33))){
var inst_33438 = (state_33488[(12)]);
var inst_33415 = inst_33438;
var state_33488__$1 = (function (){var statearr_33506 = state_33488;
(statearr_33506[(7)] = inst_33415);

return statearr_33506;
})();
var statearr_33507_33567 = state_33488__$1;
(statearr_33507_33567[(2)] = null);

(statearr_33507_33567[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (13))){
var inst_33415 = (state_33488[(7)]);
var inst_33422 = inst_33415.cljs$lang$protocol_mask$partition0$;
var inst_33423 = (inst_33422 & (64));
var inst_33424 = inst_33415.cljs$core$ISeq$;
var inst_33425 = (cljs.core.PROTOCOL_SENTINEL === inst_33424);
var inst_33426 = (inst_33423) || (inst_33425);
var state_33488__$1 = state_33488;
if(cljs.core.truth_(inst_33426)){
var statearr_33508_33568 = state_33488__$1;
(statearr_33508_33568[(1)] = (16));

} else {
var statearr_33509_33569 = state_33488__$1;
(statearr_33509_33569[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (22))){
var inst_33448 = (state_33488[(9)]);
var inst_33447 = (state_33488[(14)]);
var inst_33446 = (state_33488[(2)]);
var inst_33447__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33446,(0),null);
var inst_33448__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33446,(1),null);
var inst_33449 = (inst_33447__$1 == null);
var inst_33450 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33448__$1,change);
var inst_33451 = (inst_33449) || (inst_33450);
var state_33488__$1 = (function (){var statearr_33510 = state_33488;
(statearr_33510[(9)] = inst_33448__$1);

(statearr_33510[(14)] = inst_33447__$1);

return statearr_33510;
})();
if(cljs.core.truth_(inst_33451)){
var statearr_33511_33570 = state_33488__$1;
(statearr_33511_33570[(1)] = (23));

} else {
var statearr_33512_33571 = state_33488__$1;
(statearr_33512_33571[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (36))){
var inst_33438 = (state_33488[(12)]);
var inst_33415 = inst_33438;
var state_33488__$1 = (function (){var statearr_33513 = state_33488;
(statearr_33513[(7)] = inst_33415);

return statearr_33513;
})();
var statearr_33514_33572 = state_33488__$1;
(statearr_33514_33572[(2)] = null);

(statearr_33514_33572[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (29))){
var inst_33462 = (state_33488[(11)]);
var state_33488__$1 = state_33488;
var statearr_33515_33573 = state_33488__$1;
(statearr_33515_33573[(2)] = inst_33462);

(statearr_33515_33573[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (6))){
var state_33488__$1 = state_33488;
var statearr_33516_33574 = state_33488__$1;
(statearr_33516_33574[(2)] = false);

(statearr_33516_33574[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (28))){
var inst_33458 = (state_33488[(2)]);
var inst_33459 = calc_state();
var inst_33415 = inst_33459;
var state_33488__$1 = (function (){var statearr_33517 = state_33488;
(statearr_33517[(7)] = inst_33415);

(statearr_33517[(15)] = inst_33458);

return statearr_33517;
})();
var statearr_33518_33575 = state_33488__$1;
(statearr_33518_33575[(2)] = null);

(statearr_33518_33575[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (25))){
var inst_33484 = (state_33488[(2)]);
var state_33488__$1 = state_33488;
var statearr_33519_33576 = state_33488__$1;
(statearr_33519_33576[(2)] = inst_33484);

(statearr_33519_33576[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (34))){
var inst_33482 = (state_33488[(2)]);
var state_33488__$1 = state_33488;
var statearr_33520_33577 = state_33488__$1;
(statearr_33520_33577[(2)] = inst_33482);

(statearr_33520_33577[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (17))){
var state_33488__$1 = state_33488;
var statearr_33521_33578 = state_33488__$1;
(statearr_33521_33578[(2)] = false);

(statearr_33521_33578[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (3))){
var state_33488__$1 = state_33488;
var statearr_33522_33579 = state_33488__$1;
(statearr_33522_33579[(2)] = false);

(statearr_33522_33579[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (12))){
var inst_33486 = (state_33488[(2)]);
var state_33488__$1 = state_33488;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33488__$1,inst_33486);
} else {
if((state_val_33489 === (2))){
var inst_33390 = (state_33488[(8)]);
var inst_33395 = inst_33390.cljs$lang$protocol_mask$partition0$;
var inst_33396 = (inst_33395 & (64));
var inst_33397 = inst_33390.cljs$core$ISeq$;
var inst_33398 = (cljs.core.PROTOCOL_SENTINEL === inst_33397);
var inst_33399 = (inst_33396) || (inst_33398);
var state_33488__$1 = state_33488;
if(cljs.core.truth_(inst_33399)){
var statearr_33523_33580 = state_33488__$1;
(statearr_33523_33580[(1)] = (5));

} else {
var statearr_33524_33581 = state_33488__$1;
(statearr_33524_33581[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (23))){
var inst_33447 = (state_33488[(14)]);
var inst_33453 = (inst_33447 == null);
var state_33488__$1 = state_33488;
if(cljs.core.truth_(inst_33453)){
var statearr_33525_33582 = state_33488__$1;
(statearr_33525_33582[(1)] = (26));

} else {
var statearr_33526_33583 = state_33488__$1;
(statearr_33526_33583[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (35))){
var inst_33473 = (state_33488[(2)]);
var state_33488__$1 = state_33488;
if(cljs.core.truth_(inst_33473)){
var statearr_33527_33584 = state_33488__$1;
(statearr_33527_33584[(1)] = (36));

} else {
var statearr_33528_33585 = state_33488__$1;
(statearr_33528_33585[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (19))){
var inst_33415 = (state_33488[(7)]);
var inst_33435 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33415);
var state_33488__$1 = state_33488;
var statearr_33529_33586 = state_33488__$1;
(statearr_33529_33586[(2)] = inst_33435);

(statearr_33529_33586[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (11))){
var inst_33415 = (state_33488[(7)]);
var inst_33419 = (inst_33415 == null);
var inst_33420 = cljs.core.not(inst_33419);
var state_33488__$1 = state_33488;
if(inst_33420){
var statearr_33530_33587 = state_33488__$1;
(statearr_33530_33587[(1)] = (13));

} else {
var statearr_33531_33588 = state_33488__$1;
(statearr_33531_33588[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (9))){
var inst_33390 = (state_33488[(8)]);
var state_33488__$1 = state_33488;
var statearr_33532_33589 = state_33488__$1;
(statearr_33532_33589[(2)] = inst_33390);

(statearr_33532_33589[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (5))){
var state_33488__$1 = state_33488;
var statearr_33533_33590 = state_33488__$1;
(statearr_33533_33590[(2)] = true);

(statearr_33533_33590[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (14))){
var state_33488__$1 = state_33488;
var statearr_33534_33591 = state_33488__$1;
(statearr_33534_33591[(2)] = false);

(statearr_33534_33591[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (26))){
var inst_33448 = (state_33488[(9)]);
var inst_33455 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_33448);
var state_33488__$1 = state_33488;
var statearr_33535_33592 = state_33488__$1;
(statearr_33535_33592[(2)] = inst_33455);

(statearr_33535_33592[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (16))){
var state_33488__$1 = state_33488;
var statearr_33536_33593 = state_33488__$1;
(statearr_33536_33593[(2)] = true);

(statearr_33536_33593[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (38))){
var inst_33478 = (state_33488[(2)]);
var state_33488__$1 = state_33488;
var statearr_33537_33594 = state_33488__$1;
(statearr_33537_33594[(2)] = inst_33478);

(statearr_33537_33594[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (30))){
var inst_33448 = (state_33488[(9)]);
var inst_33439 = (state_33488[(10)]);
var inst_33440 = (state_33488[(13)]);
var inst_33465 = cljs.core.empty_QMARK_(inst_33439);
var inst_33466 = (inst_33440.cljs$core$IFn$_invoke$arity$1 ? inst_33440.cljs$core$IFn$_invoke$arity$1(inst_33448) : inst_33440.call(null,inst_33448));
var inst_33467 = cljs.core.not(inst_33466);
var inst_33468 = (inst_33465) && (inst_33467);
var state_33488__$1 = state_33488;
var statearr_33538_33595 = state_33488__$1;
(statearr_33538_33595[(2)] = inst_33468);

(statearr_33538_33595[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (10))){
var inst_33390 = (state_33488[(8)]);
var inst_33411 = (state_33488[(2)]);
var inst_33412 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33411,cljs.core.cst$kw$solos);
var inst_33413 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33411,cljs.core.cst$kw$mutes);
var inst_33414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33411,cljs.core.cst$kw$reads);
var inst_33415 = inst_33390;
var state_33488__$1 = (function (){var statearr_33539 = state_33488;
(statearr_33539[(16)] = inst_33413);

(statearr_33539[(17)] = inst_33414);

(statearr_33539[(18)] = inst_33412);

(statearr_33539[(7)] = inst_33415);

return statearr_33539;
})();
var statearr_33540_33596 = state_33488__$1;
(statearr_33540_33596[(2)] = null);

(statearr_33540_33596[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (18))){
var inst_33430 = (state_33488[(2)]);
var state_33488__$1 = state_33488;
var statearr_33541_33597 = state_33488__$1;
(statearr_33541_33597[(2)] = inst_33430);

(statearr_33541_33597[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (37))){
var state_33488__$1 = state_33488;
var statearr_33542_33598 = state_33488__$1;
(statearr_33542_33598[(2)] = null);

(statearr_33542_33598[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33489 === (8))){
var inst_33390 = (state_33488[(8)]);
var inst_33408 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33390);
var state_33488__$1 = state_33488;
var statearr_33543_33599 = state_33488__$1;
(statearr_33543_33599[(2)] = inst_33408);

(statearr_33543_33599[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___33553,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__19063__auto__,c__19175__auto___33553,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__19064__auto__ = null;
var cljs$core$async$mix_$_state_machine__19064__auto____0 = (function (){
var statearr_33547 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33547[(0)] = cljs$core$async$mix_$_state_machine__19064__auto__);

(statearr_33547[(1)] = (1));

return statearr_33547;
});
var cljs$core$async$mix_$_state_machine__19064__auto____1 = (function (state_33488){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_33488);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e33548){if((e33548 instanceof Object)){
var ex__19067__auto__ = e33548;
var statearr_33549_33600 = state_33488;
(statearr_33549_33600[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33488);

return cljs.core.cst$kw$recur;
} else {
throw e33548;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__33601 = state_33488;
state_33488 = G__33601;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__19064__auto__ = function(state_33488){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__19064__auto____1.call(this,state_33488);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__19064__auto____0;
cljs$core$async$mix_$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__19064__auto____1;
return cljs$core$async$mix_$_state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___33553,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__19177__auto__ = (function (){var statearr_33550 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_33550[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___33553);

return statearr_33550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___33553,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7207__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7207__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7207__auto__.call(null,p,v,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7207__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args33602 = [];
var len__7651__auto___33605 = arguments.length;
var i__7652__auto___33606 = (0);
while(true){
if((i__7652__auto___33606 < len__7651__auto___33605)){
args33602.push((arguments[i__7652__auto___33606]));

var G__33607 = (i__7652__auto___33606 + (1));
i__7652__auto___33606 = G__33607;
continue;
} else {
}
break;
}

var G__33604 = args33602.length;
switch (G__33604) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33602.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7207__auto__.call(null,p));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7207__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7207__auto__.call(null,p,v));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7207__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args33610 = [];
var len__7651__auto___33738 = arguments.length;
var i__7652__auto___33739 = (0);
while(true){
if((i__7652__auto___33739 < len__7651__auto___33738)){
args33610.push((arguments[i__7652__auto___33739]));

var G__33740 = (i__7652__auto___33739 + (1));
i__7652__auto___33739 = G__33740;
continue;
} else {
}
break;
}

var G__33612 = args33610.length;
switch (G__33612) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33610.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__33613 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33613) : cljs.core.atom.call(null,G__33613));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6543__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6543__auto__,mults){
return (function (p1__33609_SHARP_){
if(cljs.core.truth_((p1__33609_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33609_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__33609_SHARP_.call(null,topic)))){
return p1__33609_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__33609_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6543__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async33614 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33614 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta33615){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta33615 = meta33615;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_33616,meta33615__$1){
var self__ = this;
var _33616__$1 = this;
return (new cljs.core.async.t_cljs$core$async33614(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta33615__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_33616){
var self__ = this;
var _33616__$1 = this;
return self__.meta33615;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__33617 = self__.mults;
var G__33618 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__33617,G__33618) : cljs.core.reset_BANG_.call(null,G__33617,G__33618));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33614.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33614.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta33615], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33614.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33614.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33614";

cljs.core.async.t_cljs$core$async33614.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33614");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async33614 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async33614(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33615){
return (new cljs.core.async.t_cljs$core$async33614(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33615));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async33614(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19175__auto___33742 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___33742,mults,ensure_mult,p){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___33742,mults,ensure_mult,p){
return (function (state_33690){
var state_val_33691 = (state_33690[(1)]);
if((state_val_33691 === (7))){
var inst_33686 = (state_33690[(2)]);
var state_33690__$1 = state_33690;
var statearr_33692_33743 = state_33690__$1;
(statearr_33692_33743[(2)] = inst_33686);

(statearr_33692_33743[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (20))){
var state_33690__$1 = state_33690;
var statearr_33693_33744 = state_33690__$1;
(statearr_33693_33744[(2)] = null);

(statearr_33693_33744[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (1))){
var state_33690__$1 = state_33690;
var statearr_33694_33745 = state_33690__$1;
(statearr_33694_33745[(2)] = null);

(statearr_33694_33745[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (24))){
var inst_33669 = (state_33690[(7)]);
var inst_33678 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_33669);
var state_33690__$1 = state_33690;
var statearr_33695_33746 = state_33690__$1;
(statearr_33695_33746[(2)] = inst_33678);

(statearr_33695_33746[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (4))){
var inst_33621 = (state_33690[(8)]);
var inst_33621__$1 = (state_33690[(2)]);
var inst_33622 = (inst_33621__$1 == null);
var state_33690__$1 = (function (){var statearr_33696 = state_33690;
(statearr_33696[(8)] = inst_33621__$1);

return statearr_33696;
})();
if(cljs.core.truth_(inst_33622)){
var statearr_33697_33747 = state_33690__$1;
(statearr_33697_33747[(1)] = (5));

} else {
var statearr_33698_33748 = state_33690__$1;
(statearr_33698_33748[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (15))){
var inst_33663 = (state_33690[(2)]);
var state_33690__$1 = state_33690;
var statearr_33699_33749 = state_33690__$1;
(statearr_33699_33749[(2)] = inst_33663);

(statearr_33699_33749[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (21))){
var inst_33683 = (state_33690[(2)]);
var state_33690__$1 = (function (){var statearr_33700 = state_33690;
(statearr_33700[(9)] = inst_33683);

return statearr_33700;
})();
var statearr_33701_33750 = state_33690__$1;
(statearr_33701_33750[(2)] = null);

(statearr_33701_33750[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (13))){
var inst_33645 = (state_33690[(10)]);
var inst_33647 = cljs.core.chunked_seq_QMARK_(inst_33645);
var state_33690__$1 = state_33690;
if(inst_33647){
var statearr_33702_33751 = state_33690__$1;
(statearr_33702_33751[(1)] = (16));

} else {
var statearr_33703_33752 = state_33690__$1;
(statearr_33703_33752[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (22))){
var inst_33675 = (state_33690[(2)]);
var state_33690__$1 = state_33690;
if(cljs.core.truth_(inst_33675)){
var statearr_33704_33753 = state_33690__$1;
(statearr_33704_33753[(1)] = (23));

} else {
var statearr_33705_33754 = state_33690__$1;
(statearr_33705_33754[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (6))){
var inst_33669 = (state_33690[(7)]);
var inst_33671 = (state_33690[(11)]);
var inst_33621 = (state_33690[(8)]);
var inst_33669__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_33621) : topic_fn.call(null,inst_33621));
var inst_33670 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33671__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33670,inst_33669__$1);
var state_33690__$1 = (function (){var statearr_33706 = state_33690;
(statearr_33706[(7)] = inst_33669__$1);

(statearr_33706[(11)] = inst_33671__$1);

return statearr_33706;
})();
if(cljs.core.truth_(inst_33671__$1)){
var statearr_33707_33755 = state_33690__$1;
(statearr_33707_33755[(1)] = (19));

} else {
var statearr_33708_33756 = state_33690__$1;
(statearr_33708_33756[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (25))){
var inst_33680 = (state_33690[(2)]);
var state_33690__$1 = state_33690;
var statearr_33709_33757 = state_33690__$1;
(statearr_33709_33757[(2)] = inst_33680);

(statearr_33709_33757[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (17))){
var inst_33645 = (state_33690[(10)]);
var inst_33654 = cljs.core.first(inst_33645);
var inst_33655 = cljs.core.async.muxch_STAR_(inst_33654);
var inst_33656 = cljs.core.async.close_BANG_(inst_33655);
var inst_33657 = cljs.core.next(inst_33645);
var inst_33631 = inst_33657;
var inst_33632 = null;
var inst_33633 = (0);
var inst_33634 = (0);
var state_33690__$1 = (function (){var statearr_33710 = state_33690;
(statearr_33710[(12)] = inst_33656);

(statearr_33710[(13)] = inst_33632);

(statearr_33710[(14)] = inst_33633);

(statearr_33710[(15)] = inst_33634);

(statearr_33710[(16)] = inst_33631);

return statearr_33710;
})();
var statearr_33711_33758 = state_33690__$1;
(statearr_33711_33758[(2)] = null);

(statearr_33711_33758[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (3))){
var inst_33688 = (state_33690[(2)]);
var state_33690__$1 = state_33690;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33690__$1,inst_33688);
} else {
if((state_val_33691 === (12))){
var inst_33665 = (state_33690[(2)]);
var state_33690__$1 = state_33690;
var statearr_33712_33759 = state_33690__$1;
(statearr_33712_33759[(2)] = inst_33665);

(statearr_33712_33759[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (2))){
var state_33690__$1 = state_33690;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33690__$1,(4),ch);
} else {
if((state_val_33691 === (23))){
var state_33690__$1 = state_33690;
var statearr_33713_33760 = state_33690__$1;
(statearr_33713_33760[(2)] = null);

(statearr_33713_33760[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (19))){
var inst_33671 = (state_33690[(11)]);
var inst_33621 = (state_33690[(8)]);
var inst_33673 = cljs.core.async.muxch_STAR_(inst_33671);
var state_33690__$1 = state_33690;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33690__$1,(22),inst_33673,inst_33621);
} else {
if((state_val_33691 === (11))){
var inst_33645 = (state_33690[(10)]);
var inst_33631 = (state_33690[(16)]);
var inst_33645__$1 = cljs.core.seq(inst_33631);
var state_33690__$1 = (function (){var statearr_33714 = state_33690;
(statearr_33714[(10)] = inst_33645__$1);

return statearr_33714;
})();
if(inst_33645__$1){
var statearr_33715_33761 = state_33690__$1;
(statearr_33715_33761[(1)] = (13));

} else {
var statearr_33716_33762 = state_33690__$1;
(statearr_33716_33762[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (9))){
var inst_33667 = (state_33690[(2)]);
var state_33690__$1 = state_33690;
var statearr_33717_33763 = state_33690__$1;
(statearr_33717_33763[(2)] = inst_33667);

(statearr_33717_33763[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (5))){
var inst_33628 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33629 = cljs.core.vals(inst_33628);
var inst_33630 = cljs.core.seq(inst_33629);
var inst_33631 = inst_33630;
var inst_33632 = null;
var inst_33633 = (0);
var inst_33634 = (0);
var state_33690__$1 = (function (){var statearr_33718 = state_33690;
(statearr_33718[(13)] = inst_33632);

(statearr_33718[(14)] = inst_33633);

(statearr_33718[(15)] = inst_33634);

(statearr_33718[(16)] = inst_33631);

return statearr_33718;
})();
var statearr_33719_33764 = state_33690__$1;
(statearr_33719_33764[(2)] = null);

(statearr_33719_33764[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (14))){
var state_33690__$1 = state_33690;
var statearr_33723_33765 = state_33690__$1;
(statearr_33723_33765[(2)] = null);

(statearr_33723_33765[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (16))){
var inst_33645 = (state_33690[(10)]);
var inst_33649 = cljs.core.chunk_first(inst_33645);
var inst_33650 = cljs.core.chunk_rest(inst_33645);
var inst_33651 = cljs.core.count(inst_33649);
var inst_33631 = inst_33650;
var inst_33632 = inst_33649;
var inst_33633 = inst_33651;
var inst_33634 = (0);
var state_33690__$1 = (function (){var statearr_33724 = state_33690;
(statearr_33724[(13)] = inst_33632);

(statearr_33724[(14)] = inst_33633);

(statearr_33724[(15)] = inst_33634);

(statearr_33724[(16)] = inst_33631);

return statearr_33724;
})();
var statearr_33725_33766 = state_33690__$1;
(statearr_33725_33766[(2)] = null);

(statearr_33725_33766[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (10))){
var inst_33632 = (state_33690[(13)]);
var inst_33633 = (state_33690[(14)]);
var inst_33634 = (state_33690[(15)]);
var inst_33631 = (state_33690[(16)]);
var inst_33639 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33632,inst_33634);
var inst_33640 = cljs.core.async.muxch_STAR_(inst_33639);
var inst_33641 = cljs.core.async.close_BANG_(inst_33640);
var inst_33642 = (inst_33634 + (1));
var tmp33720 = inst_33632;
var tmp33721 = inst_33633;
var tmp33722 = inst_33631;
var inst_33631__$1 = tmp33722;
var inst_33632__$1 = tmp33720;
var inst_33633__$1 = tmp33721;
var inst_33634__$1 = inst_33642;
var state_33690__$1 = (function (){var statearr_33726 = state_33690;
(statearr_33726[(13)] = inst_33632__$1);

(statearr_33726[(14)] = inst_33633__$1);

(statearr_33726[(17)] = inst_33641);

(statearr_33726[(15)] = inst_33634__$1);

(statearr_33726[(16)] = inst_33631__$1);

return statearr_33726;
})();
var statearr_33727_33767 = state_33690__$1;
(statearr_33727_33767[(2)] = null);

(statearr_33727_33767[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (18))){
var inst_33660 = (state_33690[(2)]);
var state_33690__$1 = state_33690;
var statearr_33728_33768 = state_33690__$1;
(statearr_33728_33768[(2)] = inst_33660);

(statearr_33728_33768[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33691 === (8))){
var inst_33633 = (state_33690[(14)]);
var inst_33634 = (state_33690[(15)]);
var inst_33636 = (inst_33634 < inst_33633);
var inst_33637 = inst_33636;
var state_33690__$1 = state_33690;
if(cljs.core.truth_(inst_33637)){
var statearr_33729_33769 = state_33690__$1;
(statearr_33729_33769[(1)] = (10));

} else {
var statearr_33730_33770 = state_33690__$1;
(statearr_33730_33770[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___33742,mults,ensure_mult,p))
;
return ((function (switch__19063__auto__,c__19175__auto___33742,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__19064__auto__ = null;
var cljs$core$async$state_machine__19064__auto____0 = (function (){
var statearr_33734 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33734[(0)] = cljs$core$async$state_machine__19064__auto__);

(statearr_33734[(1)] = (1));

return statearr_33734;
});
var cljs$core$async$state_machine__19064__auto____1 = (function (state_33690){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_33690);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e33735){if((e33735 instanceof Object)){
var ex__19067__auto__ = e33735;
var statearr_33736_33771 = state_33690;
(statearr_33736_33771[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33690);

return cljs.core.cst$kw$recur;
} else {
throw e33735;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__33772 = state_33690;
state_33690 = G__33772;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$state_machine__19064__auto__ = function(state_33690){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19064__auto____1.call(this,state_33690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19064__auto____0;
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19064__auto____1;
return cljs$core$async$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___33742,mults,ensure_mult,p))
})();
var state__19177__auto__ = (function (){var statearr_33737 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_33737[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___33742);

return statearr_33737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___33742,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args33773 = [];
var len__7651__auto___33776 = arguments.length;
var i__7652__auto___33777 = (0);
while(true){
if((i__7652__auto___33777 < len__7651__auto___33776)){
args33773.push((arguments[i__7652__auto___33777]));

var G__33778 = (i__7652__auto___33777 + (1));
i__7652__auto___33777 = G__33778;
continue;
} else {
}
break;
}

var G__33775 = args33773.length;
switch (G__33775) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33773.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args33780 = [];
var len__7651__auto___33783 = arguments.length;
var i__7652__auto___33784 = (0);
while(true){
if((i__7652__auto___33784 < len__7651__auto___33783)){
args33780.push((arguments[i__7652__auto___33784]));

var G__33785 = (i__7652__auto___33784 + (1));
i__7652__auto___33784 = G__33785;
continue;
} else {
}
break;
}

var G__33782 = args33780.length;
switch (G__33782) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33780.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args33787 = [];
var len__7651__auto___33858 = arguments.length;
var i__7652__auto___33859 = (0);
while(true){
if((i__7652__auto___33859 < len__7651__auto___33858)){
args33787.push((arguments[i__7652__auto___33859]));

var G__33860 = (i__7652__auto___33859 + (1));
i__7652__auto___33859 = G__33860;
continue;
} else {
}
break;
}

var G__33789 = args33787.length;
switch (G__33789) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33787.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__19175__auto___33862 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___33862,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___33862,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33828){
var state_val_33829 = (state_33828[(1)]);
if((state_val_33829 === (7))){
var state_33828__$1 = state_33828;
var statearr_33830_33863 = state_33828__$1;
(statearr_33830_33863[(2)] = null);

(statearr_33830_33863[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33829 === (1))){
var state_33828__$1 = state_33828;
var statearr_33831_33864 = state_33828__$1;
(statearr_33831_33864[(2)] = null);

(statearr_33831_33864[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33829 === (4))){
var inst_33792 = (state_33828[(7)]);
var inst_33794 = (inst_33792 < cnt);
var state_33828__$1 = state_33828;
if(cljs.core.truth_(inst_33794)){
var statearr_33832_33865 = state_33828__$1;
(statearr_33832_33865[(1)] = (6));

} else {
var statearr_33833_33866 = state_33828__$1;
(statearr_33833_33866[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33829 === (15))){
var inst_33824 = (state_33828[(2)]);
var state_33828__$1 = state_33828;
var statearr_33834_33867 = state_33828__$1;
(statearr_33834_33867[(2)] = inst_33824);

(statearr_33834_33867[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33829 === (13))){
var inst_33817 = cljs.core.async.close_BANG_(out);
var state_33828__$1 = state_33828;
var statearr_33835_33868 = state_33828__$1;
(statearr_33835_33868[(2)] = inst_33817);

(statearr_33835_33868[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33829 === (6))){
var state_33828__$1 = state_33828;
var statearr_33836_33869 = state_33828__$1;
(statearr_33836_33869[(2)] = null);

(statearr_33836_33869[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33829 === (3))){
var inst_33826 = (state_33828[(2)]);
var state_33828__$1 = state_33828;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33828__$1,inst_33826);
} else {
if((state_val_33829 === (12))){
var inst_33814 = (state_33828[(8)]);
var inst_33814__$1 = (state_33828[(2)]);
var inst_33815 = cljs.core.some(cljs.core.nil_QMARK_,inst_33814__$1);
var state_33828__$1 = (function (){var statearr_33837 = state_33828;
(statearr_33837[(8)] = inst_33814__$1);

return statearr_33837;
})();
if(cljs.core.truth_(inst_33815)){
var statearr_33838_33870 = state_33828__$1;
(statearr_33838_33870[(1)] = (13));

} else {
var statearr_33839_33871 = state_33828__$1;
(statearr_33839_33871[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33829 === (2))){
var inst_33791 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_33792 = (0);
var state_33828__$1 = (function (){var statearr_33840 = state_33828;
(statearr_33840[(7)] = inst_33792);

(statearr_33840[(9)] = inst_33791);

return statearr_33840;
})();
var statearr_33841_33872 = state_33828__$1;
(statearr_33841_33872[(2)] = null);

(statearr_33841_33872[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33829 === (11))){
var inst_33792 = (state_33828[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_33828,(10),Object,null,(9));
var inst_33801 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_33792) : chs__$1.call(null,inst_33792));
var inst_33802 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_33792) : done.call(null,inst_33792));
var inst_33803 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33801,inst_33802);
var state_33828__$1 = state_33828;
var statearr_33842_33873 = state_33828__$1;
(statearr_33842_33873[(2)] = inst_33803);


cljs.core.async.impl.ioc_helpers.process_exception(state_33828__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33829 === (9))){
var inst_33792 = (state_33828[(7)]);
var inst_33805 = (state_33828[(2)]);
var inst_33806 = (inst_33792 + (1));
var inst_33792__$1 = inst_33806;
var state_33828__$1 = (function (){var statearr_33843 = state_33828;
(statearr_33843[(7)] = inst_33792__$1);

(statearr_33843[(10)] = inst_33805);

return statearr_33843;
})();
var statearr_33844_33874 = state_33828__$1;
(statearr_33844_33874[(2)] = null);

(statearr_33844_33874[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33829 === (5))){
var inst_33812 = (state_33828[(2)]);
var state_33828__$1 = (function (){var statearr_33845 = state_33828;
(statearr_33845[(11)] = inst_33812);

return statearr_33845;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33828__$1,(12),dchan);
} else {
if((state_val_33829 === (14))){
var inst_33814 = (state_33828[(8)]);
var inst_33819 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_33814);
var state_33828__$1 = state_33828;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33828__$1,(16),out,inst_33819);
} else {
if((state_val_33829 === (16))){
var inst_33821 = (state_33828[(2)]);
var state_33828__$1 = (function (){var statearr_33846 = state_33828;
(statearr_33846[(12)] = inst_33821);

return statearr_33846;
})();
var statearr_33847_33875 = state_33828__$1;
(statearr_33847_33875[(2)] = null);

(statearr_33847_33875[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33829 === (10))){
var inst_33796 = (state_33828[(2)]);
var inst_33797 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_33828__$1 = (function (){var statearr_33848 = state_33828;
(statearr_33848[(13)] = inst_33796);

return statearr_33848;
})();
var statearr_33849_33876 = state_33828__$1;
(statearr_33849_33876[(2)] = inst_33797);


cljs.core.async.impl.ioc_helpers.process_exception(state_33828__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33829 === (8))){
var inst_33810 = (state_33828[(2)]);
var state_33828__$1 = state_33828;
var statearr_33850_33877 = state_33828__$1;
(statearr_33850_33877[(2)] = inst_33810);

(statearr_33850_33877[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___33862,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__19063__auto__,c__19175__auto___33862,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__19064__auto__ = null;
var cljs$core$async$state_machine__19064__auto____0 = (function (){
var statearr_33854 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33854[(0)] = cljs$core$async$state_machine__19064__auto__);

(statearr_33854[(1)] = (1));

return statearr_33854;
});
var cljs$core$async$state_machine__19064__auto____1 = (function (state_33828){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_33828);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e33855){if((e33855 instanceof Object)){
var ex__19067__auto__ = e33855;
var statearr_33856_33878 = state_33828;
(statearr_33856_33878[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33828);

return cljs.core.cst$kw$recur;
} else {
throw e33855;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__33879 = state_33828;
state_33828 = G__33879;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$state_machine__19064__auto__ = function(state_33828){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19064__auto____1.call(this,state_33828);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19064__auto____0;
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19064__auto____1;
return cljs$core$async$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___33862,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__19177__auto__ = (function (){var statearr_33857 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_33857[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___33862);

return statearr_33857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___33862,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args33881 = [];
var len__7651__auto___33939 = arguments.length;
var i__7652__auto___33940 = (0);
while(true){
if((i__7652__auto___33940 < len__7651__auto___33939)){
args33881.push((arguments[i__7652__auto___33940]));

var G__33941 = (i__7652__auto___33940 + (1));
i__7652__auto___33940 = G__33941;
continue;
} else {
}
break;
}

var G__33883 = args33881.length;
switch (G__33883) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33881.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19175__auto___33943 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___33943,out){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___33943,out){
return (function (state_33915){
var state_val_33916 = (state_33915[(1)]);
if((state_val_33916 === (7))){
var inst_33894 = (state_33915[(7)]);
var inst_33895 = (state_33915[(8)]);
var inst_33894__$1 = (state_33915[(2)]);
var inst_33895__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33894__$1,(0),null);
var inst_33896 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33894__$1,(1),null);
var inst_33897 = (inst_33895__$1 == null);
var state_33915__$1 = (function (){var statearr_33917 = state_33915;
(statearr_33917[(7)] = inst_33894__$1);

(statearr_33917[(8)] = inst_33895__$1);

(statearr_33917[(9)] = inst_33896);

return statearr_33917;
})();
if(cljs.core.truth_(inst_33897)){
var statearr_33918_33944 = state_33915__$1;
(statearr_33918_33944[(1)] = (8));

} else {
var statearr_33919_33945 = state_33915__$1;
(statearr_33919_33945[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33916 === (1))){
var inst_33884 = cljs.core.vec(chs);
var inst_33885 = inst_33884;
var state_33915__$1 = (function (){var statearr_33920 = state_33915;
(statearr_33920[(10)] = inst_33885);

return statearr_33920;
})();
var statearr_33921_33946 = state_33915__$1;
(statearr_33921_33946[(2)] = null);

(statearr_33921_33946[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33916 === (4))){
var inst_33885 = (state_33915[(10)]);
var state_33915__$1 = state_33915;
return cljs.core.async.ioc_alts_BANG_(state_33915__$1,(7),inst_33885);
} else {
if((state_val_33916 === (6))){
var inst_33911 = (state_33915[(2)]);
var state_33915__$1 = state_33915;
var statearr_33922_33947 = state_33915__$1;
(statearr_33922_33947[(2)] = inst_33911);

(statearr_33922_33947[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33916 === (3))){
var inst_33913 = (state_33915[(2)]);
var state_33915__$1 = state_33915;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33915__$1,inst_33913);
} else {
if((state_val_33916 === (2))){
var inst_33885 = (state_33915[(10)]);
var inst_33887 = cljs.core.count(inst_33885);
var inst_33888 = (inst_33887 > (0));
var state_33915__$1 = state_33915;
if(cljs.core.truth_(inst_33888)){
var statearr_33924_33948 = state_33915__$1;
(statearr_33924_33948[(1)] = (4));

} else {
var statearr_33925_33949 = state_33915__$1;
(statearr_33925_33949[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33916 === (11))){
var inst_33885 = (state_33915[(10)]);
var inst_33904 = (state_33915[(2)]);
var tmp33923 = inst_33885;
var inst_33885__$1 = tmp33923;
var state_33915__$1 = (function (){var statearr_33926 = state_33915;
(statearr_33926[(10)] = inst_33885__$1);

(statearr_33926[(11)] = inst_33904);

return statearr_33926;
})();
var statearr_33927_33950 = state_33915__$1;
(statearr_33927_33950[(2)] = null);

(statearr_33927_33950[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33916 === (9))){
var inst_33895 = (state_33915[(8)]);
var state_33915__$1 = state_33915;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33915__$1,(11),out,inst_33895);
} else {
if((state_val_33916 === (5))){
var inst_33909 = cljs.core.async.close_BANG_(out);
var state_33915__$1 = state_33915;
var statearr_33928_33951 = state_33915__$1;
(statearr_33928_33951[(2)] = inst_33909);

(statearr_33928_33951[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33916 === (10))){
var inst_33907 = (state_33915[(2)]);
var state_33915__$1 = state_33915;
var statearr_33929_33952 = state_33915__$1;
(statearr_33929_33952[(2)] = inst_33907);

(statearr_33929_33952[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33916 === (8))){
var inst_33885 = (state_33915[(10)]);
var inst_33894 = (state_33915[(7)]);
var inst_33895 = (state_33915[(8)]);
var inst_33896 = (state_33915[(9)]);
var inst_33899 = (function (){var cs = inst_33885;
var vec__33890 = inst_33894;
var v = inst_33895;
var c = inst_33896;
return ((function (cs,vec__33890,v,c,inst_33885,inst_33894,inst_33895,inst_33896,state_val_33916,c__19175__auto___33943,out){
return (function (p1__33880_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33880_SHARP_);
});
;})(cs,vec__33890,v,c,inst_33885,inst_33894,inst_33895,inst_33896,state_val_33916,c__19175__auto___33943,out))
})();
var inst_33900 = cljs.core.filterv(inst_33899,inst_33885);
var inst_33885__$1 = inst_33900;
var state_33915__$1 = (function (){var statearr_33930 = state_33915;
(statearr_33930[(10)] = inst_33885__$1);

return statearr_33930;
})();
var statearr_33931_33953 = state_33915__$1;
(statearr_33931_33953[(2)] = null);

(statearr_33931_33953[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___33943,out))
;
return ((function (switch__19063__auto__,c__19175__auto___33943,out){
return (function() {
var cljs$core$async$state_machine__19064__auto__ = null;
var cljs$core$async$state_machine__19064__auto____0 = (function (){
var statearr_33935 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33935[(0)] = cljs$core$async$state_machine__19064__auto__);

(statearr_33935[(1)] = (1));

return statearr_33935;
});
var cljs$core$async$state_machine__19064__auto____1 = (function (state_33915){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_33915);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e33936){if((e33936 instanceof Object)){
var ex__19067__auto__ = e33936;
var statearr_33937_33954 = state_33915;
(statearr_33937_33954[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33915);

return cljs.core.cst$kw$recur;
} else {
throw e33936;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__33955 = state_33915;
state_33915 = G__33955;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$state_machine__19064__auto__ = function(state_33915){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19064__auto____1.call(this,state_33915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19064__auto____0;
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19064__auto____1;
return cljs$core$async$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___33943,out))
})();
var state__19177__auto__ = (function (){var statearr_33938 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_33938[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___33943);

return statearr_33938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___33943,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args33956 = [];
var len__7651__auto___34005 = arguments.length;
var i__7652__auto___34006 = (0);
while(true){
if((i__7652__auto___34006 < len__7651__auto___34005)){
args33956.push((arguments[i__7652__auto___34006]));

var G__34007 = (i__7652__auto___34006 + (1));
i__7652__auto___34006 = G__34007;
continue;
} else {
}
break;
}

var G__33958 = args33956.length;
switch (G__33958) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33956.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19175__auto___34009 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___34009,out){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___34009,out){
return (function (state_33982){
var state_val_33983 = (state_33982[(1)]);
if((state_val_33983 === (7))){
var inst_33964 = (state_33982[(7)]);
var inst_33964__$1 = (state_33982[(2)]);
var inst_33965 = (inst_33964__$1 == null);
var inst_33966 = cljs.core.not(inst_33965);
var state_33982__$1 = (function (){var statearr_33984 = state_33982;
(statearr_33984[(7)] = inst_33964__$1);

return statearr_33984;
})();
if(inst_33966){
var statearr_33985_34010 = state_33982__$1;
(statearr_33985_34010[(1)] = (8));

} else {
var statearr_33986_34011 = state_33982__$1;
(statearr_33986_34011[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33983 === (1))){
var inst_33959 = (0);
var state_33982__$1 = (function (){var statearr_33987 = state_33982;
(statearr_33987[(8)] = inst_33959);

return statearr_33987;
})();
var statearr_33988_34012 = state_33982__$1;
(statearr_33988_34012[(2)] = null);

(statearr_33988_34012[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33983 === (4))){
var state_33982__$1 = state_33982;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33982__$1,(7),ch);
} else {
if((state_val_33983 === (6))){
var inst_33977 = (state_33982[(2)]);
var state_33982__$1 = state_33982;
var statearr_33989_34013 = state_33982__$1;
(statearr_33989_34013[(2)] = inst_33977);

(statearr_33989_34013[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33983 === (3))){
var inst_33979 = (state_33982[(2)]);
var inst_33980 = cljs.core.async.close_BANG_(out);
var state_33982__$1 = (function (){var statearr_33990 = state_33982;
(statearr_33990[(9)] = inst_33979);

return statearr_33990;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_33982__$1,inst_33980);
} else {
if((state_val_33983 === (2))){
var inst_33959 = (state_33982[(8)]);
var inst_33961 = (inst_33959 < n);
var state_33982__$1 = state_33982;
if(cljs.core.truth_(inst_33961)){
var statearr_33991_34014 = state_33982__$1;
(statearr_33991_34014[(1)] = (4));

} else {
var statearr_33992_34015 = state_33982__$1;
(statearr_33992_34015[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33983 === (11))){
var inst_33959 = (state_33982[(8)]);
var inst_33969 = (state_33982[(2)]);
var inst_33970 = (inst_33959 + (1));
var inst_33959__$1 = inst_33970;
var state_33982__$1 = (function (){var statearr_33993 = state_33982;
(statearr_33993[(8)] = inst_33959__$1);

(statearr_33993[(10)] = inst_33969);

return statearr_33993;
})();
var statearr_33994_34016 = state_33982__$1;
(statearr_33994_34016[(2)] = null);

(statearr_33994_34016[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33983 === (9))){
var state_33982__$1 = state_33982;
var statearr_33995_34017 = state_33982__$1;
(statearr_33995_34017[(2)] = null);

(statearr_33995_34017[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33983 === (5))){
var state_33982__$1 = state_33982;
var statearr_33996_34018 = state_33982__$1;
(statearr_33996_34018[(2)] = null);

(statearr_33996_34018[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33983 === (10))){
var inst_33974 = (state_33982[(2)]);
var state_33982__$1 = state_33982;
var statearr_33997_34019 = state_33982__$1;
(statearr_33997_34019[(2)] = inst_33974);

(statearr_33997_34019[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33983 === (8))){
var inst_33964 = (state_33982[(7)]);
var state_33982__$1 = state_33982;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33982__$1,(11),out,inst_33964);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___34009,out))
;
return ((function (switch__19063__auto__,c__19175__auto___34009,out){
return (function() {
var cljs$core$async$state_machine__19064__auto__ = null;
var cljs$core$async$state_machine__19064__auto____0 = (function (){
var statearr_34001 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34001[(0)] = cljs$core$async$state_machine__19064__auto__);

(statearr_34001[(1)] = (1));

return statearr_34001;
});
var cljs$core$async$state_machine__19064__auto____1 = (function (state_33982){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_33982);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e34002){if((e34002 instanceof Object)){
var ex__19067__auto__ = e34002;
var statearr_34003_34020 = state_33982;
(statearr_34003_34020[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33982);

return cljs.core.cst$kw$recur;
} else {
throw e34002;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__34021 = state_33982;
state_33982 = G__34021;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$state_machine__19064__auto__ = function(state_33982){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19064__auto____1.call(this,state_33982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19064__auto____0;
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19064__auto____1;
return cljs$core$async$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___34009,out))
})();
var state__19177__auto__ = (function (){var statearr_34004 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_34004[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___34009);

return statearr_34004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___34009,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async34031 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34031 = (function (f,ch,meta34032){
this.f = f;
this.ch = ch;
this.meta34032 = meta34032;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34031.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34033,meta34032__$1){
var self__ = this;
var _34033__$1 = this;
return (new cljs.core.async.t_cljs$core$async34031(self__.f,self__.ch,meta34032__$1));
});

cljs.core.async.t_cljs$core$async34031.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34033){
var self__ = this;
var _34033__$1 = this;
return self__.meta34032;
});

cljs.core.async.t_cljs$core$async34031.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34031.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async34031.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async34031.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34031.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async34034 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34034 = (function (f,ch,meta34032,_,fn1,meta34035){
this.f = f;
this.ch = ch;
this.meta34032 = meta34032;
this._ = _;
this.fn1 = fn1;
this.meta34035 = meta34035;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34034.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_34036,meta34035__$1){
var self__ = this;
var _34036__$1 = this;
return (new cljs.core.async.t_cljs$core$async34034(self__.f,self__.ch,self__.meta34032,self__._,self__.fn1,meta34035__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async34034.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_34036){
var self__ = this;
var _34036__$1 = this;
return self__.meta34035;
});})(___$1))
;

cljs.core.async.t_cljs$core$async34034.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34034.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async34034.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async34034.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__34022_SHARP_){
var G__34037 = (((p1__34022_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__34022_SHARP_) : self__.f.call(null,p1__34022_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__34037) : f1.call(null,G__34037));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async34034.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta34032,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async34031], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta34035], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async34034.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34034.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34034";

cljs.core.async.t_cljs$core$async34034.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34034");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async34034 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async34034(f__$1,ch__$1,meta34032__$1,___$2,fn1__$1,meta34035){
return (new cljs.core.async.t_cljs$core$async34034(f__$1,ch__$1,meta34032__$1,___$2,fn1__$1,meta34035));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async34034(self__.f,self__.ch,self__.meta34032,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6531__auto__ = ret;
if(cljs.core.truth_(and__6531__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__34038 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__34038) : self__.f.call(null,G__34038));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async34031.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34031.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async34031.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta34032], null);
});

cljs.core.async.t_cljs$core$async34031.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34031.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34031";

cljs.core.async.t_cljs$core$async34031.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34031");
});

cljs.core.async.__GT_t_cljs$core$async34031 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async34031(f__$1,ch__$1,meta34032){
return (new cljs.core.async.t_cljs$core$async34031(f__$1,ch__$1,meta34032));
});

}

return (new cljs.core.async.t_cljs$core$async34031(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async34042 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34042 = (function (f,ch,meta34043){
this.f = f;
this.ch = ch;
this.meta34043 = meta34043;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34042.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34044,meta34043__$1){
var self__ = this;
var _34044__$1 = this;
return (new cljs.core.async.t_cljs$core$async34042(self__.f,self__.ch,meta34043__$1));
});

cljs.core.async.t_cljs$core$async34042.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34044){
var self__ = this;
var _34044__$1 = this;
return self__.meta34043;
});

cljs.core.async.t_cljs$core$async34042.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34042.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async34042.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34042.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async34042.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34042.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async34042.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta34043], null);
});

cljs.core.async.t_cljs$core$async34042.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34042.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34042";

cljs.core.async.t_cljs$core$async34042.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34042");
});

cljs.core.async.__GT_t_cljs$core$async34042 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async34042(f__$1,ch__$1,meta34043){
return (new cljs.core.async.t_cljs$core$async34042(f__$1,ch__$1,meta34043));
});

}

return (new cljs.core.async.t_cljs$core$async34042(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async34048 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34048 = (function (p,ch,meta34049){
this.p = p;
this.ch = ch;
this.meta34049 = meta34049;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34048.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34050,meta34049__$1){
var self__ = this;
var _34050__$1 = this;
return (new cljs.core.async.t_cljs$core$async34048(self__.p,self__.ch,meta34049__$1));
});

cljs.core.async.t_cljs$core$async34048.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34050){
var self__ = this;
var _34050__$1 = this;
return self__.meta34049;
});

cljs.core.async.t_cljs$core$async34048.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34048.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async34048.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async34048.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34048.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async34048.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34048.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async34048.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta34049], null);
});

cljs.core.async.t_cljs$core$async34048.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34048.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34048";

cljs.core.async.t_cljs$core$async34048.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34048");
});

cljs.core.async.__GT_t_cljs$core$async34048 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async34048(p__$1,ch__$1,meta34049){
return (new cljs.core.async.t_cljs$core$async34048(p__$1,ch__$1,meta34049));
});

}

return (new cljs.core.async.t_cljs$core$async34048(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args34051 = [];
var len__7651__auto___34095 = arguments.length;
var i__7652__auto___34096 = (0);
while(true){
if((i__7652__auto___34096 < len__7651__auto___34095)){
args34051.push((arguments[i__7652__auto___34096]));

var G__34097 = (i__7652__auto___34096 + (1));
i__7652__auto___34096 = G__34097;
continue;
} else {
}
break;
}

var G__34053 = args34051.length;
switch (G__34053) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34051.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19175__auto___34099 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___34099,out){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___34099,out){
return (function (state_34074){
var state_val_34075 = (state_34074[(1)]);
if((state_val_34075 === (7))){
var inst_34070 = (state_34074[(2)]);
var state_34074__$1 = state_34074;
var statearr_34076_34100 = state_34074__$1;
(statearr_34076_34100[(2)] = inst_34070);

(statearr_34076_34100[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34075 === (1))){
var state_34074__$1 = state_34074;
var statearr_34077_34101 = state_34074__$1;
(statearr_34077_34101[(2)] = null);

(statearr_34077_34101[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34075 === (4))){
var inst_34056 = (state_34074[(7)]);
var inst_34056__$1 = (state_34074[(2)]);
var inst_34057 = (inst_34056__$1 == null);
var state_34074__$1 = (function (){var statearr_34078 = state_34074;
(statearr_34078[(7)] = inst_34056__$1);

return statearr_34078;
})();
if(cljs.core.truth_(inst_34057)){
var statearr_34079_34102 = state_34074__$1;
(statearr_34079_34102[(1)] = (5));

} else {
var statearr_34080_34103 = state_34074__$1;
(statearr_34080_34103[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34075 === (6))){
var inst_34056 = (state_34074[(7)]);
var inst_34061 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_34056) : p.call(null,inst_34056));
var state_34074__$1 = state_34074;
if(cljs.core.truth_(inst_34061)){
var statearr_34081_34104 = state_34074__$1;
(statearr_34081_34104[(1)] = (8));

} else {
var statearr_34082_34105 = state_34074__$1;
(statearr_34082_34105[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34075 === (3))){
var inst_34072 = (state_34074[(2)]);
var state_34074__$1 = state_34074;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34074__$1,inst_34072);
} else {
if((state_val_34075 === (2))){
var state_34074__$1 = state_34074;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34074__$1,(4),ch);
} else {
if((state_val_34075 === (11))){
var inst_34064 = (state_34074[(2)]);
var state_34074__$1 = state_34074;
var statearr_34083_34106 = state_34074__$1;
(statearr_34083_34106[(2)] = inst_34064);

(statearr_34083_34106[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34075 === (9))){
var state_34074__$1 = state_34074;
var statearr_34084_34107 = state_34074__$1;
(statearr_34084_34107[(2)] = null);

(statearr_34084_34107[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34075 === (5))){
var inst_34059 = cljs.core.async.close_BANG_(out);
var state_34074__$1 = state_34074;
var statearr_34085_34108 = state_34074__$1;
(statearr_34085_34108[(2)] = inst_34059);

(statearr_34085_34108[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34075 === (10))){
var inst_34067 = (state_34074[(2)]);
var state_34074__$1 = (function (){var statearr_34086 = state_34074;
(statearr_34086[(8)] = inst_34067);

return statearr_34086;
})();
var statearr_34087_34109 = state_34074__$1;
(statearr_34087_34109[(2)] = null);

(statearr_34087_34109[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34075 === (8))){
var inst_34056 = (state_34074[(7)]);
var state_34074__$1 = state_34074;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34074__$1,(11),out,inst_34056);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___34099,out))
;
return ((function (switch__19063__auto__,c__19175__auto___34099,out){
return (function() {
var cljs$core$async$state_machine__19064__auto__ = null;
var cljs$core$async$state_machine__19064__auto____0 = (function (){
var statearr_34091 = [null,null,null,null,null,null,null,null,null];
(statearr_34091[(0)] = cljs$core$async$state_machine__19064__auto__);

(statearr_34091[(1)] = (1));

return statearr_34091;
});
var cljs$core$async$state_machine__19064__auto____1 = (function (state_34074){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_34074);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e34092){if((e34092 instanceof Object)){
var ex__19067__auto__ = e34092;
var statearr_34093_34110 = state_34074;
(statearr_34093_34110[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34074);

return cljs.core.cst$kw$recur;
} else {
throw e34092;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__34111 = state_34074;
state_34074 = G__34111;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$state_machine__19064__auto__ = function(state_34074){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19064__auto____1.call(this,state_34074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19064__auto____0;
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19064__auto____1;
return cljs$core$async$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___34099,out))
})();
var state__19177__auto__ = (function (){var statearr_34094 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_34094[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___34099);

return statearr_34094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___34099,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args34112 = [];
var len__7651__auto___34115 = arguments.length;
var i__7652__auto___34116 = (0);
while(true){
if((i__7652__auto___34116 < len__7651__auto___34115)){
args34112.push((arguments[i__7652__auto___34116]));

var G__34117 = (i__7652__auto___34116 + (1));
i__7652__auto___34116 = G__34117;
continue;
} else {
}
break;
}

var G__34114 = args34112.length;
switch (G__34114) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34112.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__19175__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto__){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto__){
return (function (state_34284){
var state_val_34285 = (state_34284[(1)]);
if((state_val_34285 === (7))){
var inst_34280 = (state_34284[(2)]);
var state_34284__$1 = state_34284;
var statearr_34286_34327 = state_34284__$1;
(statearr_34286_34327[(2)] = inst_34280);

(statearr_34286_34327[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (20))){
var inst_34250 = (state_34284[(7)]);
var inst_34261 = (state_34284[(2)]);
var inst_34262 = cljs.core.next(inst_34250);
var inst_34236 = inst_34262;
var inst_34237 = null;
var inst_34238 = (0);
var inst_34239 = (0);
var state_34284__$1 = (function (){var statearr_34287 = state_34284;
(statearr_34287[(8)] = inst_34238);

(statearr_34287[(9)] = inst_34261);

(statearr_34287[(10)] = inst_34236);

(statearr_34287[(11)] = inst_34239);

(statearr_34287[(12)] = inst_34237);

return statearr_34287;
})();
var statearr_34288_34328 = state_34284__$1;
(statearr_34288_34328[(2)] = null);

(statearr_34288_34328[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (1))){
var state_34284__$1 = state_34284;
var statearr_34289_34329 = state_34284__$1;
(statearr_34289_34329[(2)] = null);

(statearr_34289_34329[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (4))){
var inst_34225 = (state_34284[(13)]);
var inst_34225__$1 = (state_34284[(2)]);
var inst_34226 = (inst_34225__$1 == null);
var state_34284__$1 = (function (){var statearr_34290 = state_34284;
(statearr_34290[(13)] = inst_34225__$1);

return statearr_34290;
})();
if(cljs.core.truth_(inst_34226)){
var statearr_34291_34330 = state_34284__$1;
(statearr_34291_34330[(1)] = (5));

} else {
var statearr_34292_34331 = state_34284__$1;
(statearr_34292_34331[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (15))){
var state_34284__$1 = state_34284;
var statearr_34296_34332 = state_34284__$1;
(statearr_34296_34332[(2)] = null);

(statearr_34296_34332[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (21))){
var state_34284__$1 = state_34284;
var statearr_34297_34333 = state_34284__$1;
(statearr_34297_34333[(2)] = null);

(statearr_34297_34333[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (13))){
var inst_34238 = (state_34284[(8)]);
var inst_34236 = (state_34284[(10)]);
var inst_34239 = (state_34284[(11)]);
var inst_34237 = (state_34284[(12)]);
var inst_34246 = (state_34284[(2)]);
var inst_34247 = (inst_34239 + (1));
var tmp34293 = inst_34238;
var tmp34294 = inst_34236;
var tmp34295 = inst_34237;
var inst_34236__$1 = tmp34294;
var inst_34237__$1 = tmp34295;
var inst_34238__$1 = tmp34293;
var inst_34239__$1 = inst_34247;
var state_34284__$1 = (function (){var statearr_34298 = state_34284;
(statearr_34298[(8)] = inst_34238__$1);

(statearr_34298[(10)] = inst_34236__$1);

(statearr_34298[(11)] = inst_34239__$1);

(statearr_34298[(12)] = inst_34237__$1);

(statearr_34298[(14)] = inst_34246);

return statearr_34298;
})();
var statearr_34299_34334 = state_34284__$1;
(statearr_34299_34334[(2)] = null);

(statearr_34299_34334[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (22))){
var state_34284__$1 = state_34284;
var statearr_34300_34335 = state_34284__$1;
(statearr_34300_34335[(2)] = null);

(statearr_34300_34335[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (6))){
var inst_34225 = (state_34284[(13)]);
var inst_34234 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34225) : f.call(null,inst_34225));
var inst_34235 = cljs.core.seq(inst_34234);
var inst_34236 = inst_34235;
var inst_34237 = null;
var inst_34238 = (0);
var inst_34239 = (0);
var state_34284__$1 = (function (){var statearr_34301 = state_34284;
(statearr_34301[(8)] = inst_34238);

(statearr_34301[(10)] = inst_34236);

(statearr_34301[(11)] = inst_34239);

(statearr_34301[(12)] = inst_34237);

return statearr_34301;
})();
var statearr_34302_34336 = state_34284__$1;
(statearr_34302_34336[(2)] = null);

(statearr_34302_34336[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (17))){
var inst_34250 = (state_34284[(7)]);
var inst_34254 = cljs.core.chunk_first(inst_34250);
var inst_34255 = cljs.core.chunk_rest(inst_34250);
var inst_34256 = cljs.core.count(inst_34254);
var inst_34236 = inst_34255;
var inst_34237 = inst_34254;
var inst_34238 = inst_34256;
var inst_34239 = (0);
var state_34284__$1 = (function (){var statearr_34303 = state_34284;
(statearr_34303[(8)] = inst_34238);

(statearr_34303[(10)] = inst_34236);

(statearr_34303[(11)] = inst_34239);

(statearr_34303[(12)] = inst_34237);

return statearr_34303;
})();
var statearr_34304_34337 = state_34284__$1;
(statearr_34304_34337[(2)] = null);

(statearr_34304_34337[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (3))){
var inst_34282 = (state_34284[(2)]);
var state_34284__$1 = state_34284;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34284__$1,inst_34282);
} else {
if((state_val_34285 === (12))){
var inst_34270 = (state_34284[(2)]);
var state_34284__$1 = state_34284;
var statearr_34305_34338 = state_34284__$1;
(statearr_34305_34338[(2)] = inst_34270);

(statearr_34305_34338[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (2))){
var state_34284__$1 = state_34284;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34284__$1,(4),in$);
} else {
if((state_val_34285 === (23))){
var inst_34278 = (state_34284[(2)]);
var state_34284__$1 = state_34284;
var statearr_34306_34339 = state_34284__$1;
(statearr_34306_34339[(2)] = inst_34278);

(statearr_34306_34339[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (19))){
var inst_34265 = (state_34284[(2)]);
var state_34284__$1 = state_34284;
var statearr_34307_34340 = state_34284__$1;
(statearr_34307_34340[(2)] = inst_34265);

(statearr_34307_34340[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (11))){
var inst_34250 = (state_34284[(7)]);
var inst_34236 = (state_34284[(10)]);
var inst_34250__$1 = cljs.core.seq(inst_34236);
var state_34284__$1 = (function (){var statearr_34308 = state_34284;
(statearr_34308[(7)] = inst_34250__$1);

return statearr_34308;
})();
if(inst_34250__$1){
var statearr_34309_34341 = state_34284__$1;
(statearr_34309_34341[(1)] = (14));

} else {
var statearr_34310_34342 = state_34284__$1;
(statearr_34310_34342[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (9))){
var inst_34272 = (state_34284[(2)]);
var inst_34273 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_34284__$1 = (function (){var statearr_34311 = state_34284;
(statearr_34311[(15)] = inst_34272);

return statearr_34311;
})();
if(cljs.core.truth_(inst_34273)){
var statearr_34312_34343 = state_34284__$1;
(statearr_34312_34343[(1)] = (21));

} else {
var statearr_34313_34344 = state_34284__$1;
(statearr_34313_34344[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (5))){
var inst_34228 = cljs.core.async.close_BANG_(out);
var state_34284__$1 = state_34284;
var statearr_34314_34345 = state_34284__$1;
(statearr_34314_34345[(2)] = inst_34228);

(statearr_34314_34345[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (14))){
var inst_34250 = (state_34284[(7)]);
var inst_34252 = cljs.core.chunked_seq_QMARK_(inst_34250);
var state_34284__$1 = state_34284;
if(inst_34252){
var statearr_34315_34346 = state_34284__$1;
(statearr_34315_34346[(1)] = (17));

} else {
var statearr_34316_34347 = state_34284__$1;
(statearr_34316_34347[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (16))){
var inst_34268 = (state_34284[(2)]);
var state_34284__$1 = state_34284;
var statearr_34317_34348 = state_34284__$1;
(statearr_34317_34348[(2)] = inst_34268);

(statearr_34317_34348[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34285 === (10))){
var inst_34239 = (state_34284[(11)]);
var inst_34237 = (state_34284[(12)]);
var inst_34244 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_34237,inst_34239);
var state_34284__$1 = state_34284;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34284__$1,(13),out,inst_34244);
} else {
if((state_val_34285 === (18))){
var inst_34250 = (state_34284[(7)]);
var inst_34259 = cljs.core.first(inst_34250);
var state_34284__$1 = state_34284;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34284__$1,(20),out,inst_34259);
} else {
if((state_val_34285 === (8))){
var inst_34238 = (state_34284[(8)]);
var inst_34239 = (state_34284[(11)]);
var inst_34241 = (inst_34239 < inst_34238);
var inst_34242 = inst_34241;
var state_34284__$1 = state_34284;
if(cljs.core.truth_(inst_34242)){
var statearr_34318_34349 = state_34284__$1;
(statearr_34318_34349[(1)] = (10));

} else {
var statearr_34319_34350 = state_34284__$1;
(statearr_34319_34350[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto__))
;
return ((function (switch__19063__auto__,c__19175__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__19064__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__19064__auto____0 = (function (){
var statearr_34323 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34323[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__19064__auto__);

(statearr_34323[(1)] = (1));

return statearr_34323;
});
var cljs$core$async$mapcat_STAR__$_state_machine__19064__auto____1 = (function (state_34284){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_34284);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e34324){if((e34324 instanceof Object)){
var ex__19067__auto__ = e34324;
var statearr_34325_34351 = state_34284;
(statearr_34325_34351[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34284);

return cljs.core.cst$kw$recur;
} else {
throw e34324;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__34352 = state_34284;
state_34284 = G__34352;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__19064__auto__ = function(state_34284){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__19064__auto____1.call(this,state_34284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__19064__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__19064__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto__))
})();
var state__19177__auto__ = (function (){var statearr_34326 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_34326[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto__);

return statearr_34326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto__))
);

return c__19175__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args34353 = [];
var len__7651__auto___34356 = arguments.length;
var i__7652__auto___34357 = (0);
while(true){
if((i__7652__auto___34357 < len__7651__auto___34356)){
args34353.push((arguments[i__7652__auto___34357]));

var G__34358 = (i__7652__auto___34357 + (1));
i__7652__auto___34357 = G__34358;
continue;
} else {
}
break;
}

var G__34355 = args34353.length;
switch (G__34355) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34353.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args34360 = [];
var len__7651__auto___34363 = arguments.length;
var i__7652__auto___34364 = (0);
while(true){
if((i__7652__auto___34364 < len__7651__auto___34363)){
args34360.push((arguments[i__7652__auto___34364]));

var G__34365 = (i__7652__auto___34364 + (1));
i__7652__auto___34364 = G__34365;
continue;
} else {
}
break;
}

var G__34362 = args34360.length;
switch (G__34362) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34360.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args34367 = [];
var len__7651__auto___34418 = arguments.length;
var i__7652__auto___34419 = (0);
while(true){
if((i__7652__auto___34419 < len__7651__auto___34418)){
args34367.push((arguments[i__7652__auto___34419]));

var G__34420 = (i__7652__auto___34419 + (1));
i__7652__auto___34419 = G__34420;
continue;
} else {
}
break;
}

var G__34369 = args34367.length;
switch (G__34369) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34367.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19175__auto___34422 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___34422,out){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___34422,out){
return (function (state_34393){
var state_val_34394 = (state_34393[(1)]);
if((state_val_34394 === (7))){
var inst_34388 = (state_34393[(2)]);
var state_34393__$1 = state_34393;
var statearr_34395_34423 = state_34393__$1;
(statearr_34395_34423[(2)] = inst_34388);

(statearr_34395_34423[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34394 === (1))){
var inst_34370 = null;
var state_34393__$1 = (function (){var statearr_34396 = state_34393;
(statearr_34396[(7)] = inst_34370);

return statearr_34396;
})();
var statearr_34397_34424 = state_34393__$1;
(statearr_34397_34424[(2)] = null);

(statearr_34397_34424[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34394 === (4))){
var inst_34373 = (state_34393[(8)]);
var inst_34373__$1 = (state_34393[(2)]);
var inst_34374 = (inst_34373__$1 == null);
var inst_34375 = cljs.core.not(inst_34374);
var state_34393__$1 = (function (){var statearr_34398 = state_34393;
(statearr_34398[(8)] = inst_34373__$1);

return statearr_34398;
})();
if(inst_34375){
var statearr_34399_34425 = state_34393__$1;
(statearr_34399_34425[(1)] = (5));

} else {
var statearr_34400_34426 = state_34393__$1;
(statearr_34400_34426[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34394 === (6))){
var state_34393__$1 = state_34393;
var statearr_34401_34427 = state_34393__$1;
(statearr_34401_34427[(2)] = null);

(statearr_34401_34427[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34394 === (3))){
var inst_34390 = (state_34393[(2)]);
var inst_34391 = cljs.core.async.close_BANG_(out);
var state_34393__$1 = (function (){var statearr_34402 = state_34393;
(statearr_34402[(9)] = inst_34390);

return statearr_34402;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34393__$1,inst_34391);
} else {
if((state_val_34394 === (2))){
var state_34393__$1 = state_34393;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34393__$1,(4),ch);
} else {
if((state_val_34394 === (11))){
var inst_34373 = (state_34393[(8)]);
var inst_34382 = (state_34393[(2)]);
var inst_34370 = inst_34373;
var state_34393__$1 = (function (){var statearr_34403 = state_34393;
(statearr_34403[(7)] = inst_34370);

(statearr_34403[(10)] = inst_34382);

return statearr_34403;
})();
var statearr_34404_34428 = state_34393__$1;
(statearr_34404_34428[(2)] = null);

(statearr_34404_34428[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34394 === (9))){
var inst_34373 = (state_34393[(8)]);
var state_34393__$1 = state_34393;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34393__$1,(11),out,inst_34373);
} else {
if((state_val_34394 === (5))){
var inst_34373 = (state_34393[(8)]);
var inst_34370 = (state_34393[(7)]);
var inst_34377 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34373,inst_34370);
var state_34393__$1 = state_34393;
if(inst_34377){
var statearr_34406_34429 = state_34393__$1;
(statearr_34406_34429[(1)] = (8));

} else {
var statearr_34407_34430 = state_34393__$1;
(statearr_34407_34430[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34394 === (10))){
var inst_34385 = (state_34393[(2)]);
var state_34393__$1 = state_34393;
var statearr_34408_34431 = state_34393__$1;
(statearr_34408_34431[(2)] = inst_34385);

(statearr_34408_34431[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34394 === (8))){
var inst_34370 = (state_34393[(7)]);
var tmp34405 = inst_34370;
var inst_34370__$1 = tmp34405;
var state_34393__$1 = (function (){var statearr_34409 = state_34393;
(statearr_34409[(7)] = inst_34370__$1);

return statearr_34409;
})();
var statearr_34410_34432 = state_34393__$1;
(statearr_34410_34432[(2)] = null);

(statearr_34410_34432[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___34422,out))
;
return ((function (switch__19063__auto__,c__19175__auto___34422,out){
return (function() {
var cljs$core$async$state_machine__19064__auto__ = null;
var cljs$core$async$state_machine__19064__auto____0 = (function (){
var statearr_34414 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34414[(0)] = cljs$core$async$state_machine__19064__auto__);

(statearr_34414[(1)] = (1));

return statearr_34414;
});
var cljs$core$async$state_machine__19064__auto____1 = (function (state_34393){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_34393);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e34415){if((e34415 instanceof Object)){
var ex__19067__auto__ = e34415;
var statearr_34416_34433 = state_34393;
(statearr_34416_34433[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34393);

return cljs.core.cst$kw$recur;
} else {
throw e34415;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__34434 = state_34393;
state_34393 = G__34434;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$state_machine__19064__auto__ = function(state_34393){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19064__auto____1.call(this,state_34393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19064__auto____0;
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19064__auto____1;
return cljs$core$async$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___34422,out))
})();
var state__19177__auto__ = (function (){var statearr_34417 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_34417[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___34422);

return statearr_34417;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___34422,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args34435 = [];
var len__7651__auto___34505 = arguments.length;
var i__7652__auto___34506 = (0);
while(true){
if((i__7652__auto___34506 < len__7651__auto___34505)){
args34435.push((arguments[i__7652__auto___34506]));

var G__34507 = (i__7652__auto___34506 + (1));
i__7652__auto___34506 = G__34507;
continue;
} else {
}
break;
}

var G__34437 = args34435.length;
switch (G__34437) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34435.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19175__auto___34509 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___34509,out){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___34509,out){
return (function (state_34475){
var state_val_34476 = (state_34475[(1)]);
if((state_val_34476 === (7))){
var inst_34471 = (state_34475[(2)]);
var state_34475__$1 = state_34475;
var statearr_34477_34510 = state_34475__$1;
(statearr_34477_34510[(2)] = inst_34471);

(statearr_34477_34510[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34476 === (1))){
var inst_34438 = (new Array(n));
var inst_34439 = inst_34438;
var inst_34440 = (0);
var state_34475__$1 = (function (){var statearr_34478 = state_34475;
(statearr_34478[(7)] = inst_34440);

(statearr_34478[(8)] = inst_34439);

return statearr_34478;
})();
var statearr_34479_34511 = state_34475__$1;
(statearr_34479_34511[(2)] = null);

(statearr_34479_34511[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34476 === (4))){
var inst_34443 = (state_34475[(9)]);
var inst_34443__$1 = (state_34475[(2)]);
var inst_34444 = (inst_34443__$1 == null);
var inst_34445 = cljs.core.not(inst_34444);
var state_34475__$1 = (function (){var statearr_34480 = state_34475;
(statearr_34480[(9)] = inst_34443__$1);

return statearr_34480;
})();
if(inst_34445){
var statearr_34481_34512 = state_34475__$1;
(statearr_34481_34512[(1)] = (5));

} else {
var statearr_34482_34513 = state_34475__$1;
(statearr_34482_34513[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34476 === (15))){
var inst_34465 = (state_34475[(2)]);
var state_34475__$1 = state_34475;
var statearr_34483_34514 = state_34475__$1;
(statearr_34483_34514[(2)] = inst_34465);

(statearr_34483_34514[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34476 === (13))){
var state_34475__$1 = state_34475;
var statearr_34484_34515 = state_34475__$1;
(statearr_34484_34515[(2)] = null);

(statearr_34484_34515[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34476 === (6))){
var inst_34440 = (state_34475[(7)]);
var inst_34461 = (inst_34440 > (0));
var state_34475__$1 = state_34475;
if(cljs.core.truth_(inst_34461)){
var statearr_34485_34516 = state_34475__$1;
(statearr_34485_34516[(1)] = (12));

} else {
var statearr_34486_34517 = state_34475__$1;
(statearr_34486_34517[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34476 === (3))){
var inst_34473 = (state_34475[(2)]);
var state_34475__$1 = state_34475;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34475__$1,inst_34473);
} else {
if((state_val_34476 === (12))){
var inst_34439 = (state_34475[(8)]);
var inst_34463 = cljs.core.vec(inst_34439);
var state_34475__$1 = state_34475;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34475__$1,(15),out,inst_34463);
} else {
if((state_val_34476 === (2))){
var state_34475__$1 = state_34475;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34475__$1,(4),ch);
} else {
if((state_val_34476 === (11))){
var inst_34455 = (state_34475[(2)]);
var inst_34456 = (new Array(n));
var inst_34439 = inst_34456;
var inst_34440 = (0);
var state_34475__$1 = (function (){var statearr_34487 = state_34475;
(statearr_34487[(10)] = inst_34455);

(statearr_34487[(7)] = inst_34440);

(statearr_34487[(8)] = inst_34439);

return statearr_34487;
})();
var statearr_34488_34518 = state_34475__$1;
(statearr_34488_34518[(2)] = null);

(statearr_34488_34518[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34476 === (9))){
var inst_34439 = (state_34475[(8)]);
var inst_34453 = cljs.core.vec(inst_34439);
var state_34475__$1 = state_34475;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34475__$1,(11),out,inst_34453);
} else {
if((state_val_34476 === (5))){
var inst_34443 = (state_34475[(9)]);
var inst_34440 = (state_34475[(7)]);
var inst_34439 = (state_34475[(8)]);
var inst_34448 = (state_34475[(11)]);
var inst_34447 = (inst_34439[inst_34440] = inst_34443);
var inst_34448__$1 = (inst_34440 + (1));
var inst_34449 = (inst_34448__$1 < n);
var state_34475__$1 = (function (){var statearr_34489 = state_34475;
(statearr_34489[(12)] = inst_34447);

(statearr_34489[(11)] = inst_34448__$1);

return statearr_34489;
})();
if(cljs.core.truth_(inst_34449)){
var statearr_34490_34519 = state_34475__$1;
(statearr_34490_34519[(1)] = (8));

} else {
var statearr_34491_34520 = state_34475__$1;
(statearr_34491_34520[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34476 === (14))){
var inst_34468 = (state_34475[(2)]);
var inst_34469 = cljs.core.async.close_BANG_(out);
var state_34475__$1 = (function (){var statearr_34493 = state_34475;
(statearr_34493[(13)] = inst_34468);

return statearr_34493;
})();
var statearr_34494_34521 = state_34475__$1;
(statearr_34494_34521[(2)] = inst_34469);

(statearr_34494_34521[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34476 === (10))){
var inst_34459 = (state_34475[(2)]);
var state_34475__$1 = state_34475;
var statearr_34495_34522 = state_34475__$1;
(statearr_34495_34522[(2)] = inst_34459);

(statearr_34495_34522[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34476 === (8))){
var inst_34439 = (state_34475[(8)]);
var inst_34448 = (state_34475[(11)]);
var tmp34492 = inst_34439;
var inst_34439__$1 = tmp34492;
var inst_34440 = inst_34448;
var state_34475__$1 = (function (){var statearr_34496 = state_34475;
(statearr_34496[(7)] = inst_34440);

(statearr_34496[(8)] = inst_34439__$1);

return statearr_34496;
})();
var statearr_34497_34523 = state_34475__$1;
(statearr_34497_34523[(2)] = null);

(statearr_34497_34523[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___34509,out))
;
return ((function (switch__19063__auto__,c__19175__auto___34509,out){
return (function() {
var cljs$core$async$state_machine__19064__auto__ = null;
var cljs$core$async$state_machine__19064__auto____0 = (function (){
var statearr_34501 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34501[(0)] = cljs$core$async$state_machine__19064__auto__);

(statearr_34501[(1)] = (1));

return statearr_34501;
});
var cljs$core$async$state_machine__19064__auto____1 = (function (state_34475){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_34475);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e34502){if((e34502 instanceof Object)){
var ex__19067__auto__ = e34502;
var statearr_34503_34524 = state_34475;
(statearr_34503_34524[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34475);

return cljs.core.cst$kw$recur;
} else {
throw e34502;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__34525 = state_34475;
state_34475 = G__34525;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$state_machine__19064__auto__ = function(state_34475){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19064__auto____1.call(this,state_34475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19064__auto____0;
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19064__auto____1;
return cljs$core$async$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___34509,out))
})();
var state__19177__auto__ = (function (){var statearr_34504 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_34504[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___34509);

return statearr_34504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___34509,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args34526 = [];
var len__7651__auto___34600 = arguments.length;
var i__7652__auto___34601 = (0);
while(true){
if((i__7652__auto___34601 < len__7651__auto___34600)){
args34526.push((arguments[i__7652__auto___34601]));

var G__34602 = (i__7652__auto___34601 + (1));
i__7652__auto___34601 = G__34602;
continue;
} else {
}
break;
}

var G__34528 = args34526.length;
switch (G__34528) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34526.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19175__auto___34604 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___34604,out){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___34604,out){
return (function (state_34570){
var state_val_34571 = (state_34570[(1)]);
if((state_val_34571 === (7))){
var inst_34566 = (state_34570[(2)]);
var state_34570__$1 = state_34570;
var statearr_34572_34605 = state_34570__$1;
(statearr_34572_34605[(2)] = inst_34566);

(statearr_34572_34605[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34571 === (1))){
var inst_34529 = [];
var inst_34530 = inst_34529;
var inst_34531 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_34570__$1 = (function (){var statearr_34573 = state_34570;
(statearr_34573[(7)] = inst_34531);

(statearr_34573[(8)] = inst_34530);

return statearr_34573;
})();
var statearr_34574_34606 = state_34570__$1;
(statearr_34574_34606[(2)] = null);

(statearr_34574_34606[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34571 === (4))){
var inst_34534 = (state_34570[(9)]);
var inst_34534__$1 = (state_34570[(2)]);
var inst_34535 = (inst_34534__$1 == null);
var inst_34536 = cljs.core.not(inst_34535);
var state_34570__$1 = (function (){var statearr_34575 = state_34570;
(statearr_34575[(9)] = inst_34534__$1);

return statearr_34575;
})();
if(inst_34536){
var statearr_34576_34607 = state_34570__$1;
(statearr_34576_34607[(1)] = (5));

} else {
var statearr_34577_34608 = state_34570__$1;
(statearr_34577_34608[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34571 === (15))){
var inst_34560 = (state_34570[(2)]);
var state_34570__$1 = state_34570;
var statearr_34578_34609 = state_34570__$1;
(statearr_34578_34609[(2)] = inst_34560);

(statearr_34578_34609[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34571 === (13))){
var state_34570__$1 = state_34570;
var statearr_34579_34610 = state_34570__$1;
(statearr_34579_34610[(2)] = null);

(statearr_34579_34610[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34571 === (6))){
var inst_34530 = (state_34570[(8)]);
var inst_34555 = inst_34530.length;
var inst_34556 = (inst_34555 > (0));
var state_34570__$1 = state_34570;
if(cljs.core.truth_(inst_34556)){
var statearr_34580_34611 = state_34570__$1;
(statearr_34580_34611[(1)] = (12));

} else {
var statearr_34581_34612 = state_34570__$1;
(statearr_34581_34612[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34571 === (3))){
var inst_34568 = (state_34570[(2)]);
var state_34570__$1 = state_34570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34570__$1,inst_34568);
} else {
if((state_val_34571 === (12))){
var inst_34530 = (state_34570[(8)]);
var inst_34558 = cljs.core.vec(inst_34530);
var state_34570__$1 = state_34570;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34570__$1,(15),out,inst_34558);
} else {
if((state_val_34571 === (2))){
var state_34570__$1 = state_34570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34570__$1,(4),ch);
} else {
if((state_val_34571 === (11))){
var inst_34534 = (state_34570[(9)]);
var inst_34538 = (state_34570[(10)]);
var inst_34548 = (state_34570[(2)]);
var inst_34549 = [];
var inst_34550 = inst_34549.push(inst_34534);
var inst_34530 = inst_34549;
var inst_34531 = inst_34538;
var state_34570__$1 = (function (){var statearr_34582 = state_34570;
(statearr_34582[(11)] = inst_34550);

(statearr_34582[(7)] = inst_34531);

(statearr_34582[(12)] = inst_34548);

(statearr_34582[(8)] = inst_34530);

return statearr_34582;
})();
var statearr_34583_34613 = state_34570__$1;
(statearr_34583_34613[(2)] = null);

(statearr_34583_34613[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34571 === (9))){
var inst_34530 = (state_34570[(8)]);
var inst_34546 = cljs.core.vec(inst_34530);
var state_34570__$1 = state_34570;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34570__$1,(11),out,inst_34546);
} else {
if((state_val_34571 === (5))){
var inst_34534 = (state_34570[(9)]);
var inst_34538 = (state_34570[(10)]);
var inst_34531 = (state_34570[(7)]);
var inst_34538__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34534) : f.call(null,inst_34534));
var inst_34539 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34538__$1,inst_34531);
var inst_34540 = cljs.core.keyword_identical_QMARK_(inst_34531,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_34541 = (inst_34539) || (inst_34540);
var state_34570__$1 = (function (){var statearr_34584 = state_34570;
(statearr_34584[(10)] = inst_34538__$1);

return statearr_34584;
})();
if(cljs.core.truth_(inst_34541)){
var statearr_34585_34614 = state_34570__$1;
(statearr_34585_34614[(1)] = (8));

} else {
var statearr_34586_34615 = state_34570__$1;
(statearr_34586_34615[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34571 === (14))){
var inst_34563 = (state_34570[(2)]);
var inst_34564 = cljs.core.async.close_BANG_(out);
var state_34570__$1 = (function (){var statearr_34588 = state_34570;
(statearr_34588[(13)] = inst_34563);

return statearr_34588;
})();
var statearr_34589_34616 = state_34570__$1;
(statearr_34589_34616[(2)] = inst_34564);

(statearr_34589_34616[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34571 === (10))){
var inst_34553 = (state_34570[(2)]);
var state_34570__$1 = state_34570;
var statearr_34590_34617 = state_34570__$1;
(statearr_34590_34617[(2)] = inst_34553);

(statearr_34590_34617[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34571 === (8))){
var inst_34534 = (state_34570[(9)]);
var inst_34538 = (state_34570[(10)]);
var inst_34530 = (state_34570[(8)]);
var inst_34543 = inst_34530.push(inst_34534);
var tmp34587 = inst_34530;
var inst_34530__$1 = tmp34587;
var inst_34531 = inst_34538;
var state_34570__$1 = (function (){var statearr_34591 = state_34570;
(statearr_34591[(14)] = inst_34543);

(statearr_34591[(7)] = inst_34531);

(statearr_34591[(8)] = inst_34530__$1);

return statearr_34591;
})();
var statearr_34592_34618 = state_34570__$1;
(statearr_34592_34618[(2)] = null);

(statearr_34592_34618[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___34604,out))
;
return ((function (switch__19063__auto__,c__19175__auto___34604,out){
return (function() {
var cljs$core$async$state_machine__19064__auto__ = null;
var cljs$core$async$state_machine__19064__auto____0 = (function (){
var statearr_34596 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34596[(0)] = cljs$core$async$state_machine__19064__auto__);

(statearr_34596[(1)] = (1));

return statearr_34596;
});
var cljs$core$async$state_machine__19064__auto____1 = (function (state_34570){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_34570);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e34597){if((e34597 instanceof Object)){
var ex__19067__auto__ = e34597;
var statearr_34598_34619 = state_34570;
(statearr_34598_34619[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34570);

return cljs.core.cst$kw$recur;
} else {
throw e34597;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__34620 = state_34570;
state_34570 = G__34620;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
cljs$core$async$state_machine__19064__auto__ = function(state_34570){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19064__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19064__auto____1.call(this,state_34570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19064__auto____0;
cljs$core$async$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19064__auto____1;
return cljs$core$async$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___34604,out))
})();
var state__19177__auto__ = (function (){var statearr_34599 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_34599[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___34604);

return statearr_34599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___34604,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

