// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
var G__35214 = http_options__$1;
if(cljs.core.truth_((function (){var and__6531__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return (cljs.core.not(cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1))) && (cljs.core.not(stateful_method_QMARK_));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.assoc_in(G__35214,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__35215 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__35215) : cljs_hash.md5.md5.call(null,G__35215));
})());
} else {
return G__35214;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35220 = arguments.length;
var i__7652__auto___35221 = (0);
while(true){
if((i__7652__auto___35221 < len__7651__auto___35220)){
args__7658__auto__.push((arguments[i__7652__auto___35221]));

var G__35222 = (i__7652__auto___35221 + (1));
i__7652__auto___35221 = G__35222;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__35217){
var map__35218 = p__35217;
var map__35218__$1 = ((((!((map__35218 == null)))?((((map__35218.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35218.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35218):map__35218);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35218__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35218__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35218__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35218__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("Token "),cljs.core.str(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__6531__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__6531__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4657__auto__ = (function (){var and__6531__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var crsf_token = temp__4657__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__6543__auto__ = accept_header;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq35216){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35216));
});

/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35232 = arguments.length;
var i__7652__auto___35233 = (0);
while(true){
if((i__7652__auto___35233 < len__7651__auto___35232)){
args__7658__auto__.push((arguments[i__7652__auto___35233]));

var G__35234 = (i__7652__auto___35233 + (1));
i__7652__auto___35233 = G__35234;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__35225){
var vec__35226 = p__35225;
var map__35229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35226,(0),null);
var map__35229__$1 = ((((!((map__35229 == null)))?((((map__35229.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35229.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35229):map__35229);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35229__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e35231){if((e35231 instanceof Error)){
var _ = e35231;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e35231;

}
}} else {
return io_obj.getResponseText();
}
});

milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1);

milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq35223){
var G__35224 = cljs.core.first(seq35223);
var seq35223__$1 = cljs.core.next(seq35223);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(G__35224,seq35223__$1);
});

milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
var G__35241_35247 = io_obj;
var G__35242_35248 = goog.net.EventType.SUCCESS;
var G__35243_35249 = ((function (G__35241_35247,G__35242_35248,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__35241_35247,G__35242_35248,io_obj))
;
goog.events.listen(G__35241_35247,G__35242_35248,G__35243_35249);

var G__35244_35250 = io_obj;
var G__35245_35251 = goog.net.EventType.ERROR;
var G__35246_35252 = ((function (G__35244_35250,G__35245_35251,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__35244_35250,G__35245_35251,io_obj))
;
goog.events.listen(G__35244_35250,G__35245_35251,G__35246_35252);

return io_obj.sendFromForm(form,[cljs.core.str(form_api),cljs.core.str("?legacy=true")].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://goo.gl/B0fm2a
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35269 = arguments.length;
var i__7652__auto___35270 = (0);
while(true){
if((i__7652__auto___35270 < len__7651__auto___35269)){
args__7658__auto__.push((arguments[i__7652__auto___35270]));

var G__35271 = (i__7652__auto___35270 + (1));
i__7652__auto___35270 = G__35271;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__35257){
var map__35258 = p__35257;
var map__35258__$1 = ((((!((map__35258 == null)))?((((map__35258.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35258.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35258):map__35258);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35258__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35258__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35258__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

var G__35260_35272 = io_obj;
var G__35261_35273 = goog.net.EventType.SUCCESS;
var G__35262_35274 = ((function (G__35260_35272,G__35261_35273,io_obj,data,url,map__35258,map__35258__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,true], 0)));
});})(G__35260_35272,G__35261_35273,io_obj,data,url,map__35258,map__35258__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__35260_35272,G__35261_35273,G__35262_35274);

var G__35263_35275 = io_obj;
var G__35264_35276 = goog.net.EventType.ERROR;
var G__35265_35277 = ((function (G__35263_35275,G__35264_35276,io_obj,data,url,map__35258,map__35258__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,false], 0)));
});})(G__35263_35275,G__35264_35276,io_obj,data,url,map__35258,map__35258__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__35263_35275,G__35264_35276,G__35265_35277);

var G__35266_35278 = io_obj;
var G__35267_35279 = goog.net.EventType.PROGRESS;
var G__35268_35280 = ((function (G__35266_35278,G__35267_35279,io_obj,data,url,map__35258,map__35258__$1,headers,id,require_json_QMARK_){
return (function (p1__35253_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__35253_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__35253_SHARP_.loaded,cljs.core.cst$kw$total,p1__35253_SHARP_.total], null)));
});})(G__35266_35278,G__35267_35279,io_obj,data,url,map__35258,map__35258__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__35266_35278,G__35267_35279,G__35268_35280);

io_obj.send(url,"POST",form,headers);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq35254){
var G__35255 = cljs.core.first(seq35254);
var seq35254__$1 = cljs.core.next(seq35254);
var G__35256 = cljs.core.first(seq35254__$1);
var seq35254__$2 = cljs.core.next(seq35254__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__35255,G__35256,seq35254__$2);
});

/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35345 = arguments.length;
var i__7652__auto___35346 = (0);
while(true){
if((i__7652__auto___35346 < len__7651__auto___35345)){
args__7658__auto__.push((arguments[i__7652__auto___35346]));

var G__35347 = (i__7652__auto___35346 + (1));
i__7652__auto___35346 = G__35347;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__19175__auto___35348 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto___35348,response_channel){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto___35348,response_channel){
return (function (state_35318){
var state_val_35319 = (state_35318[(1)]);
if((state_val_35319 === (7))){
var state_35318__$1 = state_35318;
var statearr_35320_35349 = state_35318__$1;
(statearr_35320_35349[(2)] = false);

(statearr_35320_35349[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35319 === (1))){
var inst_35284 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_35318__$1 = state_35318;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35318__$1,(2),inst_35284);
} else {
if((state_val_35319 === (4))){
var state_35318__$1 = state_35318;
var statearr_35321_35350 = state_35318__$1;
(statearr_35321_35350[(2)] = false);

(statearr_35321_35350[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35319 === (13))){
var inst_35307 = (state_35318[(7)]);
var inst_35314 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_35307);
var state_35318__$1 = state_35318;
var statearr_35322_35351 = state_35318__$1;
(statearr_35322_35351[(2)] = inst_35314);

(statearr_35322_35351[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35319 === (6))){
var state_35318__$1 = state_35318;
var statearr_35323_35352 = state_35318__$1;
(statearr_35323_35352[(2)] = true);

(statearr_35323_35352[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35319 === (3))){
var inst_35286 = (state_35318[(8)]);
var inst_35291 = inst_35286.cljs$lang$protocol_mask$partition0$;
var inst_35292 = (inst_35291 & (64));
var inst_35293 = inst_35286.cljs$core$ISeq$;
var inst_35294 = (cljs.core.PROTOCOL_SENTINEL === inst_35293);
var inst_35295 = (inst_35292) || (inst_35294);
var state_35318__$1 = state_35318;
if(cljs.core.truth_(inst_35295)){
var statearr_35324_35353 = state_35318__$1;
(statearr_35324_35353[(1)] = (6));

} else {
var statearr_35325_35354 = state_35318__$1;
(statearr_35325_35354[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35319 === (12))){
var inst_35311 = window.location.href();
var inst_35312 = window.location = inst_35311;
var state_35318__$1 = state_35318;
var statearr_35326_35355 = state_35318__$1;
(statearr_35326_35355[(2)] = inst_35312);

(statearr_35326_35355[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35319 === (2))){
var inst_35286 = (state_35318[(8)]);
var inst_35286__$1 = (state_35318[(2)]);
var inst_35288 = (inst_35286__$1 == null);
var inst_35289 = cljs.core.not(inst_35288);
var state_35318__$1 = (function (){var statearr_35327 = state_35318;
(statearr_35327[(8)] = inst_35286__$1);

return statearr_35327;
})();
if(inst_35289){
var statearr_35328_35356 = state_35318__$1;
(statearr_35328_35356[(1)] = (3));

} else {
var statearr_35329_35357 = state_35318__$1;
(statearr_35329_35357[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35319 === (11))){
var inst_35307 = (state_35318[(7)]);
var inst_35307__$1 = (state_35318[(2)]);
var inst_35308 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35307__$1,cljs.core.cst$kw$status);
var inst_35309 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35308,(401));
var state_35318__$1 = (function (){var statearr_35330 = state_35318;
(statearr_35330[(7)] = inst_35307__$1);

return statearr_35330;
})();
if(inst_35309){
var statearr_35331_35358 = state_35318__$1;
(statearr_35331_35358[(1)] = (12));

} else {
var statearr_35332_35359 = state_35318__$1;
(statearr_35332_35359[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35319 === (9))){
var inst_35286 = (state_35318[(8)]);
var inst_35304 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35286);
var state_35318__$1 = state_35318;
var statearr_35333_35360 = state_35318__$1;
(statearr_35333_35360[(2)] = inst_35304);

(statearr_35333_35360[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35319 === (5))){
var inst_35302 = (state_35318[(2)]);
var state_35318__$1 = state_35318;
if(cljs.core.truth_(inst_35302)){
var statearr_35334_35361 = state_35318__$1;
(statearr_35334_35361[(1)] = (9));

} else {
var statearr_35335_35362 = state_35318__$1;
(statearr_35335_35362[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35319 === (14))){
var inst_35316 = (state_35318[(2)]);
var state_35318__$1 = state_35318;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35318__$1,inst_35316);
} else {
if((state_val_35319 === (10))){
var inst_35286 = (state_35318[(8)]);
var state_35318__$1 = state_35318;
var statearr_35336_35363 = state_35318__$1;
(statearr_35336_35363[(2)] = inst_35286);

(statearr_35336_35363[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35319 === (8))){
var inst_35299 = (state_35318[(2)]);
var state_35318__$1 = state_35318;
var statearr_35337_35364 = state_35318__$1;
(statearr_35337_35364[(2)] = inst_35299);

(statearr_35337_35364[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto___35348,response_channel))
;
return ((function (switch__19063__auto__,c__19175__auto___35348,response_channel){
return (function() {
var milia$api$io$state_machine__19064__auto__ = null;
var milia$api$io$state_machine__19064__auto____0 = (function (){
var statearr_35341 = [null,null,null,null,null,null,null,null,null];
(statearr_35341[(0)] = milia$api$io$state_machine__19064__auto__);

(statearr_35341[(1)] = (1));

return statearr_35341;
});
var milia$api$io$state_machine__19064__auto____1 = (function (state_35318){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_35318);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e35342){if((e35342 instanceof Object)){
var ex__19067__auto__ = e35342;
var statearr_35343_35365 = state_35318;
(statearr_35343_35365[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35318);

return cljs.core.cst$kw$recur;
} else {
throw e35342;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__35366 = state_35318;
state_35318 = G__35366;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
milia$api$io$state_machine__19064__auto__ = function(state_35318){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__19064__auto____0.call(this);
case 1:
return milia$api$io$state_machine__19064__auto____1.call(this,state_35318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__19064__auto____0;
milia$api$io$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__19064__auto____1;
return milia$api$io$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto___35348,response_channel))
})();
var state__19177__auto__ = (function (){var statearr_35344 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_35344[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto___35348);

return statearr_35344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto___35348,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq35281){
var G__35282 = cljs.core.first(seq35281);
var seq35281__$1 = cljs.core.next(seq35281);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__35282,seq35281__$1);
});

