// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.project');
goog.require('cljs.core');
goog.require('chimera.urls');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.metadata');
goog.require('milia.utils.remote');
/**
 * Parse and add the projects ID.
 */
milia.api.project.add_id = (function milia$api$project$add_id(project_data){
if(typeof project_data === 'string'){
return null;
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([project_data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,chimera.urls.last_url_param(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(project_data))], null)], 0));
}
});
/**
 * Get the forms for this account and owner of the user.
 */
milia.api.project.get_forms = (function milia$api$project$get_forms(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"forms"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.project.get_project = (function milia$api$project$get_project(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35672 = arguments.length;
var i__7652__auto___35673 = (0);
while(true){
if((i__7652__auto___35673 < len__7651__auto___35672)){
args__7658__auto__.push((arguments[i__7652__auto___35673]));

var G__35674 = (i__7652__auto___35673 + (1));
i__7652__auto___35673 = G__35674;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__35669){
var map__35670 = p__35669;
var map__35670__$1 = ((((!((map__35670 == null)))?((((map__35670.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35670.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35670):map__35670);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35670__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
var data = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
return data;
});

milia.api.project.get_project.cljs$lang$maxFixedArity = (1);

milia.api.project.get_project.cljs$lang$applyTo = (function (seq35667){
var G__35668 = cljs.core.first(seq35667);
var seq35667__$1 = cljs.core.next(seq35667);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic(G__35668,seq35667__$1);
});

/**
 * Return all project for this account and owner or the user.
 */
milia.api.project.all = (function milia$api$project$all(var_args){
var args35677 = [];
var len__7651__auto___35685 = arguments.length;
var i__7652__auto___35686 = (0);
while(true){
if((i__7652__auto___35686 < len__7651__auto___35685)){
args35677.push((arguments[i__7652__auto___35686]));

var G__35687 = (i__7652__auto___35686 + (1));
i__7652__auto___35686 = G__35687;
continue;
} else {
}
break;
}

var G__35681 = args35677.length;
switch (G__35681) {
case 0:
return milia.api.project.all.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args35677.slice((1)),(0),null));
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7670__auto__);

}
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.project.all(null);
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic = (function (owner,p__35682){
var map__35683 = p__35682;
var map__35683__$1 = ((((!((map__35683 == null)))?((((map__35683.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35683.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35683):map__35683);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35683__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var logged_in_username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35683__$1,cljs.core.cst$kw$logged_DASH_in_DASH_username);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
var options = ((function (url,map__35683,map__35683__$1,no_cache_QMARK_,logged_in_username){
return (function (p1__35676_SHARP_){
if(cljs.core.truth_(logged_in_username)){
return cljs.core.assoc_in(p1__35676_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$u], null),logged_in_username);
} else {
return p1__35676_SHARP_;
}
});})(url,map__35683,map__35683__$1,no_cache_QMARK_,logged_in_username))
.call(null,((function (url,map__35683,map__35683__$1,no_cache_QMARK_,logged_in_username){
return (function (p1__35675_SHARP_){
if(cljs.core.truth_(owner)){
return cljs.core.assoc_in(p1__35675_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$owner], null),owner);
} else {
return p1__35675_SHARP_;
}
});})(url,map__35683,map__35683__$1,no_cache_QMARK_,logged_in_username))
.call(null,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,null], null)));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.project.all.cljs$lang$applyTo = (function (seq35678){
var G__35679 = cljs.core.first(seq35678);
var seq35678__$1 = cljs.core.next(seq35678);
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic(G__35679,seq35678__$1);
});

milia.api.project.all.cljs$lang$maxFixedArity = (1);

/**
 * Create a project for this account and owner or the user.
 */
milia.api.project.create = (function milia$api$project$create(data,owner){
var owner_url = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",owner], 0))], null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
var form_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([owner_url,data], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,form_params], null)], 0));
});
/**
 * Update project metadata
 */
milia.api.project.update = (function milia$api$project$update(project_id,data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,data], null)], 0));
});
/**
 * Share project with specific user or remove specific user from project
 */
milia.api.project.share = (function milia$api$project$share(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35697 = arguments.length;
var i__7652__auto___35698 = (0);
while(true){
if((i__7652__auto___35698 < len__7651__auto___35697)){
args__7658__auto__.push((arguments[i__7652__auto___35698]));

var G__35699 = (i__7652__auto___35698 + (1));
i__7652__auto___35698 = G__35699;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,username,role,p__35693){
var vec__35694 = p__35693;
var remove_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35694,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id,"share"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$role,role], null);
var form_params = (cljs.core.truth_(remove_QMARK_)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$remove,"True"], null)], 0)):data);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
});

milia.api.project.share.cljs$lang$maxFixedArity = (3);

milia.api.project.share.cljs$lang$applyTo = (function (seq35689){
var G__35690 = cljs.core.first(seq35689);
var seq35689__$1 = cljs.core.next(seq35689);
var G__35691 = cljs.core.first(seq35689__$1);
var seq35689__$2 = cljs.core.next(seq35689__$1);
var G__35692 = cljs.core.first(seq35689__$2);
var seq35689__$3 = cljs.core.next(seq35689__$2);
return milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic(G__35690,G__35691,G__35692,seq35689__$3);
});

/**
 * Add tags to a project.
 */
milia.api.project.add_tags = (function milia$api$project$add_tags(id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"labels"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null),cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Get projects with given tags.
 */
milia.api.project.with_tag = (function milia$api$project$with_tag(tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null)], null)], 0));
});
/**
 * Add star to project for this user.
 */
milia.api.project.add_star = (function milia$api$project$add_star(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35705 = arguments.length;
var i__7652__auto___35706 = (0);
while(true){
if((i__7652__auto___35706 < len__7651__auto___35705)){
args__7658__auto__.push((arguments[i__7652__auto___35706]));

var G__35707 = (i__7652__auto___35706 + (1));
i__7652__auto___35706 = G__35707;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__35702){
var map__35703 = p__35702;
var map__35703__$1 = ((((!((map__35703 == null)))?((((map__35703.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35703.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35703):map__35703);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35703__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$callback,callback], 0));
});

milia.api.project.add_star.cljs$lang$maxFixedArity = (1);

milia.api.project.add_star.cljs$lang$applyTo = (function (seq35700){
var G__35701 = cljs.core.first(seq35700);
var seq35700__$1 = cljs.core.next(seq35700);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic(G__35701,seq35700__$1);
});

/**
 * Remove star from project for this user.
 */
milia.api.project.remove_star = (function milia$api$project$remove_star(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35713 = arguments.length;
var i__7652__auto___35714 = (0);
while(true){
if((i__7652__auto___35714 < len__7651__auto___35713)){
args__7658__auto__.push((arguments[i__7652__auto___35714]));

var G__35715 = (i__7652__auto___35714 + (1));
i__7652__auto___35714 = G__35715;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__35710){
var map__35711 = p__35710;
var map__35711__$1 = ((((!((map__35711 == null)))?((((map__35711.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35711.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35711):map__35711);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35711__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$delete,url,cljs.core.array_seq([cljs.core.cst$kw$callback,callback], 0));
});

milia.api.project.remove_star.cljs$lang$maxFixedArity = (1);

milia.api.project.remove_star.cljs$lang$applyTo = (function (seq35708){
var G__35709 = cljs.core.first(seq35708);
var seq35708__$1 = cljs.core.next(seq35708);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic(G__35709,seq35708__$1);
});

/**
 * Toggle between starred and unstarred for a user's project
 */
milia.api.project.toggle_star = (function milia$api$project$toggle_star(id,star_QMARK_,callback){
return (cljs.core.truth_(star_QMARK_)?milia.api.project.add_star:milia.api.project.remove_star).call(null,id,cljs.core.cst$kw$callback,callback);
});
/**
 * Get projects this user has starred.
 */
milia.api.project.get_starred = (function milia$api$project$get_starred(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user",username,"starred"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Get user that starred this project.
 */
milia.api.project.starred_by = (function milia$api$project$starred_by(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Delete a project
 */
milia.api.project.delete$ = (function milia$api$project$delete(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Set new project owner
 */
milia.api.project.transfer_owner = (function milia$api$project$transfer_owner(id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",new_owner], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,new_owner__$1], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,form_params,cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Update the project public setting.
 */
milia.api.project.update_public = (function milia$api$project$update_public(projectid,public$){
return milia.api.project.update(projectid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$public,public$], null));
});
milia.api.project.files = (function milia$api$project$files(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35721 = arguments.length;
var i__7652__auto___35722 = (0);
while(true){
if((i__7652__auto___35722 < len__7651__auto___35721)){
args__7658__auto__.push((arguments[i__7652__auto___35722]));

var G__35723 = (i__7652__auto___35722 + (1));
i__7652__auto___35722 = G__35723;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,p__35718){
var map__35719 = p__35718;
var map__35719__$1 = ((((!((map__35719 == null)))?((((map__35719.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35719.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35719):map__35719);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35719__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.utils.metadata.metadata_files(cljs.core.cst$kw$project,project_id,no_cache_QMARK_);
});

milia.api.project.files.cljs$lang$maxFixedArity = (1);

milia.api.project.files.cljs$lang$applyTo = (function (seq35716){
var G__35717 = cljs.core.first(seq35716);
var seq35716__$1 = cljs.core.next(seq35716);
return milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic(G__35717,seq35716__$1);
});

