// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.retry');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('cljs.core.async');
goog.require('milia.api.http');
milia.utils.retry.default_max_retries = (1);
milia.utils.retry.default_retry_for_statuses = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(500),(502),(503),(504)], null);
milia.utils.retry.initial_polling_interval = (1000);
milia.utils.retry.retry_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$max_DASH_retries,cljs.core.cst$kw$retry_DASH_for_DASH_statuses], null);
/**
 * Retry if a status code in retry-for-statuses is returned. Pauses for an
 * exponentially backedoff initial-polling-interval in ClojureScript. Does not
 * pause between retries in Clojure.
 */
milia.utils.retry.retry_parse_http = (function milia$utils$retry$retry_parse_http(var_args){
var args__7658__auto__ = [];
var len__7651__auto___35561 = arguments.length;
var i__7652__auto___35562 = (0);
while(true){
if((i__7652__auto___35562 < len__7651__auto___35561)){
args__7658__auto__.push((arguments[i__7652__auto___35562]));

var G__35563 = (i__7652__auto___35562 + (1));
i__7652__auto___35562 = G__35563;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__35474){
var map__35475 = p__35474;
var map__35475__$1 = ((((!((map__35475 == null)))?((((map__35475.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35475.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35475):map__35475);
var options = map__35475__$1;
var max_retries = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35475__$1,cljs.core.cst$kw$max_DASH_retries,milia.utils.retry.default_max_retries);
var retry_for_statuses = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35475__$1,cljs.core.cst$kw$retry_DASH_for_DASH_statuses,milia.utils.retry.default_retry_for_statuses);
var c__19175__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19175__auto__,map__35475,map__35475__$1,options,max_retries,retry_for_statuses){
return (function (){
var f__19176__auto__ = (function (){var switch__19063__auto__ = ((function (c__19175__auto__,map__35475,map__35475__$1,options,max_retries,retry_for_statuses){
return (function (state_35526){
var state_val_35527 = (state_35526[(1)]);
if((state_val_35527 === (7))){
var inst_35500 = (state_35526[(2)]);
var state_35526__$1 = state_35526;
if(cljs.core.truth_(inst_35500)){
var statearr_35528_35564 = state_35526__$1;
(statearr_35528_35564[(1)] = (11));

} else {
var statearr_35529_35565 = state_35526__$1;
(statearr_35529_35565[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (20))){
var inst_35477 = (state_35526[(7)]);
var inst_35478 = (state_35526[(8)]);
var inst_35516 = (state_35526[(2)]);
var inst_35517 = (inst_35477 * (2));
var inst_35518 = (inst_35478 + (1));
var inst_35477__$1 = inst_35517;
var inst_35478__$1 = inst_35518;
var state_35526__$1 = (function (){var statearr_35530 = state_35526;
(statearr_35530[(9)] = inst_35516);

(statearr_35530[(7)] = inst_35477__$1);

(statearr_35530[(8)] = inst_35478__$1);

return statearr_35530;
})();
var statearr_35531_35566 = state_35526__$1;
(statearr_35531_35566[(2)] = null);

(statearr_35531_35566[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (1))){
var inst_35477 = milia.utils.retry.initial_polling_interval;
var inst_35478 = (0);
var state_35526__$1 = (function (){var statearr_35532 = state_35526;
(statearr_35532[(7)] = inst_35477);

(statearr_35532[(8)] = inst_35478);

return statearr_35532;
})();
var statearr_35533_35567 = state_35526__$1;
(statearr_35533_35567[(2)] = null);

(statearr_35533_35567[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (4))){
var inst_35484 = (state_35526[(10)]);
var inst_35484__$1 = (state_35526[(2)]);
var inst_35486 = (inst_35484__$1 == null);
var inst_35487 = cljs.core.not(inst_35486);
var state_35526__$1 = (function (){var statearr_35534 = state_35526;
(statearr_35534[(10)] = inst_35484__$1);

return statearr_35534;
})();
if(inst_35487){
var statearr_35535_35568 = state_35526__$1;
(statearr_35535_35568[(1)] = (5));

} else {
var statearr_35536_35569 = state_35526__$1;
(statearr_35536_35569[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (15))){
var inst_35507 = (state_35526[(11)]);
var state_35526__$1 = state_35526;
var statearr_35537_35570 = state_35526__$1;
(statearr_35537_35570[(2)] = inst_35507);

(statearr_35537_35570[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (13))){
var inst_35507 = (state_35526[(11)]);
var inst_35505 = (state_35526[(12)]);
var inst_35505__$1 = (state_35526[(2)]);
var inst_35506 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35505__$1,cljs.core.cst$kw$status);
var inst_35507__$1 = chimera.seq.in_QMARK_(retry_for_statuses,inst_35506);
var state_35526__$1 = (function (){var statearr_35538 = state_35526;
(statearr_35538[(11)] = inst_35507__$1);

(statearr_35538[(12)] = inst_35505__$1);

return statearr_35538;
})();
if(cljs.core.truth_(inst_35507__$1)){
var statearr_35539_35571 = state_35526__$1;
(statearr_35539_35571[(1)] = (14));

} else {
var statearr_35540_35572 = state_35526__$1;
(statearr_35540_35572[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (6))){
var state_35526__$1 = state_35526;
var statearr_35541_35573 = state_35526__$1;
(statearr_35541_35573[(2)] = false);

(statearr_35541_35573[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (17))){
var inst_35477 = (state_35526[(7)]);
var inst_35514 = cljs.core.async.timeout(inst_35477);
var state_35526__$1 = state_35526;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35526__$1,(20),inst_35514);
} else {
if((state_val_35527 === (3))){
var inst_35524 = (state_35526[(2)]);
var state_35526__$1 = state_35526;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35526__$1,inst_35524);
} else {
if((state_val_35527 === (12))){
var inst_35484 = (state_35526[(10)]);
var state_35526__$1 = state_35526;
var statearr_35542_35574 = state_35526__$1;
(statearr_35542_35574[(2)] = inst_35484);

(statearr_35542_35574[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (2))){
var inst_35481 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,options,milia.utils.retry.retry_keys);
var inst_35482 = chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(milia.api.http.parse_http,cljs.core.array_seq([method,url,inst_35481], 0));
var state_35526__$1 = state_35526;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35526__$1,(4),inst_35482);
} else {
if((state_val_35527 === (19))){
var inst_35522 = (state_35526[(2)]);
var state_35526__$1 = state_35526;
var statearr_35543_35575 = state_35526__$1;
(statearr_35543_35575[(2)] = inst_35522);

(statearr_35543_35575[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (11))){
var inst_35484 = (state_35526[(10)]);
var inst_35502 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35484);
var state_35526__$1 = state_35526;
var statearr_35544_35576 = state_35526__$1;
(statearr_35544_35576[(2)] = inst_35502);

(statearr_35544_35576[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (9))){
var state_35526__$1 = state_35526;
var statearr_35545_35577 = state_35526__$1;
(statearr_35545_35577[(2)] = false);

(statearr_35545_35577[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (5))){
var inst_35484 = (state_35526[(10)]);
var inst_35489 = inst_35484.cljs$lang$protocol_mask$partition0$;
var inst_35490 = (inst_35489 & (64));
var inst_35491 = inst_35484.cljs$core$ISeq$;
var inst_35492 = (cljs.core.PROTOCOL_SENTINEL === inst_35491);
var inst_35493 = (inst_35490) || (inst_35492);
var state_35526__$1 = state_35526;
if(cljs.core.truth_(inst_35493)){
var statearr_35546_35578 = state_35526__$1;
(statearr_35546_35578[(1)] = (8));

} else {
var statearr_35547_35579 = state_35526__$1;
(statearr_35547_35579[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (14))){
var inst_35478 = (state_35526[(8)]);
var inst_35509 = (inst_35478 < max_retries);
var state_35526__$1 = state_35526;
var statearr_35548_35580 = state_35526__$1;
(statearr_35548_35580[(2)] = inst_35509);

(statearr_35548_35580[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (16))){
var inst_35512 = (state_35526[(2)]);
var state_35526__$1 = state_35526;
if(cljs.core.truth_(inst_35512)){
var statearr_35549_35581 = state_35526__$1;
(statearr_35549_35581[(1)] = (17));

} else {
var statearr_35550_35582 = state_35526__$1;
(statearr_35550_35582[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (10))){
var inst_35497 = (state_35526[(2)]);
var state_35526__$1 = state_35526;
var statearr_35551_35583 = state_35526__$1;
(statearr_35551_35583[(2)] = inst_35497);

(statearr_35551_35583[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (18))){
var inst_35505 = (state_35526[(12)]);
var state_35526__$1 = state_35526;
var statearr_35552_35584 = state_35526__$1;
(statearr_35552_35584[(2)] = inst_35505);

(statearr_35552_35584[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35527 === (8))){
var state_35526__$1 = state_35526;
var statearr_35553_35585 = state_35526__$1;
(statearr_35553_35585[(2)] = true);

(statearr_35553_35585[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19175__auto__,map__35475,map__35475__$1,options,max_retries,retry_for_statuses))
;
return ((function (switch__19063__auto__,c__19175__auto__,map__35475,map__35475__$1,options,max_retries,retry_for_statuses){
return (function() {
var milia$utils$retry$state_machine__19064__auto__ = null;
var milia$utils$retry$state_machine__19064__auto____0 = (function (){
var statearr_35557 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35557[(0)] = milia$utils$retry$state_machine__19064__auto__);

(statearr_35557[(1)] = (1));

return statearr_35557;
});
var milia$utils$retry$state_machine__19064__auto____1 = (function (state_35526){
while(true){
var ret_value__19065__auto__ = (function (){try{while(true){
var result__19066__auto__ = switch__19063__auto__(state_35526);
if(cljs.core.keyword_identical_QMARK_(result__19066__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19066__auto__;
}
break;
}
}catch (e35558){if((e35558 instanceof Object)){
var ex__19067__auto__ = e35558;
var statearr_35559_35586 = state_35526;
(statearr_35559_35586[(5)] = ex__19067__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_35526);

return cljs.core.cst$kw$recur;
} else {
throw e35558;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19065__auto__,cljs.core.cst$kw$recur)){
var G__35587 = state_35526;
state_35526 = G__35587;
continue;
} else {
return ret_value__19065__auto__;
}
break;
}
});
milia$utils$retry$state_machine__19064__auto__ = function(state_35526){
switch(arguments.length){
case 0:
return milia$utils$retry$state_machine__19064__auto____0.call(this);
case 1:
return milia$utils$retry$state_machine__19064__auto____1.call(this,state_35526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$utils$retry$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$0 = milia$utils$retry$state_machine__19064__auto____0;
milia$utils$retry$state_machine__19064__auto__.cljs$core$IFn$_invoke$arity$1 = milia$utils$retry$state_machine__19064__auto____1;
return milia$utils$retry$state_machine__19064__auto__;
})()
;})(switch__19063__auto__,c__19175__auto__,map__35475,map__35475__$1,options,max_retries,retry_for_statuses))
})();
var state__19177__auto__ = (function (){var statearr_35560 = (f__19176__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19176__auto__.cljs$core$IFn$_invoke$arity$0() : f__19176__auto__.call(null));
(statearr_35560[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19175__auto__);

return statearr_35560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19177__auto__);
});})(c__19175__auto__,map__35475,map__35475__$1,options,max_retries,retry_for_statuses))
);

return c__19175__auto__;
});

milia.utils.retry.retry_parse_http.cljs$lang$maxFixedArity = (2);

milia.utils.retry.retry_parse_http.cljs$lang$applyTo = (function (seq35471){
var G__35472 = cljs.core.first(seq35471);
var seq35471__$1 = cljs.core.next(seq35471);
var G__35473 = cljs.core.first(seq35471__$1);
var seq35471__$2 = cljs.core.next(seq35471__$1);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(G__35472,G__35473,seq35471__$2);
});

