// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args31845 = [];
var len__7651__auto___31851 = arguments.length;
var i__7652__auto___31852 = (0);
while(true){
if((i__7652__auto___31852 < len__7651__auto___31851)){
args31845.push((arguments[i__7652__auto___31852]));

var G__31853 = (i__7652__auto___31852 + (1));
i__7652__auto___31852 = G__31853;
continue;
} else {
}
break;
}

var G__31847 = args31845.length;
switch (G__31847) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31845.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async31848 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31848 = (function (f,blockable,meta31849){
this.f = f;
this.blockable = blockable;
this.meta31849 = meta31849;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31850,meta31849__$1){
var self__ = this;
var _31850__$1 = this;
return (new cljs.core.async.t_cljs$core$async31848(self__.f,self__.blockable,meta31849__$1));
});

cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31850){
var self__ = this;
var _31850__$1 = this;
return self__.meta31849;
});

cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async31848.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async31848.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta31849], null);
});

cljs.core.async.t_cljs$core$async31848.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31848.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31848";

cljs.core.async.t_cljs$core$async31848.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async31848");
});

cljs.core.async.__GT_t_cljs$core$async31848 = (function cljs$core$async$__GT_t_cljs$core$async31848(f__$1,blockable__$1,meta31849){
return (new cljs.core.async.t_cljs$core$async31848(f__$1,blockable__$1,meta31849));
});

}

return (new cljs.core.async.t_cljs$core$async31848(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args31857 = [];
var len__7651__auto___31860 = arguments.length;
var i__7652__auto___31861 = (0);
while(true){
if((i__7652__auto___31861 < len__7651__auto___31860)){
args31857.push((arguments[i__7652__auto___31861]));

var G__31862 = (i__7652__auto___31861 + (1));
i__7652__auto___31861 = G__31862;
continue;
} else {
}
break;
}

var G__31859 = args31857.length;
switch (G__31859) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31857.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args31864 = [];
var len__7651__auto___31867 = arguments.length;
var i__7652__auto___31868 = (0);
while(true){
if((i__7652__auto___31868 < len__7651__auto___31867)){
args31864.push((arguments[i__7652__auto___31868]));

var G__31869 = (i__7652__auto___31868 + (1));
i__7652__auto___31868 = G__31869;
continue;
} else {
}
break;
}

var G__31866 = args31864.length;
switch (G__31866) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31864.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args31871 = [];
var len__7651__auto___31874 = arguments.length;
var i__7652__auto___31875 = (0);
while(true){
if((i__7652__auto___31875 < len__7651__auto___31874)){
args31871.push((arguments[i__7652__auto___31875]));

var G__31876 = (i__7652__auto___31875 + (1));
i__7652__auto___31875 = G__31876;
continue;
} else {
}
break;
}

var G__31873 = args31871.length;
switch (G__31873) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31871.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_31878 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31878) : fn1.call(null,val_31878));
} else {
cljs.core.async.impl.dispatch.run(((function (val_31878,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31878) : fn1.call(null,val_31878));
});})(val_31878,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args31879 = [];
var len__7651__auto___31882 = arguments.length;
var i__7652__auto___31883 = (0);
while(true){
if((i__7652__auto___31883 < len__7651__auto___31882)){
args31879.push((arguments[i__7652__auto___31883]));

var G__31884 = (i__7652__auto___31883 + (1));
i__7652__auto___31883 = G__31884;
continue;
} else {
}
break;
}

var G__31881 = args31879.length;
switch (G__31881) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31879.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7461__auto___31886 = n;
var x_31887 = (0);
while(true){
if((x_31887 < n__7461__auto___31886)){
(a[x_31887] = (0));

var G__31888 = (x_31887 + (1));
x_31887 = G__31888;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__31889 = (i + (1));
i = G__31889;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async31893 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31893 = (function (flag,meta31894){
this.flag = flag;
this.meta31894 = meta31894;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31893.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31895,meta31894__$1){
var self__ = this;
var _31895__$1 = this;
return (new cljs.core.async.t_cljs$core$async31893(self__.flag,meta31894__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31893.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31895){
var self__ = this;
var _31895__$1 = this;
return self__.meta31894;
});})(flag))
;

cljs.core.async.t_cljs$core$async31893.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31893.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async31893.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31893.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31893.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta31894], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31893.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31893.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31893";

cljs.core.async.t_cljs$core$async31893.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async31893");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31893 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31893(flag__$1,meta31894){
return (new cljs.core.async.t_cljs$core$async31893(flag__$1,meta31894));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31893(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31899 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31899 = (function (flag,cb,meta31900){
this.flag = flag;
this.cb = cb;
this.meta31900 = meta31900;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async31899.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31901,meta31900__$1){
var self__ = this;
var _31901__$1 = this;
return (new cljs.core.async.t_cljs$core$async31899(self__.flag,self__.cb,meta31900__$1));
});

cljs.core.async.t_cljs$core$async31899.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31901){
var self__ = this;
var _31901__$1 = this;
return self__.meta31900;
});

cljs.core.async.t_cljs$core$async31899.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31899.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async31899.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31899.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31899.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta31900], null);
});

cljs.core.async.t_cljs$core$async31899.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31899.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31899";

cljs.core.async.t_cljs$core$async31899.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async31899");
});

cljs.core.async.__GT_t_cljs$core$async31899 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31899(flag__$1,cb__$1,meta31900){
return (new cljs.core.async.t_cljs$core$async31899(flag__$1,cb__$1,meta31900));
});

}

return (new cljs.core.async.t_cljs$core$async31899(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31902_SHARP_){
var G__31906 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31902_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31906) : fret.call(null,G__31906));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31903_SHARP_){
var G__31907 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31903_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__31907) : fret.call(null,G__31907));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6543__auto__ = wport;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31908 = (i + (1));
i = G__31908;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6543__auto__ = ret;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6531__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31914 = arguments.length;
var i__7652__auto___31915 = (0);
while(true){
if((i__7652__auto___31915 < len__7651__auto___31914)){
args__7658__auto__.push((arguments[i__7652__auto___31915]));

var G__31916 = (i__7652__auto___31915 + (1));
i__7652__auto___31915 = G__31916;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31911){
var map__31912 = p__31911;
var map__31912__$1 = ((((!((map__31912 == null)))?((((map__31912.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31912.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31912):map__31912);
var opts = map__31912__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31909){
var G__31910 = cljs.core.first(seq31909);
var seq31909__$1 = cljs.core.next(seq31909);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31910,seq31909__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args31917 = [];
var len__7651__auto___31967 = arguments.length;
var i__7652__auto___31968 = (0);
while(true){
if((i__7652__auto___31968 < len__7651__auto___31967)){
args31917.push((arguments[i__7652__auto___31968]));

var G__31969 = (i__7652__auto___31968 + (1));
i__7652__auto___31968 = G__31969;
continue;
} else {
}
break;
}

var G__31919 = args31917.length;
switch (G__31919) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31917.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__19292__auto___31971 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___31971){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___31971){
return (function (state_31943){
var state_val_31944 = (state_31943[(1)]);
if((state_val_31944 === (7))){
var inst_31939 = (state_31943[(2)]);
var state_31943__$1 = state_31943;
var statearr_31945_31972 = state_31943__$1;
(statearr_31945_31972[(2)] = inst_31939);

(statearr_31945_31972[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31944 === (1))){
var state_31943__$1 = state_31943;
var statearr_31946_31973 = state_31943__$1;
(statearr_31946_31973[(2)] = null);

(statearr_31946_31973[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31944 === (4))){
var inst_31922 = (state_31943[(7)]);
var inst_31922__$1 = (state_31943[(2)]);
var inst_31923 = (inst_31922__$1 == null);
var state_31943__$1 = (function (){var statearr_31947 = state_31943;
(statearr_31947[(7)] = inst_31922__$1);

return statearr_31947;
})();
if(cljs.core.truth_(inst_31923)){
var statearr_31948_31974 = state_31943__$1;
(statearr_31948_31974[(1)] = (5));

} else {
var statearr_31949_31975 = state_31943__$1;
(statearr_31949_31975[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31944 === (13))){
var state_31943__$1 = state_31943;
var statearr_31950_31976 = state_31943__$1;
(statearr_31950_31976[(2)] = null);

(statearr_31950_31976[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31944 === (6))){
var inst_31922 = (state_31943[(7)]);
var state_31943__$1 = state_31943;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31943__$1,(11),to,inst_31922);
} else {
if((state_val_31944 === (3))){
var inst_31941 = (state_31943[(2)]);
var state_31943__$1 = state_31943;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31943__$1,inst_31941);
} else {
if((state_val_31944 === (12))){
var state_31943__$1 = state_31943;
var statearr_31951_31977 = state_31943__$1;
(statearr_31951_31977[(2)] = null);

(statearr_31951_31977[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31944 === (2))){
var state_31943__$1 = state_31943;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31943__$1,(4),from);
} else {
if((state_val_31944 === (11))){
var inst_31932 = (state_31943[(2)]);
var state_31943__$1 = state_31943;
if(cljs.core.truth_(inst_31932)){
var statearr_31952_31978 = state_31943__$1;
(statearr_31952_31978[(1)] = (12));

} else {
var statearr_31953_31979 = state_31943__$1;
(statearr_31953_31979[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31944 === (9))){
var state_31943__$1 = state_31943;
var statearr_31954_31980 = state_31943__$1;
(statearr_31954_31980[(2)] = null);

(statearr_31954_31980[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31944 === (5))){
var state_31943__$1 = state_31943;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31955_31981 = state_31943__$1;
(statearr_31955_31981[(1)] = (8));

} else {
var statearr_31956_31982 = state_31943__$1;
(statearr_31956_31982[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31944 === (14))){
var inst_31937 = (state_31943[(2)]);
var state_31943__$1 = state_31943;
var statearr_31957_31983 = state_31943__$1;
(statearr_31957_31983[(2)] = inst_31937);

(statearr_31957_31983[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31944 === (10))){
var inst_31929 = (state_31943[(2)]);
var state_31943__$1 = state_31943;
var statearr_31958_31984 = state_31943__$1;
(statearr_31958_31984[(2)] = inst_31929);

(statearr_31958_31984[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31944 === (8))){
var inst_31926 = cljs.core.async.close_BANG_(to);
var state_31943__$1 = state_31943;
var statearr_31959_31985 = state_31943__$1;
(statearr_31959_31985[(2)] = inst_31926);

(statearr_31959_31985[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___31971))
;
return ((function (switch__19180__auto__,c__19292__auto___31971){
return (function() {
var cljs$core$async$state_machine__19181__auto__ = null;
var cljs$core$async$state_machine__19181__auto____0 = (function (){
var statearr_31963 = [null,null,null,null,null,null,null,null];
(statearr_31963[(0)] = cljs$core$async$state_machine__19181__auto__);

(statearr_31963[(1)] = (1));

return statearr_31963;
});
var cljs$core$async$state_machine__19181__auto____1 = (function (state_31943){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_31943);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e31964){if((e31964 instanceof Object)){
var ex__19184__auto__ = e31964;
var statearr_31965_31986 = state_31943;
(statearr_31965_31986[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31943);

return cljs.core.cst$kw$recur;
} else {
throw e31964;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__31987 = state_31943;
state_31943 = G__31987;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$state_machine__19181__auto__ = function(state_31943){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19181__auto____1.call(this,state_31943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19181__auto____0;
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19181__auto____1;
return cljs$core$async$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___31971))
})();
var state__19294__auto__ = (function (){var statearr_31966 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_31966[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___31971);

return statearr_31966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___31971))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__32175){
var vec__32176 = p__32175;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32176,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32176,(1),null);
var job = vec__32176;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__19292__auto___32362 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___32362,res,vec__32176,v,p,job,jobs,results){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___32362,res,vec__32176,v,p,job,jobs,results){
return (function (state_32183){
var state_val_32184 = (state_32183[(1)]);
if((state_val_32184 === (1))){
var state_32183__$1 = state_32183;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32183__$1,(2),res,v);
} else {
if((state_val_32184 === (2))){
var inst_32180 = (state_32183[(2)]);
var inst_32181 = cljs.core.async.close_BANG_(res);
var state_32183__$1 = (function (){var statearr_32185 = state_32183;
(statearr_32185[(7)] = inst_32180);

return statearr_32185;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32183__$1,inst_32181);
} else {
return null;
}
}
});})(c__19292__auto___32362,res,vec__32176,v,p,job,jobs,results))
;
return ((function (switch__19180__auto__,c__19292__auto___32362,res,vec__32176,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0 = (function (){
var statearr_32189 = [null,null,null,null,null,null,null,null];
(statearr_32189[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__);

(statearr_32189[(1)] = (1));

return statearr_32189;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1 = (function (state_32183){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_32183);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e32190){if((e32190 instanceof Object)){
var ex__19184__auto__ = e32190;
var statearr_32191_32363 = state_32183;
(statearr_32191_32363[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32183);

return cljs.core.cst$kw$recur;
} else {
throw e32190;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__32364 = state_32183;
state_32183 = G__32364;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__ = function(state_32183){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1.call(this,state_32183);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___32362,res,vec__32176,v,p,job,jobs,results))
})();
var state__19294__auto__ = (function (){var statearr_32192 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_32192[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___32362);

return statearr_32192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___32362,res,vec__32176,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__32193){
var vec__32194 = p__32193;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32194,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32194,(1),null);
var job = vec__32194;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7461__auto___32365 = n;
var __32366 = (0);
while(true){
if((__32366 < n__7461__auto___32365)){
var G__32197_32367 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__32197_32367) {
case "compute":
var c__19292__auto___32369 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32366,c__19292__auto___32369,G__32197_32367,n__7461__auto___32365,jobs,results,process,async){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (__32366,c__19292__auto___32369,G__32197_32367,n__7461__auto___32365,jobs,results,process,async){
return (function (state_32210){
var state_val_32211 = (state_32210[(1)]);
if((state_val_32211 === (1))){
var state_32210__$1 = state_32210;
var statearr_32212_32370 = state_32210__$1;
(statearr_32212_32370[(2)] = null);

(statearr_32212_32370[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (2))){
var state_32210__$1 = state_32210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32210__$1,(4),jobs);
} else {
if((state_val_32211 === (3))){
var inst_32208 = (state_32210[(2)]);
var state_32210__$1 = state_32210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32210__$1,inst_32208);
} else {
if((state_val_32211 === (4))){
var inst_32200 = (state_32210[(2)]);
var inst_32201 = process(inst_32200);
var state_32210__$1 = state_32210;
if(cljs.core.truth_(inst_32201)){
var statearr_32213_32371 = state_32210__$1;
(statearr_32213_32371[(1)] = (5));

} else {
var statearr_32214_32372 = state_32210__$1;
(statearr_32214_32372[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (5))){
var state_32210__$1 = state_32210;
var statearr_32215_32373 = state_32210__$1;
(statearr_32215_32373[(2)] = null);

(statearr_32215_32373[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (6))){
var state_32210__$1 = state_32210;
var statearr_32216_32374 = state_32210__$1;
(statearr_32216_32374[(2)] = null);

(statearr_32216_32374[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (7))){
var inst_32206 = (state_32210[(2)]);
var state_32210__$1 = state_32210;
var statearr_32217_32375 = state_32210__$1;
(statearr_32217_32375[(2)] = inst_32206);

(statearr_32217_32375[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__32366,c__19292__auto___32369,G__32197_32367,n__7461__auto___32365,jobs,results,process,async))
;
return ((function (__32366,switch__19180__auto__,c__19292__auto___32369,G__32197_32367,n__7461__auto___32365,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0 = (function (){
var statearr_32221 = [null,null,null,null,null,null,null];
(statearr_32221[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__);

(statearr_32221[(1)] = (1));

return statearr_32221;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1 = (function (state_32210){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_32210);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e32222){if((e32222 instanceof Object)){
var ex__19184__auto__ = e32222;
var statearr_32223_32376 = state_32210;
(statearr_32223_32376[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32210);

return cljs.core.cst$kw$recur;
} else {
throw e32222;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__32377 = state_32210;
state_32210 = G__32377;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__ = function(state_32210){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1.call(this,state_32210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__;
})()
;})(__32366,switch__19180__auto__,c__19292__auto___32369,G__32197_32367,n__7461__auto___32365,jobs,results,process,async))
})();
var state__19294__auto__ = (function (){var statearr_32224 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_32224[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___32369);

return statearr_32224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(__32366,c__19292__auto___32369,G__32197_32367,n__7461__auto___32365,jobs,results,process,async))
);


break;
case "async":
var c__19292__auto___32378 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__32366,c__19292__auto___32378,G__32197_32367,n__7461__auto___32365,jobs,results,process,async){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (__32366,c__19292__auto___32378,G__32197_32367,n__7461__auto___32365,jobs,results,process,async){
return (function (state_32237){
var state_val_32238 = (state_32237[(1)]);
if((state_val_32238 === (1))){
var state_32237__$1 = state_32237;
var statearr_32239_32379 = state_32237__$1;
(statearr_32239_32379[(2)] = null);

(statearr_32239_32379[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32238 === (2))){
var state_32237__$1 = state_32237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32237__$1,(4),jobs);
} else {
if((state_val_32238 === (3))){
var inst_32235 = (state_32237[(2)]);
var state_32237__$1 = state_32237;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32237__$1,inst_32235);
} else {
if((state_val_32238 === (4))){
var inst_32227 = (state_32237[(2)]);
var inst_32228 = async(inst_32227);
var state_32237__$1 = state_32237;
if(cljs.core.truth_(inst_32228)){
var statearr_32240_32380 = state_32237__$1;
(statearr_32240_32380[(1)] = (5));

} else {
var statearr_32241_32381 = state_32237__$1;
(statearr_32241_32381[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32238 === (5))){
var state_32237__$1 = state_32237;
var statearr_32242_32382 = state_32237__$1;
(statearr_32242_32382[(2)] = null);

(statearr_32242_32382[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32238 === (6))){
var state_32237__$1 = state_32237;
var statearr_32243_32383 = state_32237__$1;
(statearr_32243_32383[(2)] = null);

(statearr_32243_32383[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32238 === (7))){
var inst_32233 = (state_32237[(2)]);
var state_32237__$1 = state_32237;
var statearr_32244_32384 = state_32237__$1;
(statearr_32244_32384[(2)] = inst_32233);

(statearr_32244_32384[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__32366,c__19292__auto___32378,G__32197_32367,n__7461__auto___32365,jobs,results,process,async))
;
return ((function (__32366,switch__19180__auto__,c__19292__auto___32378,G__32197_32367,n__7461__auto___32365,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0 = (function (){
var statearr_32248 = [null,null,null,null,null,null,null];
(statearr_32248[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__);

(statearr_32248[(1)] = (1));

return statearr_32248;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1 = (function (state_32237){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_32237);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e32249){if((e32249 instanceof Object)){
var ex__19184__auto__ = e32249;
var statearr_32250_32385 = state_32237;
(statearr_32250_32385[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32237);

return cljs.core.cst$kw$recur;
} else {
throw e32249;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__32386 = state_32237;
state_32237 = G__32386;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__ = function(state_32237){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1.call(this,state_32237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__;
})()
;})(__32366,switch__19180__auto__,c__19292__auto___32378,G__32197_32367,n__7461__auto___32365,jobs,results,process,async))
})();
var state__19294__auto__ = (function (){var statearr_32251 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_32251[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___32378);

return statearr_32251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(__32366,c__19292__auto___32378,G__32197_32367,n__7461__auto___32365,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__32387 = (__32366 + (1));
__32366 = G__32387;
continue;
} else {
}
break;
}

var c__19292__auto___32388 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___32388,jobs,results,process,async){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___32388,jobs,results,process,async){
return (function (state_32273){
var state_val_32274 = (state_32273[(1)]);
if((state_val_32274 === (1))){
var state_32273__$1 = state_32273;
var statearr_32275_32389 = state_32273__$1;
(statearr_32275_32389[(2)] = null);

(statearr_32275_32389[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32274 === (2))){
var state_32273__$1 = state_32273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32273__$1,(4),from);
} else {
if((state_val_32274 === (3))){
var inst_32271 = (state_32273[(2)]);
var state_32273__$1 = state_32273;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32273__$1,inst_32271);
} else {
if((state_val_32274 === (4))){
var inst_32254 = (state_32273[(7)]);
var inst_32254__$1 = (state_32273[(2)]);
var inst_32255 = (inst_32254__$1 == null);
var state_32273__$1 = (function (){var statearr_32276 = state_32273;
(statearr_32276[(7)] = inst_32254__$1);

return statearr_32276;
})();
if(cljs.core.truth_(inst_32255)){
var statearr_32277_32390 = state_32273__$1;
(statearr_32277_32390[(1)] = (5));

} else {
var statearr_32278_32391 = state_32273__$1;
(statearr_32278_32391[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32274 === (5))){
var inst_32257 = cljs.core.async.close_BANG_(jobs);
var state_32273__$1 = state_32273;
var statearr_32279_32392 = state_32273__$1;
(statearr_32279_32392[(2)] = inst_32257);

(statearr_32279_32392[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32274 === (6))){
var inst_32259 = (state_32273[(8)]);
var inst_32254 = (state_32273[(7)]);
var inst_32259__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_32260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32261 = [inst_32254,inst_32259__$1];
var inst_32262 = (new cljs.core.PersistentVector(null,2,(5),inst_32260,inst_32261,null));
var state_32273__$1 = (function (){var statearr_32280 = state_32273;
(statearr_32280[(8)] = inst_32259__$1);

return statearr_32280;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32273__$1,(8),jobs,inst_32262);
} else {
if((state_val_32274 === (7))){
var inst_32269 = (state_32273[(2)]);
var state_32273__$1 = state_32273;
var statearr_32281_32393 = state_32273__$1;
(statearr_32281_32393[(2)] = inst_32269);

(statearr_32281_32393[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32274 === (8))){
var inst_32259 = (state_32273[(8)]);
var inst_32264 = (state_32273[(2)]);
var state_32273__$1 = (function (){var statearr_32282 = state_32273;
(statearr_32282[(9)] = inst_32264);

return statearr_32282;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32273__$1,(9),results,inst_32259);
} else {
if((state_val_32274 === (9))){
var inst_32266 = (state_32273[(2)]);
var state_32273__$1 = (function (){var statearr_32283 = state_32273;
(statearr_32283[(10)] = inst_32266);

return statearr_32283;
})();
var statearr_32284_32394 = state_32273__$1;
(statearr_32284_32394[(2)] = null);

(statearr_32284_32394[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___32388,jobs,results,process,async))
;
return ((function (switch__19180__auto__,c__19292__auto___32388,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0 = (function (){
var statearr_32288 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32288[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__);

(statearr_32288[(1)] = (1));

return statearr_32288;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1 = (function (state_32273){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_32273);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e32289){if((e32289 instanceof Object)){
var ex__19184__auto__ = e32289;
var statearr_32290_32395 = state_32273;
(statearr_32290_32395[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32273);

return cljs.core.cst$kw$recur;
} else {
throw e32289;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__32396 = state_32273;
state_32273 = G__32396;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__ = function(state_32273){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1.call(this,state_32273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___32388,jobs,results,process,async))
})();
var state__19294__auto__ = (function (){var statearr_32291 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_32291[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___32388);

return statearr_32291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___32388,jobs,results,process,async))
);


var c__19292__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto__,jobs,results,process,async){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto__,jobs,results,process,async){
return (function (state_32329){
var state_val_32330 = (state_32329[(1)]);
if((state_val_32330 === (7))){
var inst_32325 = (state_32329[(2)]);
var state_32329__$1 = state_32329;
var statearr_32331_32397 = state_32329__$1;
(statearr_32331_32397[(2)] = inst_32325);

(statearr_32331_32397[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (20))){
var state_32329__$1 = state_32329;
var statearr_32332_32398 = state_32329__$1;
(statearr_32332_32398[(2)] = null);

(statearr_32332_32398[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (1))){
var state_32329__$1 = state_32329;
var statearr_32333_32399 = state_32329__$1;
(statearr_32333_32399[(2)] = null);

(statearr_32333_32399[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (4))){
var inst_32294 = (state_32329[(7)]);
var inst_32294__$1 = (state_32329[(2)]);
var inst_32295 = (inst_32294__$1 == null);
var state_32329__$1 = (function (){var statearr_32334 = state_32329;
(statearr_32334[(7)] = inst_32294__$1);

return statearr_32334;
})();
if(cljs.core.truth_(inst_32295)){
var statearr_32335_32400 = state_32329__$1;
(statearr_32335_32400[(1)] = (5));

} else {
var statearr_32336_32401 = state_32329__$1;
(statearr_32336_32401[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (15))){
var inst_32307 = (state_32329[(8)]);
var state_32329__$1 = state_32329;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32329__$1,(18),to,inst_32307);
} else {
if((state_val_32330 === (21))){
var inst_32320 = (state_32329[(2)]);
var state_32329__$1 = state_32329;
var statearr_32337_32402 = state_32329__$1;
(statearr_32337_32402[(2)] = inst_32320);

(statearr_32337_32402[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (13))){
var inst_32322 = (state_32329[(2)]);
var state_32329__$1 = (function (){var statearr_32338 = state_32329;
(statearr_32338[(9)] = inst_32322);

return statearr_32338;
})();
var statearr_32339_32403 = state_32329__$1;
(statearr_32339_32403[(2)] = null);

(statearr_32339_32403[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (6))){
var inst_32294 = (state_32329[(7)]);
var state_32329__$1 = state_32329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32329__$1,(11),inst_32294);
} else {
if((state_val_32330 === (17))){
var inst_32315 = (state_32329[(2)]);
var state_32329__$1 = state_32329;
if(cljs.core.truth_(inst_32315)){
var statearr_32340_32404 = state_32329__$1;
(statearr_32340_32404[(1)] = (19));

} else {
var statearr_32341_32405 = state_32329__$1;
(statearr_32341_32405[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (3))){
var inst_32327 = (state_32329[(2)]);
var state_32329__$1 = state_32329;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32329__$1,inst_32327);
} else {
if((state_val_32330 === (12))){
var inst_32304 = (state_32329[(10)]);
var state_32329__$1 = state_32329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32329__$1,(14),inst_32304);
} else {
if((state_val_32330 === (2))){
var state_32329__$1 = state_32329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32329__$1,(4),results);
} else {
if((state_val_32330 === (19))){
var state_32329__$1 = state_32329;
var statearr_32342_32406 = state_32329__$1;
(statearr_32342_32406[(2)] = null);

(statearr_32342_32406[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (11))){
var inst_32304 = (state_32329[(2)]);
var state_32329__$1 = (function (){var statearr_32343 = state_32329;
(statearr_32343[(10)] = inst_32304);

return statearr_32343;
})();
var statearr_32344_32407 = state_32329__$1;
(statearr_32344_32407[(2)] = null);

(statearr_32344_32407[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (9))){
var state_32329__$1 = state_32329;
var statearr_32345_32408 = state_32329__$1;
(statearr_32345_32408[(2)] = null);

(statearr_32345_32408[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (5))){
var state_32329__$1 = state_32329;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32346_32409 = state_32329__$1;
(statearr_32346_32409[(1)] = (8));

} else {
var statearr_32347_32410 = state_32329__$1;
(statearr_32347_32410[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (14))){
var inst_32309 = (state_32329[(11)]);
var inst_32307 = (state_32329[(8)]);
var inst_32307__$1 = (state_32329[(2)]);
var inst_32308 = (inst_32307__$1 == null);
var inst_32309__$1 = cljs.core.not(inst_32308);
var state_32329__$1 = (function (){var statearr_32348 = state_32329;
(statearr_32348[(11)] = inst_32309__$1);

(statearr_32348[(8)] = inst_32307__$1);

return statearr_32348;
})();
if(inst_32309__$1){
var statearr_32349_32411 = state_32329__$1;
(statearr_32349_32411[(1)] = (15));

} else {
var statearr_32350_32412 = state_32329__$1;
(statearr_32350_32412[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (16))){
var inst_32309 = (state_32329[(11)]);
var state_32329__$1 = state_32329;
var statearr_32351_32413 = state_32329__$1;
(statearr_32351_32413[(2)] = inst_32309);

(statearr_32351_32413[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (10))){
var inst_32301 = (state_32329[(2)]);
var state_32329__$1 = state_32329;
var statearr_32352_32414 = state_32329__$1;
(statearr_32352_32414[(2)] = inst_32301);

(statearr_32352_32414[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (18))){
var inst_32312 = (state_32329[(2)]);
var state_32329__$1 = state_32329;
var statearr_32353_32415 = state_32329__$1;
(statearr_32353_32415[(2)] = inst_32312);

(statearr_32353_32415[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32330 === (8))){
var inst_32298 = cljs.core.async.close_BANG_(to);
var state_32329__$1 = state_32329;
var statearr_32354_32416 = state_32329__$1;
(statearr_32354_32416[(2)] = inst_32298);

(statearr_32354_32416[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto__,jobs,results,process,async))
;
return ((function (switch__19180__auto__,c__19292__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0 = (function (){
var statearr_32358 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32358[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__);

(statearr_32358[(1)] = (1));

return statearr_32358;
});
var cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1 = (function (state_32329){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_32329);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e32359){if((e32359 instanceof Object)){
var ex__19184__auto__ = e32359;
var statearr_32360_32417 = state_32329;
(statearr_32360_32417[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32329);

return cljs.core.cst$kw$recur;
} else {
throw e32359;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__32418 = state_32329;
state_32329 = G__32418;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__ = function(state_32329){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1.call(this,state_32329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__19181__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto__,jobs,results,process,async))
})();
var state__19294__auto__ = (function (){var statearr_32361 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_32361[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto__);

return statearr_32361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto__,jobs,results,process,async))
);

return c__19292__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args32419 = [];
var len__7651__auto___32422 = arguments.length;
var i__7652__auto___32423 = (0);
while(true){
if((i__7652__auto___32423 < len__7651__auto___32422)){
args32419.push((arguments[i__7652__auto___32423]));

var G__32424 = (i__7652__auto___32423 + (1));
i__7652__auto___32423 = G__32424;
continue;
} else {
}
break;
}

var G__32421 = args32419.length;
switch (G__32421) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32419.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args32426 = [];
var len__7651__auto___32429 = arguments.length;
var i__7652__auto___32430 = (0);
while(true){
if((i__7652__auto___32430 < len__7651__auto___32429)){
args32426.push((arguments[i__7652__auto___32430]));

var G__32431 = (i__7652__auto___32430 + (1));
i__7652__auto___32430 = G__32431;
continue;
} else {
}
break;
}

var G__32428 = args32426.length;
switch (G__32428) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32426.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args32433 = [];
var len__7651__auto___32486 = arguments.length;
var i__7652__auto___32487 = (0);
while(true){
if((i__7652__auto___32487 < len__7651__auto___32486)){
args32433.push((arguments[i__7652__auto___32487]));

var G__32488 = (i__7652__auto___32487 + (1));
i__7652__auto___32487 = G__32488;
continue;
} else {
}
break;
}

var G__32435 = args32433.length;
switch (G__32435) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32433.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__19292__auto___32490 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___32490,tc,fc){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___32490,tc,fc){
return (function (state_32461){
var state_val_32462 = (state_32461[(1)]);
if((state_val_32462 === (7))){
var inst_32457 = (state_32461[(2)]);
var state_32461__$1 = state_32461;
var statearr_32463_32491 = state_32461__$1;
(statearr_32463_32491[(2)] = inst_32457);

(statearr_32463_32491[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (1))){
var state_32461__$1 = state_32461;
var statearr_32464_32492 = state_32461__$1;
(statearr_32464_32492[(2)] = null);

(statearr_32464_32492[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (4))){
var inst_32438 = (state_32461[(7)]);
var inst_32438__$1 = (state_32461[(2)]);
var inst_32439 = (inst_32438__$1 == null);
var state_32461__$1 = (function (){var statearr_32465 = state_32461;
(statearr_32465[(7)] = inst_32438__$1);

return statearr_32465;
})();
if(cljs.core.truth_(inst_32439)){
var statearr_32466_32493 = state_32461__$1;
(statearr_32466_32493[(1)] = (5));

} else {
var statearr_32467_32494 = state_32461__$1;
(statearr_32467_32494[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (13))){
var state_32461__$1 = state_32461;
var statearr_32468_32495 = state_32461__$1;
(statearr_32468_32495[(2)] = null);

(statearr_32468_32495[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (6))){
var inst_32438 = (state_32461[(7)]);
var inst_32444 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_32438) : p.call(null,inst_32438));
var state_32461__$1 = state_32461;
if(cljs.core.truth_(inst_32444)){
var statearr_32469_32496 = state_32461__$1;
(statearr_32469_32496[(1)] = (9));

} else {
var statearr_32470_32497 = state_32461__$1;
(statearr_32470_32497[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (3))){
var inst_32459 = (state_32461[(2)]);
var state_32461__$1 = state_32461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32461__$1,inst_32459);
} else {
if((state_val_32462 === (12))){
var state_32461__$1 = state_32461;
var statearr_32471_32498 = state_32461__$1;
(statearr_32471_32498[(2)] = null);

(statearr_32471_32498[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (2))){
var state_32461__$1 = state_32461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32461__$1,(4),ch);
} else {
if((state_val_32462 === (11))){
var inst_32438 = (state_32461[(7)]);
var inst_32448 = (state_32461[(2)]);
var state_32461__$1 = state_32461;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32461__$1,(8),inst_32448,inst_32438);
} else {
if((state_val_32462 === (9))){
var state_32461__$1 = state_32461;
var statearr_32472_32499 = state_32461__$1;
(statearr_32472_32499[(2)] = tc);

(statearr_32472_32499[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (5))){
var inst_32441 = cljs.core.async.close_BANG_(tc);
var inst_32442 = cljs.core.async.close_BANG_(fc);
var state_32461__$1 = (function (){var statearr_32473 = state_32461;
(statearr_32473[(8)] = inst_32441);

return statearr_32473;
})();
var statearr_32474_32500 = state_32461__$1;
(statearr_32474_32500[(2)] = inst_32442);

(statearr_32474_32500[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (14))){
var inst_32455 = (state_32461[(2)]);
var state_32461__$1 = state_32461;
var statearr_32475_32501 = state_32461__$1;
(statearr_32475_32501[(2)] = inst_32455);

(statearr_32475_32501[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (10))){
var state_32461__$1 = state_32461;
var statearr_32476_32502 = state_32461__$1;
(statearr_32476_32502[(2)] = fc);

(statearr_32476_32502[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32462 === (8))){
var inst_32450 = (state_32461[(2)]);
var state_32461__$1 = state_32461;
if(cljs.core.truth_(inst_32450)){
var statearr_32477_32503 = state_32461__$1;
(statearr_32477_32503[(1)] = (12));

} else {
var statearr_32478_32504 = state_32461__$1;
(statearr_32478_32504[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___32490,tc,fc))
;
return ((function (switch__19180__auto__,c__19292__auto___32490,tc,fc){
return (function() {
var cljs$core$async$state_machine__19181__auto__ = null;
var cljs$core$async$state_machine__19181__auto____0 = (function (){
var statearr_32482 = [null,null,null,null,null,null,null,null,null];
(statearr_32482[(0)] = cljs$core$async$state_machine__19181__auto__);

(statearr_32482[(1)] = (1));

return statearr_32482;
});
var cljs$core$async$state_machine__19181__auto____1 = (function (state_32461){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_32461);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e32483){if((e32483 instanceof Object)){
var ex__19184__auto__ = e32483;
var statearr_32484_32505 = state_32461;
(statearr_32484_32505[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32461);

return cljs.core.cst$kw$recur;
} else {
throw e32483;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__32506 = state_32461;
state_32461 = G__32506;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$state_machine__19181__auto__ = function(state_32461){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19181__auto____1.call(this,state_32461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19181__auto____0;
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19181__auto____1;
return cljs$core$async$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___32490,tc,fc))
})();
var state__19294__auto__ = (function (){var statearr_32485 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_32485[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___32490);

return statearr_32485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___32490,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__19292__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto__){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto__){
return (function (state_32570){
var state_val_32571 = (state_32570[(1)]);
if((state_val_32571 === (7))){
var inst_32566 = (state_32570[(2)]);
var state_32570__$1 = state_32570;
var statearr_32572_32593 = state_32570__$1;
(statearr_32572_32593[(2)] = inst_32566);

(statearr_32572_32593[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32571 === (1))){
var inst_32550 = init;
var state_32570__$1 = (function (){var statearr_32573 = state_32570;
(statearr_32573[(7)] = inst_32550);

return statearr_32573;
})();
var statearr_32574_32594 = state_32570__$1;
(statearr_32574_32594[(2)] = null);

(statearr_32574_32594[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32571 === (4))){
var inst_32553 = (state_32570[(8)]);
var inst_32553__$1 = (state_32570[(2)]);
var inst_32554 = (inst_32553__$1 == null);
var state_32570__$1 = (function (){var statearr_32575 = state_32570;
(statearr_32575[(8)] = inst_32553__$1);

return statearr_32575;
})();
if(cljs.core.truth_(inst_32554)){
var statearr_32576_32595 = state_32570__$1;
(statearr_32576_32595[(1)] = (5));

} else {
var statearr_32577_32596 = state_32570__$1;
(statearr_32577_32596[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32571 === (6))){
var inst_32557 = (state_32570[(9)]);
var inst_32550 = (state_32570[(7)]);
var inst_32553 = (state_32570[(8)]);
var inst_32557__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_32550,inst_32553) : f.call(null,inst_32550,inst_32553));
var inst_32558 = cljs.core.reduced_QMARK_(inst_32557__$1);
var state_32570__$1 = (function (){var statearr_32578 = state_32570;
(statearr_32578[(9)] = inst_32557__$1);

return statearr_32578;
})();
if(inst_32558){
var statearr_32579_32597 = state_32570__$1;
(statearr_32579_32597[(1)] = (8));

} else {
var statearr_32580_32598 = state_32570__$1;
(statearr_32580_32598[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32571 === (3))){
var inst_32568 = (state_32570[(2)]);
var state_32570__$1 = state_32570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32570__$1,inst_32568);
} else {
if((state_val_32571 === (2))){
var state_32570__$1 = state_32570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32570__$1,(4),ch);
} else {
if((state_val_32571 === (9))){
var inst_32557 = (state_32570[(9)]);
var inst_32550 = inst_32557;
var state_32570__$1 = (function (){var statearr_32581 = state_32570;
(statearr_32581[(7)] = inst_32550);

return statearr_32581;
})();
var statearr_32582_32599 = state_32570__$1;
(statearr_32582_32599[(2)] = null);

(statearr_32582_32599[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32571 === (5))){
var inst_32550 = (state_32570[(7)]);
var state_32570__$1 = state_32570;
var statearr_32583_32600 = state_32570__$1;
(statearr_32583_32600[(2)] = inst_32550);

(statearr_32583_32600[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32571 === (10))){
var inst_32564 = (state_32570[(2)]);
var state_32570__$1 = state_32570;
var statearr_32584_32601 = state_32570__$1;
(statearr_32584_32601[(2)] = inst_32564);

(statearr_32584_32601[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32571 === (8))){
var inst_32557 = (state_32570[(9)]);
var inst_32560 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_32557) : cljs.core.deref.call(null,inst_32557));
var state_32570__$1 = state_32570;
var statearr_32585_32602 = state_32570__$1;
(statearr_32585_32602[(2)] = inst_32560);

(statearr_32585_32602[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto__))
;
return ((function (switch__19180__auto__,c__19292__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__19181__auto__ = null;
var cljs$core$async$reduce_$_state_machine__19181__auto____0 = (function (){
var statearr_32589 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32589[(0)] = cljs$core$async$reduce_$_state_machine__19181__auto__);

(statearr_32589[(1)] = (1));

return statearr_32589;
});
var cljs$core$async$reduce_$_state_machine__19181__auto____1 = (function (state_32570){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_32570);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e32590){if((e32590 instanceof Object)){
var ex__19184__auto__ = e32590;
var statearr_32591_32603 = state_32570;
(statearr_32591_32603[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32570);

return cljs.core.cst$kw$recur;
} else {
throw e32590;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__32604 = state_32570;
state_32570 = G__32604;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__19181__auto__ = function(state_32570){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__19181__auto____1.call(this,state_32570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__19181__auto____0;
cljs$core$async$reduce_$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__19181__auto____1;
return cljs$core$async$reduce_$_state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto__))
})();
var state__19294__auto__ = (function (){var statearr_32592 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_32592[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto__);

return statearr_32592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto__))
);

return c__19292__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__19292__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto__,f__$1){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto__,f__$1){
return (function (state_32624){
var state_val_32625 = (state_32624[(1)]);
if((state_val_32625 === (1))){
var inst_32619 = cljs.core.async.reduce(f__$1,init,ch);
var state_32624__$1 = state_32624;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32624__$1,(2),inst_32619);
} else {
if((state_val_32625 === (2))){
var inst_32621 = (state_32624[(2)]);
var inst_32622 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_32621) : f__$1.call(null,inst_32621));
var state_32624__$1 = state_32624;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32624__$1,inst_32622);
} else {
return null;
}
}
});})(c__19292__auto__,f__$1))
;
return ((function (switch__19180__auto__,c__19292__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__19181__auto__ = null;
var cljs$core$async$transduce_$_state_machine__19181__auto____0 = (function (){
var statearr_32629 = [null,null,null,null,null,null,null];
(statearr_32629[(0)] = cljs$core$async$transduce_$_state_machine__19181__auto__);

(statearr_32629[(1)] = (1));

return statearr_32629;
});
var cljs$core$async$transduce_$_state_machine__19181__auto____1 = (function (state_32624){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_32624);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e32630){if((e32630 instanceof Object)){
var ex__19184__auto__ = e32630;
var statearr_32631_32633 = state_32624;
(statearr_32631_32633[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32624);

return cljs.core.cst$kw$recur;
} else {
throw e32630;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__32634 = state_32624;
state_32624 = G__32634;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__19181__auto__ = function(state_32624){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__19181__auto____1.call(this,state_32624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__19181__auto____0;
cljs$core$async$transduce_$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__19181__auto____1;
return cljs$core$async$transduce_$_state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto__,f__$1))
})();
var state__19294__auto__ = (function (){var statearr_32632 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_32632[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto__);

return statearr_32632;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto__,f__$1))
);

return c__19292__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args32635 = [];
var len__7651__auto___32687 = arguments.length;
var i__7652__auto___32688 = (0);
while(true){
if((i__7652__auto___32688 < len__7651__auto___32687)){
args32635.push((arguments[i__7652__auto___32688]));

var G__32689 = (i__7652__auto___32688 + (1));
i__7652__auto___32688 = G__32689;
continue;
} else {
}
break;
}

var G__32637 = args32635.length;
switch (G__32637) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args32635.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__19292__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto__){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto__){
return (function (state_32662){
var state_val_32663 = (state_32662[(1)]);
if((state_val_32663 === (7))){
var inst_32644 = (state_32662[(2)]);
var state_32662__$1 = state_32662;
var statearr_32664_32691 = state_32662__$1;
(statearr_32664_32691[(2)] = inst_32644);

(statearr_32664_32691[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32663 === (1))){
var inst_32638 = cljs.core.seq(coll);
var inst_32639 = inst_32638;
var state_32662__$1 = (function (){var statearr_32665 = state_32662;
(statearr_32665[(7)] = inst_32639);

return statearr_32665;
})();
var statearr_32666_32692 = state_32662__$1;
(statearr_32666_32692[(2)] = null);

(statearr_32666_32692[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32663 === (4))){
var inst_32639 = (state_32662[(7)]);
var inst_32642 = cljs.core.first(inst_32639);
var state_32662__$1 = state_32662;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32662__$1,(7),ch,inst_32642);
} else {
if((state_val_32663 === (13))){
var inst_32656 = (state_32662[(2)]);
var state_32662__$1 = state_32662;
var statearr_32667_32693 = state_32662__$1;
(statearr_32667_32693[(2)] = inst_32656);

(statearr_32667_32693[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32663 === (6))){
var inst_32647 = (state_32662[(2)]);
var state_32662__$1 = state_32662;
if(cljs.core.truth_(inst_32647)){
var statearr_32668_32694 = state_32662__$1;
(statearr_32668_32694[(1)] = (8));

} else {
var statearr_32669_32695 = state_32662__$1;
(statearr_32669_32695[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32663 === (3))){
var inst_32660 = (state_32662[(2)]);
var state_32662__$1 = state_32662;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32662__$1,inst_32660);
} else {
if((state_val_32663 === (12))){
var state_32662__$1 = state_32662;
var statearr_32670_32696 = state_32662__$1;
(statearr_32670_32696[(2)] = null);

(statearr_32670_32696[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32663 === (2))){
var inst_32639 = (state_32662[(7)]);
var state_32662__$1 = state_32662;
if(cljs.core.truth_(inst_32639)){
var statearr_32671_32697 = state_32662__$1;
(statearr_32671_32697[(1)] = (4));

} else {
var statearr_32672_32698 = state_32662__$1;
(statearr_32672_32698[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32663 === (11))){
var inst_32653 = cljs.core.async.close_BANG_(ch);
var state_32662__$1 = state_32662;
var statearr_32673_32699 = state_32662__$1;
(statearr_32673_32699[(2)] = inst_32653);

(statearr_32673_32699[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32663 === (9))){
var state_32662__$1 = state_32662;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32674_32700 = state_32662__$1;
(statearr_32674_32700[(1)] = (11));

} else {
var statearr_32675_32701 = state_32662__$1;
(statearr_32675_32701[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32663 === (5))){
var inst_32639 = (state_32662[(7)]);
var state_32662__$1 = state_32662;
var statearr_32676_32702 = state_32662__$1;
(statearr_32676_32702[(2)] = inst_32639);

(statearr_32676_32702[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32663 === (10))){
var inst_32658 = (state_32662[(2)]);
var state_32662__$1 = state_32662;
var statearr_32677_32703 = state_32662__$1;
(statearr_32677_32703[(2)] = inst_32658);

(statearr_32677_32703[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32663 === (8))){
var inst_32639 = (state_32662[(7)]);
var inst_32649 = cljs.core.next(inst_32639);
var inst_32639__$1 = inst_32649;
var state_32662__$1 = (function (){var statearr_32678 = state_32662;
(statearr_32678[(7)] = inst_32639__$1);

return statearr_32678;
})();
var statearr_32679_32704 = state_32662__$1;
(statearr_32679_32704[(2)] = null);

(statearr_32679_32704[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto__))
;
return ((function (switch__19180__auto__,c__19292__auto__){
return (function() {
var cljs$core$async$state_machine__19181__auto__ = null;
var cljs$core$async$state_machine__19181__auto____0 = (function (){
var statearr_32683 = [null,null,null,null,null,null,null,null];
(statearr_32683[(0)] = cljs$core$async$state_machine__19181__auto__);

(statearr_32683[(1)] = (1));

return statearr_32683;
});
var cljs$core$async$state_machine__19181__auto____1 = (function (state_32662){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_32662);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e32684){if((e32684 instanceof Object)){
var ex__19184__auto__ = e32684;
var statearr_32685_32705 = state_32662;
(statearr_32685_32705[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32662);

return cljs.core.cst$kw$recur;
} else {
throw e32684;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__32706 = state_32662;
state_32662 = G__32706;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$state_machine__19181__auto__ = function(state_32662){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19181__auto____1.call(this,state_32662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19181__auto____0;
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19181__auto____1;
return cljs$core$async$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto__))
})();
var state__19294__auto__ = (function (){var statearr_32686 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_32686[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto__);

return statearr_32686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto__))
);

return c__19292__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7206__auto__ = (((_ == null))?null:_);
var m__7207__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7207__auto__.call(null,_));
} else {
var m__7207__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7207__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7207__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7207__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto__.call(null,m));
} else {
var m__7207__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__32935 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__32935) : cljs.core.atom.call(null,G__32935));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32936 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32936 = (function (ch,cs,meta32937){
this.ch = ch;
this.cs = cs;
this.meta32937 = meta32937;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async32936.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32938,meta32937__$1){
var self__ = this;
var _32938__$1 = this;
return (new cljs.core.async.t_cljs$core$async32936(self__.ch,self__.cs,meta32937__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async32936.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32938){
var self__ = this;
var _32938__$1 = this;
return self__.meta32937;
});})(cs))
;

cljs.core.async.t_cljs$core$async32936.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32936.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async32936.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32936.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32936.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32936.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__32939_33163 = self__.cs;
var G__32940_33164 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__32939_33163,G__32940_33164) : cljs.core.reset_BANG_.call(null,G__32939_33163,G__32940_33164));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32936.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta32937], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async32936.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32936.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32936";

cljs.core.async.t_cljs$core$async32936.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async32936");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async32936 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async32936(ch__$1,cs__$1,meta32937){
return (new cljs.core.async.t_cljs$core$async32936(ch__$1,cs__$1,meta32937));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async32936(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__19292__auto___33165 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___33165,cs,m,dchan,dctr,done){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___33165,cs,m,dchan,dctr,done){
return (function (state_33075){
var state_val_33076 = (state_33075[(1)]);
if((state_val_33076 === (7))){
var inst_33071 = (state_33075[(2)]);
var state_33075__$1 = state_33075;
var statearr_33077_33166 = state_33075__$1;
(statearr_33077_33166[(2)] = inst_33071);

(statearr_33077_33166[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (20))){
var inst_32974 = (state_33075[(7)]);
var inst_32986 = cljs.core.first(inst_32974);
var inst_32987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32986,(0),null);
var inst_32988 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32986,(1),null);
var state_33075__$1 = (function (){var statearr_33078 = state_33075;
(statearr_33078[(8)] = inst_32987);

return statearr_33078;
})();
if(cljs.core.truth_(inst_32988)){
var statearr_33079_33167 = state_33075__$1;
(statearr_33079_33167[(1)] = (22));

} else {
var statearr_33080_33168 = state_33075__$1;
(statearr_33080_33168[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (27))){
var inst_32943 = (state_33075[(9)]);
var inst_33016 = (state_33075[(10)]);
var inst_33018 = (state_33075[(11)]);
var inst_33023 = (state_33075[(12)]);
var inst_33023__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33016,inst_33018);
var inst_33024 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33023__$1,inst_32943,done);
var state_33075__$1 = (function (){var statearr_33081 = state_33075;
(statearr_33081[(12)] = inst_33023__$1);

return statearr_33081;
})();
if(cljs.core.truth_(inst_33024)){
var statearr_33082_33169 = state_33075__$1;
(statearr_33082_33169[(1)] = (30));

} else {
var statearr_33083_33170 = state_33075__$1;
(statearr_33083_33170[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (1))){
var state_33075__$1 = state_33075;
var statearr_33084_33171 = state_33075__$1;
(statearr_33084_33171[(2)] = null);

(statearr_33084_33171[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (24))){
var inst_32974 = (state_33075[(7)]);
var inst_32993 = (state_33075[(2)]);
var inst_32994 = cljs.core.next(inst_32974);
var inst_32952 = inst_32994;
var inst_32953 = null;
var inst_32954 = (0);
var inst_32955 = (0);
var state_33075__$1 = (function (){var statearr_33085 = state_33075;
(statearr_33085[(13)] = inst_32953);

(statearr_33085[(14)] = inst_32993);

(statearr_33085[(15)] = inst_32954);

(statearr_33085[(16)] = inst_32952);

(statearr_33085[(17)] = inst_32955);

return statearr_33085;
})();
var statearr_33086_33172 = state_33075__$1;
(statearr_33086_33172[(2)] = null);

(statearr_33086_33172[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (39))){
var state_33075__$1 = state_33075;
var statearr_33090_33173 = state_33075__$1;
(statearr_33090_33173[(2)] = null);

(statearr_33090_33173[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (4))){
var inst_32943 = (state_33075[(9)]);
var inst_32943__$1 = (state_33075[(2)]);
var inst_32944 = (inst_32943__$1 == null);
var state_33075__$1 = (function (){var statearr_33091 = state_33075;
(statearr_33091[(9)] = inst_32943__$1);

return statearr_33091;
})();
if(cljs.core.truth_(inst_32944)){
var statearr_33092_33174 = state_33075__$1;
(statearr_33092_33174[(1)] = (5));

} else {
var statearr_33093_33175 = state_33075__$1;
(statearr_33093_33175[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (15))){
var inst_32953 = (state_33075[(13)]);
var inst_32954 = (state_33075[(15)]);
var inst_32952 = (state_33075[(16)]);
var inst_32955 = (state_33075[(17)]);
var inst_32970 = (state_33075[(2)]);
var inst_32971 = (inst_32955 + (1));
var tmp33087 = inst_32953;
var tmp33088 = inst_32954;
var tmp33089 = inst_32952;
var inst_32952__$1 = tmp33089;
var inst_32953__$1 = tmp33087;
var inst_32954__$1 = tmp33088;
var inst_32955__$1 = inst_32971;
var state_33075__$1 = (function (){var statearr_33094 = state_33075;
(statearr_33094[(18)] = inst_32970);

(statearr_33094[(13)] = inst_32953__$1);

(statearr_33094[(15)] = inst_32954__$1);

(statearr_33094[(16)] = inst_32952__$1);

(statearr_33094[(17)] = inst_32955__$1);

return statearr_33094;
})();
var statearr_33095_33176 = state_33075__$1;
(statearr_33095_33176[(2)] = null);

(statearr_33095_33176[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (21))){
var inst_32997 = (state_33075[(2)]);
var state_33075__$1 = state_33075;
var statearr_33099_33177 = state_33075__$1;
(statearr_33099_33177[(2)] = inst_32997);

(statearr_33099_33177[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (31))){
var inst_33023 = (state_33075[(12)]);
var inst_33027 = done(null);
var inst_33028 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_33023);
var state_33075__$1 = (function (){var statearr_33100 = state_33075;
(statearr_33100[(19)] = inst_33027);

return statearr_33100;
})();
var statearr_33101_33178 = state_33075__$1;
(statearr_33101_33178[(2)] = inst_33028);

(statearr_33101_33178[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (32))){
var inst_33015 = (state_33075[(20)]);
var inst_33016 = (state_33075[(10)]);
var inst_33018 = (state_33075[(11)]);
var inst_33017 = (state_33075[(21)]);
var inst_33030 = (state_33075[(2)]);
var inst_33031 = (inst_33018 + (1));
var tmp33096 = inst_33015;
var tmp33097 = inst_33016;
var tmp33098 = inst_33017;
var inst_33015__$1 = tmp33096;
var inst_33016__$1 = tmp33097;
var inst_33017__$1 = tmp33098;
var inst_33018__$1 = inst_33031;
var state_33075__$1 = (function (){var statearr_33102 = state_33075;
(statearr_33102[(20)] = inst_33015__$1);

(statearr_33102[(10)] = inst_33016__$1);

(statearr_33102[(11)] = inst_33018__$1);

(statearr_33102[(21)] = inst_33017__$1);

(statearr_33102[(22)] = inst_33030);

return statearr_33102;
})();
var statearr_33103_33179 = state_33075__$1;
(statearr_33103_33179[(2)] = null);

(statearr_33103_33179[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (40))){
var inst_33043 = (state_33075[(23)]);
var inst_33047 = done(null);
var inst_33048 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_33043);
var state_33075__$1 = (function (){var statearr_33104 = state_33075;
(statearr_33104[(24)] = inst_33047);

return statearr_33104;
})();
var statearr_33105_33180 = state_33075__$1;
(statearr_33105_33180[(2)] = inst_33048);

(statearr_33105_33180[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (33))){
var inst_33034 = (state_33075[(25)]);
var inst_33036 = cljs.core.chunked_seq_QMARK_(inst_33034);
var state_33075__$1 = state_33075;
if(inst_33036){
var statearr_33106_33181 = state_33075__$1;
(statearr_33106_33181[(1)] = (36));

} else {
var statearr_33107_33182 = state_33075__$1;
(statearr_33107_33182[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (13))){
var inst_32964 = (state_33075[(26)]);
var inst_32967 = cljs.core.async.close_BANG_(inst_32964);
var state_33075__$1 = state_33075;
var statearr_33108_33183 = state_33075__$1;
(statearr_33108_33183[(2)] = inst_32967);

(statearr_33108_33183[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (22))){
var inst_32987 = (state_33075[(8)]);
var inst_32990 = cljs.core.async.close_BANG_(inst_32987);
var state_33075__$1 = state_33075;
var statearr_33109_33184 = state_33075__$1;
(statearr_33109_33184[(2)] = inst_32990);

(statearr_33109_33184[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (36))){
var inst_33034 = (state_33075[(25)]);
var inst_33038 = cljs.core.chunk_first(inst_33034);
var inst_33039 = cljs.core.chunk_rest(inst_33034);
var inst_33040 = cljs.core.count(inst_33038);
var inst_33015 = inst_33039;
var inst_33016 = inst_33038;
var inst_33017 = inst_33040;
var inst_33018 = (0);
var state_33075__$1 = (function (){var statearr_33110 = state_33075;
(statearr_33110[(20)] = inst_33015);

(statearr_33110[(10)] = inst_33016);

(statearr_33110[(11)] = inst_33018);

(statearr_33110[(21)] = inst_33017);

return statearr_33110;
})();
var statearr_33111_33185 = state_33075__$1;
(statearr_33111_33185[(2)] = null);

(statearr_33111_33185[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (41))){
var inst_33034 = (state_33075[(25)]);
var inst_33050 = (state_33075[(2)]);
var inst_33051 = cljs.core.next(inst_33034);
var inst_33015 = inst_33051;
var inst_33016 = null;
var inst_33017 = (0);
var inst_33018 = (0);
var state_33075__$1 = (function (){var statearr_33112 = state_33075;
(statearr_33112[(20)] = inst_33015);

(statearr_33112[(27)] = inst_33050);

(statearr_33112[(10)] = inst_33016);

(statearr_33112[(11)] = inst_33018);

(statearr_33112[(21)] = inst_33017);

return statearr_33112;
})();
var statearr_33113_33186 = state_33075__$1;
(statearr_33113_33186[(2)] = null);

(statearr_33113_33186[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (43))){
var state_33075__$1 = state_33075;
var statearr_33114_33187 = state_33075__$1;
(statearr_33114_33187[(2)] = null);

(statearr_33114_33187[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (29))){
var inst_33059 = (state_33075[(2)]);
var state_33075__$1 = state_33075;
var statearr_33115_33188 = state_33075__$1;
(statearr_33115_33188[(2)] = inst_33059);

(statearr_33115_33188[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (44))){
var inst_33068 = (state_33075[(2)]);
var state_33075__$1 = (function (){var statearr_33116 = state_33075;
(statearr_33116[(28)] = inst_33068);

return statearr_33116;
})();
var statearr_33117_33189 = state_33075__$1;
(statearr_33117_33189[(2)] = null);

(statearr_33117_33189[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (6))){
var inst_33007 = (state_33075[(29)]);
var inst_33006 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_33007__$1 = cljs.core.keys(inst_33006);
var inst_33008 = cljs.core.count(inst_33007__$1);
var inst_33009 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_33008) : cljs.core.reset_BANG_.call(null,dctr,inst_33008));
var inst_33014 = cljs.core.seq(inst_33007__$1);
var inst_33015 = inst_33014;
var inst_33016 = null;
var inst_33017 = (0);
var inst_33018 = (0);
var state_33075__$1 = (function (){var statearr_33118 = state_33075;
(statearr_33118[(20)] = inst_33015);

(statearr_33118[(30)] = inst_33009);

(statearr_33118[(10)] = inst_33016);

(statearr_33118[(11)] = inst_33018);

(statearr_33118[(21)] = inst_33017);

(statearr_33118[(29)] = inst_33007__$1);

return statearr_33118;
})();
var statearr_33119_33190 = state_33075__$1;
(statearr_33119_33190[(2)] = null);

(statearr_33119_33190[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (28))){
var inst_33015 = (state_33075[(20)]);
var inst_33034 = (state_33075[(25)]);
var inst_33034__$1 = cljs.core.seq(inst_33015);
var state_33075__$1 = (function (){var statearr_33120 = state_33075;
(statearr_33120[(25)] = inst_33034__$1);

return statearr_33120;
})();
if(inst_33034__$1){
var statearr_33121_33191 = state_33075__$1;
(statearr_33121_33191[(1)] = (33));

} else {
var statearr_33122_33192 = state_33075__$1;
(statearr_33122_33192[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (25))){
var inst_33018 = (state_33075[(11)]);
var inst_33017 = (state_33075[(21)]);
var inst_33020 = (inst_33018 < inst_33017);
var inst_33021 = inst_33020;
var state_33075__$1 = state_33075;
if(cljs.core.truth_(inst_33021)){
var statearr_33123_33193 = state_33075__$1;
(statearr_33123_33193[(1)] = (27));

} else {
var statearr_33124_33194 = state_33075__$1;
(statearr_33124_33194[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (34))){
var state_33075__$1 = state_33075;
var statearr_33125_33195 = state_33075__$1;
(statearr_33125_33195[(2)] = null);

(statearr_33125_33195[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (17))){
var state_33075__$1 = state_33075;
var statearr_33126_33196 = state_33075__$1;
(statearr_33126_33196[(2)] = null);

(statearr_33126_33196[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (3))){
var inst_33073 = (state_33075[(2)]);
var state_33075__$1 = state_33075;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33075__$1,inst_33073);
} else {
if((state_val_33076 === (12))){
var inst_33002 = (state_33075[(2)]);
var state_33075__$1 = state_33075;
var statearr_33127_33197 = state_33075__$1;
(statearr_33127_33197[(2)] = inst_33002);

(statearr_33127_33197[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (2))){
var state_33075__$1 = state_33075;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33075__$1,(4),ch);
} else {
if((state_val_33076 === (23))){
var state_33075__$1 = state_33075;
var statearr_33128_33198 = state_33075__$1;
(statearr_33128_33198[(2)] = null);

(statearr_33128_33198[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (35))){
var inst_33057 = (state_33075[(2)]);
var state_33075__$1 = state_33075;
var statearr_33129_33199 = state_33075__$1;
(statearr_33129_33199[(2)] = inst_33057);

(statearr_33129_33199[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (19))){
var inst_32974 = (state_33075[(7)]);
var inst_32978 = cljs.core.chunk_first(inst_32974);
var inst_32979 = cljs.core.chunk_rest(inst_32974);
var inst_32980 = cljs.core.count(inst_32978);
var inst_32952 = inst_32979;
var inst_32953 = inst_32978;
var inst_32954 = inst_32980;
var inst_32955 = (0);
var state_33075__$1 = (function (){var statearr_33130 = state_33075;
(statearr_33130[(13)] = inst_32953);

(statearr_33130[(15)] = inst_32954);

(statearr_33130[(16)] = inst_32952);

(statearr_33130[(17)] = inst_32955);

return statearr_33130;
})();
var statearr_33131_33200 = state_33075__$1;
(statearr_33131_33200[(2)] = null);

(statearr_33131_33200[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (11))){
var inst_32952 = (state_33075[(16)]);
var inst_32974 = (state_33075[(7)]);
var inst_32974__$1 = cljs.core.seq(inst_32952);
var state_33075__$1 = (function (){var statearr_33132 = state_33075;
(statearr_33132[(7)] = inst_32974__$1);

return statearr_33132;
})();
if(inst_32974__$1){
var statearr_33133_33201 = state_33075__$1;
(statearr_33133_33201[(1)] = (16));

} else {
var statearr_33134_33202 = state_33075__$1;
(statearr_33134_33202[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (9))){
var inst_33004 = (state_33075[(2)]);
var state_33075__$1 = state_33075;
var statearr_33135_33203 = state_33075__$1;
(statearr_33135_33203[(2)] = inst_33004);

(statearr_33135_33203[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (5))){
var inst_32950 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_32951 = cljs.core.seq(inst_32950);
var inst_32952 = inst_32951;
var inst_32953 = null;
var inst_32954 = (0);
var inst_32955 = (0);
var state_33075__$1 = (function (){var statearr_33136 = state_33075;
(statearr_33136[(13)] = inst_32953);

(statearr_33136[(15)] = inst_32954);

(statearr_33136[(16)] = inst_32952);

(statearr_33136[(17)] = inst_32955);

return statearr_33136;
})();
var statearr_33137_33204 = state_33075__$1;
(statearr_33137_33204[(2)] = null);

(statearr_33137_33204[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (14))){
var state_33075__$1 = state_33075;
var statearr_33138_33205 = state_33075__$1;
(statearr_33138_33205[(2)] = null);

(statearr_33138_33205[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (45))){
var inst_33065 = (state_33075[(2)]);
var state_33075__$1 = state_33075;
var statearr_33139_33206 = state_33075__$1;
(statearr_33139_33206[(2)] = inst_33065);

(statearr_33139_33206[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (26))){
var inst_33007 = (state_33075[(29)]);
var inst_33061 = (state_33075[(2)]);
var inst_33062 = cljs.core.seq(inst_33007);
var state_33075__$1 = (function (){var statearr_33140 = state_33075;
(statearr_33140[(31)] = inst_33061);

return statearr_33140;
})();
if(inst_33062){
var statearr_33141_33207 = state_33075__$1;
(statearr_33141_33207[(1)] = (42));

} else {
var statearr_33142_33208 = state_33075__$1;
(statearr_33142_33208[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (16))){
var inst_32974 = (state_33075[(7)]);
var inst_32976 = cljs.core.chunked_seq_QMARK_(inst_32974);
var state_33075__$1 = state_33075;
if(inst_32976){
var statearr_33143_33209 = state_33075__$1;
(statearr_33143_33209[(1)] = (19));

} else {
var statearr_33144_33210 = state_33075__$1;
(statearr_33144_33210[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (38))){
var inst_33054 = (state_33075[(2)]);
var state_33075__$1 = state_33075;
var statearr_33145_33211 = state_33075__$1;
(statearr_33145_33211[(2)] = inst_33054);

(statearr_33145_33211[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (30))){
var state_33075__$1 = state_33075;
var statearr_33146_33212 = state_33075__$1;
(statearr_33146_33212[(2)] = null);

(statearr_33146_33212[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (10))){
var inst_32953 = (state_33075[(13)]);
var inst_32955 = (state_33075[(17)]);
var inst_32963 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_32953,inst_32955);
var inst_32964 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32963,(0),null);
var inst_32965 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32963,(1),null);
var state_33075__$1 = (function (){var statearr_33147 = state_33075;
(statearr_33147[(26)] = inst_32964);

return statearr_33147;
})();
if(cljs.core.truth_(inst_32965)){
var statearr_33148_33213 = state_33075__$1;
(statearr_33148_33213[(1)] = (13));

} else {
var statearr_33149_33214 = state_33075__$1;
(statearr_33149_33214[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (18))){
var inst_33000 = (state_33075[(2)]);
var state_33075__$1 = state_33075;
var statearr_33150_33215 = state_33075__$1;
(statearr_33150_33215[(2)] = inst_33000);

(statearr_33150_33215[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (42))){
var state_33075__$1 = state_33075;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33075__$1,(45),dchan);
} else {
if((state_val_33076 === (37))){
var inst_32943 = (state_33075[(9)]);
var inst_33043 = (state_33075[(23)]);
var inst_33034 = (state_33075[(25)]);
var inst_33043__$1 = cljs.core.first(inst_33034);
var inst_33044 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_33043__$1,inst_32943,done);
var state_33075__$1 = (function (){var statearr_33151 = state_33075;
(statearr_33151[(23)] = inst_33043__$1);

return statearr_33151;
})();
if(cljs.core.truth_(inst_33044)){
var statearr_33152_33216 = state_33075__$1;
(statearr_33152_33216[(1)] = (39));

} else {
var statearr_33153_33217 = state_33075__$1;
(statearr_33153_33217[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33076 === (8))){
var inst_32954 = (state_33075[(15)]);
var inst_32955 = (state_33075[(17)]);
var inst_32957 = (inst_32955 < inst_32954);
var inst_32958 = inst_32957;
var state_33075__$1 = state_33075;
if(cljs.core.truth_(inst_32958)){
var statearr_33154_33218 = state_33075__$1;
(statearr_33154_33218[(1)] = (10));

} else {
var statearr_33155_33219 = state_33075__$1;
(statearr_33155_33219[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___33165,cs,m,dchan,dctr,done))
;
return ((function (switch__19180__auto__,c__19292__auto___33165,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__19181__auto__ = null;
var cljs$core$async$mult_$_state_machine__19181__auto____0 = (function (){
var statearr_33159 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33159[(0)] = cljs$core$async$mult_$_state_machine__19181__auto__);

(statearr_33159[(1)] = (1));

return statearr_33159;
});
var cljs$core$async$mult_$_state_machine__19181__auto____1 = (function (state_33075){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_33075);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e33160){if((e33160 instanceof Object)){
var ex__19184__auto__ = e33160;
var statearr_33161_33220 = state_33075;
(statearr_33161_33220[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33075);

return cljs.core.cst$kw$recur;
} else {
throw e33160;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__33221 = state_33075;
state_33075 = G__33221;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__19181__auto__ = function(state_33075){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__19181__auto____1.call(this,state_33075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__19181__auto____0;
cljs$core$async$mult_$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__19181__auto____1;
return cljs$core$async$mult_$_state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___33165,cs,m,dchan,dctr,done))
})();
var state__19294__auto__ = (function (){var statearr_33162 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_33162[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___33165);

return statearr_33162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___33165,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args33222 = [];
var len__7651__auto___33225 = arguments.length;
var i__7652__auto___33226 = (0);
while(true){
if((i__7652__auto___33226 < len__7651__auto___33225)){
args33222.push((arguments[i__7652__auto___33226]));

var G__33227 = (i__7652__auto___33226 + (1));
i__7652__auto___33226 = G__33227;
continue;
} else {
}
break;
}

var G__33224 = args33222.length;
switch (G__33224) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33222.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto__.call(null,m,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7207__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto__.call(null,m));
} else {
var m__7207__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7207__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7207__auto__.call(null,m,state_map));
} else {
var m__7207__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7207__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7206__auto__ = (((m == null))?null:m);
var m__7207__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7207__auto__.call(null,m,mode));
} else {
var m__7207__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7207__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___33239 = arguments.length;
var i__7652__auto___33240 = (0);
while(true){
if((i__7652__auto___33240 < len__7651__auto___33239)){
args__7658__auto__.push((arguments[i__7652__auto___33240]));

var G__33241 = (i__7652__auto___33240 + (1));
i__7652__auto___33240 = G__33241;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__33233){
var map__33234 = p__33233;
var map__33234__$1 = ((((!((map__33234 == null)))?((((map__33234.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33234.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33234):map__33234);
var opts = map__33234__$1;
var statearr_33236_33242 = state;
(statearr_33236_33242[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__33234,map__33234__$1,opts){
return (function (val){
var statearr_33237_33243 = state;
(statearr_33237_33243[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__33234,map__33234__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_33238_33244 = state;
(statearr_33238_33244[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq33229){
var G__33230 = cljs.core.first(seq33229);
var seq33229__$1 = cljs.core.next(seq33229);
var G__33231 = cljs.core.first(seq33229__$1);
var seq33229__$2 = cljs.core.next(seq33229__$1);
var G__33232 = cljs.core.first(seq33229__$2);
var seq33229__$3 = cljs.core.next(seq33229__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__33230,G__33231,G__33232,seq33229__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__33416 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33416) : cljs.core.atom.call(null,G__33416));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__33417 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33417) : cljs.core.atom.call(null,G__33417));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async33418 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33418 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta33419){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta33419 = meta33419;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33418.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33420,meta33419__$1){
var self__ = this;
var _33420__$1 = this;
return (new cljs.core.async.t_cljs$core$async33418(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta33419__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33418.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_33420){
var self__ = this;
var _33420__$1 = this;
return self__.meta33419;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33418.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33418.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33418.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33418.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33418.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33418.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__33421_33587 = self__.cs;
var G__33422_33588 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__33421_33587,G__33422_33588) : cljs.core.reset_BANG_.call(null,G__33421_33587,G__33422_33588));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33418.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33418.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33418.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta33419], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async33418.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33418.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33418";

cljs.core.async.t_cljs$core$async33418.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33418");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async33418 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async33418(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33419){
return (new cljs.core.async.t_cljs$core$async33418(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta33419));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async33418(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19292__auto___33589 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___33589,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___33589,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_33524){
var state_val_33525 = (state_33524[(1)]);
if((state_val_33525 === (7))){
var inst_33439 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
var statearr_33526_33590 = state_33524__$1;
(statearr_33526_33590[(2)] = inst_33439);

(statearr_33526_33590[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (20))){
var inst_33451 = (state_33524[(7)]);
var state_33524__$1 = state_33524;
var statearr_33527_33591 = state_33524__$1;
(statearr_33527_33591[(2)] = inst_33451);

(statearr_33527_33591[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (27))){
var state_33524__$1 = state_33524;
var statearr_33528_33592 = state_33524__$1;
(statearr_33528_33592[(2)] = null);

(statearr_33528_33592[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (1))){
var inst_33426 = (state_33524[(8)]);
var inst_33426__$1 = calc_state();
var inst_33428 = (inst_33426__$1 == null);
var inst_33429 = cljs.core.not(inst_33428);
var state_33524__$1 = (function (){var statearr_33529 = state_33524;
(statearr_33529[(8)] = inst_33426__$1);

return statearr_33529;
})();
if(inst_33429){
var statearr_33530_33593 = state_33524__$1;
(statearr_33530_33593[(1)] = (2));

} else {
var statearr_33531_33594 = state_33524__$1;
(statearr_33531_33594[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (24))){
var inst_33475 = (state_33524[(9)]);
var inst_33498 = (state_33524[(10)]);
var inst_33484 = (state_33524[(11)]);
var inst_33498__$1 = (inst_33475.cljs$core$IFn$_invoke$arity$1 ? inst_33475.cljs$core$IFn$_invoke$arity$1(inst_33484) : inst_33475.call(null,inst_33484));
var state_33524__$1 = (function (){var statearr_33532 = state_33524;
(statearr_33532[(10)] = inst_33498__$1);

return statearr_33532;
})();
if(cljs.core.truth_(inst_33498__$1)){
var statearr_33533_33595 = state_33524__$1;
(statearr_33533_33595[(1)] = (29));

} else {
var statearr_33534_33596 = state_33524__$1;
(statearr_33534_33596[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (4))){
var inst_33442 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
if(cljs.core.truth_(inst_33442)){
var statearr_33535_33597 = state_33524__$1;
(statearr_33535_33597[(1)] = (8));

} else {
var statearr_33536_33598 = state_33524__$1;
(statearr_33536_33598[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (15))){
var inst_33469 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
if(cljs.core.truth_(inst_33469)){
var statearr_33537_33599 = state_33524__$1;
(statearr_33537_33599[(1)] = (19));

} else {
var statearr_33538_33600 = state_33524__$1;
(statearr_33538_33600[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (21))){
var inst_33474 = (state_33524[(12)]);
var inst_33474__$1 = (state_33524[(2)]);
var inst_33475 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33474__$1,cljs.core.cst$kw$solos);
var inst_33476 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33474__$1,cljs.core.cst$kw$mutes);
var inst_33477 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33474__$1,cljs.core.cst$kw$reads);
var state_33524__$1 = (function (){var statearr_33539 = state_33524;
(statearr_33539[(12)] = inst_33474__$1);

(statearr_33539[(9)] = inst_33475);

(statearr_33539[(13)] = inst_33476);

return statearr_33539;
})();
return cljs.core.async.ioc_alts_BANG_(state_33524__$1,(22),inst_33477);
} else {
if((state_val_33525 === (31))){
var inst_33506 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
if(cljs.core.truth_(inst_33506)){
var statearr_33540_33601 = state_33524__$1;
(statearr_33540_33601[(1)] = (32));

} else {
var statearr_33541_33602 = state_33524__$1;
(statearr_33541_33602[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (32))){
var inst_33483 = (state_33524[(14)]);
var state_33524__$1 = state_33524;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33524__$1,(35),out,inst_33483);
} else {
if((state_val_33525 === (33))){
var inst_33474 = (state_33524[(12)]);
var inst_33451 = inst_33474;
var state_33524__$1 = (function (){var statearr_33542 = state_33524;
(statearr_33542[(7)] = inst_33451);

return statearr_33542;
})();
var statearr_33543_33603 = state_33524__$1;
(statearr_33543_33603[(2)] = null);

(statearr_33543_33603[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (13))){
var inst_33451 = (state_33524[(7)]);
var inst_33458 = inst_33451.cljs$lang$protocol_mask$partition0$;
var inst_33459 = (inst_33458 & (64));
var inst_33460 = inst_33451.cljs$core$ISeq$;
var inst_33461 = (cljs.core.PROTOCOL_SENTINEL === inst_33460);
var inst_33462 = (inst_33459) || (inst_33461);
var state_33524__$1 = state_33524;
if(cljs.core.truth_(inst_33462)){
var statearr_33544_33604 = state_33524__$1;
(statearr_33544_33604[(1)] = (16));

} else {
var statearr_33545_33605 = state_33524__$1;
(statearr_33545_33605[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (22))){
var inst_33483 = (state_33524[(14)]);
var inst_33484 = (state_33524[(11)]);
var inst_33482 = (state_33524[(2)]);
var inst_33483__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33482,(0),null);
var inst_33484__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33482,(1),null);
var inst_33485 = (inst_33483__$1 == null);
var inst_33486 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33484__$1,change);
var inst_33487 = (inst_33485) || (inst_33486);
var state_33524__$1 = (function (){var statearr_33546 = state_33524;
(statearr_33546[(14)] = inst_33483__$1);

(statearr_33546[(11)] = inst_33484__$1);

return statearr_33546;
})();
if(cljs.core.truth_(inst_33487)){
var statearr_33547_33606 = state_33524__$1;
(statearr_33547_33606[(1)] = (23));

} else {
var statearr_33548_33607 = state_33524__$1;
(statearr_33548_33607[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (36))){
var inst_33474 = (state_33524[(12)]);
var inst_33451 = inst_33474;
var state_33524__$1 = (function (){var statearr_33549 = state_33524;
(statearr_33549[(7)] = inst_33451);

return statearr_33549;
})();
var statearr_33550_33608 = state_33524__$1;
(statearr_33550_33608[(2)] = null);

(statearr_33550_33608[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (29))){
var inst_33498 = (state_33524[(10)]);
var state_33524__$1 = state_33524;
var statearr_33551_33609 = state_33524__$1;
(statearr_33551_33609[(2)] = inst_33498);

(statearr_33551_33609[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (6))){
var state_33524__$1 = state_33524;
var statearr_33552_33610 = state_33524__$1;
(statearr_33552_33610[(2)] = false);

(statearr_33552_33610[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (28))){
var inst_33494 = (state_33524[(2)]);
var inst_33495 = calc_state();
var inst_33451 = inst_33495;
var state_33524__$1 = (function (){var statearr_33553 = state_33524;
(statearr_33553[(7)] = inst_33451);

(statearr_33553[(15)] = inst_33494);

return statearr_33553;
})();
var statearr_33554_33611 = state_33524__$1;
(statearr_33554_33611[(2)] = null);

(statearr_33554_33611[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (25))){
var inst_33520 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
var statearr_33555_33612 = state_33524__$1;
(statearr_33555_33612[(2)] = inst_33520);

(statearr_33555_33612[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (34))){
var inst_33518 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
var statearr_33556_33613 = state_33524__$1;
(statearr_33556_33613[(2)] = inst_33518);

(statearr_33556_33613[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (17))){
var state_33524__$1 = state_33524;
var statearr_33557_33614 = state_33524__$1;
(statearr_33557_33614[(2)] = false);

(statearr_33557_33614[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (3))){
var state_33524__$1 = state_33524;
var statearr_33558_33615 = state_33524__$1;
(statearr_33558_33615[(2)] = false);

(statearr_33558_33615[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (12))){
var inst_33522 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33524__$1,inst_33522);
} else {
if((state_val_33525 === (2))){
var inst_33426 = (state_33524[(8)]);
var inst_33431 = inst_33426.cljs$lang$protocol_mask$partition0$;
var inst_33432 = (inst_33431 & (64));
var inst_33433 = inst_33426.cljs$core$ISeq$;
var inst_33434 = (cljs.core.PROTOCOL_SENTINEL === inst_33433);
var inst_33435 = (inst_33432) || (inst_33434);
var state_33524__$1 = state_33524;
if(cljs.core.truth_(inst_33435)){
var statearr_33559_33616 = state_33524__$1;
(statearr_33559_33616[(1)] = (5));

} else {
var statearr_33560_33617 = state_33524__$1;
(statearr_33560_33617[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (23))){
var inst_33483 = (state_33524[(14)]);
var inst_33489 = (inst_33483 == null);
var state_33524__$1 = state_33524;
if(cljs.core.truth_(inst_33489)){
var statearr_33561_33618 = state_33524__$1;
(statearr_33561_33618[(1)] = (26));

} else {
var statearr_33562_33619 = state_33524__$1;
(statearr_33562_33619[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (35))){
var inst_33509 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
if(cljs.core.truth_(inst_33509)){
var statearr_33563_33620 = state_33524__$1;
(statearr_33563_33620[(1)] = (36));

} else {
var statearr_33564_33621 = state_33524__$1;
(statearr_33564_33621[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (19))){
var inst_33451 = (state_33524[(7)]);
var inst_33471 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33451);
var state_33524__$1 = state_33524;
var statearr_33565_33622 = state_33524__$1;
(statearr_33565_33622[(2)] = inst_33471);

(statearr_33565_33622[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (11))){
var inst_33451 = (state_33524[(7)]);
var inst_33455 = (inst_33451 == null);
var inst_33456 = cljs.core.not(inst_33455);
var state_33524__$1 = state_33524;
if(inst_33456){
var statearr_33566_33623 = state_33524__$1;
(statearr_33566_33623[(1)] = (13));

} else {
var statearr_33567_33624 = state_33524__$1;
(statearr_33567_33624[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (9))){
var inst_33426 = (state_33524[(8)]);
var state_33524__$1 = state_33524;
var statearr_33568_33625 = state_33524__$1;
(statearr_33568_33625[(2)] = inst_33426);

(statearr_33568_33625[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (5))){
var state_33524__$1 = state_33524;
var statearr_33569_33626 = state_33524__$1;
(statearr_33569_33626[(2)] = true);

(statearr_33569_33626[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (14))){
var state_33524__$1 = state_33524;
var statearr_33570_33627 = state_33524__$1;
(statearr_33570_33627[(2)] = false);

(statearr_33570_33627[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (26))){
var inst_33484 = (state_33524[(11)]);
var inst_33491 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_33484);
var state_33524__$1 = state_33524;
var statearr_33571_33628 = state_33524__$1;
(statearr_33571_33628[(2)] = inst_33491);

(statearr_33571_33628[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (16))){
var state_33524__$1 = state_33524;
var statearr_33572_33629 = state_33524__$1;
(statearr_33572_33629[(2)] = true);

(statearr_33572_33629[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (38))){
var inst_33514 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
var statearr_33573_33630 = state_33524__$1;
(statearr_33573_33630[(2)] = inst_33514);

(statearr_33573_33630[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (30))){
var inst_33475 = (state_33524[(9)]);
var inst_33476 = (state_33524[(13)]);
var inst_33484 = (state_33524[(11)]);
var inst_33501 = cljs.core.empty_QMARK_(inst_33475);
var inst_33502 = (inst_33476.cljs$core$IFn$_invoke$arity$1 ? inst_33476.cljs$core$IFn$_invoke$arity$1(inst_33484) : inst_33476.call(null,inst_33484));
var inst_33503 = cljs.core.not(inst_33502);
var inst_33504 = (inst_33501) && (inst_33503);
var state_33524__$1 = state_33524;
var statearr_33574_33631 = state_33524__$1;
(statearr_33574_33631[(2)] = inst_33504);

(statearr_33574_33631[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (10))){
var inst_33426 = (state_33524[(8)]);
var inst_33447 = (state_33524[(2)]);
var inst_33448 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33447,cljs.core.cst$kw$solos);
var inst_33449 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33447,cljs.core.cst$kw$mutes);
var inst_33450 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33447,cljs.core.cst$kw$reads);
var inst_33451 = inst_33426;
var state_33524__$1 = (function (){var statearr_33575 = state_33524;
(statearr_33575[(7)] = inst_33451);

(statearr_33575[(16)] = inst_33449);

(statearr_33575[(17)] = inst_33448);

(statearr_33575[(18)] = inst_33450);

return statearr_33575;
})();
var statearr_33576_33632 = state_33524__$1;
(statearr_33576_33632[(2)] = null);

(statearr_33576_33632[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (18))){
var inst_33466 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
var statearr_33577_33633 = state_33524__$1;
(statearr_33577_33633[(2)] = inst_33466);

(statearr_33577_33633[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (37))){
var state_33524__$1 = state_33524;
var statearr_33578_33634 = state_33524__$1;
(statearr_33578_33634[(2)] = null);

(statearr_33578_33634[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (8))){
var inst_33426 = (state_33524[(8)]);
var inst_33444 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_33426);
var state_33524__$1 = state_33524;
var statearr_33579_33635 = state_33524__$1;
(statearr_33579_33635[(2)] = inst_33444);

(statearr_33579_33635[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___33589,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__19180__auto__,c__19292__auto___33589,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__19181__auto__ = null;
var cljs$core$async$mix_$_state_machine__19181__auto____0 = (function (){
var statearr_33583 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33583[(0)] = cljs$core$async$mix_$_state_machine__19181__auto__);

(statearr_33583[(1)] = (1));

return statearr_33583;
});
var cljs$core$async$mix_$_state_machine__19181__auto____1 = (function (state_33524){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_33524);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e33584){if((e33584 instanceof Object)){
var ex__19184__auto__ = e33584;
var statearr_33585_33636 = state_33524;
(statearr_33585_33636[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33524);

return cljs.core.cst$kw$recur;
} else {
throw e33584;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__33637 = state_33524;
state_33524 = G__33637;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__19181__auto__ = function(state_33524){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__19181__auto____1.call(this,state_33524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__19181__auto____0;
cljs$core$async$mix_$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__19181__auto____1;
return cljs$core$async$mix_$_state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___33589,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__19294__auto__ = (function (){var statearr_33586 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_33586[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___33589);

return statearr_33586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___33589,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7207__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7207__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7207__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7207__auto__.call(null,p,v,ch));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7207__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args33638 = [];
var len__7651__auto___33641 = arguments.length;
var i__7652__auto___33642 = (0);
while(true){
if((i__7652__auto___33642 < len__7651__auto___33641)){
args33638.push((arguments[i__7652__auto___33642]));

var G__33643 = (i__7652__auto___33642 + (1));
i__7652__auto___33642 = G__33643;
continue;
} else {
}
break;
}

var G__33640 = args33638.length;
switch (G__33640) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33638.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7207__auto__.call(null,p));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7207__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7206__auto__ = (((p == null))?null:p);
var m__7207__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7206__auto__)]);
if(!((m__7207__auto__ == null))){
return (m__7207__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7207__auto__.call(null,p,v));
} else {
var m__7207__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7207__auto____$1 == null))){
return (m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7207__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7207__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args33646 = [];
var len__7651__auto___33774 = arguments.length;
var i__7652__auto___33775 = (0);
while(true){
if((i__7652__auto___33775 < len__7651__auto___33774)){
args33646.push((arguments[i__7652__auto___33775]));

var G__33776 = (i__7652__auto___33775 + (1));
i__7652__auto___33775 = G__33776;
continue;
} else {
}
break;
}

var G__33648 = args33646.length;
switch (G__33648) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33646.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__33649 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__33649) : cljs.core.atom.call(null,G__33649));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6543__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6543__auto__,mults){
return (function (p1__33645_SHARP_){
if(cljs.core.truth_((p1__33645_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__33645_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__33645_SHARP_.call(null,topic)))){
return p1__33645_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__33645_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6543__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async33650 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33650 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta33651){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta33651 = meta33651;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async33650.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_33652,meta33651__$1){
var self__ = this;
var _33652__$1 = this;
return (new cljs.core.async.t_cljs$core$async33650(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta33651__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33650.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_33652){
var self__ = this;
var _33652__$1 = this;
return self__.meta33651;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33650.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33650.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33650.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33650.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33650.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33650.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__33653 = self__.mults;
var G__33654 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__33653,G__33654) : cljs.core.reset_BANG_.call(null,G__33653,G__33654));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33650.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33650.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta33651], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async33650.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33650.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33650";

cljs.core.async.t_cljs$core$async33650.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async33650");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async33650 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async33650(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33651){
return (new cljs.core.async.t_cljs$core$async33650(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta33651));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async33650(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__19292__auto___33778 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___33778,mults,ensure_mult,p){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___33778,mults,ensure_mult,p){
return (function (state_33726){
var state_val_33727 = (state_33726[(1)]);
if((state_val_33727 === (7))){
var inst_33722 = (state_33726[(2)]);
var state_33726__$1 = state_33726;
var statearr_33728_33779 = state_33726__$1;
(statearr_33728_33779[(2)] = inst_33722);

(statearr_33728_33779[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (20))){
var state_33726__$1 = state_33726;
var statearr_33729_33780 = state_33726__$1;
(statearr_33729_33780[(2)] = null);

(statearr_33729_33780[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (1))){
var state_33726__$1 = state_33726;
var statearr_33730_33781 = state_33726__$1;
(statearr_33730_33781[(2)] = null);

(statearr_33730_33781[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (24))){
var inst_33705 = (state_33726[(7)]);
var inst_33714 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_33705);
var state_33726__$1 = state_33726;
var statearr_33731_33782 = state_33726__$1;
(statearr_33731_33782[(2)] = inst_33714);

(statearr_33731_33782[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (4))){
var inst_33657 = (state_33726[(8)]);
var inst_33657__$1 = (state_33726[(2)]);
var inst_33658 = (inst_33657__$1 == null);
var state_33726__$1 = (function (){var statearr_33732 = state_33726;
(statearr_33732[(8)] = inst_33657__$1);

return statearr_33732;
})();
if(cljs.core.truth_(inst_33658)){
var statearr_33733_33783 = state_33726__$1;
(statearr_33733_33783[(1)] = (5));

} else {
var statearr_33734_33784 = state_33726__$1;
(statearr_33734_33784[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (15))){
var inst_33699 = (state_33726[(2)]);
var state_33726__$1 = state_33726;
var statearr_33735_33785 = state_33726__$1;
(statearr_33735_33785[(2)] = inst_33699);

(statearr_33735_33785[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (21))){
var inst_33719 = (state_33726[(2)]);
var state_33726__$1 = (function (){var statearr_33736 = state_33726;
(statearr_33736[(9)] = inst_33719);

return statearr_33736;
})();
var statearr_33737_33786 = state_33726__$1;
(statearr_33737_33786[(2)] = null);

(statearr_33737_33786[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (13))){
var inst_33681 = (state_33726[(10)]);
var inst_33683 = cljs.core.chunked_seq_QMARK_(inst_33681);
var state_33726__$1 = state_33726;
if(inst_33683){
var statearr_33738_33787 = state_33726__$1;
(statearr_33738_33787[(1)] = (16));

} else {
var statearr_33739_33788 = state_33726__$1;
(statearr_33739_33788[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (22))){
var inst_33711 = (state_33726[(2)]);
var state_33726__$1 = state_33726;
if(cljs.core.truth_(inst_33711)){
var statearr_33740_33789 = state_33726__$1;
(statearr_33740_33789[(1)] = (23));

} else {
var statearr_33741_33790 = state_33726__$1;
(statearr_33741_33790[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (6))){
var inst_33705 = (state_33726[(7)]);
var inst_33657 = (state_33726[(8)]);
var inst_33707 = (state_33726[(11)]);
var inst_33705__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_33657) : topic_fn.call(null,inst_33657));
var inst_33706 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33707__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33706,inst_33705__$1);
var state_33726__$1 = (function (){var statearr_33742 = state_33726;
(statearr_33742[(7)] = inst_33705__$1);

(statearr_33742[(11)] = inst_33707__$1);

return statearr_33742;
})();
if(cljs.core.truth_(inst_33707__$1)){
var statearr_33743_33791 = state_33726__$1;
(statearr_33743_33791[(1)] = (19));

} else {
var statearr_33744_33792 = state_33726__$1;
(statearr_33744_33792[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (25))){
var inst_33716 = (state_33726[(2)]);
var state_33726__$1 = state_33726;
var statearr_33745_33793 = state_33726__$1;
(statearr_33745_33793[(2)] = inst_33716);

(statearr_33745_33793[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (17))){
var inst_33681 = (state_33726[(10)]);
var inst_33690 = cljs.core.first(inst_33681);
var inst_33691 = cljs.core.async.muxch_STAR_(inst_33690);
var inst_33692 = cljs.core.async.close_BANG_(inst_33691);
var inst_33693 = cljs.core.next(inst_33681);
var inst_33667 = inst_33693;
var inst_33668 = null;
var inst_33669 = (0);
var inst_33670 = (0);
var state_33726__$1 = (function (){var statearr_33746 = state_33726;
(statearr_33746[(12)] = inst_33667);

(statearr_33746[(13)] = inst_33669);

(statearr_33746[(14)] = inst_33670);

(statearr_33746[(15)] = inst_33668);

(statearr_33746[(16)] = inst_33692);

return statearr_33746;
})();
var statearr_33747_33794 = state_33726__$1;
(statearr_33747_33794[(2)] = null);

(statearr_33747_33794[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (3))){
var inst_33724 = (state_33726[(2)]);
var state_33726__$1 = state_33726;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33726__$1,inst_33724);
} else {
if((state_val_33727 === (12))){
var inst_33701 = (state_33726[(2)]);
var state_33726__$1 = state_33726;
var statearr_33748_33795 = state_33726__$1;
(statearr_33748_33795[(2)] = inst_33701);

(statearr_33748_33795[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (2))){
var state_33726__$1 = state_33726;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33726__$1,(4),ch);
} else {
if((state_val_33727 === (23))){
var state_33726__$1 = state_33726;
var statearr_33749_33796 = state_33726__$1;
(statearr_33749_33796[(2)] = null);

(statearr_33749_33796[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (19))){
var inst_33657 = (state_33726[(8)]);
var inst_33707 = (state_33726[(11)]);
var inst_33709 = cljs.core.async.muxch_STAR_(inst_33707);
var state_33726__$1 = state_33726;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33726__$1,(22),inst_33709,inst_33657);
} else {
if((state_val_33727 === (11))){
var inst_33681 = (state_33726[(10)]);
var inst_33667 = (state_33726[(12)]);
var inst_33681__$1 = cljs.core.seq(inst_33667);
var state_33726__$1 = (function (){var statearr_33750 = state_33726;
(statearr_33750[(10)] = inst_33681__$1);

return statearr_33750;
})();
if(inst_33681__$1){
var statearr_33751_33797 = state_33726__$1;
(statearr_33751_33797[(1)] = (13));

} else {
var statearr_33752_33798 = state_33726__$1;
(statearr_33752_33798[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (9))){
var inst_33703 = (state_33726[(2)]);
var state_33726__$1 = state_33726;
var statearr_33753_33799 = state_33726__$1;
(statearr_33753_33799[(2)] = inst_33703);

(statearr_33753_33799[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (5))){
var inst_33664 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_33665 = cljs.core.vals(inst_33664);
var inst_33666 = cljs.core.seq(inst_33665);
var inst_33667 = inst_33666;
var inst_33668 = null;
var inst_33669 = (0);
var inst_33670 = (0);
var state_33726__$1 = (function (){var statearr_33754 = state_33726;
(statearr_33754[(12)] = inst_33667);

(statearr_33754[(13)] = inst_33669);

(statearr_33754[(14)] = inst_33670);

(statearr_33754[(15)] = inst_33668);

return statearr_33754;
})();
var statearr_33755_33800 = state_33726__$1;
(statearr_33755_33800[(2)] = null);

(statearr_33755_33800[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (14))){
var state_33726__$1 = state_33726;
var statearr_33759_33801 = state_33726__$1;
(statearr_33759_33801[(2)] = null);

(statearr_33759_33801[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (16))){
var inst_33681 = (state_33726[(10)]);
var inst_33685 = cljs.core.chunk_first(inst_33681);
var inst_33686 = cljs.core.chunk_rest(inst_33681);
var inst_33687 = cljs.core.count(inst_33685);
var inst_33667 = inst_33686;
var inst_33668 = inst_33685;
var inst_33669 = inst_33687;
var inst_33670 = (0);
var state_33726__$1 = (function (){var statearr_33760 = state_33726;
(statearr_33760[(12)] = inst_33667);

(statearr_33760[(13)] = inst_33669);

(statearr_33760[(14)] = inst_33670);

(statearr_33760[(15)] = inst_33668);

return statearr_33760;
})();
var statearr_33761_33802 = state_33726__$1;
(statearr_33761_33802[(2)] = null);

(statearr_33761_33802[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (10))){
var inst_33667 = (state_33726[(12)]);
var inst_33669 = (state_33726[(13)]);
var inst_33670 = (state_33726[(14)]);
var inst_33668 = (state_33726[(15)]);
var inst_33675 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_33668,inst_33670);
var inst_33676 = cljs.core.async.muxch_STAR_(inst_33675);
var inst_33677 = cljs.core.async.close_BANG_(inst_33676);
var inst_33678 = (inst_33670 + (1));
var tmp33756 = inst_33667;
var tmp33757 = inst_33669;
var tmp33758 = inst_33668;
var inst_33667__$1 = tmp33756;
var inst_33668__$1 = tmp33758;
var inst_33669__$1 = tmp33757;
var inst_33670__$1 = inst_33678;
var state_33726__$1 = (function (){var statearr_33762 = state_33726;
(statearr_33762[(12)] = inst_33667__$1);

(statearr_33762[(13)] = inst_33669__$1);

(statearr_33762[(14)] = inst_33670__$1);

(statearr_33762[(17)] = inst_33677);

(statearr_33762[(15)] = inst_33668__$1);

return statearr_33762;
})();
var statearr_33763_33803 = state_33726__$1;
(statearr_33763_33803[(2)] = null);

(statearr_33763_33803[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (18))){
var inst_33696 = (state_33726[(2)]);
var state_33726__$1 = state_33726;
var statearr_33764_33804 = state_33726__$1;
(statearr_33764_33804[(2)] = inst_33696);

(statearr_33764_33804[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33727 === (8))){
var inst_33669 = (state_33726[(13)]);
var inst_33670 = (state_33726[(14)]);
var inst_33672 = (inst_33670 < inst_33669);
var inst_33673 = inst_33672;
var state_33726__$1 = state_33726;
if(cljs.core.truth_(inst_33673)){
var statearr_33765_33805 = state_33726__$1;
(statearr_33765_33805[(1)] = (10));

} else {
var statearr_33766_33806 = state_33726__$1;
(statearr_33766_33806[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___33778,mults,ensure_mult,p))
;
return ((function (switch__19180__auto__,c__19292__auto___33778,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__19181__auto__ = null;
var cljs$core$async$state_machine__19181__auto____0 = (function (){
var statearr_33770 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33770[(0)] = cljs$core$async$state_machine__19181__auto__);

(statearr_33770[(1)] = (1));

return statearr_33770;
});
var cljs$core$async$state_machine__19181__auto____1 = (function (state_33726){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_33726);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e33771){if((e33771 instanceof Object)){
var ex__19184__auto__ = e33771;
var statearr_33772_33807 = state_33726;
(statearr_33772_33807[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33726);

return cljs.core.cst$kw$recur;
} else {
throw e33771;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__33808 = state_33726;
state_33726 = G__33808;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$state_machine__19181__auto__ = function(state_33726){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19181__auto____1.call(this,state_33726);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19181__auto____0;
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19181__auto____1;
return cljs$core$async$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___33778,mults,ensure_mult,p))
})();
var state__19294__auto__ = (function (){var statearr_33773 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_33773[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___33778);

return statearr_33773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___33778,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args33809 = [];
var len__7651__auto___33812 = arguments.length;
var i__7652__auto___33813 = (0);
while(true){
if((i__7652__auto___33813 < len__7651__auto___33812)){
args33809.push((arguments[i__7652__auto___33813]));

var G__33814 = (i__7652__auto___33813 + (1));
i__7652__auto___33813 = G__33814;
continue;
} else {
}
break;
}

var G__33811 = args33809.length;
switch (G__33811) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33809.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args33816 = [];
var len__7651__auto___33819 = arguments.length;
var i__7652__auto___33820 = (0);
while(true){
if((i__7652__auto___33820 < len__7651__auto___33819)){
args33816.push((arguments[i__7652__auto___33820]));

var G__33821 = (i__7652__auto___33820 + (1));
i__7652__auto___33820 = G__33821;
continue;
} else {
}
break;
}

var G__33818 = args33816.length;
switch (G__33818) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33816.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args33823 = [];
var len__7651__auto___33894 = arguments.length;
var i__7652__auto___33895 = (0);
while(true){
if((i__7652__auto___33895 < len__7651__auto___33894)){
args33823.push((arguments[i__7652__auto___33895]));

var G__33896 = (i__7652__auto___33895 + (1));
i__7652__auto___33895 = G__33896;
continue;
} else {
}
break;
}

var G__33825 = args33823.length;
switch (G__33825) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33823.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__19292__auto___33898 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___33898,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___33898,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_33864){
var state_val_33865 = (state_33864[(1)]);
if((state_val_33865 === (7))){
var state_33864__$1 = state_33864;
var statearr_33866_33899 = state_33864__$1;
(statearr_33866_33899[(2)] = null);

(statearr_33866_33899[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33865 === (1))){
var state_33864__$1 = state_33864;
var statearr_33867_33900 = state_33864__$1;
(statearr_33867_33900[(2)] = null);

(statearr_33867_33900[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33865 === (4))){
var inst_33828 = (state_33864[(7)]);
var inst_33830 = (inst_33828 < cnt);
var state_33864__$1 = state_33864;
if(cljs.core.truth_(inst_33830)){
var statearr_33868_33901 = state_33864__$1;
(statearr_33868_33901[(1)] = (6));

} else {
var statearr_33869_33902 = state_33864__$1;
(statearr_33869_33902[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33865 === (15))){
var inst_33860 = (state_33864[(2)]);
var state_33864__$1 = state_33864;
var statearr_33870_33903 = state_33864__$1;
(statearr_33870_33903[(2)] = inst_33860);

(statearr_33870_33903[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33865 === (13))){
var inst_33853 = cljs.core.async.close_BANG_(out);
var state_33864__$1 = state_33864;
var statearr_33871_33904 = state_33864__$1;
(statearr_33871_33904[(2)] = inst_33853);

(statearr_33871_33904[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33865 === (6))){
var state_33864__$1 = state_33864;
var statearr_33872_33905 = state_33864__$1;
(statearr_33872_33905[(2)] = null);

(statearr_33872_33905[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33865 === (3))){
var inst_33862 = (state_33864[(2)]);
var state_33864__$1 = state_33864;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33864__$1,inst_33862);
} else {
if((state_val_33865 === (12))){
var inst_33850 = (state_33864[(8)]);
var inst_33850__$1 = (state_33864[(2)]);
var inst_33851 = cljs.core.some(cljs.core.nil_QMARK_,inst_33850__$1);
var state_33864__$1 = (function (){var statearr_33873 = state_33864;
(statearr_33873[(8)] = inst_33850__$1);

return statearr_33873;
})();
if(cljs.core.truth_(inst_33851)){
var statearr_33874_33906 = state_33864__$1;
(statearr_33874_33906[(1)] = (13));

} else {
var statearr_33875_33907 = state_33864__$1;
(statearr_33875_33907[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33865 === (2))){
var inst_33827 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_33828 = (0);
var state_33864__$1 = (function (){var statearr_33876 = state_33864;
(statearr_33876[(9)] = inst_33827);

(statearr_33876[(7)] = inst_33828);

return statearr_33876;
})();
var statearr_33877_33908 = state_33864__$1;
(statearr_33877_33908[(2)] = null);

(statearr_33877_33908[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33865 === (11))){
var inst_33828 = (state_33864[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_33864,(10),Object,null,(9));
var inst_33837 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_33828) : chs__$1.call(null,inst_33828));
var inst_33838 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_33828) : done.call(null,inst_33828));
var inst_33839 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33837,inst_33838);
var state_33864__$1 = state_33864;
var statearr_33878_33909 = state_33864__$1;
(statearr_33878_33909[(2)] = inst_33839);


cljs.core.async.impl.ioc_helpers.process_exception(state_33864__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33865 === (9))){
var inst_33828 = (state_33864[(7)]);
var inst_33841 = (state_33864[(2)]);
var inst_33842 = (inst_33828 + (1));
var inst_33828__$1 = inst_33842;
var state_33864__$1 = (function (){var statearr_33879 = state_33864;
(statearr_33879[(10)] = inst_33841);

(statearr_33879[(7)] = inst_33828__$1);

return statearr_33879;
})();
var statearr_33880_33910 = state_33864__$1;
(statearr_33880_33910[(2)] = null);

(statearr_33880_33910[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33865 === (5))){
var inst_33848 = (state_33864[(2)]);
var state_33864__$1 = (function (){var statearr_33881 = state_33864;
(statearr_33881[(11)] = inst_33848);

return statearr_33881;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33864__$1,(12),dchan);
} else {
if((state_val_33865 === (14))){
var inst_33850 = (state_33864[(8)]);
var inst_33855 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_33850);
var state_33864__$1 = state_33864;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33864__$1,(16),out,inst_33855);
} else {
if((state_val_33865 === (16))){
var inst_33857 = (state_33864[(2)]);
var state_33864__$1 = (function (){var statearr_33882 = state_33864;
(statearr_33882[(12)] = inst_33857);

return statearr_33882;
})();
var statearr_33883_33911 = state_33864__$1;
(statearr_33883_33911[(2)] = null);

(statearr_33883_33911[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33865 === (10))){
var inst_33832 = (state_33864[(2)]);
var inst_33833 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_33864__$1 = (function (){var statearr_33884 = state_33864;
(statearr_33884[(13)] = inst_33832);

return statearr_33884;
})();
var statearr_33885_33912 = state_33864__$1;
(statearr_33885_33912[(2)] = inst_33833);


cljs.core.async.impl.ioc_helpers.process_exception(state_33864__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_33865 === (8))){
var inst_33846 = (state_33864[(2)]);
var state_33864__$1 = state_33864;
var statearr_33886_33913 = state_33864__$1;
(statearr_33886_33913[(2)] = inst_33846);

(statearr_33886_33913[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___33898,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__19180__auto__,c__19292__auto___33898,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__19181__auto__ = null;
var cljs$core$async$state_machine__19181__auto____0 = (function (){
var statearr_33890 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33890[(0)] = cljs$core$async$state_machine__19181__auto__);

(statearr_33890[(1)] = (1));

return statearr_33890;
});
var cljs$core$async$state_machine__19181__auto____1 = (function (state_33864){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_33864);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e33891){if((e33891 instanceof Object)){
var ex__19184__auto__ = e33891;
var statearr_33892_33914 = state_33864;
(statearr_33892_33914[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33864);

return cljs.core.cst$kw$recur;
} else {
throw e33891;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__33915 = state_33864;
state_33864 = G__33915;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$state_machine__19181__auto__ = function(state_33864){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19181__auto____1.call(this,state_33864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19181__auto____0;
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19181__auto____1;
return cljs$core$async$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___33898,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__19294__auto__ = (function (){var statearr_33893 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_33893[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___33898);

return statearr_33893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___33898,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args33917 = [];
var len__7651__auto___33975 = arguments.length;
var i__7652__auto___33976 = (0);
while(true){
if((i__7652__auto___33976 < len__7651__auto___33975)){
args33917.push((arguments[i__7652__auto___33976]));

var G__33977 = (i__7652__auto___33976 + (1));
i__7652__auto___33976 = G__33977;
continue;
} else {
}
break;
}

var G__33919 = args33917.length;
switch (G__33919) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33917.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19292__auto___33979 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___33979,out){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___33979,out){
return (function (state_33951){
var state_val_33952 = (state_33951[(1)]);
if((state_val_33952 === (7))){
var inst_33931 = (state_33951[(7)]);
var inst_33930 = (state_33951[(8)]);
var inst_33930__$1 = (state_33951[(2)]);
var inst_33931__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33930__$1,(0),null);
var inst_33932 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33930__$1,(1),null);
var inst_33933 = (inst_33931__$1 == null);
var state_33951__$1 = (function (){var statearr_33953 = state_33951;
(statearr_33953[(7)] = inst_33931__$1);

(statearr_33953[(8)] = inst_33930__$1);

(statearr_33953[(9)] = inst_33932);

return statearr_33953;
})();
if(cljs.core.truth_(inst_33933)){
var statearr_33954_33980 = state_33951__$1;
(statearr_33954_33980[(1)] = (8));

} else {
var statearr_33955_33981 = state_33951__$1;
(statearr_33955_33981[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33952 === (1))){
var inst_33920 = cljs.core.vec(chs);
var inst_33921 = inst_33920;
var state_33951__$1 = (function (){var statearr_33956 = state_33951;
(statearr_33956[(10)] = inst_33921);

return statearr_33956;
})();
var statearr_33957_33982 = state_33951__$1;
(statearr_33957_33982[(2)] = null);

(statearr_33957_33982[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33952 === (4))){
var inst_33921 = (state_33951[(10)]);
var state_33951__$1 = state_33951;
return cljs.core.async.ioc_alts_BANG_(state_33951__$1,(7),inst_33921);
} else {
if((state_val_33952 === (6))){
var inst_33947 = (state_33951[(2)]);
var state_33951__$1 = state_33951;
var statearr_33958_33983 = state_33951__$1;
(statearr_33958_33983[(2)] = inst_33947);

(statearr_33958_33983[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33952 === (3))){
var inst_33949 = (state_33951[(2)]);
var state_33951__$1 = state_33951;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33951__$1,inst_33949);
} else {
if((state_val_33952 === (2))){
var inst_33921 = (state_33951[(10)]);
var inst_33923 = cljs.core.count(inst_33921);
var inst_33924 = (inst_33923 > (0));
var state_33951__$1 = state_33951;
if(cljs.core.truth_(inst_33924)){
var statearr_33960_33984 = state_33951__$1;
(statearr_33960_33984[(1)] = (4));

} else {
var statearr_33961_33985 = state_33951__$1;
(statearr_33961_33985[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33952 === (11))){
var inst_33921 = (state_33951[(10)]);
var inst_33940 = (state_33951[(2)]);
var tmp33959 = inst_33921;
var inst_33921__$1 = tmp33959;
var state_33951__$1 = (function (){var statearr_33962 = state_33951;
(statearr_33962[(10)] = inst_33921__$1);

(statearr_33962[(11)] = inst_33940);

return statearr_33962;
})();
var statearr_33963_33986 = state_33951__$1;
(statearr_33963_33986[(2)] = null);

(statearr_33963_33986[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33952 === (9))){
var inst_33931 = (state_33951[(7)]);
var state_33951__$1 = state_33951;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_33951__$1,(11),out,inst_33931);
} else {
if((state_val_33952 === (5))){
var inst_33945 = cljs.core.async.close_BANG_(out);
var state_33951__$1 = state_33951;
var statearr_33964_33987 = state_33951__$1;
(statearr_33964_33987[(2)] = inst_33945);

(statearr_33964_33987[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33952 === (10))){
var inst_33943 = (state_33951[(2)]);
var state_33951__$1 = state_33951;
var statearr_33965_33988 = state_33951__$1;
(statearr_33965_33988[(2)] = inst_33943);

(statearr_33965_33988[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33952 === (8))){
var inst_33931 = (state_33951[(7)]);
var inst_33930 = (state_33951[(8)]);
var inst_33932 = (state_33951[(9)]);
var inst_33921 = (state_33951[(10)]);
var inst_33935 = (function (){var cs = inst_33921;
var vec__33926 = inst_33930;
var v = inst_33931;
var c = inst_33932;
return ((function (cs,vec__33926,v,c,inst_33931,inst_33930,inst_33932,inst_33921,state_val_33952,c__19292__auto___33979,out){
return (function (p1__33916_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__33916_SHARP_);
});
;})(cs,vec__33926,v,c,inst_33931,inst_33930,inst_33932,inst_33921,state_val_33952,c__19292__auto___33979,out))
})();
var inst_33936 = cljs.core.filterv(inst_33935,inst_33921);
var inst_33921__$1 = inst_33936;
var state_33951__$1 = (function (){var statearr_33966 = state_33951;
(statearr_33966[(10)] = inst_33921__$1);

return statearr_33966;
})();
var statearr_33967_33989 = state_33951__$1;
(statearr_33967_33989[(2)] = null);

(statearr_33967_33989[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___33979,out))
;
return ((function (switch__19180__auto__,c__19292__auto___33979,out){
return (function() {
var cljs$core$async$state_machine__19181__auto__ = null;
var cljs$core$async$state_machine__19181__auto____0 = (function (){
var statearr_33971 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33971[(0)] = cljs$core$async$state_machine__19181__auto__);

(statearr_33971[(1)] = (1));

return statearr_33971;
});
var cljs$core$async$state_machine__19181__auto____1 = (function (state_33951){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_33951);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e33972){if((e33972 instanceof Object)){
var ex__19184__auto__ = e33972;
var statearr_33973_33990 = state_33951;
(statearr_33973_33990[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_33951);

return cljs.core.cst$kw$recur;
} else {
throw e33972;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__33991 = state_33951;
state_33951 = G__33991;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$state_machine__19181__auto__ = function(state_33951){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19181__auto____1.call(this,state_33951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19181__auto____0;
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19181__auto____1;
return cljs$core$async$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___33979,out))
})();
var state__19294__auto__ = (function (){var statearr_33974 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_33974[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___33979);

return statearr_33974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___33979,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args33992 = [];
var len__7651__auto___34041 = arguments.length;
var i__7652__auto___34042 = (0);
while(true){
if((i__7652__auto___34042 < len__7651__auto___34041)){
args33992.push((arguments[i__7652__auto___34042]));

var G__34043 = (i__7652__auto___34042 + (1));
i__7652__auto___34042 = G__34043;
continue;
} else {
}
break;
}

var G__33994 = args33992.length;
switch (G__33994) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33992.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19292__auto___34045 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___34045,out){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___34045,out){
return (function (state_34018){
var state_val_34019 = (state_34018[(1)]);
if((state_val_34019 === (7))){
var inst_34000 = (state_34018[(7)]);
var inst_34000__$1 = (state_34018[(2)]);
var inst_34001 = (inst_34000__$1 == null);
var inst_34002 = cljs.core.not(inst_34001);
var state_34018__$1 = (function (){var statearr_34020 = state_34018;
(statearr_34020[(7)] = inst_34000__$1);

return statearr_34020;
})();
if(inst_34002){
var statearr_34021_34046 = state_34018__$1;
(statearr_34021_34046[(1)] = (8));

} else {
var statearr_34022_34047 = state_34018__$1;
(statearr_34022_34047[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34019 === (1))){
var inst_33995 = (0);
var state_34018__$1 = (function (){var statearr_34023 = state_34018;
(statearr_34023[(8)] = inst_33995);

return statearr_34023;
})();
var statearr_34024_34048 = state_34018__$1;
(statearr_34024_34048[(2)] = null);

(statearr_34024_34048[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34019 === (4))){
var state_34018__$1 = state_34018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34018__$1,(7),ch);
} else {
if((state_val_34019 === (6))){
var inst_34013 = (state_34018[(2)]);
var state_34018__$1 = state_34018;
var statearr_34025_34049 = state_34018__$1;
(statearr_34025_34049[(2)] = inst_34013);

(statearr_34025_34049[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34019 === (3))){
var inst_34015 = (state_34018[(2)]);
var inst_34016 = cljs.core.async.close_BANG_(out);
var state_34018__$1 = (function (){var statearr_34026 = state_34018;
(statearr_34026[(9)] = inst_34015);

return statearr_34026;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34018__$1,inst_34016);
} else {
if((state_val_34019 === (2))){
var inst_33995 = (state_34018[(8)]);
var inst_33997 = (inst_33995 < n);
var state_34018__$1 = state_34018;
if(cljs.core.truth_(inst_33997)){
var statearr_34027_34050 = state_34018__$1;
(statearr_34027_34050[(1)] = (4));

} else {
var statearr_34028_34051 = state_34018__$1;
(statearr_34028_34051[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34019 === (11))){
var inst_33995 = (state_34018[(8)]);
var inst_34005 = (state_34018[(2)]);
var inst_34006 = (inst_33995 + (1));
var inst_33995__$1 = inst_34006;
var state_34018__$1 = (function (){var statearr_34029 = state_34018;
(statearr_34029[(10)] = inst_34005);

(statearr_34029[(8)] = inst_33995__$1);

return statearr_34029;
})();
var statearr_34030_34052 = state_34018__$1;
(statearr_34030_34052[(2)] = null);

(statearr_34030_34052[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34019 === (9))){
var state_34018__$1 = state_34018;
var statearr_34031_34053 = state_34018__$1;
(statearr_34031_34053[(2)] = null);

(statearr_34031_34053[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34019 === (5))){
var state_34018__$1 = state_34018;
var statearr_34032_34054 = state_34018__$1;
(statearr_34032_34054[(2)] = null);

(statearr_34032_34054[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34019 === (10))){
var inst_34010 = (state_34018[(2)]);
var state_34018__$1 = state_34018;
var statearr_34033_34055 = state_34018__$1;
(statearr_34033_34055[(2)] = inst_34010);

(statearr_34033_34055[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34019 === (8))){
var inst_34000 = (state_34018[(7)]);
var state_34018__$1 = state_34018;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34018__$1,(11),out,inst_34000);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___34045,out))
;
return ((function (switch__19180__auto__,c__19292__auto___34045,out){
return (function() {
var cljs$core$async$state_machine__19181__auto__ = null;
var cljs$core$async$state_machine__19181__auto____0 = (function (){
var statearr_34037 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34037[(0)] = cljs$core$async$state_machine__19181__auto__);

(statearr_34037[(1)] = (1));

return statearr_34037;
});
var cljs$core$async$state_machine__19181__auto____1 = (function (state_34018){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_34018);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e34038){if((e34038 instanceof Object)){
var ex__19184__auto__ = e34038;
var statearr_34039_34056 = state_34018;
(statearr_34039_34056[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34018);

return cljs.core.cst$kw$recur;
} else {
throw e34038;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__34057 = state_34018;
state_34018 = G__34057;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$state_machine__19181__auto__ = function(state_34018){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19181__auto____1.call(this,state_34018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19181__auto____0;
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19181__auto____1;
return cljs$core$async$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___34045,out))
})();
var state__19294__auto__ = (function (){var statearr_34040 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_34040[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___34045);

return statearr_34040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___34045,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async34067 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34067 = (function (f,ch,meta34068){
this.f = f;
this.ch = ch;
this.meta34068 = meta34068;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34067.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34069,meta34068__$1){
var self__ = this;
var _34069__$1 = this;
return (new cljs.core.async.t_cljs$core$async34067(self__.f,self__.ch,meta34068__$1));
});

cljs.core.async.t_cljs$core$async34067.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34069){
var self__ = this;
var _34069__$1 = this;
return self__.meta34068;
});

cljs.core.async.t_cljs$core$async34067.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34067.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async34067.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async34067.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34067.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async34070 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34070 = (function (f,ch,meta34068,_,fn1,meta34071){
this.f = f;
this.ch = ch;
this.meta34068 = meta34068;
this._ = _;
this.fn1 = fn1;
this.meta34071 = meta34071;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34070.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_34072,meta34071__$1){
var self__ = this;
var _34072__$1 = this;
return (new cljs.core.async.t_cljs$core$async34070(self__.f,self__.ch,self__.meta34068,self__._,self__.fn1,meta34071__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async34070.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_34072){
var self__ = this;
var _34072__$1 = this;
return self__.meta34071;
});})(___$1))
;

cljs.core.async.t_cljs$core$async34070.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34070.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async34070.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async34070.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__34058_SHARP_){
var G__34073 = (((p1__34058_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__34058_SHARP_) : self__.f.call(null,p1__34058_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__34073) : f1.call(null,G__34073));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async34070.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta34068,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async34067], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta34071], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async34070.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34070.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34070";

cljs.core.async.t_cljs$core$async34070.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34070");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async34070 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async34070(f__$1,ch__$1,meta34068__$1,___$2,fn1__$1,meta34071){
return (new cljs.core.async.t_cljs$core$async34070(f__$1,ch__$1,meta34068__$1,___$2,fn1__$1,meta34071));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async34070(self__.f,self__.ch,self__.meta34068,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6531__auto__ = ret;
if(cljs.core.truth_(and__6531__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__34074 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__34074) : self__.f.call(null,G__34074));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async34067.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34067.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async34067.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta34068], null);
});

cljs.core.async.t_cljs$core$async34067.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34067.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34067";

cljs.core.async.t_cljs$core$async34067.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34067");
});

cljs.core.async.__GT_t_cljs$core$async34067 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async34067(f__$1,ch__$1,meta34068){
return (new cljs.core.async.t_cljs$core$async34067(f__$1,ch__$1,meta34068));
});

}

return (new cljs.core.async.t_cljs$core$async34067(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async34078 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34078 = (function (f,ch,meta34079){
this.f = f;
this.ch = ch;
this.meta34079 = meta34079;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34078.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34080,meta34079__$1){
var self__ = this;
var _34080__$1 = this;
return (new cljs.core.async.t_cljs$core$async34078(self__.f,self__.ch,meta34079__$1));
});

cljs.core.async.t_cljs$core$async34078.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34080){
var self__ = this;
var _34080__$1 = this;
return self__.meta34079;
});

cljs.core.async.t_cljs$core$async34078.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34078.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async34078.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34078.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async34078.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34078.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async34078.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta34079], null);
});

cljs.core.async.t_cljs$core$async34078.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34078.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34078";

cljs.core.async.t_cljs$core$async34078.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34078");
});

cljs.core.async.__GT_t_cljs$core$async34078 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async34078(f__$1,ch__$1,meta34079){
return (new cljs.core.async.t_cljs$core$async34078(f__$1,ch__$1,meta34079));
});

}

return (new cljs.core.async.t_cljs$core$async34078(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async34084 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async34084 = (function (p,ch,meta34085){
this.p = p;
this.ch = ch;
this.meta34085 = meta34085;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async34084.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34086,meta34085__$1){
var self__ = this;
var _34086__$1 = this;
return (new cljs.core.async.t_cljs$core$async34084(self__.p,self__.ch,meta34085__$1));
});

cljs.core.async.t_cljs$core$async34084.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34086){
var self__ = this;
var _34086__$1 = this;
return self__.meta34085;
});

cljs.core.async.t_cljs$core$async34084.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34084.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async34084.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async34084.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34084.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async34084.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async34084.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async34084.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta34085], null);
});

cljs.core.async.t_cljs$core$async34084.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async34084.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async34084";

cljs.core.async.t_cljs$core$async34084.cljs$lang$ctorPrWriter = (function (this__7149__auto__,writer__7150__auto__,opt__7151__auto__){
return cljs.core._write(writer__7150__auto__,"cljs.core.async/t_cljs$core$async34084");
});

cljs.core.async.__GT_t_cljs$core$async34084 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async34084(p__$1,ch__$1,meta34085){
return (new cljs.core.async.t_cljs$core$async34084(p__$1,ch__$1,meta34085));
});

}

return (new cljs.core.async.t_cljs$core$async34084(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args34087 = [];
var len__7651__auto___34131 = arguments.length;
var i__7652__auto___34132 = (0);
while(true){
if((i__7652__auto___34132 < len__7651__auto___34131)){
args34087.push((arguments[i__7652__auto___34132]));

var G__34133 = (i__7652__auto___34132 + (1));
i__7652__auto___34132 = G__34133;
continue;
} else {
}
break;
}

var G__34089 = args34087.length;
switch (G__34089) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34087.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19292__auto___34135 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___34135,out){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___34135,out){
return (function (state_34110){
var state_val_34111 = (state_34110[(1)]);
if((state_val_34111 === (7))){
var inst_34106 = (state_34110[(2)]);
var state_34110__$1 = state_34110;
var statearr_34112_34136 = state_34110__$1;
(statearr_34112_34136[(2)] = inst_34106);

(statearr_34112_34136[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34111 === (1))){
var state_34110__$1 = state_34110;
var statearr_34113_34137 = state_34110__$1;
(statearr_34113_34137[(2)] = null);

(statearr_34113_34137[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34111 === (4))){
var inst_34092 = (state_34110[(7)]);
var inst_34092__$1 = (state_34110[(2)]);
var inst_34093 = (inst_34092__$1 == null);
var state_34110__$1 = (function (){var statearr_34114 = state_34110;
(statearr_34114[(7)] = inst_34092__$1);

return statearr_34114;
})();
if(cljs.core.truth_(inst_34093)){
var statearr_34115_34138 = state_34110__$1;
(statearr_34115_34138[(1)] = (5));

} else {
var statearr_34116_34139 = state_34110__$1;
(statearr_34116_34139[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34111 === (6))){
var inst_34092 = (state_34110[(7)]);
var inst_34097 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_34092) : p.call(null,inst_34092));
var state_34110__$1 = state_34110;
if(cljs.core.truth_(inst_34097)){
var statearr_34117_34140 = state_34110__$1;
(statearr_34117_34140[(1)] = (8));

} else {
var statearr_34118_34141 = state_34110__$1;
(statearr_34118_34141[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34111 === (3))){
var inst_34108 = (state_34110[(2)]);
var state_34110__$1 = state_34110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34110__$1,inst_34108);
} else {
if((state_val_34111 === (2))){
var state_34110__$1 = state_34110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34110__$1,(4),ch);
} else {
if((state_val_34111 === (11))){
var inst_34100 = (state_34110[(2)]);
var state_34110__$1 = state_34110;
var statearr_34119_34142 = state_34110__$1;
(statearr_34119_34142[(2)] = inst_34100);

(statearr_34119_34142[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34111 === (9))){
var state_34110__$1 = state_34110;
var statearr_34120_34143 = state_34110__$1;
(statearr_34120_34143[(2)] = null);

(statearr_34120_34143[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34111 === (5))){
var inst_34095 = cljs.core.async.close_BANG_(out);
var state_34110__$1 = state_34110;
var statearr_34121_34144 = state_34110__$1;
(statearr_34121_34144[(2)] = inst_34095);

(statearr_34121_34144[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34111 === (10))){
var inst_34103 = (state_34110[(2)]);
var state_34110__$1 = (function (){var statearr_34122 = state_34110;
(statearr_34122[(8)] = inst_34103);

return statearr_34122;
})();
var statearr_34123_34145 = state_34110__$1;
(statearr_34123_34145[(2)] = null);

(statearr_34123_34145[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34111 === (8))){
var inst_34092 = (state_34110[(7)]);
var state_34110__$1 = state_34110;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34110__$1,(11),out,inst_34092);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___34135,out))
;
return ((function (switch__19180__auto__,c__19292__auto___34135,out){
return (function() {
var cljs$core$async$state_machine__19181__auto__ = null;
var cljs$core$async$state_machine__19181__auto____0 = (function (){
var statearr_34127 = [null,null,null,null,null,null,null,null,null];
(statearr_34127[(0)] = cljs$core$async$state_machine__19181__auto__);

(statearr_34127[(1)] = (1));

return statearr_34127;
});
var cljs$core$async$state_machine__19181__auto____1 = (function (state_34110){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_34110);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e34128){if((e34128 instanceof Object)){
var ex__19184__auto__ = e34128;
var statearr_34129_34146 = state_34110;
(statearr_34129_34146[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34110);

return cljs.core.cst$kw$recur;
} else {
throw e34128;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__34147 = state_34110;
state_34110 = G__34147;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$state_machine__19181__auto__ = function(state_34110){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19181__auto____1.call(this,state_34110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19181__auto____0;
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19181__auto____1;
return cljs$core$async$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___34135,out))
})();
var state__19294__auto__ = (function (){var statearr_34130 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_34130[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___34135);

return statearr_34130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___34135,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args34148 = [];
var len__7651__auto___34151 = arguments.length;
var i__7652__auto___34152 = (0);
while(true){
if((i__7652__auto___34152 < len__7651__auto___34151)){
args34148.push((arguments[i__7652__auto___34152]));

var G__34153 = (i__7652__auto___34152 + (1));
i__7652__auto___34152 = G__34153;
continue;
} else {
}
break;
}

var G__34150 = args34148.length;
switch (G__34150) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34148.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__19292__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto__){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto__){
return (function (state_34320){
var state_val_34321 = (state_34320[(1)]);
if((state_val_34321 === (7))){
var inst_34316 = (state_34320[(2)]);
var state_34320__$1 = state_34320;
var statearr_34322_34363 = state_34320__$1;
(statearr_34322_34363[(2)] = inst_34316);

(statearr_34322_34363[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (20))){
var inst_34286 = (state_34320[(7)]);
var inst_34297 = (state_34320[(2)]);
var inst_34298 = cljs.core.next(inst_34286);
var inst_34272 = inst_34298;
var inst_34273 = null;
var inst_34274 = (0);
var inst_34275 = (0);
var state_34320__$1 = (function (){var statearr_34323 = state_34320;
(statearr_34323[(8)] = inst_34274);

(statearr_34323[(9)] = inst_34275);

(statearr_34323[(10)] = inst_34297);

(statearr_34323[(11)] = inst_34272);

(statearr_34323[(12)] = inst_34273);

return statearr_34323;
})();
var statearr_34324_34364 = state_34320__$1;
(statearr_34324_34364[(2)] = null);

(statearr_34324_34364[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (1))){
var state_34320__$1 = state_34320;
var statearr_34325_34365 = state_34320__$1;
(statearr_34325_34365[(2)] = null);

(statearr_34325_34365[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (4))){
var inst_34261 = (state_34320[(13)]);
var inst_34261__$1 = (state_34320[(2)]);
var inst_34262 = (inst_34261__$1 == null);
var state_34320__$1 = (function (){var statearr_34326 = state_34320;
(statearr_34326[(13)] = inst_34261__$1);

return statearr_34326;
})();
if(cljs.core.truth_(inst_34262)){
var statearr_34327_34366 = state_34320__$1;
(statearr_34327_34366[(1)] = (5));

} else {
var statearr_34328_34367 = state_34320__$1;
(statearr_34328_34367[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (15))){
var state_34320__$1 = state_34320;
var statearr_34332_34368 = state_34320__$1;
(statearr_34332_34368[(2)] = null);

(statearr_34332_34368[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (21))){
var state_34320__$1 = state_34320;
var statearr_34333_34369 = state_34320__$1;
(statearr_34333_34369[(2)] = null);

(statearr_34333_34369[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (13))){
var inst_34274 = (state_34320[(8)]);
var inst_34275 = (state_34320[(9)]);
var inst_34272 = (state_34320[(11)]);
var inst_34273 = (state_34320[(12)]);
var inst_34282 = (state_34320[(2)]);
var inst_34283 = (inst_34275 + (1));
var tmp34329 = inst_34274;
var tmp34330 = inst_34272;
var tmp34331 = inst_34273;
var inst_34272__$1 = tmp34330;
var inst_34273__$1 = tmp34331;
var inst_34274__$1 = tmp34329;
var inst_34275__$1 = inst_34283;
var state_34320__$1 = (function (){var statearr_34334 = state_34320;
(statearr_34334[(8)] = inst_34274__$1);

(statearr_34334[(9)] = inst_34275__$1);

(statearr_34334[(11)] = inst_34272__$1);

(statearr_34334[(12)] = inst_34273__$1);

(statearr_34334[(14)] = inst_34282);

return statearr_34334;
})();
var statearr_34335_34370 = state_34320__$1;
(statearr_34335_34370[(2)] = null);

(statearr_34335_34370[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (22))){
var state_34320__$1 = state_34320;
var statearr_34336_34371 = state_34320__$1;
(statearr_34336_34371[(2)] = null);

(statearr_34336_34371[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (6))){
var inst_34261 = (state_34320[(13)]);
var inst_34270 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34261) : f.call(null,inst_34261));
var inst_34271 = cljs.core.seq(inst_34270);
var inst_34272 = inst_34271;
var inst_34273 = null;
var inst_34274 = (0);
var inst_34275 = (0);
var state_34320__$1 = (function (){var statearr_34337 = state_34320;
(statearr_34337[(8)] = inst_34274);

(statearr_34337[(9)] = inst_34275);

(statearr_34337[(11)] = inst_34272);

(statearr_34337[(12)] = inst_34273);

return statearr_34337;
})();
var statearr_34338_34372 = state_34320__$1;
(statearr_34338_34372[(2)] = null);

(statearr_34338_34372[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (17))){
var inst_34286 = (state_34320[(7)]);
var inst_34290 = cljs.core.chunk_first(inst_34286);
var inst_34291 = cljs.core.chunk_rest(inst_34286);
var inst_34292 = cljs.core.count(inst_34290);
var inst_34272 = inst_34291;
var inst_34273 = inst_34290;
var inst_34274 = inst_34292;
var inst_34275 = (0);
var state_34320__$1 = (function (){var statearr_34339 = state_34320;
(statearr_34339[(8)] = inst_34274);

(statearr_34339[(9)] = inst_34275);

(statearr_34339[(11)] = inst_34272);

(statearr_34339[(12)] = inst_34273);

return statearr_34339;
})();
var statearr_34340_34373 = state_34320__$1;
(statearr_34340_34373[(2)] = null);

(statearr_34340_34373[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (3))){
var inst_34318 = (state_34320[(2)]);
var state_34320__$1 = state_34320;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34320__$1,inst_34318);
} else {
if((state_val_34321 === (12))){
var inst_34306 = (state_34320[(2)]);
var state_34320__$1 = state_34320;
var statearr_34341_34374 = state_34320__$1;
(statearr_34341_34374[(2)] = inst_34306);

(statearr_34341_34374[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (2))){
var state_34320__$1 = state_34320;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34320__$1,(4),in$);
} else {
if((state_val_34321 === (23))){
var inst_34314 = (state_34320[(2)]);
var state_34320__$1 = state_34320;
var statearr_34342_34375 = state_34320__$1;
(statearr_34342_34375[(2)] = inst_34314);

(statearr_34342_34375[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (19))){
var inst_34301 = (state_34320[(2)]);
var state_34320__$1 = state_34320;
var statearr_34343_34376 = state_34320__$1;
(statearr_34343_34376[(2)] = inst_34301);

(statearr_34343_34376[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (11))){
var inst_34286 = (state_34320[(7)]);
var inst_34272 = (state_34320[(11)]);
var inst_34286__$1 = cljs.core.seq(inst_34272);
var state_34320__$1 = (function (){var statearr_34344 = state_34320;
(statearr_34344[(7)] = inst_34286__$1);

return statearr_34344;
})();
if(inst_34286__$1){
var statearr_34345_34377 = state_34320__$1;
(statearr_34345_34377[(1)] = (14));

} else {
var statearr_34346_34378 = state_34320__$1;
(statearr_34346_34378[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (9))){
var inst_34308 = (state_34320[(2)]);
var inst_34309 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_34320__$1 = (function (){var statearr_34347 = state_34320;
(statearr_34347[(15)] = inst_34308);

return statearr_34347;
})();
if(cljs.core.truth_(inst_34309)){
var statearr_34348_34379 = state_34320__$1;
(statearr_34348_34379[(1)] = (21));

} else {
var statearr_34349_34380 = state_34320__$1;
(statearr_34349_34380[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (5))){
var inst_34264 = cljs.core.async.close_BANG_(out);
var state_34320__$1 = state_34320;
var statearr_34350_34381 = state_34320__$1;
(statearr_34350_34381[(2)] = inst_34264);

(statearr_34350_34381[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (14))){
var inst_34286 = (state_34320[(7)]);
var inst_34288 = cljs.core.chunked_seq_QMARK_(inst_34286);
var state_34320__$1 = state_34320;
if(inst_34288){
var statearr_34351_34382 = state_34320__$1;
(statearr_34351_34382[(1)] = (17));

} else {
var statearr_34352_34383 = state_34320__$1;
(statearr_34352_34383[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (16))){
var inst_34304 = (state_34320[(2)]);
var state_34320__$1 = state_34320;
var statearr_34353_34384 = state_34320__$1;
(statearr_34353_34384[(2)] = inst_34304);

(statearr_34353_34384[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34321 === (10))){
var inst_34275 = (state_34320[(9)]);
var inst_34273 = (state_34320[(12)]);
var inst_34280 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_34273,inst_34275);
var state_34320__$1 = state_34320;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34320__$1,(13),out,inst_34280);
} else {
if((state_val_34321 === (18))){
var inst_34286 = (state_34320[(7)]);
var inst_34295 = cljs.core.first(inst_34286);
var state_34320__$1 = state_34320;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34320__$1,(20),out,inst_34295);
} else {
if((state_val_34321 === (8))){
var inst_34274 = (state_34320[(8)]);
var inst_34275 = (state_34320[(9)]);
var inst_34277 = (inst_34275 < inst_34274);
var inst_34278 = inst_34277;
var state_34320__$1 = state_34320;
if(cljs.core.truth_(inst_34278)){
var statearr_34354_34385 = state_34320__$1;
(statearr_34354_34385[(1)] = (10));

} else {
var statearr_34355_34386 = state_34320__$1;
(statearr_34355_34386[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto__))
;
return ((function (switch__19180__auto__,c__19292__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__19181__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__19181__auto____0 = (function (){
var statearr_34359 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34359[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__19181__auto__);

(statearr_34359[(1)] = (1));

return statearr_34359;
});
var cljs$core$async$mapcat_STAR__$_state_machine__19181__auto____1 = (function (state_34320){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_34320);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e34360){if((e34360 instanceof Object)){
var ex__19184__auto__ = e34360;
var statearr_34361_34387 = state_34320;
(statearr_34361_34387[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34320);

return cljs.core.cst$kw$recur;
} else {
throw e34360;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__34388 = state_34320;
state_34320 = G__34388;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__19181__auto__ = function(state_34320){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__19181__auto____1.call(this,state_34320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__19181__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__19181__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto__))
})();
var state__19294__auto__ = (function (){var statearr_34362 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_34362[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto__);

return statearr_34362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto__))
);

return c__19292__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args34389 = [];
var len__7651__auto___34392 = arguments.length;
var i__7652__auto___34393 = (0);
while(true){
if((i__7652__auto___34393 < len__7651__auto___34392)){
args34389.push((arguments[i__7652__auto___34393]));

var G__34394 = (i__7652__auto___34393 + (1));
i__7652__auto___34393 = G__34394;
continue;
} else {
}
break;
}

var G__34391 = args34389.length;
switch (G__34391) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34389.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args34396 = [];
var len__7651__auto___34399 = arguments.length;
var i__7652__auto___34400 = (0);
while(true){
if((i__7652__auto___34400 < len__7651__auto___34399)){
args34396.push((arguments[i__7652__auto___34400]));

var G__34401 = (i__7652__auto___34400 + (1));
i__7652__auto___34400 = G__34401;
continue;
} else {
}
break;
}

var G__34398 = args34396.length;
switch (G__34398) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34396.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args34403 = [];
var len__7651__auto___34454 = arguments.length;
var i__7652__auto___34455 = (0);
while(true){
if((i__7652__auto___34455 < len__7651__auto___34454)){
args34403.push((arguments[i__7652__auto___34455]));

var G__34456 = (i__7652__auto___34455 + (1));
i__7652__auto___34455 = G__34456;
continue;
} else {
}
break;
}

var G__34405 = args34403.length;
switch (G__34405) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34403.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19292__auto___34458 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___34458,out){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___34458,out){
return (function (state_34429){
var state_val_34430 = (state_34429[(1)]);
if((state_val_34430 === (7))){
var inst_34424 = (state_34429[(2)]);
var state_34429__$1 = state_34429;
var statearr_34431_34459 = state_34429__$1;
(statearr_34431_34459[(2)] = inst_34424);

(statearr_34431_34459[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34430 === (1))){
var inst_34406 = null;
var state_34429__$1 = (function (){var statearr_34432 = state_34429;
(statearr_34432[(7)] = inst_34406);

return statearr_34432;
})();
var statearr_34433_34460 = state_34429__$1;
(statearr_34433_34460[(2)] = null);

(statearr_34433_34460[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34430 === (4))){
var inst_34409 = (state_34429[(8)]);
var inst_34409__$1 = (state_34429[(2)]);
var inst_34410 = (inst_34409__$1 == null);
var inst_34411 = cljs.core.not(inst_34410);
var state_34429__$1 = (function (){var statearr_34434 = state_34429;
(statearr_34434[(8)] = inst_34409__$1);

return statearr_34434;
})();
if(inst_34411){
var statearr_34435_34461 = state_34429__$1;
(statearr_34435_34461[(1)] = (5));

} else {
var statearr_34436_34462 = state_34429__$1;
(statearr_34436_34462[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34430 === (6))){
var state_34429__$1 = state_34429;
var statearr_34437_34463 = state_34429__$1;
(statearr_34437_34463[(2)] = null);

(statearr_34437_34463[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34430 === (3))){
var inst_34426 = (state_34429[(2)]);
var inst_34427 = cljs.core.async.close_BANG_(out);
var state_34429__$1 = (function (){var statearr_34438 = state_34429;
(statearr_34438[(9)] = inst_34426);

return statearr_34438;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34429__$1,inst_34427);
} else {
if((state_val_34430 === (2))){
var state_34429__$1 = state_34429;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34429__$1,(4),ch);
} else {
if((state_val_34430 === (11))){
var inst_34409 = (state_34429[(8)]);
var inst_34418 = (state_34429[(2)]);
var inst_34406 = inst_34409;
var state_34429__$1 = (function (){var statearr_34439 = state_34429;
(statearr_34439[(10)] = inst_34418);

(statearr_34439[(7)] = inst_34406);

return statearr_34439;
})();
var statearr_34440_34464 = state_34429__$1;
(statearr_34440_34464[(2)] = null);

(statearr_34440_34464[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34430 === (9))){
var inst_34409 = (state_34429[(8)]);
var state_34429__$1 = state_34429;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34429__$1,(11),out,inst_34409);
} else {
if((state_val_34430 === (5))){
var inst_34409 = (state_34429[(8)]);
var inst_34406 = (state_34429[(7)]);
var inst_34413 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34409,inst_34406);
var state_34429__$1 = state_34429;
if(inst_34413){
var statearr_34442_34465 = state_34429__$1;
(statearr_34442_34465[(1)] = (8));

} else {
var statearr_34443_34466 = state_34429__$1;
(statearr_34443_34466[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34430 === (10))){
var inst_34421 = (state_34429[(2)]);
var state_34429__$1 = state_34429;
var statearr_34444_34467 = state_34429__$1;
(statearr_34444_34467[(2)] = inst_34421);

(statearr_34444_34467[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34430 === (8))){
var inst_34406 = (state_34429[(7)]);
var tmp34441 = inst_34406;
var inst_34406__$1 = tmp34441;
var state_34429__$1 = (function (){var statearr_34445 = state_34429;
(statearr_34445[(7)] = inst_34406__$1);

return statearr_34445;
})();
var statearr_34446_34468 = state_34429__$1;
(statearr_34446_34468[(2)] = null);

(statearr_34446_34468[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___34458,out))
;
return ((function (switch__19180__auto__,c__19292__auto___34458,out){
return (function() {
var cljs$core$async$state_machine__19181__auto__ = null;
var cljs$core$async$state_machine__19181__auto____0 = (function (){
var statearr_34450 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34450[(0)] = cljs$core$async$state_machine__19181__auto__);

(statearr_34450[(1)] = (1));

return statearr_34450;
});
var cljs$core$async$state_machine__19181__auto____1 = (function (state_34429){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_34429);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e34451){if((e34451 instanceof Object)){
var ex__19184__auto__ = e34451;
var statearr_34452_34469 = state_34429;
(statearr_34452_34469[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34429);

return cljs.core.cst$kw$recur;
} else {
throw e34451;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__34470 = state_34429;
state_34429 = G__34470;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$state_machine__19181__auto__ = function(state_34429){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19181__auto____1.call(this,state_34429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19181__auto____0;
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19181__auto____1;
return cljs$core$async$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___34458,out))
})();
var state__19294__auto__ = (function (){var statearr_34453 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_34453[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___34458);

return statearr_34453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___34458,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args34471 = [];
var len__7651__auto___34541 = arguments.length;
var i__7652__auto___34542 = (0);
while(true){
if((i__7652__auto___34542 < len__7651__auto___34541)){
args34471.push((arguments[i__7652__auto___34542]));

var G__34543 = (i__7652__auto___34542 + (1));
i__7652__auto___34542 = G__34543;
continue;
} else {
}
break;
}

var G__34473 = args34471.length;
switch (G__34473) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34471.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19292__auto___34545 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___34545,out){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___34545,out){
return (function (state_34511){
var state_val_34512 = (state_34511[(1)]);
if((state_val_34512 === (7))){
var inst_34507 = (state_34511[(2)]);
var state_34511__$1 = state_34511;
var statearr_34513_34546 = state_34511__$1;
(statearr_34513_34546[(2)] = inst_34507);

(statearr_34513_34546[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34512 === (1))){
var inst_34474 = (new Array(n));
var inst_34475 = inst_34474;
var inst_34476 = (0);
var state_34511__$1 = (function (){var statearr_34514 = state_34511;
(statearr_34514[(7)] = inst_34475);

(statearr_34514[(8)] = inst_34476);

return statearr_34514;
})();
var statearr_34515_34547 = state_34511__$1;
(statearr_34515_34547[(2)] = null);

(statearr_34515_34547[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34512 === (4))){
var inst_34479 = (state_34511[(9)]);
var inst_34479__$1 = (state_34511[(2)]);
var inst_34480 = (inst_34479__$1 == null);
var inst_34481 = cljs.core.not(inst_34480);
var state_34511__$1 = (function (){var statearr_34516 = state_34511;
(statearr_34516[(9)] = inst_34479__$1);

return statearr_34516;
})();
if(inst_34481){
var statearr_34517_34548 = state_34511__$1;
(statearr_34517_34548[(1)] = (5));

} else {
var statearr_34518_34549 = state_34511__$1;
(statearr_34518_34549[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34512 === (15))){
var inst_34501 = (state_34511[(2)]);
var state_34511__$1 = state_34511;
var statearr_34519_34550 = state_34511__$1;
(statearr_34519_34550[(2)] = inst_34501);

(statearr_34519_34550[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34512 === (13))){
var state_34511__$1 = state_34511;
var statearr_34520_34551 = state_34511__$1;
(statearr_34520_34551[(2)] = null);

(statearr_34520_34551[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34512 === (6))){
var inst_34476 = (state_34511[(8)]);
var inst_34497 = (inst_34476 > (0));
var state_34511__$1 = state_34511;
if(cljs.core.truth_(inst_34497)){
var statearr_34521_34552 = state_34511__$1;
(statearr_34521_34552[(1)] = (12));

} else {
var statearr_34522_34553 = state_34511__$1;
(statearr_34522_34553[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34512 === (3))){
var inst_34509 = (state_34511[(2)]);
var state_34511__$1 = state_34511;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34511__$1,inst_34509);
} else {
if((state_val_34512 === (12))){
var inst_34475 = (state_34511[(7)]);
var inst_34499 = cljs.core.vec(inst_34475);
var state_34511__$1 = state_34511;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34511__$1,(15),out,inst_34499);
} else {
if((state_val_34512 === (2))){
var state_34511__$1 = state_34511;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34511__$1,(4),ch);
} else {
if((state_val_34512 === (11))){
var inst_34491 = (state_34511[(2)]);
var inst_34492 = (new Array(n));
var inst_34475 = inst_34492;
var inst_34476 = (0);
var state_34511__$1 = (function (){var statearr_34523 = state_34511;
(statearr_34523[(7)] = inst_34475);

(statearr_34523[(8)] = inst_34476);

(statearr_34523[(10)] = inst_34491);

return statearr_34523;
})();
var statearr_34524_34554 = state_34511__$1;
(statearr_34524_34554[(2)] = null);

(statearr_34524_34554[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34512 === (9))){
var inst_34475 = (state_34511[(7)]);
var inst_34489 = cljs.core.vec(inst_34475);
var state_34511__$1 = state_34511;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34511__$1,(11),out,inst_34489);
} else {
if((state_val_34512 === (5))){
var inst_34475 = (state_34511[(7)]);
var inst_34476 = (state_34511[(8)]);
var inst_34484 = (state_34511[(11)]);
var inst_34479 = (state_34511[(9)]);
var inst_34483 = (inst_34475[inst_34476] = inst_34479);
var inst_34484__$1 = (inst_34476 + (1));
var inst_34485 = (inst_34484__$1 < n);
var state_34511__$1 = (function (){var statearr_34525 = state_34511;
(statearr_34525[(11)] = inst_34484__$1);

(statearr_34525[(12)] = inst_34483);

return statearr_34525;
})();
if(cljs.core.truth_(inst_34485)){
var statearr_34526_34555 = state_34511__$1;
(statearr_34526_34555[(1)] = (8));

} else {
var statearr_34527_34556 = state_34511__$1;
(statearr_34527_34556[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34512 === (14))){
var inst_34504 = (state_34511[(2)]);
var inst_34505 = cljs.core.async.close_BANG_(out);
var state_34511__$1 = (function (){var statearr_34529 = state_34511;
(statearr_34529[(13)] = inst_34504);

return statearr_34529;
})();
var statearr_34530_34557 = state_34511__$1;
(statearr_34530_34557[(2)] = inst_34505);

(statearr_34530_34557[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34512 === (10))){
var inst_34495 = (state_34511[(2)]);
var state_34511__$1 = state_34511;
var statearr_34531_34558 = state_34511__$1;
(statearr_34531_34558[(2)] = inst_34495);

(statearr_34531_34558[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34512 === (8))){
var inst_34475 = (state_34511[(7)]);
var inst_34484 = (state_34511[(11)]);
var tmp34528 = inst_34475;
var inst_34475__$1 = tmp34528;
var inst_34476 = inst_34484;
var state_34511__$1 = (function (){var statearr_34532 = state_34511;
(statearr_34532[(7)] = inst_34475__$1);

(statearr_34532[(8)] = inst_34476);

return statearr_34532;
})();
var statearr_34533_34559 = state_34511__$1;
(statearr_34533_34559[(2)] = null);

(statearr_34533_34559[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___34545,out))
;
return ((function (switch__19180__auto__,c__19292__auto___34545,out){
return (function() {
var cljs$core$async$state_machine__19181__auto__ = null;
var cljs$core$async$state_machine__19181__auto____0 = (function (){
var statearr_34537 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34537[(0)] = cljs$core$async$state_machine__19181__auto__);

(statearr_34537[(1)] = (1));

return statearr_34537;
});
var cljs$core$async$state_machine__19181__auto____1 = (function (state_34511){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_34511);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e34538){if((e34538 instanceof Object)){
var ex__19184__auto__ = e34538;
var statearr_34539_34560 = state_34511;
(statearr_34539_34560[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34511);

return cljs.core.cst$kw$recur;
} else {
throw e34538;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__34561 = state_34511;
state_34511 = G__34561;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$state_machine__19181__auto__ = function(state_34511){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19181__auto____1.call(this,state_34511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19181__auto____0;
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19181__auto____1;
return cljs$core$async$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___34545,out))
})();
var state__19294__auto__ = (function (){var statearr_34540 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_34540[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___34545);

return statearr_34540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___34545,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args34562 = [];
var len__7651__auto___34636 = arguments.length;
var i__7652__auto___34637 = (0);
while(true){
if((i__7652__auto___34637 < len__7651__auto___34636)){
args34562.push((arguments[i__7652__auto___34637]));

var G__34638 = (i__7652__auto___34637 + (1));
i__7652__auto___34637 = G__34638;
continue;
} else {
}
break;
}

var G__34564 = args34562.length;
switch (G__34564) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34562.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__19292__auto___34640 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19292__auto___34640,out){
return (function (){
var f__19293__auto__ = (function (){var switch__19180__auto__ = ((function (c__19292__auto___34640,out){
return (function (state_34606){
var state_val_34607 = (state_34606[(1)]);
if((state_val_34607 === (7))){
var inst_34602 = (state_34606[(2)]);
var state_34606__$1 = state_34606;
var statearr_34608_34641 = state_34606__$1;
(statearr_34608_34641[(2)] = inst_34602);

(statearr_34608_34641[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34607 === (1))){
var inst_34565 = [];
var inst_34566 = inst_34565;
var inst_34567 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_34606__$1 = (function (){var statearr_34609 = state_34606;
(statearr_34609[(7)] = inst_34567);

(statearr_34609[(8)] = inst_34566);

return statearr_34609;
})();
var statearr_34610_34642 = state_34606__$1;
(statearr_34610_34642[(2)] = null);

(statearr_34610_34642[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34607 === (4))){
var inst_34570 = (state_34606[(9)]);
var inst_34570__$1 = (state_34606[(2)]);
var inst_34571 = (inst_34570__$1 == null);
var inst_34572 = cljs.core.not(inst_34571);
var state_34606__$1 = (function (){var statearr_34611 = state_34606;
(statearr_34611[(9)] = inst_34570__$1);

return statearr_34611;
})();
if(inst_34572){
var statearr_34612_34643 = state_34606__$1;
(statearr_34612_34643[(1)] = (5));

} else {
var statearr_34613_34644 = state_34606__$1;
(statearr_34613_34644[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34607 === (15))){
var inst_34596 = (state_34606[(2)]);
var state_34606__$1 = state_34606;
var statearr_34614_34645 = state_34606__$1;
(statearr_34614_34645[(2)] = inst_34596);

(statearr_34614_34645[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34607 === (13))){
var state_34606__$1 = state_34606;
var statearr_34615_34646 = state_34606__$1;
(statearr_34615_34646[(2)] = null);

(statearr_34615_34646[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34607 === (6))){
var inst_34566 = (state_34606[(8)]);
var inst_34591 = inst_34566.length;
var inst_34592 = (inst_34591 > (0));
var state_34606__$1 = state_34606;
if(cljs.core.truth_(inst_34592)){
var statearr_34616_34647 = state_34606__$1;
(statearr_34616_34647[(1)] = (12));

} else {
var statearr_34617_34648 = state_34606__$1;
(statearr_34617_34648[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34607 === (3))){
var inst_34604 = (state_34606[(2)]);
var state_34606__$1 = state_34606;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34606__$1,inst_34604);
} else {
if((state_val_34607 === (12))){
var inst_34566 = (state_34606[(8)]);
var inst_34594 = cljs.core.vec(inst_34566);
var state_34606__$1 = state_34606;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34606__$1,(15),out,inst_34594);
} else {
if((state_val_34607 === (2))){
var state_34606__$1 = state_34606;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34606__$1,(4),ch);
} else {
if((state_val_34607 === (11))){
var inst_34574 = (state_34606[(10)]);
var inst_34570 = (state_34606[(9)]);
var inst_34584 = (state_34606[(2)]);
var inst_34585 = [];
var inst_34586 = inst_34585.push(inst_34570);
var inst_34566 = inst_34585;
var inst_34567 = inst_34574;
var state_34606__$1 = (function (){var statearr_34618 = state_34606;
(statearr_34618[(7)] = inst_34567);

(statearr_34618[(11)] = inst_34584);

(statearr_34618[(12)] = inst_34586);

(statearr_34618[(8)] = inst_34566);

return statearr_34618;
})();
var statearr_34619_34649 = state_34606__$1;
(statearr_34619_34649[(2)] = null);

(statearr_34619_34649[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34607 === (9))){
var inst_34566 = (state_34606[(8)]);
var inst_34582 = cljs.core.vec(inst_34566);
var state_34606__$1 = state_34606;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_34606__$1,(11),out,inst_34582);
} else {
if((state_val_34607 === (5))){
var inst_34567 = (state_34606[(7)]);
var inst_34574 = (state_34606[(10)]);
var inst_34570 = (state_34606[(9)]);
var inst_34574__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_34570) : f.call(null,inst_34570));
var inst_34575 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34574__$1,inst_34567);
var inst_34576 = cljs.core.keyword_identical_QMARK_(inst_34567,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_34577 = (inst_34575) || (inst_34576);
var state_34606__$1 = (function (){var statearr_34620 = state_34606;
(statearr_34620[(10)] = inst_34574__$1);

return statearr_34620;
})();
if(cljs.core.truth_(inst_34577)){
var statearr_34621_34650 = state_34606__$1;
(statearr_34621_34650[(1)] = (8));

} else {
var statearr_34622_34651 = state_34606__$1;
(statearr_34622_34651[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34607 === (14))){
var inst_34599 = (state_34606[(2)]);
var inst_34600 = cljs.core.async.close_BANG_(out);
var state_34606__$1 = (function (){var statearr_34624 = state_34606;
(statearr_34624[(13)] = inst_34599);

return statearr_34624;
})();
var statearr_34625_34652 = state_34606__$1;
(statearr_34625_34652[(2)] = inst_34600);

(statearr_34625_34652[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34607 === (10))){
var inst_34589 = (state_34606[(2)]);
var state_34606__$1 = state_34606;
var statearr_34626_34653 = state_34606__$1;
(statearr_34626_34653[(2)] = inst_34589);

(statearr_34626_34653[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34607 === (8))){
var inst_34574 = (state_34606[(10)]);
var inst_34570 = (state_34606[(9)]);
var inst_34566 = (state_34606[(8)]);
var inst_34579 = inst_34566.push(inst_34570);
var tmp34623 = inst_34566;
var inst_34566__$1 = tmp34623;
var inst_34567 = inst_34574;
var state_34606__$1 = (function (){var statearr_34627 = state_34606;
(statearr_34627[(7)] = inst_34567);

(statearr_34627[(14)] = inst_34579);

(statearr_34627[(8)] = inst_34566__$1);

return statearr_34627;
})();
var statearr_34628_34654 = state_34606__$1;
(statearr_34628_34654[(2)] = null);

(statearr_34628_34654[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19292__auto___34640,out))
;
return ((function (switch__19180__auto__,c__19292__auto___34640,out){
return (function() {
var cljs$core$async$state_machine__19181__auto__ = null;
var cljs$core$async$state_machine__19181__auto____0 = (function (){
var statearr_34632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34632[(0)] = cljs$core$async$state_machine__19181__auto__);

(statearr_34632[(1)] = (1));

return statearr_34632;
});
var cljs$core$async$state_machine__19181__auto____1 = (function (state_34606){
while(true){
var ret_value__19182__auto__ = (function (){try{while(true){
var result__19183__auto__ = switch__19180__auto__(state_34606);
if(cljs.core.keyword_identical_QMARK_(result__19183__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19183__auto__;
}
break;
}
}catch (e34633){if((e34633 instanceof Object)){
var ex__19184__auto__ = e34633;
var statearr_34634_34655 = state_34606;
(statearr_34634_34655[(5)] = ex__19184__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_34606);

return cljs.core.cst$kw$recur;
} else {
throw e34633;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19182__auto__,cljs.core.cst$kw$recur)){
var G__34656 = state_34606;
state_34606 = G__34656;
continue;
} else {
return ret_value__19182__auto__;
}
break;
}
});
cljs$core$async$state_machine__19181__auto__ = function(state_34606){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__19181__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__19181__auto____1.call(this,state_34606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__19181__auto____0;
cljs$core$async$state_machine__19181__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__19181__auto____1;
return cljs$core$async$state_machine__19181__auto__;
})()
;})(switch__19180__auto__,c__19292__auto___34640,out))
})();
var state__19294__auto__ = (function (){var statearr_34635 = (f__19293__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19293__auto__.cljs$core$IFn$_invoke$arity$0() : f__19293__auto__.call(null));
(statearr_34635[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19292__auto___34640);

return statearr_34635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19294__auto__);
});})(c__19292__auto___34640,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

