// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('chimera.string');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.dataset');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.export_pending_status_msg = "PENDING";
milia.api.async_export.initial_polling_interval = (5000);
/**
 * If a temp-token is set, add it as a query string parameter. The caller needs
 * to explicity pass a question-mark or ampersand depending on whether this is
 * the first or a subsequenty query parameter.
 */
milia.api.async_export.temp_token_suffix = (function milia$api$async_export$temp_token_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31761 = arguments.length;
var i__7652__auto___31762 = (0);
while(true){
if((i__7652__auto___31762 < len__7651__auto___31761)){
args__7658__auto__.push((arguments[i__7652__auto___31762]));

var G__31763 = (i__7652__auto___31762 + (1));
i__7652__auto___31762 = G__31763;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (s){
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return clojure.string.join.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_((chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token)))?cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.vec(s),"temp_token=",cljs.core.array_seq([temp_token], 0)):s));
});

milia.api.async_export.temp_token_suffix.cljs$lang$maxFixedArity = (0);

milia.api.async_export.temp_token_suffix.cljs$lang$applyTo = (function (seq31760){
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31760));
});

/**
 * Handles API server's response and acts according to given callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__31764,p__31765){
var map__31774 = p__31764;
var map__31774__$1 = ((((!((map__31774 == null)))?((((map__31774.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31774.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31774):map__31774);
var response = map__31774__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31774__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31774__$1,cljs.core.cst$kw$body);
var map__31775 = p__31765;
var map__31775__$1 = ((((!((map__31775 == null)))?((((map__31775.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31775.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31775):map__31775);
var callbacks = map__31775__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31775__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31775__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31775__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31775__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__31778 = body;
var map__31778__$1 = ((((!((map__31778 == null)))?((((map__31778.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31778.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31778):map__31778);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31778__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31778__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31778__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = ((function (map__31778,map__31778__$1,export_url,job_status,job_id,map__31774,map__31774__$1,response,status,body,map__31775,map__31775__$1,callbacks,on_error,on_export_url,on_job_id,on_stop){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});})(map__31778,map__31778__$1,export_url,job_status,job_id,map__31774,map__31774__$1,response,status,body,map__31775,map__31775__$1,callbacks,on_error,on_export_url,on_job_id,on_stop))
;
var error_detail = (function (){var or__6543__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = cljs.core.cst$kw$details.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
if(cljs.core.truth_(is_failed_status_QMARK_())){
return job_status;
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}

} else {
}

if(cljs.core.truth_((function (){var or__6543__auto__ = (status >= (400));
if(or__6543__auto__){
return or__6543__auto__;
} else {
return is_failed_status_QMARK_();
}
})())){
if(cljs.core.fn_QMARK_(on_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(403))){
var G__31780_31782 = error_detail;
var G__31781_31783 = cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(body);
(on_error.cljs$core$IFn$_invoke$arity$2 ? on_error.cljs$core$IFn$_invoke$arity$2(G__31780_31782,G__31781_31783) : on_error.call(null,G__31780_31782,G__31781_31783));
} else {
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
}
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 *  When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31834 = arguments.length;
var i__7652__auto___31835 = (0);
while(true){
if((i__7652__auto___31835 < len__7651__auto___31834)){
args__7658__auto__.push((arguments[i__7652__auto___31835]));

var G__31836 = (i__7652__auto___31835 + (1));
i__7652__auto___31835 = G__31836;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__31787){
var map__31788 = p__31787;
var map__31788__$1 = ((((!((map__31788 == null)))?((((map__31788.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31788.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31788):map__31788);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31788__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31788__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31788__$1,cljs.core.cst$kw$data_DASH_type);
var c__19179__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19179__auto__,map__31788,map__31788__$1,on_error,on_export_url,data_type){
return (function (){
var f__19180__auto__ = (function (){var switch__19067__auto__ = ((function (c__19179__auto__,map__31788,map__31788__$1,on_error,on_export_url,data_type){
return (function (state_31816){
var state_val_31817 = (state_31816[(1)]);
if((state_val_31817 === (1))){
var inst_31790 = milia.api.async_export.initial_polling_interval;
var state_31816__$1 = (function (){var statearr_31818 = state_31816;
(statearr_31818[(7)] = inst_31790);

return statearr_31818;
})();
var statearr_31819_31837 = state_31816__$1;
(statearr_31819_31837[(2)] = null);

(statearr_31819_31837[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31817 === (2))){
var inst_31794 = (state_31816[(8)]);
var inst_31792 = (state_31816[(9)]);
var inst_31792__$1 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var inst_31793 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_31794__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_31793,dataset_id,inst_31792__$1], 0));
var inst_31795 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_31794__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_31816__$1 = (function (){var statearr_31820 = state_31816;
(statearr_31820[(8)] = inst_31794__$1);

(statearr_31820[(9)] = inst_31792__$1);

return statearr_31820;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31816__$1,(4),inst_31795);
} else {
if((state_val_31817 === (3))){
var inst_31814 = (state_31816[(2)]);
var state_31816__$1 = state_31816;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31816__$1,inst_31814);
} else {
if((state_val_31817 === (4))){
var inst_31794 = (state_31816[(8)]);
var inst_31792 = (state_31816[(9)]);
var inst_31790 = (state_31816[(7)]);
var inst_31797 = (state_31816[(2)]);
var inst_31798 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_31799 = (function (){var polling_interval = inst_31790;
var job_suffix = inst_31792;
var job_url = inst_31794;
var response = inst_31797;
return ((function (polling_interval,job_suffix,job_url,response,inst_31794,inst_31792,inst_31790,inst_31797,inst_31798,state_val_31817,c__19179__auto__,map__31788,map__31788__$1,on_error,on_export_url,data_type){
return (function (){
return cljs.core.constantly(cljs.core.cst$kw$stop);
});
;})(polling_interval,job_suffix,job_url,response,inst_31794,inst_31792,inst_31790,inst_31797,inst_31798,state_val_31817,c__19179__auto__,map__31788,map__31788__$1,on_error,on_export_url,data_type))
})();
var inst_31800 = [inst_31799,on_error,on_export_url];
var inst_31801 = cljs.core.PersistentHashMap.fromArrays(inst_31798,inst_31800);
var inst_31802 = milia.api.async_export.handle_response(inst_31797,inst_31801);
var inst_31803 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_31802,cljs.core.cst$kw$stop);
var state_31816__$1 = state_31816;
if(inst_31803){
var statearr_31821_31838 = state_31816__$1;
(statearr_31821_31838[(1)] = (5));

} else {
var statearr_31822_31839 = state_31816__$1;
(statearr_31822_31839[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31817 === (5))){
var inst_31790 = (state_31816[(7)]);
var inst_31805 = cljs.core.async.timeout(inst_31790);
var state_31816__$1 = state_31816;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31816__$1,(8),inst_31805);
} else {
if((state_val_31817 === (6))){
var state_31816__$1 = state_31816;
var statearr_31823_31840 = state_31816__$1;
(statearr_31823_31840[(2)] = null);

(statearr_31823_31840[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31817 === (7))){
var inst_31812 = (state_31816[(2)]);
var state_31816__$1 = state_31816;
var statearr_31824_31841 = state_31816__$1;
(statearr_31824_31841[(2)] = inst_31812);

(statearr_31824_31841[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31817 === (8))){
var inst_31790 = (state_31816[(7)]);
var inst_31807 = (state_31816[(2)]);
var inst_31808 = (inst_31790 * (2));
var inst_31790__$1 = inst_31808;
var state_31816__$1 = (function (){var statearr_31825 = state_31816;
(statearr_31825[(10)] = inst_31807);

(statearr_31825[(7)] = inst_31790__$1);

return statearr_31825;
})();
var statearr_31826_31842 = state_31816__$1;
(statearr_31826_31842[(2)] = null);

(statearr_31826_31842[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19179__auto__,map__31788,map__31788__$1,on_error,on_export_url,data_type))
;
return ((function (switch__19067__auto__,c__19179__auto__,map__31788,map__31788__$1,on_error,on_export_url,data_type){
return (function() {
var milia$api$async_export$state_machine__19068__auto__ = null;
var milia$api$async_export$state_machine__19068__auto____0 = (function (){
var statearr_31830 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31830[(0)] = milia$api$async_export$state_machine__19068__auto__);

(statearr_31830[(1)] = (1));

return statearr_31830;
});
var milia$api$async_export$state_machine__19068__auto____1 = (function (state_31816){
while(true){
var ret_value__19069__auto__ = (function (){try{while(true){
var result__19070__auto__ = switch__19067__auto__(state_31816);
if(cljs.core.keyword_identical_QMARK_(result__19070__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19070__auto__;
}
break;
}
}catch (e31831){if((e31831 instanceof Object)){
var ex__19071__auto__ = e31831;
var statearr_31832_31843 = state_31816;
(statearr_31832_31843[(5)] = ex__19071__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31816);

return cljs.core.cst$kw$recur;
} else {
throw e31831;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19069__auto__,cljs.core.cst$kw$recur)){
var G__31844 = state_31816;
state_31816 = G__31844;
continue;
} else {
return ret_value__19069__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19068__auto__ = function(state_31816){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19068__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19068__auto____1.call(this,state_31816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19068__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19068__auto____0;
milia$api$async_export$state_machine__19068__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19068__auto____1;
return milia$api$async_export$state_machine__19068__auto__;
})()
;})(switch__19067__auto__,c__19179__auto__,map__31788,map__31788__$1,on_error,on_export_url,data_type))
})();
var state__19181__auto__ = (function (){var statearr_31833 = (f__19180__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19180__auto__.cljs$core$IFn$_invoke$arity$0() : f__19180__auto__.call(null));
(statearr_31833[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19179__auto__);

return statearr_31833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19181__auto__);
});})(c__19179__auto__,map__31788,map__31788__$1,on_error,on_export_url,data_type))
);

return c__19179__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq31784){
var G__31785 = cljs.core.first(seq31784);
var seq31784__$1 = cljs.core.next(seq31784);
var G__31786 = cljs.core.first(seq31784__$1);
var seq31784__$2 = cljs.core.next(seq31784__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31785,G__31786,seq31784__$2);
});

/**
 * Repeatedly polls the export endpoint given a form_id while any of the
 *    export status is pending.
 */
milia.api.async_export.monitor_async_exports_per_form_BANG_ = (function milia$api$async_export$monitor_async_exports_per_form_BANG_(dataset_id,callback){
var c__19179__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19179__auto__){
return (function (){
var f__19180__auto__ = (function (){var switch__19067__auto__ = ((function (c__19179__auto__){
return (function (state_31974){
var state_val_31975 = (state_31974[(1)]);
if((state_val_31975 === (7))){
var inst_31949 = (state_31974[(2)]);
var state_31974__$1 = state_31974;
if(cljs.core.truth_(inst_31949)){
var statearr_31976_32006 = state_31974__$1;
(statearr_31976_32006[(1)] = (11));

} else {
var statearr_31977_32007 = state_31974__$1;
(statearr_31977_32007[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31975 === (1))){
var inst_31926 = milia.api.async_export.initial_polling_interval;
var state_31974__$1 = (function (){var statearr_31978 = state_31974;
(statearr_31978[(7)] = inst_31926);

return statearr_31978;
})();
var statearr_31979_32008 = state_31974__$1;
(statearr_31979_32008[(2)] = null);

(statearr_31979_32008[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31975 === (4))){
var inst_31933 = (state_31974[(8)]);
var inst_31933__$1 = (state_31974[(2)]);
var inst_31935 = (inst_31933__$1 == null);
var inst_31936 = cljs.core.not(inst_31935);
var state_31974__$1 = (function (){var statearr_31980 = state_31974;
(statearr_31980[(8)] = inst_31933__$1);

return statearr_31980;
})();
if(inst_31936){
var statearr_31981_32009 = state_31974__$1;
(statearr_31981_32009[(1)] = (5));

} else {
var statearr_31982_32010 = state_31974__$1;
(statearr_31982_32010[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31975 === (15))){
var inst_31926 = (state_31974[(7)]);
var inst_31964 = cljs.core.async.timeout(inst_31926);
var state_31974__$1 = state_31974;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31974__$1,(17),inst_31964);
} else {
if((state_val_31975 === (13))){
var inst_31956 = (state_31974[(9)]);
var inst_31926 = (state_31974[(7)]);
var inst_31930 = (state_31974[(10)]);
var inst_31954 = (state_31974[(2)]);
var inst_31955 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31954,cljs.core.cst$kw$status);
var inst_31956__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31954,cljs.core.cst$kw$body);
var inst_31957 = (function (){var polling_interval = inst_31926;
var export_url = inst_31930;
var map__31928 = inst_31954;
var status = inst_31955;
var body = inst_31956__$1;
return ((function (polling_interval,export_url,map__31928,status,body,inst_31956,inst_31926,inst_31930,inst_31954,inst_31955,inst_31956__$1,state_val_31975,c__19179__auto__){
return (function (p1__31845_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$job_status.cljs$core$IFn$_invoke$arity$1(p1__31845_SHARP_),milia.api.async_export.export_pending_status_msg);
});
;})(polling_interval,export_url,map__31928,status,body,inst_31956,inst_31926,inst_31930,inst_31954,inst_31955,inst_31956__$1,state_val_31975,c__19179__auto__))
})();
var inst_31958 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_31957,inst_31956__$1);
var inst_31959 = cljs.core.vec(inst_31958);
var inst_31960 = cljs.core.empty_QMARK_(inst_31959);
var state_31974__$1 = (function (){var statearr_31983 = state_31974;
(statearr_31983[(9)] = inst_31956__$1);

return statearr_31983;
})();
if(inst_31960){
var statearr_31984_32011 = state_31974__$1;
(statearr_31984_32011[(1)] = (14));

} else {
var statearr_31985_32012 = state_31974__$1;
(statearr_31985_32012[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31975 === (6))){
var state_31974__$1 = state_31974;
var statearr_31986_32013 = state_31974__$1;
(statearr_31986_32013[(2)] = false);

(statearr_31986_32013[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31975 === (17))){
var inst_31926 = (state_31974[(7)]);
var inst_31966 = (state_31974[(2)]);
var inst_31967 = (inst_31926 * (2));
var inst_31926__$1 = inst_31967;
var state_31974__$1 = (function (){var statearr_31987 = state_31974;
(statearr_31987[(11)] = inst_31966);

(statearr_31987[(7)] = inst_31926__$1);

return statearr_31987;
})();
var statearr_31988_32014 = state_31974__$1;
(statearr_31988_32014[(2)] = null);

(statearr_31988_32014[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31975 === (3))){
var inst_31972 = (state_31974[(2)]);
var state_31974__$1 = state_31974;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31974__$1,inst_31972);
} else {
if((state_val_31975 === (12))){
var inst_31933 = (state_31974[(8)]);
var state_31974__$1 = state_31974;
var statearr_31989_32015 = state_31974__$1;
(statearr_31989_32015[(2)] = inst_31933);

(statearr_31989_32015[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31975 === (2))){
var inst_31930 = (state_31974[(10)]);
var inst_31929 = milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export?xform=",dataset_id,"&"], 0));
var inst_31930__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_31929], 0));
var inst_31931 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_31930__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_31974__$1 = (function (){var statearr_31990 = state_31974;
(statearr_31990[(10)] = inst_31930__$1);

return statearr_31990;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31974__$1,(4),inst_31931);
} else {
if((state_val_31975 === (11))){
var inst_31933 = (state_31974[(8)]);
var inst_31951 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31933);
var state_31974__$1 = state_31974;
var statearr_31991_32016 = state_31974__$1;
(statearr_31991_32016[(2)] = inst_31951);

(statearr_31991_32016[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31975 === (9))){
var state_31974__$1 = state_31974;
var statearr_31992_32017 = state_31974__$1;
(statearr_31992_32017[(2)] = false);

(statearr_31992_32017[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31975 === (5))){
var inst_31933 = (state_31974[(8)]);
var inst_31938 = inst_31933.cljs$lang$protocol_mask$partition0$;
var inst_31939 = (inst_31938 & (64));
var inst_31940 = inst_31933.cljs$core$ISeq$;
var inst_31941 = (cljs.core.PROTOCOL_SENTINEL === inst_31940);
var inst_31942 = (inst_31939) || (inst_31941);
var state_31974__$1 = state_31974;
if(cljs.core.truth_(inst_31942)){
var statearr_31993_32018 = state_31974__$1;
(statearr_31993_32018[(1)] = (8));

} else {
var statearr_31994_32019 = state_31974__$1;
(statearr_31994_32019[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31975 === (14))){
var inst_31956 = (state_31974[(9)]);
var inst_31962 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_31956) : callback.call(null,inst_31956));
var state_31974__$1 = state_31974;
var statearr_31995_32020 = state_31974__$1;
(statearr_31995_32020[(2)] = inst_31962);

(statearr_31995_32020[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31975 === (16))){
var inst_31970 = (state_31974[(2)]);
var state_31974__$1 = state_31974;
var statearr_31996_32021 = state_31974__$1;
(statearr_31996_32021[(2)] = inst_31970);

(statearr_31996_32021[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31975 === (10))){
var inst_31946 = (state_31974[(2)]);
var state_31974__$1 = state_31974;
var statearr_31997_32022 = state_31974__$1;
(statearr_31997_32022[(2)] = inst_31946);

(statearr_31997_32022[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31975 === (8))){
var state_31974__$1 = state_31974;
var statearr_31998_32023 = state_31974__$1;
(statearr_31998_32023[(2)] = true);

(statearr_31998_32023[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19179__auto__))
;
return ((function (switch__19067__auto__,c__19179__auto__){
return (function() {
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19068__auto__ = null;
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19068__auto____0 = (function (){
var statearr_32002 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32002[(0)] = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19068__auto__);

(statearr_32002[(1)] = (1));

return statearr_32002;
});
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19068__auto____1 = (function (state_31974){
while(true){
var ret_value__19069__auto__ = (function (){try{while(true){
var result__19070__auto__ = switch__19067__auto__(state_31974);
if(cljs.core.keyword_identical_QMARK_(result__19070__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19070__auto__;
}
break;
}
}catch (e32003){if((e32003 instanceof Object)){
var ex__19071__auto__ = e32003;
var statearr_32004_32024 = state_31974;
(statearr_32004_32024[(5)] = ex__19071__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31974);

return cljs.core.cst$kw$recur;
} else {
throw e32003;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19069__auto__,cljs.core.cst$kw$recur)){
var G__32025 = state_31974;
state_31974 = G__32025;
continue;
} else {
return ret_value__19069__auto__;
}
break;
}
});
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19068__auto__ = function(state_31974){
switch(arguments.length){
case 0:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19068__auto____0.call(this);
case 1:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19068__auto____1.call(this,state_31974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19068__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19068__auto____0;
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19068__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19068__auto____1;
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19068__auto__;
})()
;})(switch__19067__auto__,c__19179__auto__))
})();
var state__19181__auto__ = (function (){var statearr_32005 = (f__19180__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19180__auto__.cljs$core$IFn$_invoke$arity$0() : f__19180__auto__.call(null));
(statearr_32005[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19179__auto__);

return statearr_32005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19181__auto__);
});})(c__19179__auto__))
);

return c__19179__auto__;
});
milia.api.async_export.version_key = "_version";
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_hxl","include_images","remove_group_name",milia.api.async_export.version_key,"query","export_id","include_labels","include_labels_only","win_excel_utf8","redirect_uri","binary_select_multiples","value_select_multiples","show_choice_labels"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_hxl_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id,cljs.core.cst$kw$include_DASH_labels_QMARK_,cljs.core.cst$kw$labels_DASH_only_QMARK_,cljs.core.cst$kw$windows_DASH_compatible_DASH_csv_QMARK_,cljs.core.cst$kw$redirect_DASH_uri,cljs.core.cst$kw$binary_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$value_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$show_DASH_choice_DASH_labels_QMARK_], null);
milia.api.async_export.get_param = (function milia$api$async_export$get_param(key,value){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,milia.api.async_export.version_key)){
return goog.string.format("&query={\"%s\":\"%s\"}",key,value);
} else {
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
}
});
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_((function (){var or__6543__auto__ = value;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
return milia.api.async_export.get_param(key,value);
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32033 = arguments.length;
var i__7652__auto___32034 = (0);
while(true){
if((i__7652__auto___32034 < len__7651__auto___32033)){
args__7658__auto__.push((arguments[i__7652__auto___32034]));

var G__32035 = (i__7652__auto___32034 + (1));
i__7652__auto___32034 = G__32035;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__32029){
var vec__32030 = p__32029;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32030,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq32026){
var G__32027 = cljs.core.first(seq32026);
var seq32026__$1 = cljs.core.next(seq32026);
var G__32028 = cljs.core.first(seq32026__$1);
var seq32026__$2 = cljs.core.next(seq32026__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__32027,G__32028,seq32026__$2);
});

/**
 * Triggers async export and watches it via polling.
 *    Fires on-job-id callback on receving :job_uuid from server, then monitors
 *    job via polling.
 *    On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32085 = arguments.length;
var i__7652__auto___32086 = (0);
while(true){
if((i__7652__auto___32086 < len__7651__auto___32085)){
args__7658__auto__.push((arguments[i__7652__auto___32086]));

var G__32087 = (i__7652__auto___32086 + (1));
i__7652__auto___32086 = G__32087;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__32038){
var vec__32039 = p__32038;
var map__32042 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32039,(0),null);
var map__32042__$1 = ((((!((map__32042 == null)))?((((map__32042.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32042.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__32042):map__32042);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32042__$1,cljs.core.cst$kw$data_DASH_type);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32042__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32042__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32042__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32042__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32042__$1,cljs.core.cst$kw$on_DASH_error);
var on_done = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32042__$1,cljs.core.cst$kw$on_DASH_done);
var c__19179__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19179__auto__,vec__32039,map__32042,map__32042__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (){
var f__19180__auto__ = (function (){var switch__19067__auto__ = ((function (c__19179__auto__,vec__32039,map__32042,map__32042__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (state_32065){
var state_val_32066 = (state_32065[(1)]);
if((state_val_32066 === (1))){
var inst_32046 = (state_32065[(7)]);
var inst_32044 = (state_32065[(8)]);
var inst_32044__$1 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var inst_32045 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_32046__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_32045,dataset_id,inst_32044__$1], 0));
var inst_32047 = milia.utils.retry.retry_parse_http(cljs.core.cst$kw$get,inst_32046__$1);
var state_32065__$1 = (function (){var statearr_32067 = state_32065;
(statearr_32067[(7)] = inst_32046__$1);

(statearr_32067[(8)] = inst_32044__$1);

return statearr_32067;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32065__$1,(2),inst_32047);
} else {
if((state_val_32066 === (2))){
var inst_32049 = (state_32065[(9)]);
var inst_32046 = (state_32065[(7)]);
var inst_32044 = (state_32065[(8)]);
var inst_32049__$1 = (state_32065[(2)]);
var inst_32050 = (function (){var export_suffix = inst_32044;
var export_url = inst_32046;
var response = inst_32049__$1;
return ((function (export_suffix,export_url,response,inst_32049,inst_32046,inst_32044,inst_32049__$1,state_val_32066,c__19179__auto__,vec__32039,map__32042,map__32042__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([cljs.core.cst$kw$on_DASH_export_DASH_url,on_export_url,cljs.core.cst$kw$on_DASH_error,on_error,cljs.core.cst$kw$data_DASH_type,data_type], 0));
});
;})(export_suffix,export_url,response,inst_32049,inst_32046,inst_32044,inst_32049__$1,state_val_32066,c__19179__auto__,vec__32039,map__32042,map__32042__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state_32065__$1 = (function (){var statearr_32068 = state_32065;
(statearr_32068[(10)] = inst_32050);

(statearr_32068[(9)] = inst_32049__$1);

return statearr_32068;
})();
if(cljs.core.truth_(on_done)){
var statearr_32069_32088 = state_32065__$1;
(statearr_32069_32088[(1)] = (3));

} else {
var statearr_32070_32089 = state_32065__$1;
(statearr_32070_32089[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (3))){
var inst_32049 = (state_32065[(9)]);
var inst_32052 = (on_done.cljs$core$IFn$_invoke$arity$1 ? on_done.cljs$core$IFn$_invoke$arity$1(inst_32049) : on_done.call(null,inst_32049));
var state_32065__$1 = state_32065;
var statearr_32071_32090 = state_32065__$1;
(statearr_32071_32090[(2)] = inst_32052);

(statearr_32071_32090[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (4))){
var state_32065__$1 = state_32065;
var statearr_32072_32091 = state_32065__$1;
(statearr_32072_32091[(2)] = null);

(statearr_32072_32091[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (5))){
var inst_32055 = (state_32065[(2)]);
var inst_32056 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var state_32065__$1 = (function (){var statearr_32073 = state_32065;
(statearr_32073[(11)] = inst_32056);

(statearr_32073[(12)] = inst_32055);

return statearr_32073;
})();
if(cljs.core.truth_(on_done)){
var statearr_32074_32092 = state_32065__$1;
(statearr_32074_32092[(1)] = (6));

} else {
var statearr_32075_32093 = state_32065__$1;
(statearr_32075_32093[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (6))){
var state_32065__$1 = state_32065;
var statearr_32076_32094 = state_32065__$1;
(statearr_32076_32094[(2)] = on_job_id);

(statearr_32076_32094[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (7))){
var inst_32050 = (state_32065[(10)]);
var state_32065__$1 = state_32065;
var statearr_32077_32095 = state_32065__$1;
(statearr_32077_32095[(2)] = inst_32050);

(statearr_32077_32095[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (8))){
var inst_32049 = (state_32065[(9)]);
var inst_32056 = (state_32065[(11)]);
var inst_32060 = (state_32065[(2)]);
var inst_32061 = [on_error,inst_32060,on_export_url];
var inst_32062 = cljs.core.PersistentHashMap.fromArrays(inst_32056,inst_32061);
var inst_32063 = milia.api.async_export.handle_response(inst_32049,inst_32062);
var state_32065__$1 = state_32065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32065__$1,inst_32063);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19179__auto__,vec__32039,map__32042,map__32042__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
;
return ((function (switch__19067__auto__,c__19179__auto__,vec__32039,map__32042,map__32042__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function() {
var milia$api$async_export$state_machine__19068__auto__ = null;
var milia$api$async_export$state_machine__19068__auto____0 = (function (){
var statearr_32081 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32081[(0)] = milia$api$async_export$state_machine__19068__auto__);

(statearr_32081[(1)] = (1));

return statearr_32081;
});
var milia$api$async_export$state_machine__19068__auto____1 = (function (state_32065){
while(true){
var ret_value__19069__auto__ = (function (){try{while(true){
var result__19070__auto__ = switch__19067__auto__(state_32065);
if(cljs.core.keyword_identical_QMARK_(result__19070__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19070__auto__;
}
break;
}
}catch (e32082){if((e32082 instanceof Object)){
var ex__19071__auto__ = e32082;
var statearr_32083_32096 = state_32065;
(statearr_32083_32096[(5)] = ex__19071__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32065);

return cljs.core.cst$kw$recur;
} else {
throw e32082;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19069__auto__,cljs.core.cst$kw$recur)){
var G__32097 = state_32065;
state_32065 = G__32097;
continue;
} else {
return ret_value__19069__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19068__auto__ = function(state_32065){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19068__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19068__auto____1.call(this,state_32065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19068__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19068__auto____0;
milia$api$async_export$state_machine__19068__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19068__auto____1;
return milia$api$async_export$state_machine__19068__auto__;
})()
;})(switch__19067__auto__,c__19179__auto__,vec__32039,map__32042,map__32042__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state__19181__auto__ = (function (){var statearr_32084 = (f__19180__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19180__auto__.cljs$core$IFn$_invoke$arity$0() : f__19180__auto__.call(null));
(statearr_32084[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19179__auto__);

return statearr_32084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19181__auto__);
});})(c__19179__auto__,vec__32039,map__32042,map__32042__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
);

return c__19179__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq32036){
var G__32037 = cljs.core.first(seq32036);
var seq32036__$1 = cljs.core.next(seq32036);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32037,seq32036__$1);
});

/**
 * Returns a channel, which will have the async export url when ready.
 */
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,((function (ch){
return (function (p1__32098_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__32098_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
/**
 * Returns a channel, which will have the async _data_
 *  downloaded using http-method when ready.
 */
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___32123 = arguments.length;
var i__7652__auto___32124 = (0);
while(true){
if((i__7652__auto___32124 < len__7651__auto___32123)){
args__7658__auto__.push((arguments[i__7652__auto___32124]));

var G__32125 = (i__7652__auto___32124 + (1));
i__7652__auto___32124 = G__32125;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){
var c__19179__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19179__auto__){
return (function (){
var f__19180__auto__ = (function (){var switch__19067__auto__ = ((function (c__19179__auto__){
return (function (state_32114){
var state_val_32115 = (state_32114[(1)]);
if((state_val_32115 === (1))){
var inst_32103 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_32114__$1 = state_32114;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32114__$1,(2),inst_32103);
} else {
if((state_val_32115 === (2))){
var inst_32105 = (state_32114[(2)]);
var inst_32106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32107 = [http_method,inst_32105];
var inst_32108 = (new cljs.core.PersistentVector(null,2,(5),inst_32106,inst_32107,null));
var inst_32109 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_32108,args);
var inst_32110 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_32109);
var state_32114__$1 = state_32114;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32114__$1,(3),inst_32110);
} else {
if((state_val_32115 === (3))){
var inst_32112 = (state_32114[(2)]);
var state_32114__$1 = state_32114;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32114__$1,inst_32112);
} else {
return null;
}
}
}
});})(c__19179__auto__))
;
return ((function (switch__19067__auto__,c__19179__auto__){
return (function() {
var milia$api$async_export$state_machine__19068__auto__ = null;
var milia$api$async_export$state_machine__19068__auto____0 = (function (){
var statearr_32119 = [null,null,null,null,null,null,null];
(statearr_32119[(0)] = milia$api$async_export$state_machine__19068__auto__);

(statearr_32119[(1)] = (1));

return statearr_32119;
});
var milia$api$async_export$state_machine__19068__auto____1 = (function (state_32114){
while(true){
var ret_value__19069__auto__ = (function (){try{while(true){
var result__19070__auto__ = switch__19067__auto__(state_32114);
if(cljs.core.keyword_identical_QMARK_(result__19070__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19070__auto__;
}
break;
}
}catch (e32120){if((e32120 instanceof Object)){
var ex__19071__auto__ = e32120;
var statearr_32121_32126 = state_32114;
(statearr_32121_32126[(5)] = ex__19071__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_32114);

return cljs.core.cst$kw$recur;
} else {
throw e32120;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19069__auto__,cljs.core.cst$kw$recur)){
var G__32127 = state_32114;
state_32114 = G__32127;
continue;
} else {
return ret_value__19069__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19068__auto__ = function(state_32114){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19068__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19068__auto____1.call(this,state_32114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19068__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19068__auto____0;
milia$api$async_export$state_machine__19068__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19068__auto____1;
return milia$api$async_export$state_machine__19068__auto__;
})()
;})(switch__19067__auto__,c__19179__auto__))
})();
var state__19181__auto__ = (function (){var statearr_32122 = (f__19180__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19180__auto__.cljs$core$IFn$_invoke$arity$0() : f__19180__auto__.call(null));
(statearr_32122[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19179__auto__);

return statearr_32122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19181__auto__);
});})(c__19179__auto__))
);

return c__19179__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq32099){
var G__32100 = cljs.core.first(seq32099);
var seq32099__$1 = cljs.core.next(seq32099);
var G__32101 = cljs.core.first(seq32099__$1);
var seq32099__$2 = cljs.core.next(seq32099__$1);
var G__32102 = cljs.core.first(seq32099__$2);
var seq32099__$3 = cljs.core.next(seq32099__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__32100,G__32101,G__32102,seq32099__$3);
});

/**
 * Get exports based on a form id.
 */
milia.api.async_export.get_exports_per_form = (function milia$api$async_export$get_exports_per_form(dataset_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export?xform=",dataset_id,"&"], 0))], 0)));
});
/**
 * Delete an export based on an export id
 */
milia.api.async_export.delete_export = (function milia$api$async_export$delete_export(export_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export",milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([export_id,"?"], 0))], 0)));
});
