// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
var G__31078 = http_options__$1;
if(cljs.core.truth_((function (){var and__6531__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return (cljs.core.not(cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1))) && (cljs.core.not(stateful_method_QMARK_));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.assoc_in(G__31078,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__31079 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__31079) : cljs_hash.md5.md5.call(null,G__31079));
})());
} else {
return G__31078;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31084 = arguments.length;
var i__7652__auto___31085 = (0);
while(true){
if((i__7652__auto___31085 < len__7651__auto___31084)){
args__7658__auto__.push((arguments[i__7652__auto___31085]));

var G__31086 = (i__7652__auto___31085 + (1));
i__7652__auto___31085 = G__31086;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__31081){
var map__31082 = p__31081;
var map__31082__$1 = ((((!((map__31082 == null)))?((((map__31082.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31082.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31082):map__31082);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31082__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31082__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31082__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31082__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("Token "),cljs.core.str(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__6531__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__6531__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4657__auto__ = (function (){var and__6531__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var crsf_token = temp__4657__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__6543__auto__ = accept_header;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq31080){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31080));
});

/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31096 = arguments.length;
var i__7652__auto___31097 = (0);
while(true){
if((i__7652__auto___31097 < len__7651__auto___31096)){
args__7658__auto__.push((arguments[i__7652__auto___31097]));

var G__31098 = (i__7652__auto___31097 + (1));
i__7652__auto___31097 = G__31098;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__31089){
var vec__31090 = p__31089;
var map__31093 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31090,(0),null);
var map__31093__$1 = ((((!((map__31093 == null)))?((((map__31093.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31093.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31093):map__31093);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31093__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e31095){if((e31095 instanceof Error)){
var _ = e31095;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e31095;

}
}} else {
return io_obj.getResponseText();
}
});

milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1);

milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq31087){
var G__31088 = cljs.core.first(seq31087);
var seq31087__$1 = cljs.core.next(seq31087);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(G__31088,seq31087__$1);
});

milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
var G__31105_31111 = io_obj;
var G__31106_31112 = goog.net.EventType.SUCCESS;
var G__31107_31113 = ((function (G__31105_31111,G__31106_31112,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__31105_31111,G__31106_31112,io_obj))
;
goog.events.listen(G__31105_31111,G__31106_31112,G__31107_31113);

var G__31108_31114 = io_obj;
var G__31109_31115 = goog.net.EventType.ERROR;
var G__31110_31116 = ((function (G__31108_31114,G__31109_31115,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__31108_31114,G__31109_31115,io_obj))
;
goog.events.listen(G__31108_31114,G__31109_31115,G__31110_31116);

return io_obj.sendFromForm(form,[cljs.core.str(form_api),cljs.core.str("?legacy=true")].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://goo.gl/B0fm2a
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31133 = arguments.length;
var i__7652__auto___31134 = (0);
while(true){
if((i__7652__auto___31134 < len__7651__auto___31133)){
args__7658__auto__.push((arguments[i__7652__auto___31134]));

var G__31135 = (i__7652__auto___31134 + (1));
i__7652__auto___31134 = G__31135;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__31121){
var map__31122 = p__31121;
var map__31122__$1 = ((((!((map__31122 == null)))?((((map__31122.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31122.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31122):map__31122);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31122__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31122__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31122__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

var G__31124_31136 = io_obj;
var G__31125_31137 = goog.net.EventType.SUCCESS;
var G__31126_31138 = ((function (G__31124_31136,G__31125_31137,io_obj,data,url,map__31122,map__31122__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,true], 0)));
});})(G__31124_31136,G__31125_31137,io_obj,data,url,map__31122,map__31122__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__31124_31136,G__31125_31137,G__31126_31138);

var G__31127_31139 = io_obj;
var G__31128_31140 = goog.net.EventType.ERROR;
var G__31129_31141 = ((function (G__31127_31139,G__31128_31140,io_obj,data,url,map__31122,map__31122__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,false], 0)));
});})(G__31127_31139,G__31128_31140,io_obj,data,url,map__31122,map__31122__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__31127_31139,G__31128_31140,G__31129_31141);

var G__31130_31142 = io_obj;
var G__31131_31143 = goog.net.EventType.PROGRESS;
var G__31132_31144 = ((function (G__31130_31142,G__31131_31143,io_obj,data,url,map__31122,map__31122__$1,headers,id,require_json_QMARK_){
return (function (p1__31117_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__31117_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__31117_SHARP_.loaded,cljs.core.cst$kw$total,p1__31117_SHARP_.total], null)));
});})(G__31130_31142,G__31131_31143,io_obj,data,url,map__31122,map__31122__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__31130_31142,G__31131_31143,G__31132_31144);

io_obj.send(url,"POST",form,headers);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq31118){
var G__31119 = cljs.core.first(seq31118);
var seq31118__$1 = cljs.core.next(seq31118);
var G__31120 = cljs.core.first(seq31118__$1);
var seq31118__$2 = cljs.core.next(seq31118__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__31119,G__31120,seq31118__$2);
});

/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31209 = arguments.length;
var i__7652__auto___31210 = (0);
while(true){
if((i__7652__auto___31210 < len__7651__auto___31209)){
args__7658__auto__.push((arguments[i__7652__auto___31210]));

var G__31211 = (i__7652__auto___31210 + (1));
i__7652__auto___31210 = G__31211;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__19179__auto___31212 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19179__auto___31212,response_channel){
return (function (){
var f__19180__auto__ = (function (){var switch__19067__auto__ = ((function (c__19179__auto___31212,response_channel){
return (function (state_31182){
var state_val_31183 = (state_31182[(1)]);
if((state_val_31183 === (7))){
var state_31182__$1 = state_31182;
var statearr_31184_31213 = state_31182__$1;
(statearr_31184_31213[(2)] = false);

(statearr_31184_31213[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31183 === (1))){
var inst_31148 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_31182__$1 = state_31182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31182__$1,(2),inst_31148);
} else {
if((state_val_31183 === (4))){
var state_31182__$1 = state_31182;
var statearr_31185_31214 = state_31182__$1;
(statearr_31185_31214[(2)] = false);

(statearr_31185_31214[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31183 === (13))){
var inst_31171 = (state_31182[(7)]);
var inst_31178 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_31171);
var state_31182__$1 = state_31182;
var statearr_31186_31215 = state_31182__$1;
(statearr_31186_31215[(2)] = inst_31178);

(statearr_31186_31215[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31183 === (6))){
var state_31182__$1 = state_31182;
var statearr_31187_31216 = state_31182__$1;
(statearr_31187_31216[(2)] = true);

(statearr_31187_31216[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31183 === (3))){
var inst_31150 = (state_31182[(8)]);
var inst_31155 = inst_31150.cljs$lang$protocol_mask$partition0$;
var inst_31156 = (inst_31155 & (64));
var inst_31157 = inst_31150.cljs$core$ISeq$;
var inst_31158 = (cljs.core.PROTOCOL_SENTINEL === inst_31157);
var inst_31159 = (inst_31156) || (inst_31158);
var state_31182__$1 = state_31182;
if(cljs.core.truth_(inst_31159)){
var statearr_31188_31217 = state_31182__$1;
(statearr_31188_31217[(1)] = (6));

} else {
var statearr_31189_31218 = state_31182__$1;
(statearr_31189_31218[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31183 === (12))){
var inst_31175 = window.location.href();
var inst_31176 = window.location = inst_31175;
var state_31182__$1 = state_31182;
var statearr_31190_31219 = state_31182__$1;
(statearr_31190_31219[(2)] = inst_31176);

(statearr_31190_31219[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31183 === (2))){
var inst_31150 = (state_31182[(8)]);
var inst_31150__$1 = (state_31182[(2)]);
var inst_31152 = (inst_31150__$1 == null);
var inst_31153 = cljs.core.not(inst_31152);
var state_31182__$1 = (function (){var statearr_31191 = state_31182;
(statearr_31191[(8)] = inst_31150__$1);

return statearr_31191;
})();
if(inst_31153){
var statearr_31192_31220 = state_31182__$1;
(statearr_31192_31220[(1)] = (3));

} else {
var statearr_31193_31221 = state_31182__$1;
(statearr_31193_31221[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31183 === (11))){
var inst_31171 = (state_31182[(7)]);
var inst_31171__$1 = (state_31182[(2)]);
var inst_31172 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31171__$1,cljs.core.cst$kw$status);
var inst_31173 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31172,(401));
var state_31182__$1 = (function (){var statearr_31194 = state_31182;
(statearr_31194[(7)] = inst_31171__$1);

return statearr_31194;
})();
if(inst_31173){
var statearr_31195_31222 = state_31182__$1;
(statearr_31195_31222[(1)] = (12));

} else {
var statearr_31196_31223 = state_31182__$1;
(statearr_31196_31223[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31183 === (9))){
var inst_31150 = (state_31182[(8)]);
var inst_31168 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31150);
var state_31182__$1 = state_31182;
var statearr_31197_31224 = state_31182__$1;
(statearr_31197_31224[(2)] = inst_31168);

(statearr_31197_31224[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31183 === (5))){
var inst_31166 = (state_31182[(2)]);
var state_31182__$1 = state_31182;
if(cljs.core.truth_(inst_31166)){
var statearr_31198_31225 = state_31182__$1;
(statearr_31198_31225[(1)] = (9));

} else {
var statearr_31199_31226 = state_31182__$1;
(statearr_31199_31226[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31183 === (14))){
var inst_31180 = (state_31182[(2)]);
var state_31182__$1 = state_31182;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31182__$1,inst_31180);
} else {
if((state_val_31183 === (10))){
var inst_31150 = (state_31182[(8)]);
var state_31182__$1 = state_31182;
var statearr_31200_31227 = state_31182__$1;
(statearr_31200_31227[(2)] = inst_31150);

(statearr_31200_31227[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31183 === (8))){
var inst_31163 = (state_31182[(2)]);
var state_31182__$1 = state_31182;
var statearr_31201_31228 = state_31182__$1;
(statearr_31201_31228[(2)] = inst_31163);

(statearr_31201_31228[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19179__auto___31212,response_channel))
;
return ((function (switch__19067__auto__,c__19179__auto___31212,response_channel){
return (function() {
var milia$api$io$state_machine__19068__auto__ = null;
var milia$api$io$state_machine__19068__auto____0 = (function (){
var statearr_31205 = [null,null,null,null,null,null,null,null,null];
(statearr_31205[(0)] = milia$api$io$state_machine__19068__auto__);

(statearr_31205[(1)] = (1));

return statearr_31205;
});
var milia$api$io$state_machine__19068__auto____1 = (function (state_31182){
while(true){
var ret_value__19069__auto__ = (function (){try{while(true){
var result__19070__auto__ = switch__19067__auto__(state_31182);
if(cljs.core.keyword_identical_QMARK_(result__19070__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19070__auto__;
}
break;
}
}catch (e31206){if((e31206 instanceof Object)){
var ex__19071__auto__ = e31206;
var statearr_31207_31229 = state_31182;
(statearr_31207_31229[(5)] = ex__19071__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31182);

return cljs.core.cst$kw$recur;
} else {
throw e31206;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19069__auto__,cljs.core.cst$kw$recur)){
var G__31230 = state_31182;
state_31182 = G__31230;
continue;
} else {
return ret_value__19069__auto__;
}
break;
}
});
milia$api$io$state_machine__19068__auto__ = function(state_31182){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__19068__auto____0.call(this);
case 1:
return milia$api$io$state_machine__19068__auto____1.call(this,state_31182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__19068__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__19068__auto____0;
milia$api$io$state_machine__19068__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__19068__auto____1;
return milia$api$io$state_machine__19068__auto__;
})()
;})(switch__19067__auto__,c__19179__auto___31212,response_channel))
})();
var state__19181__auto__ = (function (){var statearr_31208 = (f__19180__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19180__auto__.cljs$core$IFn$_invoke$arity$0() : f__19180__auto__.call(null));
(statearr_31208[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19179__auto___31212);

return statearr_31208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19181__auto__);
});})(c__19179__auto___31212,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq31145){
var G__31146 = cljs.core.first(seq31145);
var seq31145__$1 = cljs.core.next(seq31145);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__31146,seq31145__$1);
});

