// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.retry');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('cljs.core.async');
goog.require('milia.api.http');
milia.utils.retry.default_max_retries = (1);
milia.utils.retry.default_retry_for_statuses = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(500),(502),(503),(504)], null);
milia.utils.retry.initial_polling_interval = (1000);
milia.utils.retry.retry_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$max_DASH_retries,cljs.core.cst$kw$retry_DASH_for_DASH_statuses], null);
/**
 * Retry if a status code in retry-for-statuses is returned. Pauses for an
 * exponentially backedoff initial-polling-interval in ClojureScript. Does not
 * pause between retries in Clojure.
 */
milia.utils.retry.retry_parse_http = (function milia$utils$retry$retry_parse_http(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31417 = arguments.length;
var i__7652__auto___31418 = (0);
while(true){
if((i__7652__auto___31418 < len__7651__auto___31417)){
args__7658__auto__.push((arguments[i__7652__auto___31418]));

var G__31419 = (i__7652__auto___31418 + (1));
i__7652__auto___31418 = G__31419;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__31330){
var map__31331 = p__31330;
var map__31331__$1 = ((((!((map__31331 == null)))?((((map__31331.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31331.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31331):map__31331);
var options = map__31331__$1;
var max_retries = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31331__$1,cljs.core.cst$kw$max_DASH_retries,milia.utils.retry.default_max_retries);
var retry_for_statuses = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31331__$1,cljs.core.cst$kw$retry_DASH_for_DASH_statuses,milia.utils.retry.default_retry_for_statuses);
var c__19179__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19179__auto__,map__31331,map__31331__$1,options,max_retries,retry_for_statuses){
return (function (){
var f__19180__auto__ = (function (){var switch__19067__auto__ = ((function (c__19179__auto__,map__31331,map__31331__$1,options,max_retries,retry_for_statuses){
return (function (state_31382){
var state_val_31383 = (state_31382[(1)]);
if((state_val_31383 === (7))){
var inst_31356 = (state_31382[(2)]);
var state_31382__$1 = state_31382;
if(cljs.core.truth_(inst_31356)){
var statearr_31384_31420 = state_31382__$1;
(statearr_31384_31420[(1)] = (11));

} else {
var statearr_31385_31421 = state_31382__$1;
(statearr_31385_31421[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (20))){
var inst_31334 = (state_31382[(7)]);
var inst_31333 = (state_31382[(8)]);
var inst_31372 = (state_31382[(2)]);
var inst_31373 = (inst_31333 * (2));
var inst_31374 = (inst_31334 + (1));
var inst_31333__$1 = inst_31373;
var inst_31334__$1 = inst_31374;
var state_31382__$1 = (function (){var statearr_31386 = state_31382;
(statearr_31386[(7)] = inst_31334__$1);

(statearr_31386[(9)] = inst_31372);

(statearr_31386[(8)] = inst_31333__$1);

return statearr_31386;
})();
var statearr_31387_31422 = state_31382__$1;
(statearr_31387_31422[(2)] = null);

(statearr_31387_31422[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (1))){
var inst_31333 = milia.utils.retry.initial_polling_interval;
var inst_31334 = (0);
var state_31382__$1 = (function (){var statearr_31388 = state_31382;
(statearr_31388[(7)] = inst_31334);

(statearr_31388[(8)] = inst_31333);

return statearr_31388;
})();
var statearr_31389_31423 = state_31382__$1;
(statearr_31389_31423[(2)] = null);

(statearr_31389_31423[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (4))){
var inst_31340 = (state_31382[(10)]);
var inst_31340__$1 = (state_31382[(2)]);
var inst_31342 = (inst_31340__$1 == null);
var inst_31343 = cljs.core.not(inst_31342);
var state_31382__$1 = (function (){var statearr_31390 = state_31382;
(statearr_31390[(10)] = inst_31340__$1);

return statearr_31390;
})();
if(inst_31343){
var statearr_31391_31424 = state_31382__$1;
(statearr_31391_31424[(1)] = (5));

} else {
var statearr_31392_31425 = state_31382__$1;
(statearr_31392_31425[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (15))){
var inst_31363 = (state_31382[(11)]);
var state_31382__$1 = state_31382;
var statearr_31393_31426 = state_31382__$1;
(statearr_31393_31426[(2)] = inst_31363);

(statearr_31393_31426[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (13))){
var inst_31361 = (state_31382[(12)]);
var inst_31363 = (state_31382[(11)]);
var inst_31361__$1 = (state_31382[(2)]);
var inst_31362 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31361__$1,cljs.core.cst$kw$status);
var inst_31363__$1 = chimera.seq.in_QMARK_(retry_for_statuses,inst_31362);
var state_31382__$1 = (function (){var statearr_31394 = state_31382;
(statearr_31394[(12)] = inst_31361__$1);

(statearr_31394[(11)] = inst_31363__$1);

return statearr_31394;
})();
if(cljs.core.truth_(inst_31363__$1)){
var statearr_31395_31427 = state_31382__$1;
(statearr_31395_31427[(1)] = (14));

} else {
var statearr_31396_31428 = state_31382__$1;
(statearr_31396_31428[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (6))){
var state_31382__$1 = state_31382;
var statearr_31397_31429 = state_31382__$1;
(statearr_31397_31429[(2)] = false);

(statearr_31397_31429[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (17))){
var inst_31333 = (state_31382[(8)]);
var inst_31370 = cljs.core.async.timeout(inst_31333);
var state_31382__$1 = state_31382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31382__$1,(20),inst_31370);
} else {
if((state_val_31383 === (3))){
var inst_31380 = (state_31382[(2)]);
var state_31382__$1 = state_31382;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31382__$1,inst_31380);
} else {
if((state_val_31383 === (12))){
var inst_31340 = (state_31382[(10)]);
var state_31382__$1 = state_31382;
var statearr_31398_31430 = state_31382__$1;
(statearr_31398_31430[(2)] = inst_31340);

(statearr_31398_31430[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (2))){
var inst_31337 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,options,milia.utils.retry.retry_keys);
var inst_31338 = chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(milia.api.http.parse_http,cljs.core.array_seq([method,url,inst_31337], 0));
var state_31382__$1 = state_31382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31382__$1,(4),inst_31338);
} else {
if((state_val_31383 === (19))){
var inst_31378 = (state_31382[(2)]);
var state_31382__$1 = state_31382;
var statearr_31399_31431 = state_31382__$1;
(statearr_31399_31431[(2)] = inst_31378);

(statearr_31399_31431[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (11))){
var inst_31340 = (state_31382[(10)]);
var inst_31358 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_31340);
var state_31382__$1 = state_31382;
var statearr_31400_31432 = state_31382__$1;
(statearr_31400_31432[(2)] = inst_31358);

(statearr_31400_31432[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (9))){
var state_31382__$1 = state_31382;
var statearr_31401_31433 = state_31382__$1;
(statearr_31401_31433[(2)] = false);

(statearr_31401_31433[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (5))){
var inst_31340 = (state_31382[(10)]);
var inst_31345 = inst_31340.cljs$lang$protocol_mask$partition0$;
var inst_31346 = (inst_31345 & (64));
var inst_31347 = inst_31340.cljs$core$ISeq$;
var inst_31348 = (cljs.core.PROTOCOL_SENTINEL === inst_31347);
var inst_31349 = (inst_31346) || (inst_31348);
var state_31382__$1 = state_31382;
if(cljs.core.truth_(inst_31349)){
var statearr_31402_31434 = state_31382__$1;
(statearr_31402_31434[(1)] = (8));

} else {
var statearr_31403_31435 = state_31382__$1;
(statearr_31403_31435[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (14))){
var inst_31334 = (state_31382[(7)]);
var inst_31365 = (inst_31334 < max_retries);
var state_31382__$1 = state_31382;
var statearr_31404_31436 = state_31382__$1;
(statearr_31404_31436[(2)] = inst_31365);

(statearr_31404_31436[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (16))){
var inst_31368 = (state_31382[(2)]);
var state_31382__$1 = state_31382;
if(cljs.core.truth_(inst_31368)){
var statearr_31405_31437 = state_31382__$1;
(statearr_31405_31437[(1)] = (17));

} else {
var statearr_31406_31438 = state_31382__$1;
(statearr_31406_31438[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (10))){
var inst_31353 = (state_31382[(2)]);
var state_31382__$1 = state_31382;
var statearr_31407_31439 = state_31382__$1;
(statearr_31407_31439[(2)] = inst_31353);

(statearr_31407_31439[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (18))){
var inst_31361 = (state_31382[(12)]);
var state_31382__$1 = state_31382;
var statearr_31408_31440 = state_31382__$1;
(statearr_31408_31440[(2)] = inst_31361);

(statearr_31408_31440[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31383 === (8))){
var state_31382__$1 = state_31382;
var statearr_31409_31441 = state_31382__$1;
(statearr_31409_31441[(2)] = true);

(statearr_31409_31441[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19179__auto__,map__31331,map__31331__$1,options,max_retries,retry_for_statuses))
;
return ((function (switch__19067__auto__,c__19179__auto__,map__31331,map__31331__$1,options,max_retries,retry_for_statuses){
return (function() {
var milia$utils$retry$state_machine__19068__auto__ = null;
var milia$utils$retry$state_machine__19068__auto____0 = (function (){
var statearr_31413 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31413[(0)] = milia$utils$retry$state_machine__19068__auto__);

(statearr_31413[(1)] = (1));

return statearr_31413;
});
var milia$utils$retry$state_machine__19068__auto____1 = (function (state_31382){
while(true){
var ret_value__19069__auto__ = (function (){try{while(true){
var result__19070__auto__ = switch__19067__auto__(state_31382);
if(cljs.core.keyword_identical_QMARK_(result__19070__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19070__auto__;
}
break;
}
}catch (e31414){if((e31414 instanceof Object)){
var ex__19071__auto__ = e31414;
var statearr_31415_31442 = state_31382;
(statearr_31415_31442[(5)] = ex__19071__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31382);

return cljs.core.cst$kw$recur;
} else {
throw e31414;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19069__auto__,cljs.core.cst$kw$recur)){
var G__31443 = state_31382;
state_31382 = G__31443;
continue;
} else {
return ret_value__19069__auto__;
}
break;
}
});
milia$utils$retry$state_machine__19068__auto__ = function(state_31382){
switch(arguments.length){
case 0:
return milia$utils$retry$state_machine__19068__auto____0.call(this);
case 1:
return milia$utils$retry$state_machine__19068__auto____1.call(this,state_31382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$utils$retry$state_machine__19068__auto__.cljs$core$IFn$_invoke$arity$0 = milia$utils$retry$state_machine__19068__auto____0;
milia$utils$retry$state_machine__19068__auto__.cljs$core$IFn$_invoke$arity$1 = milia$utils$retry$state_machine__19068__auto____1;
return milia$utils$retry$state_machine__19068__auto__;
})()
;})(switch__19067__auto__,c__19179__auto__,map__31331,map__31331__$1,options,max_retries,retry_for_statuses))
})();
var state__19181__auto__ = (function (){var statearr_31416 = (f__19180__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19180__auto__.cljs$core$IFn$_invoke$arity$0() : f__19180__auto__.call(null));
(statearr_31416[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19179__auto__);

return statearr_31416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19181__auto__);
});})(c__19179__auto__,map__31331,map__31331__$1,options,max_retries,retry_for_statuses))
);

return c__19179__auto__;
});

milia.utils.retry.retry_parse_http.cljs$lang$maxFixedArity = (2);

milia.utils.retry.retry_parse_http.cljs$lang$applyTo = (function (seq31327){
var G__31328 = cljs.core.first(seq31327);
var seq31327__$1 = cljs.core.next(seq31327);
var G__31329 = cljs.core.first(seq31327__$1);
var seq31327__$2 = cljs.core.next(seq31327__$1);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(G__31328,G__31329,seq31327__$2);
});

