// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.project');
goog.require('cljs.core');
goog.require('chimera.urls');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.metadata');
goog.require('milia.utils.remote');
/**
 * Parse and add the projects ID.
 */
milia.api.project.add_id = (function milia$api$project$add_id(project_data){
if(typeof project_data === 'string'){
return null;
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([project_data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,chimera.urls.last_url_param(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(project_data))], null)], 0));
}
});
/**
 * Get the forms for this account and owner of the user.
 */
milia.api.project.get_forms = (function milia$api$project$get_forms(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"forms"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.project.get_project = (function milia$api$project$get_project(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31599 = arguments.length;
var i__7652__auto___31600 = (0);
while(true){
if((i__7652__auto___31600 < len__7651__auto___31599)){
args__7658__auto__.push((arguments[i__7652__auto___31600]));

var G__31601 = (i__7652__auto___31600 + (1));
i__7652__auto___31600 = G__31601;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__31596){
var map__31597 = p__31596;
var map__31597__$1 = ((((!((map__31597 == null)))?((((map__31597.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31597.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31597):map__31597);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31597__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
var data = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
return data;
});

milia.api.project.get_project.cljs$lang$maxFixedArity = (1);

milia.api.project.get_project.cljs$lang$applyTo = (function (seq31594){
var G__31595 = cljs.core.first(seq31594);
var seq31594__$1 = cljs.core.next(seq31594);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic(G__31595,seq31594__$1);
});

/**
 * Return all project for this account and owner or the user.
 */
milia.api.project.all = (function milia$api$project$all(var_args){
var args31604 = [];
var len__7651__auto___31612 = arguments.length;
var i__7652__auto___31613 = (0);
while(true){
if((i__7652__auto___31613 < len__7651__auto___31612)){
args31604.push((arguments[i__7652__auto___31613]));

var G__31614 = (i__7652__auto___31613 + (1));
i__7652__auto___31613 = G__31614;
continue;
} else {
}
break;
}

var G__31608 = args31604.length;
switch (G__31608) {
case 0:
return milia.api.project.all.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args31604.slice((1)),(0),null));
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7670__auto__);

}
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.project.all(null);
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic = (function (owner,p__31609){
var map__31610 = p__31609;
var map__31610__$1 = ((((!((map__31610 == null)))?((((map__31610.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31610.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31610):map__31610);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31610__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var logged_in_username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31610__$1,cljs.core.cst$kw$logged_DASH_in_DASH_username);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
var options = ((function (url,map__31610,map__31610__$1,no_cache_QMARK_,logged_in_username){
return (function (p1__31603_SHARP_){
if(cljs.core.truth_(logged_in_username)){
return cljs.core.assoc_in(p1__31603_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$u], null),logged_in_username);
} else {
return p1__31603_SHARP_;
}
});})(url,map__31610,map__31610__$1,no_cache_QMARK_,logged_in_username))
.call(null,((function (url,map__31610,map__31610__$1,no_cache_QMARK_,logged_in_username){
return (function (p1__31602_SHARP_){
if(cljs.core.truth_(owner)){
return cljs.core.assoc_in(p1__31602_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$owner], null),owner);
} else {
return p1__31602_SHARP_;
}
});})(url,map__31610,map__31610__$1,no_cache_QMARK_,logged_in_username))
.call(null,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,null], null)));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.project.all.cljs$lang$applyTo = (function (seq31605){
var G__31606 = cljs.core.first(seq31605);
var seq31605__$1 = cljs.core.next(seq31605);
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic(G__31606,seq31605__$1);
});

milia.api.project.all.cljs$lang$maxFixedArity = (1);

/**
 * Create a project for this account and owner or the user.
 */
milia.api.project.create = (function milia$api$project$create(data,owner){
var owner_url = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",owner], 0))], null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
var form_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([owner_url,data], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,form_params], null)], 0));
});
/**
 * Update project metadata
 */
milia.api.project.update = (function milia$api$project$update(project_id,data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,data], null)], 0));
});
/**
 * Share project with specific user or remove specific user from project
 */
milia.api.project.share = (function milia$api$project$share(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31624 = arguments.length;
var i__7652__auto___31625 = (0);
while(true){
if((i__7652__auto___31625 < len__7651__auto___31624)){
args__7658__auto__.push((arguments[i__7652__auto___31625]));

var G__31626 = (i__7652__auto___31625 + (1));
i__7652__auto___31625 = G__31626;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,username,role,p__31620){
var vec__31621 = p__31620;
var remove_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31621,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id,"share"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$role,role], null);
var form_params = (cljs.core.truth_(remove_QMARK_)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$remove,"True"], null)], 0)):data);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
});

milia.api.project.share.cljs$lang$maxFixedArity = (3);

milia.api.project.share.cljs$lang$applyTo = (function (seq31616){
var G__31617 = cljs.core.first(seq31616);
var seq31616__$1 = cljs.core.next(seq31616);
var G__31618 = cljs.core.first(seq31616__$1);
var seq31616__$2 = cljs.core.next(seq31616__$1);
var G__31619 = cljs.core.first(seq31616__$2);
var seq31616__$3 = cljs.core.next(seq31616__$2);
return milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic(G__31617,G__31618,G__31619,seq31616__$3);
});

/**
 * Add tags to a project.
 */
milia.api.project.add_tags = (function milia$api$project$add_tags(id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"labels"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null),cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Get projects with given tags.
 */
milia.api.project.with_tag = (function milia$api$project$with_tag(tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null)], null)], 0));
});
/**
 * Add star to project for this user.
 */
milia.api.project.add_star = (function milia$api$project$add_star(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31632 = arguments.length;
var i__7652__auto___31633 = (0);
while(true){
if((i__7652__auto___31633 < len__7651__auto___31632)){
args__7658__auto__.push((arguments[i__7652__auto___31633]));

var G__31634 = (i__7652__auto___31633 + (1));
i__7652__auto___31633 = G__31634;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__31629){
var map__31630 = p__31629;
var map__31630__$1 = ((((!((map__31630 == null)))?((((map__31630.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31630.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31630):map__31630);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31630__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$callback,callback], 0));
});

milia.api.project.add_star.cljs$lang$maxFixedArity = (1);

milia.api.project.add_star.cljs$lang$applyTo = (function (seq31627){
var G__31628 = cljs.core.first(seq31627);
var seq31627__$1 = cljs.core.next(seq31627);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic(G__31628,seq31627__$1);
});

/**
 * Remove star from project for this user.
 */
milia.api.project.remove_star = (function milia$api$project$remove_star(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31640 = arguments.length;
var i__7652__auto___31641 = (0);
while(true){
if((i__7652__auto___31641 < len__7651__auto___31640)){
args__7658__auto__.push((arguments[i__7652__auto___31641]));

var G__31642 = (i__7652__auto___31641 + (1));
i__7652__auto___31641 = G__31642;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__31637){
var map__31638 = p__31637;
var map__31638__$1 = ((((!((map__31638 == null)))?((((map__31638.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31638.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31638):map__31638);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31638__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$delete,url,cljs.core.array_seq([cljs.core.cst$kw$callback,callback], 0));
});

milia.api.project.remove_star.cljs$lang$maxFixedArity = (1);

milia.api.project.remove_star.cljs$lang$applyTo = (function (seq31635){
var G__31636 = cljs.core.first(seq31635);
var seq31635__$1 = cljs.core.next(seq31635);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic(G__31636,seq31635__$1);
});

/**
 * Toggle between starred and unstarred for a user's project
 */
milia.api.project.toggle_star = (function milia$api$project$toggle_star(id,star_QMARK_,callback){
return (cljs.core.truth_(star_QMARK_)?milia.api.project.add_star:milia.api.project.remove_star).call(null,id,cljs.core.cst$kw$callback,callback);
});
/**
 * Get projects this user has starred.
 */
milia.api.project.get_starred = (function milia$api$project$get_starred(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user",username,"starred"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Get user that starred this project.
 */
milia.api.project.starred_by = (function milia$api$project$starred_by(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Delete a project
 */
milia.api.project.delete$ = (function milia$api$project$delete(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Set new project owner
 */
milia.api.project.transfer_owner = (function milia$api$project$transfer_owner(id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",new_owner], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,new_owner__$1], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,form_params,cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Update the project public setting.
 */
milia.api.project.update_public = (function milia$api$project$update_public(projectid,public$){
return milia.api.project.update(projectid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$public,public$], null));
});
milia.api.project.files = (function milia$api$project$files(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31648 = arguments.length;
var i__7652__auto___31649 = (0);
while(true){
if((i__7652__auto___31649 < len__7651__auto___31648)){
args__7658__auto__.push((arguments[i__7652__auto___31649]));

var G__31650 = (i__7652__auto___31649 + (1));
i__7652__auto___31649 = G__31650;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,p__31645){
var map__31646 = p__31645;
var map__31646__$1 = ((((!((map__31646 == null)))?((((map__31646.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31646.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31646):map__31646);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31646__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.utils.metadata.metadata_files(cljs.core.cst$kw$project,project_id,no_cache_QMARK_);
});

milia.api.project.files.cljs$lang$maxFixedArity = (1);

milia.api.project.files.cljs$lang$applyTo = (function (seq31643){
var G__31644 = cljs.core.first(seq31643);
var seq31643__$1 = cljs.core.next(seq31643);
return milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic(G__31644,seq31643__$1);
});

