// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.notes');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Returns all notes. Returns notes for a specific submission if
 *   optional instance ID is proviced
 */
milia.api.notes.list = (function milia$api$notes$list(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31496 = arguments.length;
var i__7652__auto___31497 = (0);
while(true){
if((i__7652__auto___31497 < len__7651__auto___31496)){
args__7658__auto__.push((arguments[i__7652__auto___31497]));

var G__31498 = (i__7652__auto___31497 + (1));
i__7652__auto___31497 = G__31498;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.notes.list.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.notes.list.cljs$core$IFn$_invoke$arity$variadic = (function (p__31493){
var map__31494 = p__31493;
var map__31494__$1 = ((((!((map__31494 == null)))?((((map__31494.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31494.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31494):map__31494);
var instance_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31494__$1,cljs.core.cst$kw$instance_DASH_id);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31494__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("notes"),cljs.core.str((cljs.core.truth_(instance_id)?[cljs.core.str("?instance="),cljs.core.str(instance_id)].join(''):null))].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.notes.list.cljs$lang$maxFixedArity = (0);

milia.api.notes.list.cljs$lang$applyTo = (function (seq31492){
return milia.api.notes.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31492));
});

/**
 * Creates a note for a submission instance given the note and instance-id.
 * Takes an options instance-field argument if note added for specific field.
 */
milia.api.notes.create = (function milia$api$notes$create(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31506 = arguments.length;
var i__7652__auto___31507 = (0);
while(true){
if((i__7652__auto___31507 < len__7651__auto___31506)){
args__7658__auto__.push((arguments[i__7652__auto___31507]));

var G__31508 = (i__7652__auto___31507 + (1));
i__7652__auto___31507 = G__31508;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.notes.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.notes.create.cljs$core$IFn$_invoke$arity$variadic = (function (note,instance_id,p__31502){
var vec__31503 = p__31502;
var instance_field = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31503,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["notes"], 0));
var params = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$note,note,cljs.core.cst$kw$instance,instance_id], null);
var form_params = (cljs.core.truth_(instance_field)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(params,cljs.core.cst$kw$instance_field,instance_field):params);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
});

milia.api.notes.create.cljs$lang$maxFixedArity = (2);

milia.api.notes.create.cljs$lang$applyTo = (function (seq31499){
var G__31500 = cljs.core.first(seq31499);
var seq31499__$1 = cljs.core.next(seq31499);
var G__31501 = cljs.core.first(seq31499__$1);
var seq31499__$2 = cljs.core.next(seq31499__$1);
return milia.api.notes.create.cljs$core$IFn$_invoke$arity$variadic(G__31500,G__31501,seq31499__$2);
});

/**
 * Returns a note object given a note ID.
 */
milia.api.notes.get = (function milia$api$notes$get(note_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["notes",note_id], 0)));
});
/**
 * Deletes a note given a note ID.
 */
milia.api.notes.delete$ = (function milia$api$notes$delete(note_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["notes",note_id], 0)));
});
