// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.rest_services');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
/**
 * Create a rest service.
 * `xform-id` is the numeric id of the x-form to associate the service with
 * `name` is one of 1. `generic_json`
 *                  2. `generic_xml`
 *                  3. `textit`
 *                  4. `f2dhis2`
 *                  5. `bamboo`
 * `service-url` is the URL of the webhook receiving endpoint
 * `options` is a map for additional configuration, containing the following
 *    keys in the case of textit:
 *  1. `:service` - Service being configured
 *  2. `:auth_token` - Authentication token
 *  3. `:flow_uuid` - UUID of the flow in textit
 *  4. `:contacts` - The contact in the flow
 */
milia.api.rest_services.create = (function milia$api$rest_services$create(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31661 = arguments.length;
var i__7652__auto___31662 = (0);
while(true){
if((i__7652__auto___31662 < len__7651__auto___31661)){
args__7658__auto__.push((arguments[i__7652__auto___31662]));

var G__31663 = (i__7652__auto___31662 + (1));
i__7652__auto___31662 = G__31663;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic = (function (xform_id,name,service_url,p__31657){
var vec__31658 = p__31657;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31658,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
});

milia.api.rest_services.create.cljs$lang$maxFixedArity = (3);

milia.api.rest_services.create.cljs$lang$applyTo = (function (seq31653){
var G__31654 = cljs.core.first(seq31653);
var seq31653__$1 = cljs.core.next(seq31653);
var G__31655 = cljs.core.first(seq31653__$1);
var seq31653__$2 = cljs.core.next(seq31653__$1);
var G__31656 = cljs.core.first(seq31653__$2);
var seq31653__$3 = cljs.core.next(seq31653__$2);
return milia.api.rest_services.create.cljs$core$IFn$_invoke$arity$variadic(G__31654,G__31655,G__31656,seq31653__$3);
});

/**
 * Updates a rest service.
 */
milia.api.rest_services.update_restservice = (function milia$api$rest_services$update_restservice(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31673 = arguments.length;
var i__7652__auto___31674 = (0);
while(true){
if((i__7652__auto___31674 < len__7651__auto___31673)){
args__7658__auto__.push((arguments[i__7652__auto___31674]));

var G__31675 = (i__7652__auto___31674 + (1));
i__7652__auto___31674 = G__31675;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((4) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((4)),(0),null)):null);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7659__auto__);
});

milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic = (function (id,xform_id,name,service_url,p__31669){
var vec__31670 = p__31669;
var options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31670,(0),null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,xform_id,cljs.core.cst$kw$name,name,cljs.core.cst$kw$service_url,service_url], null),options], 0))], null)], 0));
});

milia.api.rest_services.update_restservice.cljs$lang$maxFixedArity = (4);

milia.api.rest_services.update_restservice.cljs$lang$applyTo = (function (seq31664){
var G__31665 = cljs.core.first(seq31664);
var seq31664__$1 = cljs.core.next(seq31664);
var G__31666 = cljs.core.first(seq31664__$1);
var seq31664__$2 = cljs.core.next(seq31664__$1);
var G__31667 = cljs.core.first(seq31664__$2);
var seq31664__$3 = cljs.core.next(seq31664__$2);
var G__31668 = cljs.core.first(seq31664__$3);
var seq31664__$4 = cljs.core.next(seq31664__$3);
return milia.api.rest_services.update_restservice.cljs$core$IFn$_invoke$arity$variadic(G__31665,G__31666,G__31667,G__31668,seq31664__$4);
});

/**
 * Delete a rest service
 */
milia.api.rest_services.delete$ = (function milia$api$rest_services$delete(id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)));
});
/**
 * Get all rest services the requesting user has access to
 */
milia.api.rest_services.get_all = (function milia$api$rest_services$get_all(){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices"], 0)));
});
/**
 * Get information for a specific rest service
 */
milia.api.rest_services.get_by_id = (function milia$api$rest_services$get_by_id(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31681 = arguments.length;
var i__7652__auto___31682 = (0);
while(true){
if((i__7652__auto___31682 < len__7651__auto___31681)){
args__7658__auto__.push((arguments[i__7652__auto___31682]));

var G__31683 = (i__7652__auto___31682 + (1));
i__7652__auto___31682 = G__31683;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__31678){
var map__31679 = p__31678;
var map__31679__$1 = ((((!((map__31679 == null)))?((((map__31679.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31679.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31679):map__31679);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31679__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["restservices",id], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.rest_services.get_by_id.cljs$lang$maxFixedArity = (1);

milia.api.rest_services.get_by_id.cljs$lang$applyTo = (function (seq31676){
var G__31677 = cljs.core.first(seq31676);
var seq31676__$1 = cljs.core.next(seq31676);
return milia.api.rest_services.get_by_id.cljs$core$IFn$_invoke$arity$variadic(G__31677,seq31676__$1);
});

/**
 * Get rest services for a form
 */
milia.api.rest_services.get_by_form_id = (function milia$api$rest_services$get_by_form_id(var_args){
var args__7658__auto__ = [];
var len__7651__auto___31689 = arguments.length;
var i__7652__auto___31690 = (0);
while(true){
if((i__7652__auto___31690 < len__7651__auto___31689)){
args__7658__auto__.push((arguments[i__7652__auto___31690]));

var G__31691 = (i__7652__auto___31690 + (1));
i__7652__auto___31690 = G__31691;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic = (function (formid,p__31686){
var map__31687 = p__31686;
var map__31687__$1 = ((((!((map__31687 == null)))?((((map__31687.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31687.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31687):map__31687);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31687__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("restservices?xform="),cljs.core.str(formid)].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.rest_services.get_by_form_id.cljs$lang$maxFixedArity = (1);

milia.api.rest_services.get_by_form_id.cljs$lang$applyTo = (function (seq31684){
var G__31685 = cljs.core.first(seq31684);
var seq31684__$1 = cljs.core.next(seq31684);
return milia.api.rest_services.get_by_form_id.cljs$core$IFn$_invoke$arity$variadic(G__31685,seq31684__$1);
});

