// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.dataset');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.metadata');
goog.require('milia.utils.remote');
if(typeof milia.api.dataset.type__GT_endpoint !== 'undefined'){
} else {
milia.api.dataset.type__GT_endpoint = (function (){var method_table__7471__auto__ = (function (){var G__38166 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38166) : cljs.core.atom.call(null,G__38166));
})();
var prefer_table__7472__auto__ = (function (){var G__38167 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38167) : cljs.core.atom.call(null,G__38167));
})();
var method_cache__7473__auto__ = (function (){var G__38168 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38168) : cljs.core.atom.call(null,G__38168));
})();
var cached_hierarchy__7474__auto__ = (function (){var G__38169 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38169) : cljs.core.atom.call(null,G__38169));
})();
var hierarchy__7475__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("milia.api.dataset","type->endpoint"),((function (method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__){
return (function() { 
var G__38170__delegate = function (datatype,_){
return datatype;
};
var G__38170 = function (datatype,var_args){
var _ = null;
if (arguments.length > 1) {
var G__38171__i = 0, G__38171__a = new Array(arguments.length -  1);
while (G__38171__i < G__38171__a.length) {G__38171__a[G__38171__i] = arguments[G__38171__i + 1]; ++G__38171__i;}
  _ = new cljs.core.IndexedSeq(G__38171__a,0);
} 
return G__38170__delegate.call(this,datatype,_);};
G__38170.cljs$lang$maxFixedArity = 1;
G__38170.cljs$lang$applyTo = (function (arglist__38172){
var datatype = cljs.core.first(arglist__38172);
var _ = cljs.core.rest(arglist__38172);
return G__38170__delegate(datatype,_);
});
G__38170.cljs$core$IFn$_invoke$arity$variadic = G__38170__delegate;
return G__38170;
})()
;})(method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__))
,cljs.core.cst$kw$default,hierarchy__7475__auto__,method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__));
})();
}
milia.api.dataset.type__GT_endpoint.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function() { 
var G__38176__delegate = function (_,p__38173){
var map__38174 = p__38173;
var map__38174__$1 = ((((!((map__38174 == null)))?((((map__38174.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38174.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38174):map__38174);
var async = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38174__$1,cljs.core.cst$kw$async,true);
if(cljs.core.truth_(async)){
return "forms";
} else {
return "data";
}
};
var G__38176 = function (_,var_args){
var p__38173 = null;
if (arguments.length > 1) {
var G__38177__i = 0, G__38177__a = new Array(arguments.length -  1);
while (G__38177__i < G__38177__a.length) {G__38177__a[G__38177__i] = arguments[G__38177__i + 1]; ++G__38177__i;}
  p__38173 = new cljs.core.IndexedSeq(G__38177__a,0);
} 
return G__38176__delegate.call(this,_,p__38173);};
G__38176.cljs$lang$maxFixedArity = 1;
G__38176.cljs$lang$applyTo = (function (arglist__38178){
var _ = cljs.core.first(arglist__38178);
var p__38173 = cljs.core.rest(arglist__38178);
return G__38176__delegate(_,p__38173);
});
G__38176.cljs$core$IFn$_invoke$arity$variadic = G__38176__delegate;
return G__38176;
})()
);
milia.api.dataset.type__GT_endpoint.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$filtered_DASH_dataset,(function() { 
var G__38179__delegate = function (_,___$1){
return "dataviews";
};
var G__38179 = function (_,var_args){
var ___$1 = null;
if (arguments.length > 1) {
var G__38180__i = 0, G__38180__a = new Array(arguments.length -  1);
while (G__38180__i < G__38180__a.length) {G__38180__a[G__38180__i] = arguments[G__38180__i + 1]; ++G__38180__i;}
  ___$1 = new cljs.core.IndexedSeq(G__38180__a,0);
} 
return G__38179__delegate.call(this,_,___$1);};
G__38179.cljs$lang$maxFixedArity = 1;
G__38179.cljs$lang$applyTo = (function (arglist__38181){
var _ = cljs.core.first(arglist__38181);
var ___$1 = cljs.core.rest(arglist__38181);
return G__38179__delegate(_,___$1);
});
G__38179.cljs$core$IFn$_invoke$arity$variadic = G__38179__delegate;
return G__38179;
})()
);
/**
 * Return all the datasets for an account.
 */
milia.api.dataset.all = (function milia$api$dataset$all(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("forms?owner="),cljs.core.str(username)].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return all public datasets for a specific user.
 */
milia.api.dataset.public$ = (function milia$api$dataset$public(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",username], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Clone the dataset given by ID into the account with the given username.
 */
milia.api.dataset.clone = (function milia$api$dataset$clone(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38188 = arguments.length;
var i__7652__auto___38189 = (0);
while(true){
if((i__7652__auto___38189 < len__7651__auto___38188)){
args__7658__auto__.push((arguments[i__7652__auto___38189]));

var G__38190 = (i__7652__auto___38189 + (1));
i__7652__auto___38189 = G__38190;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,username,p__38185){
var map__38186 = p__38185;
var map__38186__$1 = ((((!((map__38186 == null)))?((((map__38186.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38186.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38186):map__38186);
var project_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38186__$1,cljs.core.cst$kw$project_DASH_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"clone"], 0));
var data_base = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$username,username], null)], null);
var data = (cljs.core.truth_(project_id)?cljs.core.assoc_in(data_base,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form_DASH_params,cljs.core.cst$kw$project_id], null),project_id):data_base);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,data,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});

milia.api.dataset.clone.cljs$lang$maxFixedArity = (2);

milia.api.dataset.clone.cljs$lang$applyTo = (function (seq38182){
var G__38183 = cljs.core.first(seq38182);
var seq38182__$1 = cljs.core.next(seq38182);
var G__38184 = cljs.core.first(seq38182__$1);
var seq38182__$2 = cljs.core.next(seq38182__$1);
return milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic(G__38183,G__38184,seq38182__$2);
});

/**
 * Set the metadata for a dataset using PUT. All parameters must be passed.
 */
milia.api.dataset.update = (function milia$api$dataset$update(dataset_id,params){
if(cljs.core.truth_(chimera.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$created_by,cljs.core.cst$kw$description,cljs.core.cst$kw$downloadable,cljs.core.cst$kw$owner,cljs.core.cst$kw$project,cljs.core.cst$kw$public,cljs.core.cst$kw$public_data,cljs.core.cst$kw$title,cljs.core.cst$kw$uuid], null)))){
} else {
throw (new Error("Assert failed: (has-keys? params [:created_by :description :downloadable :owner :project :public :public_data :title :uuid])"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Update the title of a form
 */
milia.api.dataset.update_form_name = (function milia$api$dataset$update_form_name(dataset_id,params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Return the data associated with a dataset.
 */
milia.api.dataset.data = (function milia$api$dataset$data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38196 = arguments.length;
var i__7652__auto___38197 = (0);
while(true){
if((i__7652__auto___38197 < len__7651__auto___38196)){
args__7658__auto__.push((arguments[i__7652__auto___38197]));

var G__38198 = (i__7652__auto___38197 + (1));
i__7652__auto___38197 = G__38198;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});
goog.exportSymbol('milia.api.dataset.data', milia.api.dataset.data);

milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__38193){
var map__38194 = p__38193;
var map__38194__$1 = ((((!((map__38194 == null)))?((((map__38194.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38194.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38194):map__38194);
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38194__$1,cljs.core.cst$kw$format);
var raw_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38194__$1,cljs.core.cst$kw$raw_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38194__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38194__$1,cljs.core.cst$kw$accept_DASH_header);
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38194__$1,cljs.core.cst$kw$query_DASH_params);
var data_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38194__$1,cljs.core.cst$kw$data_DASH_id);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38194__$1,cljs.core.cst$kw$auth_DASH_token);
var dataset_suffix = (cljs.core.truth_(format)?[cljs.core.str(dataset_id),cljs.core.str((cljs.core.truth_(data_id)?[cljs.core.str("/"),cljs.core.str(data_id)].join(''):null)),cljs.core.str("."),cljs.core.str(format)].join(''):dataset_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_suffix], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,query_params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$raw_DASH_response_QMARK_,raw_QMARK_,cljs.core.cst$kw$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$auth_DASH_token,auth_token], 0));
});

milia.api.dataset.data.cljs$lang$maxFixedArity = (1);

milia.api.dataset.data.cljs$lang$applyTo = (function (seq38191){
var G__38192 = cljs.core.first(seq38191);
var seq38191__$1 = cljs.core.next(seq38191);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic(G__38192,seq38191__$1);
});

/**
 * Retrieve a record from the dataset.
 */
milia.api.dataset.record = (function milia$api$dataset$record(dataset_id,record_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,record_id], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Returns tags for a dataset
 */
milia.api.dataset.tags = (function milia$api$dataset$tags(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"labels"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add tags to a dataset
 */
milia.api.dataset.add_tags = (function milia$api$dataset$add_tags(dataset_id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"labels"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,tags], null)], 0));
});
/**
 * Return filename taking format special cases into account.
 */
milia.api.dataset.filename_for_format = (function milia$api$dataset$filename_for_format(dataset_id,format){
return [cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(format,"csvzip"))?"zip":format))].join('');
});
/**
 * Return options needed to handle format.
 */
milia.api.dataset.options_for_format = (function milia$api$dataset$options_for_format(format){
if(cljs.core.truth_(chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["csvzip","sav","xls","xlsx","zip"], null),format))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
if(typeof milia.api.dataset.type__GT_download_path !== 'undefined'){
} else {
milia.api.dataset.type__GT_download_path = (function (){var method_table__7471__auto__ = (function (){var G__38199 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38199) : cljs.core.atom.call(null,G__38199));
})();
var prefer_table__7472__auto__ = (function (){var G__38200 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38200) : cljs.core.atom.call(null,G__38200));
})();
var method_cache__7473__auto__ = (function (){var G__38201 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38201) : cljs.core.atom.call(null,G__38201));
})();
var cached_hierarchy__7474__auto__ = (function (){var G__38202 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__38202) : cljs.core.atom.call(null,G__38202));
})();
var hierarchy__7475__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("milia.api.dataset","type->download-path"),((function (method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__){
return (function() { 
var G__38203__delegate = function (datatype,_){
return datatype;
};
var G__38203 = function (datatype,var_args){
var _ = null;
if (arguments.length > 1) {
var G__38204__i = 0, G__38204__a = new Array(arguments.length -  1);
while (G__38204__i < G__38204__a.length) {G__38204__a[G__38204__i] = arguments[G__38204__i + 1]; ++G__38204__i;}
  _ = new cljs.core.IndexedSeq(G__38204__a,0);
} 
return G__38203__delegate.call(this,datatype,_);};
G__38203.cljs$lang$maxFixedArity = 1;
G__38203.cljs$lang$applyTo = (function (arglist__38205){
var datatype = cljs.core.first(arglist__38205);
var _ = cljs.core.rest(arglist__38205);
return G__38203__delegate(datatype,_);
});
G__38203.cljs$core$IFn$_invoke$arity$variadic = G__38203__delegate;
return G__38203;
})()
;})(method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__))
,cljs.core.cst$kw$default,hierarchy__7475__auto__,method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__));
})();
}
milia.api.dataset.type__GT_download_path.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,dataset_id,format,export_options){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(format),cljs.core.str((cljs.core.truth_(export_options)?[cljs.core.str("?"),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",(function (){var iter__7326__auto__ = (function milia$api$dataset$iter__38206(s__38207){
return (new cljs.core.LazySeq(null,(function (){
var s__38207__$1 = s__38207;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__38207__$1);
if(temp__4657__auto__){
var s__38207__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__38207__$2)){
var c__7324__auto__ = cljs.core.chunk_first(s__38207__$2);
var size__7325__auto__ = cljs.core.count(c__7324__auto__);
var b__38209 = cljs.core.chunk_buffer(size__7325__auto__);
if((function (){var i__38208 = (0);
while(true){
if((i__38208 < size__7325__auto__)){
var vec__38218 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7324__auto__,i__38208);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38218,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38218,(1),null);
cljs.core.chunk_append(b__38209,[cljs.core.str(cljs.core.name(option)),cljs.core.str("="),cljs.core.str(val)].join(''));

var G__38224 = (i__38208 + (1));
i__38208 = G__38224;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38209),milia$api$dataset$iter__38206(cljs.core.chunk_rest(s__38207__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38209),null);
}
} else {
var vec__38221 = cljs.core.first(s__38207__$2);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38221,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38221,(1),null);
return cljs.core.cons([cljs.core.str(cljs.core.name(option)),cljs.core.str("="),cljs.core.str(val)].join(''),milia$api$dataset$iter__38206(cljs.core.rest(s__38207__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7326__auto__(export_options);
})()))].join(''):null))].join('')], null);
}));
milia.api.dataset.type__GT_download_path.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$filtered_DASH_dataset,(function (_,dataset_id,format,export_options){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dataset_id,[cljs.core.str("data."),cljs.core.str(format)].join('')], null);
}));
/**
 * Download form data in specified format. The synchronicity here refers to the
 * server side. This will still return a channel, not data, in CLJS.
 * The options map (last parameter) has the following keys:
 * :accept-header Defaults to application/json
 * :submission-id The id of the submission whose data the client requires. The
 *  function returns data for all submissions if this is not provided.
 * :dataview? Boolean flag indicating whether the data belongs to a filtered
 *  dataview
 */
milia.api.dataset.download_synchronously = (function milia$api$dataset$download_synchronously(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38231 = arguments.length;
var i__7652__auto___38232 = (0);
while(true){
if((i__7652__auto___38232 < len__7651__auto___38231)){
args__7658__auto__.push((arguments[i__7652__auto___38232]));

var G__38233 = (i__7652__auto___38232 + (1));
i__7652__auto___38232 = G__38233;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,format,p__38228){
var map__38229 = p__38228;
var map__38229__$1 = ((((!((map__38229 == null)))?((((map__38229.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38229.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38229):map__38229);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38229__$1,cljs.core.cst$kw$accept_DASH_header);
var submission_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38229__$1,cljs.core.cst$kw$submission_DASH_id);
var dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38229__$1,cljs.core.cst$kw$dataview_QMARK_);
var url = (cljs.core.truth_(dataview_QMARK_)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataset_id,[cljs.core.str("data."),cljs.core.str(format)].join('')], 0)):(cljs.core.truth_(submission_id)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,[cljs.core.str(submission_id),cljs.core.str("."),cljs.core.str(format)].join('')], 0)):milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",[cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(format)].join('')], 0))
));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$http_DASH_options,milia.api.dataset.options_for_format(format)], 0));
});

milia.api.dataset.download_synchronously.cljs$lang$maxFixedArity = (2);

milia.api.dataset.download_synchronously.cljs$lang$applyTo = (function (seq38225){
var G__38226 = cljs.core.first(seq38225);
var seq38225__$1 = cljs.core.next(seq38225);
var G__38227 = cljs.core.first(seq38225__$1);
var seq38225__$2 = cljs.core.next(seq38225__$1);
return milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic(G__38226,G__38227,seq38225__$2);
});

/**
 * Download form as JSON string or file in specified format if format passed.
 */
milia.api.dataset.form = (function milia$api$dataset$form(var_args){
var args38234 = [];
var len__7651__auto___38237 = arguments.length;
var i__7652__auto___38238 = (0);
while(true){
if((i__7652__auto___38238 < len__7651__auto___38237)){
args38234.push((arguments[i__7652__auto___38238]));

var G__38239 = (i__7652__auto___38238 + (1));
i__7652__auto___38238 = G__38239;
continue;
} else {
}
break;
}

var G__38236 = args38234.length;
switch (G__38236) {
case 1:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38234.length)].join('')));

}
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"form.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,format){
var suffix = [cljs.core.str("form."),cljs.core.str(format)].join('');
var options = milia.api.dataset.options_for_format(format);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,suffix], 0));
var filename = [cljs.core.str(dataset_id),cljs.core.str("_"),cljs.core.str(suffix)].join('');
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$filename,filename], 0));
});

milia.api.dataset.form.cljs$lang$maxFixedArity = 2;

/**
 * Show dataset metadata.
 */
milia.api.dataset.metadata = (function milia$api$dataset$metadata(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38246 = arguments.length;
var i__7652__auto___38247 = (0);
while(true){
if((i__7652__auto___38247 < len__7651__auto___38246)){
args__7658__auto__.push((arguments[i__7652__auto___38247]));

var G__38248 = (i__7652__auto___38247 + (1));
i__7652__auto___38247 = G__38248;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__38243){
var map__38244 = p__38243;
var map__38244__$1 = ((((!((map__38244 == null)))?((((map__38244.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38244.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38244):map__38244);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38244__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",[cljs.core.str(dataset_id),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.dataset.metadata.cljs$lang$maxFixedArity = (1);

milia.api.dataset.metadata.cljs$lang$applyTo = (function (seq38241){
var G__38242 = cljs.core.first(seq38241);
var seq38241__$1 = cljs.core.next(seq38241);
return milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic(G__38242,seq38241__$1);
});

/**
 * Return link to online data entry.
 */
milia.api.dataset.online_data_entry_link = (function milia$api$dataset$online_data_entry_link(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"enketo"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return link to online data entry.
 */
milia.api.dataset.edit_link = (function milia$api$dataset$edit_link(username,project_id,dataset_id,instance_id){
var return_url = milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([username,project_id,dataset_id,"submission-editing-complete"], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,instance_id,[cljs.core.str("enketo?return_url="),cljs.core.str(return_url)].join('')], 0));
return cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(milia.api.http.parse_http(cljs.core.cst$kw$get,url));
});
/**
 * Delete a dataset by ID.
 */
milia.api.dataset.delete$ = (function milia$api$dataset$delete(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"delete_async"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Move a dataset to a project use account if no owner passed.
 */
milia.api.dataset.move_to_project = (function milia$api$dataset$move_to_project(dataset_id,project_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id,"forms"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$formid,dataset_id], null)], null)], 0));
});
/**
 * Set a new form owner
 */
milia.api.dataset.new_form_owner = (function milia$api$dataset$new_form_owner(dataset_id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",new_owner], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,new_owner__$1], null)], null)], 0));
});
/**
 * Share dataset with specific user
 */
milia.api.dataset.update_sharing = (function milia$api$dataset$update_sharing(dataset_id,username,role){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"share"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$role,role], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null)], 0));
});
/**
 * Link xform or dataview as media
 */
milia.api.dataset.link_xform_or_dataview_as_media = (function milia$api$dataset$link_xform_or_dataview_as_media(object_type,object_id,media_filename,xform_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata"], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"media",cljs.core.cst$kw$data_value,[cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [object_type,object_id,media_filename], null)))].join(''),cljs.core.cst$kw$xform,xform_id], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Add xls report link to dataset
 */
milia.api.dataset.add_xls_report = (function milia$api$dataset$add_xls_report(dataset_id,uuid,filename){
var xls_url = milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["xls",uuid], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata"], 0));
var data = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_type,"external_export",cljs.core.cst$kw$data_value,[cljs.core.str(filename),cljs.core.str("|"),cljs.core.str(xls_url)].join('')], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null)], 0));
});
/**
 * Download xls report from the j2x service
 */
milia.api.dataset.download_xls_report = (function milia$api$dataset$download_xls_report(var_args){
var args38249 = [];
var len__7651__auto___38252 = arguments.length;
var i__7652__auto___38253 = (0);
while(true){
if((i__7652__auto___38253 < len__7651__auto___38252)){
args38249.push((arguments[i__7652__auto___38253]));

var G__38254 = (i__7652__auto___38253 + (1));
i__7652__auto___38253 = G__38254;
continue;
} else {
}
break;
}

var G__38251 = args38249.length;
switch (G__38251) {
case 3:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38249.length)].join('')));

}
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3 = (function (dataset_id,meta_id,filename){
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4(dataset_id,meta_id,filename,null);
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4 = (function (dataset_id,meta_id,filename,data_id){
var suffix = (cljs.core.truth_(data_id)?[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id),cljs.core.str("&data_id="),cljs.core.str(data_id)].join(''):[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id)].join(''));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",suffix], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$filename,filename], 0));
});

milia.api.dataset.download_xls_report.cljs$lang$maxFixedArity = 4;

/**
 * Returns a submission's edit history
 */
milia.api.dataset.edit_history = (function milia$api$dataset$edit_history(dataset_id,instance_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,instance_id,"history"], 0)));
});
milia.api.dataset.files = (function milia$api$dataset$files(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38262 = arguments.length;
var i__7652__auto___38263 = (0);
while(true){
if((i__7652__auto___38263 < len__7651__auto___38262)){
args__7658__auto__.push((arguments[i__7652__auto___38263]));

var G__38264 = (i__7652__auto___38263 + (1));
i__7652__auto___38263 = G__38264;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic = (function (instance_id,project_id,p__38259){
var map__38260 = p__38259;
var map__38260__$1 = ((((!((map__38260 == null)))?((((map__38260.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38260.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38260):map__38260);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38260__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38260__$1,cljs.core.cst$kw$dataset_DASH_id);
var extra_params = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$project,project_id], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$xform,dataset_id], null));
return milia.utils.metadata.metadata_files.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$instance,instance_id,no_cache_QMARK_,cljs.core.array_seq([cljs.core.cst$kw$extra_DASH_params,extra_params], 0));
});

milia.api.dataset.files.cljs$lang$maxFixedArity = (2);

milia.api.dataset.files.cljs$lang$applyTo = (function (seq38256){
var G__38257 = cljs.core.first(seq38256);
var seq38256__$1 = cljs.core.next(seq38256);
var G__38258 = cljs.core.first(seq38256__$1);
var seq38256__$2 = cljs.core.next(seq38256__$1);
return milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic(G__38257,G__38258,seq38256__$2);
});

/**
 * Integer Integer String String -> Channel HttpResponse
 */
milia.api.dataset.update_xform_meta_permissions = (function milia$api$dataset$update_xform_meta_permissions(dataset_id,metadata_id,editor_meta_role,dataentry_meta_role){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata",metadata_id], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"xform_meta_perms",cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_value,[cljs.core.str(editor_meta_role),cljs.core.str("|"),cljs.core.str(dataentry_meta_role)].join('')], null)], null)], 0));
});
/**
 * Integer String String -> Channel HttpResponse
 */
milia.api.dataset.create_xform_meta_permissions = (function milia$api$dataset$create_xform_meta_permissions(dataset_id,editor_meta_role,dataentry_meta_role){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"xform_meta_perms",cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_value,[cljs.core.str(editor_meta_role),cljs.core.str("|"),cljs.core.str(dataentry_meta_role)].join('')], null)], null)], 0));
});
/**
 * Create a submission review
 */
milia.api.dataset.create_submission_review = (function milia$api$dataset$create_submission_review(p__38265){
var map__38268 = p__38265;
var map__38268__$1 = ((((!((map__38268 == null)))?((((map__38268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38268.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38268):map__38268);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38268__$1,cljs.core.cst$kw$status);
var instance = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38268__$1,cljs.core.cst$kw$instance);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38268__$1,cljs.core.cst$kw$note);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["submissionreview"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,status,cljs.core.cst$kw$instance,instance,cljs.core.cst$kw$note,note], null)], null)], 0));
});
/**
 * Create a submission review
 */
milia.api.dataset.create_multiple_submission_reviews = (function milia$api$dataset$create_multiple_submission_reviews(p__38270){
var map__38273 = p__38270;
var map__38273__$1 = ((((!((map__38273 == null)))?((((map__38273.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38273.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38273):map__38273);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38273__$1,cljs.core.cst$kw$status);
var instances = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38273__$1,cljs.core.cst$kw$instances);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38273__$1,cljs.core.cst$kw$note);
var json_vec = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (map__38273,map__38273__$1,status,instances,note){
return (function (instance){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$note,note,cljs.core.cst$kw$status,status,cljs.core.cst$kw$instance,instance], null);
});})(map__38273,map__38273__$1,status,instances,note))
,instances);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["submissionreview"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,json_vec], null)], 0));
});
/**
 * Get a submission review
 */
milia.api.dataset.get_submission_review = (function milia$api$dataset$get_submission_review(submission_review_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["submissionreview",submission_review_id], 0)));
});
/**
 * List a submission review
 */
milia.api.dataset.list_submission_reviews = (function milia$api$dataset$list_submission_reviews(){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["submissionreview"], 0)));
});
/**
 * Update a submission review
 */
milia.api.dataset.update_submission_review = (function milia$api$dataset$update_submission_review(p__38275){
var map__38279 = p__38275;
var map__38279__$1 = ((((!((map__38279 == null)))?((((map__38279.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38279.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38279):map__38279);
var submission_review_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38279__$1,cljs.core.cst$kw$submission_DASH_review_DASH_id);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38279__$1,cljs.core.cst$kw$status);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38279__$1,cljs.core.cst$kw$note);
if(cljs.core.not_every_QMARK_(cljs.core.nil_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [status,note], null))){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["submissionreview",submission_review_id], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,(function (){var G__38281 = cljs.core.PersistentArrayMap.EMPTY;
var G__38281__$1 = (cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(status) : chimera.core.not_nil_QMARK_.call(null,status)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38281,cljs.core.cst$kw$status,status):G__38281);
if(cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(note) : chimera.core.not_nil_QMARK_.call(null,note)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38281__$1,cljs.core.cst$kw$note,note);
} else {
return G__38281__$1;
}
})()], null)], 0));
} else {
return null;
}
});
milia.api.dataset.filter_submission_review_by_instance = (function milia$api$dataset$filter_submission_review_by_instance(p__38282){
var map__38286 = p__38282;
var map__38286__$1 = ((((!((map__38286 == null)))?((((map__38286.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38286.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38286):map__38286);
var instance = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38286__$1,cljs.core.cst$kw$instance);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38286__$1,cljs.core.cst$kw$status);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38286__$1,cljs.core.cst$kw$note);
var query_params_str = chimera.string.get_query_params_str((function (){var G__38288 = cljs.core.PersistentArrayMap.EMPTY;
var G__38288__$1 = (cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(instance) : chimera.core.not_nil_QMARK_.call(null,instance)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38288,cljs.core.cst$kw$instance,instance):G__38288);
var G__38288__$2 = (cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(status) : chimera.core.not_nil_QMARK_.call(null,status)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38288__$1,cljs.core.cst$kw$status,status):G__38288__$1);
if(cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(note) : chimera.core.not_nil_QMARK_.call(null,note)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__38288__$2,cljs.core.cst$kw$note,note);
} else {
return G__38288__$2;
}
})());
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("submissionreview"),cljs.core.str(query_params_str)].join('')], 0)));
});
milia.api.dataset.delete_submission_review = (function milia$api$dataset$delete_submission_review(instance){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["submissionreview",instance], 0)));
});
