// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.retry');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('cljs.core.async');
goog.require('milia.api.http');
milia.utils.retry.default_max_retries = (1);
milia.utils.retry.default_retry_for_statuses = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(500),(502),(503),(504)], null);
milia.utils.retry.initial_polling_interval = (1000);
milia.utils.retry.retry_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$max_DASH_retries,cljs.core.cst$kw$retry_DASH_for_DASH_statuses], null);
/**
 * Retry if a status code in retry-for-statuses is returned. Pauses for an
 * exponentially backedoff initial-polling-interval in ClojureScript. Does not
 * pause between retries in Clojure.
 */
milia.utils.retry.retry_parse_http = (function milia$utils$retry$retry_parse_http(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37924 = arguments.length;
var i__7652__auto___37925 = (0);
while(true){
if((i__7652__auto___37925 < len__7651__auto___37924)){
args__7658__auto__.push((arguments[i__7652__auto___37925]));

var G__37926 = (i__7652__auto___37925 + (1));
i__7652__auto___37925 = G__37926;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__37837){
var map__37838 = p__37837;
var map__37838__$1 = ((((!((map__37838 == null)))?((((map__37838.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37838.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37838):map__37838);
var options = map__37838__$1;
var max_retries = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__37838__$1,cljs.core.cst$kw$max_DASH_retries,milia.utils.retry.default_max_retries);
var retry_for_statuses = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__37838__$1,cljs.core.cst$kw$retry_DASH_for_DASH_statuses,milia.utils.retry.default_retry_for_statuses);
var c__19296__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto__,map__37838,map__37838__$1,options,max_retries,retry_for_statuses){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto__,map__37838,map__37838__$1,options,max_retries,retry_for_statuses){
return (function (state_37889){
var state_val_37890 = (state_37889[(1)]);
if((state_val_37890 === (7))){
var inst_37863 = (state_37889[(2)]);
var state_37889__$1 = state_37889;
if(cljs.core.truth_(inst_37863)){
var statearr_37891_37927 = state_37889__$1;
(statearr_37891_37927[(1)] = (11));

} else {
var statearr_37892_37928 = state_37889__$1;
(statearr_37892_37928[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (20))){
var inst_37841 = (state_37889[(7)]);
var inst_37840 = (state_37889[(8)]);
var inst_37879 = (state_37889[(2)]);
var inst_37880 = (inst_37840 * (2));
var inst_37881 = (inst_37841 + (1));
var inst_37840__$1 = inst_37880;
var inst_37841__$1 = inst_37881;
var state_37889__$1 = (function (){var statearr_37893 = state_37889;
(statearr_37893[(7)] = inst_37841__$1);

(statearr_37893[(8)] = inst_37840__$1);

(statearr_37893[(9)] = inst_37879);

return statearr_37893;
})();
var statearr_37894_37929 = state_37889__$1;
(statearr_37894_37929[(2)] = null);

(statearr_37894_37929[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (1))){
var inst_37840 = milia.utils.retry.initial_polling_interval;
var inst_37841 = (0);
var state_37889__$1 = (function (){var statearr_37895 = state_37889;
(statearr_37895[(7)] = inst_37841);

(statearr_37895[(8)] = inst_37840);

return statearr_37895;
})();
var statearr_37896_37930 = state_37889__$1;
(statearr_37896_37930[(2)] = null);

(statearr_37896_37930[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (4))){
var inst_37847 = (state_37889[(10)]);
var inst_37847__$1 = (state_37889[(2)]);
var inst_37849 = (inst_37847__$1 == null);
var inst_37850 = cljs.core.not(inst_37849);
var state_37889__$1 = (function (){var statearr_37897 = state_37889;
(statearr_37897[(10)] = inst_37847__$1);

return statearr_37897;
})();
if(inst_37850){
var statearr_37898_37931 = state_37889__$1;
(statearr_37898_37931[(1)] = (5));

} else {
var statearr_37899_37932 = state_37889__$1;
(statearr_37899_37932[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (15))){
var inst_37870 = (state_37889[(11)]);
var state_37889__$1 = state_37889;
var statearr_37900_37933 = state_37889__$1;
(statearr_37900_37933[(2)] = inst_37870);

(statearr_37900_37933[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (13))){
var inst_37868 = (state_37889[(12)]);
var inst_37870 = (state_37889[(11)]);
var inst_37868__$1 = (state_37889[(2)]);
var inst_37869 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37868__$1,cljs.core.cst$kw$status);
var inst_37870__$1 = chimera.seq.in_QMARK_(retry_for_statuses,inst_37869);
var state_37889__$1 = (function (){var statearr_37901 = state_37889;
(statearr_37901[(12)] = inst_37868__$1);

(statearr_37901[(11)] = inst_37870__$1);

return statearr_37901;
})();
if(cljs.core.truth_(inst_37870__$1)){
var statearr_37902_37934 = state_37889__$1;
(statearr_37902_37934[(1)] = (14));

} else {
var statearr_37903_37935 = state_37889__$1;
(statearr_37903_37935[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (6))){
var state_37889__$1 = state_37889;
var statearr_37904_37936 = state_37889__$1;
(statearr_37904_37936[(2)] = false);

(statearr_37904_37936[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (17))){
var inst_37840 = (state_37889[(8)]);
var inst_37877 = cljs.core.async.timeout(inst_37840);
var state_37889__$1 = state_37889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37889__$1,(20),inst_37877);
} else {
if((state_val_37890 === (3))){
var inst_37887 = (state_37889[(2)]);
var state_37889__$1 = state_37889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37889__$1,inst_37887);
} else {
if((state_val_37890 === (12))){
var inst_37847 = (state_37889[(10)]);
var state_37889__$1 = state_37889;
var statearr_37905_37937 = state_37889__$1;
(statearr_37905_37937[(2)] = inst_37847);

(statearr_37905_37937[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (2))){
var inst_37844 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,options,milia.utils.retry.retry_keys);
var inst_37845 = chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(milia.api.http.parse_http,cljs.core.array_seq([method,url,inst_37844], 0));
var state_37889__$1 = state_37889;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37889__$1,(4),inst_37845);
} else {
if((state_val_37890 === (19))){
var inst_37885 = (state_37889[(2)]);
var state_37889__$1 = state_37889;
var statearr_37906_37938 = state_37889__$1;
(statearr_37906_37938[(2)] = inst_37885);

(statearr_37906_37938[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (11))){
var inst_37847 = (state_37889[(10)]);
var inst_37865 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37847);
var state_37889__$1 = state_37889;
var statearr_37907_37939 = state_37889__$1;
(statearr_37907_37939[(2)] = inst_37865);

(statearr_37907_37939[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (9))){
var state_37889__$1 = state_37889;
var statearr_37908_37940 = state_37889__$1;
(statearr_37908_37940[(2)] = false);

(statearr_37908_37940[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (5))){
var inst_37847 = (state_37889[(10)]);
var inst_37852 = inst_37847.cljs$lang$protocol_mask$partition0$;
var inst_37853 = (inst_37852 & (64));
var inst_37854 = inst_37847.cljs$core$ISeq$;
var inst_37855 = (cljs.core.PROTOCOL_SENTINEL === inst_37854);
var inst_37856 = (inst_37853) || (inst_37855);
var state_37889__$1 = state_37889;
if(cljs.core.truth_(inst_37856)){
var statearr_37909_37941 = state_37889__$1;
(statearr_37909_37941[(1)] = (8));

} else {
var statearr_37910_37942 = state_37889__$1;
(statearr_37910_37942[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (14))){
var inst_37841 = (state_37889[(7)]);
var inst_37872 = (inst_37841 < max_retries);
var state_37889__$1 = state_37889;
var statearr_37911_37943 = state_37889__$1;
(statearr_37911_37943[(2)] = inst_37872);

(statearr_37911_37943[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (16))){
var inst_37875 = (state_37889[(2)]);
var state_37889__$1 = state_37889;
if(cljs.core.truth_(inst_37875)){
var statearr_37912_37944 = state_37889__$1;
(statearr_37912_37944[(1)] = (17));

} else {
var statearr_37913_37945 = state_37889__$1;
(statearr_37913_37945[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (10))){
var inst_37860 = (state_37889[(2)]);
var state_37889__$1 = state_37889;
var statearr_37914_37946 = state_37889__$1;
(statearr_37914_37946[(2)] = inst_37860);

(statearr_37914_37946[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (18))){
var inst_37868 = (state_37889[(12)]);
var state_37889__$1 = state_37889;
var statearr_37915_37947 = state_37889__$1;
(statearr_37915_37947[(2)] = inst_37868);

(statearr_37915_37947[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37890 === (8))){
var state_37889__$1 = state_37889;
var statearr_37916_37948 = state_37889__$1;
(statearr_37916_37948[(2)] = true);

(statearr_37916_37948[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto__,map__37838,map__37838__$1,options,max_retries,retry_for_statuses))
;
return ((function (switch__19184__auto__,c__19296__auto__,map__37838,map__37838__$1,options,max_retries,retry_for_statuses){
return (function() {
var milia$utils$retry$state_machine__19185__auto__ = null;
var milia$utils$retry$state_machine__19185__auto____0 = (function (){
var statearr_37920 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37920[(0)] = milia$utils$retry$state_machine__19185__auto__);

(statearr_37920[(1)] = (1));

return statearr_37920;
});
var milia$utils$retry$state_machine__19185__auto____1 = (function (state_37889){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_37889);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e37921){if((e37921 instanceof Object)){
var ex__19188__auto__ = e37921;
var statearr_37922_37949 = state_37889;
(statearr_37922_37949[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_37889);

return cljs.core.cst$kw$recur;
} else {
throw e37921;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__37950 = state_37889;
state_37889 = G__37950;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
milia$utils$retry$state_machine__19185__auto__ = function(state_37889){
switch(arguments.length){
case 0:
return milia$utils$retry$state_machine__19185__auto____0.call(this);
case 1:
return milia$utils$retry$state_machine__19185__auto____1.call(this,state_37889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$utils$retry$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = milia$utils$retry$state_machine__19185__auto____0;
milia$utils$retry$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = milia$utils$retry$state_machine__19185__auto____1;
return milia$utils$retry$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto__,map__37838,map__37838__$1,options,max_retries,retry_for_statuses))
})();
var state__19298__auto__ = (function (){var statearr_37923 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_37923[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto__);

return statearr_37923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto__,map__37838,map__37838__$1,options,max_retries,retry_for_statuses))
);

return c__19296__auto__;
});

milia.utils.retry.retry_parse_http.cljs$lang$maxFixedArity = (2);

milia.utils.retry.retry_parse_http.cljs$lang$applyTo = (function (seq37834){
var G__37835 = cljs.core.first(seq37834);
var seq37834__$1 = cljs.core.next(seq37834);
var G__37836 = cljs.core.first(seq37834__$1);
var seq37834__$2 = cljs.core.next(seq37834__$1);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(G__37835,G__37836,seq37834__$2);
});

