// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('chimera.string');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.dataset');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.export_pending_status_msg = "PENDING";
milia.api.async_export.initial_polling_interval = (5000);
/**
 * If a temp-token is set, add it as a query string parameter. The caller needs
 * to explicity pass a question-mark or ampersand depending on whether this is
 * the first or a subsequenty query parameter.
 */
milia.api.async_export.temp_token_suffix = (function milia$api$async_export$temp_token_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38292 = arguments.length;
var i__7652__auto___38293 = (0);
while(true){
if((i__7652__auto___38293 < len__7651__auto___38292)){
args__7658__auto__.push((arguments[i__7652__auto___38293]));

var G__38294 = (i__7652__auto___38293 + (1));
i__7652__auto___38293 = G__38294;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (s){
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return clojure.string.join.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_((chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token)))?cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.vec(s),"temp_token=",cljs.core.array_seq([temp_token], 0)):s));
});

milia.api.async_export.temp_token_suffix.cljs$lang$maxFixedArity = (0);

milia.api.async_export.temp_token_suffix.cljs$lang$applyTo = (function (seq38291){
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38291));
});

/**
 * Handles API server's response and acts according to given callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__38295,p__38296){
var map__38305 = p__38295;
var map__38305__$1 = ((((!((map__38305 == null)))?((((map__38305.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38305.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38305):map__38305);
var response = map__38305__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38305__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38305__$1,cljs.core.cst$kw$body);
var map__38306 = p__38296;
var map__38306__$1 = ((((!((map__38306 == null)))?((((map__38306.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38306.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38306):map__38306);
var callbacks = map__38306__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38306__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38306__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38306__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__38306__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__38309 = body;
var map__38309__$1 = ((((!((map__38309 == null)))?((((map__38309.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38309.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38309):map__38309);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38309__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38309__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38309__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = ((function (map__38309,map__38309__$1,export_url,job_status,job_id,map__38305,map__38305__$1,response,status,body,map__38306,map__38306__$1,callbacks,on_error,on_export_url,on_job_id,on_stop){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});})(map__38309,map__38309__$1,export_url,job_status,job_id,map__38305,map__38305__$1,response,status,body,map__38306,map__38306__$1,callbacks,on_error,on_export_url,on_job_id,on_stop))
;
var error_detail = (function (){var or__6543__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = cljs.core.cst$kw$details.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
if(cljs.core.truth_(is_failed_status_QMARK_())){
return job_status;
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}

} else {
}

if(cljs.core.truth_((function (){var or__6543__auto__ = (status >= (400));
if(or__6543__auto__){
return or__6543__auto__;
} else {
return is_failed_status_QMARK_();
}
})())){
if(cljs.core.fn_QMARK_(on_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(403))){
var G__38311_38313 = error_detail;
var G__38312_38314 = cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(body);
(on_error.cljs$core$IFn$_invoke$arity$2 ? on_error.cljs$core$IFn$_invoke$arity$2(G__38311_38313,G__38312_38314) : on_error.call(null,G__38311_38313,G__38312_38314));
} else {
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
}
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 *  When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38365 = arguments.length;
var i__7652__auto___38366 = (0);
while(true){
if((i__7652__auto___38366 < len__7651__auto___38365)){
args__7658__auto__.push((arguments[i__7652__auto___38366]));

var G__38367 = (i__7652__auto___38366 + (1));
i__7652__auto___38366 = G__38367;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__38318){
var map__38319 = p__38318;
var map__38319__$1 = ((((!((map__38319 == null)))?((((map__38319.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38319.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38319):map__38319);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38319__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38319__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38319__$1,cljs.core.cst$kw$data_DASH_type);
var c__19296__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto__,map__38319,map__38319__$1,on_error,on_export_url,data_type){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto__,map__38319,map__38319__$1,on_error,on_export_url,data_type){
return (function (state_38347){
var state_val_38348 = (state_38347[(1)]);
if((state_val_38348 === (1))){
var inst_38321 = milia.api.async_export.initial_polling_interval;
var state_38347__$1 = (function (){var statearr_38349 = state_38347;
(statearr_38349[(7)] = inst_38321);

return statearr_38349;
})();
var statearr_38350_38368 = state_38347__$1;
(statearr_38350_38368[(2)] = null);

(statearr_38350_38368[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38348 === (2))){
var inst_38323 = (state_38347[(8)]);
var inst_38325 = (state_38347[(9)]);
var inst_38323__$1 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var inst_38324 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_38325__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_38324,dataset_id,inst_38323__$1], 0));
var inst_38326 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_38325__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_38347__$1 = (function (){var statearr_38351 = state_38347;
(statearr_38351[(8)] = inst_38323__$1);

(statearr_38351[(9)] = inst_38325__$1);

return statearr_38351;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38347__$1,(4),inst_38326);
} else {
if((state_val_38348 === (3))){
var inst_38345 = (state_38347[(2)]);
var state_38347__$1 = state_38347;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38347__$1,inst_38345);
} else {
if((state_val_38348 === (4))){
var inst_38323 = (state_38347[(8)]);
var inst_38325 = (state_38347[(9)]);
var inst_38321 = (state_38347[(7)]);
var inst_38328 = (state_38347[(2)]);
var inst_38329 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_38330 = (function (){var polling_interval = inst_38321;
var job_suffix = inst_38323;
var job_url = inst_38325;
var response = inst_38328;
return ((function (polling_interval,job_suffix,job_url,response,inst_38323,inst_38325,inst_38321,inst_38328,inst_38329,state_val_38348,c__19296__auto__,map__38319,map__38319__$1,on_error,on_export_url,data_type){
return (function (){
return cljs.core.constantly(cljs.core.cst$kw$stop);
});
;})(polling_interval,job_suffix,job_url,response,inst_38323,inst_38325,inst_38321,inst_38328,inst_38329,state_val_38348,c__19296__auto__,map__38319,map__38319__$1,on_error,on_export_url,data_type))
})();
var inst_38331 = [inst_38330,on_error,on_export_url];
var inst_38332 = cljs.core.PersistentHashMap.fromArrays(inst_38329,inst_38331);
var inst_38333 = milia.api.async_export.handle_response(inst_38328,inst_38332);
var inst_38334 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_38333,cljs.core.cst$kw$stop);
var state_38347__$1 = state_38347;
if(inst_38334){
var statearr_38352_38369 = state_38347__$1;
(statearr_38352_38369[(1)] = (5));

} else {
var statearr_38353_38370 = state_38347__$1;
(statearr_38353_38370[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38348 === (5))){
var inst_38321 = (state_38347[(7)]);
var inst_38336 = cljs.core.async.timeout(inst_38321);
var state_38347__$1 = state_38347;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38347__$1,(8),inst_38336);
} else {
if((state_val_38348 === (6))){
var state_38347__$1 = state_38347;
var statearr_38354_38371 = state_38347__$1;
(statearr_38354_38371[(2)] = null);

(statearr_38354_38371[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38348 === (7))){
var inst_38343 = (state_38347[(2)]);
var state_38347__$1 = state_38347;
var statearr_38355_38372 = state_38347__$1;
(statearr_38355_38372[(2)] = inst_38343);

(statearr_38355_38372[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38348 === (8))){
var inst_38321 = (state_38347[(7)]);
var inst_38338 = (state_38347[(2)]);
var inst_38339 = (inst_38321 * (2));
var inst_38321__$1 = inst_38339;
var state_38347__$1 = (function (){var statearr_38356 = state_38347;
(statearr_38356[(10)] = inst_38338);

(statearr_38356[(7)] = inst_38321__$1);

return statearr_38356;
})();
var statearr_38357_38373 = state_38347__$1;
(statearr_38357_38373[(2)] = null);

(statearr_38357_38373[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19296__auto__,map__38319,map__38319__$1,on_error,on_export_url,data_type))
;
return ((function (switch__19184__auto__,c__19296__auto__,map__38319,map__38319__$1,on_error,on_export_url,data_type){
return (function() {
var milia$api$async_export$state_machine__19185__auto__ = null;
var milia$api$async_export$state_machine__19185__auto____0 = (function (){
var statearr_38361 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38361[(0)] = milia$api$async_export$state_machine__19185__auto__);

(statearr_38361[(1)] = (1));

return statearr_38361;
});
var milia$api$async_export$state_machine__19185__auto____1 = (function (state_38347){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_38347);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e38362){if((e38362 instanceof Object)){
var ex__19188__auto__ = e38362;
var statearr_38363_38374 = state_38347;
(statearr_38363_38374[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38347);

return cljs.core.cst$kw$recur;
} else {
throw e38362;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__38375 = state_38347;
state_38347 = G__38375;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19185__auto__ = function(state_38347){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19185__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19185__auto____1.call(this,state_38347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19185__auto____0;
milia$api$async_export$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19185__auto____1;
return milia$api$async_export$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto__,map__38319,map__38319__$1,on_error,on_export_url,data_type))
})();
var state__19298__auto__ = (function (){var statearr_38364 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_38364[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto__);

return statearr_38364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto__,map__38319,map__38319__$1,on_error,on_export_url,data_type))
);

return c__19296__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq38315){
var G__38316 = cljs.core.first(seq38315);
var seq38315__$1 = cljs.core.next(seq38315);
var G__38317 = cljs.core.first(seq38315__$1);
var seq38315__$2 = cljs.core.next(seq38315__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__38316,G__38317,seq38315__$2);
});

/**
 * Repeatedly polls the export endpoint given a form_id while any of the
 *    export status is pending.
 */
milia.api.async_export.monitor_async_exports_per_form_BANG_ = (function milia$api$async_export$monitor_async_exports_per_form_BANG_(dataset_id,callback){
var c__19296__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto__){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto__){
return (function (state_38505){
var state_val_38506 = (state_38505[(1)]);
if((state_val_38506 === (7))){
var inst_38480 = (state_38505[(2)]);
var state_38505__$1 = state_38505;
if(cljs.core.truth_(inst_38480)){
var statearr_38507_38537 = state_38505__$1;
(statearr_38507_38537[(1)] = (11));

} else {
var statearr_38508_38538 = state_38505__$1;
(statearr_38508_38538[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38506 === (1))){
var inst_38457 = milia.api.async_export.initial_polling_interval;
var state_38505__$1 = (function (){var statearr_38509 = state_38505;
(statearr_38509[(7)] = inst_38457);

return statearr_38509;
})();
var statearr_38510_38539 = state_38505__$1;
(statearr_38510_38539[(2)] = null);

(statearr_38510_38539[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38506 === (4))){
var inst_38464 = (state_38505[(8)]);
var inst_38464__$1 = (state_38505[(2)]);
var inst_38466 = (inst_38464__$1 == null);
var inst_38467 = cljs.core.not(inst_38466);
var state_38505__$1 = (function (){var statearr_38511 = state_38505;
(statearr_38511[(8)] = inst_38464__$1);

return statearr_38511;
})();
if(inst_38467){
var statearr_38512_38540 = state_38505__$1;
(statearr_38512_38540[(1)] = (5));

} else {
var statearr_38513_38541 = state_38505__$1;
(statearr_38513_38541[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38506 === (15))){
var inst_38457 = (state_38505[(7)]);
var inst_38495 = cljs.core.async.timeout(inst_38457);
var state_38505__$1 = state_38505;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38505__$1,(17),inst_38495);
} else {
if((state_val_38506 === (13))){
var inst_38487 = (state_38505[(9)]);
var inst_38461 = (state_38505[(10)]);
var inst_38457 = (state_38505[(7)]);
var inst_38485 = (state_38505[(2)]);
var inst_38486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38485,cljs.core.cst$kw$status);
var inst_38487__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38485,cljs.core.cst$kw$body);
var inst_38488 = (function (){var polling_interval = inst_38457;
var export_url = inst_38461;
var map__38459 = inst_38485;
var status = inst_38486;
var body = inst_38487__$1;
return ((function (polling_interval,export_url,map__38459,status,body,inst_38487,inst_38461,inst_38457,inst_38485,inst_38486,inst_38487__$1,state_val_38506,c__19296__auto__){
return (function (p1__38376_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$job_status.cljs$core$IFn$_invoke$arity$1(p1__38376_SHARP_),milia.api.async_export.export_pending_status_msg);
});
;})(polling_interval,export_url,map__38459,status,body,inst_38487,inst_38461,inst_38457,inst_38485,inst_38486,inst_38487__$1,state_val_38506,c__19296__auto__))
})();
var inst_38489 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_38488,inst_38487__$1);
var inst_38490 = cljs.core.vec(inst_38489);
var inst_38491 = cljs.core.empty_QMARK_(inst_38490);
var state_38505__$1 = (function (){var statearr_38514 = state_38505;
(statearr_38514[(9)] = inst_38487__$1);

return statearr_38514;
})();
if(inst_38491){
var statearr_38515_38542 = state_38505__$1;
(statearr_38515_38542[(1)] = (14));

} else {
var statearr_38516_38543 = state_38505__$1;
(statearr_38516_38543[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38506 === (6))){
var state_38505__$1 = state_38505;
var statearr_38517_38544 = state_38505__$1;
(statearr_38517_38544[(2)] = false);

(statearr_38517_38544[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38506 === (17))){
var inst_38457 = (state_38505[(7)]);
var inst_38497 = (state_38505[(2)]);
var inst_38498 = (inst_38457 * (2));
var inst_38457__$1 = inst_38498;
var state_38505__$1 = (function (){var statearr_38518 = state_38505;
(statearr_38518[(11)] = inst_38497);

(statearr_38518[(7)] = inst_38457__$1);

return statearr_38518;
})();
var statearr_38519_38545 = state_38505__$1;
(statearr_38519_38545[(2)] = null);

(statearr_38519_38545[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38506 === (3))){
var inst_38503 = (state_38505[(2)]);
var state_38505__$1 = state_38505;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38505__$1,inst_38503);
} else {
if((state_val_38506 === (12))){
var inst_38464 = (state_38505[(8)]);
var state_38505__$1 = state_38505;
var statearr_38520_38546 = state_38505__$1;
(statearr_38520_38546[(2)] = inst_38464);

(statearr_38520_38546[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38506 === (2))){
var inst_38461 = (state_38505[(10)]);
var inst_38460 = milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export?xform=",dataset_id,"&"], 0));
var inst_38461__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_38460], 0));
var inst_38462 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_38461__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_38505__$1 = (function (){var statearr_38521 = state_38505;
(statearr_38521[(10)] = inst_38461__$1);

return statearr_38521;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38505__$1,(4),inst_38462);
} else {
if((state_val_38506 === (11))){
var inst_38464 = (state_38505[(8)]);
var inst_38482 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38464);
var state_38505__$1 = state_38505;
var statearr_38522_38547 = state_38505__$1;
(statearr_38522_38547[(2)] = inst_38482);

(statearr_38522_38547[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38506 === (9))){
var state_38505__$1 = state_38505;
var statearr_38523_38548 = state_38505__$1;
(statearr_38523_38548[(2)] = false);

(statearr_38523_38548[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38506 === (5))){
var inst_38464 = (state_38505[(8)]);
var inst_38469 = inst_38464.cljs$lang$protocol_mask$partition0$;
var inst_38470 = (inst_38469 & (64));
var inst_38471 = inst_38464.cljs$core$ISeq$;
var inst_38472 = (cljs.core.PROTOCOL_SENTINEL === inst_38471);
var inst_38473 = (inst_38470) || (inst_38472);
var state_38505__$1 = state_38505;
if(cljs.core.truth_(inst_38473)){
var statearr_38524_38549 = state_38505__$1;
(statearr_38524_38549[(1)] = (8));

} else {
var statearr_38525_38550 = state_38505__$1;
(statearr_38525_38550[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38506 === (14))){
var inst_38487 = (state_38505[(9)]);
var inst_38493 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_38487) : callback.call(null,inst_38487));
var state_38505__$1 = state_38505;
var statearr_38526_38551 = state_38505__$1;
(statearr_38526_38551[(2)] = inst_38493);

(statearr_38526_38551[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38506 === (16))){
var inst_38501 = (state_38505[(2)]);
var state_38505__$1 = state_38505;
var statearr_38527_38552 = state_38505__$1;
(statearr_38527_38552[(2)] = inst_38501);

(statearr_38527_38552[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38506 === (10))){
var inst_38477 = (state_38505[(2)]);
var state_38505__$1 = state_38505;
var statearr_38528_38553 = state_38505__$1;
(statearr_38528_38553[(2)] = inst_38477);

(statearr_38528_38553[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38506 === (8))){
var state_38505__$1 = state_38505;
var statearr_38529_38554 = state_38505__$1;
(statearr_38529_38554[(2)] = true);

(statearr_38529_38554[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19296__auto__))
;
return ((function (switch__19184__auto__,c__19296__auto__){
return (function() {
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19185__auto__ = null;
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19185__auto____0 = (function (){
var statearr_38533 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38533[(0)] = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19185__auto__);

(statearr_38533[(1)] = (1));

return statearr_38533;
});
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19185__auto____1 = (function (state_38505){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_38505);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e38534){if((e38534 instanceof Object)){
var ex__19188__auto__ = e38534;
var statearr_38535_38555 = state_38505;
(statearr_38535_38555[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38505);

return cljs.core.cst$kw$recur;
} else {
throw e38534;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__38556 = state_38505;
state_38505 = G__38556;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19185__auto__ = function(state_38505){
switch(arguments.length){
case 0:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19185__auto____0.call(this);
case 1:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19185__auto____1.call(this,state_38505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19185__auto____0;
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19185__auto____1;
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto__))
})();
var state__19298__auto__ = (function (){var statearr_38536 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_38536[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto__);

return statearr_38536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto__))
);

return c__19296__auto__;
});
milia.api.async_export.version_key = "_version";
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_hxl","include_images","remove_group_name",milia.api.async_export.version_key,"query","export_id","include_labels","include_labels_only","win_excel_utf8","redirect_uri","binary_select_multiples","value_select_multiples","show_choice_labels","include_reviews"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_hxl_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id,cljs.core.cst$kw$include_DASH_labels_QMARK_,cljs.core.cst$kw$labels_DASH_only_QMARK_,cljs.core.cst$kw$windows_DASH_compatible_DASH_csv_QMARK_,cljs.core.cst$kw$redirect_DASH_uri,cljs.core.cst$kw$binary_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$value_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$show_DASH_choice_DASH_labels_QMARK_,cljs.core.cst$kw$include_DASH_reviews_QMARK_], null);
milia.api.async_export.get_param = (function milia$api$async_export$get_param(key,value){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,milia.api.async_export.version_key)){
return goog.string.format("&query={\"%s\":\"%s\"}",key,value);
} else {
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
}
});
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_((function (){var or__6543__auto__ = value;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
return milia.api.async_export.get_param(key,value);
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38564 = arguments.length;
var i__7652__auto___38565 = (0);
while(true){
if((i__7652__auto___38565 < len__7651__auto___38564)){
args__7658__auto__.push((arguments[i__7652__auto___38565]));

var G__38566 = (i__7652__auto___38565 + (1));
i__7652__auto___38565 = G__38566;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__38560){
var vec__38561 = p__38560;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38561,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq38557){
var G__38558 = cljs.core.first(seq38557);
var seq38557__$1 = cljs.core.next(seq38557);
var G__38559 = cljs.core.first(seq38557__$1);
var seq38557__$2 = cljs.core.next(seq38557__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__38558,G__38559,seq38557__$2);
});

/**
 * Triggers async export and watches it via polling.
 *    Fires on-job-id callback on receving :job_uuid from server, then monitors
 *    job via polling.
 *    On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38616 = arguments.length;
var i__7652__auto___38617 = (0);
while(true){
if((i__7652__auto___38617 < len__7651__auto___38616)){
args__7658__auto__.push((arguments[i__7652__auto___38617]));

var G__38618 = (i__7652__auto___38617 + (1));
i__7652__auto___38617 = G__38618;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__38569){
var vec__38570 = p__38569;
var map__38573 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38570,(0),null);
var map__38573__$1 = ((((!((map__38573 == null)))?((((map__38573.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38573.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38573):map__38573);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38573__$1,cljs.core.cst$kw$data_DASH_type);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38573__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38573__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38573__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38573__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38573__$1,cljs.core.cst$kw$on_DASH_error);
var on_done = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38573__$1,cljs.core.cst$kw$on_DASH_done);
var c__19296__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto__,vec__38570,map__38573,map__38573__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto__,vec__38570,map__38573,map__38573__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (state_38596){
var state_val_38597 = (state_38596[(1)]);
if((state_val_38597 === (1))){
var inst_38577 = (state_38596[(7)]);
var inst_38575 = (state_38596[(8)]);
var inst_38575__$1 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var inst_38576 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_38577__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_38576,dataset_id,inst_38575__$1], 0));
var inst_38578 = milia.utils.retry.retry_parse_http(cljs.core.cst$kw$get,inst_38577__$1);
var state_38596__$1 = (function (){var statearr_38598 = state_38596;
(statearr_38598[(7)] = inst_38577__$1);

(statearr_38598[(8)] = inst_38575__$1);

return statearr_38598;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38596__$1,(2),inst_38578);
} else {
if((state_val_38597 === (2))){
var inst_38577 = (state_38596[(7)]);
var inst_38575 = (state_38596[(8)]);
var inst_38580 = (state_38596[(9)]);
var inst_38580__$1 = (state_38596[(2)]);
var inst_38581 = (function (){var export_suffix = inst_38575;
var export_url = inst_38577;
var response = inst_38580__$1;
return ((function (export_suffix,export_url,response,inst_38577,inst_38575,inst_38580,inst_38580__$1,state_val_38597,c__19296__auto__,vec__38570,map__38573,map__38573__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([cljs.core.cst$kw$on_DASH_export_DASH_url,on_export_url,cljs.core.cst$kw$on_DASH_error,on_error,cljs.core.cst$kw$data_DASH_type,data_type], 0));
});
;})(export_suffix,export_url,response,inst_38577,inst_38575,inst_38580,inst_38580__$1,state_val_38597,c__19296__auto__,vec__38570,map__38573,map__38573__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state_38596__$1 = (function (){var statearr_38599 = state_38596;
(statearr_38599[(10)] = inst_38581);

(statearr_38599[(9)] = inst_38580__$1);

return statearr_38599;
})();
if(cljs.core.truth_(on_done)){
var statearr_38600_38619 = state_38596__$1;
(statearr_38600_38619[(1)] = (3));

} else {
var statearr_38601_38620 = state_38596__$1;
(statearr_38601_38620[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38597 === (3))){
var inst_38580 = (state_38596[(9)]);
var inst_38583 = (on_done.cljs$core$IFn$_invoke$arity$1 ? on_done.cljs$core$IFn$_invoke$arity$1(inst_38580) : on_done.call(null,inst_38580));
var state_38596__$1 = state_38596;
var statearr_38602_38621 = state_38596__$1;
(statearr_38602_38621[(2)] = inst_38583);

(statearr_38602_38621[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38597 === (4))){
var state_38596__$1 = state_38596;
var statearr_38603_38622 = state_38596__$1;
(statearr_38603_38622[(2)] = null);

(statearr_38603_38622[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38597 === (5))){
var inst_38586 = (state_38596[(2)]);
var inst_38587 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var state_38596__$1 = (function (){var statearr_38604 = state_38596;
(statearr_38604[(11)] = inst_38587);

(statearr_38604[(12)] = inst_38586);

return statearr_38604;
})();
if(cljs.core.truth_(on_done)){
var statearr_38605_38623 = state_38596__$1;
(statearr_38605_38623[(1)] = (6));

} else {
var statearr_38606_38624 = state_38596__$1;
(statearr_38606_38624[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38597 === (6))){
var state_38596__$1 = state_38596;
var statearr_38607_38625 = state_38596__$1;
(statearr_38607_38625[(2)] = on_job_id);

(statearr_38607_38625[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38597 === (7))){
var inst_38581 = (state_38596[(10)]);
var state_38596__$1 = state_38596;
var statearr_38608_38626 = state_38596__$1;
(statearr_38608_38626[(2)] = inst_38581);

(statearr_38608_38626[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38597 === (8))){
var inst_38587 = (state_38596[(11)]);
var inst_38580 = (state_38596[(9)]);
var inst_38591 = (state_38596[(2)]);
var inst_38592 = [on_error,inst_38591,on_export_url];
var inst_38593 = cljs.core.PersistentHashMap.fromArrays(inst_38587,inst_38592);
var inst_38594 = milia.api.async_export.handle_response(inst_38580,inst_38593);
var state_38596__$1 = state_38596;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38596__$1,inst_38594);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__19296__auto__,vec__38570,map__38573,map__38573__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
;
return ((function (switch__19184__auto__,c__19296__auto__,vec__38570,map__38573,map__38573__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function() {
var milia$api$async_export$state_machine__19185__auto__ = null;
var milia$api$async_export$state_machine__19185__auto____0 = (function (){
var statearr_38612 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38612[(0)] = milia$api$async_export$state_machine__19185__auto__);

(statearr_38612[(1)] = (1));

return statearr_38612;
});
var milia$api$async_export$state_machine__19185__auto____1 = (function (state_38596){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_38596);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e38613){if((e38613 instanceof Object)){
var ex__19188__auto__ = e38613;
var statearr_38614_38627 = state_38596;
(statearr_38614_38627[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38596);

return cljs.core.cst$kw$recur;
} else {
throw e38613;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__38628 = state_38596;
state_38596 = G__38628;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19185__auto__ = function(state_38596){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19185__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19185__auto____1.call(this,state_38596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19185__auto____0;
milia$api$async_export$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19185__auto____1;
return milia$api$async_export$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto__,vec__38570,map__38573,map__38573__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state__19298__auto__ = (function (){var statearr_38615 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_38615[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto__);

return statearr_38615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto__,vec__38570,map__38573,map__38573__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
);

return c__19296__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq38567){
var G__38568 = cljs.core.first(seq38567);
var seq38567__$1 = cljs.core.next(seq38567);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__38568,seq38567__$1);
});

/**
 * Returns a channel, which will have the async export url when ready.
 */
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,((function (ch){
return (function (p1__38629_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__38629_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
/**
 * Returns a channel, which will have the async _data_
 *  downloaded using http-method when ready.
 */
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___38654 = arguments.length;
var i__7652__auto___38655 = (0);
while(true){
if((i__7652__auto___38655 < len__7651__auto___38654)){
args__7658__auto__.push((arguments[i__7652__auto___38655]));

var G__38656 = (i__7652__auto___38655 + (1));
i__7652__auto___38655 = G__38656;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){
var c__19296__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19296__auto__){
return (function (){
var f__19297__auto__ = (function (){var switch__19184__auto__ = ((function (c__19296__auto__){
return (function (state_38645){
var state_val_38646 = (state_38645[(1)]);
if((state_val_38646 === (1))){
var inst_38634 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_38645__$1 = state_38645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38645__$1,(2),inst_38634);
} else {
if((state_val_38646 === (2))){
var inst_38636 = (state_38645[(2)]);
var inst_38637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38638 = [http_method,inst_38636];
var inst_38639 = (new cljs.core.PersistentVector(null,2,(5),inst_38637,inst_38638,null));
var inst_38640 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38639,args);
var inst_38641 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_38640);
var state_38645__$1 = state_38645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38645__$1,(3),inst_38641);
} else {
if((state_val_38646 === (3))){
var inst_38643 = (state_38645[(2)]);
var state_38645__$1 = state_38645;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38645__$1,inst_38643);
} else {
return null;
}
}
}
});})(c__19296__auto__))
;
return ((function (switch__19184__auto__,c__19296__auto__){
return (function() {
var milia$api$async_export$state_machine__19185__auto__ = null;
var milia$api$async_export$state_machine__19185__auto____0 = (function (){
var statearr_38650 = [null,null,null,null,null,null,null];
(statearr_38650[(0)] = milia$api$async_export$state_machine__19185__auto__);

(statearr_38650[(1)] = (1));

return statearr_38650;
});
var milia$api$async_export$state_machine__19185__auto____1 = (function (state_38645){
while(true){
var ret_value__19186__auto__ = (function (){try{while(true){
var result__19187__auto__ = switch__19184__auto__(state_38645);
if(cljs.core.keyword_identical_QMARK_(result__19187__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19187__auto__;
}
break;
}
}catch (e38651){if((e38651 instanceof Object)){
var ex__19188__auto__ = e38651;
var statearr_38652_38657 = state_38645;
(statearr_38652_38657[(5)] = ex__19188__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38645);

return cljs.core.cst$kw$recur;
} else {
throw e38651;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19186__auto__,cljs.core.cst$kw$recur)){
var G__38658 = state_38645;
state_38645 = G__38658;
continue;
} else {
return ret_value__19186__auto__;
}
break;
}
});
milia$api$async_export$state_machine__19185__auto__ = function(state_38645){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__19185__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__19185__auto____1.call(this,state_38645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__19185__auto____0;
milia$api$async_export$state_machine__19185__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__19185__auto____1;
return milia$api$async_export$state_machine__19185__auto__;
})()
;})(switch__19184__auto__,c__19296__auto__))
})();
var state__19298__auto__ = (function (){var statearr_38653 = (f__19297__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19297__auto__.cljs$core$IFn$_invoke$arity$0() : f__19297__auto__.call(null));
(statearr_38653[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19296__auto__);

return statearr_38653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19298__auto__);
});})(c__19296__auto__))
);

return c__19296__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq38630){
var G__38631 = cljs.core.first(seq38630);
var seq38630__$1 = cljs.core.next(seq38630);
var G__38632 = cljs.core.first(seq38630__$1);
var seq38630__$2 = cljs.core.next(seq38630__$1);
var G__38633 = cljs.core.first(seq38630__$2);
var seq38630__$3 = cljs.core.next(seq38630__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__38631,G__38632,G__38633,seq38630__$3);
});

/**
 * Get exports based on a form id.
 */
milia.api.async_export.get_exports_per_form = (function milia$api$async_export$get_exports_per_form(dataset_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export?xform=",dataset_id,"&"], 0))], 0)));
});
/**
 * Delete an export based on an export id
 */
milia.api.async_export.delete_export = (function milia$api$async_export$delete_export(export_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export",milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([export_id,"?"], 0))], 0)));
});
