// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('chimera.string');
goog.require('cljs.core');
goog.require('chimera.core');
goog.require('clojure.string');
goog.require('cljs.pprint');
chimera.string.email_regex = /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,6}$/i;
chimera.string.twitter_username_regex = /^[A-Za-z0-9_]*$/;
chimera.string.domain_name_regex = /([a-z0-9|-]+\.)*[a-z0-9|-]+\.[a-z]+/;
chimera.string.truncate_if_longer_than = (50);
chimera.string.ellipsis_start = (36);
chimera.string.ellipsis_stop_from_end = (12);
/**
 * Return true if string value is true else false
 */
chimera.string.str_is_true_QMARK_ = (function chimera$string$str_is_true_QMARK_(value){
var and__6531__auto__ = value;
if(cljs.core.truth_(and__6531__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(clojure.string.lower_case(value),"true");
} else {
return and__6531__auto__;
}
});
chimera.string.chars__GT_entities = new cljs.core.PersistentArrayMap(null, 5, ["<","&lt;",">","&gt;","&","&amp;","\"","&quot;","'","&#39;"], null);
chimera.string.vowel_QMARK_ = cljs.core.set("aeiou");
chimera.string.parenthesize_suffix = (function chimera$string$parenthesize_suffix(prefix,suffix){
return [cljs.core.str(prefix),cljs.core.str(" ("),cljs.core.str(suffix),cljs.core.str(")")].join('');
});
/**
 * Shorten a string to a certain length with middle ellipsis.
 */
chimera.string.truncate_with_ellipsis = (function chimera$string$truncate_with_ellipsis(s){
if((cljs.core.count(s) > chimera.string.truncate_if_longer_than)){
var end_start = (cljs.core.count(s) - chimera.string.ellipsis_stop_from_end);
return [cljs.core.str(cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),chimera.string.ellipsis_start)),cljs.core.str("..."),cljs.core.str(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,end_start))].join('');
} else {
return s;
}
});
/**
 * Return the first character of a string capitalized.
 */
chimera.string.first_cap = (function chimera$string$first_cap(s){
return clojure.string.capitalize([cljs.core.str(cljs.core.first(s))].join(''));
});
/**
 * True if `s` is an email address.
 */
chimera.string.is_email_QMARK_ = (function chimera$string$is_email_QMARK_(s){
return cljs.core.first(s.match(chimera.string.email_regex));
});
/**
 * True if `s` is a valid twitter username
 */
chimera.string.is_twitter_username_QMARK_ = (function chimera$string$is_twitter_username_QMARK_(s){
return cljs.core.first(s.match(chimera.string.twitter_username_regex));
});
/**
 * Wrap the count of a collection in parens and postfix.
 */
chimera.string.postfix_paren_count = (function chimera$string$postfix_paren_count(prefix,collection){
return chimera.string.parenthesize_suffix(prefix,cljs.core.count(collection));
});
/**
 * True if `s` ends with the passed suffix.
 */
chimera.string.ends_with_QMARK_ = (function chimera$string$ends_with_QMARK_(s,suffix){
var offset = (cljs.core.count(s) - cljs.core.count(suffix));
return ((offset >= (0))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(suffix,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,offset)));
});
/**
 * Serialize a Clojure map to JavaScript string map.
 */
chimera.string.map__GT_js_string_map = (function chimera$string$map__GT_js_string_map(m){
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.flatten(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["{",cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",(function (){var iter__7326__auto__ = (function chimera$string$map__GT_js_string_map_$_iter__37326(s__37327){
return (new cljs.core.LazySeq(null,(function (){
var s__37327__$1 = s__37327;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37327__$1);
if(temp__4657__auto__){
var s__37327__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37327__$2)){
var c__7324__auto__ = cljs.core.chunk_first(s__37327__$2);
var size__7325__auto__ = cljs.core.count(c__7324__auto__);
var b__37329 = cljs.core.chunk_buffer(size__7325__auto__);
if((function (){var i__37328 = (0);
while(true){
if((i__37328 < size__7325__auto__)){
var vec__37338 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7324__auto__,i__37328);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37338,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37338,(1),null);
cljs.core.chunk_append(b__37329,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name(k),"\":\"",v,"\""], null));

var G__37344 = (i__37328 + (1));
i__37328 = G__37344;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37329),chimera$string$map__GT_js_string_map_$_iter__37326(cljs.core.chunk_rest(s__37327__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37329),null);
}
} else {
var vec__37341 = cljs.core.first(s__37327__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37341,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37341,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["\"",cljs.core.name(k),"\":\"",v,"\""], null),chimera$string$map__GT_js_string_map_$_iter__37326(cljs.core.rest(s__37327__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7326__auto__(m);
})()),"}"], null)));
});
/**
 * True if the first letter of `s` is a vowel.
 */
chimera.string.begins_with_vowel_QMARK_ = (function chimera$string$begins_with_vowel_QMARK_(s){
var G__37346 = cljs.core.first(clojure.string.lower_case(cljs.core.first(s)));
return (chimera.string.vowel_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.vowel_QMARK_.cljs$core$IFn$_invoke$arity$1(G__37346) : chimera.string.vowel_QMARK_.call(null,G__37346));
});
/**
 * If `s` is a string and equal to 'false' in lower case return false,
 * otherwise return `s`.
 */
chimera.string.false_str__GT_false = (function chimera$string$false_str__GT_false(s){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((function (){var and__6531__auto__ = typeof s === 'string';
if(and__6531__auto__){
return clojure.string.lower_case(s);
} else {
return and__6531__auto__;
}
})(),"false")){
return false;
} else {
return s;
}
});
/**
 * Render a JSON error as a string for the user.
 */
chimera.string.error_json__GT_str = (function chimera$string$error_json__GT_str(json){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("<br/>",(function (){var iter__7326__auto__ = (function chimera$string$error_json__GT_str_$_iter__37369(s__37370){
return (new cljs.core.LazySeq(null,(function (){
var s__37370__$1 = s__37370;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__37370__$1);
if(temp__4657__auto__){
var s__37370__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__37370__$2)){
var c__7324__auto__ = cljs.core.chunk_first(s__37370__$2);
var size__7325__auto__ = cljs.core.count(c__7324__auto__);
var b__37372 = cljs.core.chunk_buffer(size__7325__auto__);
if((function (){var i__37371 = (0);
while(true){
if((i__37371 < size__7325__auto__)){
var vec__37383 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7324__auto__,i__37371);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37383,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37383,(1),null);
var key = clojure.string.capitalize(cljs.core.name(k));
var value = (function (){var G__37386 = v;
if(cljs.core.vector_QMARK_(v)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__37386);
} else {
return G__37386;
}
})();
cljs.core.chunk_append(b__37372,[cljs.core.str(key),cljs.core.str(": "),cljs.core.str(value)].join(''));

var G__37391 = (i__37371 + (1));
i__37371 = G__37391;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__37372),chimera$string$error_json__GT_str_$_iter__37369(cljs.core.chunk_rest(s__37370__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__37372),null);
}
} else {
var vec__37387 = cljs.core.first(s__37370__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37387,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37387,(1),null);
var key = clojure.string.capitalize(cljs.core.name(k));
var value = (function (){var G__37390 = v;
if(cljs.core.vector_QMARK_(v)){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__37390);
} else {
return G__37390;
}
})();
return cljs.core.cons([cljs.core.str(key),cljs.core.str(": "),cljs.core.str(value)].join(''),chimera$string$error_json__GT_str_$_iter__37369(cljs.core.rest(s__37370__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7326__auto__(json);
})());
});
/**
 * Build an unescaped string.
 */
chimera.string.unescape = (function chimera$string$unescape(s){
if(typeof s === 'string'){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (r,p__37396){
var vec__37397 = p__37396;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37397,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37397,(1),null);
return clojure.string.replace(r,cljs.core.re_pattern(v),[cljs.core.str(k)].join(''));
}),s,chimera.string.chars__GT_entities);
} else {
return s;
}
});
/**
 * Checks if a variable is null
 */
chimera.string.is_null_QMARK_ = (function chimera$string$is_null_QMARK_(s){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("null",s);
});
/**
 * Checks if a variable is null or nil
 */
chimera.string.is_null_or_nil_QMARK_ = (function chimera$string$is_null_or_nil_QMARK_(s){
var or__6543__auto__ = chimera.string.is_null_QMARK_(s);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return (s == null);
}
});
chimera.string.is_not_null_QMARK_ = cljs.core.complement(chimera.string.is_null_QMARK_);
chimera.string.safe_lower_case = (function chimera$string$safe_lower_case(str){
if(typeof str === 'string'){
return clojure.string.lower_case(str);
} else {
return null;
}
});
/**
 * True if substring is a substring of `s`
 */
chimera.string.substring_QMARK_ = (function chimera$string$substring_QMARK_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37407 = arguments.length;
var i__7652__auto___37408 = (0);
while(true){
if((i__7652__auto___37408 < len__7651__auto___37407)){
args__7658__auto__.push((arguments[i__7652__auto___37408]));

var G__37409 = (i__7652__auto___37408 + (1));
i__7652__auto___37408 = G__37409;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (substring,s,p__37403){
var map__37404 = p__37403;
var map__37404__$1 = ((((!((map__37404 == null)))?((((map__37404.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37404.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37404):map__37404);
var case_sensitive_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__37404__$1,cljs.core.cst$kw$case_DASH_sensitive_QMARK_,true);
if(cljs.core.truth_((function (){var or__6543__auto__ = cljs.core.empty_QMARK_(s);
if(or__6543__auto__){
return or__6543__auto__;
} else {
return chimera.string.is_null_QMARK_(s);
}
})())){
return false;
} else {
var G__37406 = cljs.core.re_find(cljs.core.re_pattern([cljs.core.str((cljs.core.truth_(case_sensitive_QMARK_)?null:"(?i)")),cljs.core.str(substring)].join('')),s);
return (chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(G__37406) : chimera.core.not_nil_QMARK_.call(null,G__37406));
}
});

chimera.string.substring_QMARK_.cljs$lang$maxFixedArity = (2);

chimera.string.substring_QMARK_.cljs$lang$applyTo = (function (seq37400){
var G__37401 = cljs.core.first(seq37400);
var seq37400__$1 = cljs.core.next(seq37400);
var G__37402 = cljs.core.first(seq37400__$1);
var seq37400__$2 = cljs.core.next(seq37400__$1);
return chimera.string.substring_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__37401,G__37402,seq37400__$2);
});

/**
 * Insert a comma into numbers in thousands and higher
 */
chimera.string.humanize_number = (function chimera$string$humanize_number(n){
return cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~:d",cljs.core.array_seq([n], 0));
});
/**
 * Escape for types. Replaces characters in the string with this base on
 *   chars->entities map.
 */
chimera.string.escape_for_type = (function chimera$string$escape_for_type(x){
if((x == null)){
return "null";
} else {
if(typeof x === 'string'){
return clojure.string.escape(x,chimera.string.chars__GT_entities);
} else {
return x;

}
}
});
chimera.string.get_query_params_str = (function chimera$string$get_query_params_str(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37417 = arguments.length;
var i__7652__auto___37418 = (0);
while(true){
if((i__7652__auto___37418 < len__7651__auto___37417)){
args__7658__auto__.push((arguments[i__7652__auto___37418]));

var G__37419 = (i__7652__auto___37418 + (1));
i__7652__auto___37418 = G__37419;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return chimera.string.get_query_params_str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

chimera.string.get_query_params_str.cljs$core$IFn$_invoke$arity$variadic = (function (query_params_map,p__37412){
var vec__37413 = p__37412;
var query_param_str = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37413,(0),null);

var query_param_str__$1 = [cljs.core.str(query_param_str)].join('');
var query_param_str_blank_QMARK_ = clojure.string.blank_QMARK_(query_param_str__$1);
var key = cljs.core.first(cljs.core.keys(query_params_map));
var query_param_key = cljs.core.name((function (){var or__6543__auto__ = key;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "";
}
})());
var query_param_val = (function (){var and__6531__auto__ = key;
if(cljs.core.truth_(and__6531__auto__)){
return (key.cljs$core$IFn$_invoke$arity$1 ? key.cljs$core$IFn$_invoke$arity$1(query_params_map) : key.call(null,query_params_map));
} else {
return and__6531__auto__;
}
})();
var G__37416 = cljs.core.count(query_params_map);
switch (G__37416) {
case (0):
return null;

break;
case (1):
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(((query_param_str_blank_QMARK_)?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?",query_param_key,"=",query_param_val], null):new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [query_param_str__$1,"&",query_param_key,"=",query_param_val], null)));

break;
default:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(chimera.string.get_query_params_str,((query_param_str_blank_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [query_params_map,[cljs.core.str("?")].join('')], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.rest(query_params_map)),[cljs.core.str(query_param_str__$1),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(query_param_str__$1,"?"))?null:"&")),cljs.core.str(query_param_key),cljs.core.str("="),cljs.core.str(query_param_val)].join('')], null)));

}
});

chimera.string.get_query_params_str.cljs$lang$maxFixedArity = (1);

chimera.string.get_query_params_str.cljs$lang$applyTo = (function (seq37410){
var G__37411 = cljs.core.first(seq37410);
var seq37410__$1 = cljs.core.next(seq37410);
return chimera.string.get_query_params_str.cljs$core$IFn$_invoke$arity$variadic(G__37411,seq37410__$1);
});

