// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.organization');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('cljs.core.async');
milia.api.organization.internal_members_team_name = "members";
milia.api.organization.owners_team_name = "Owners";
milia.api.organization.editor_role = "editor";
/**
 * List all the organizations belonging to the account making the request.
 * When a username is provided, return only those organizations shared by both
 * the account making the request and the user associated with the username.
 */
milia.api.organization.all = (function milia$api$organization$all(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37960 = arguments.length;
var i__7652__auto___37961 = (0);
while(true){
if((i__7652__auto___37961 < len__7651__auto___37960)){
args__7658__auto__.push((arguments[i__7652__auto___37961]));

var G__37962 = (i__7652__auto___37961 + (1));
i__7652__auto___37961 = G__37962;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.organization.all.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.organization.all.cljs$core$IFn$_invoke$arity$variadic = (function (p__37956){
var vec__37957 = p__37956;
var username = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37957,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(username)?[cljs.core.str("orgs?shared_with="),cljs.core.str(username)].join(''):"orgs")], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.organization.all.cljs$lang$maxFixedArity = (0);

milia.api.organization.all.cljs$lang$applyTo = (function (seq37955){
return milia.api.organization.all.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq37955));
});

milia.api.organization.create = (function milia$api$organization$create(data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
milia.api.organization.profile = (function milia$api$organization$profile(var_args){
var args__7658__auto__ = [];
var len__7651__auto___37968 = arguments.length;
var i__7652__auto___37969 = (0);
while(true){
if((i__7652__auto___37969 < len__7651__auto___37968)){
args__7658__auto__.push((arguments[i__7652__auto___37969]));

var G__37970 = (i__7652__auto___37969 + (1));
i__7652__auto___37969 = G__37970;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic = (function (org_name,p__37965){
var map__37966 = p__37965;
var map__37966__$1 = ((((!((map__37966 == null)))?((((map__37966.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37966.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__37966):map__37966);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37966__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.organization.profile.cljs$lang$maxFixedArity = (1);

milia.api.organization.profile.cljs$lang$applyTo = (function (seq37963){
var G__37964 = cljs.core.first(seq37963);
var seq37963__$1 = cljs.core.next(seq37963);
return milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic(G__37964,seq37963__$1);
});

milia.api.organization.retrieve_org_metadata = (function milia$api$organization$retrieve_org_metadata(username){
return cljs.core.cst$kw$metadata.cljs$core$IFn$_invoke$arity$1(milia.api.organization.profile(username));
});
/**
 * Return whether a user can create projects within an organization
 */
milia.api.organization.can_user_create_project_under_organization_QMARK_ = (function milia$api$organization$can_user_create_project_under_organization_QMARK_(username_to_check,organization){
var role = cljs.core.cst$kw$role.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__37971_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$user.cljs$core$IFn$_invoke$arity$1(p1__37971_SHARP_),username_to_check);
}),cljs.core.cst$kw$users.cljs$core$IFn$_invoke$arity$1(organization))));
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(role,"manager")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(role,"owner"));
});
milia.api.organization.get_organizations_where_user_can_create_projects = (function milia$api$organization$get_organizations_where_user_can_create_projects(username_to_check){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__37972_SHARP_){
return milia.api.organization.can_user_create_project_under_organization_QMARK_(username_to_check,p1__37972_SHARP_);
}),milia.api.organization.all());
});
/**
 * Return all the teams for an organization.
 */
milia.api.organization.teams_all = (function milia$api$organization$teams_all(var_args){
var args37973 = [];
var len__7651__auto___37976 = arguments.length;
var i__7652__auto___37977 = (0);
while(true){
if((i__7652__auto___37977 < len__7651__auto___37976)){
args37973.push((arguments[i__7652__auto___37977]));

var G__37978 = (i__7652__auto___37977 + (1));
i__7652__auto___37977 = G__37978;
continue;
} else {
}
break;
}

var G__37975 = args37973.length;
switch (G__37975) {
case 0:
return milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37973.length)].join('')));

}
});

milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$1(null);
});

milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$1 = (function (organization_name){
var base_url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams"], 0));
var url = (cljs.core.truth_(organization_name)?[cljs.core.str(base_url),cljs.core.str("?org="),cljs.core.str(organization_name)].join(''):base_url);
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.organization.teams_all.cljs$lang$maxFixedArity = 1;

/**
 * Return the teams for an organization, removing 'members' team that is used
 * internall by the API to store non-team based org members.
 */
milia.api.organization.teams = (function milia$api$organization$teams(org_name){
var teams = milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$0();
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (teams){
return (function (p1__37980_SHARP_){
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(milia.api.organization.internal_members_team_name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(p1__37980_SHARP_))) || (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(org_name,cljs.core.cst$kw$organization.cljs$core$IFn$_invoke$arity$1(p1__37980_SHARP_)));
});})(teams))
,teams);
});
milia.api.organization.team_info = (function milia$api$organization$team_info(org_name,team_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",org_name,team_id], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.organization.team_members = (function milia$api$organization$team_members(team_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",team_id,"members"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add a team to an organization
 */
milia.api.organization.create_team = (function milia$api$organization$create_team(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Add a user to a team
 */
milia.api.organization.add_team_member = (function milia$api$organization$add_team_member(org_name,team_id,user){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",org_name,team_id,"members"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,user], null)], 0));
});
milia.api.organization.members = (function milia$api$organization$members(org_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add a user to an organization
 */
milia.api.organization.add_member = (function milia$api$organization$add_member(var_args){
var args37981 = [];
var len__7651__auto___37984 = arguments.length;
var i__7652__auto___37985 = (0);
while(true){
if((i__7652__auto___37985 < len__7651__auto___37984)){
args37981.push((arguments[i__7652__auto___37985]));

var G__37986 = (i__7652__auto___37985 + (1));
i__7652__auto___37985 = G__37986;
continue;
} else {
}
break;
}

var G__37983 = args37981.length;
switch (G__37983) {
case 2:
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37981.length)].join('')));

}
});

milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$2 = (function (org_name,member){
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3(org_name,member,null);
});

milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3 = (function (org_name,member,role){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members"], 0));
var assigned_role = (function (){var or__6543__auto__ = role;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return milia.api.organization.editor_role;
}
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,member,cljs.core.cst$kw$role,assigned_role], null)], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});

milia.api.organization.add_member.cljs$lang$maxFixedArity = 3;

/**
 * Change the role of an organization member
 */
milia.api.organization.change_org_member_role = (function milia$api$organization$change_org_member_role(member,org_name,event_chan){
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,cljs.core.cst$kw$username.cljs$core$IFn$_invoke$arity$1(member),cljs.core.cst$kw$role,cljs.core.cst$kw$role.cljs$core$IFn$_invoke$arity$1(member)], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members"], 0)),cljs.core.array_seq([cljs.core.cst$kw$callback,((function (data){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$updated_DASH_member,member], null));
});})(data))
,cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,data], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
/**
 * Remove a user from an organization or organization team
 */
milia.api.organization.remove_member = (function milia$api$organization$remove_member(var_args){
var args37988 = [];
var len__7651__auto___37991 = arguments.length;
var i__7652__auto___37992 = (0);
while(true){
if((i__7652__auto___37992 < len__7651__auto___37991)){
args37988.push((arguments[i__7652__auto___37992]));

var G__37993 = (i__7652__auto___37992 + (1));
i__7652__auto___37992 = G__37993;
continue;
} else {
}
break;
}

var G__37990 = args37988.length;
switch (G__37990) {
case 2:
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args37988.length)].join('')));

}
});

milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$2 = (function (org_name,member){
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3(org_name,member,null);
});

milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3 = (function (org_name,member,team_id){
var url = (cljs.core.truth_(team_id)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",org_name,team_id,"members"], 0)):milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members"], 0)));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$delete,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$username,member], null)], null)], 0));
});

milia.api.organization.remove_member.cljs$lang$maxFixedArity = 3;

/**
 * Is the user the only member of the Owners team.
 */
milia.api.organization.single_owner_QMARK_ = (function milia$api$organization$single_owner_QMARK_(team,members){
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(milia.api.organization.owners_team_name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(team))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(members)));
});
/**
 * Is user only members in org with owner role?
 */
milia.api.organization.single_owner_member_QMARK_ = (function milia$api$organization$single_owner_member_QMARK_(org_name){
var org = milia.api.organization.profile(org_name);
var users = cljs.core.cst$kw$users.cljs$core$IFn$_invoke$arity$1(org);
var owner_roles = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (org,users){
return (function (p1__37995_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("owner",p1__37995_SHARP_);
});})(org,users))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$role,users));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(owner_roles),(1));
});
/**
 * update organization profile
 */
milia.api.organization.update = (function milia$api$organization$update(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",cljs.core.cst$kw$org.cljs$core$IFn$_invoke$arity$1(params)], 0));
var params__$1 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(params,cljs.core.cst$kw$org);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,params__$1], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
/**
 * Returns an Organizaion team given the team name.
 */
milia.api.organization.get_team = (function milia$api$organization$get_team(org_name,team_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("teams?org="),cljs.core.str(org_name)].join('')], 0));
var teams = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
return cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (url,teams){
return (function (p1__37996_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(team_name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(p1__37996_SHARP_));
});})(url,teams))
,teams));
});
milia.api.organization.share_team = (function milia$api$organization$share_team(team_id,data){

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",team_id,"share"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,data], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
