// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.EventType');
goog.require('cljs.core.async');
goog.require('cljs_http.util');
goog.require('goog.net.Jsonp');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
cljs_http.core.pending_requests = (function (){var G__36815 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36815) : cljs.core.atom.call(null,G__36815));
})();
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__4657__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cljs_http.core.pending_requests) : cljs.core.deref.call(null,cljs_http.core.pending_requests)).call(null,channel);
if(cljs.core.truth_(temp__4657__auto__)){
var req = temp__4657__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__36820){
var vec__36821 = p__36820;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36821,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36821,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__36825 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__36825)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__36825)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__36825)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__36825)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__36825)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__36825)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(response_type)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__36826){
var map__36830 = p__36826;
var map__36830__$1 = ((((!((map__36830 == null)))?((((map__36830.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36830.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36830):map__36830);
var request = map__36830__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36830__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36830__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36830__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__6543__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__36832 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__36832,default_headers);

cljs_http.core.apply_response_type_BANG_(G__36832,response_type);

G__36832.setTimeoutInterval(timeout);

G__36832.setWithCredentials(send_credentials);

return G__36832;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__36833){
var map__36862 = p__36833;
var map__36862__$1 = ((((!((map__36862 == null)))?((((map__36862.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36862.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36862):map__36862);
var request = map__36862__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36862__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36862__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36862__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36862__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36862__$1,cljs.core.cst$kw$cancel);
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36862__$1,cljs.core.cst$kw$progress);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__6543__auto__ = request_method;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr,map__36862,map__36862__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__36864 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__36864) : cljs_http.core.error_kw.call(null,G__36864));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if(cljs.core.not(cljs_http.core.aborted_QMARK_(xhr))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr,map__36862,map__36862__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

if(cljs.core.truth_(progress)){
var listener_36890 = ((function (channel,request_url,method,headers__$1,xhr,map__36862,map__36862__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$direction,direction,cljs.core.cst$kw$loaded,evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,evt.total], null):null)], 0)));
});})(channel,request_url,method,headers__$1,xhr,map__36862,map__36862__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
var G__36865_36891 = xhr;
G__36865_36891.setProgressEventsEnabled(true);

G__36865_36891.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_36890,cljs.core.cst$kw$upload));

G__36865_36891.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_36890,cljs.core.cst$kw$download));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__19252__auto___36892 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___36892,channel,request_url,method,headers__$1,xhr,map__36862,map__36862__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___36892,channel,request_url,method,headers__$1,xhr,map__36862,map__36862__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (state_36876){
var state_val_36877 = (state_36876[(1)]);
if((state_val_36877 === (1))){
var state_36876__$1 = state_36876;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36876__$1,(2),cancel);
} else {
if((state_val_36877 === (2))){
var inst_36867 = (state_36876[(2)]);
var inst_36868 = xhr.isComplete();
var inst_36869 = cljs.core.not(inst_36868);
var state_36876__$1 = (function (){var statearr_36878 = state_36876;
(statearr_36878[(7)] = inst_36867);

return statearr_36878;
})();
if(inst_36869){
var statearr_36879_36893 = state_36876__$1;
(statearr_36879_36893[(1)] = (3));

} else {
var statearr_36880_36894 = state_36876__$1;
(statearr_36880_36894[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (3))){
var inst_36871 = xhr.abort();
var state_36876__$1 = state_36876;
var statearr_36881_36895 = state_36876__$1;
(statearr_36881_36895[(2)] = inst_36871);

(statearr_36881_36895[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (4))){
var state_36876__$1 = state_36876;
var statearr_36882_36896 = state_36876__$1;
(statearr_36882_36896[(2)] = null);

(statearr_36882_36896[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36877 === (5))){
var inst_36874 = (state_36876[(2)]);
var state_36876__$1 = state_36876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36876__$1,inst_36874);
} else {
return null;
}
}
}
}
}
});})(c__19252__auto___36892,channel,request_url,method,headers__$1,xhr,map__36862,map__36862__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
return ((function (switch__19140__auto__,c__19252__auto___36892,channel,request_url,method,headers__$1,xhr,map__36862,map__36862__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function() {
var cljs_http$core$xhr_$_state_machine__19141__auto__ = null;
var cljs_http$core$xhr_$_state_machine__19141__auto____0 = (function (){
var statearr_36886 = [null,null,null,null,null,null,null,null];
(statearr_36886[(0)] = cljs_http$core$xhr_$_state_machine__19141__auto__);

(statearr_36886[(1)] = (1));

return statearr_36886;
});
var cljs_http$core$xhr_$_state_machine__19141__auto____1 = (function (state_36876){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_36876);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e36887){if((e36887 instanceof Object)){
var ex__19144__auto__ = e36887;
var statearr_36888_36897 = state_36876;
(statearr_36888_36897[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36876);

return cljs.core.cst$kw$recur;
} else {
throw e36887;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__36898 = state_36876;
state_36876 = G__36898;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__19141__auto__ = function(state_36876){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__19141__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__19141__auto____1.call(this,state_36876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__19141__auto____0;
cljs_http$core$xhr_$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__19141__auto____1;
return cljs_http$core$xhr_$_state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___36892,channel,request_url,method,headers__$1,xhr,map__36862,map__36862__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
})();
var state__19254__auto__ = (function (){var statearr_36889 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_36889[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___36892);

return statearr_36889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___36892,channel,request_url,method,headers__$1,xhr,map__36862,map__36862__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__36899){
var map__36916 = p__36899;
var map__36916__$1 = ((((!((map__36916 == null)))?((((map__36916.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36916.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36916):map__36916);
var request = map__36916__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36916__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36916__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36916__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__36916__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_36932 = jsonp.send(null,((function (channel,jsonp,map__36916,map__36916__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.array_seq([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__36916,map__36916__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp,map__36916,map__36916__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__36916,map__36916__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_36932], null));

if(cljs.core.truth_(cancel)){
var c__19252__auto___36933 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__19252__auto___36933,req_36932,channel,jsonp,map__36916,map__36916__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__19253__auto__ = (function (){var switch__19140__auto__ = ((function (c__19252__auto___36933,req_36932,channel,jsonp,map__36916,map__36916__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_36922){
var state_val_36923 = (state_36922[(1)]);
if((state_val_36923 === (1))){
var state_36922__$1 = state_36922;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36922__$1,(2),cancel);
} else {
if((state_val_36923 === (2))){
var inst_36919 = (state_36922[(2)]);
var inst_36920 = jsonp.cancel(req_36932);
var state_36922__$1 = (function (){var statearr_36924 = state_36922;
(statearr_36924[(7)] = inst_36919);

return statearr_36924;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_36922__$1,inst_36920);
} else {
return null;
}
}
});})(c__19252__auto___36933,req_36932,channel,jsonp,map__36916,map__36916__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__19140__auto__,c__19252__auto___36933,req_36932,channel,jsonp,map__36916,map__36916__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__19141__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__19141__auto____0 = (function (){
var statearr_36928 = [null,null,null,null,null,null,null,null];
(statearr_36928[(0)] = cljs_http$core$jsonp_$_state_machine__19141__auto__);

(statearr_36928[(1)] = (1));

return statearr_36928;
});
var cljs_http$core$jsonp_$_state_machine__19141__auto____1 = (function (state_36922){
while(true){
var ret_value__19142__auto__ = (function (){try{while(true){
var result__19143__auto__ = switch__19140__auto__(state_36922);
if(cljs.core.keyword_identical_QMARK_(result__19143__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__19143__auto__;
}
break;
}
}catch (e36929){if((e36929 instanceof Object)){
var ex__19144__auto__ = e36929;
var statearr_36930_36934 = state_36922;
(statearr_36930_36934[(5)] = ex__19144__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_36922);

return cljs.core.cst$kw$recur;
} else {
throw e36929;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__19142__auto__,cljs.core.cst$kw$recur)){
var G__36935 = state_36922;
state_36922 = G__36935;
continue;
} else {
return ret_value__19142__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__19141__auto__ = function(state_36922){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__19141__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__19141__auto____1.call(this,state_36922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__19141__auto____0;
cljs_http$core$jsonp_$_state_machine__19141__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__19141__auto____1;
return cljs_http$core$jsonp_$_state_machine__19141__auto__;
})()
;})(switch__19140__auto__,c__19252__auto___36933,req_36932,channel,jsonp,map__36916,map__36916__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__19254__auto__ = (function (){var statearr_36931 = (f__19253__auto__.cljs$core$IFn$_invoke$arity$0 ? f__19253__auto__.cljs$core$IFn$_invoke$arity$0() : f__19253__auto__.call(null));
(statearr_36931[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19252__auto___36933);

return statearr_36931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__19254__auto__);
});})(c__19252__auto___36933,req_36932,channel,jsonp,map__36916,map__36916__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__36936){
var map__36939 = p__36936;
var map__36939__$1 = ((((!((map__36939 == null)))?((((map__36939.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36939.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36939):map__36939);
var request = map__36939__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36939__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
