// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.async_export');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('chimera.string');
goog.require('goog.string.format');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('milia.api.dataset');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.retry');
milia.api.async_export.export_async_url = "export_async.json?format=";
milia.api.async_export.export_failure_status_msg = "FAILURE";
milia.api.async_export.export_pending_status_msg = "PENDING";
milia.api.async_export.initial_polling_interval = (5000);
/**
 * If a temp-token is set, add it as a query string parameter. The caller needs
 * to explicity pass a question-mark or ampersand depending on whether this is
 * the first or a subsequenty query parameter.
 */
milia.api.async_export.temp_token_suffix = (function milia$api$async_export$temp_token_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16164 = arguments.length;
var i__7652__auto___16165 = (0);
while(true){
if((i__7652__auto___16165 < len__7651__auto___16164)){
args__7658__auto__.push((arguments[i__7652__auto___16165]));

var G__16166 = (i__7652__auto___16165 + (1));
i__7652__auto___16165 = G__16166;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (s){
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return clojure.string.join.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_((chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token)))?cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.vec(s),"temp_token=",cljs.core.array_seq([temp_token], 0)):s));
});

milia.api.async_export.temp_token_suffix.cljs$lang$maxFixedArity = (0);

milia.api.async_export.temp_token_suffix.cljs$lang$applyTo = (function (seq16163){
return milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq16163));
});

/**
 * Handles API server's response and acts according to given callbacks.
 */
milia.api.async_export.handle_response = (function milia$api$async_export$handle_response(p__16167,p__16168){
var map__16177 = p__16167;
var map__16177__$1 = ((((!((map__16177 == null)))?((((map__16177.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16177.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16177):map__16177);
var response = map__16177__$1;
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16177__$1,cljs.core.cst$kw$status);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16177__$1,cljs.core.cst$kw$body);
var map__16178 = p__16168;
var map__16178__$1 = ((((!((map__16178 == null)))?((((map__16178.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16178.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16178):map__16178);
var callbacks = map__16178__$1;
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16178__$1,cljs.core.cst$kw$on_DASH_error,cljs.core.identity);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16178__$1,cljs.core.cst$kw$on_DASH_export_DASH_url,cljs.core.identity);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16178__$1,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.identity);
var on_stop = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16178__$1,cljs.core.cst$kw$on_DASH_stop,cljs.core.constantly(null));
var map__16181 = body;
var map__16181__$1 = ((((!((map__16181 == null)))?((((map__16181.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16181.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16181):map__16181);
var export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16181__$1,cljs.core.cst$kw$export_url);
var job_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16181__$1,cljs.core.cst$kw$job_status);
var job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16181__$1,cljs.core.cst$kw$job_uuid);
var is_failed_status_QMARK_ = ((function (map__16181,map__16181__$1,export_url,job_status,job_id,map__16177,map__16177__$1,response,status,body,map__16178,map__16178__$1,callbacks,on_error,on_export_url,on_job_id,on_stop){
return (function (){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(job_status,milia.api.async_export.export_failure_status_msg);
});})(map__16181,map__16181__$1,export_url,job_status,job_id,map__16177,map__16177__$1,response,status,body,map__16178,map__16178__$1,callbacks,on_error,on_export_url,on_job_id,on_stop))
;
var error_detail = (function (){var or__6543__auto__ = cljs.core.cst$kw$detail.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
var or__6543__auto____$1 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$1)){
return or__6543__auto____$1;
} else {
var or__6543__auto____$2 = cljs.core.cst$kw$details.cljs$core$IFn$_invoke$arity$1(body);
if(cljs.core.truth_(or__6543__auto____$2)){
return or__6543__auto____$2;
} else {
if(cljs.core.truth_(is_failed_status_QMARK_())){
return job_status;
} else {
return null;
}
}
}
}
})();
if(cljs.core.truth_(export_url)){
if(cljs.core.fn_QMARK_(on_export_url)){
(on_export_url.cljs$core$IFn$_invoke$arity$1 ? on_export_url.cljs$core$IFn$_invoke$arity$1(export_url) : on_export_url.call(null,export_url));
} else {
}

(on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
}

if(cljs.core.truth_(job_id)){
if(cljs.core.fn_QMARK_(on_job_id)){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));
} else {
}

} else {
}

if(cljs.core.truth_((function (){var or__6543__auto__ = (status >= (400));
if(or__6543__auto__){
return or__6543__auto__;
} else {
return is_failed_status_QMARK_();
}
})())){
if(cljs.core.fn_QMARK_(on_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(status,(403))){
var G__16183_16185 = error_detail;
var G__16184_16186 = cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(body);
(on_error.cljs$core$IFn$_invoke$arity$2 ? on_error.cljs$core$IFn$_invoke$arity$2(G__16183_16185,G__16184_16186) : on_error.call(null,G__16183_16185,G__16184_16186));
} else {
(on_error.cljs$core$IFn$_invoke$arity$1 ? on_error.cljs$core$IFn$_invoke$arity$1(error_detail) : on_error.call(null,error_detail));
}
} else {
}

return (on_stop.cljs$core$IFn$_invoke$arity$0 ? on_stop.cljs$core$IFn$_invoke$arity$0() : on_stop.call(null));
} else {
return null;
}
});
/**
 * Repeatedly polls the async export progress for the given job_uuid,
 *  When export_url is returned, fires callback on-export-url.
 */
milia.api.async_export.monitor_async_export_BANG_ = (function milia$api$async_export$monitor_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16237 = arguments.length;
var i__7652__auto___16238 = (0);
while(true){
if((i__7652__auto___16238 < len__7651__auto___16237)){
args__7658__auto__.push((arguments[i__7652__auto___16238]));

var G__16239 = (i__7652__auto___16238 + (1));
i__7652__auto___16238 = G__16239;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,job_id,p__16190){
var map__16191 = p__16190;
var map__16191__$1 = ((((!((map__16191 == null)))?((((map__16191.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16191.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16191):map__16191);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16191__$1,cljs.core.cst$kw$on_DASH_error);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16191__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16191__$1,cljs.core.cst$kw$data_DASH_type);
var c__12537__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12537__auto__,map__16191,map__16191__$1,on_error,on_export_url,data_type){
return (function (){
var f__12538__auto__ = (function (){var switch__12460__auto__ = ((function (c__12537__auto__,map__16191,map__16191__$1,on_error,on_export_url,data_type){
return (function (state_16219){
var state_val_16220 = (state_16219[(1)]);
if((state_val_16220 === (1))){
var inst_16193 = milia.api.async_export.initial_polling_interval;
var state_16219__$1 = (function (){var statearr_16221 = state_16219;
(statearr_16221[(7)] = inst_16193);

return statearr_16221;
})();
var statearr_16222_16240 = state_16219__$1;
(statearr_16222_16240[(2)] = null);

(statearr_16222_16240[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16220 === (2))){
var inst_16195 = (state_16219[(8)]);
var inst_16197 = (state_16219[(9)]);
var inst_16195__$1 = [cljs.core.str("export_async.json?job_uuid="),cljs.core.str(job_id)].join('');
var inst_16196 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_16197__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_16196,dataset_id,inst_16195__$1], 0));
var inst_16198 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_16197__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_16219__$1 = (function (){var statearr_16223 = state_16219;
(statearr_16223[(8)] = inst_16195__$1);

(statearr_16223[(9)] = inst_16197__$1);

return statearr_16223;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16219__$1,(4),inst_16198);
} else {
if((state_val_16220 === (3))){
var inst_16217 = (state_16219[(2)]);
var state_16219__$1 = state_16219;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16219__$1,inst_16217);
} else {
if((state_val_16220 === (4))){
var inst_16193 = (state_16219[(7)]);
var inst_16195 = (state_16219[(8)]);
var inst_16197 = (state_16219[(9)]);
var inst_16200 = (state_16219[(2)]);
var inst_16201 = [cljs.core.cst$kw$on_DASH_stop,cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_export_DASH_url];
var inst_16202 = (function (){var polling_interval = inst_16193;
var job_suffix = inst_16195;
var job_url = inst_16197;
var response = inst_16200;
return ((function (polling_interval,job_suffix,job_url,response,inst_16193,inst_16195,inst_16197,inst_16200,inst_16201,state_val_16220,c__12537__auto__,map__16191,map__16191__$1,on_error,on_export_url,data_type){
return (function (){
return cljs.core.constantly(cljs.core.cst$kw$stop);
});
;})(polling_interval,job_suffix,job_url,response,inst_16193,inst_16195,inst_16197,inst_16200,inst_16201,state_val_16220,c__12537__auto__,map__16191,map__16191__$1,on_error,on_export_url,data_type))
})();
var inst_16203 = [inst_16202,on_error,on_export_url];
var inst_16204 = cljs.core.PersistentHashMap.fromArrays(inst_16201,inst_16203);
var inst_16205 = milia.api.async_export.handle_response(inst_16200,inst_16204);
var inst_16206 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_16205,cljs.core.cst$kw$stop);
var state_16219__$1 = state_16219;
if(inst_16206){
var statearr_16224_16241 = state_16219__$1;
(statearr_16224_16241[(1)] = (5));

} else {
var statearr_16225_16242 = state_16219__$1;
(statearr_16225_16242[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16220 === (5))){
var inst_16193 = (state_16219[(7)]);
var inst_16208 = cljs.core.async.timeout(inst_16193);
var state_16219__$1 = state_16219;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16219__$1,(8),inst_16208);
} else {
if((state_val_16220 === (6))){
var state_16219__$1 = state_16219;
var statearr_16226_16243 = state_16219__$1;
(statearr_16226_16243[(2)] = null);

(statearr_16226_16243[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16220 === (7))){
var inst_16215 = (state_16219[(2)]);
var state_16219__$1 = state_16219;
var statearr_16227_16244 = state_16219__$1;
(statearr_16227_16244[(2)] = inst_16215);

(statearr_16227_16244[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16220 === (8))){
var inst_16193 = (state_16219[(7)]);
var inst_16210 = (state_16219[(2)]);
var inst_16211 = (inst_16193 * (2));
var inst_16193__$1 = inst_16211;
var state_16219__$1 = (function (){var statearr_16228 = state_16219;
(statearr_16228[(7)] = inst_16193__$1);

(statearr_16228[(10)] = inst_16210);

return statearr_16228;
})();
var statearr_16229_16245 = state_16219__$1;
(statearr_16229_16245[(2)] = null);

(statearr_16229_16245[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__12537__auto__,map__16191,map__16191__$1,on_error,on_export_url,data_type))
;
return ((function (switch__12460__auto__,c__12537__auto__,map__16191,map__16191__$1,on_error,on_export_url,data_type){
return (function() {
var milia$api$async_export$state_machine__12461__auto__ = null;
var milia$api$async_export$state_machine__12461__auto____0 = (function (){
var statearr_16233 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16233[(0)] = milia$api$async_export$state_machine__12461__auto__);

(statearr_16233[(1)] = (1));

return statearr_16233;
});
var milia$api$async_export$state_machine__12461__auto____1 = (function (state_16219){
while(true){
var ret_value__12462__auto__ = (function (){try{while(true){
var result__12463__auto__ = switch__12460__auto__(state_16219);
if(cljs.core.keyword_identical_QMARK_(result__12463__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12463__auto__;
}
break;
}
}catch (e16234){if((e16234 instanceof Object)){
var ex__12464__auto__ = e16234;
var statearr_16235_16246 = state_16219;
(statearr_16235_16246[(5)] = ex__12464__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16219);

return cljs.core.cst$kw$recur;
} else {
throw e16234;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12462__auto__,cljs.core.cst$kw$recur)){
var G__16247 = state_16219;
state_16219 = G__16247;
continue;
} else {
return ret_value__12462__auto__;
}
break;
}
});
milia$api$async_export$state_machine__12461__auto__ = function(state_16219){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__12461__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__12461__auto____1.call(this,state_16219);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__12461__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__12461__auto____0;
milia$api$async_export$state_machine__12461__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__12461__auto____1;
return milia$api$async_export$state_machine__12461__auto__;
})()
;})(switch__12460__auto__,c__12537__auto__,map__16191,map__16191__$1,on_error,on_export_url,data_type))
})();
var state__12539__auto__ = (function (){var statearr_16236 = (f__12538__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12538__auto__.cljs$core$IFn$_invoke$arity$0() : f__12538__auto__.call(null));
(statearr_16236[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12537__auto__);

return statearr_16236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12539__auto__);
});})(c__12537__auto__,map__16191,map__16191__$1,on_error,on_export_url,data_type))
);

return c__12537__auto__;
});

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$maxFixedArity = (2);

milia.api.async_export.monitor_async_export_BANG_.cljs$lang$applyTo = (function (seq16187){
var G__16188 = cljs.core.first(seq16187);
var seq16187__$1 = cljs.core.next(seq16187);
var G__16189 = cljs.core.first(seq16187__$1);
var seq16187__$2 = cljs.core.next(seq16187__$1);
return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16188,G__16189,seq16187__$2);
});

/**
 * Repeatedly polls the export endpoint given a form_id while any of the
 *    export status is pending.
 */
milia.api.async_export.monitor_async_exports_per_form_BANG_ = (function milia$api$async_export$monitor_async_exports_per_form_BANG_(dataset_id,callback){
var c__12537__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12537__auto__){
return (function (){
var f__12538__auto__ = (function (){var switch__12460__auto__ = ((function (c__12537__auto__){
return (function (state_16377){
var state_val_16378 = (state_16377[(1)]);
if((state_val_16378 === (7))){
var inst_16352 = (state_16377[(2)]);
var state_16377__$1 = state_16377;
if(cljs.core.truth_(inst_16352)){
var statearr_16379_16409 = state_16377__$1;
(statearr_16379_16409[(1)] = (11));

} else {
var statearr_16380_16410 = state_16377__$1;
(statearr_16380_16410[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16378 === (1))){
var inst_16329 = milia.api.async_export.initial_polling_interval;
var state_16377__$1 = (function (){var statearr_16381 = state_16377;
(statearr_16381[(7)] = inst_16329);

return statearr_16381;
})();
var statearr_16382_16411 = state_16377__$1;
(statearr_16382_16411[(2)] = null);

(statearr_16382_16411[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16378 === (4))){
var inst_16336 = (state_16377[(8)]);
var inst_16336__$1 = (state_16377[(2)]);
var inst_16338 = (inst_16336__$1 == null);
var inst_16339 = cljs.core.not(inst_16338);
var state_16377__$1 = (function (){var statearr_16383 = state_16377;
(statearr_16383[(8)] = inst_16336__$1);

return statearr_16383;
})();
if(inst_16339){
var statearr_16384_16412 = state_16377__$1;
(statearr_16384_16412[(1)] = (5));

} else {
var statearr_16385_16413 = state_16377__$1;
(statearr_16385_16413[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16378 === (15))){
var inst_16329 = (state_16377[(7)]);
var inst_16367 = cljs.core.async.timeout(inst_16329);
var state_16377__$1 = state_16377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16377__$1,(17),inst_16367);
} else {
if((state_val_16378 === (13))){
var inst_16359 = (state_16377[(9)]);
var inst_16333 = (state_16377[(10)]);
var inst_16329 = (state_16377[(7)]);
var inst_16357 = (state_16377[(2)]);
var inst_16358 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16357,cljs.core.cst$kw$status);
var inst_16359__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16357,cljs.core.cst$kw$body);
var inst_16360 = (function (){var polling_interval = inst_16329;
var export_url = inst_16333;
var map__16331 = inst_16357;
var status = inst_16358;
var body = inst_16359__$1;
return ((function (polling_interval,export_url,map__16331,status,body,inst_16359,inst_16333,inst_16329,inst_16357,inst_16358,inst_16359__$1,state_val_16378,c__12537__auto__){
return (function (p1__16248_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$job_status.cljs$core$IFn$_invoke$arity$1(p1__16248_SHARP_),milia.api.async_export.export_pending_status_msg);
});
;})(polling_interval,export_url,map__16331,status,body,inst_16359,inst_16333,inst_16329,inst_16357,inst_16358,inst_16359__$1,state_val_16378,c__12537__auto__))
})();
var inst_16361 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_16360,inst_16359__$1);
var inst_16362 = cljs.core.vec(inst_16361);
var inst_16363 = cljs.core.empty_QMARK_(inst_16362);
var state_16377__$1 = (function (){var statearr_16386 = state_16377;
(statearr_16386[(9)] = inst_16359__$1);

return statearr_16386;
})();
if(inst_16363){
var statearr_16387_16414 = state_16377__$1;
(statearr_16387_16414[(1)] = (14));

} else {
var statearr_16388_16415 = state_16377__$1;
(statearr_16388_16415[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16378 === (6))){
var state_16377__$1 = state_16377;
var statearr_16389_16416 = state_16377__$1;
(statearr_16389_16416[(2)] = false);

(statearr_16389_16416[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16378 === (17))){
var inst_16329 = (state_16377[(7)]);
var inst_16369 = (state_16377[(2)]);
var inst_16370 = (inst_16329 * (2));
var inst_16329__$1 = inst_16370;
var state_16377__$1 = (function (){var statearr_16390 = state_16377;
(statearr_16390[(7)] = inst_16329__$1);

(statearr_16390[(11)] = inst_16369);

return statearr_16390;
})();
var statearr_16391_16417 = state_16377__$1;
(statearr_16391_16417[(2)] = null);

(statearr_16391_16417[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16378 === (3))){
var inst_16375 = (state_16377[(2)]);
var state_16377__$1 = state_16377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16377__$1,inst_16375);
} else {
if((state_val_16378 === (12))){
var inst_16336 = (state_16377[(8)]);
var state_16377__$1 = state_16377;
var statearr_16392_16418 = state_16377__$1;
(statearr_16392_16418[(2)] = inst_16336);

(statearr_16392_16418[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16378 === (2))){
var inst_16333 = (state_16377[(10)]);
var inst_16332 = milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export.json?xform=",dataset_id,"&"], 0));
var inst_16333__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_16332], 0));
var inst_16334 = milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,inst_16333__$1,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,true], 0));
var state_16377__$1 = (function (){var statearr_16393 = state_16377;
(statearr_16393[(10)] = inst_16333__$1);

return statearr_16393;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16377__$1,(4),inst_16334);
} else {
if((state_val_16378 === (11))){
var inst_16336 = (state_16377[(8)]);
var inst_16354 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_16336);
var state_16377__$1 = state_16377;
var statearr_16394_16419 = state_16377__$1;
(statearr_16394_16419[(2)] = inst_16354);

(statearr_16394_16419[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16378 === (9))){
var state_16377__$1 = state_16377;
var statearr_16395_16420 = state_16377__$1;
(statearr_16395_16420[(2)] = false);

(statearr_16395_16420[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16378 === (5))){
var inst_16336 = (state_16377[(8)]);
var inst_16341 = inst_16336.cljs$lang$protocol_mask$partition0$;
var inst_16342 = (inst_16341 & (64));
var inst_16343 = inst_16336.cljs$core$ISeq$;
var inst_16344 = (cljs.core.PROTOCOL_SENTINEL === inst_16343);
var inst_16345 = (inst_16342) || (inst_16344);
var state_16377__$1 = state_16377;
if(cljs.core.truth_(inst_16345)){
var statearr_16396_16421 = state_16377__$1;
(statearr_16396_16421[(1)] = (8));

} else {
var statearr_16397_16422 = state_16377__$1;
(statearr_16397_16422[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16378 === (14))){
var inst_16359 = (state_16377[(9)]);
var inst_16365 = (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(inst_16359) : callback.call(null,inst_16359));
var state_16377__$1 = state_16377;
var statearr_16398_16423 = state_16377__$1;
(statearr_16398_16423[(2)] = inst_16365);

(statearr_16398_16423[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16378 === (16))){
var inst_16373 = (state_16377[(2)]);
var state_16377__$1 = state_16377;
var statearr_16399_16424 = state_16377__$1;
(statearr_16399_16424[(2)] = inst_16373);

(statearr_16399_16424[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16378 === (10))){
var inst_16349 = (state_16377[(2)]);
var state_16377__$1 = state_16377;
var statearr_16400_16425 = state_16377__$1;
(statearr_16400_16425[(2)] = inst_16349);

(statearr_16400_16425[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16378 === (8))){
var state_16377__$1 = state_16377;
var statearr_16401_16426 = state_16377__$1;
(statearr_16401_16426[(2)] = true);

(statearr_16401_16426[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12537__auto__))
;
return ((function (switch__12460__auto__,c__12537__auto__){
return (function() {
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__12461__auto__ = null;
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__12461__auto____0 = (function (){
var statearr_16405 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16405[(0)] = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__12461__auto__);

(statearr_16405[(1)] = (1));

return statearr_16405;
});
var milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__12461__auto____1 = (function (state_16377){
while(true){
var ret_value__12462__auto__ = (function (){try{while(true){
var result__12463__auto__ = switch__12460__auto__(state_16377);
if(cljs.core.keyword_identical_QMARK_(result__12463__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12463__auto__;
}
break;
}
}catch (e16406){if((e16406 instanceof Object)){
var ex__12464__auto__ = e16406;
var statearr_16407_16427 = state_16377;
(statearr_16407_16427[(5)] = ex__12464__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16377);

return cljs.core.cst$kw$recur;
} else {
throw e16406;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12462__auto__,cljs.core.cst$kw$recur)){
var G__16428 = state_16377;
state_16377 = G__16428;
continue;
} else {
return ret_value__12462__auto__;
}
break;
}
});
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__12461__auto__ = function(state_16377){
switch(arguments.length){
case 0:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__12461__auto____0.call(this);
case 1:
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__12461__auto____1.call(this,state_16377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__12461__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__12461__auto____0;
milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__12461__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__12461__auto____1;
return milia$api$async_export$monitor_async_exports_per_form_BANG__$_state_machine__12461__auto__;
})()
;})(switch__12460__auto__,c__12537__auto__))
})();
var state__12539__auto__ = (function (){var statearr_16408 = (f__12538__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12538__auto__.cljs$core$IFn$_invoke$arity$0() : f__12538__auto__.call(null));
(statearr_16408[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12537__auto__);

return statearr_16408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12539__auto__);
});})(c__12537__auto__))
);

return c__12537__auto__;
});
milia.api.async_export.version_key = "_version";
milia.api.async_export.export_option_keys = new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, ["meta","data_id","group_delimiter","do_not_split_select_multiples","include_hxl","include_images","remove_group_name",milia.api.async_export.version_key,"query","export_id","include_labels","include_labels_only","win_excel_utf8","redirect_uri","binary_select_multiples","value_select_multiples","show_choice_labels","include_reviews"], null);
milia.api.async_export.export_option_values = new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$meta_DASH_id,cljs.core.cst$kw$data_DASH_id,cljs.core.cst$kw$group_DASH_delimiter,cljs.core.cst$kw$do_DASH_not_DASH_split_DASH_multi_DASH_selects_QMARK_,cljs.core.cst$kw$include_DASH_hxl_QMARK_,cljs.core.cst$kw$include_DASH_images_QMARK_,cljs.core.cst$kw$remove_DASH_group_DASH_name_QMARK_,cljs.core.cst$kw$version,cljs.core.cst$kw$query,cljs.core.cst$kw$export_id,cljs.core.cst$kw$include_DASH_labels_QMARK_,cljs.core.cst$kw$labels_DASH_only_QMARK_,cljs.core.cst$kw$windows_DASH_compatible_DASH_csv_QMARK_,cljs.core.cst$kw$redirect_DASH_uri,cljs.core.cst$kw$binary_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$value_DASH_select_DASH_multiples_QMARK_,cljs.core.cst$kw$show_DASH_choice_DASH_labels_QMARK_,cljs.core.cst$kw$include_DASH_reviews_QMARK_], null);
milia.api.async_export.get_param = (function milia$api$async_export$get_param(key,value){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,milia.api.async_export.version_key)){
return goog.string.format("&query={\"%s\":\"%s\"}",key,value);
} else {
return [cljs.core.str("&"),cljs.core.str(key),cljs.core.str("="),cljs.core.str(value)].join('');
}
});
milia.api.async_export.add_param = (function milia$api$async_export$add_param(key,value){
if(cljs.core.truth_((function (){var or__6543__auto__ = value;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,false);
}
})())){
return milia.api.async_export.get_param(key,value);
} else {
return null;
}
});
/**
 * Build the export options string to pass to the Ona API.
 */
milia.api.async_export.build_export_suffix = (function milia$api$async_export$build_export_suffix(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16436 = arguments.length;
var i__7652__auto___16437 = (0);
while(true){
if((i__7652__auto___16437 < len__7651__auto___16436)){
args__7658__auto__.push((arguments[i__7652__auto___16437]));

var G__16438 = (i__7652__auto___16437 + (1));
i__7652__auto___16437 = G__16438;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic = (function (url,data_format,p__16432){
var vec__16433 = p__16432;
var export_options = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16433,(0),null);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,data_format], null),cljs.core.map.cljs$core$IFn$_invoke$arity$3(milia.api.async_export.add_param,milia.api.async_export.export_option_keys,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,milia.api.async_export.export_option_values).call(null,export_options))));
});

milia.api.async_export.build_export_suffix.cljs$lang$maxFixedArity = (2);

milia.api.async_export.build_export_suffix.cljs$lang$applyTo = (function (seq16429){
var G__16430 = cljs.core.first(seq16429);
var seq16429__$1 = cljs.core.next(seq16429);
var G__16431 = cljs.core.first(seq16429__$1);
var seq16429__$2 = cljs.core.next(seq16429__$1);
return milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(G__16430,G__16431,seq16429__$2);
});

/**
 * Triggers async export and watches it via polling.
 *    Fires on-job-id callback on receving :job_uuid from server, then monitors
 *    job via polling.
 *    On receiving :export_url from server, on-export-url fired.
 */
milia.api.async_export.trigger_async_export_BANG_ = (function milia$api$async_export$trigger_async_export_BANG_(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16488 = arguments.length;
var i__7652__auto___16489 = (0);
while(true){
if((i__7652__auto___16489 < len__7651__auto___16488)){
args__7658__auto__.push((arguments[i__7652__auto___16489]));

var G__16490 = (i__7652__auto___16489 + (1));
i__7652__auto___16489 = G__16490;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__16441){
var vec__16442 = p__16441;
var map__16445 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16442,(0),null);
var map__16445__$1 = ((((!((map__16445 == null)))?((((map__16445.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16445.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16445):map__16445);
var data_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16445__$1,cljs.core.cst$kw$data_DASH_type);
var data_format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16445__$1,cljs.core.cst$kw$data_DASH_format);
var export_options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16445__$1,cljs.core.cst$kw$export_DASH_options);
var on_job_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16445__$1,cljs.core.cst$kw$on_DASH_job_DASH_id);
var on_export_url = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16445__$1,cljs.core.cst$kw$on_DASH_export_DASH_url);
var on_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16445__$1,cljs.core.cst$kw$on_DASH_error);
var on_done = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16445__$1,cljs.core.cst$kw$on_DASH_done);
var c__12537__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12537__auto__,vec__16442,map__16445,map__16445__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (){
var f__12538__auto__ = (function (){var switch__12460__auto__ = ((function (c__12537__auto__,vec__16442,map__16445,map__16445__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (state_16468){
var state_val_16469 = (state_16468[(1)]);
if((state_val_16469 === (1))){
var inst_16449 = (state_16468[(7)]);
var inst_16447 = (state_16468[(8)]);
var inst_16447__$1 = milia.api.async_export.build_export_suffix.cljs$core$IFn$_invoke$arity$variadic(milia.api.async_export.export_async_url,data_format,cljs.core.array_seq([export_options], 0));
var inst_16448 = (milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1 ? milia.api.dataset.type__GT_endpoint.cljs$core$IFn$_invoke$arity$1(data_type) : milia.api.dataset.type__GT_endpoint.call(null,data_type));
var inst_16449__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_16448,dataset_id,inst_16447__$1], 0));
var inst_16450 = milia.utils.retry.retry_parse_http(cljs.core.cst$kw$get,inst_16449__$1);
var state_16468__$1 = (function (){var statearr_16470 = state_16468;
(statearr_16470[(7)] = inst_16449__$1);

(statearr_16470[(8)] = inst_16447__$1);

return statearr_16470;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16468__$1,(2),inst_16450);
} else {
if((state_val_16469 === (2))){
var inst_16452 = (state_16468[(9)]);
var inst_16449 = (state_16468[(7)]);
var inst_16447 = (state_16468[(8)]);
var inst_16452__$1 = (state_16468[(2)]);
var inst_16453 = (function (){var export_suffix = inst_16447;
var export_url = inst_16449;
var response = inst_16452__$1;
return ((function (export_suffix,export_url,response,inst_16452,inst_16449,inst_16447,inst_16452__$1,state_val_16469,c__12537__auto__,vec__16442,map__16445,map__16445__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function (job_id){
(on_job_id.cljs$core$IFn$_invoke$arity$1 ? on_job_id.cljs$core$IFn$_invoke$arity$1(job_id) : on_job_id.call(null,job_id));

return milia.api.async_export.monitor_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,job_id,cljs.core.array_seq([cljs.core.cst$kw$on_DASH_export_DASH_url,on_export_url,cljs.core.cst$kw$on_DASH_error,on_error,cljs.core.cst$kw$data_DASH_type,data_type], 0));
});
;})(export_suffix,export_url,response,inst_16452,inst_16449,inst_16447,inst_16452__$1,state_val_16469,c__12537__auto__,vec__16442,map__16445,map__16445__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state_16468__$1 = (function (){var statearr_16471 = state_16468;
(statearr_16471[(9)] = inst_16452__$1);

(statearr_16471[(10)] = inst_16453);

return statearr_16471;
})();
if(cljs.core.truth_(on_done)){
var statearr_16472_16491 = state_16468__$1;
(statearr_16472_16491[(1)] = (3));

} else {
var statearr_16473_16492 = state_16468__$1;
(statearr_16473_16492[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16469 === (3))){
var inst_16452 = (state_16468[(9)]);
var inst_16455 = (on_done.cljs$core$IFn$_invoke$arity$1 ? on_done.cljs$core$IFn$_invoke$arity$1(inst_16452) : on_done.call(null,inst_16452));
var state_16468__$1 = state_16468;
var statearr_16474_16493 = state_16468__$1;
(statearr_16474_16493[(2)] = inst_16455);

(statearr_16474_16493[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16469 === (4))){
var state_16468__$1 = state_16468;
var statearr_16475_16494 = state_16468__$1;
(statearr_16475_16494[(2)] = null);

(statearr_16475_16494[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16469 === (5))){
var inst_16458 = (state_16468[(2)]);
var inst_16459 = [cljs.core.cst$kw$on_DASH_error,cljs.core.cst$kw$on_DASH_job_DASH_id,cljs.core.cst$kw$on_DASH_export_DASH_url];
var state_16468__$1 = (function (){var statearr_16476 = state_16468;
(statearr_16476[(11)] = inst_16458);

(statearr_16476[(12)] = inst_16459);

return statearr_16476;
})();
if(cljs.core.truth_(on_done)){
var statearr_16477_16495 = state_16468__$1;
(statearr_16477_16495[(1)] = (6));

} else {
var statearr_16478_16496 = state_16468__$1;
(statearr_16478_16496[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16469 === (6))){
var state_16468__$1 = state_16468;
var statearr_16479_16497 = state_16468__$1;
(statearr_16479_16497[(2)] = on_job_id);

(statearr_16479_16497[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16469 === (7))){
var inst_16453 = (state_16468[(10)]);
var state_16468__$1 = state_16468;
var statearr_16480_16498 = state_16468__$1;
(statearr_16480_16498[(2)] = inst_16453);

(statearr_16480_16498[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16469 === (8))){
var inst_16452 = (state_16468[(9)]);
var inst_16459 = (state_16468[(12)]);
var inst_16463 = (state_16468[(2)]);
var inst_16464 = [on_error,inst_16463,on_export_url];
var inst_16465 = cljs.core.PersistentHashMap.fromArrays(inst_16459,inst_16464);
var inst_16466 = milia.api.async_export.handle_response(inst_16452,inst_16465);
var state_16468__$1 = state_16468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16468__$1,inst_16466);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__12537__auto__,vec__16442,map__16445,map__16445__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
;
return ((function (switch__12460__auto__,c__12537__auto__,vec__16442,map__16445,map__16445__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done){
return (function() {
var milia$api$async_export$state_machine__12461__auto__ = null;
var milia$api$async_export$state_machine__12461__auto____0 = (function (){
var statearr_16484 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16484[(0)] = milia$api$async_export$state_machine__12461__auto__);

(statearr_16484[(1)] = (1));

return statearr_16484;
});
var milia$api$async_export$state_machine__12461__auto____1 = (function (state_16468){
while(true){
var ret_value__12462__auto__ = (function (){try{while(true){
var result__12463__auto__ = switch__12460__auto__(state_16468);
if(cljs.core.keyword_identical_QMARK_(result__12463__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12463__auto__;
}
break;
}
}catch (e16485){if((e16485 instanceof Object)){
var ex__12464__auto__ = e16485;
var statearr_16486_16499 = state_16468;
(statearr_16486_16499[(5)] = ex__12464__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16468);

return cljs.core.cst$kw$recur;
} else {
throw e16485;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12462__auto__,cljs.core.cst$kw$recur)){
var G__16500 = state_16468;
state_16468 = G__16500;
continue;
} else {
return ret_value__12462__auto__;
}
break;
}
});
milia$api$async_export$state_machine__12461__auto__ = function(state_16468){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__12461__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__12461__auto____1.call(this,state_16468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__12461__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__12461__auto____0;
milia$api$async_export$state_machine__12461__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__12461__auto____1;
return milia$api$async_export$state_machine__12461__auto__;
})()
;})(switch__12460__auto__,c__12537__auto__,vec__16442,map__16445,map__16445__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
})();
var state__12539__auto__ = (function (){var statearr_16487 = (f__12538__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12538__auto__.cljs$core$IFn$_invoke$arity$0() : f__12538__auto__.call(null));
(statearr_16487[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12537__auto__);

return statearr_16487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12539__auto__);
});})(c__12537__auto__,vec__16442,map__16445,map__16445__$1,data_type,data_format,export_options,on_job_id,on_export_url,on_error,on_done))
);

return c__12537__auto__;
});

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$maxFixedArity = (1);

milia.api.async_export.trigger_async_export_BANG_.cljs$lang$applyTo = (function (seq16439){
var G__16440 = cljs.core.first(seq16439);
var seq16439__$1 = cljs.core.next(seq16439);
return milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16440,seq16439__$1);
});

/**
 * Returns a channel, which will have the async export url when ready.
 */
milia.api.async_export.get_async_export_url = (function milia$api$async_export$get_async_export_url(dataset_id,data_format){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
milia.api.async_export.trigger_async_export_BANG_.cljs$core$IFn$_invoke$arity$variadic(dataset_id,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_format,data_format,cljs.core.cst$kw$on_DASH_export_DASH_url,((function (ch){
return (function (p1__16501_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,p1__16501_SHARP_);
});})(ch))
], null)], 0));

return ch;
});
/**
 * Returns a channel, which will have the async _data_
 *  downloaded using http-method when ready.
 */
milia.api.async_export.get_async_export_data = (function milia$api$async_export$get_async_export_data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16526 = arguments.length;
var i__7652__auto___16527 = (0);
while(true){
if((i__7652__auto___16527 < len__7651__auto___16526)){
args__7658__auto__.push((arguments[i__7652__auto___16527]));

var G__16528 = (i__7652__auto___16527 + (1));
i__7652__auto___16527 = G__16528;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,fmt,http_method,args){
var c__12537__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12537__auto__){
return (function (){
var f__12538__auto__ = (function (){var switch__12460__auto__ = ((function (c__12537__auto__){
return (function (state_16517){
var state_val_16518 = (state_16517[(1)]);
if((state_val_16518 === (1))){
var inst_16506 = milia.api.async_export.get_async_export_url(dataset_id,fmt);
var state_16517__$1 = state_16517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16517__$1,(2),inst_16506);
} else {
if((state_val_16518 === (2))){
var inst_16508 = (state_16517[(2)]);
var inst_16509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16510 = [http_method,inst_16508];
var inst_16511 = (new cljs.core.PersistentVector(null,2,(5),inst_16509,inst_16510,null));
var inst_16512 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_16511,args);
var inst_16513 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(milia.api.http.parse_http,inst_16512);
var state_16517__$1 = state_16517;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16517__$1,(3),inst_16513);
} else {
if((state_val_16518 === (3))){
var inst_16515 = (state_16517[(2)]);
var state_16517__$1 = state_16517;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16517__$1,inst_16515);
} else {
return null;
}
}
}
});})(c__12537__auto__))
;
return ((function (switch__12460__auto__,c__12537__auto__){
return (function() {
var milia$api$async_export$state_machine__12461__auto__ = null;
var milia$api$async_export$state_machine__12461__auto____0 = (function (){
var statearr_16522 = [null,null,null,null,null,null,null];
(statearr_16522[(0)] = milia$api$async_export$state_machine__12461__auto__);

(statearr_16522[(1)] = (1));

return statearr_16522;
});
var milia$api$async_export$state_machine__12461__auto____1 = (function (state_16517){
while(true){
var ret_value__12462__auto__ = (function (){try{while(true){
var result__12463__auto__ = switch__12460__auto__(state_16517);
if(cljs.core.keyword_identical_QMARK_(result__12463__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12463__auto__;
}
break;
}
}catch (e16523){if((e16523 instanceof Object)){
var ex__12464__auto__ = e16523;
var statearr_16524_16529 = state_16517;
(statearr_16524_16529[(5)] = ex__12464__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16517);

return cljs.core.cst$kw$recur;
} else {
throw e16523;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12462__auto__,cljs.core.cst$kw$recur)){
var G__16530 = state_16517;
state_16517 = G__16530;
continue;
} else {
return ret_value__12462__auto__;
}
break;
}
});
milia$api$async_export$state_machine__12461__auto__ = function(state_16517){
switch(arguments.length){
case 0:
return milia$api$async_export$state_machine__12461__auto____0.call(this);
case 1:
return milia$api$async_export$state_machine__12461__auto____1.call(this,state_16517);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$async_export$state_machine__12461__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$async_export$state_machine__12461__auto____0;
milia$api$async_export$state_machine__12461__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$async_export$state_machine__12461__auto____1;
return milia$api$async_export$state_machine__12461__auto__;
})()
;})(switch__12460__auto__,c__12537__auto__))
})();
var state__12539__auto__ = (function (){var statearr_16525 = (f__12538__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12538__auto__.cljs$core$IFn$_invoke$arity$0() : f__12538__auto__.call(null));
(statearr_16525[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12537__auto__);

return statearr_16525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12539__auto__);
});})(c__12537__auto__))
);

return c__12537__auto__;
});

milia.api.async_export.get_async_export_data.cljs$lang$maxFixedArity = (3);

milia.api.async_export.get_async_export_data.cljs$lang$applyTo = (function (seq16502){
var G__16503 = cljs.core.first(seq16502);
var seq16502__$1 = cljs.core.next(seq16502);
var G__16504 = cljs.core.first(seq16502__$1);
var seq16502__$2 = cljs.core.next(seq16502__$1);
var G__16505 = cljs.core.first(seq16502__$2);
var seq16502__$3 = cljs.core.next(seq16502__$2);
return milia.api.async_export.get_async_export_data.cljs$core$IFn$_invoke$arity$variadic(G__16503,G__16504,G__16505,seq16502__$3);
});

/**
 * Get exports based on a form id.
 */
milia.api.async_export.get_exports_per_form = (function milia$api$async_export$get_exports_per_form(dataset_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export.json?xform=",dataset_id,"&"], 0))], 0)));
});
/**
 * Delete an export based on an export id
 */
milia.api.async_export.delete_export = (function milia$api$async_export$delete_export(export_id){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["export",milia.api.async_export.temp_token_suffix.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([export_id,"?"], 0))], 0)));
});
