// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.dataset');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('chimera.core');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.metadata');
goog.require('milia.utils.remote');
if(typeof milia.api.dataset.type__GT_endpoint !== 'undefined'){
} else {
milia.api.dataset.type__GT_endpoint = (function (){var method_table__7471__auto__ = (function (){var G__16038 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16038) : cljs.core.atom.call(null,G__16038));
})();
var prefer_table__7472__auto__ = (function (){var G__16039 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16039) : cljs.core.atom.call(null,G__16039));
})();
var method_cache__7473__auto__ = (function (){var G__16040 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16040) : cljs.core.atom.call(null,G__16040));
})();
var cached_hierarchy__7474__auto__ = (function (){var G__16041 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16041) : cljs.core.atom.call(null,G__16041));
})();
var hierarchy__7475__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("milia.api.dataset","type->endpoint"),((function (method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__){
return (function() { 
var G__16042__delegate = function (datatype,_){
return datatype;
};
var G__16042 = function (datatype,var_args){
var _ = null;
if (arguments.length > 1) {
var G__16043__i = 0, G__16043__a = new Array(arguments.length -  1);
while (G__16043__i < G__16043__a.length) {G__16043__a[G__16043__i] = arguments[G__16043__i + 1]; ++G__16043__i;}
  _ = new cljs.core.IndexedSeq(G__16043__a,0);
} 
return G__16042__delegate.call(this,datatype,_);};
G__16042.cljs$lang$maxFixedArity = 1;
G__16042.cljs$lang$applyTo = (function (arglist__16044){
var datatype = cljs.core.first(arglist__16044);
var _ = cljs.core.rest(arglist__16044);
return G__16042__delegate(datatype,_);
});
G__16042.cljs$core$IFn$_invoke$arity$variadic = G__16042__delegate;
return G__16042;
})()
;})(method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__))
,cljs.core.cst$kw$default,hierarchy__7475__auto__,method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__));
})();
}
milia.api.dataset.type__GT_endpoint.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function() { 
var G__16048__delegate = function (_,p__16045){
var map__16046 = p__16045;
var map__16046__$1 = ((((!((map__16046 == null)))?((((map__16046.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16046.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16046):map__16046);
var async = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__16046__$1,cljs.core.cst$kw$async,true);
if(cljs.core.truth_(async)){
return "forms";
} else {
return "data";
}
};
var G__16048 = function (_,var_args){
var p__16045 = null;
if (arguments.length > 1) {
var G__16049__i = 0, G__16049__a = new Array(arguments.length -  1);
while (G__16049__i < G__16049__a.length) {G__16049__a[G__16049__i] = arguments[G__16049__i + 1]; ++G__16049__i;}
  p__16045 = new cljs.core.IndexedSeq(G__16049__a,0);
} 
return G__16048__delegate.call(this,_,p__16045);};
G__16048.cljs$lang$maxFixedArity = 1;
G__16048.cljs$lang$applyTo = (function (arglist__16050){
var _ = cljs.core.first(arglist__16050);
var p__16045 = cljs.core.rest(arglist__16050);
return G__16048__delegate(_,p__16045);
});
G__16048.cljs$core$IFn$_invoke$arity$variadic = G__16048__delegate;
return G__16048;
})()
);
milia.api.dataset.type__GT_endpoint.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$filtered_DASH_dataset,(function() { 
var G__16051__delegate = function (_,___$1){
return "dataviews";
};
var G__16051 = function (_,var_args){
var ___$1 = null;
if (arguments.length > 1) {
var G__16052__i = 0, G__16052__a = new Array(arguments.length -  1);
while (G__16052__i < G__16052__a.length) {G__16052__a[G__16052__i] = arguments[G__16052__i + 1]; ++G__16052__i;}
  ___$1 = new cljs.core.IndexedSeq(G__16052__a,0);
} 
return G__16051__delegate.call(this,_,___$1);};
G__16051.cljs$lang$maxFixedArity = 1;
G__16051.cljs$lang$applyTo = (function (arglist__16053){
var _ = cljs.core.first(arglist__16053);
var ___$1 = cljs.core.rest(arglist__16053);
return G__16051__delegate(_,___$1);
});
G__16051.cljs$core$IFn$_invoke$arity$variadic = G__16051__delegate;
return G__16051;
})()
);
/**
 * Return all the datasets for an account.
 */
milia.api.dataset.all = (function milia$api$dataset$all(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("forms.json?owner="),cljs.core.str(username)].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return all public datasets for a specific user.
 */
milia.api.dataset.public$ = (function milia$api$dataset$public(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",[cljs.core.str(username),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Clone the dataset given by ID into the account with the given username.
 */
milia.api.dataset.clone = (function milia$api$dataset$clone(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16060 = arguments.length;
var i__7652__auto___16061 = (0);
while(true){
if((i__7652__auto___16061 < len__7651__auto___16060)){
args__7658__auto__.push((arguments[i__7652__auto___16061]));

var G__16062 = (i__7652__auto___16061 + (1));
i__7652__auto___16061 = G__16062;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,username,p__16057){
var map__16058 = p__16057;
var map__16058__$1 = ((((!((map__16058 == null)))?((((map__16058.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16058.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16058):map__16058);
var project_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16058__$1,cljs.core.cst$kw$project_DASH_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"clone.json"], 0));
var data_base = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$username,username], null)], null);
var data = (cljs.core.truth_(project_id)?cljs.core.assoc_in(data_base,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$form_DASH_params,cljs.core.cst$kw$project_id], null),project_id):data_base);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,data,cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});

milia.api.dataset.clone.cljs$lang$maxFixedArity = (2);

milia.api.dataset.clone.cljs$lang$applyTo = (function (seq16054){
var G__16055 = cljs.core.first(seq16054);
var seq16054__$1 = cljs.core.next(seq16054);
var G__16056 = cljs.core.first(seq16054__$1);
var seq16054__$2 = cljs.core.next(seq16054__$1);
return milia.api.dataset.clone.cljs$core$IFn$_invoke$arity$variadic(G__16055,G__16056,seq16054__$2);
});

/**
 * Set the metadata for a dataset using PUT. All parameters must be passed.
 */
milia.api.dataset.update = (function milia$api$dataset$update(dataset_id,params){
if(cljs.core.truth_(chimera.seq.has_keys_QMARK_(params,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$created_by,cljs.core.cst$kw$description,cljs.core.cst$kw$downloadable,cljs.core.cst$kw$owner,cljs.core.cst$kw$project,cljs.core.cst$kw$public,cljs.core.cst$kw$public_data,cljs.core.cst$kw$title,cljs.core.cst$kw$uuid], null)))){
} else {
throw (new Error("Assert failed: (has-keys? params [:created_by :description :downloadable :owner :project :public :public_data :title :uuid])"));
}

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",[cljs.core.str(dataset_id),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Update the title of a form
 */
milia.api.dataset.update_form_name = (function milia$api$dataset$update_form_name(dataset_id,params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Return the data associated with a dataset.
 */
milia.api.dataset.data = (function milia$api$dataset$data(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16068 = arguments.length;
var i__7652__auto___16069 = (0);
while(true){
if((i__7652__auto___16069 < len__7651__auto___16068)){
args__7658__auto__.push((arguments[i__7652__auto___16069]));

var G__16070 = (i__7652__auto___16069 + (1));
i__7652__auto___16069 = G__16070;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});
goog.exportSymbol('milia.api.dataset.data', milia.api.dataset.data);

milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__16065){
var map__16066 = p__16065;
var map__16066__$1 = ((((!((map__16066 == null)))?((((map__16066.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16066.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16066):map__16066);
var format = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16066__$1,cljs.core.cst$kw$format);
var raw_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16066__$1,cljs.core.cst$kw$raw_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16066__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16066__$1,cljs.core.cst$kw$accept_DASH_header);
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16066__$1,cljs.core.cst$kw$query_DASH_params);
var data_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16066__$1,cljs.core.cst$kw$data_DASH_id);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16066__$1,cljs.core.cst$kw$auth_DASH_token);
var dataset_suffix = (cljs.core.truth_(format)?[cljs.core.str(dataset_id),cljs.core.str((cljs.core.truth_(data_id)?[cljs.core.str("/"),cljs.core.str(data_id)].join(''):null)),cljs.core.str("."),cljs.core.str(format)].join(''):dataset_id);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_suffix], 0));
var options = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,query_params], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$raw_DASH_response_QMARK_,raw_QMARK_,cljs.core.cst$kw$must_DASH_revalidate_QMARK_,must_revalidate_QMARK_,cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$auth_DASH_token,auth_token], 0));
});

milia.api.dataset.data.cljs$lang$maxFixedArity = (1);

milia.api.dataset.data.cljs$lang$applyTo = (function (seq16063){
var G__16064 = cljs.core.first(seq16063);
var seq16063__$1 = cljs.core.next(seq16063);
return milia.api.dataset.data.cljs$core$IFn$_invoke$arity$variadic(G__16064,seq16063__$1);
});

/**
 * Retrieve a record from the dataset.
 */
milia.api.dataset.record = (function milia$api$dataset$record(dataset_id,record_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,[cljs.core.str(record_id),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Returns tags for a dataset
 */
milia.api.dataset.tags = (function milia$api$dataset$tags(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"labels.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add tags to a dataset
 */
milia.api.dataset.add_tags = (function milia$api$dataset$add_tags(dataset_id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"labels.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,tags], null)], 0));
});
/**
 * Return filename taking format special cases into account.
 */
milia.api.dataset.filename_for_format = (function milia$api$dataset$filename_for_format(dataset_id,format){
return [cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(format,"csvzip"))?"zip":format))].join('');
});
/**
 * Return options needed to handle format.
 */
milia.api.dataset.options_for_format = (function milia$api$dataset$options_for_format(format){
if(cljs.core.truth_(chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["csvzip","sav","xls","xlsx","zip"], null),format))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null);
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
if(typeof milia.api.dataset.type__GT_download_path !== 'undefined'){
} else {
milia.api.dataset.type__GT_download_path = (function (){var method_table__7471__auto__ = (function (){var G__16071 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16071) : cljs.core.atom.call(null,G__16071));
})();
var prefer_table__7472__auto__ = (function (){var G__16072 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16072) : cljs.core.atom.call(null,G__16072));
})();
var method_cache__7473__auto__ = (function (){var G__16073 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16073) : cljs.core.atom.call(null,G__16073));
})();
var cached_hierarchy__7474__auto__ = (function (){var G__16074 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16074) : cljs.core.atom.call(null,G__16074));
})();
var hierarchy__7475__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("milia.api.dataset","type->download-path"),((function (method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__){
return (function() { 
var G__16075__delegate = function (datatype,_){
return datatype;
};
var G__16075 = function (datatype,var_args){
var _ = null;
if (arguments.length > 1) {
var G__16076__i = 0, G__16076__a = new Array(arguments.length -  1);
while (G__16076__i < G__16076__a.length) {G__16076__a[G__16076__i] = arguments[G__16076__i + 1]; ++G__16076__i;}
  _ = new cljs.core.IndexedSeq(G__16076__a,0);
} 
return G__16075__delegate.call(this,datatype,_);};
G__16075.cljs$lang$maxFixedArity = 1;
G__16075.cljs$lang$applyTo = (function (arglist__16077){
var datatype = cljs.core.first(arglist__16077);
var _ = cljs.core.rest(arglist__16077);
return G__16075__delegate(datatype,_);
});
G__16075.cljs$core$IFn$_invoke$arity$variadic = G__16075__delegate;
return G__16075;
})()
;})(method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__,hierarchy__7475__auto__))
,cljs.core.cst$kw$default,hierarchy__7475__auto__,method_table__7471__auto__,prefer_table__7472__auto__,method_cache__7473__auto__,cached_hierarchy__7474__auto__));
})();
}
milia.api.dataset.type__GT_download_path.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (_,dataset_id,format,export_options){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(format),cljs.core.str((cljs.core.truth_(export_options)?[cljs.core.str("?"),cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",(function (){var iter__7326__auto__ = (function milia$api$dataset$iter__16078(s__16079){
return (new cljs.core.LazySeq(null,(function (){
var s__16079__$1 = s__16079;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__16079__$1);
if(temp__4657__auto__){
var s__16079__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__16079__$2)){
var c__7324__auto__ = cljs.core.chunk_first(s__16079__$2);
var size__7325__auto__ = cljs.core.count(c__7324__auto__);
var b__16081 = cljs.core.chunk_buffer(size__7325__auto__);
if((function (){var i__16080 = (0);
while(true){
if((i__16080 < size__7325__auto__)){
var vec__16090 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7324__auto__,i__16080);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16090,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16090,(1),null);
cljs.core.chunk_append(b__16081,[cljs.core.str(cljs.core.name(option)),cljs.core.str("="),cljs.core.str(val)].join(''));

var G__16096 = (i__16080 + (1));
i__16080 = G__16096;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__16081),milia$api$dataset$iter__16078(cljs.core.chunk_rest(s__16079__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__16081),null);
}
} else {
var vec__16093 = cljs.core.first(s__16079__$2);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16093,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16093,(1),null);
return cljs.core.cons([cljs.core.str(cljs.core.name(option)),cljs.core.str("="),cljs.core.str(val)].join(''),milia$api$dataset$iter__16078(cljs.core.rest(s__16079__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7326__auto__(export_options);
})()))].join(''):null))].join('')], null);
}));
milia.api.dataset.type__GT_download_path.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$filtered_DASH_dataset,(function (_,dataset_id,format,export_options){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dataset_id,[cljs.core.str("data."),cljs.core.str(format)].join('')], null);
}));
/**
 * Download form data in specified format. The synchronicity here refers to the
 * server side. This will still return a channel, not data, in CLJS.
 * The options map (last parameter) has the following keys:
 * :accept-header Defaults to application/json
 * :submission-id The id of the submission whose data the client requires. The
 *  function returns data for all submissions if this is not provided.
 * :dataview? Boolean flag indicating whether the data belongs to a filtered
 *  dataview
 */
milia.api.dataset.download_synchronously = (function milia$api$dataset$download_synchronously(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16103 = arguments.length;
var i__7652__auto___16104 = (0);
while(true){
if((i__7652__auto___16104 < len__7651__auto___16103)){
args__7658__auto__.push((arguments[i__7652__auto___16104]));

var G__16105 = (i__7652__auto___16104 + (1));
i__7652__auto___16104 = G__16105;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,format,p__16100){
var map__16101 = p__16100;
var map__16101__$1 = ((((!((map__16101 == null)))?((((map__16101.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16101.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16101):map__16101);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16101__$1,cljs.core.cst$kw$accept_DASH_header);
var submission_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16101__$1,cljs.core.cst$kw$submission_DASH_id);
var dataview_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16101__$1,cljs.core.cst$kw$dataview_QMARK_);
var url = (cljs.core.truth_(dataview_QMARK_)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["dataviews",dataset_id,[cljs.core.str("data."),cljs.core.str(format)].join('')], 0)):(cljs.core.truth_(submission_id)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,[cljs.core.str(submission_id),cljs.core.str("."),cljs.core.str(format)].join('')], 0)):milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",[cljs.core.str(dataset_id),cljs.core.str("."),cljs.core.str(format)].join('')], 0))
));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$accept_DASH_header,accept_header,cljs.core.cst$kw$http_DASH_options,milia.api.dataset.options_for_format(format)], 0));
});

milia.api.dataset.download_synchronously.cljs$lang$maxFixedArity = (2);

milia.api.dataset.download_synchronously.cljs$lang$applyTo = (function (seq16097){
var G__16098 = cljs.core.first(seq16097);
var seq16097__$1 = cljs.core.next(seq16097);
var G__16099 = cljs.core.first(seq16097__$1);
var seq16097__$2 = cljs.core.next(seq16097__$1);
return milia.api.dataset.download_synchronously.cljs$core$IFn$_invoke$arity$variadic(G__16098,G__16099,seq16097__$2);
});

/**
 * Download form as JSON string or file in specified format if format passed.
 */
milia.api.dataset.form = (function milia$api$dataset$form(var_args){
var args16106 = [];
var len__7651__auto___16109 = arguments.length;
var i__7652__auto___16110 = (0);
while(true){
if((i__7652__auto___16110 < len__7651__auto___16109)){
args16106.push((arguments[i__7652__auto___16110]));

var G__16111 = (i__7652__auto___16110 + (1));
i__7652__auto___16110 = G__16111;
continue;
} else {
}
break;
}

var G__16108 = args16106.length;
switch (G__16108) {
case 1:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16106.length)].join('')));

}
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$1 = (function (dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"form.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.dataset.form.cljs$core$IFn$_invoke$arity$2 = (function (dataset_id,format){
var suffix = [cljs.core.str("form."),cljs.core.str(format)].join('');
var options = milia.api.dataset.options_for_format(format);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,suffix], 0));
var filename = [cljs.core.str(dataset_id),cljs.core.str("_"),cljs.core.str(suffix)].join('');
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$filename,filename], 0));
});

milia.api.dataset.form.cljs$lang$maxFixedArity = 2;

/**
 * Show dataset metadata.
 */
milia.api.dataset.metadata = (function milia$api$dataset$metadata(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16118 = arguments.length;
var i__7652__auto___16119 = (0);
while(true){
if((i__7652__auto___16119 < len__7651__auto___16118)){
args__7658__auto__.push((arguments[i__7652__auto___16119]));

var G__16120 = (i__7652__auto___16119 + (1));
i__7652__auto___16119 = G__16120;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic = (function (dataset_id,p__16115){
var map__16116 = p__16115;
var map__16116__$1 = ((((!((map__16116 == null)))?((((map__16116.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16116.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16116):map__16116);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16116__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",[cljs.core.str(dataset_id),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.dataset.metadata.cljs$lang$maxFixedArity = (1);

milia.api.dataset.metadata.cljs$lang$applyTo = (function (seq16113){
var G__16114 = cljs.core.first(seq16113);
var seq16113__$1 = cljs.core.next(seq16113);
return milia.api.dataset.metadata.cljs$core$IFn$_invoke$arity$variadic(G__16114,seq16113__$1);
});

/**
 * Return link to online data entry.
 */
milia.api.dataset.online_data_entry_link = (function milia$api$dataset$online_data_entry_link(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"enketo.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Return link to online data entry.
 */
milia.api.dataset.edit_link = (function milia$api$dataset$edit_link(username,project_id,dataset_id,instance_id){
var return_url = milia.utils.remote.make_client_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([username,project_id,dataset_id,"submission-editing-complete"], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,instance_id,[cljs.core.str("enketo.json?return_url="),cljs.core.str(return_url)].join('')], 0));
return cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(milia.api.http.parse_http(cljs.core.cst$kw$get,url));
});
/**
 * Delete a dataset by ID.
 */
milia.api.dataset.delete$ = (function milia$api$dataset$delete(dataset_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"delete_async.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Move a dataset to a project use account if no owner passed.
 */
milia.api.dataset.move_to_project = (function milia$api$dataset$move_to_project(dataset_id,project_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id,"forms.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$formid,dataset_id], null)], null)], 0));
});
/**
 * Set a new form owner
 */
milia.api.dataset.new_form_owner = (function milia$api$dataset$new_form_owner(dataset_id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",[cljs.core.str(dataset_id),cljs.core.str(".json")].join('')], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",new_owner], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,new_owner__$1], null)], null)], 0));
});
/**
 * Share dataset with specific user
 */
milia.api.dataset.update_sharing = (function milia$api$dataset$update_sharing(dataset_id,username,role){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",dataset_id,"share.json"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$role,role], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null)], 0));
});
/**
 * Link xform or dataview as media
 */
milia.api.dataset.link_xform_or_dataview_as_media = (function milia$api$dataset$link_xform_or_dataview_as_media(object_type,object_id,media_filename,xform_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata.json"], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"media",cljs.core.cst$kw$data_value,[cljs.core.str(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [object_type,object_id,media_filename], null)))].join(''),cljs.core.cst$kw$xform,xform_id], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
});
/**
 * Add xls report link to dataset
 */
milia.api.dataset.add_xls_report = (function milia$api$dataset$add_xls_report(dataset_id,uuid,filename){
var xls_url = milia.utils.remote.make_j2x_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["xls",uuid], 0));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata.json"], 0));
var data = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_type,"external_export",cljs.core.cst$kw$data_value,[cljs.core.str(filename),cljs.core.str("|"),cljs.core.str(xls_url)].join('')], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null)], 0));
});
/**
 * Download xls report from the j2x service
 */
milia.api.dataset.download_xls_report = (function milia$api$dataset$download_xls_report(var_args){
var args16121 = [];
var len__7651__auto___16124 = arguments.length;
var i__7652__auto___16125 = (0);
while(true){
if((i__7652__auto___16125 < len__7651__auto___16124)){
args16121.push((arguments[i__7652__auto___16125]));

var G__16126 = (i__7652__auto___16125 + (1));
i__7652__auto___16125 = G__16126;
continue;
} else {
}
break;
}

var G__16123 = args16121.length;
switch (G__16123) {
case 3:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16121.length)].join('')));

}
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$3 = (function (dataset_id,meta_id,filename){
return milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4(dataset_id,meta_id,filename,null);
});

milia.api.dataset.download_xls_report.cljs$core$IFn$_invoke$arity$4 = (function (dataset_id,meta_id,filename,data_id){
var suffix = (cljs.core.truth_(data_id)?[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id),cljs.core.str("&data_id="),cljs.core.str(data_id)].join(''):[cljs.core.str(dataset_id),cljs.core.str(".xls?meta="),cljs.core.str(meta_id)].join(''));
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["forms",suffix], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$as,cljs.core.cst$kw$byte_DASH_array], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true,cljs.core.cst$kw$filename,filename], 0));
});

milia.api.dataset.download_xls_report.cljs$lang$maxFixedArity = 4;

milia.api.dataset.file_ext_query_param_map = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$csv,"csv_file",cljs.core.cst$kw$xls,"xls_file",cljs.core.cst$kw$xlsx,"xls_file"], null);
milia.api.dataset.get_media_file_extension = (function milia$api$dataset$get_media_file_extension(filename){
return cljs.core.peek(clojure.string.split.cljs$core$IFn$_invoke$arity$2(filename,/\./));
});
/**
 * Returns a submission's edit history
 */
milia.api.dataset.edit_history = (function milia$api$dataset$edit_history(dataset_id,instance_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["data",dataset_id,instance_id,"history.json"], 0)));
});
milia.api.dataset.files = (function milia$api$dataset$files(var_args){
var args__7658__auto__ = [];
var len__7651__auto___16134 = arguments.length;
var i__7652__auto___16135 = (0);
while(true){
if((i__7652__auto___16135 < len__7651__auto___16134)){
args__7658__auto__.push((arguments[i__7652__auto___16135]));

var G__16136 = (i__7652__auto___16135 + (1));
i__7652__auto___16135 = G__16136;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic = (function (instance_id,project_id,p__16131){
var map__16132 = p__16131;
var map__16132__$1 = ((((!((map__16132 == null)))?((((map__16132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16132.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16132):map__16132);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16132__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var dataset_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16132__$1,cljs.core.cst$kw$dataset_DASH_id);
var extra_params = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$project,project_id], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$xform,dataset_id], null));
return milia.utils.metadata.metadata_files.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$instance,instance_id,no_cache_QMARK_,cljs.core.array_seq([cljs.core.cst$kw$extra_DASH_params,extra_params], 0));
});

milia.api.dataset.files.cljs$lang$maxFixedArity = (2);

milia.api.dataset.files.cljs$lang$applyTo = (function (seq16128){
var G__16129 = cljs.core.first(seq16128);
var seq16128__$1 = cljs.core.next(seq16128);
var G__16130 = cljs.core.first(seq16128__$1);
var seq16128__$2 = cljs.core.next(seq16128__$1);
return milia.api.dataset.files.cljs$core$IFn$_invoke$arity$variadic(G__16129,G__16130,seq16128__$2);
});

/**
 * Integer Integer String String -> Channel HttpResponse
 */
milia.api.dataset.update_xform_meta_permissions = (function milia$api$dataset$update_xform_meta_permissions(dataset_id,metadata_id,editor_meta_role,dataentry_meta_role){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata",[cljs.core.str(metadata_id),cljs.core.str(".json")].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"xform_meta_perms",cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_value,[cljs.core.str(editor_meta_role),cljs.core.str("|"),cljs.core.str(dataentry_meta_role)].join('')], null)], null)], 0));
});
/**
 * Integer String String -> Channel HttpResponse
 */
milia.api.dataset.create_xform_meta_permissions = (function milia$api$dataset$create_xform_meta_permissions(dataset_id,editor_meta_role,dataentry_meta_role){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["metadata.json"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_type,"xform_meta_perms",cljs.core.cst$kw$xform,dataset_id,cljs.core.cst$kw$data_value,[cljs.core.str(editor_meta_role),cljs.core.str("|"),cljs.core.str(dataentry_meta_role)].join('')], null)], null)], 0));
});
/**
 * Create a submission review
 */
milia.api.dataset.create_submission_review = (function milia$api$dataset$create_submission_review(p__16137){
var map__16140 = p__16137;
var map__16140__$1 = ((((!((map__16140 == null)))?((((map__16140.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16140.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16140):map__16140);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16140__$1,cljs.core.cst$kw$status);
var instance = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16140__$1,cljs.core.cst$kw$instance);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16140__$1,cljs.core.cst$kw$note);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["submissionreview.json"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,status,cljs.core.cst$kw$instance,instance,cljs.core.cst$kw$note,note], null)], null)], 0));
});
/**
 * Create a submission review
 */
milia.api.dataset.create_multiple_submission_reviews = (function milia$api$dataset$create_multiple_submission_reviews(p__16142){
var map__16145 = p__16142;
var map__16145__$1 = ((((!((map__16145 == null)))?((((map__16145.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16145.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16145):map__16145);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16145__$1,cljs.core.cst$kw$status);
var instances = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16145__$1,cljs.core.cst$kw$instances);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16145__$1,cljs.core.cst$kw$note);
var json_vec = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (map__16145,map__16145__$1,status,instances,note){
return (function (instance){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$note,note,cljs.core.cst$kw$status,status,cljs.core.cst$kw$instance,instance], null);
});})(map__16145,map__16145__$1,status,instances,note))
,instances);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["submissionreview.json"], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,json_vec], null)], 0));
});
/**
 * Get a submission review
 */
milia.api.dataset.get_submission_review = (function milia$api$dataset$get_submission_review(submission_review_id){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["submissionreview",[cljs.core.str(submission_review_id),cljs.core.str(".json")].join('')], 0)));
});
/**
 * List a submission review
 */
milia.api.dataset.list_submission_reviews = (function milia$api$dataset$list_submission_reviews(){
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["submissionreview.json"], 0)));
});
/**
 * Update a submission review
 */
milia.api.dataset.update_submission_review = (function milia$api$dataset$update_submission_review(p__16147){
var map__16151 = p__16147;
var map__16151__$1 = ((((!((map__16151 == null)))?((((map__16151.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16151.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16151):map__16151);
var submission_review_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16151__$1,cljs.core.cst$kw$submission_DASH_review_DASH_id);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16151__$1,cljs.core.cst$kw$status);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16151__$1,cljs.core.cst$kw$note);
if(cljs.core.not_every_QMARK_(cljs.core.nil_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [status,note], null))){
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["submissionreview",[cljs.core.str(submission_review_id),cljs.core.str(".json")].join('')], 0)),cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,(function (){var G__16153 = cljs.core.PersistentArrayMap.EMPTY;
var G__16153__$1 = (cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(status) : chimera.core.not_nil_QMARK_.call(null,status)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__16153,cljs.core.cst$kw$status,status):G__16153);
if(cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(note) : chimera.core.not_nil_QMARK_.call(null,note)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__16153__$1,cljs.core.cst$kw$note,note);
} else {
return G__16153__$1;
}
})()], null)], 0));
} else {
return null;
}
});
milia.api.dataset.filter_submission_review_by_instance = (function milia$api$dataset$filter_submission_review_by_instance(p__16154){
var map__16158 = p__16154;
var map__16158__$1 = ((((!((map__16158 == null)))?((((map__16158.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16158.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16158):map__16158);
var instance = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16158__$1,cljs.core.cst$kw$instance);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16158__$1,cljs.core.cst$kw$status);
var note = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16158__$1,cljs.core.cst$kw$note);
var query_params_str = chimera.string.get_query_params_str((function (){var G__16160 = cljs.core.PersistentArrayMap.EMPTY;
var G__16160__$1 = (cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(instance) : chimera.core.not_nil_QMARK_.call(null,instance)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__16160,cljs.core.cst$kw$instance,instance):G__16160);
var G__16160__$2 = (cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(status) : chimera.core.not_nil_QMARK_.call(null,status)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__16160__$1,cljs.core.cst$kw$status,status):G__16160__$1);
if(cljs.core.truth_((chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.core.not_nil_QMARK_.cljs$core$IFn$_invoke$arity$1(note) : chimera.core.not_nil_QMARK_.call(null,note)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__16160__$2,cljs.core.cst$kw$note,note);
} else {
return G__16160__$2;
}
})());
return milia.api.http.parse_http(cljs.core.cst$kw$get,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("submissionreview.json"),cljs.core.str(query_params_str)].join('')], 0)));
});
milia.api.dataset.delete_submission_review = (function milia$api$dataset$delete_submission_review(instance){
return milia.api.http.parse_http(cljs.core.cst$kw$delete,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["submissionreview",[cljs.core.str(instance),cljs.core.str(".json")].join('')], 0)));
});
