// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.io');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('goog.net.cookies');
goog.require('goog.events');
goog.require('goog.net.IframeIo');
goog.require('cljs_http.client');
goog.require('cljs_hash.md5');
goog.require('cljs.core.async');
goog.require('chimera.seq');
goog.require('clojure.set');
goog.require('goog.net.XhrIo');
goog.require('chimera.string');
goog.require('clojure.string');
goog.require('milia.utils.remote');
/**
 * Build http-options based on arguments.
 */
milia.api.io.build_http_options = (function milia$api$io$build_http_options(http_options,method,no_cache_QMARK_){
var stateful_method_QMARK_ = chimera.seq.in_QMARK_(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$post,cljs.core.cst$kw$put,cljs.core.cst$kw$patch], null),method);
var param_key = (cljs.core.truth_(stateful_method_QMARK_)?cljs.core.cst$kw$form_DASH_params:cljs.core.cst$kw$query_DASH_params);
var http_options__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(http_options,cljs.core.cst$kw$with_DASH_credentials_QMARK_,false);
var G__15453 = http_options__$1;
if(cljs.core.truth_((function (){var and__6531__auto__ = no_cache_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return (cljs.core.not(cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(http_options__$1))) && (cljs.core.not(stateful_method_QMARK_));
} else {
return and__6531__auto__;
}
})())){
return cljs.core.assoc_in(G__15453,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param_key,cljs.core.cst$kw$t], null),(function (){var G__15454 = [cljs.core.str(Date.now())].join('');
return (cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1 ? cljs_hash.md5.md5.cljs$core$IFn$_invoke$arity$1(G__15454) : cljs_hash.md5.md5.call(null,G__15454));
})());
} else {
return G__15453;
}
});
/**
 * An almost 'batteries-included' request, similar to cljs-http.client/request.
 * Contains everything except response decoding.
 */
milia.api.io.raw_request = cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_json_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(cljs_http.core.request))))))))));
/**
 * Builds request headers for the HTTP request by adding
 *   Authorization, X-CSRFToken and Cache-control headers where necessary
 */
milia.api.io.token__GT_headers = (function milia$api$io$token__GT_headers(var_args){
var args__7658__auto__ = [];
var len__7651__auto___15459 = arguments.length;
var i__7652__auto___15460 = (0);
while(true){
if((i__7652__auto___15460 < len__7651__auto___15459)){
args__7658__auto__.push((arguments[i__7652__auto___15460]));

var G__15461 = (i__7652__auto___15460 + (1));
i__7652__auto___15460 = G__15461;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic = (function (p__15456){
var map__15457 = p__15456;
var map__15457__$1 = ((((!((map__15457 == null)))?((((map__15457.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15457.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15457):map__15457);
var get_crsftoken_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15457__$1,cljs.core.cst$kw$get_DASH_crsftoken_QMARK_);
var must_revalidate_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15457__$1,cljs.core.cst$kw$must_DASH_revalidate_QMARK_);
var accept_header = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15457__$1,cljs.core.cst$kw$accept_DASH_header);
var auth_token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15457__$1,cljs.core.cst$kw$auth_DASH_token);
var temp_token = cljs.core.cst$kw$temp_DASH_token.cljs$core$IFn$_invoke$arity$1(milia.utils.remote._STAR_credentials_STAR_);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(auth_token)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("Token "),cljs.core.str(auth_token)].join('')], null):(cljs.core.truth_((function (){var and__6531__auto__ = cljs.core.not_empty(temp_token);
if(cljs.core.truth_(and__6531__auto__)){
return (chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1 ? chimera.string.is_not_null_QMARK_.cljs$core$IFn$_invoke$arity$1(temp_token) : chimera.string.is_not_null_QMARK_.call(null,temp_token));
} else {
return and__6531__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Authorization",[cljs.core.str("TempToken "),cljs.core.str(temp_token)].join('')], null):null)),(cljs.core.truth_(must_revalidate_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cache-control","must-revalidate"], null):null),(function (){var temp__4657__auto__ = (function (){var and__6531__auto__ = get_crsftoken_QMARK_;
if(cljs.core.truth_(and__6531__auto__)){
return goog.net.cookies.get("csrftoken");
} else {
return and__6531__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var crsf_token = temp__4657__auto__;
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRFToken",crsf_token], null);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["X-CSRF-Token",crsf_token], null);
} else {
return null;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Accept",(function (){var or__6543__auto__ = accept_header;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return "application/json";
}
})()], null)], null));
});

milia.api.io.token__GT_headers.cljs$lang$maxFixedArity = (0);

milia.api.io.token__GT_headers.cljs$lang$applyTo = (function (seq15455){
return milia.api.io.token__GT_headers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq15455));
});

/**
 * Get the response out of an object that watches an async/xhr request.
 * JsIoObject, Maybe {Keyword Bool} -> {:keyword }
 */
milia.api.io.get_xhr_io_response = (function milia$api$io$get_xhr_io_response(var_args){
var args__7658__auto__ = [];
var len__7651__auto___15471 = arguments.length;
var i__7652__auto___15472 = (0);
while(true){
if((i__7652__auto___15472 < len__7651__auto___15471)){
args__7658__auto__.push((arguments[i__7652__auto___15472]));

var G__15473 = (i__7652__auto___15472 + (1));
i__7652__auto___15472 = G__15473;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic = (function (io_obj,p__15464){
var vec__15465 = p__15464;
var map__15468 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15465,(0),null);
var map__15468__$1 = ((((!((map__15468 == null)))?((((map__15468.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15468.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15468):map__15468);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15468__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
if(cljs.core.truth_(require_json_QMARK_)){
try{return io_obj.getResponseJson();
}catch (e15470){if((e15470 instanceof Error)){
var _ = e15470;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$error,io_obj.getResponseText()], null);
} else {
throw e15470;

}
}} else {
return io_obj.getResponseText();
}
});

milia.api.io.get_xhr_io_response.cljs$lang$maxFixedArity = (1);

milia.api.io.get_xhr_io_response.cljs$lang$applyTo = (function (seq15462){
var G__15463 = cljs.core.first(seq15462);
var seq15462__$1 = cljs.core.next(seq15462);
return milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(G__15463,seq15462__$1);
});

milia.api.io.upload_via_iframe = (function milia$api$io$upload_via_iframe(form,form_api,event_chan){
var io_obj = (new goog.net.IframeIo());
var G__15480_15486 = io_obj;
var G__15481_15487 = goog.net.EventType.SUCCESS;
var G__15482_15488 = ((function (G__15480_15486,G__15481_15487,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__15480_15486,G__15481_15487,io_obj))
;
goog.events.listen(G__15480_15486,G__15481_15487,G__15482_15488);

var G__15483_15489 = io_obj;
var G__15484_15490 = goog.net.EventType.ERROR;
var G__15485_15491 = ((function (G__15483_15489,G__15484_15490,io_obj){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$data,io_obj.getResponseText()], null));
});})(G__15483_15489,G__15484_15490,io_obj))
;
goog.events.listen(G__15483_15489,G__15484_15490,G__15485_15491);

return io_obj.sendFromForm(form,[cljs.core.str(form_api),cljs.core.str("?legacy=true")].join(''));
});
/**
 * Use goog.net.XhrIo to upload file. Receives an HTML form object,
 *   a core.async channel where result message will be put
 *   and (optionally) an id to include in the result message. Returns the
 *   XhrIo object that can be used to abort request. More XhrIo API
 *   docs at: https://developers.google.com/closure/library/docs/xhrio
 */
milia.api.io.upload_file = (function milia$api$io$upload_file(var_args){
var args__7658__auto__ = [];
var len__7651__auto___15511 = arguments.length;
var i__7652__auto___15512 = (0);
while(true){
if((i__7652__auto___15512 < len__7651__auto___15511)){
args__7658__auto__.push((arguments[i__7652__auto___15512]));

var G__15513 = (i__7652__auto___15512 + (1));
i__7652__auto___15512 = G__15513;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,chan,p__15496){
var map__15497 = p__15496;
var map__15497__$1 = ((((!((map__15497 == null)))?((((map__15497.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15497.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15497):map__15497);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15497__$1,cljs.core.cst$kw$headers);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15497__$1,cljs.core.cst$kw$id);
var require_json_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15497__$1,cljs.core.cst$kw$require_DASH_json_QMARK_);
var io_obj = (new goog.net.XhrIo());
var data = (cljs.core.truth_(id)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,id], null):null);
var url = form.action;
io_obj.setProgressEventsEnabled(true);

var G__15499_15514 = io_obj;
var G__15500_15515 = goog.net.EventType.COMPLETE;
var G__15501_15516 = ((function (G__15499_15514,G__15500_15515,io_obj,data,url,map__15497,map__15497__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0))));
});})(G__15499_15514,G__15500_15515,io_obj,data,url,map__15497,map__15497__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__15499_15514,G__15500_15515,G__15501_15516);

var G__15502_15517 = io_obj;
var G__15503_15518 = goog.net.EventType.SUCCESS;
var G__15504_15519 = ((function (G__15502_15517,G__15503_15518,io_obj,data,url,map__15497,map__15497__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,true], 0)));
});})(G__15502_15517,G__15503_15518,io_obj,data,url,map__15497,map__15497__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__15502_15517,G__15503_15518,G__15504_15519);

var G__15505_15520 = io_obj;
var G__15506_15521 = goog.net.EventType.ERROR;
var G__15507_15522 = ((function (G__15505_15520,G__15506_15521,io_obj,data,url,map__15497,map__15497__$1,headers,id,require_json_QMARK_){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.cst$kw$data,milia.api.io.get_xhr_io_response.cljs$core$IFn$_invoke$arity$variadic(io_obj,cljs.core.array_seq([require_json_QMARK_], 0)),cljs.core.array_seq([cljs.core.cst$kw$success_QMARK_,false], 0)));
});})(G__15505_15520,G__15506_15521,io_obj,data,url,map__15497,map__15497__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__15505_15520,G__15506_15521,G__15507_15522);

var G__15508_15523 = io_obj;
var G__15509_15524 = goog.net.EventType.PROGRESS;
var G__15510_15525 = ((function (G__15508_15523,G__15509_15524,io_obj,data,url,map__15497,map__15497__$1,headers,id,require_json_QMARK_){
return (function (p1__15492_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,cljs.core.cst$kw$progress,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$length_DASH_computable,p1__15492_SHARP_.lengthComputable,cljs.core.cst$kw$loaded,p1__15492_SHARP_.loaded,cljs.core.cst$kw$total,p1__15492_SHARP_.total], null)));
});})(G__15508_15523,G__15509_15524,io_obj,data,url,map__15497,map__15497__$1,headers,id,require_json_QMARK_))
;
goog.events.listen(G__15508_15523,G__15509_15524,G__15510_15525);

io_obj.send(url,"POST",form,headers);

return io_obj;
});

milia.api.io.upload_file.cljs$lang$maxFixedArity = (2);

milia.api.io.upload_file.cljs$lang$applyTo = (function (seq15493){
var G__15494 = cljs.core.first(seq15493);
var seq15493__$1 = cljs.core.next(seq15493);
var G__15495 = cljs.core.first(seq15493__$1);
var seq15493__$2 = cljs.core.next(seq15493__$1);
return milia.api.io.upload_file.cljs$core$IFn$_invoke$arity$variadic(G__15494,G__15495,seq15493__$2);
});

/**
 * Wraps cljs-http.client/request and redirects if status is 401
 */
milia.api.io.http_request = (function milia$api$io$http_request(var_args){
var args__7658__auto__ = [];
var len__7651__auto___15590 = arguments.length;
var i__7652__auto___15591 = (0);
while(true){
if((i__7652__auto___15591 < len__7651__auto___15590)){
args__7658__auto__.push((arguments[i__7652__auto___15591]));

var G__15592 = (i__7652__auto___15591 + (1));
i__7652__auto___15591 = G__15592;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic = (function (request_fn,args){
var response_channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__12537__auto___15593 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12537__auto___15593,response_channel){
return (function (){
var f__12538__auto__ = (function (){var switch__12460__auto__ = ((function (c__12537__auto___15593,response_channel){
return (function (state_15563){
var state_val_15564 = (state_15563[(1)]);
if((state_val_15564 === (7))){
var state_15563__$1 = state_15563;
var statearr_15565_15594 = state_15563__$1;
(statearr_15565_15594[(2)] = false);

(statearr_15565_15594[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15564 === (1))){
var inst_15529 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(request_fn,args);
var state_15563__$1 = state_15563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15563__$1,(2),inst_15529);
} else {
if((state_val_15564 === (4))){
var state_15563__$1 = state_15563;
var statearr_15566_15595 = state_15563__$1;
(statearr_15566_15595[(2)] = false);

(statearr_15566_15595[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15564 === (13))){
var inst_15552 = (state_15563[(7)]);
var inst_15559 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_channel,inst_15552);
var state_15563__$1 = state_15563;
var statearr_15567_15596 = state_15563__$1;
(statearr_15567_15596[(2)] = inst_15559);

(statearr_15567_15596[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15564 === (6))){
var state_15563__$1 = state_15563;
var statearr_15568_15597 = state_15563__$1;
(statearr_15568_15597[(2)] = true);

(statearr_15568_15597[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15564 === (3))){
var inst_15531 = (state_15563[(8)]);
var inst_15536 = inst_15531.cljs$lang$protocol_mask$partition0$;
var inst_15537 = (inst_15536 & (64));
var inst_15538 = inst_15531.cljs$core$ISeq$;
var inst_15539 = (cljs.core.PROTOCOL_SENTINEL === inst_15538);
var inst_15540 = (inst_15537) || (inst_15539);
var state_15563__$1 = state_15563;
if(cljs.core.truth_(inst_15540)){
var statearr_15569_15598 = state_15563__$1;
(statearr_15569_15598[(1)] = (6));

} else {
var statearr_15570_15599 = state_15563__$1;
(statearr_15570_15599[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15564 === (12))){
var inst_15556 = window.location.href();
var inst_15557 = window.location = inst_15556;
var state_15563__$1 = state_15563;
var statearr_15571_15600 = state_15563__$1;
(statearr_15571_15600[(2)] = inst_15557);

(statearr_15571_15600[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15564 === (2))){
var inst_15531 = (state_15563[(8)]);
var inst_15531__$1 = (state_15563[(2)]);
var inst_15533 = (inst_15531__$1 == null);
var inst_15534 = cljs.core.not(inst_15533);
var state_15563__$1 = (function (){var statearr_15572 = state_15563;
(statearr_15572[(8)] = inst_15531__$1);

return statearr_15572;
})();
if(inst_15534){
var statearr_15573_15601 = state_15563__$1;
(statearr_15573_15601[(1)] = (3));

} else {
var statearr_15574_15602 = state_15563__$1;
(statearr_15574_15602[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15564 === (11))){
var inst_15552 = (state_15563[(7)]);
var inst_15552__$1 = (state_15563[(2)]);
var inst_15553 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15552__$1,cljs.core.cst$kw$status);
var inst_15554 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15553,(401));
var state_15563__$1 = (function (){var statearr_15575 = state_15563;
(statearr_15575[(7)] = inst_15552__$1);

return statearr_15575;
})();
if(inst_15554){
var statearr_15576_15603 = state_15563__$1;
(statearr_15576_15603[(1)] = (12));

} else {
var statearr_15577_15604 = state_15563__$1;
(statearr_15577_15604[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15564 === (9))){
var inst_15531 = (state_15563[(8)]);
var inst_15549 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_15531);
var state_15563__$1 = state_15563;
var statearr_15578_15605 = state_15563__$1;
(statearr_15578_15605[(2)] = inst_15549);

(statearr_15578_15605[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15564 === (5))){
var inst_15547 = (state_15563[(2)]);
var state_15563__$1 = state_15563;
if(cljs.core.truth_(inst_15547)){
var statearr_15579_15606 = state_15563__$1;
(statearr_15579_15606[(1)] = (9));

} else {
var statearr_15580_15607 = state_15563__$1;
(statearr_15580_15607[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15564 === (14))){
var inst_15561 = (state_15563[(2)]);
var state_15563__$1 = state_15563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15563__$1,inst_15561);
} else {
if((state_val_15564 === (10))){
var inst_15531 = (state_15563[(8)]);
var state_15563__$1 = state_15563;
var statearr_15581_15608 = state_15563__$1;
(statearr_15581_15608[(2)] = inst_15531);

(statearr_15581_15608[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15564 === (8))){
var inst_15544 = (state_15563[(2)]);
var state_15563__$1 = state_15563;
var statearr_15582_15609 = state_15563__$1;
(statearr_15582_15609[(2)] = inst_15544);

(statearr_15582_15609[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12537__auto___15593,response_channel))
;
return ((function (switch__12460__auto__,c__12537__auto___15593,response_channel){
return (function() {
var milia$api$io$state_machine__12461__auto__ = null;
var milia$api$io$state_machine__12461__auto____0 = (function (){
var statearr_15586 = [null,null,null,null,null,null,null,null,null];
(statearr_15586[(0)] = milia$api$io$state_machine__12461__auto__);

(statearr_15586[(1)] = (1));

return statearr_15586;
});
var milia$api$io$state_machine__12461__auto____1 = (function (state_15563){
while(true){
var ret_value__12462__auto__ = (function (){try{while(true){
var result__12463__auto__ = switch__12460__auto__(state_15563);
if(cljs.core.keyword_identical_QMARK_(result__12463__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12463__auto__;
}
break;
}
}catch (e15587){if((e15587 instanceof Object)){
var ex__12464__auto__ = e15587;
var statearr_15588_15610 = state_15563;
(statearr_15588_15610[(5)] = ex__12464__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15563);

return cljs.core.cst$kw$recur;
} else {
throw e15587;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12462__auto__,cljs.core.cst$kw$recur)){
var G__15611 = state_15563;
state_15563 = G__15611;
continue;
} else {
return ret_value__12462__auto__;
}
break;
}
});
milia$api$io$state_machine__12461__auto__ = function(state_15563){
switch(arguments.length){
case 0:
return milia$api$io$state_machine__12461__auto____0.call(this);
case 1:
return milia$api$io$state_machine__12461__auto____1.call(this,state_15563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$api$io$state_machine__12461__auto__.cljs$core$IFn$_invoke$arity$0 = milia$api$io$state_machine__12461__auto____0;
milia$api$io$state_machine__12461__auto__.cljs$core$IFn$_invoke$arity$1 = milia$api$io$state_machine__12461__auto____1;
return milia$api$io$state_machine__12461__auto__;
})()
;})(switch__12460__auto__,c__12537__auto___15593,response_channel))
})();
var state__12539__auto__ = (function (){var statearr_15589 = (f__12538__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12538__auto__.cljs$core$IFn$_invoke$arity$0() : f__12538__auto__.call(null));
(statearr_15589[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12537__auto___15593);

return statearr_15589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12539__auto__);
});})(c__12537__auto___15593,response_channel))
);


return response_channel;
});

milia.api.io.http_request.cljs$lang$maxFixedArity = (1);

milia.api.io.http_request.cljs$lang$applyTo = (function (seq15526){
var G__15527 = cljs.core.first(seq15526);
var seq15526__$1 = cljs.core.next(seq15526);
return milia.api.io.http_request.cljs$core$IFn$_invoke$arity$variadic(G__15527,seq15526__$1);
});

