// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.organization');
goog.require('cljs.core');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('cljs.core.async');
milia.api.organization.internal_members_team_name = "members";
milia.api.organization.owners_team_name = "Owners";
milia.api.organization.editor_role = "editor";
/**
 * List all the organizations belonging to the account making the request.
 * When a username is provided, return only those organizations shared by both
 * the account making the request and the user associated with the username.
 */
milia.api.organization.all = (function milia$api$organization$all(var_args){
var args__7658__auto__ = [];
var len__7651__auto___15834 = arguments.length;
var i__7652__auto___15835 = (0);
while(true){
if((i__7652__auto___15835 < len__7651__auto___15834)){
args__7658__auto__.push((arguments[i__7652__auto___15835]));

var G__15836 = (i__7652__auto___15835 + (1));
i__7652__auto___15835 = G__15836;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((0) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((0)),(0),null)):null);
return milia.api.organization.all.cljs$core$IFn$_invoke$arity$variadic(argseq__7659__auto__);
});

milia.api.organization.all.cljs$core$IFn$_invoke$arity$variadic = (function (p__15830){
var vec__15831 = p__15830;
var username = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15831,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(username)?[cljs.core.str("orgs.json?shared_with="),cljs.core.str(username)].join(''):"orgs.json")], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.organization.all.cljs$lang$maxFixedArity = (0);

milia.api.organization.all.cljs$lang$applyTo = (function (seq15829){
return milia.api.organization.all.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq15829));
});

milia.api.organization.create = (function milia$api$organization$create(data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,data], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
milia.api.organization.profile = (function milia$api$organization$profile(var_args){
var args__7658__auto__ = [];
var len__7651__auto___15842 = arguments.length;
var i__7652__auto___15843 = (0);
while(true){
if((i__7652__auto___15843 < len__7651__auto___15842)){
args__7658__auto__.push((arguments[i__7652__auto___15843]));

var G__15844 = (i__7652__auto___15843 + (1));
i__7652__auto___15843 = G__15844;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic = (function (org_name,p__15839){
var map__15840 = p__15839;
var map__15840__$1 = ((((!((map__15840 == null)))?((((map__15840.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15840.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15840):map__15840);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15840__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",[cljs.core.str(org_name),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.organization.profile.cljs$lang$maxFixedArity = (1);

milia.api.organization.profile.cljs$lang$applyTo = (function (seq15837){
var G__15838 = cljs.core.first(seq15837);
var seq15837__$1 = cljs.core.next(seq15837);
return milia.api.organization.profile.cljs$core$IFn$_invoke$arity$variadic(G__15838,seq15837__$1);
});

milia.api.organization.retrieve_org_metadata = (function milia$api$organization$retrieve_org_metadata(username){
return cljs.core.cst$kw$metadata.cljs$core$IFn$_invoke$arity$1(milia.api.organization.profile(username));
});
/**
 * Return whether a user can create projects within an organization
 */
milia.api.organization.can_user_create_project_under_organization_QMARK_ = (function milia$api$organization$can_user_create_project_under_organization_QMARK_(username_to_check,organization){
var role = cljs.core.cst$kw$role.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__15845_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$user.cljs$core$IFn$_invoke$arity$1(p1__15845_SHARP_),username_to_check);
}),cljs.core.cst$kw$users.cljs$core$IFn$_invoke$arity$1(organization))));
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(role,"manager")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(role,"owner"));
});
milia.api.organization.get_organizations_where_user_can_create_projects = (function milia$api$organization$get_organizations_where_user_can_create_projects(username_to_check){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__15846_SHARP_){
return milia.api.organization.can_user_create_project_under_organization_QMARK_(username_to_check,p1__15846_SHARP_);
}),milia.api.organization.all());
});
/**
 * Return all the teams for an organization.
 */
milia.api.organization.teams_all = (function milia$api$organization$teams_all(var_args){
var args15847 = [];
var len__7651__auto___15850 = arguments.length;
var i__7652__auto___15851 = (0);
while(true){
if((i__7652__auto___15851 < len__7651__auto___15850)){
args15847.push((arguments[i__7652__auto___15851]));

var G__15852 = (i__7652__auto___15851 + (1));
i__7652__auto___15851 = G__15852;
continue;
} else {
}
break;
}

var G__15849 = args15847.length;
switch (G__15849) {
case 0:
return milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15847.length)].join('')));

}
});

milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$1(null);
});

milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$1 = (function (organization_name){
var base_url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams.json"], 0));
var url = (cljs.core.truth_(organization_name)?[cljs.core.str(base_url),cljs.core.str("?org="),cljs.core.str(organization_name)].join(''):base_url);
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});

milia.api.organization.teams_all.cljs$lang$maxFixedArity = 1;

/**
 * Return the teams for an organization, removing 'members' team that is used
 * internall by the API to store non-team based org members.
 */
milia.api.organization.teams = (function milia$api$organization$teams(org_name){
var teams = milia.api.organization.teams_all.cljs$core$IFn$_invoke$arity$0();
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (teams){
return (function (p1__15854_SHARP_){
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(milia.api.organization.internal_members_team_name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(p1__15854_SHARP_))) || (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(org_name,cljs.core.cst$kw$organization.cljs$core$IFn$_invoke$arity$1(p1__15854_SHARP_)));
});})(teams))
,teams);
});
milia.api.organization.team_info = (function milia$api$organization$team_info(org_name,team_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",org_name,[cljs.core.str(team_id),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.organization.team_members = (function milia$api$organization$team_members(team_id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",team_id,"members.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add a team to an organization
 */
milia.api.organization.create_team = (function milia$api$organization$create_team(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,params], null)], 0));
});
/**
 * Add a user to a team
 */
milia.api.organization.add_team_member = (function milia$api$organization$add_team_member(org_name,team_id,user){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",org_name,team_id,"members.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,user], null)], 0));
});
milia.api.organization.members = (function milia$api$organization$members(org_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Add a user to an organization
 */
milia.api.organization.add_member = (function milia$api$organization$add_member(var_args){
var args15855 = [];
var len__7651__auto___15858 = arguments.length;
var i__7652__auto___15859 = (0);
while(true){
if((i__7652__auto___15859 < len__7651__auto___15858)){
args15855.push((arguments[i__7652__auto___15859]));

var G__15860 = (i__7652__auto___15859 + (1));
i__7652__auto___15859 = G__15860;
continue;
} else {
}
break;
}

var G__15857 = args15855.length;
switch (G__15857) {
case 2:
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15855.length)].join('')));

}
});

milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$2 = (function (org_name,member){
return milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3(org_name,member,null);
});

milia.api.organization.add_member.cljs$core$IFn$_invoke$arity$3 = (function (org_name,member,role){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members.json"], 0));
var assigned_role = (function (){var or__6543__auto__ = role;
if(cljs.core.truth_(or__6543__auto__)){
return or__6543__auto__;
} else {
return milia.api.organization.editor_role;
}
})();
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,member,cljs.core.cst$kw$role,assigned_role], null)], null),cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true,cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});

milia.api.organization.add_member.cljs$lang$maxFixedArity = 3;

/**
 * Change the role of an organization member
 */
milia.api.organization.change_org_member_role = (function milia$api$organization$change_org_member_role(member,org_name,event_chan){
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,cljs.core.cst$kw$username.cljs$core$IFn$_invoke$arity$1(member),cljs.core.cst$kw$role,cljs.core.cst$kw$role.cljs$core$IFn$_invoke$arity$1(member)], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members.json"], 0)),cljs.core.array_seq([cljs.core.cst$kw$callback,((function (data){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(event_chan,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$updated_DASH_member,member], null));
});})(data))
,cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,data], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
/**
 * Remove a user from an organization or organization team
 */
milia.api.organization.remove_member = (function milia$api$organization$remove_member(var_args){
var args15862 = [];
var len__7651__auto___15865 = arguments.length;
var i__7652__auto___15866 = (0);
while(true){
if((i__7652__auto___15866 < len__7651__auto___15865)){
args15862.push((arguments[i__7652__auto___15866]));

var G__15867 = (i__7652__auto___15866 + (1));
i__7652__auto___15866 = G__15867;
continue;
} else {
}
break;
}

var G__15864 = args15862.length;
switch (G__15864) {
case 2:
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args15862.length)].join('')));

}
});

milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$2 = (function (org_name,member){
return milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3(org_name,member,null);
});

milia.api.organization.remove_member.cljs$core$IFn$_invoke$arity$3 = (function (org_name,member,team_id){
var url = (cljs.core.truth_(team_id)?milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",org_name,team_id,"members.json"], 0)):milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",org_name,"members.json"], 0)));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$delete,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$username,member], null)], null)], 0));
});

milia.api.organization.remove_member.cljs$lang$maxFixedArity = 3;

/**
 * Is the user the only member of the Owners team.
 */
milia.api.organization.single_owner_QMARK_ = (function milia$api$organization$single_owner_QMARK_(team,members){
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(milia.api.organization.owners_team_name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(team))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(members)));
});
/**
 * Is user only members in org with owner role?
 */
milia.api.organization.single_owner_member_QMARK_ = (function milia$api$organization$single_owner_member_QMARK_(org_name){
var org = milia.api.organization.profile(org_name);
var users = cljs.core.cst$kw$users.cljs$core$IFn$_invoke$arity$1(org);
var owner_roles = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (org,users){
return (function (p1__15869_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("owner",p1__15869_SHARP_);
});})(org,users))
,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$role,users));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(owner_roles),(1));
});
/**
 * update organization profile
 */
milia.api.organization.update = (function milia$api$organization$update(params){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["orgs",[cljs.core.str(cljs.core.cst$kw$org.cljs$core$IFn$_invoke$arity$1(params)),cljs.core.str(".json")].join('')], 0));
var params__$1 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(params,cljs.core.cst$kw$org);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,params__$1], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
/**
 * Returns an Organizaion team given the team name.
 */
milia.api.organization.get_team = (function milia$api$organization$get_team(org_name,team_name){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([[cljs.core.str("teams.json?org="),cljs.core.str(org_name)].join('')], 0));
var teams = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$suppress_DASH_4xx_DASH_exceptions_QMARK_,true], 0));
return cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (url,teams){
return (function (p1__15870_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(team_name,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(p1__15870_SHARP_));
});})(url,teams))
,teams));
});
milia.api.organization.share_team = (function milia$api$organization$share_team(team_id,data){

var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["teams",team_id,"share.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,data], null),cljs.core.cst$kw$as_DASH_map_QMARK_,true], 0));
});
