// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.project');
goog.require('cljs.core');
goog.require('chimera.urls');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.metadata');
goog.require('milia.utils.remote');
/**
 * Parse and add the projects ID.
 */
milia.api.project.add_id = (function milia$api$project$add_id(project_data){
if(typeof project_data === 'string'){
return null;
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([project_data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,chimera.urls.last_url_param(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(project_data))], null)], 0));
}
});
/**
 * Get the forms for this account and owner of the user.
 */
milia.api.project.get_forms = (function milia$api$project$get_forms(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"forms.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
milia.api.project.get_project = (function milia$api$project$get_project(var_args){
var args__7658__auto__ = [];
var len__7651__auto___15909 = arguments.length;
var i__7652__auto___15910 = (0);
while(true){
if((i__7652__auto___15910 < len__7651__auto___15909)){
args__7658__auto__.push((arguments[i__7652__auto___15910]));

var G__15911 = (i__7652__auto___15910 + (1));
i__7652__auto___15910 = G__15911;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__15906){
var map__15907 = p__15906;
var map__15907__$1 = ((((!((map__15907 == null)))?((((map__15907.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15907.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15907):map__15907);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15907__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",[cljs.core.str(id),cljs.core.str(".json")].join('')], 0));
var data = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
return data;
});

milia.api.project.get_project.cljs$lang$maxFixedArity = (1);

milia.api.project.get_project.cljs$lang$applyTo = (function (seq15904){
var G__15905 = cljs.core.first(seq15904);
var seq15904__$1 = cljs.core.next(seq15904);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic(G__15905,seq15904__$1);
});

/**
 * Return all project for this account and owner or the user.
 */
milia.api.project.all = (function milia$api$project$all(var_args){
var args15914 = [];
var len__7651__auto___15922 = arguments.length;
var i__7652__auto___15923 = (0);
while(true){
if((i__7652__auto___15923 < len__7651__auto___15922)){
args15914.push((arguments[i__7652__auto___15923]));

var G__15924 = (i__7652__auto___15923 + (1));
i__7652__auto___15923 = G__15924;
continue;
} else {
}
break;
}

var G__15918 = args15914.length;
switch (G__15918) {
case 0:
return milia.api.project.all.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__7670__auto__ = (new cljs.core.IndexedSeq(args15914.slice((1)),(0),null));
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7670__auto__);

}
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.project.all(null);
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic = (function (owner,p__15919){
var map__15920 = p__15919;
var map__15920__$1 = ((((!((map__15920 == null)))?((((map__15920.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15920.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15920):map__15920);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15920__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
var logged_in_username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15920__$1,cljs.core.cst$kw$logged_DASH_in_DASH_username);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects.json"], 0));
var options = ((function (url,map__15920,map__15920__$1,no_cache_QMARK_,logged_in_username){
return (function (p1__15913_SHARP_){
if(cljs.core.truth_(logged_in_username)){
return cljs.core.assoc_in(p1__15913_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$u], null),logged_in_username);
} else {
return p1__15913_SHARP_;
}
});})(url,map__15920,map__15920__$1,no_cache_QMARK_,logged_in_username))
.call(null,((function (url,map__15920,map__15920__$1,no_cache_QMARK_,logged_in_username){
return (function (p1__15912_SHARP_){
if(cljs.core.truth_(owner)){
return cljs.core.assoc_in(p1__15912_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$owner], null),owner);
} else {
return p1__15912_SHARP_;
}
});})(url,map__15920,map__15920__$1,no_cache_QMARK_,logged_in_username))
.call(null,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,null], null)));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,options,cljs.core.cst$kw$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.project.all.cljs$lang$applyTo = (function (seq15915){
var G__15916 = cljs.core.first(seq15915);
var seq15915__$1 = cljs.core.next(seq15915);
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic(G__15916,seq15915__$1);
});

milia.api.project.all.cljs$lang$maxFixedArity = (1);

/**
 * Create a project for this account and owner or the user.
 */
milia.api.project.create = (function milia$api$project$create(data,owner){
var owner_url = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",[cljs.core.str(owner),cljs.core.str(".json")].join('')], 0))], null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects.json"], 0));
var form_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([owner_url,data], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,form_params], null)], 0));
});
/**
 * Update project metadata
 */
milia.api.project.update = (function milia$api$project$update(project_id,data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",[cljs.core.str(project_id),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$json_DASH_params,data], null)], 0));
});
/**
 * Share project with specific user or remove specific user from project
 */
milia.api.project.share = (function milia$api$project$share(var_args){
var args__7658__auto__ = [];
var len__7651__auto___15934 = arguments.length;
var i__7652__auto___15935 = (0);
while(true){
if((i__7652__auto___15935 < len__7651__auto___15934)){
args__7658__auto__.push((arguments[i__7652__auto___15935]));

var G__15936 = (i__7652__auto___15935 + (1));
i__7652__auto___15935 = G__15936;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((3) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((3)),(0),null)):null);
return milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7659__auto__);
});

milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,username,role,p__15930){
var vec__15931 = p__15930;
var remove_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15931,(0),null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id,"share.json"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$username,username,cljs.core.cst$kw$role,role], null);
var form_params = (cljs.core.truth_(remove_QMARK_)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$remove,"True"], null)], 0)):data);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$put,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,form_params], null)], 0));
});

milia.api.project.share.cljs$lang$maxFixedArity = (3);

milia.api.project.share.cljs$lang$applyTo = (function (seq15926){
var G__15927 = cljs.core.first(seq15926);
var seq15926__$1 = cljs.core.next(seq15926);
var G__15928 = cljs.core.first(seq15926__$1);
var seq15926__$2 = cljs.core.next(seq15926__$1);
var G__15929 = cljs.core.first(seq15926__$2);
var seq15926__$3 = cljs.core.next(seq15926__$2);
return milia.api.project.share.cljs$core$IFn$_invoke$arity$variadic(G__15927,G__15928,G__15929,seq15926__$3);
});

/**
 * Add tags to a project.
 */
milia.api.project.add_tags = (function milia$api$project$add_tags(id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"labels.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null),cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Get projects with given tags.
 */
milia.api.project.with_tag = (function milia$api$project$with_tag(tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$get,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null)], null)], 0));
});
/**
 * Add star to project for this user.
 */
milia.api.project.add_star = (function milia$api$project$add_star(var_args){
var args__7658__auto__ = [];
var len__7651__auto___15942 = arguments.length;
var i__7652__auto___15943 = (0);
while(true){
if((i__7652__auto___15943 < len__7651__auto___15942)){
args__7658__auto__.push((arguments[i__7652__auto___15943]));

var G__15944 = (i__7652__auto___15943 + (1));
i__7652__auto___15943 = G__15944;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__15939){
var map__15940 = p__15939;
var map__15940__$1 = ((((!((map__15940 == null)))?((((map__15940.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15940.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15940):map__15940);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15940__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$post,url,cljs.core.array_seq([cljs.core.cst$kw$callback,callback], 0));
});

milia.api.project.add_star.cljs$lang$maxFixedArity = (1);

milia.api.project.add_star.cljs$lang$applyTo = (function (seq15937){
var G__15938 = cljs.core.first(seq15937);
var seq15937__$1 = cljs.core.next(seq15937);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic(G__15938,seq15937__$1);
});

/**
 * Remove star from project for this user.
 */
milia.api.project.remove_star = (function milia$api$project$remove_star(var_args){
var args__7658__auto__ = [];
var len__7651__auto___15950 = arguments.length;
var i__7652__auto___15951 = (0);
while(true){
if((i__7652__auto___15951 < len__7651__auto___15950)){
args__7658__auto__.push((arguments[i__7652__auto___15951]));

var G__15952 = (i__7652__auto___15951 + (1));
i__7652__auto___15951 = G__15952;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__15947){
var map__15948 = p__15947;
var map__15948__$1 = ((((!((map__15948 == null)))?((((map__15948.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15948.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15948):map__15948);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15948__$1,cljs.core.cst$kw$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star.json"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$delete,url,cljs.core.array_seq([cljs.core.cst$kw$callback,callback], 0));
});

milia.api.project.remove_star.cljs$lang$maxFixedArity = (1);

milia.api.project.remove_star.cljs$lang$applyTo = (function (seq15945){
var G__15946 = cljs.core.first(seq15945);
var seq15945__$1 = cljs.core.next(seq15945);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic(G__15946,seq15945__$1);
});

/**
 * Toggle between starred and unstarred for a user's project
 */
milia.api.project.toggle_star = (function milia$api$project$toggle_star(id,star_QMARK_,callback){
return (cljs.core.truth_(star_QMARK_)?milia.api.project.add_star:milia.api.project.remove_star).call(null,id,cljs.core.cst$kw$callback,callback);
});
/**
 * Get projects this user has starred.
 */
milia.api.project.get_starred = (function milia$api$project$get_starred(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user",username,"starred.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Get user that starred this project.
 */
milia.api.project.starred_by = (function milia$api$project$starred_by(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star.json"], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$get,url);
});
/**
 * Delete a project
 */
milia.api.project.delete$ = (function milia$api$project$delete(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",[cljs.core.str(id),cljs.core.str(".json")].join('')], 0));
return milia.api.http.parse_http(cljs.core.cst$kw$delete,url);
});
/**
 * Set new project owner
 */
milia.api.project.transfer_owner = (function milia$api$project$transfer_owner(id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",[cljs.core.str(id),cljs.core.str(".json")].join('')], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",[cljs.core.str(new_owner),cljs.core.str(".json")].join('')], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$owner,new_owner__$1], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$patch,url,cljs.core.array_seq([cljs.core.cst$kw$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$form_DASH_params,form_params,cljs.core.cst$kw$content_DASH_type,cljs.core.cst$kw$json], null)], 0));
});
/**
 * Update the project public setting.
 */
milia.api.project.update_public = (function milia$api$project$update_public(projectid,public$){
return milia.api.project.update(projectid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$public,public$], null));
});
milia.api.project.files = (function milia$api$project$files(var_args){
var args__7658__auto__ = [];
var len__7651__auto___15958 = arguments.length;
var i__7652__auto___15959 = (0);
while(true){
if((i__7652__auto___15959 < len__7651__auto___15958)){
args__7658__auto__.push((arguments[i__7652__auto___15959]));

var G__15960 = (i__7652__auto___15959 + (1));
i__7652__auto___15959 = G__15960;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((1) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((1)),(0),null)):null);
return milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7659__auto__);
});

milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic = (function (project_id,p__15955){
var map__15956 = p__15955;
var map__15956__$1 = ((((!((map__15956 == null)))?((((map__15956.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15956.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15956):map__15956);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15956__$1,cljs.core.cst$kw$no_DASH_cache_QMARK_);
return milia.utils.metadata.metadata_files(cljs.core.cst$kw$project,project_id,no_cache_QMARK_);
});

milia.api.project.files.cljs$lang$maxFixedArity = (1);

milia.api.project.files.cljs$lang$applyTo = (function (seq15953){
var G__15954 = cljs.core.first(seq15953);
var seq15953__$1 = cljs.core.next(seq15953);
return milia.api.project.files.cljs$core$IFn$_invoke$arity$variadic(G__15954,seq15953__$1);
});

