// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('milia.utils.retry');
goog.require('cljs.core');
goog.require('chimera.seq');
goog.require('cljs.core.async');
goog.require('milia.api.http');
milia.utils.retry.default_max_retries = (1);
milia.utils.retry.default_retry_for_statuses = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(500),(502),(503),(504)], null);
milia.utils.retry.initial_polling_interval = (1000);
milia.utils.retry.retry_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$max_DASH_retries,cljs.core.cst$kw$retry_DASH_for_DASH_statuses], null);
/**
 * Retry if a status code in retry-for-statuses is returned. Pauses for an
 * exponentially backedoff initial-polling-interval in ClojureScript. Does not
 * pause between retries in Clojure.
 */
milia.utils.retry.retry_parse_http = (function milia$utils$retry$retry_parse_http(var_args){
var args__7658__auto__ = [];
var len__7651__auto___15798 = arguments.length;
var i__7652__auto___15799 = (0);
while(true){
if((i__7652__auto___15799 < len__7651__auto___15798)){
args__7658__auto__.push((arguments[i__7652__auto___15799]));

var G__15800 = (i__7652__auto___15799 + (1));
i__7652__auto___15799 = G__15800;
continue;
} else {
}
break;
}

var argseq__7659__auto__ = ((((2) < args__7658__auto__.length))?(new cljs.core.IndexedSeq(args__7658__auto__.slice((2)),(0),null)):null);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7659__auto__);
});

milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic = (function (method,url,p__15711){
var map__15712 = p__15711;
var map__15712__$1 = ((((!((map__15712 == null)))?((((map__15712.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15712.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15712):map__15712);
var options = map__15712__$1;
var max_retries = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15712__$1,cljs.core.cst$kw$max_DASH_retries,milia.utils.retry.default_max_retries);
var retry_for_statuses = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__15712__$1,cljs.core.cst$kw$retry_DASH_for_DASH_statuses,milia.utils.retry.default_retry_for_statuses);
var c__12537__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__12537__auto__,map__15712,map__15712__$1,options,max_retries,retry_for_statuses){
return (function (){
var f__12538__auto__ = (function (){var switch__12460__auto__ = ((function (c__12537__auto__,map__15712,map__15712__$1,options,max_retries,retry_for_statuses){
return (function (state_15763){
var state_val_15764 = (state_15763[(1)]);
if((state_val_15764 === (7))){
var inst_15737 = (state_15763[(2)]);
var state_15763__$1 = state_15763;
if(cljs.core.truth_(inst_15737)){
var statearr_15765_15801 = state_15763__$1;
(statearr_15765_15801[(1)] = (11));

} else {
var statearr_15766_15802 = state_15763__$1;
(statearr_15766_15802[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (20))){
var inst_15715 = (state_15763[(7)]);
var inst_15714 = (state_15763[(8)]);
var inst_15753 = (state_15763[(2)]);
var inst_15754 = (inst_15714 * (2));
var inst_15755 = (inst_15715 + (1));
var inst_15714__$1 = inst_15754;
var inst_15715__$1 = inst_15755;
var state_15763__$1 = (function (){var statearr_15767 = state_15763;
(statearr_15767[(7)] = inst_15715__$1);

(statearr_15767[(8)] = inst_15714__$1);

(statearr_15767[(9)] = inst_15753);

return statearr_15767;
})();
var statearr_15768_15803 = state_15763__$1;
(statearr_15768_15803[(2)] = null);

(statearr_15768_15803[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (1))){
var inst_15714 = milia.utils.retry.initial_polling_interval;
var inst_15715 = (0);
var state_15763__$1 = (function (){var statearr_15769 = state_15763;
(statearr_15769[(7)] = inst_15715);

(statearr_15769[(8)] = inst_15714);

return statearr_15769;
})();
var statearr_15770_15804 = state_15763__$1;
(statearr_15770_15804[(2)] = null);

(statearr_15770_15804[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (4))){
var inst_15721 = (state_15763[(10)]);
var inst_15721__$1 = (state_15763[(2)]);
var inst_15723 = (inst_15721__$1 == null);
var inst_15724 = cljs.core.not(inst_15723);
var state_15763__$1 = (function (){var statearr_15771 = state_15763;
(statearr_15771[(10)] = inst_15721__$1);

return statearr_15771;
})();
if(inst_15724){
var statearr_15772_15805 = state_15763__$1;
(statearr_15772_15805[(1)] = (5));

} else {
var statearr_15773_15806 = state_15763__$1;
(statearr_15773_15806[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (15))){
var inst_15744 = (state_15763[(11)]);
var state_15763__$1 = state_15763;
var statearr_15774_15807 = state_15763__$1;
(statearr_15774_15807[(2)] = inst_15744);

(statearr_15774_15807[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (13))){
var inst_15742 = (state_15763[(12)]);
var inst_15744 = (state_15763[(11)]);
var inst_15742__$1 = (state_15763[(2)]);
var inst_15743 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15742__$1,cljs.core.cst$kw$status);
var inst_15744__$1 = chimera.seq.in_QMARK_(retry_for_statuses,inst_15743);
var state_15763__$1 = (function (){var statearr_15775 = state_15763;
(statearr_15775[(12)] = inst_15742__$1);

(statearr_15775[(11)] = inst_15744__$1);

return statearr_15775;
})();
if(cljs.core.truth_(inst_15744__$1)){
var statearr_15776_15808 = state_15763__$1;
(statearr_15776_15808[(1)] = (14));

} else {
var statearr_15777_15809 = state_15763__$1;
(statearr_15777_15809[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (6))){
var state_15763__$1 = state_15763;
var statearr_15778_15810 = state_15763__$1;
(statearr_15778_15810[(2)] = false);

(statearr_15778_15810[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (17))){
var inst_15714 = (state_15763[(8)]);
var inst_15751 = cljs.core.async.timeout(inst_15714);
var state_15763__$1 = state_15763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15763__$1,(20),inst_15751);
} else {
if((state_val_15764 === (3))){
var inst_15761 = (state_15763[(2)]);
var state_15763__$1 = state_15763;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15763__$1,inst_15761);
} else {
if((state_val_15764 === (12))){
var inst_15721 = (state_15763[(10)]);
var state_15763__$1 = state_15763;
var statearr_15779_15811 = state_15763__$1;
(statearr_15779_15811[(2)] = inst_15721);

(statearr_15779_15811[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (2))){
var inst_15718 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,options,milia.utils.retry.retry_keys);
var inst_15719 = chimera.seq.mapply.cljs$core$IFn$_invoke$arity$variadic(milia.api.http.parse_http,cljs.core.array_seq([method,url,inst_15718], 0));
var state_15763__$1 = state_15763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15763__$1,(4),inst_15719);
} else {
if((state_val_15764 === (19))){
var inst_15759 = (state_15763[(2)]);
var state_15763__$1 = state_15763;
var statearr_15780_15812 = state_15763__$1;
(statearr_15780_15812[(2)] = inst_15759);

(statearr_15780_15812[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (11))){
var inst_15721 = (state_15763[(10)]);
var inst_15739 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_15721);
var state_15763__$1 = state_15763;
var statearr_15781_15813 = state_15763__$1;
(statearr_15781_15813[(2)] = inst_15739);

(statearr_15781_15813[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (9))){
var state_15763__$1 = state_15763;
var statearr_15782_15814 = state_15763__$1;
(statearr_15782_15814[(2)] = false);

(statearr_15782_15814[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (5))){
var inst_15721 = (state_15763[(10)]);
var inst_15726 = inst_15721.cljs$lang$protocol_mask$partition0$;
var inst_15727 = (inst_15726 & (64));
var inst_15728 = inst_15721.cljs$core$ISeq$;
var inst_15729 = (cljs.core.PROTOCOL_SENTINEL === inst_15728);
var inst_15730 = (inst_15727) || (inst_15729);
var state_15763__$1 = state_15763;
if(cljs.core.truth_(inst_15730)){
var statearr_15783_15815 = state_15763__$1;
(statearr_15783_15815[(1)] = (8));

} else {
var statearr_15784_15816 = state_15763__$1;
(statearr_15784_15816[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (14))){
var inst_15715 = (state_15763[(7)]);
var inst_15746 = (inst_15715 < max_retries);
var state_15763__$1 = state_15763;
var statearr_15785_15817 = state_15763__$1;
(statearr_15785_15817[(2)] = inst_15746);

(statearr_15785_15817[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (16))){
var inst_15749 = (state_15763[(2)]);
var state_15763__$1 = state_15763;
if(cljs.core.truth_(inst_15749)){
var statearr_15786_15818 = state_15763__$1;
(statearr_15786_15818[(1)] = (17));

} else {
var statearr_15787_15819 = state_15763__$1;
(statearr_15787_15819[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (10))){
var inst_15734 = (state_15763[(2)]);
var state_15763__$1 = state_15763;
var statearr_15788_15820 = state_15763__$1;
(statearr_15788_15820[(2)] = inst_15734);

(statearr_15788_15820[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (18))){
var inst_15742 = (state_15763[(12)]);
var state_15763__$1 = state_15763;
var statearr_15789_15821 = state_15763__$1;
(statearr_15789_15821[(2)] = inst_15742);

(statearr_15789_15821[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15764 === (8))){
var state_15763__$1 = state_15763;
var statearr_15790_15822 = state_15763__$1;
(statearr_15790_15822[(2)] = true);

(statearr_15790_15822[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__12537__auto__,map__15712,map__15712__$1,options,max_retries,retry_for_statuses))
;
return ((function (switch__12460__auto__,c__12537__auto__,map__15712,map__15712__$1,options,max_retries,retry_for_statuses){
return (function() {
var milia$utils$retry$state_machine__12461__auto__ = null;
var milia$utils$retry$state_machine__12461__auto____0 = (function (){
var statearr_15794 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15794[(0)] = milia$utils$retry$state_machine__12461__auto__);

(statearr_15794[(1)] = (1));

return statearr_15794;
});
var milia$utils$retry$state_machine__12461__auto____1 = (function (state_15763){
while(true){
var ret_value__12462__auto__ = (function (){try{while(true){
var result__12463__auto__ = switch__12460__auto__(state_15763);
if(cljs.core.keyword_identical_QMARK_(result__12463__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__12463__auto__;
}
break;
}
}catch (e15795){if((e15795 instanceof Object)){
var ex__12464__auto__ = e15795;
var statearr_15796_15823 = state_15763;
(statearr_15796_15823[(5)] = ex__12464__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15763);

return cljs.core.cst$kw$recur;
} else {
throw e15795;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__12462__auto__,cljs.core.cst$kw$recur)){
var G__15824 = state_15763;
state_15763 = G__15824;
continue;
} else {
return ret_value__12462__auto__;
}
break;
}
});
milia$utils$retry$state_machine__12461__auto__ = function(state_15763){
switch(arguments.length){
case 0:
return milia$utils$retry$state_machine__12461__auto____0.call(this);
case 1:
return milia$utils$retry$state_machine__12461__auto____1.call(this,state_15763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
milia$utils$retry$state_machine__12461__auto__.cljs$core$IFn$_invoke$arity$0 = milia$utils$retry$state_machine__12461__auto____0;
milia$utils$retry$state_machine__12461__auto__.cljs$core$IFn$_invoke$arity$1 = milia$utils$retry$state_machine__12461__auto____1;
return milia$utils$retry$state_machine__12461__auto__;
})()
;})(switch__12460__auto__,c__12537__auto__,map__15712,map__15712__$1,options,max_retries,retry_for_statuses))
})();
var state__12539__auto__ = (function (){var statearr_15797 = (f__12538__auto__.cljs$core$IFn$_invoke$arity$0 ? f__12538__auto__.cljs$core$IFn$_invoke$arity$0() : f__12538__auto__.call(null));
(statearr_15797[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__12537__auto__);

return statearr_15797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__12539__auto__);
});})(c__12537__auto__,map__15712,map__15712__$1,options,max_retries,retry_for_statuses))
);

return c__12537__auto__;
});

milia.utils.retry.retry_parse_http.cljs$lang$maxFixedArity = (2);

milia.utils.retry.retry_parse_http.cljs$lang$applyTo = (function (seq15708){
var G__15709 = cljs.core.first(seq15708);
var seq15708__$1 = cljs.core.next(seq15708);
var G__15710 = cljs.core.first(seq15708__$1);
var seq15708__$2 = cljs.core.next(seq15708__$1);
return milia.utils.retry.retry_parse_http.cljs$core$IFn$_invoke$arity$variadic(G__15709,G__15710,seq15708__$2);
});

