// Compiled by ClojureScript 1.7.28 {:static-fns true, :optimize-constants true}
goog.provide('milia.api.project');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('milia.api.http');
goog.require('milia.utils.remote');
goog.require('milia.utils.url');
/**
 * Parse and add the projects ID.
 */
milia.api.project.add_id = (function milia$api$project$add_id(project_data){
if(typeof project_data === 'string'){
return null;
} else {
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([project_data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$id,milia.utils.url.last_url_param(cljs.core.constant$keyword$url.cljs$core$IFn$_invoke$arity$1(project_data))], null)], 0));
}
});
/**
 * Get the forms for this account and owner of the user.
 */
milia.api.project.get_forms = (function milia$api$project$get_forms(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"forms"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
milia.api.project.get_project = (function milia$api$project$get_project(){
var args__8965__auto__ = [];
var len__8958__auto___14938 = arguments.length;
var i__8959__auto___14939 = (0);
while(true){
if((i__8959__auto___14939 < len__8958__auto___14938)){
args__8965__auto__.push((arguments[i__8959__auto___14939]));

var G__14940 = (i__8959__auto___14939 + (1));
i__8959__auto___14939 = G__14940;
continue;
} else {
}
break;
}

var argseq__8966__auto__ = ((((1) < args__8965__auto__.length))?(new cljs.core.IndexedSeq(args__8965__auto__.slice((1)),(0))):null);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8966__auto__);
});

milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__14935){
var map__14936 = p__14935;
var map__14936__$1 = ((((!((map__14936 == null)))?((((map__14936.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14936.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14936):map__14936);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14936__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
var data = milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
return data;
});

milia.api.project.get_project.cljs$lang$maxFixedArity = (1);

milia.api.project.get_project.cljs$lang$applyTo = (function (seq14933){
var G__14934 = cljs.core.first(seq14933);
var seq14933__$1 = cljs.core.next(seq14933);
return milia.api.project.get_project.cljs$core$IFn$_invoke$arity$variadic(G__14934,seq14933__$1);
});
/**
 * Return all project for this account and owner or the user.
 */
milia.api.project.all = (function milia$api$project$all(){
var args14943 = [];
var len__8958__auto___14951 = arguments.length;
var i__8959__auto___14952 = (0);
while(true){
if((i__8959__auto___14952 < len__8958__auto___14951)){
args14943.push((arguments[i__8959__auto___14952]));

var G__14953 = (i__8959__auto___14952 + (1));
i__8959__auto___14952 = G__14953;
continue;
} else {
}
break;
}

var G__14947 = args14943.length;
switch (G__14947) {
case 0:
return milia.api.project.all.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__8977__auto__ = (new cljs.core.IndexedSeq(args14943.slice((1)),(0)));
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8977__auto__);

}
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$0 = (function (){
return milia.api.project.all(null);
});

milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic = (function (owner,p__14948){
var map__14949 = p__14948;
var map__14949__$1 = ((((!((map__14949 == null)))?((((map__14949.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14949.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14949):map__14949);
var no_cache_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14949__$1,cljs.core.constant$keyword$no_DASH_cache_QMARK_);
var logged_in_username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14949__$1,cljs.core.constant$keyword$logged_DASH_in_DASH_username);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
var options = ((function (url,map__14949,map__14949__$1,no_cache_QMARK_,logged_in_username){
return (function (p1__14942_SHARP_){
if(cljs.core.truth_(logged_in_username)){
return cljs.core.assoc_in(p1__14942_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params,cljs.core.constant$keyword$u], null),logged_in_username);
} else {
return p1__14942_SHARP_;
}
});})(url,map__14949,map__14949__$1,no_cache_QMARK_,logged_in_username))
.call(null,((function (url,map__14949,map__14949__$1,no_cache_QMARK_,logged_in_username){
return (function (p1__14941_SHARP_){
if(cljs.core.truth_(owner)){
return cljs.core.assoc_in(p1__14941_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.constant$keyword$query_DASH_params,cljs.core.constant$keyword$owner], null),owner);
} else {
return p1__14941_SHARP_;
}
});})(url,map__14949,map__14949__$1,no_cache_QMARK_,logged_in_username))
.call(null,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$query_DASH_params,null], null)));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,options,cljs.core.constant$keyword$no_DASH_cache_QMARK_,no_cache_QMARK_], 0));
});

milia.api.project.all.cljs$lang$applyTo = (function (seq14944){
var G__14945 = cljs.core.first(seq14944);
var seq14944__$1 = cljs.core.next(seq14944);
return milia.api.project.all.cljs$core$IFn$_invoke$arity$variadic(G__14945,seq14944__$1);
});

milia.api.project.all.cljs$lang$maxFixedArity = (1);
/**
 * Create a project for this account and owner or the user.
 */
milia.api.project.create = (function milia$api$project$create(data,owner){
var owner_url = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$owner,milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",owner], 0))], null);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
var form_params = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([owner_url,data], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$json_DASH_params,form_params], null)], 0));
});
/**
 * Update project metadata
 */
milia.api.project.update = (function milia$api$project$update(project_id,data){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$patch,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,data,cljs.core.constant$keyword$content_DASH_type,cljs.core.constant$keyword$json], null)], 0));
});
/**
 * Share project with specific user or remove specific user from project
 */
milia.api.project.share = (function milia$api$project$share(){
var args14955 = [];
var len__8958__auto___14958 = arguments.length;
var i__8959__auto___14959 = (0);
while(true){
if((i__8959__auto___14959 < len__8958__auto___14958)){
args14955.push((arguments[i__8959__auto___14959]));

var G__14960 = (i__8959__auto___14959 + (1));
i__8959__auto___14959 = G__14960;
continue;
} else {
}
break;
}

var G__14957 = args14955.length;
switch (G__14957) {
case 3:
return milia.api.project.share.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return milia.api.project.share.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args14955.length)].join('')));

}
});

milia.api.project.share.cljs$core$IFn$_invoke$arity$3 = (function (project_id,username,role){
return milia.api.project.share.cljs$core$IFn$_invoke$arity$4(project_id,username,role,false);
});

milia.api.project.share.cljs$core$IFn$_invoke$arity$4 = (function (project_id,username,role,remove_QMARK_){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",project_id,"share"], 0));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$username,username,cljs.core.constant$keyword$role,role], null);
var form_params = (cljs.core.truth_(remove_QMARK_)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([data,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$remove,"True"], null)], 0)):data);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$put,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$form_DASH_params,form_params], null)], 0));
});

milia.api.project.share.cljs$lang$maxFixedArity = 4;
/**
 * Add tags to a project.
 */
milia.api.project.add_tags = (function milia$api$project$add_tags(id,tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"labels"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null),cljs.core.constant$keyword$content_DASH_type,cljs.core.constant$keyword$json], null)], 0));
});
/**
 * Get projects with given tags.
 */
milia.api.project.with_tag = (function milia$api$project$with_tag(tags){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$get,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$query_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$tags,clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",tags)], null)], null)], 0));
});
/**
 * Add star to project for this user.
 */
milia.api.project.add_star = (function milia$api$project$add_star(){
var args__8965__auto__ = [];
var len__8958__auto___14967 = arguments.length;
var i__8959__auto___14968 = (0);
while(true){
if((i__8959__auto___14968 < len__8958__auto___14967)){
args__8965__auto__.push((arguments[i__8959__auto___14968]));

var G__14969 = (i__8959__auto___14968 + (1));
i__8959__auto___14968 = G__14969;
continue;
} else {
}
break;
}

var argseq__8966__auto__ = ((((1) < args__8965__auto__.length))?(new cljs.core.IndexedSeq(args__8965__auto__.slice((1)),(0))):null);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8966__auto__);
});

milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__14964){
var map__14965 = p__14964;
var map__14965__$1 = ((((!((map__14965 == null)))?((((map__14965.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14965.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14965):map__14965);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14965__$1,cljs.core.constant$keyword$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$post,url,cljs.core.array_seq([cljs.core.constant$keyword$callback,callback], 0));
});

milia.api.project.add_star.cljs$lang$maxFixedArity = (1);

milia.api.project.add_star.cljs$lang$applyTo = (function (seq14962){
var G__14963 = cljs.core.first(seq14962);
var seq14962__$1 = cljs.core.next(seq14962);
return milia.api.project.add_star.cljs$core$IFn$_invoke$arity$variadic(G__14963,seq14962__$1);
});
/**
 * Remove star from project for this user.
 */
milia.api.project.remove_star = (function milia$api$project$remove_star(){
var args__8965__auto__ = [];
var len__8958__auto___14975 = arguments.length;
var i__8959__auto___14976 = (0);
while(true){
if((i__8959__auto___14976 < len__8958__auto___14975)){
args__8965__auto__.push((arguments[i__8959__auto___14976]));

var G__14977 = (i__8959__auto___14976 + (1));
i__8959__auto___14976 = G__14977;
continue;
} else {
}
break;
}

var argseq__8966__auto__ = ((((1) < args__8965__auto__.length))?(new cljs.core.IndexedSeq(args__8965__auto__.slice((1)),(0))):null);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8966__auto__);
});

milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic = (function (id,p__14972){
var map__14973 = p__14972;
var map__14973__$1 = ((((!((map__14973 == null)))?((((map__14973.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14973.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__14973):map__14973);
var callback = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14973__$1,cljs.core.constant$keyword$callback);
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$delete,url,cljs.core.array_seq([cljs.core.constant$keyword$callback,callback], 0));
});

milia.api.project.remove_star.cljs$lang$maxFixedArity = (1);

milia.api.project.remove_star.cljs$lang$applyTo = (function (seq14970){
var G__14971 = cljs.core.first(seq14970);
var seq14970__$1 = cljs.core.next(seq14970);
return milia.api.project.remove_star.cljs$core$IFn$_invoke$arity$variadic(G__14971,seq14970__$1);
});
/**
 * Toggle between starred and unstarred for a user's project
 */
milia.api.project.toggle_star = (function milia$api$project$toggle_star(id,star_QMARK_,callback){
return (cljs.core.truth_(star_QMARK_)?milia.api.project.add_star:milia.api.project.remove_star).call(null,id,cljs.core.constant$keyword$callback,callback);
});
/**
 * Get projects this user has starred.
 */
milia.api.project.get_starred = (function milia$api$project$get_starred(username){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["user",username,"starred"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Get user that starred this project.
 */
milia.api.project.starred_by = (function milia$api$project$starred_by(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id,"star"], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$get,url);
});
/**
 * Delete a project
 */
milia.api.project.delete$ = (function milia$api$project$delete(id){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
return milia.api.http.parse_http(cljs.core.constant$keyword$delete,url);
});
/**
 * Set new project owner
 */
milia.api.project.transfer_owner = (function milia$api$project$transfer_owner(id,new_owner){
var url = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["projects",id], 0));
var new_owner__$1 = milia.utils.remote.make_url.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["users",new_owner], 0));
var form_params = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$owner,new_owner__$1], null);
return milia.api.http.parse_http.cljs$core$IFn$_invoke$arity$variadic(cljs.core.constant$keyword$patch,url,cljs.core.array_seq([cljs.core.constant$keyword$http_DASH_options,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.constant$keyword$form_DASH_params,form_params,cljs.core.constant$keyword$content_DASH_type,cljs.core.constant$keyword$json], null)], 0));
});
/**
 * Update the project public setting.
 */
milia.api.project.update_public = (function milia$api$project$update_public(projectid,public$){
return milia.api.project.update(projectid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.constant$keyword$public,public$], null));
});
